/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.Path;
import jmri.jmrit.logix.BlockOrder;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.MergePrompt;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.OPath;
import jmri.jmrit.logix.Portal;
import jmri.jmrit.logix.RouteFinder;
import jmri.jmrit.logix.SpeedUtil;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.logix.WarrantManager;
import jmri.jmrit.logix.WarrantPreferences;
import jmri.jmrit.picker.PickListModel;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.RosterSpeedProfile;
import jmri.jmrit.roster.swing.RosterEntryListCellRenderer;
import jmri.jmrit.symbolicprog.ValueEditor;
import jmri.util.DnDStringImportHandler;
import jmri.util.JmriJFrame;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class WarrantRoute
extends JmriJFrame
implements ActionListener,
PropertyChangeListener {
    protected RouteLocation _origin = new RouteLocation(Location.ORIGIN);
    protected RouteLocation _destination = new RouteLocation(Location.DEST);
    protected RouteLocation _via = new RouteLocation(Location.VIA);
    protected RouteLocation _avoid = new RouteLocation(Location.AVOID);
    protected RouteLocation _focusedField;
    protected SpeedUtil _speedUtil;
    protected Display _displayPref;
    protected Display _units;
    protected float _scale = 87.1f;
    static int STRUT_SIZE = 10;
    private int _depth = 20;
    static String PAD = "               ";
    private JDialog _pickRouteDialog;
    private final RouteTableModel _routeModel;
    protected ArrayList<BlockOrder> _orders;
    private JFrame _debugFrame;
    private RouteFinder _routeFinder;
    private final JTextField _searchDepth = new JTextField(5);
    private JButton _calculateButton = new JButton(Bundle.getMessage("Calculate"));
    private JButton _stopButton;
    private final JComboBox<String> _rosterBox = new JComboBox();
    private final AddressTextField _dccNumBox = new AddressTextField();
    private final JTextField _trainNameBox = new JTextField(6);
    private final JButton _viewProfile = new JButton(Bundle.getMessage("ViewProfile"));
    private JmriJFrame _spTable = null;
    private JmriJFrame _pickListFrame;
    private Warrant _tempWarrant;
    private static final Logger log = LoggerFactory.getLogger(WarrantRoute.class);

    protected WarrantRoute() {
        super(false, true);
        if (log.isDebugEnabled()) {
            log.debug("newInstance");
        }
        this._searchDepth.setText(Integer.toString(this._depth));
        this._routeModel = new RouteTableModel();
        this._speedUtil = new SpeedUtil();
        int interpretation = 4;
        WarrantPreferences wp = WarrantPreferences.getDefault();
        if (wp != null) {
            interpretation = WarrantPreferences.getDefault().getInterpretation();
            this._scale = wp.getLayoutScale();
        }
        if (interpretation == 3) {
            this._displayPref = Display.MPH;
            this._units = Display.IN;
        } else if (interpretation == 4) {
            this._displayPref = Display.KPH;
            this._units = Display.CM;
        } else {
            this._displayPref = Display.INPS;
            this._units = Display.IN;
        }
        this.setupRoster();
    }

    protected abstract void selectedRoute(ArrayList<BlockOrder> var1);

    protected abstract void maxThrottleEventAction();

    @Override
    public abstract void propertyChange(PropertyChangeEvent var1);

    protected void setSpeedUtil(SpeedUtil sp) {
        this._speedUtil = sp;
    }

    private int getDepth() {
        try {
            int i = Integer.parseInt(this._searchDepth.getText());
            if (i > 2) {
                this._depth = i;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return this._depth;
    }

    protected JPanel searchDepthPanel(boolean vertical) {
        this._searchDepth.setText(Integer.toString(this._depth));
        JPanel p = new JPanel();
        p.add(Box.createHorizontalGlue());
        p.add(WarrantRoute.makeTextBoxPanel(vertical, this._searchDepth, "SearchDepth", "ToolTipSearchDepth"));
        this._searchDepth.setColumns(5);
        p.add(Box.createHorizontalGlue());
        return p;
    }

    protected JPanel calculatePanel(boolean vertical) {
        this._calculateButton.setMaximumSize(this._calculateButton.getPreferredSize());
        this._calculateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WarrantRoute.this.clearTempWarrant();
                WarrantRoute.this.calculate();
            }
        });
        this._stopButton = new JButton(Bundle.getMessage("Stop"));
        this._stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WarrantRoute.this.stopRouteFinder();
            }
        });
        JPanel panel = new JPanel();
        panel.add(WarrantRoute.makeTextBoxPanel(vertical, this._calculateButton, "CalculateRoute", null));
        panel.add(WarrantRoute.makeTextBoxPanel(vertical, this._stopButton, "StopSearch", null));
        return panel;
    }

    public JPanel makePickListPanel() {
        JButton button = new JButton(Bundle.getMessage("MenuBlockPicker"));
        button.setMaximumSize(this._calculateButton.getPreferredSize());
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WarrantRoute.this._pickListFrame != null) {
                    WarrantRoute.this._pickListFrame.dispose();
                }
                WarrantRoute.this._pickListFrame = new JmriJFrame();
                PickListModel<OBlock> model = PickListModel.oBlockPickModelInstance();
                WarrantRoute.this._pickListFrame.add(new JScrollPane(model.makePickTable()));
                WarrantRoute.this._pickListFrame.pack();
                WarrantRoute.this._pickListFrame.setVisible(true);
            }
        });
        JPanel p = new JPanel();
        p.add(button);
        return p;
    }

    protected JPanel makeTrainIdPanel(JPanel comp) {
        JPanel trainPanel = new JPanel();
        trainPanel.setLayout(new BoxLayout(trainPanel, 2));
        trainPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(WarrantRoute.makeTextBoxPanel(false, this._trainNameBox, "TrainName", "noTrainName"));
        panel.add(WarrantRoute.makeTextBoxPanel(false, this._rosterBox, "Roster", null));
        panel.add(Box.createVerticalStrut(2));
        panel.add(WarrantRoute.makeTextBoxPanel(false, this._dccNumBox, "DccAddress", null));
        this._dccNumBox.addActionListener(e -> this.checkAddress());
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 2));
        p.add(this._viewProfile);
        this._viewProfile.addActionListener(e -> this.showProfile());
        panel.add(p);
        if (comp != null) {
            panel.add(comp);
        }
        trainPanel.add(panel);
        trainPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
        return trainPanel;
    }

    private void setupRoster() {
        List<RosterEntry> list = Roster.getDefault().matchingList(null, null, null, null, null, null, null);
        this._rosterBox.setRenderer(new RosterEntryListCellRenderer());
        this._rosterBox.addItem(" ");
        this._rosterBox.addItem(Bundle.getMessage("noSuchAddress"));
        int i = 0;
        while (i < list.size()) {
            RosterEntry r = list.get(i);
            this._rosterBox.addItem(r.titleString());
            ++i;
        }
        this._rosterBox.setMaximumSize(this._rosterBox.getPreferredSize());
        this._rosterBox.addActionListener(e -> this.checkAddress());
    }

    private void showProfile() {
        JPanel viewPanel;
        this.closeProfileTable();
        String id = this._speedUtil.getRosterId();
        if (id == null || id.isEmpty()) {
            return;
        }
        if (Roster.getDefault().getEntryForId(id) == null) {
            DccLocoAddress dccAddr = this._speedUtil.getDccAddress();
            String rosterId = JOptionPane.showInputDialog(this, Bundle.getMessage("makeRosterEntry", this._speedUtil.getAddress()), Bundle.getMessage("QuestionTitle"), 3);
            if (log.isDebugEnabled()) {
                log.debug("Create roster entry {}", (Object)rosterId);
            }
            if (rosterId != null && !rosterId.isEmpty()) {
                RosterEntry rosterEntry = new RosterEntry();
                Roster.getDefault().addEntry(rosterEntry);
                rosterEntry.setId(rosterId);
                rosterEntry.setDccAddress(String.valueOf(dccAddr.getNumber()));
                rosterEntry.setProtocol(dccAddr.getProtocol());
                rosterEntry.ensureFilenameExists();
                WarrantManager mgr = InstanceManager.getDefault(WarrantManager.class);
                RosterSpeedProfile mergeProfile = this._speedUtil.getMergeProfile();
                mgr.setMergeProfile(rosterId, mergeProfile);
                mgr.getMergeProfiles().remove(id);
                this._speedUtil.setRosterId(rosterId);
            }
        }
        if ((viewPanel = this.makeViewPanel(id)) == null) {
            if (id.charAt(0) != '$' || id.charAt(id.length() - 1) != '$') {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("NoSpeedProfile", id), Bundle.getMessage("WarningTitle"), 2);
            }
            return;
        }
        this._spTable = new JmriJFrame(false, true);
        JPanel framePanel = new JPanel();
        framePanel.setLayout(new BoxLayout(framePanel, 3));
        framePanel.add(Box.createGlue());
        framePanel.add(viewPanel);
        this._spTable.getContentPane().add(framePanel);
        this._spTable.pack();
        this._spTable.setVisible(true);
    }

    JPanel makeViewPanel(String id) {
        RosterSpeedProfile speedProfile = this._speedUtil.getMergeProfile();
        RosterEntry re = Roster.getDefault().getEntryForId(id);
        RosterSpeedProfile rosterSpeedProfile = re != null ? re.getSpeedProfile() : null;
        if (!(speedProfile != null && speedProfile.getProfileSize() != 0 || rosterSpeedProfile != null && rosterSpeedProfile.getProfileSize() != 0)) {
            this._viewProfile.setEnabled(false);
            return null;
        }
        this._viewProfile.setEnabled(true);
        JPanel viewPanel = new JPanel();
        viewPanel.setLayout(new BoxLayout(viewPanel, 3));
        viewPanel.add(Box.createGlue());
        JPanel panel = new JPanel();
        panel.add(MergePrompt.makeEditInfoPanel(id));
        viewPanel.add(panel);
        JPanel spPanel = new JPanel();
        spPanel.setLayout(new BoxLayout(spPanel, 2));
        spPanel.add(Box.createGlue());
        if (rosterSpeedProfile != null) {
            Map<Integer, Boolean> anomilies = MergePrompt.validateSpeedProfile(rosterSpeedProfile);
            spPanel.add(MergePrompt.makeSpeedProfilePanel("rosterSpeedProfile", rosterSpeedProfile, false, anomilies));
            spPanel.add(Box.createGlue());
        }
        if (speedProfile != null) {
            Map<Integer, Boolean> anomaly = MergePrompt.validateSpeedProfile(speedProfile);
            spPanel.add(MergePrompt.makeSpeedProfilePanel("mergedSpeedProfile", speedProfile, true, anomaly));
            spPanel.add(Box.createGlue());
        }
        viewPanel.add(spPanel);
        return viewPanel;
    }

    protected void closeProfileTable() {
        if (this._spTable != null) {
            this._spTable.dispose();
            this._spTable = null;
        }
    }

    protected String setTrainInfo(String name) {
        if (log.isDebugEnabled()) {
            log.debug("setTrainInfo for: {}", (Object)name);
        }
        this.setTrainName(name);
        this._dccNumBox.setText(this._speedUtil.getAddress());
        this.setRosterBox();
        if (name == null) {
            RosterEntry re = this._speedUtil.getRosterEntry();
            if (re != null) {
                this.setTrainName(re.getRoadNumber());
                this.setRosterBox();
            } else {
                this.setTrainName(this._speedUtil.getAddress());
            }
        }
        return null;
    }

    private void setRosterBox() {
        String id = this._speedUtil.getRosterId();
        if (id != null && id.equals(this._rosterBox.getSelectedItem())) {
            return;
        }
        if (id != null && id.charAt(0) != '$' && id.charAt(id.length() - 1) != '$') {
            this._rosterBox.setSelectedItem(id);
        } else {
            this._rosterBox.setSelectedItem(Bundle.getMessage("noSuchAddress"));
        }
    }

    protected void setTrainName(String name) {
        this._trainNameBox.setText(name);
    }

    protected String getTrainName() {
        String trainName = this._trainNameBox.getText();
        if (trainName == null || trainName.length() == 0) {
            trainName = this._dccNumBox.getText();
        }
        return trainName;
    }

    private void checkAddress() {
        String msg = this.setAddress();
        if (msg != null) {
            JOptionPane.showMessageDialog(this, msg, Bundle.getMessage("WarningTitle"), 2);
        }
    }

    protected String setAddress() {
        String msg = null;
        String suAddr = this._speedUtil.getAddress();
        String addrText = this._dccNumBox.getText();
        String suId = this._speedUtil.getRosterId();
        boolean textChange = false;
        if (!addrText.equals(suAddr) || suId == null) {
            textChange = true;
            if (!this._speedUtil.setAddress(this._dccNumBox.getText())) {
                msg = Bundle.getMessage("BadDccAddress", this._dccNumBox.getText());
            } else {
                suAddr = this._speedUtil.getAddress();
                this._dccNumBox.setText(suAddr);
                suId = this._speedUtil.getRosterId();
                this.maxThrottleEventAction();
                if (suId != null && (suId.charAt(0) != '$' || suId.charAt(suId.length() - 1) != '$')) {
                    this._rosterBox.setSelectedItem(suId);
                } else {
                    this._rosterBox.setSelectedItem(Bundle.getMessage("noSuchAddress"));
                    return null;
                }
            }
        }
        String id = (String)this._rosterBox.getSelectedItem();
        RosterEntry re = Roster.getDefault().getEntryForId(id);
        boolean isRoster = re != null;
        suId = this._speedUtil.getRosterId();
        if (suId != null && suId.charAt(0) == '$' && suId.charAt(suId.length() - 1) == '$') {
            isRoster = true;
        }
        if (!textChange && !isRoster) {
            this._dccNumBox.setText(null);
            return null;
        }
        if (re != null) {
            if (!re.getDccLocoAddress().equals(this._speedUtil.getDccAddress())) {
                this._speedUtil.setRosterId(id);
            }
            this._dccNumBox.setText(re.getDccLocoAddress().toString());
            this.maxThrottleEventAction();
            msg = null;
        } else if (msg == null) {
            this._rosterBox.setSelectedItem(Bundle.getMessage("noSuchAddress"));
        }
        return msg;
    }

    protected String getAddress() {
        return this._dccNumBox.getText();
    }

    protected String checkLocoAddress() {
        if (this._speedUtil.getDccAddress() == null) {
            return Bundle.getMessage("BadDccAddress", this._dccNumBox.getText());
        }
        return null;
    }

    protected void calculate() {
        String msg = this.findRoute();
        if (msg != null) {
            JOptionPane.showMessageDialog(this, msg, Bundle.getMessage("WarningTitle"), 2);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (log.isTraceEnabled()) {
            log.trace("actionPerformed: source {} id= {}, ActionCommand= ", new Object[]{((Component)obj).getName(), e.getID(), e.getActionCommand()});
        }
        this.doAction(obj);
    }

    void doAction(Object obj) {
        if (obj instanceof JTextField) {
            JTextField box = (JTextField)obj;
            if (!(this._origin.checkBlockBox(box) || this._destination.checkBlockBox(box) || this._via.checkBlockBox(box))) {
                this._avoid.checkBlockBox(box);
            }
        } else {
            JComboBox box = (JComboBox)obj;
            if (!(this._origin.checkPathBox(box) || this._destination.checkPathBox(box) || this._via.checkPathBox(box) || this._avoid.checkPathBox(box))) {
                if (this._origin.checkPortalBox(box)) {
                    this._origin.setOrderExitPortal();
                }
                if (this._destination.checkPortalBox(box)) {
                    this._destination.setOrderEntryPortal();
                }
            }
        }
    }

    protected JPanel makeBlockPanels(boolean add) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        JPanel oPanel = this._origin.makePanel("OriginBlock", "OriginToolTip", "PathName", "ExitPortalName", this);
        panel.add(oPanel);
        oPanel = this._destination.makePanel("DestBlock", "DestToolTip", "PathName", "EntryPortalName", this);
        panel.add(oPanel);
        oPanel = this._via.makePanel("ViaBlock", "ViaToolTip", "PathName", null, this);
        JPanel aPanel = this._avoid.makePanel("AvoidBlock", "AvoidToolTip", "PathName", null, this);
        if (add) {
            JPanel pLeft = new JPanel();
            pLeft.setLayout(new BoxLayout(pLeft, 3));
            pLeft.add(oPanel);
            pLeft.add(aPanel);
            JPanel pRight = new JPanel();
            pRight.setLayout(new BoxLayout(pRight, 3));
            pRight.add(this.searchDepthPanel(true));
            pRight.add(this.makePickListPanel());
            pRight.add(this.calculatePanel(true));
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 2));
            p.add(pLeft);
            p.add(pRight);
            panel.add(p);
        } else {
            panel.add(oPanel);
            panel.add(aPanel);
        }
        return panel;
    }

    private JPanel makeLabelCombo(String title, JComboBox<String> box, String tooltip) {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.setToolTipText(Bundle.getMessage(tooltip));
        box.setToolTipText(Bundle.getMessage(tooltip));
        JLabel l = new JLabel(String.valueOf(PAD) + Bundle.getMessage(title) + PAD);
        p.add((Component)l, "North");
        l.setLabelFor(box);
        p.add(box, "Center");
        box.setBackground(Color.white);
        box.addActionListener(this);
        box.setAlignmentX(0.5f);
        return p;
    }

    private boolean setOriginBlock() {
        return this._origin.setBlock();
    }

    private boolean setDestinationBlock() {
        return this._destination.setBlock();
    }

    private boolean setViaBlock() {
        return this._via.setBlock();
    }

    private boolean setAvoidBlock() {
        return this._avoid.setBlock();
    }

    protected void mouseClickedOnBlock(OBlock block) {
        if (this._focusedField != null) {
            this._focusedField.setBlock(block);
        } else {
            this._origin.setBlock(block);
        }
    }

    private boolean pathsAreValid(OBlock block) {
        List<Path> list = block.getPaths();
        if (list.isEmpty()) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("NoPaths", block.getDisplayName()), Bundle.getMessage("WarningTitle"), 2);
            return false;
        }
        int i = 0;
        while (i < list.size()) {
            OPath path = (OPath)list.get(i);
            if (path.getFromPortal() == null && path.getToPortal() == null) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("PathNeedsPortal", path.getName(), block.getDisplayName()), Bundle.getMessage("WarningTitle"), 2);
                return false;
            }
            ++i;
        }
        return true;
    }

    private String findRoute() {
        BlockOrder order;
        String pathName;
        String msg = this.setOriginBlock() ? ((pathName = (order = this._origin.getOrder()).getPathName()) != null ? (order.getExitName() == null ? Bundle.getMessage("SetExitPortal", Bundle.getMessage("OriginBlock")) : WarrantRoute.pathIsValid(order.getBlock(), pathName)) : Bundle.getMessage("SetPath", Bundle.getMessage("OriginBlock"))) : Bundle.getMessage("SetEndPoint", Bundle.getMessage("OriginBlock"));
        if (msg == null) {
            msg = this.setDestinationBlock() ? ((pathName = (order = this._destination.getOrder()).getPathName()) != null ? (order.getEntryName() == null ? Bundle.getMessage("SetEntryPortal", Bundle.getMessage("DestBlock")) : WarrantRoute.pathIsValid(order.getBlock(), pathName)) : Bundle.getMessage("SetPath", Bundle.getMessage("DestBlock"))) : Bundle.getMessage("SetEndPoint", Bundle.getMessage("DestBlock"));
        }
        if (msg == null && this.setViaBlock() && (order = this._via.getOrder()) != null && order.getPathName() == null) {
            msg = Bundle.getMessage("SetPath", Bundle.getMessage("ViaBlock"));
        }
        if (msg == null && this.setAvoidBlock() && (order = this._avoid.getOrder()) != null && order.getPathName() == null) {
            msg = Bundle.getMessage("SetPath", Bundle.getMessage("AvoidBlock"));
        }
        if (msg == null) {
            if (log.isDebugEnabled()) {
                log.debug("Params OK. findRoute() is creating a RouteFinder");
            }
            this._routeFinder = new RouteFinder(this, this._origin.getOrder(), this._destination.getOrder(), this._via.getOrder(), this._avoid.getOrder(), this.getDepth());
            ThreadingUtil.newThread(this._routeFinder).start();
        }
        return msg;
    }

    protected void stopRouteFinder() {
        if (this._routeFinder != null) {
            this._routeFinder.quit();
            this._routeFinder = null;
        }
    }

    protected List<BlockOrder> getOrders() {
        return this._orders;
    }

    protected BlockOrder getViaBlockOrder() {
        return this._via.getOrder();
    }

    protected BlockOrder getAvoidBlockOrder() {
        return this._avoid.getOrder();
    }

    protected void clearTempWarrant() {
        if (this._tempWarrant != null) {
            this._tempWarrant.deAllocate();
        }
    }

    private void showTempWarrant(ArrayList<BlockOrder> orders) {
        String s = ("" + Math.random()).substring(4);
        if (this._tempWarrant == null) {
            this._tempWarrant = new Warrant("IW" + s + "TEMP", null);
            this._tempWarrant.setBlockOrders(orders);
        }
        this._tempWarrant.setRoute(true, orders);
    }

    protected void pickRoute(List<DefaultMutableTreeNode> destNodes, DefaultTreeModel routeTree) {
        if (destNodes.size() == 1) {
            this.showRoute(destNodes.get(0), routeTree);
            this.selectedRoute(this._orders);
            this.showTempWarrant(this._orders);
            return;
        }
        this._pickRouteDialog = new JDialog(this, Bundle.getMessage("DialogTitle"), false);
        this._pickRouteDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WarrantRoute.this.clearTempWarrant();
            }
        });
        this._tempWarrant = null;
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(5, 5));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JLabel(Bundle.getMessage("NumberRoutes1", destNodes.size())));
        panel.add(new JLabel(Bundle.getMessage("NumberRoutes2")));
        JPanel wrapper = new JPanel();
        wrapper.add(panel);
        mainPanel.add((Component)wrapper, "North");
        final ButtonGroup buttons = new ButtonGroup();
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        int i = 0;
        while (i < destNodes.size()) {
            JRadioButton button = new JRadioButton(Bundle.getMessage("RouteSize", i + 1, destNodes.get(i).getLevel() + 1));
            button.setActionCommand("" + i);
            button.addActionListener(e -> this.clearTempWarrant());
            buttons.add(button);
            panel.add(button);
            if (destNodes.size() == 1) {
                button.setSelected(true);
            }
            ++i;
        }
        JScrollPane scrollPane = new JScrollPane(panel);
        JViewport vp = scrollPane.getViewport();
        JRadioButton button = new JRadioButton(Bundle.getMessage("RouteSize", 0, 0));
        vp.setPreferredSize(new Dimension(button.getWidth(), this._depth * button.getHeight()));
        mainPanel.add((Component)scrollPane, "Center");
        JButton ok = new JButton(Bundle.getMessage("ButtonSelect"));
        ok.addActionListener(new ActionListener(){
            ButtonGroup buts;
            JDialog dialog;
            List<DefaultMutableTreeNode> dNodes;
            DefaultTreeModel tree;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.buts.getSelection() != null) {
                    WarrantRoute.this.clearTempWarrant();
                    int i = Integer.parseInt(buttons.getSelection().getActionCommand());
                    WarrantRoute.this.showRoute(this.dNodes.get(i), this.tree);
                    WarrantRoute.this.selectedRoute(WarrantRoute.this._orders);
                    WarrantRoute.this.showTempWarrant(WarrantRoute.this._orders);
                    this.dialog.dispose();
                } else {
                    WarrantRoute.this.showWarning(Bundle.getMessage("SelectRoute"));
                }
            }

            ActionListener init(ButtonGroup bg, JDialog d, List<DefaultMutableTreeNode> dn, DefaultTreeModel t) {
                this.buts = bg;
                this.dialog = d;
                this.dNodes = dn;
                this.tree = t;
                return this;
            }
        }.init(buttons, this._pickRouteDialog, destNodes, routeTree));
        ok.setMaximumSize(ok.getPreferredSize());
        JButton show = new JButton(Bundle.getMessage("ButtonReview"));
        show.addActionListener(new ActionListener(){
            ButtonGroup buts;
            List<DefaultMutableTreeNode> destinationNodes;
            DefaultTreeModel tree;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.buts.getSelection() != null) {
                    WarrantRoute.this.clearTempWarrant();
                    int i = Integer.parseInt(buttons.getSelection().getActionCommand());
                    WarrantRoute.this.showRoute(this.destinationNodes.get(i), this.tree);
                    WarrantRoute.this.showTempWarrant(WarrantRoute.this._orders);
                } else {
                    WarrantRoute.this.showWarning(Bundle.getMessage("SelectRoute"));
                }
            }

            ActionListener init(ButtonGroup bg, List<DefaultMutableTreeNode> dn, DefaultTreeModel t) {
                this.buts = bg;
                this.destinationNodes = dn;
                this.tree = t;
                return this;
            }
        }.init(buttons, destNodes, routeTree));
        show.setMaximumSize(show.getPreferredSize());
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createHorizontalGlue());
        panel.add(show);
        panel.add(Box.createHorizontalStrut(STRUT_SIZE));
        panel.add(ok);
        panel.add(Box.createHorizontalGlue());
        wrapper = new JPanel();
        wrapper.add(panel);
        mainPanel.add((Component)wrapper, "South");
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createHorizontalStrut(STRUT_SIZE));
        panel.add(this.makeRouteTablePanel());
        panel.add(Box.createHorizontalStrut(STRUT_SIZE));
        panel.add(mainPanel);
        panel.add(Box.createHorizontalStrut(STRUT_SIZE));
        this._pickRouteDialog.getContentPane().add(panel);
        this._pickRouteDialog.setLocation(this.getLocation().x - 20, this.getLocation().y + 150);
        this._pickRouteDialog.pack();
        this._pickRouteDialog.setVisible(true);
    }

    protected void showWarning(String msg) {
        JOptionPane.showMessageDialog(this, msg, Bundle.getMessage("WarningTitle"), 2);
    }

    private void showRoute(DefaultMutableTreeNode destNode, DefaultTreeModel tree) {
        TreeNode[] nodes = tree.getPathToRoot(destNode);
        this._orders = new ArrayList();
        TreeNode[] treeNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            TreeNode node = treeNodeArray[n2];
            this._orders.add((BlockOrder)((DefaultMutableTreeNode)node).getUserObject());
            ++n2;
        }
        this._routeModel.fireTableDataChanged();
        if (log.isDebugEnabled()) {
            log.debug("showRoute: Route has {} orders.", (Object)this._orders.size());
        }
    }

    protected JPanel makeRouteTablePanel() {
        JTable routeTable = new JTable(this._routeModel);
        routeTable.setDefaultEditor(JComboBox.class, new ValueEditor());
        int i = 0;
        while (i < this._routeModel.getColumnCount()) {
            int width = this._routeModel.getPreferredWidth(i);
            routeTable.getColumnModel().getColumn(i).setPreferredWidth(width);
            ++i;
        }
        JScrollPane tablePane = new JScrollPane(routeTable);
        Dimension dim = routeTable.getPreferredSize();
        dim.height = routeTable.getRowHeight() * 11;
        tablePane.getViewport().setPreferredSize(dim);
        JPanel routePanel = new JPanel();
        routePanel.setLayout(new BoxLayout(routePanel, 1));
        JLabel title = new JLabel(Bundle.getMessage("RouteTableTitle"));
        routePanel.add((Component)title, "North");
        routePanel.add(tablePane);
        routePanel.add(Box.createVerticalGlue());
        return routePanel;
    }

    protected void debugRoute(DefaultTreeModel tree, BlockOrder origin, BlockOrder dest) {
        if (1 == JOptionPane.showConfirmDialog(this, Bundle.getMessage("NoRoute", origin.getBlock().getDisplayName(), origin.getPathName(), origin.getExitName(), dest.getBlock().getDisplayName(), dest.getEntryName(), dest.getPathName(), this.getDepth()), Bundle.getMessage("WarningTitle"), 0, 2)) {
            return;
        }
        if (this._debugFrame != null) {
            this._debugFrame.dispose();
        }
        this._debugFrame = new JFrame(Bundle.getMessage("DebugRoute"));
        JTree dTree = new JTree(tree);
        dTree.setShowsRootHandles(true);
        dTree.setScrollsOnExpand(true);
        dTree.setExpandsSelectedPaths(true);
        JScrollPane treePane = new JScrollPane(dTree);
        treePane.getViewport().setPreferredSize(new Dimension(900, 300));
        this._debugFrame.getContentPane().add(treePane);
        this._debugFrame.setVisible(true);
        this._debugFrame.pack();
    }

    protected void clearRoute() {
        this._orders = new ArrayList();
        this.clearFrames();
        this.clearFields();
        this._focusedField = this._origin;
        this._routeModel.fireTableDataChanged();
    }

    private void clearFrames() {
        if (this._debugFrame != null) {
            this._debugFrame.dispose();
            this._debugFrame = null;
        }
        if (this._pickRouteDialog != null) {
            this._pickRouteDialog.dispose();
            this._pickRouteDialog = null;
        }
        this.closeProfileTable();
        if (this._pickListFrame != null) {
            this._pickListFrame.dispose();
            this._pickListFrame = null;
        }
    }

    private void clearFields() {
        this._origin.clearFields();
        this._destination.clearFields();
        this._via.clearFields();
        this._avoid.clearFields();
    }

    protected String routeIsValid() {
        if (this._orders == null || this._orders.isEmpty()) {
            return Bundle.getMessage("noBlockOrders");
        }
        if (this._orders.size() < 2) {
            return Bundle.getMessage("NoRouteSet", this._origin.getBlockName(), this._destination.getBlockName());
        }
        BlockOrder blockOrder = this._orders.get(0);
        String msg = WarrantRoute.pathIsValid(blockOrder.getBlock(), blockOrder.getPathName());
        if (msg == null) {
            int i = 1;
            while (i < this._orders.size()) {
                BlockOrder nextBlockOrder = this._orders.get(i);
                msg = WarrantRoute.pathIsValid(nextBlockOrder.getBlock(), nextBlockOrder.getPathName());
                if (msg != null) {
                    return msg;
                }
                if (!blockOrder.getExitName().equals(nextBlockOrder.getEntryName())) {
                    return Bundle.getMessage("disconnectedRoute", blockOrder.getBlock().getDisplayName(), nextBlockOrder.getBlock().getDisplayName());
                }
                blockOrder = nextBlockOrder;
                ++i;
            }
        }
        return msg;
    }

    protected static String pathIsValid(OBlock block, String pathName) {
        if (block == null) {
            return Bundle.getMessage("PathInvalid", pathName, "null");
        }
        List<Path> list = block.getPaths();
        if (list.isEmpty()) {
            return Bundle.getMessage("WarningTitle");
        }
        if (pathName != null) {
            int i = 0;
            while (i < list.size()) {
                OPath path = (OPath)list.get(i);
                if (pathName.equals(path.getName())) {
                    if (path.getFromPortal() == null && path.getToPortal() == null) {
                        return Bundle.getMessage("PathNeedsPortal", pathName, block.getDisplayName());
                    }
                    return null;
                }
                ++i;
            }
        }
        return Bundle.getMessage("PathInvalid", pathName, block.getDisplayName());
    }

    @Override
    public void dispose() {
        this.clearFrames();
        super.dispose();
    }

    protected static JPanel makeTextBoxPanel(boolean vertical, JComponent comp, String text, String tooltip) {
        JPanel panel = new JPanel();
        JLabel label = new JLabel(Bundle.getMessage(text));
        if (vertical) {
            panel.setLayout(new BoxLayout(panel, 3));
            label.setAlignmentX(0.5f);
            comp.setAlignmentX(0.5f);
            panel.add(Box.createVerticalStrut(STRUT_SIZE));
        } else {
            panel.setLayout(new BoxLayout(panel, 2));
            label.setAlignmentX(0.0f);
            comp.setAlignmentX(1.0f);
            panel.add(Box.createHorizontalStrut(STRUT_SIZE));
        }
        panel.add(label);
        if (!vertical) {
            panel.add(Box.createHorizontalStrut(STRUT_SIZE));
        }
        panel.add(comp);
        if (vertical) {
            panel.add(Box.createVerticalStrut(STRUT_SIZE));
        } else {
            panel.add(Box.createHorizontalStrut(STRUT_SIZE));
        }
        if (comp instanceof JTextField || comp instanceof JComboBox) {
            comp.setBackground(Color.white);
        }
        if (tooltip != null) {
            String tipText = Bundle.getMessage(tooltip);
            panel.setToolTipText(tipText);
            comp.setToolTipText(tipText);
            label.setToolTipText(tipText);
        }
        panel.setMaximumSize(new Dimension(350, comp.getPreferredSize().height));
        panel.setMinimumSize(new Dimension(80, comp.getPreferredSize().height));
        return panel;
    }

    protected static JPanel makeTextAndButtonPanel(JComponent comp, JComponent button, JLabel label, String tooltip) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        label.setAlignmentX(0.0f);
        panel.add(Box.createHorizontalStrut(STRUT_SIZE));
        panel.add(label);
        panel.add(Box.createHorizontalStrut(STRUT_SIZE));
        panel.add(Box.createHorizontalGlue());
        comp.setAlignmentX(1.0f);
        panel.add(comp);
        if (comp instanceof JTextField || comp instanceof JComboBox) {
            comp.setBackground(Color.white);
        }
        panel.add(Box.createHorizontalStrut(STRUT_SIZE));
        button.setAlignmentX(1.0f);
        panel.add(button);
        panel.add(Box.createHorizontalStrut(STRUT_SIZE));
        if (tooltip != null) {
            String tipText = Bundle.getMessage(tooltip);
            panel.setToolTipText(tipText);
            comp.setToolTipText(tipText);
            button.setToolTipText(tipText);
            label.setToolTipText(tipText);
        }
        panel.setMaximumSize(new Dimension(350, comp.getPreferredSize().height));
        panel.setMinimumSize(new Dimension(50, comp.getPreferredSize().height));
        return panel;
    }

    protected static JPanel makeTextBoxPanel(JComponent comp, String label, String tooltip) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(Box.createHorizontalStrut(STRUT_SIZE));
        comp.setAlignmentX(0.0f);
        comp.setMaximumSize(new Dimension(300, comp.getPreferredSize().height));
        comp.setMinimumSize(new Dimension(30, comp.getPreferredSize().height));
        panel.add(comp);
        if (comp instanceof JTextField || comp instanceof JComboBox) {
            comp.setBackground(Color.white);
            JLabel l = new JLabel(Bundle.getMessage(label));
            l.setAlignmentX(0.0f);
            l.setToolTipText(Bundle.getMessage(tooltip));
            panel.add(l);
        } else if (comp instanceof AbstractButton) {
            ((AbstractButton)comp).setText(Bundle.getMessage(label));
        }
        panel.add(Box.createHorizontalStrut(STRUT_SIZE));
        if (tooltip != null) {
            String tipText = Bundle.getMessage(tooltip);
            panel.setToolTipText(tipText);
            comp.setToolTipText(tipText);
        }
        panel.setMaximumSize(new Dimension(350, comp.getPreferredSize().height));
        panel.setMinimumSize(new Dimension(80, comp.getPreferredSize().height));
        return panel;
    }

    static class AddressTextField
    extends JTextField
    implements FocusListener {
        public AddressTextField() {
            this.addFocusListener(this);
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.fireActionPerformed();
        }
    }

    static enum Display {
        MPH("mph"),
        KPH("kph"),
        MMPS("mmps"),
        INPS("inps"),
        IN("in"),
        CM("cm");

        String _bundleKey;

        private Display(String bundleName) {
            this._bundleKey = bundleName;
        }

        public String toString() {
            return Bundle.getMessage(this._bundleKey);
        }
    }

    static class DisplayButton
    extends JButton {
        Display pref;

        DisplayButton(Display p) {
            this.setDisplayPref(p);
        }

        void setDisplayPref(Display p) {
            this.pref = p;
            this.setText(p.toString());
        }

        Display getDisplyPref() {
            return this.pref;
        }
    }

    static enum Location {
        ORIGIN,
        DEST,
        VIA,
        AVOID;

    }

    protected class RouteLocation
    extends MouseAdapter {
        Location location;
        private BlockOrder order;
        JTextField blockBox = new JTextField();
        private final JComboBox<String> pathBox = new JComboBox();
        JComboBox<String> portalBox;

        RouteLocation(Location loc) {
            this.location = loc;
            if (this.location == Location.ORIGIN || this.location == Location.DEST) {
                this.portalBox = new JComboBox();
            }
        }

        private JPanel makePanel(String title, String tooltip, String box1Name, String box2Name, WarrantRoute parent) {
            JPanel oPanel = new JPanel();
            oPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), Bundle.getMessage(title), 2, 2));
            JPanel hPanel = new JPanel();
            hPanel.setLayout(new BoxLayout(hPanel, 2));
            hPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
            hPanel.add(this.makeBlockBox(tooltip));
            hPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
            JPanel pPanel = new JPanel();
            pPanel.setLayout(new BoxLayout(pPanel, 2));
            pPanel.add(WarrantRoute.this.makeLabelCombo(box1Name, this.pathBox, tooltip));
            pPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
            if (box2Name != null) {
                pPanel.add(WarrantRoute.this.makeLabelCombo(box2Name, this.portalBox, tooltip));
                pPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
            }
            hPanel.add(pPanel);
            oPanel.add(hPanel);
            pPanel.setToolTipText(Bundle.getMessage(tooltip));
            hPanel.setToolTipText(Bundle.getMessage(tooltip));
            oPanel.setToolTipText(Bundle.getMessage(tooltip));
            this.blockBox.addActionListener(parent);
            this.blockBox.addPropertyChangeListener(parent);
            this.blockBox.addMouseListener(this);
            return oPanel;
        }

        private JPanel makeBlockBox(String tooltip) {
            this.blockBox.setDragEnabled(true);
            this.blockBox.setTransferHandler(new DnDStringImportHandler());
            this.blockBox.setColumns(20);
            this.blockBox.setAlignmentX(0.5f);
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.setToolTipText(Bundle.getMessage(tooltip));
            this.blockBox.setToolTipText(Bundle.getMessage(tooltip));
            JLabel l = new JLabel(Bundle.getMessage("BlockName"));
            p.add((Component)l, "North");
            l.setLabelFor(this.blockBox);
            p.add((Component)this.blockBox, "Center");
            return p;
        }

        private void clearFields() {
            this.setBlock(null);
        }

        private boolean checkBlockBox(JTextField box) {
            if (box == this.blockBox) {
                this.setBlock(this.getEndPointBlock());
                return true;
            }
            return false;
        }

        private boolean checkPathBox(JComboBox<String> box) {
            if (box == this.pathBox) {
                if (this.portalBox != null) {
                    this.setPortalBox(this.order);
                }
                return true;
            }
            return false;
        }

        private boolean checkPortalBox(JComboBox<String> box) {
            return box == this.portalBox;
        }

        private void setOrderEntryPortal() {
            if (this.order != null) {
                this.order.setEntryName((String)this.portalBox.getSelectedItem());
            }
        }

        private void setOrderExitPortal() {
            if (this.order != null) {
                this.order.setExitName((String)this.portalBox.getSelectedItem());
            }
        }

        protected void setOrder(BlockOrder o) {
            if (o != null) {
                this.order = new BlockOrder(o);
                OBlock block = o.getBlock();
                this.blockBox.setText(block.getDisplayName());
                this.setPathBox(block);
                this.setPathName(o.getPathName());
                this.setPortalBox(o);
                if (this.location == Location.DEST) {
                    this.setPortalName(o.getEntryName());
                } else if (this.location == Location.ORIGIN) {
                    this.setPortalName(o.getExitName());
                }
            }
        }

        protected BlockOrder getOrder() {
            return this.order;
        }

        private void setPortalName(String name) {
            this.portalBox.setSelectedItem(name);
        }

        private void setPathName(String name) {
            this.pathBox.setSelectedItem(name);
        }

        protected String getBlockName() {
            return this.blockBox.getText();
        }

        private OBlock getEndPointBlock() {
            String text = this.blockBox.getText();
            int idx = text.indexOf(9);
            if (idx > 0) {
                text = idx + 1 < text.length() ? text.substring(idx + 1) : text.substring(0, idx);
            }
            this.blockBox.setText(text);
            OBlock block = InstanceManager.getDefault(OBlockManager.class).getOBlock(text);
            if (block == null && text.length() > 0) {
                JOptionPane.showMessageDialog(this.blockBox.getParent(), Bundle.getMessage("BlockNotFound", text), Bundle.getMessage("WarningTitle"), 2);
            }
            return block;
        }

        private boolean setBlock() {
            return this.setBlock(this.getEndPointBlock());
        }

        private boolean setBlock(OBlock block) {
            boolean result = true;
            if (block == null) {
                result = false;
                this.order = null;
            } else if (this.order != null && block == this.order.getBlock() && WarrantRoute.pathIsValid(block, this.order.getPathName()) == null) {
                result = true;
            } else if (WarrantRoute.this.pathsAreValid(block)) {
                this.order = new BlockOrder(block);
                if (!this.setPathBox(block)) {
                    result = false;
                } else {
                    this.setPortalBox(this.order);
                }
            } else {
                result = false;
            }
            if (result) {
                if (block != null) {
                    this.blockBox.setText(block.getDisplayName());
                }
                this.order.setPathName((String)this.pathBox.getSelectedItem());
                if (this.location == Location.DEST) {
                    this.order.setEntryName((String)this.portalBox.getSelectedItem());
                } else if (this.location == Location.ORIGIN) {
                    this.order.setExitName((String)this.portalBox.getSelectedItem());
                }
                this.setNextLocation();
            } else {
                this.blockBox.setText(null);
                this.pathBox.removeAllItems();
                if (this.portalBox != null) {
                    this.portalBox.removeAllItems();
                }
            }
            return result;
        }

        private boolean setPathBox(OBlock block) {
            this.pathBox.removeAllItems();
            if (this.portalBox != null) {
                this.portalBox.removeAllItems();
            }
            if (block == null) {
                return false;
            }
            List<Path> list = block.getPaths();
            if (list.isEmpty()) {
                JOptionPane.showMessageDialog(null, Bundle.getMessage("NoPaths", block.getDisplayName()), Bundle.getMessage("WarningTitle"), 2);
                return false;
            }
            int i = 0;
            while (i < list.size()) {
                this.pathBox.addItem(((OPath)list.get(i)).getName());
                ++i;
            }
            return true;
        }

        private void setPortalBox(BlockOrder order) {
            if (this.portalBox == null) {
                return;
            }
            this.portalBox.removeAllItems();
            if (order == null) {
                return;
            }
            String pathName = (String)this.pathBox.getSelectedItem();
            order.setPathName(pathName);
            OPath path = order.getPath();
            if (path != null) {
                String name;
                Portal portal = path.getFromPortal();
                if (portal != null && (name = portal.getName()) != null) {
                    this.portalBox.addItem(name);
                }
                if ((portal = path.getToPortal()) != null && (name = portal.getName()) != null) {
                    this.portalBox.addItem(name);
                }
                if (log.isTraceEnabled()) {
                    log.debug("setPortalBox: Path {} set in block {}", (Object)path.getName(), (Object)order.getBlock().getDisplayName());
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("setPortalBox: Path {} not found in block {}", (Object)pathName, (Object)order.getBlock().getDisplayName());
                }
                order.setPathName(null);
            }
        }

        private void setNextLocation() {
            switch (this.location) {
                case ORIGIN: {
                    WarrantRoute.this._focusedField = WarrantRoute.this._destination;
                    break;
                }
                case DEST: {
                    WarrantRoute.this._focusedField = WarrantRoute.this._via;
                    break;
                }
                case VIA: {
                    WarrantRoute.this._focusedField = WarrantRoute.this._avoid;
                    break;
                }
                case AVOID: {
                    WarrantRoute.this._focusedField = WarrantRoute.this._origin;
                    break;
                }
                default: {
                    log.warn("Unhandled next location code: {}", (Object)this.location);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            WarrantRoute.this._focusedField = this;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            WarrantRoute.this._focusedField = this;
        }
    }

    class RouteTableModel
    extends AbstractTableModel {
        static final int BLOCK_COLUMN = 0;
        static final int ENTER_PORTAL_COL = 1;
        static final int PATH_COLUMN = 2;
        static final int DEST_PORTAL_COL = 3;
        static final int NUMCOLS = 4;

        RouteTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            if (WarrantRoute.this._orders == null) {
                return 0;
            }
            return WarrantRoute.this._orders.size();
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Bundle.getMessage("BlockCol");
                }
                case 1: {
                    return Bundle.getMessage("EnterPortalCol");
                }
                case 2: {
                    return Bundle.getMessage("PathCol");
                }
                case 3: {
                    return Bundle.getMessage("DestPortalCol");
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return String.class;
        }

        public int getPreferredWidth(int col) {
            return new JTextField((int)15).getPreferredSize().width;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (WarrantRoute.this._orders == null || row >= WarrantRoute.this._orders.size()) {
                return "";
            }
            BlockOrder bo = WarrantRoute.this._orders.get(row);
            if (bo == null) {
                log.error("BlockOrder is null");
                return "";
            }
            switch (col) {
                case 0: {
                    OBlock b = bo.getBlock();
                    if (b == null) {
                        return "null";
                    }
                    return bo.getBlock().getDisplayName();
                }
                case 1: {
                    return bo.getEntryName();
                }
                case 2: {
                    return bo.getPathName();
                }
                case 3: {
                    if (row == WarrantRoute.this._orders.size() - 1) {
                        return "";
                    }
                    return bo.getExitName();
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (WarrantRoute.this._orders == null) {
                return;
            }
            BlockOrder bo = WarrantRoute.this._orders.get(row);
            switch (col) {
                case 0: {
                    OBlock block = InstanceManager.getDefault(OBlockManager.class).getOBlock((String)value);
                    if (block == null) break;
                    bo.setBlock(block);
                    break;
                }
                case 1: {
                    bo.setEntryName((String)value);
                    break;
                }
                case 2: {
                    bo.setPathName((String)value);
                    break;
                }
                case 3: {
                    bo.setExitName((String)value);
                }
            }
            this.fireTableRowsUpdated(row, row);
        }
    }
}

