/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.swing.JOptionPane;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.NamedBean;
import jmri.ShutDownManager;
import jmri.ShutDownTask;
import jmri.jmrit.logix.BlockOrder;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OPath;
import jmri.jmrit.logix.Portal;
import jmri.jmrit.logix.SCWarrant;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.logix.WarrantPreferences;
import jmri.jmrit.logix.WarrantShutdownTask;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.RosterSpeedProfile;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import jmri.managers.AbstractManager;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarrantManager
extends AbstractManager<Warrant>
implements InstanceManagerAutoDefault {
    private HashMap<String, RosterSpeedProfile> _mergeProfiles = new HashMap();
    ShutDownTask _shutDownTask = null;
    private boolean _suppressWarnings = false;
    private static final Logger log = LoggerFactory.getLogger(WarrantManager.class);

    public WarrantManager() {
        super(InstanceManager.getDefault(InternalSystemConnectionMemo.class));
    }

    @Override
    public int getXMLOrder() {
        return 170;
    }

    @Override
    public char typeLetter() {
        return 'W';
    }

    public Warrant createNewWarrant(String systemName, String userName, boolean SCWa, long TTP) {
        Warrant r;
        log.debug("createNewWarrant {} SCWa= {}", (Object)systemName, (Object)SCWa);
        if (userName != null && userName.trim().length() > 0) {
            r = (Warrant)this.getByUserName(userName);
            if (r == null) {
                r = (Warrant)this.getBySystemName(systemName);
            }
            if (r != null) {
                log.warn("Warrant {}  exits.", (Object)r.getDisplayName());
                return null;
            }
        }
        if (!systemName.startsWith(this.getSystemNamePrefix()) || systemName.length() < this.getSystemNamePrefix().length() + 1) {
            log.error("Warrant system name \"{}\" must begin with \"{}\".", (Object)systemName, (Object)this.getSystemNamePrefix());
            return null;
        }
        r = SCWa ? new SCWarrant(systemName, userName, TTP) : new Warrant(systemName, userName);
        this.register(r);
        return r;
    }

    public Warrant getWarrant(String name) {
        Warrant r = (Warrant)this.getByUserName(name);
        if (r != null) {
            return r;
        }
        return (Warrant)this.getBySystemName(name);
    }

    public Warrant provideWarrant(String name) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        Warrant w = (Warrant)this.getByUserName(name);
        if (w == null) {
            w = (Warrant)this.getBySystemName(name);
        }
        if (w == null) {
            w = this.createNewWarrant(name, null, false, 0L);
        }
        return w;
    }

    protected boolean okToRemoveBlock(OBlock block) {
        String name = block.getDisplayName();
        List<Warrant> list = this.warrantsUsing(block);
        boolean ok = true;
        if (!list.isEmpty() && !this._suppressWarnings) {
            StringBuilder sb = new StringBuilder();
            for (Warrant w : list) {
                sb.append(Bundle.getMessage("DeleteWarrantBlock", name, w.getDisplayName()));
            }
            sb.append(Bundle.getMessage("DeleteConfirm", name));
            ok = this.okToRemove(name, sb.toString());
        }
        if (ok) {
            this.removeWarrants(list);
        }
        return ok;
    }

    protected boolean okToRemovePortal(Portal portal) {
        List<NamedBean> sList;
        String name = portal.getName();
        boolean ok = true;
        List<Warrant> wList = this.warrantsUsing(portal);
        if (!wList.isEmpty() && !this._suppressWarnings) {
            StringBuilder sb = new StringBuilder();
            for (Warrant w : wList) {
                sb.append(Bundle.getMessage("DeleteWarrantPortal", name, w.getDisplayName()));
            }
            sb.append(Bundle.getMessage("DeleteConfirm", name));
            ok = this.okToRemove(name, sb.toString());
        }
        if (!(sList = this.signalsUsing(portal)).isEmpty() && !this._suppressWarnings) {
            StringBuilder sb = new StringBuilder();
            for (NamedBean s : sList) {
                sb.append(Bundle.getMessage("DeletePortalSignal", name, s.getDisplayName(), portal.getProtectedBlock(s)));
            }
            sb.append(Bundle.getMessage("DeleteConfirmSignal", name));
            ok = this.okToRemove(name, sb.toString());
        }
        if (ok) {
            this.removeWarrants(wList);
            for (NamedBean s : sList) {
                portal.deleteSignal(s);
            }
        }
        return ok;
    }

    protected boolean okToRemoveBlockPath(OBlock block, OPath path) {
        String pathName = path.getName();
        String blockName = block.getDisplayName();
        boolean ok = true;
        List<Warrant> list = this.warrantsUsing(block, path);
        if (!list.isEmpty() && !this._suppressWarnings) {
            StringBuilder sb = new StringBuilder();
            for (Warrant w : list) {
                sb.append(Bundle.getMessage("DeleteWarrantPath", pathName, blockName, w.getDisplayName()));
            }
            sb.append(Bundle.getMessage("DeleteConfirm", pathName));
            ok = this.okToRemove(pathName, sb.toString());
        }
        if (ok) {
            this.removeWarrants(list);
        }
        return ok;
    }

    private void removeWarrants(List<Warrant> list) {
        for (Warrant w : list) {
            if (w.getRunMode() != 0) {
                w.controlRunTrain(3);
            }
            this.deregister(w);
            w.dispose();
        }
    }

    private boolean okToRemove(String name, String message) {
        if (!ThreadingUtil.isLayoutThread()) {
            log.warn("Cannot delete portal \"{}\" from this thread", (Object)name);
            return false;
        }
        int val = JOptionPane.showOptionDialog(null, message, Bundle.getMessage("WarningTitle"), 1, 3, null, new Object[]{Bundle.getMessage("ButtonYes"), Bundle.getMessage("ButtonYesPlus"), Bundle.getMessage("ButtonNo")}, Bundle.getMessage("ButtonNo"));
        if (val == 2) {
            return false;
        }
        if (val == 1) {
            this._suppressWarnings = true;
        }
        return true;
    }

    protected synchronized void portalNameChange(String oldName, String newName) {
        for (Warrant w : this.getNamedBeanSet()) {
            List<BlockOrder> orders = w.getBlockOrders();
            for (BlockOrder bo : orders) {
                if (oldName.equals(bo.getEntryName())) {
                    bo.setEntryName(newName);
                }
                if (!oldName.equals(bo.getExitName())) continue;
                bo.setExitName(newName);
            }
        }
    }

    protected List<Warrant> warrantsUsing(OBlock block) {
        ArrayList<Warrant> list = new ArrayList<Warrant>();
        for (Warrant w : this.getNamedBeanSet()) {
            List<BlockOrder> orders = w.getBlockOrders();
            Iterator<BlockOrder> it = orders.iterator();
            while (it.hasNext()) {
                if (!block.equals(it.next().getBlock())) continue;
                list.add(w);
            }
        }
        return list;
    }

    protected List<Warrant> warrantsUsing(Portal portal) {
        ArrayList<Warrant> list = new ArrayList<Warrant>();
        String name = portal.getName();
        for (Warrant w : this.getNamedBeanSet()) {
            List<BlockOrder> orders = w.getBlockOrders();
            for (BlockOrder bo : orders) {
                if (name.equals(bo.getEntryName()) && !list.contains(w)) {
                    list.add(w);
                    continue;
                }
                if (!name.equals(bo.getExitName()) || list.contains(w)) continue;
                list.add(w);
            }
        }
        return list;
    }

    protected List<NamedBean> signalsUsing(Portal portal) {
        ArrayList<NamedBean> list = new ArrayList<NamedBean>();
        NamedBean signal = portal.getToSignal();
        if (signal != null) {
            list.add(signal);
        }
        if ((signal = portal.getFromSignal()) != null) {
            list.add(signal);
        }
        return list;
    }

    protected List<Warrant> warrantsUsing(OBlock block, OPath path) {
        ArrayList<Warrant> list = new ArrayList<Warrant>();
        String name = path.getName();
        for (Warrant w : this.getNamedBeanSet()) {
            List<BlockOrder> orders = w.getBlockOrders();
            for (BlockOrder bo : orders) {
                if (!block.equals(bo.getBlock()) || !name.equals(bo.getPathName())) continue;
                list.add(w);
            }
        }
        return list;
    }

    protected synchronized void pathNameChange(OBlock block, String oldName, String newName) {
        for (Warrant w : this.getNamedBeanSet()) {
            List<BlockOrder> orders = w.getBlockOrders();
            for (BlockOrder bo : orders) {
                if (!bo.getBlock().equals(block) || !bo.getPathName().equals(oldName)) continue;
                bo.setPathName(newName);
            }
        }
    }

    public static WarrantManager getDefault() {
        return InstanceManager.getOptionalDefault(WarrantManager.class).orElseGet(() -> InstanceManager.setDefault(WarrantManager.class, new WarrantManager()));
    }

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameWarrants" : "BeanNameWarrant");
    }

    @Override
    public Class<Warrant> getNamedBeanClass() {
        return Warrant.class;
    }

    protected void setMergeProfile(String id, RosterSpeedProfile merge) {
        if (this._shutDownTask == null && !WarrantPreferences.getDefault().getShutdown().equals((Object)WarrantPreferences.Shutdown.NO_MERGE)) {
            this._shutDownTask = new WarrantShutdownTask("WarrantRosterSpeedProfileCheck");
            InstanceManager.getDefault(ShutDownManager.class).register(this._shutDownTask);
        }
        if (id != null) {
            this._mergeProfiles.put(id, merge);
        }
    }

    @Nonnull
    protected RosterSpeedProfile getMergeProfile(String id) {
        RosterSpeedProfile mergeProfile = this._mergeProfiles.get(id);
        if (mergeProfile != null && mergeProfile.getProfileSize() > 0) {
            return this.makeProfileCopy(mergeProfile, id);
        }
        return this.makeProfileCopy(null, id);
    }

    protected RosterSpeedProfile makeProfileCopy(RosterSpeedProfile mergeProfile, String id) {
        RosterSpeedProfile profile = new RosterSpeedProfile(null);
        if (mergeProfile == null) {
            RosterSpeedProfile rosterProfile;
            RosterEntry rosterEntry;
            if (id != null && !id.isEmpty() && (rosterEntry = Roster.getDefault().getEntryForId(id)) != null && (rosterProfile = rosterEntry.getSpeedProfile()) != null) {
                TreeMap<Integer, RosterSpeedProfile.SpeedStep> rosterTree = rosterProfile.getProfileSpeeds();
                for (Map.Entry<Integer, RosterSpeedProfile.SpeedStep> entry : rosterTree.entrySet()) {
                    profile.setSpeed(entry.getKey(), entry.getValue().getForwardSpeed(), entry.getValue().getReverseSpeed());
                }
            }
            return profile;
        }
        TreeMap<Integer, RosterSpeedProfile.SpeedStep> rosterTree = mergeProfile.getProfileSpeeds();
        for (Map.Entry<Integer, RosterSpeedProfile.SpeedStep> entry : rosterTree.entrySet()) {
            profile.setSpeed(entry.getKey(), entry.getValue().getForwardSpeed(), entry.getValue().getReverseSpeed());
        }
        return profile;
    }

    protected HashMap<String, RosterSpeedProfile> getMergeProfiles() {
        return this._mergeProfiles;
    }

    @Override
    public void dispose() {
        for (Warrant w : this._beans) {
            w.stopWarrant(true, true);
        }
        super.dispose();
    }
}

