/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.InvokeOnLayoutThread;
import jmri.LocoAddress;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.SignalHead;
import jmri.SignalMast;
import jmri.ThrottleListener;
import jmri.ThrottleManager;
import jmri.implementation.AbstractNamedBean;
import jmri.implementation.SignalSpeedMap;
import jmri.jmrit.logix.BlockOrder;
import jmri.jmrit.logix.BlockSpeedInfo;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.Engineer;
import jmri.jmrit.logix.LearnThrottleFrame;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.RampData;
import jmri.jmrit.logix.SCWarrant;
import jmri.jmrit.logix.SpeedUtil;
import jmri.jmrit.logix.ThrottleSetting;
import jmri.jmrit.logix.Tracker;
import jmri.jmrit.logix.TrackerTableAction;
import jmri.jmrit.logix.WarrantPreferences;
import jmri.jmrit.logix.WarrantTableFrame;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Warrant
extends AbstractNamedBean
implements ThrottleListener,
PropertyChangeListener {
    public static final String Stop = InstanceManager.getDefault(SignalSpeedMap.class).getNamedSpeed(0.0f);
    public static final String EStop = Bundle.getMessage("EStop");
    public static final String Normal = "Normal";
    private List<BlockOrder> _orders;
    private BlockOrder _viaOrder;
    private BlockOrder _avoidOrder;
    private List<ThrottleSetting> _commands = new ArrayList<ThrottleSetting>();
    protected String _trainName;
    private SpeedUtil _speedUtil;
    private boolean _runBlind = false;
    private boolean _partialAllocate;
    private boolean _addTracker;
    private boolean _noRamp;
    private boolean _nxWarrant = false;
    private LearnThrottleFrame _student;
    private boolean _tempRunBlind;
    private boolean _delayStart;
    private int _idxCurrentOrder = 0;
    private int _idxLastOrder = 0;
    protected int _runMode = 0;
    private Engineer _engineer;
    @GuardedBy(value="this")
    private CommandDelay _delayCommand;
    private boolean _allocated;
    private boolean _totalAllocated;
    private boolean _routeSet;
    protected OBlock _stoppingBlock;
    private NamedBean _protectSignal;
    private int _idxProtectSignal;
    private OBlock _myShareBlock;
    private OBlock _otherShareBlock;
    private boolean _waitForSignal;
    private boolean _waitForBlock;
    private boolean _waitForWarrant;
    private String _curSignalAspect;
    protected String _message;
    private ThrottleManager tm;
    public static final int MODE_NONE = 0;
    public static final int MODE_LEARN = 1;
    public static final int MODE_RUN = 2;
    public static final int MODE_MANUAL = 3;
    public static final String[] MODES = new String[]{"none", "LearnMode", "RunAuto", "RunManual", "Abort"};
    public static final int MODE_ABORT = 4;
    public static final int STOP = 0;
    public static final int HALT = 1;
    public static final int RESUME = 2;
    public static final int ABORT = 3;
    public static final int RETRY = 4;
    public static final int ESTOP = 5;
    protected static final int RAMP_HALT = 6;
    protected static final int RUNNING = 7;
    protected static final int SPEED_RESTRICTED = 8;
    protected static final int WAIT_FOR_CLEAR = 9;
    protected static final int WAIT_FOR_SENSOR = 10;
    protected static final int WAIT_FOR_TRAIN = 11;
    protected static final int WAIT_FOR_DELAYED_START = 12;
    protected static final int LEARNING = 13;
    protected static final int STOP_PENDING = 14;
    protected static final int DEBUG = 8;
    protected static final int SPEED_UP = 7;
    protected static final String[] CNTRL_CMDS = new String[]{"Stop", "Halt", "Resume", "Abort", "MoveToNext", "EStop", "SmoothHalt", "SpeedUp", "Debug"};
    protected static final String[] RUN_STATE = new String[]{"HaltStart", "atHalt", "Resumed", "Aborts", "Retried", "EStop", "HaltPending", "Running", "changeSpeed", "WaitingForClear", "WaitingForSensor", "RunningLate", "WaitingForStart", "RecordingScript", "StopPending"};
    private static final Logger log = LoggerFactory.getLogger(Warrant.class);

    public Warrant(String sName, String uName) {
        super(sName, uName);
        this._orders = new ArrayList<BlockOrder>();
        this._speedUtil = new SpeedUtil();
        this.tm = InstanceManager.getNullableDefault(ThrottleManager.class);
    }

    protected void setNXWarrant(boolean set) {
        this._nxWarrant = set;
    }

    protected boolean isNXWarrant() {
        return this._nxWarrant;
    }

    @Override
    public int getState() {
        if (this._engineer != null) {
            return this._engineer.getRunState();
        }
        if (this._delayStart) {
            return 12;
        }
        if (this._runMode == 1) {
            return 13;
        }
        if (this._runMode != 0) {
            return 7;
        }
        return -1;
    }

    @Override
    public void setState(int state) {
    }

    public SpeedUtil getSpeedUtil() {
        return this._speedUtil;
    }

    public void setSpeedUtil(SpeedUtil su) {
        this._speedUtil = su;
    }

    public List<BlockOrder> getBlockOrders() {
        return this._orders;
    }

    public void addBlockOrder(BlockOrder order) {
        this._orders.add(order);
    }

    public void setBlockOrders(List<BlockOrder> orders) {
        this._orders = orders;
    }

    public BlockOrder getfirstOrder() {
        if (this._orders.isEmpty()) {
            return null;
        }
        return new BlockOrder(this._orders.get(0));
    }

    public BlockOrder getLastOrder() {
        int size = this._orders.size();
        if (size < 2) {
            return null;
        }
        return new BlockOrder(this._orders.get(size - 1));
    }

    public BlockOrder getViaOrder() {
        if (this._viaOrder == null) {
            return null;
        }
        return new BlockOrder(this._viaOrder);
    }

    public void setViaOrder(BlockOrder order) {
        this._viaOrder = order;
    }

    public BlockOrder getAvoidOrder() {
        if (this._avoidOrder == null) {
            return null;
        }
        return new BlockOrder(this._avoidOrder);
    }

    public void setAvoidOrder(BlockOrder order) {
        this._avoidOrder = order;
    }

    protected String getRoutePathInBlock(OBlock block) {
        int i = 0;
        while (i < this._orders.size()) {
            if (this._orders.get(i).getBlock().equals(block)) {
                return this._orders.get(i).getPathName();
            }
            ++i;
        }
        return null;
    }

    public final BlockOrder getCurrentBlockOrder() {
        return this.getBlockOrderAt(this._idxCurrentOrder);
    }

    public final int getCurrentOrderIndex() {
        return this._idxCurrentOrder;
    }

    protected void incrementCurrentOrderIndex() {
        ++this._idxCurrentOrder;
    }

    protected int getIndexOfBlock(OBlock block, int startIdx) {
        int i = startIdx;
        while (i < this._orders.size()) {
            if (this._orders.get(i).getBlock().equals(block)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int getIndexOfBlockBefore(int endIdx, OBlock block) {
        int i = endIdx;
        while (i >= 0) {
            if (this._orders.get(i).getBlock().equals(block)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    protected int getIndexOfBlock(String name, int startIdx) {
        int i = startIdx;
        while (i < this._orders.size()) {
            if (this._orders.get(i).getBlock().getDisplayName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected BlockOrder getBlockOrderAt(int index) {
        if (index >= 0 && index < this._orders.size()) {
            return this._orders.get(index);
        }
        return null;
    }

    protected OBlock getBlockAt(int idx) {
        BlockOrder bo = this.getBlockOrderAt(idx);
        if (bo != null) {
            return bo.getBlock();
        }
        return null;
    }

    public String getCurrentBlockName() {
        OBlock block = this.getBlockAt(this._idxCurrentOrder);
        if (block == null) {
            return "";
        }
        return block.getDisplayName();
    }

    private int getBlockStateAt(int idx) {
        OBlock b = this.getBlockAt(idx);
        if (b != null) {
            return b.getState();
        }
        return 1;
    }

    public List<ThrottleSetting> getThrottleCommands() {
        return this._commands;
    }

    public void setThrottleCommands(List<ThrottleSetting> list) {
        this._commands = list;
    }

    public void addThrottleCommand(ThrottleSetting ts) {
        if (ts == null) {
            log.error("warrant {} cannot add null ThrottleSetting", (Object)this.getDisplayName());
        } else {
            this._commands.add(ts);
        }
    }

    public void setTrackSpeeds() {
        float speed = 0.0f;
        for (ThrottleSetting ts : this._commands) {
            ThrottleSetting.CommandValue cmdVal = ts.getValue();
            ThrottleSetting.ValueType valType = cmdVal.getType();
            switch (valType) {
                case VAL_FLOAT: {
                    speed = this._speedUtil.getTrackSpeed(cmdVal.getFloat());
                    break;
                }
                case VAL_TRUE: {
                    this._speedUtil.setIsForward(true);
                    break;
                }
                case VAL_FALSE: {
                    this._speedUtil.setIsForward(false);
                }
            }
            ts.setTrackSpeed(speed);
        }
    }

    public void setNoRamp(boolean set) {
        this._noRamp = set;
    }

    public void setShareRoute(boolean set) {
        this._partialAllocate = set;
    }

    public void setAddTracker(boolean set) {
        this._addTracker = set;
    }

    public boolean getNoRamp() {
        return this._noRamp;
    }

    public boolean getShareRoute() {
        return this._partialAllocate;
    }

    public boolean getAddTracker() {
        return this._addTracker;
    }

    public String getTrainName() {
        return this._trainName;
    }

    public void setTrainName(String name) {
        this._trainName = name;
    }

    public boolean getRunBlind() {
        return this._runBlind;
    }

    public void setRunBlind(boolean runBlind) {
        this._runBlind = runBlind;
    }

    protected void fireRunStatus(String property, Object old, Object status) {
        ThreadingUtil.runOnGUIEventually(() -> this.firePropertyChange(property, old, status));
    }

    public boolean isAllocated() {
        return this._allocated;
    }

    public boolean isTotalAllocated() {
        return this._totalAllocated;
    }

    public boolean hasRouteSet() {
        return this._routeSet;
    }

    public boolean routeIsFree() {
        int i = 0;
        while (i < this._orders.size()) {
            OBlock block = this._orders.get(i).getBlock();
            if (!block.isFree()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean routeIsOccupied() {
        int i = 1;
        while (i < this._orders.size()) {
            OBlock block = this._orders.get(i).getBlock();
            if ((block.getState() & 2) != 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isWaitingForSignal() {
        return this._waitForSignal;
    }

    protected boolean isWaitingForClear() {
        return this._waitForBlock;
    }

    protected boolean isWaitingForWarrant() {
        return this._waitForWarrant;
    }

    protected Warrant getBlockingWarrant() {
        if (this._stoppingBlock != null && !this.equals(this._stoppingBlock.getWarrant())) {
            return this._stoppingBlock.getWarrant();
        }
        if (this._otherShareBlock != null) {
            return this._otherShareBlock.getWarrant();
        }
        return null;
    }

    public int getRunMode() {
        return this._runMode;
    }

    protected String getRunModeMessage() {
        String modeDesc = null;
        switch (this._runMode) {
            case 0: {
                return Bundle.getMessage("NotRunning", this.getDisplayName());
            }
            case 1: {
                modeDesc = Bundle.getMessage("Recording");
                break;
            }
            case 2: {
                modeDesc = Bundle.getMessage("AutoRun");
                break;
            }
            case 3: {
                modeDesc = Bundle.getMessage("ManualRun");
            }
        }
        return Bundle.getMessage("WarrantInUse", modeDesc, this.getDisplayName());
    }

    protected String getRunningMessage() {
        if (this._delayStart) {
            return Bundle.getMessage("waitForDelayStart", this._trainName, this.getBlockOrderAt(0).getBlock().getDisplayName());
        }
        switch (this._runMode) {
            case 0: {
                if (this.getBlockOrders().isEmpty()) {
                    return Bundle.getMessage("BlankWarrant");
                }
                if (this._speedUtil.getAddress() == null) {
                    return Bundle.getMessage("NoLoco");
                }
                if (!(this instanceof SCWarrant) && this._commands.size() <= this._orders.size()) {
                    return Bundle.getMessage("NoCommands", this.getDisplayName());
                }
                if (this._message == null) {
                    return Bundle.getMessage("Idle");
                }
                if (this._idxCurrentOrder != 0 && this._idxLastOrder == this._idxCurrentOrder) {
                    return String.valueOf(Bundle.getMessage("locationUnknown", this._trainName, this.getCurrentBlockName())) + this._message;
                }
                return Bundle.getMessage("Idle1", this._message);
            }
            case 1: {
                return Bundle.getMessage("Learning", this.getCurrentBlockName());
            }
            case 2: {
                if (this._engineer == null) {
                    return Bundle.getMessage("engineerGone", this.getCurrentBlockName());
                }
                int cmdIdx = this._engineer.getCurrentCommandIndex();
                if (cmdIdx >= this._commands.size()) {
                    cmdIdx = this._commands.size() - 1;
                }
                ++cmdIdx;
                OBlock block = this.getCurrentBlockOrder().getBlock();
                if ((block.getState() & 0x102) == 0) {
                    this._engineer.setSpeedToType(EStop);
                    return Bundle.getMessage("LostTrain", this._trainName, block.getDisplayName());
                }
                String blockName = block.getDisplayName();
                String speedMsg = this.getSpeedMessage(this._engineer.getSpeedType(true));
                int runState = this._engineer.getRunState();
                switch (runState) {
                    case 3: {
                        if (cmdIdx == this._commands.size() - 1) {
                            this._engineer = null;
                            return Bundle.getMessage("endOfScript", this._trainName);
                        }
                        return Bundle.getMessage("Aborted", blockName, cmdIdx);
                    }
                    case 1: 
                    case 9: {
                        String msg = this.makeWaitMessage(blockName, cmdIdx);
                        return msg;
                    }
                    case 11: {
                        int blkIdx = this._idxCurrentOrder + 1;
                        if (blkIdx >= this._orders.size()) {
                            blkIdx = this._orders.size() - 1;
                        }
                        return Bundle.getMessage("WaitForTrain", cmdIdx, this.getBlockOrderAt(blkIdx).getBlock().getDisplayName(), speedMsg);
                    }
                    case 10: {
                        return Bundle.getMessage("WaitForSensor", cmdIdx, this._engineer.getWaitSensor().getDisplayName(), blockName, speedMsg);
                    }
                    case 7: {
                        return Bundle.getMessage("WhereRunning", blockName, cmdIdx, speedMsg);
                    }
                    case 8: {
                        return Bundle.getMessage("changeSpeed", blockName, cmdIdx, speedMsg);
                    }
                    case 6: {
                        return Bundle.getMessage("HaltPending", speedMsg, blockName);
                    }
                    case 14: {
                        return Bundle.getMessage("StopPending", speedMsg, blockName, this._waitForSignal ? Bundle.getMessage("Signal") : (this._waitForWarrant ? Bundle.getMessage("Warrant") : Bundle.getMessage("Occupancy")));
                    }
                }
                return this._message;
            }
            case 3: {
                BlockOrder bo = this.getCurrentBlockOrder();
                if (bo != null) {
                    return Bundle.getMessage("ManualRunning", bo.getBlock().getDisplayName());
                }
                return Bundle.getMessage("ManualRun");
            }
        }
        return "ERROR mode= " + MODES[this._runMode];
    }

    private String getSpeedMessage(String speedType) {
        String units;
        float speed = 0.0f;
        SignalSpeedMap speedMap = InstanceManager.getDefault(SignalSpeedMap.class);
        switch (speedMap.getInterpretation()) {
            case 1: {
                speed = this._engineer.getSpeedSetting() * 100.0f;
                float scriptSpeed = this._engineer.getScriptSpeed();
                scriptSpeed = scriptSpeed > 0.0f ? speed / scriptSpeed : 0.0f;
                units = Bundle.getMessage("percentNormal", Math.round(scriptSpeed));
                break;
            }
            case 2: {
                units = Bundle.getMessage("percentThrottle");
                speed = this._engineer.getSpeedSetting() * 100.0f;
                break;
            }
            case 3: {
                units = Bundle.getMessage("mph");
                speed = this._speedUtil.getTrackSpeed(this._engineer.getSpeedSetting()) * speedMap.getLayoutScale();
                speed *= 2.2369363f;
                break;
            }
            case 4: {
                units = Bundle.getMessage("kph");
                speed = this._speedUtil.getTrackSpeed(this._engineer.getSpeedSetting()) * speedMap.getLayoutScale();
                speed *= 3.6f;
                break;
            }
            default: {
                log.error("Unknown speed interpretation {}", (Object)speedMap.getInterpretation());
                throw new IllegalArgumentException("Unknown speed interpretation " + speedMap.getInterpretation());
            }
        }
        return Bundle.getMessage("atSpeed", speedType, Math.round(speed), units);
    }

    protected String makeWaitMessage(String blockName, int cmdIdx) {
        String which;
        String where = null;
        if (this._waitForSignal) {
            which = Bundle.getMessage("Signal");
            OBlock protectedBlock = this.getBlockAt(this._idxProtectSignal);
            if (protectedBlock != null) {
                where = protectedBlock.getDisplayName();
            }
        } else if (this._waitForWarrant) {
            Warrant w = this.getBlockingWarrant();
            which = w != null ? Bundle.getMessage("WarrantWait", w.getDisplayName()) : Bundle.getMessage("WarrantWait", "Unknown");
            if (this._stoppingBlock != null) {
                where = this._stoppingBlock.getDisplayName();
            }
        } else if (this._waitForBlock) {
            which = Bundle.getMessage("Occupancy");
            if (this._stoppingBlock != null) {
                where = this._stoppingBlock.getDisplayName();
            }
        } else {
            if (this._engineer.isRamping()) {
                String speedMsg = this.getSpeedMessage(this._engineer.getSpeedType(true));
                return Bundle.getMessage("changeSpeed", blockName, cmdIdx, speedMsg);
            }
            return Bundle.getMessage(RUN_STATE[this._engineer.getRunState()], blockName, cmdIdx);
        }
        if (where != null) {
            return Bundle.getMessage("WaitForClear", blockName, which, where);
        }
        log.warn("makeWaitMessage has flags. But no source for condition!");
        this.debugInfo();
        return Bundle.getMessage(RUN_STATE[this._engineer.getRunState()], blockName, "Error");
    }

    @InvokeOnLayoutThread
    private void startTracker() {
        ThreadingUtil.runOnGUIEventually(() -> new Tracker(this.getCurrentBlockOrder().getBlock(), this._trainName, null, InstanceManager.getDefault(TrackerTableAction.class)));
    }

    public void stopWarrant(boolean abort, boolean turnOffFunctions) {
        this._delayStart = false;
        this.clearWaitFlags(true);
        if (this._student != null) {
            this._student.dispose();
            this._student = null;
        }
        int oldMode = this._runMode;
        this._runMode = 0;
        this._curSignalAspect = null;
        if (this._engineer != null) {
            this._engineer.stopRun(abort, turnOffFunctions);
            if (!Thread.currentThread().equals(this._engineer)) {
                try {
                    this._engineer.join(200L);
                }
                catch (InterruptedException interruptedException) {
                    log.info("_engineer.join() interrupted. warrant {}", (Object)this.getDisplayName());
                }
                this._engineer = null;
            }
        }
        this.deAllocate();
        if (turnOffFunctions && this._idxCurrentOrder == this._orders.size() - 1) {
            this._speedUtil.stopRun(true);
            if (this._addTracker) {
                this.startTracker();
                this._runMode = 3;
            }
        }
        this._addTracker = false;
        this.fireRunStatus("runMode", oldMode, this._runMode);
        if (log.isDebugEnabled()) {
            log.debug("{}: terminated {}.", (Object)this.getDisplayName(), (Object)(abort ? "- aborted!" : "normally"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setRunMode(int mode, DccLocoAddress address, LearnThrottleFrame student, List<ThrottleSetting> commands, boolean runBlind) {
        if (log.isDebugEnabled()) {
            log.debug("setRunMode({}) ({}) called with _runMode= {}.", new Object[]{this.getDisplayName(), mode, MODES[mode], MODES[this._runMode]});
        }
        this._message = null;
        if (this._runMode != 0) {
            this._message = this.getRunModeMessage();
            log.error(this._message);
            return this._message;
        }
        this._delayStart = false;
        this.clearWaitFlags(true);
        if (address != null) {
            this._speedUtil.setDccAddress(address);
        }
        if (mode == 1) {
            if (student == null) {
                this._message = Bundle.getMessage("noLearnThrottle", this.getDisplayName());
                log.error(this._message);
                return this._message;
            }
            Warrant warrant = this;
            synchronized (warrant) {
                this._student = student;
            }
            this._runMode = mode;
        } else if (mode == 2 || mode == 3) {
            int state;
            if (commands != null && commands.size() > this._orders.size()) {
                this._commands = commands;
            }
            this._idxCurrentOrder = 0;
            this._runMode = mode;
            if (!runBlind && ((state = this.getBlockStateAt(0)) & 0x102) == 0) {
                this.setStoppingBlock(this.getBlockAt(0));
                this._waitForBlock = true;
                this._delayStart = true;
            }
        } else {
            this.stopWarrant(true, true);
        }
        this.getBlockAt((int)0)._entryTime = System.currentTimeMillis();
        this._tempRunBlind = runBlind;
        if (!this._delayStart) {
            if (mode != 3) {
                this._message = this.acquireThrottle();
            } else {
                this.startupWarrant();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("{}: Exit setRunMode(). msg= {}", (Object)this.getDisplayName(), (Object)this._message);
        }
        this.fireRunStatus("runMode", 0, this._runMode);
        return this._message;
    }

    protected String acquireThrottle() {
        String msg = null;
        DccLocoAddress dccAddress = this._speedUtil.getDccAddress();
        if (log.isDebugEnabled()) {
            log.debug("{}: acquireThrottle request at {}", (Object)this.getDisplayName(), (Object)dccAddress);
        }
        if (dccAddress == null) {
            msg = Bundle.getMessage("NoAddress", this.getDisplayName());
        } else if (this.tm == null) {
            msg = Bundle.getMessage("noThrottle", this._speedUtil.getDccAddress().getNumber());
        } else if (!this.tm.requestThrottle(dccAddress, (ThrottleListener)this, false)) {
            return Bundle.getMessage("trainInUse", dccAddress.getNumber());
        }
        if (msg != null) {
            this.abortWarrant(msg);
            this.fireRunStatus("throttleFail", null, msg);
            return msg;
        }
        return null;
    }

    @Override
    public void notifyThrottleFound(DccThrottle throttle) {
        if (throttle == null) {
            String msg = Bundle.getMessage("noThrottle", this.getDisplayName());
            this.abortWarrant(msg);
            this.fireRunStatus("throttleFail", null, msg);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("{}: notifyThrottleFound for address= {}, class= {},", new Object[]{this.getDisplayName(), throttle.getLocoAddress(), throttle.getClass().getName()});
        }
        this._speedUtil.setThrottle(throttle);
        this.startupWarrant();
        this.runWarrant(throttle);
    }

    @Override
    public void notifyFailedThrottleRequest(LocoAddress address, String reason) {
        this.abortWarrant(Bundle.getMessage("noThrottle", String.valueOf(reason) + " " + (address != null ? Integer.valueOf(address.getNumber()) : this.getDisplayName())));
        this.fireRunStatus("throttleFail", null, reason);
    }

    @Override
    public void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
    }

    protected void releaseThrottle(DccThrottle throttle) {
        if (throttle != null) {
            if (this.tm != null) {
                this.tm.releaseThrottle(throttle, this);
            } else {
                log.error("{} on thread {}", (Object)Bundle.getMessage("noThrottle", throttle.getLocoAddress()), (Object)Thread.currentThread().getName());
            }
        }
    }

    protected void abortWarrant(String msg) {
        log.error("Abort warrant \"{}\" - {} ", (Object)this.getDisplayName(), (Object)msg);
        this.stopWarrant(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean controlRunTrain(int idx) {
        if (idx < 0) {
            return false;
        }
        boolean ret = false;
        if (this._engineer == null) {
            if (log.isDebugEnabled()) {
                log.debug("{}: controlRunTrain({})= \"{}\" for train {} runMode= {}", new Object[]{this.getDisplayName(), idx, CNTRL_CMDS[idx], this.getTrainName(), MODES[this._runMode]});
            }
            switch (idx) {
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 7: {
                    this.fireRunStatus("SpeedChange", null, idx);
                    break;
                }
                case 0: 
                case 3: {
                    if (this._runMode == 1) {
                        this.fireRunStatus("abortLearn", -1, this._idxCurrentOrder);
                        break;
                    }
                    this.fireRunStatus("controlChange", 2, 3);
                    this.stopWarrant(true, true);
                    break;
                }
                case 8: {
                    ret = this.debugInfo();
                    this.fireRunStatus("SpeedChange", null, idx);
                }
            }
            return ret;
        }
        int runState = this._engineer.getRunState();
        if (log.isDebugEnabled()) {
            log.debug("{}: controlRunTrain({})= \"{}\" for train {} runstate= {}, in block {}.", new Object[]{idx, CNTRL_CMDS[idx], this.getTrainName(), RUN_STATE[runState], this.getDisplayName(), this.getBlockAt(this._idxCurrentOrder).getDisplayName()});
        }
        Warrant warrant = this;
        synchronized (warrant) {
            switch (idx) {
                case 6: {
                    this._engineer.rampSpeedTo(Stop, -1);
                    this._engineer.setHalt(true);
                    ret = true;
                    break;
                }
                case 2: {
                    OBlock block = this.getBlockAt(this._idxCurrentOrder);
                    if ((block.getState() & 2) == 0) break;
                    if (this._waitForSignal || this._waitForBlock || this._waitForWarrant) {
                        ret = this.askResumeQuestion(block);
                        if (!ret) break;
                        if (WarrantPreferences.getDefault().getTrace()) {
                            log.info(Bundle.getMessage("userOverRide", this._trainName, block.getDisplayName()));
                        }
                        ret = this.reStartTrain();
                        break;
                    }
                    ret = this.reStartTrain();
                    break;
                }
                case 7: {
                    OBlock block = this.getBlockAt(this._idxCurrentOrder);
                    if ((block.getState() & 2) == 0) break;
                    if (this._waitForSignal || this._waitForBlock || this._waitForWarrant || runState != 7 && runState != 8) {
                        ret = this.askResumeQuestion(block);
                        if (!ret) break;
                        if (WarrantPreferences.getDefault().getTrace()) {
                            log.info(Bundle.getMessage("userOverRide", this._trainName, block.getDisplayName()));
                        }
                        ret = this.bumpSpeed();
                        break;
                    }
                    ret = this.bumpSpeed();
                    break;
                }
                case 4: {
                    OBlock block = this.getBlockAt(this._idxCurrentOrder + 1);
                    if (block.allocate(this) != null || (block.getState() & 2) == 0) break;
                    if (this._waitForSignal || this._waitForBlock || this._waitForWarrant || runState != 7 && runState != 8) {
                        ret = this.askResumeQuestion(block);
                        if (!ret) break;
                        if (WarrantPreferences.getDefault().getTrace()) {
                            log.info(Bundle.getMessage("userOverRide", this._trainName, block.getDisplayName()));
                        }
                        ret = this.moveToNextBlock(block);
                        break;
                    }
                    ret = this.moveToNextBlock(block);
                    break;
                }
                case 3: {
                    this.stopWarrant(true, true);
                    ret = true;
                    break;
                }
                case 0: 
                case 1: {
                    this.cancelDelayRamp();
                    this._engineer.setSpeedToType(Stop);
                    ret = true;
                    break;
                }
                case 5: {
                    this.cancelDelayRamp();
                    this._engineer.setSpeedToType(EStop);
                    ret = true;
                    break;
                }
                default: {
                    ret = this.debugInfo();
                    this.fireRunStatus("SpeedChange", null, idx);
                    return ret;
                }
            }
        }
        int state = runState;
        if (state == 1 && (this._waitForSignal || this._waitForBlock || this._waitForWarrant)) {
            state = 9;
        }
        if (ret) {
            this.fireRunStatus("controlChange", state, idx);
        } else {
            this.fireRunStatus("controlFailed", state, idx);
        }
        return ret;
    }

    private boolean askResumeQuestion(OBlock block) {
        String msg = Bundle.getMessage("ResumeQuestion", this.makeWaitMessage(block.getDisplayName(), this._idxCurrentOrder));
        boolean ret = ThreadingUtil.runOnGUIwithReturn(() -> {
            int result = JOptionPane.showConfirmDialog(WarrantTableFrame.getDefault(), msg, Bundle.getMessage("ResumeTitle"), 0, 3);
            if (result == 0) {
                return true;
            }
            return false;
        });
        return ret;
    }

    private boolean reStartTrain() {
        OBlock block = this.getBlockAt(this._idxCurrentOrder);
        if (block.allocate(this) == null && (block.getState() & 2) != 0) {
            this._engineer.setHalt(false);
            this.clearWaitFlags(false);
            if (this._idxCurrentOrder == 0) {
                return this.setMovement(false);
            }
            return this.restoreRunning(this._engineer.getSpeedType(false));
        }
        return false;
    }

    private boolean bumpSpeed() {
        OBlock block = this.getBlockAt(this._idxCurrentOrder);
        if (block.allocate(this) == null && (block.getState() & 2) != 0) {
            this._engineer.setHalt(false);
            this.clearWaitFlags(false);
            float speedSetting = this._engineer.getSpeedSetting();
            if (speedSetting < 0.0f) {
                speedSetting = 0.0f;
            }
            this._engineer.setSpeed(speedSetting + this._speedUtil.getRampThrottleIncrement());
            return true;
        }
        return false;
    }

    private boolean moveToNextBlock(OBlock block) {
        BlockOrder bo = this.getBlockOrderAt(this._idxCurrentOrder + 1);
        this._message = bo.setPath(this);
        if (this._message != null) {
            log.warn("Cannot clear path for warrant \"{}\" at block \"{}\" - msg = {}", new Object[]{this.getDisplayName(), block.getDisplayName(), this._message});
            return false;
        }
        ++this._idxCurrentOrder;
        if (block.equals(this._stoppingBlock)) {
            this.clearStoppingBlock();
        }
        this.goingActive(block);
        return true;
    }

    protected boolean debugInfo() {
        StringBuffer info = new StringBuffer("\nWarrant: ");
        info.append(this.getDisplayName());
        info.append(" - Head Block \"");
        info.append(this.getBlockAt(this._idxCurrentOrder).getDisplayName());
        info.append("\" BlockOrder idx= ");
        info.append(this._idxCurrentOrder);
        info.append("\n\tWarrant flags: _waitForSignal= ");
        info.append(this._waitForSignal);
        info.append(", _waitForBlock= ");
        info.append(this._waitForBlock);
        info.append(", _waitForWarrant= ");
        info.append(this._waitForWarrant);
        if (this._protectSignal != null) {
            info.append("\n\tSignal \"");
            info.append(this._protectSignal.getDisplayName());
            info.append("\" protects block ");
            info.append(this.getBlockAt(this._idxProtectSignal).getDisplayName());
            info.append("\" from approch block \"");
            info.append(this.getBlockAt(this._idxProtectSignal - 1).getDisplayName());
            info.append("\".");
        } else {
            info.append("\n\tNo signals ahead with speed restrictions");
        }
        if (this._stoppingBlock != null) {
            if (this._waitForWarrant) {
                info.append("\n\tWarrant \"");
                info.append(this.getBlockingWarrant().getDisplayName());
                info.append("\" owns block \"");
                info.append(this._stoppingBlock.getDisplayName());
                info.append("\"");
            } else {
                Object what = this._stoppingBlock.getValue();
                String who = what != null ? what.toString() : "Unknown Train";
                info.append("\n\t\"");
                info.append(who);
                info.append("\" occupies Block \"");
                info.append(this._stoppingBlock.getDisplayName());
                info.append("\"");
            }
        } else {
            info.append("\n\tNo occupied blocks ahead");
        }
        if (this._message != null) {
            info.append("\n\tLast message \"");
            info.append(this._message);
            info.append("\"");
        } else {
            info.append("\n\tNo messages.");
        }
        if (this._engineer != null) {
            info.append(this._engineer.debugInfo());
        } else {
            info.append("No engineer.");
        }
        log.info(info.toString());
        return true;
    }

    protected void startupWarrant() {
        this._idxCurrentOrder = 0;
        this._idxLastOrder = 0;
        BlockOrder bo = this.getBlockOrderAt(0);
        OBlock b = bo.getBlock();
        b.setValue(this._trainName);
        b.setState(b.getState() | 0x20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWarrant(DccThrottle throttle) {
        if (this._runMode == 1) {
            Warrant warrant = this;
            synchronized (warrant) {
                this._student.notifyThrottleFound(throttle);
            }
        }
        if (this._engineer != null && !this._engineer.getState().equals((Object)Thread.State.TERMINATED)) {
            log.error(this._engineer.debugInfo());
            if (!Thread.currentThread().equals(this._engineer)) {
                try {
                    this._engineer.join(200L);
                }
                catch (InterruptedException interruptedException) {
                    log.info("_engineer.join() interrupted. warrant {}", (Object)this.getDisplayName());
                }
                if (log.isDebugEnabled()) {
                    log.debug(this._engineer.debugInfo());
                }
            }
            this._engineer = null;
        }
        if (!this._noRamp) {
            this._speedUtil.getBlockSpeedTimes(this._commands);
        }
        this._engineer = new Engineer(this, throttle);
        if (this._tempRunBlind) {
            this._engineer.setRunOnET(true);
        }
        if (this._delayStart) {
            this._engineer.setHalt(true);
            this.fireRunStatus("ReadyToRun", -1, 0);
        }
        this._engineer.start();
        if (this._engineer.getRunState() == 7) {
            this.setMovement(false);
        }
        this._delayStart = false;
    }

    public String allocateRoute(boolean show, List<BlockOrder> orders) {
        if (this._totalAllocated) {
            return null;
        }
        if (orders != null) {
            this._orders = orders;
        }
        this._allocated = false;
        OBlock block = this.getBlockAt(0);
        this._message = block.allocate(this);
        if (this._message != null) {
            return this._message;
        }
        this._allocated = true;
        String msg = this.allocateFromIndex(false, 1);
        if (msg != null) {
            this._message = msg;
        } else if (this._partialAllocate) {
            this._message = Bundle.getMessage("sharedRoute");
        }
        if (show) {
            return this._message;
        }
        return null;
    }

    private String allocateFromIndex(boolean setOne, int index) {
        int limit = this._partialAllocate || setOne ? Math.min(index + 1, this._orders.size()) : this._orders.size();
        OBlock currentBlock = this.getBlockAt(this._idxCurrentOrder);
        if (log.isDebugEnabled()) {
            log.debug("{}: allocateFromIndex({}) block= {} _partialAllocate= {}.", new Object[]{this.getDisplayName(), index, currentBlock.getDisplayName(), this._partialAllocate});
        }
        this._message = null;
        boolean passageDenied = false;
        boolean allocationDenied = false;
        int i = index;
        while (i < limit) {
            BlockOrder bo = this._orders.get(i);
            OBlock block = bo.getBlock();
            if (!allocationDenied) {
                String msg;
                if (!currentBlock.equals(block)) {
                    if ((block.getState() & 2) != 0 && !this._delayStart) {
                        if (this._message == null) {
                            this._message = Bundle.getMessage("BlockRougeOccupied", block.getDisplayName());
                        }
                        if (this._partialAllocate) {
                            allocationDenied = true;
                        }
                        passageDenied = true;
                    }
                    if (Stop.equals(this.getPermissibleSpeedAt(bo)) && !this._delayStart) {
                        if (this._message == null) {
                            this._message = Bundle.getMessage("BlockStopAspect", block.getDisplayName());
                        }
                        if (this._partialAllocate) {
                            allocationDenied = true;
                        }
                        passageDenied = true;
                    }
                }
                if (!allocationDenied && (msg = block.allocate(this)) != null && this._message == null) {
                    this._message = msg;
                    passageDenied = true;
                    allocationDenied = true;
                }
                if (!passageDenied) {
                    msg = bo.setPath(this);
                    if (setOne || msg != null) {
                        if (this._message == null) {
                            this._message = msg;
                        }
                        passageDenied = true;
                    }
                }
            }
            ++i;
        }
        if (!allocationDenied && limit == this._orders.size()) {
            this._totalAllocated = true;
        }
        return this._message;
    }

    public void deAllocate() {
        this._allocated = false;
        this._totalAllocated = false;
        this._routeSet = false;
        int i = 0;
        while (i < this._orders.size()) {
            OBlock block = this._orders.get(i).getBlock();
            if (block.isAllocatedTo(this)) {
                block.deAllocate(this);
            }
            ++i;
        }
        this._message = null;
        if (log.isDebugEnabled()) {
            log.debug("{}: deallocated Route.", (Object)this.getDisplayName());
        }
    }

    public void runWarrant(int mode) {
        this.setRoute(false, null);
        this.setRunMode(mode, null, null, null, false);
    }

    public String setRoute(boolean show, List<BlockOrder> orders) {
        if (this._partialAllocate) {
            this.deAllocate();
        }
        this._routeSet = false;
        String msg = this.allocateRoute(show, orders);
        if (msg != null) {
            this._message = msg;
            log.debug("setRoute: {}", (Object)msg);
            return this._message;
        }
        BlockOrder bo = this._orders.get(0);
        msg = bo.setPath(this);
        if (msg != null) {
            this._message = msg;
            log.debug("setRoute: {}", (Object)msg);
            return this._message;
        }
        this._routeSet = true;
        if (!this._partialAllocate) {
            int i = 1;
            while (i < this._orders.size()) {
                bo = this._orders.get(i);
                OBlock block = bo.getBlock();
                if ((block.getState() & 2) != 0) {
                    if (this._message == null) break;
                    this._message = Bundle.getMessage("BlockRougeOccupied", block.getDisplayName());
                    break;
                }
                if (Stop.equals(this.getPermissibleSpeedAt(bo))) {
                    if (this._message == null) break;
                    this._message = Bundle.getMessage("BlockStopAspect", block.getDisplayName());
                    break;
                }
                msg = bo.setPath(this);
                if (msg != null && this._message == null) {
                    this._message = msg;
                    log.debug("setRoute: {}", (Object)msg);
                    break;
                }
                ++i;
            }
        }
        this._routeSet = true;
        return null;
    }

    public String checkStartBlock() {
        BlockOrder bo;
        OBlock block;
        String msg;
        if (log.isDebugEnabled()) {
            log.debug("{}: checkStartBlock.", (Object)this.getDisplayName());
        }
        if ((msg = (block = (bo = this._orders.get(0)).getBlock()).allocate(this)) != null) {
            return msg;
        }
        msg = bo.setPath(this);
        if (msg != null) {
            return msg;
        }
        int state = block.getState();
        if ((state & 0x100) != 0 || this._tempRunBlind) {
            msg = "BlockDark";
        } else if ((state & 2) == 0) {
            msg = "warnStart";
        }
        return msg;
    }

    protected String checkforTrackers() {
        BlockOrder bo = this._orders.get(0);
        OBlock block = bo.getBlock();
        log.debug("{}: checkforTrackers at block {}", (Object)this.getDisplayName(), (Object)block.getDisplayName());
        Tracker t = InstanceManager.getDefault(TrackerTableAction.class).findTrackerIn(block);
        if (t != null) {
            return Bundle.getMessage("blockInUse", t.getTrainName(), block.getDisplayName());
        }
        return null;
    }

    public String checkRoute() {
        if (log.isDebugEnabled()) {
            log.debug("{}: checkRoute.", (Object)this.getDisplayName());
        }
        if (this._orders == null || this._orders.size() == 0) {
            return Bundle.getMessage("noBlockOrders");
        }
        OBlock startBlock = this._orders.get(0).getBlock();
        int i = 1;
        while (i < this._orders.size()) {
            OBlock block = this._orders.get(i).getBlock();
            if ((block.getState() & 2) != 0 && !startBlock.equals(block)) {
                return Bundle.getMessage("BlockRougeOccupied", block.getDisplayName());
            }
            Warrant w = block.getWarrant();
            if (w != null && !this.equals(w)) {
                return Bundle.getMessage("AllocatedToWarrant", w.getDisplayName(), block.getDisplayName(), w.getTrainName());
            }
            ++i;
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!(evt.getSource() instanceof NamedBean)) {
            return;
        }
        String property = evt.getPropertyName();
        if (log.isDebugEnabled()) {
            log.debug("{}: propertyChange \"{}\" new= {} source= {}", new Object[]{this.getDisplayName(), property, evt.getNewValue(), ((NamedBean)evt.getSource()).getDisplayName()});
        }
        if (this._protectSignal != null && this._protectSignal == evt.getSource()) {
            if (property.equals("Aspect") || property.equals("Appearance")) {
                this.readStoppingSignal();
            }
        } else if (property.equals("state")) {
            if (this._stoppingBlock != null && this._stoppingBlock.equals(evt.getSource())) {
                if (this._delayStart) {
                    Warrant w;
                    if ((((Number)evt.getNewValue()).intValue() & 2) != 0 && (this.equals(w = this._stoppingBlock.getWarrant()) || w == null) && this.clearStoppingBlock()) {
                        OBlock block = this.getBlockAt(this._idxCurrentOrder);
                        if (this._runMode == 2) {
                            this.acquireThrottle();
                        } else if (this._runMode == 3) {
                            this.fireRunStatus("ReadyToRun", -1, 0);
                            this._delayStart = false;
                        }
                        block._entryTime = System.currentTimeMillis();
                        block.setValue(this._trainName);
                        block.setState(block.getState() | 0x20);
                    }
                } else if ((((Number)evt.getNewValue()).intValue() & 4) != 0) {
                    ThreadingUtil.runOnGUIDelayed(() -> this.clearStoppingBlock(), 7000);
                }
            } else if (this._otherShareBlock != null && this._otherShareBlock == evt.getSource() && (((Number)evt.getNewValue()).intValue() & 4) != 0) {
                this.clearShareTOBlock();
            }
        } else if (this._delayStart && property.equals("runMode") && ((Number)evt.getNewValue()).intValue() == 0) {
            ((Warrant)evt.getSource()).removePropertyChangeListener(this);
            if (this.clearStoppingBlock()) {
                this.acquireThrottle();
            }
        }
    }

    private String getSignalSpeedType(NamedBean signal) {
        String speedType;
        if (signal instanceof SignalHead) {
            SignalHead head = (SignalHead)signal;
            int appearance = head.getAppearance();
            speedType = InstanceManager.getDefault(SignalSpeedMap.class).getAppearanceSpeed(head.getAppearanceName(appearance));
            if (log.isDebugEnabled()) {
                log.debug("{}: SignalHead {} sets appearance speed to {}", new Object[]{this.getDisplayName(), signal.getDisplayName(), speedType});
            }
        } else {
            SignalMast mast = (SignalMast)signal;
            String aspect = mast.getAspect();
            speedType = InstanceManager.getDefault(SignalSpeedMap.class).getAspectSpeed(aspect, mast.getSignalSystem());
            if (log.isDebugEnabled()) {
                log.debug("{}: SignalMast {} sets aspect speed to {}", new Object[]{this.getDisplayName(), signal.getDisplayName(), speedType});
            }
        }
        return speedType;
    }

    private void readStoppingSignal() {
        if (this._idxProtectSignal < this._idxCurrentOrder) {
            this.signalAddListener(null, this._idxCurrentOrder);
            return;
        }
        String speedType = this.getSignalSpeedType(this._protectSignal);
        if (log.isDebugEnabled()) {
            log.debug("{}: Signal \"{}\" sets speed \"{}\" {} blocks ahead.", new Object[]{this.getDisplayName(), this._protectSignal.getDisplayName(), speedType, this._idxProtectSignal - this._idxCurrentOrder});
        }
        if (speedType.equals(Stop)) {
            float availDist = this.getAvailableDistance(this._idxProtectSignal);
            float changeDist = this.getEntranceDistance(this._engineer.getSpeedSetting(), this._idxProtectSignal, speedType);
            if (changeDist < availDist) {
                return;
            }
            this.setMovement(true);
        } else {
            this._waitForSignal = false;
            if (WarrantPreferences.getDefault().getTrace()) {
                log.info(Bundle.getMessage("SignalCleared", this._protectSignal.getDisplayName(), speedType, this._trainName));
            }
            this._message = this.allocateFromIndex(true, this._idxCurrentOrder + 1);
            this._curSignalAspect = speedType;
            if (this._message == null) {
                ThreadingUtil.runOnGUIDelayed(() -> this.restoreRunning(speedType), 3500);
            } else {
                this.setStoppingBlock(this.getBlockAt(this._idxCurrentOrder + 1));
                this._waitForBlock = true;
                this.fireRunStatus("waiting", -1, this.getRunningMessage());
            }
        }
    }

    private float getAvailableDistance(int idxChange) {
        float availDist = 0.0f;
        int idxBlockOrder = this._idxCurrentOrder + 1;
        if (idxBlockOrder < this._orders.size() - 1) {
            while (idxBlockOrder < idxChange) {
                availDist += this.getAvailableDistanceAt(idxBlockOrder++);
            }
        }
        return availDist;
    }

    private float getEntranceDistance(float speedSetting, int idxBlockOrder, String speedType) {
        float scriptSpeed = this._speedUtil.getBlockSpeedInfo(idxBlockOrder).getEntranceSpeed();
        float endSpeed = this._speedUtil.modifySpeed(scriptSpeed, speedType);
        if (speedSetting <= endSpeed || Math.abs(scriptSpeed - endSpeed) < 0.005f) {
            if (log.isDebugEnabled()) {
                log.debug("{}: Ramp unnecessary. Script decreases speed from {} to {} before entering block \"{}\".", new Object[]{this.getDisplayName(), Float.valueOf(scriptSpeed), Float.valueOf(endSpeed), this.getBlockAt(idxBlockOrder).getDisplayName()});
            }
            float f = 0.0f;
        }
        float enterLen = this.getRampLengthForEntry(scriptSpeed, endSpeed);
        float nowLen = this.getRampLengthForEntry(speedSetting, endSpeed);
        if (nowLen > enterLen) {
            enterLen = nowLen;
        }
        float bufDist = this.getEntranceBufferDist(idxBlockOrder);
        return enterLen + bufDist;
    }

    private void doStoppingBlockClear() {
        this._stoppingBlock.removePropertyChangeListener(this);
        if (this._waitForBlock) {
            this._waitForBlock = false;
        }
        if (this._waitForWarrant) {
            this._waitForWarrant = false;
        }
        if (WarrantPreferences.getDefault().getTrace()) {
            log.info(Bundle.getMessage("StopBlockCleared", this._stoppingBlock.getDisplayName(), this.getTrainName()));
        }
        this._stoppingBlock = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clearStoppingBlock() {
        Runnable allocateBlocks;
        if (this._stoppingBlock == null) {
            return false;
        }
        if (this.allocateFromIndex(true, this._idxCurrentOrder + 1) == null) {
            this.doStoppingBlockClear();
            if (this._delayStart) {
                return true;
            }
            String speedType = this._curSignalAspect != null ? this._curSignalAspect : this._engineer.getSpeedType(false);
            return this.restoreRunning(speedType);
        }
        Runnable runnable = allocateBlocks = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long time = 0L;
                try {
                    1 var3_2 = this;
                    synchronized (var3_2) {
                        String speedType = Warrant.this._curSignalAspect != null ? Warrant.this._curSignalAspect : Warrant.this._engineer.getSpeedType(false);
                        while (time < 200L) {
                            Warrant.this._message = Warrant.this.allocateFromIndex(true, Warrant.this._idxCurrentOrder + 1);
                            if (Warrant.this._message == null) {
                                Warrant.this.doStoppingBlockClear();
                                Warrant.this.restoreRunning(speedType);
                                break;
                            }
                            this.wait(20L);
                            time += 20L;
                        }
                        if (Warrant.this._message != null) {
                            log.warn("{}: unable to clear StoppingBlock message= \"{}\" time= {}", new Object[]{Warrant.this.getDisplayName(), Warrant.this._message, time});
                        }
                    }
                }
                catch (InterruptedException ie) {
                    log.warn("Warrant \"{}\" InterruptedException message= \"{}\" time= {}", new Object[]{Warrant.this.getDisplayName(), ie.toString(), time});
                    Thread.currentThread().interrupt();
                }
                if (log.isDebugEnabled()) {
                    log.debug("{}: waited {}ms for clearStoppingBlock to allocateFrom block \"{}\"", new Object[]{Warrant.this.getDisplayName(), time, Warrant.this.getBlockAt(Warrant.this._idxCurrentOrder + 1).getDisplayName()});
                }
            }
        };
        synchronized (runnable) {
            Thread doit = ThreadingUtil.newThread(() -> {
                try {
                    SwingUtilities.invokeLater(allocateBlocks);
                }
                catch (Exception e) {
                    log.error("Exception in allocateBlocks", (Throwable)e);
                }
            }, "Warrant doit");
            doit.start();
        }
        return true;
    }

    private boolean okToRun() {
        int runState = -1;
        boolean ret = false;
        if (this._engineer != null) {
            runState = this._engineer.getRunState();
            if (!(this._waitForSignal || this._waitForBlock || this._waitForWarrant || runState == 1 || runState == 6)) {
                ret = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("{}: okToRun()= {}: runState={} _waitForSignal={} _waitForBlock={} _waitForWarrant={}.", new Object[]{this.getDisplayName(), ret, runState < 0 ? "No Engineer" : RUN_STATE[runState], this._waitForSignal, this._waitForBlock, this._waitForWarrant});
        }
        return ret;
    }

    private boolean restoreRunning(String speedType) {
        if (this.okToRun()) {
            this.getBlockOrderAt(this._idxCurrentOrder).setPath(this);
            this.cancelDelayRamp();
            this._engineer.rampSpeedTo(speedType, -1);
            this._curSignalAspect = null;
            this.fireRunStatus("SpeedChange", this._idxCurrentOrder - 1, this._idxCurrentOrder);
            if (log.isDebugEnabled()) {
                log.debug("{}: restoreRunning(): rampSpeedTo to \"{}\"", (Object)this.getDisplayName(), (Object)speedType);
            }
            return true;
        }
        log.warn("{}: Cannot restore Running.", (Object)this.getDisplayName());
        this.fireRunStatus("waiting", -1, this.getRunningMessage());
        return false;
    }

    private void clearShareTOBlock() {
        if (this._otherShareBlock == null) {
            return;
        }
        this._otherShareBlock.removePropertyChangeListener(this);
        if (log.isDebugEnabled()) {
            String msg = this._orders.get(this.getIndexOfBlock(this._myShareBlock, this._idxCurrentOrder)).setPath(this);
            log.info("_otherShareBlock= \"{}\" Cleared. {}", (Object)this._otherShareBlock.getDisplayName(), (Object)(msg == null ? "" : "msg"));
        }
        this._otherShareBlock = null;
        this._myShareBlock = null;
        this._waitForWarrant = false;
        String speedType = this._curSignalAspect != null ? this._curSignalAspect : this._engineer.getSpeedType(false);
        this.restoreRunning(speedType);
    }

    protected void setShareTOBlock(OBlock block, OBlock myBlock) {
        OBlock prevBlk = this._otherShareBlock;
        if (this._myShareBlock != null) {
            if (this._myShareBlock.equals(myBlock)) {
                return;
            }
            int idxBlock = this.getIndexOfBlock(myBlock, this._idxCurrentOrder);
            int idxStop = this.getIndexOfBlock(this._myShareBlock, this._idxCurrentOrder);
            if (idxStop < idxBlock && idxStop >= 0) {
                return;
            }
            this._otherShareBlock.removePropertyChangeListener(this);
        }
        this._myShareBlock = myBlock;
        this._otherShareBlock = block;
        this._otherShareBlock.addPropertyChangeListener(this);
        if (log.isDebugEnabled()) {
            String msg = "{}: sets _shareTOBlock= \"{}\" owned by warrant \"{}\"";
            if (prevBlk != null) {
                msg = String.valueOf(msg) + ", removes \"{}\"";
            }
            log.debug(msg, new Object[]{this.getDisplayName(), block.getDisplayName(), block.getWarrant(), prevBlk == null ? "" : prevBlk.getDisplayName()});
        }
    }

    private void setStoppingBlock(OBlock block) {
        if (block == null) {
            return;
        }
        int idxBlock = this.getIndexOfBlock(block, this._idxCurrentOrder);
        if (idxBlock < 0 || this._idxCurrentOrder == idxBlock && this._idxCurrentOrder > 0) {
            return;
        }
        OBlock prevBlk = this._stoppingBlock;
        if (this._stoppingBlock != null) {
            if (this._stoppingBlock.equals(block)) {
                return;
            }
            int idxStop = this.getIndexOfBlock(this._stoppingBlock, this._idxCurrentOrder);
            if (idxBlock < idxStop || idxStop < 0) {
                prevBlk.removePropertyChangeListener(this);
            } else {
                return;
            }
        }
        this._stoppingBlock = block;
        this._stoppingBlock.addPropertyChangeListener(this);
        log.info(Bundle.getMessage("StopBlockSet", this._stoppingBlock.getDisplayName(), this.getTrainName()));
        if (log.isDebugEnabled()) {
            String msg = "{}: sets _stoppingBlock= \"{}\"";
            if (prevBlk != null) {
                msg = String.valueOf(msg) + ", removes \"{}\"";
            }
            log.debug(msg, new Object[]{this.getDisplayName(), this._stoppingBlock.getDisplayName(), prevBlk == null ? "" : prevBlk.getDisplayName()});
        }
    }

    private boolean setStoppingSignal(int idx) {
        BlockOrder blkOrder = this.getBlockOrderAt(idx);
        NamedBean signal = blkOrder.getSignal();
        if (this._protectSignal != null && this._protectSignal.equals(signal)) {
            if (this._idxProtectSignal < idx && idx >= 0) {
                this._idxProtectSignal = idx;
            }
            return true;
        }
        if (this._protectSignal != null && idx > this._idxProtectSignal && this._idxProtectSignal > this._idxCurrentOrder) {
            return true;
        }
        return this.signalAddListener(signal, idx);
    }

    private boolean signalAddListener(NamedBean signal, int signalIndex) {
        if (signalIndex == this._idxProtectSignal) {
            return true;
        }
        StringBuffer sb = new StringBuffer(this.getDisplayName());
        if (this._protectSignal != null) {
            this._protectSignal.removePropertyChangeListener(this);
            if (log.isDebugEnabled()) {
                sb.append(" - removes signal \"");
                sb.append(this._protectSignal.getDisplayName());
                sb.append(" at \"");
                sb.append(this.getBlockAt(this._idxProtectSignal).getDisplayName());
                sb.append("\"");
            }
            this._protectSignal = null;
            this._idxProtectSignal = -1;
        }
        boolean ret = false;
        if (signal != null) {
            this._protectSignal = signal;
            this._idxProtectSignal = signalIndex;
            this._protectSignal.addPropertyChangeListener(this);
            if (log.isDebugEnabled()) {
                sb.append(" - sets signal \"");
                sb.append(this._protectSignal.getDisplayName());
                sb.append(" at \"");
                sb.append(this.getBlockAt(this._idxProtectSignal).getDisplayName());
                sb.append("\"");
            }
            ret = true;
        }
        if (log.isDebugEnabled()) {
            log.debug(sb.toString());
        }
        return ret;
    }

    @InvokeOnLayoutThread
    protected void goingActive(OBlock block) {
        int runState;
        if (log.isDebugEnabled() && !ThreadingUtil.isLayoutThread()) {
            log.error("invoked on wrong thread", (Throwable)new Exception("traceback"));
            this.stopWarrant(true, true);
            return;
        }
        if (this._runMode == 0) {
            return;
        }
        int activeIdx = this.getIndexOfBlock(block, this._idxCurrentOrder);
        if (log.isDebugEnabled()) {
            log.debug("{}: **Block \"{}\" goingActive. activeIdx= {}, _idxCurrentOrder= {}.", new Object[]{this.getDisplayName(), block.getDisplayName(), activeIdx, this._idxCurrentOrder});
        }
        if (activeIdx <= 0) {
            if (activeIdx == 0 && this._idxCurrentOrder == 0) {
                this.getBlockOrderAt(activeIdx).setPath(this);
                this.fireRunStatus("SpeedChange", null, activeIdx);
            }
            return;
        }
        if (this._engineer == null) {
            runState = -1;
            if (this._runMode == 2) {
                log.error("NoEngineer! warrant {}", (Object)this.getDisplayName());
                return;
            }
        } else {
            runState = this._engineer.getRunState();
        }
        if (activeIdx == this._idxCurrentOrder) {
            if (WarrantPreferences.getDefault().getTrace()) {
                log.info("{}: Train \"{}\" regained Detection at \"{}\"", new Object[]{this.getDisplayName(), this.getTrainName(), block.getDisplayName()});
            }
        } else if (activeIdx == this._idxCurrentOrder + 1) {
            if (this._delayStart) {
                log.warn("{}: Rogue entered Block \"{}\" ahead of {}.", new Object[]{this.getDisplayName(), block.getDisplayName(), this.getTrainName()});
                this._message = Bundle.getMessage("BlockRougeOccupied", block.getDisplayName());
                return;
            }
            this._message = this.getBlockOrderAt(activeIdx).setPath(this);
            if (this._message != null) {
                log.error("goingActive setPath fails: {}", (Object)this._message);
            }
            if (this._engineer != null && this._engineer.getSpeedSetting() <= 0.0f && runState != 9 && runState != 14 && runState != 6) {
                log.info("Train \"{}\" at speed 0, runState= {}, but block \"{}\" entered.", new Object[]{this.getTrainName(), RUN_STATE[runState], block.getDisplayName()});
                this.setStoppingBlock(block);
                this._waitForBlock = true;
                this._engineer.setSpeedToType(Stop);
                return;
            }
            this._idxLastOrder = this._idxCurrentOrder;
            this._idxCurrentOrder = activeIdx;
        } else if (activeIdx > this._idxCurrentOrder + 1) {
            if (this._runMode == 1) {
                log.error("Block \"{}\" became occupied before block \"{}\". ABORT recording.", (Object)block.getDisplayName(), (Object)this.getBlockAt(this._idxCurrentOrder + 1).getDisplayName());
                this.fireRunStatus("abortLearn", activeIdx, this._idxCurrentOrder);
                return;
            }
            int idx = this._idxCurrentOrder + 1;
            while (idx < activeIdx) {
                OBlock preBlock = this.getBlockAt(idx);
                if ((preBlock.getState() & 0x100) == 0) {
                    if (log.isDebugEnabled()) {
                        OBlock curBlock = this.getBlockAt(this._idxCurrentOrder);
                        log.debug("Rogue train entered block \"{}\" ahead of train {} currently in block \"{}\"!", new Object[]{block.getDisplayName(), this._trainName, curBlock.getDisplayName()});
                    }
                    return;
                }
                ++idx;
            }
            OBlock prevBlock = this.getBlockAt(activeIdx - 1);
            prevBlock._entryTime = System.currentTimeMillis() - 1000L;
            prevBlock.setValue(this._trainName);
            prevBlock.setState(prevBlock.getState() | 0x20);
            if (log.isDebugEnabled()) {
                log.debug("{}: Train leaving UNDETECTED block \"{}\" now entering block\"{}\"", new Object[]{this.getDisplayName(), prevBlock.getDisplayName(), block.getDisplayName()});
            }
        } else if (this._idxCurrentOrder > activeIdx) {
            log.info("Tail of Train {} regained detection behind Block= {} at block= {}", new Object[]{this.getTrainName(), block.getDisplayName(), this.getBlockAt(activeIdx).getDisplayName()});
            return;
        }
        this.setHeadOfTrain(block);
        if (this._engineer != null) {
            this._engineer.clearWaitForSync(block);
        }
        this.fireRunStatus("blockChange", this.getBlockAt(activeIdx - 1), block);
        if (this._idxCurrentOrder < this._orders.size() - 1) {
            this.allocateFromIndex(true, this._idxCurrentOrder + 1);
            if (this._engineer != null) {
                BlockOrder bo = this._orders.get(this._idxCurrentOrder + 1);
                if ((bo.getBlock().getState() & 0x100) != 0) {
                    this._engineer.setRunOnET(true);
                } else if (!this._tempRunBlind) {
                    this._engineer.setRunOnET(false);
                }
            }
        } else if (this._runMode == 3) {
            this.stopWarrant(false, true);
        }
        if (log.isTraceEnabled()) {
            log.debug("{}: end of goingActive. leaving \"{}\" entered \"{}\"", new Object[]{this.getDisplayName(), this.getBlockAt(activeIdx - 1).getDisplayName(), block.getDisplayName()});
        }
        this.setMovement(false);
    }

    private void setHeadOfTrain(OBlock block) {
        block.setValue(this._trainName);
        block.setState(block.getState() | 0x20);
        block._entryTime = System.currentTimeMillis();
        if (this._runMode == 2) {
            float length = 0.0f;
            if (this._idxCurrentOrder == 1 || this._idxCurrentOrder == this._orders.size() - 1) {
                BlockOrder bo = this.getBlockOrderAt(this._idxCurrentOrder - 1);
                length = bo.getPath().getLengthMm() / 2.0f;
            } else {
                int i = this._idxLastOrder;
                while (i < this._idxCurrentOrder) {
                    BlockOrder bo = this.getBlockOrderAt(i);
                    length += bo.getPath().getLengthMm();
                    ++i;
                }
            }
            this._speedUtil.leavingBlock(this.getBlockAt(this._idxCurrentOrder - 1), length);
        }
    }

    @InvokeOnLayoutThread
    protected void goingInactive(OBlock block) {
        if (log.isDebugEnabled() && !ThreadingUtil.isLayoutThread()) {
            log.error("invoked on wrong thread", (Throwable)new Exception("traceback"));
        }
        if (this._runMode == 0) {
            return;
        }
        int idx = this.getIndexOfBlockBefore(this._idxCurrentOrder, block);
        if (log.isDebugEnabled()) {
            log.debug("{}: *Block \"{}\" goingInactive. idx= {}, _idxCurrentOrder= {}.", new Object[]{this.getDisplayName(), block.getDisplayName(), idx, this._idxCurrentOrder});
        }
        if (idx < this._idxCurrentOrder) {
            this.releaseBlock(block, idx);
        } else if (idx == this._idxCurrentOrder) {
            if (this._idxCurrentOrder + 1 < this._orders.size()) {
                OBlock nextBlock = this.getBlockAt(this._idxCurrentOrder + 1);
                if ((nextBlock.getState() & 0x100) != 0) {
                    if (this._engineer != null) {
                        this.goingActive(nextBlock);
                        this.releaseBlock(block, idx);
                    } else if (this._runMode == 1) {
                        ++this._idxCurrentOrder;
                        this.fireRunStatus("blockChange", block, nextBlock);
                    } else if (this._runMode == 2) {
                        this.controlRunTrain(3);
                    }
                } else if ((nextBlock.getState() & 2) != 0 && (this._waitForBlock || this._waitForWarrant)) {
                    this.releaseBlock(block, idx);
                    this.setHeadOfTrain(nextBlock);
                    this.fireRunStatus("blockChange", block, nextBlock);
                    log.warn("block \"{}\" goingInactive. train has entered rogue occupied block {}! warrant {}", new Object[]{block.getDisplayName(), nextBlock.getDisplayName(), this.getDisplayName()});
                } else {
                    OBlock prevBlock;
                    boolean lost = true;
                    if (this._idxCurrentOrder > 0 && ((prevBlock = this.getBlockAt(this._idxCurrentOrder - 1)).getState() & 2) != 0 && this.equals(prevBlock.getWarrant())) {
                        --this._idxCurrentOrder;
                        prevBlock.allocate(this);
                        lost = false;
                    }
                    if (lost) {
                        log.warn("block \"{}\" goingInactive. train is lost! warrant {}", (Object)block.getDisplayName(), (Object)this.getDisplayName());
                        this.fireRunStatus("blockChange", block, null);
                        if (this._engineer != null) {
                            this._engineer.setSpeedToType(EStop);
                            if (this._idxCurrentOrder == 0) {
                                this.setStoppingBlock(block);
                                this._delayStart = true;
                            }
                        }
                    }
                }
            } else {
                OBlock prevBlock = this.getBlockAt(this._idxCurrentOrder - 1);
                if ((prevBlock.getState() & 2) != 0 && this.equals(prevBlock.getWarrant())) {
                    --this._idxCurrentOrder;
                    prevBlock.allocate(this);
                } else {
                    log.warn("block \"{}\" Last Block goingInactive. train is lost! warrant {}", (Object)block.getDisplayName(), (Object)this.getDisplayName());
                    if (this._engineer != null) {
                        this._engineer.setSpeedToType(Stop);
                    }
                }
            }
        }
    }

    private void releaseBlock(OBlock block, int idx) {
        if (this._partialAllocate) {
            int i = idx;
            while (i > -1) {
                OBlock prevBlock = this.getBlockAt(i);
                if (prevBlock.deAllocate(this)) {
                    if (prevBlock.equals(this._stoppingBlock)) {
                        this.doStoppingBlockClear();
                    }
                    this._totalAllocated = false;
                    --i;
                    continue;
                }
                break;
            }
        } else {
            int i = idx;
            while (i > -1) {
                boolean neededLater = false;
                OBlock prevBlock = this.getBlockAt(i);
                int j = i + 1;
                while (j < this._orders.size()) {
                    if (prevBlock.equals(this.getBlockAt(j))) {
                        neededLater = true;
                    }
                    ++j;
                }
                if (!neededLater) {
                    if (!prevBlock.deAllocate(this)) break;
                    if (prevBlock.equals(this._stoppingBlock)) {
                        this.doStoppingBlockClear();
                    }
                    this._totalAllocated = false;
                } else if (prevBlock.isAllocatedTo(this)) {
                    prevBlock.setValue(null);
                }
                --i;
            }
        }
    }

    private String getPermissibleSpeedAt(BlockOrder bo) {
        OBlock block = bo.getBlock();
        String speedType = bo.getPermissibleEntranceSpeed();
        if (speedType != null) {
            if (log.isDebugEnabled()) {
                log.debug("{}: getPermissibleSpeedAt(): \"{}\" Signal speed= {}", new Object[]{this.getDisplayName(), block.getDisplayName(), speedType});
            }
        } else {
            speedType = block.getBlockSpeed();
            if (speedType.equals("")) {
                speedType = null;
            }
            if (speedType != null && log.isDebugEnabled()) {
                log.debug("{}: getPermissibleSpeedAt(): \"{}\" Block speed= {}", new Object[]{this.getDisplayName(), block.getDisplayName(), speedType});
            }
        }
        return speedType;
    }

    private synchronized void cancelDelayRamp() {
        if (this._delayCommand != null) {
            this._delayCommand.interrupt();
            log.debug("{}: cancelDelayRamp called.", (Object)this.getDisplayName());
            this._delayCommand = null;
        }
    }

    @Override
    public void dispose() {
        this.stopWarrant(false, true);
        super.dispose();
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameWarrant");
    }

    private synchronized void endDelayCommand() {
        this._delayCommand = null;
    }

    private void clearWaitFlags(boolean removeListeners) {
        log.debug("{}: Flags cleared {}.", (Object)this.getDisplayName(), (Object)(removeListeners ? "and removed Listeners" : "only"));
        this._waitForBlock = false;
        this._waitForSignal = false;
        this._waitForWarrant = false;
        if (removeListeners) {
            if (this._protectSignal != null) {
                this._protectSignal.removePropertyChangeListener(this);
                this._protectSignal = null;
                this._idxProtectSignal = -1;
            }
            if (this._stoppingBlock != null) {
                this._stoppingBlock.removePropertyChangeListener(this);
                this._stoppingBlock = null;
            }
            if (this._otherShareBlock != null) {
                this._otherShareBlock.removePropertyChangeListener(this);
                this._otherShareBlock = null;
                this._myShareBlock = null;
            }
        }
    }

    private String getSpeedTypeForBlock(int idxBlockOrder, boolean okToAllocate) {
        BlockOrder blkOrder = this.getBlockOrderAt(idxBlockOrder);
        OBlock block = blkOrder.getBlock();
        String speedType = this.getPermissibleSpeedAt(blkOrder);
        if (Stop.equals(speedType)) {
            this._waitForSignal = true;
            if (this._partialAllocate) {
                okToAllocate = false;
            }
        }
        if (okToAllocate) {
            this._message = block.allocate(this);
        }
        if (this._message != null) {
            Warrant w = block.getWarrant();
            if (w != null && !this.equals(w)) {
                this._waitForWarrant = true;
            } else {
                this._waitForBlock = true;
            }
            speedType = Stop;
        }
        if ((block.getState() & 2) != 0 && idxBlockOrder > this._idxCurrentOrder) {
            this._waitForBlock = true;
            speedType = Stop;
        }
        if (!Stop.equals(speedType) && okToAllocate) {
            this._message = blkOrder.setPath(this);
            if (this._message != null) {
                this._waitForWarrant = true;
                speedType = Stop;
                log.warn(this._message);
            }
        }
        if (log.isDebugEnabled() && (this._waitForSignal || this._waitForBlock || this._waitForWarrant)) {
            log.debug("{}: \"{}\" speed change of type \"{}\" needed to enter block \"{}\".", new Object[]{this.getDisplayName(), this._waitForSignal ? "Signal" : (this._waitForWarrant ? "Warrant" : "Block"), speedType, block.getDisplayName()});
        }
        return speedType;
    }

    private float getAvailableDistanceAt(int idxBlockOrder) {
        BlockOrder blkOrder = this.getBlockOrderAt(idxBlockOrder);
        float pathLength = blkOrder.getPath().getLengthMm();
        if (idxBlockOrder == 0 || pathLength <= 1.0f) {
            float blkDist = this._speedUtil.getBlockSpeedInfo(idxBlockOrder).getDistance();
            if (log.isDebugEnabled()) {
                log.debug("{}: getAvailableDistanceAt: block \"{}\" using calculated blkDist= {}, pathLength= {}", new Object[]{this.getDisplayName(), blkOrder.getBlock().getDisplayName(), Float.valueOf(blkDist), Float.valueOf(pathLength)});
            }
            return blkDist;
        }
        return pathLength;
    }

    private float getRampLengthForEntry(float scriptSpeed, float endSpeed) {
        String speedType = this._engineer.getSpeedType(false);
        float currentSpeed = this._speedUtil.modifySpeed(scriptSpeed, speedType);
        RampData ramp = this._speedUtil.getRampForSpeedChange(currentSpeed, endSpeed);
        float enterLen = ramp.getRampLength(speedType);
        if (log.isTraceEnabled()) {
            log.debug("{}: getRampLengthForEntry: from speed={} to speed={}. rampLen={}", new Object[]{this.getDisplayName(), Float.valueOf(scriptSpeed), Float.valueOf(endSpeed), Float.valueOf(enterLen)});
        }
        return enterLen;
    }

    private float getEntranceBufferDist(int idxBlockOrder) {
        float bufDist = 9144.0f / WarrantPreferences.getDefault().getLayoutScale();
        if (this._waitForSignal) {
            bufDist += this.getBlockOrderAt(idxBlockOrder).getEntranceSpace();
        }
        return bufDist;
    }

    private boolean setMovement(boolean signalChange) {
        float timeRatio;
        float trackSpeed;
        float modSetting;
        float scriptSpeed;
        if (this._runMode != 2 || this._idxCurrentOrder > this._orders.size() - 1) {
            return false;
        }
        if (this._engineer == null) {
            this.controlRunTrain(3);
            return false;
        }
        int runState = this._engineer.getRunState();
        BlockOrder blkOrder = this.getBlockOrderAt(this._idxCurrentOrder);
        OBlock curBlock = blkOrder.getBlock();
        String currentSpeedType = this._engineer.getSpeedType(true);
        if (log.isDebugEnabled()) {
            log.debug("{}: SET MOVEMENT Block\"{}\" runState= {}, currentSpeedType= {}. {}.", new Object[]{this.getDisplayName(), curBlock.getDisplayName(), RUN_STATE[runState], currentSpeedType, this._partialAllocate ? "ShareRoute" : ""});
        }
        this._message = blkOrder.setPath(this);
        if (this._message != null) {
            log.error("Train {} in block \"{}\" but path cannot be set! msg= {}, warrant {}", new Object[]{this.getTrainName(), curBlock.getDisplayName(), this._message, this.getDisplayName()});
            this._engineer.setSpeedToType(Stop);
            return false;
        }
        if ((curBlock.getState() & 0x102) == 0) {
            log.error("Train {} expected in block \"{}\" but block is unoccupied! warrant {}", new Object[]{this.getTrainName(), curBlock.getDisplayName(), this.getDisplayName()});
            this._engineer.setSpeedToType(Stop);
            return false;
        }
        float speedSetting = this._engineer.getSpeedSetting();
        if (log.isDebugEnabled()) {
            log.debug("{}: Stopping flags: _waitForBlock={}, _waitForSignal={}, _waitForWarrant={} runState= {}, speedSetting= {}, speedType= {}.", new Object[]{this.getDisplayName(), this._waitForBlock, this._waitForSignal, this._waitForWarrant, RUN_STATE[runState], Float.valueOf(speedSetting), currentSpeedType});
        }
        if (this._noRamp) {
            String entrySpeedType;
            if (this._idxCurrentOrder < this._orders.size() - 1 && (entrySpeedType = this.getSpeedTypeForBlock(this._idxCurrentOrder + 1, true)) != null && this._speedUtil.secondGreaterThanFirst(entrySpeedType, currentSpeedType)) {
                if (log.isDebugEnabled()) {
                    log.debug("{}: No ramp speed change of \"{}\" from \"{}\" in block \"{}\"", new Object[]{this.getDisplayName(), entrySpeedType, currentSpeedType, curBlock.getDisplayName()});
                }
                this._engineer.setSpeedToType(entrySpeedType);
            }
            if (log.isDebugEnabled()) {
                log.debug("{}: Exit setMovement due to no ramping.", (Object)this.getDisplayName());
            }
            return true;
        }
        String entrySpeedType = this.getPermissibleSpeedAt(blkOrder);
        if (this._speedUtil.secondGreaterThanFirst(currentSpeedType, entrySpeedType) && !this._engineer.isRamping()) {
            this.restoreRunning(entrySpeedType);
        }
        if (this._idxCurrentOrder == this._orders.size() - 1) {
            return true;
        }
        this.clearWaitFlags(false);
        String speedType = currentSpeedType;
        int idxSpeedChange = this._idxCurrentOrder;
        while (!this._speedUtil.secondGreaterThanFirst(speedType, currentSpeedType) && idxSpeedChange < this._orders.size() - 1) {
            String s;
            if ((s = this.getSpeedTypeForBlock(++idxSpeedChange, false)) == null) continue;
            speedType = s;
        }
        OBlock block = this.getBlockAt(idxSpeedChange);
        if (this._waitForBlock || this._waitForWarrant) {
            this.setStoppingBlock(block);
        }
        float availDist = this.getAvailableDistance(idxSpeedChange);
        float changeDist = this.getEntranceDistance(speedSetting, idxSpeedChange, speedType);
        if (log.isDebugEnabled()) {
            log.debug("{}: Speed \"{}\" at block \"{}\" until speed \"{}\" at block \"{}\", availDist={}, enterDist={}", new Object[]{this.getDisplayName(), currentSpeedType, curBlock.getDisplayName(), speedType, block.getDisplayName(), Float.valueOf(availDist), Float.valueOf(changeDist)});
        }
        if (changeDist <= availDist) {
            int i = this._idxCurrentOrder + 1;
            while (i < this._orders.size() - 1) {
                if (this.setStoppingSignal(i)) break;
                ++i;
            }
            this.clearWaitFlags(false);
            return true;
        }
        if (this._waitForSignal) {
            this.setStoppingSignal(idxSpeedChange);
        } else {
            int i = this._idxCurrentOrder + 1;
            while (i < this._orders.size() - 1) {
                if (this.setStoppingSignal(i)) break;
                ++i;
            }
        }
        if (currentSpeedType.equals(speedType)) {
            return true;
        }
        float curAvail = this.getAvailableDistanceAt(this._idxCurrentOrder);
        if (signalChange && (curAvail -= this._speedUtil.getDistanceTravelled()) < 0.0f) {
            curAvail = 0.0f;
        }
        if (changeDist > (availDist += curAvail)) {
            log.warn("No room for train {} to ramp to speed \"{}\" in block \"{}\"!. availDist={}, enterDist={} on warrant {}", new Object[]{this.getTrainName(), speedType, curBlock.getDisplayName(), Float.valueOf(availDist), Float.valueOf(changeDist), this.getDisplayName()});
            this._engineer.rampSpeedTo(speedType, idxSpeedChange - 1);
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("{}: Speed decrease to \"{}\" from {} needed before entering block \"{}\", availDist={}, enterDist={}", new Object[]{this.getDisplayName(), speedType, currentSpeedType, block.getDisplayName(), Float.valueOf(availDist), Float.valueOf(changeDist)});
        }
        BlockSpeedInfo blkSpeedInfo = this._speedUtil.getBlockSpeedInfo(this._idxCurrentOrder);
        int cmdIdx = blkSpeedInfo.getFirstIndex();
        int endIdx = this._speedUtil.getBlockSpeedInfo(idxSpeedChange - 1).getLastIndex();
        if (this._idxCurrentOrder == 0) {
            scriptSpeed = 0.0f;
            modSetting = 0.0f;
            trackSpeed = 0.0f;
            timeRatio = 1.0f;
            changeDist = 0.0f;
        } else {
            scriptSpeed = blkSpeedInfo.getEntranceSpeed();
            modSetting = this._speedUtil.modifySpeed(scriptSpeed, currentSpeedType);
            trackSpeed = this._speedUtil.getTrackSpeed(modSetting);
            timeRatio = this._speedUtil.getTrackSpeed(scriptSpeed) / trackSpeed;
        }
        if (log.isDebugEnabled()) {
            log.debug("cmdIdx #{} to #{} at speedType \"{}\" modScriptSetting={} speedSetting={}, timeRatio={}", new Object[]{cmdIdx + 1, endIdx + 1, currentSpeedType, Float.valueOf(modSetting), Float.valueOf(speedSetting), Float.valueOf(timeRatio)});
        }
        float accumTime = 0.0f;
        float accumDist = 0.0f;
        float remDist = availDist - changeDist;
        float deltaTime = trackSpeed > 0.0f ? remDist / trackSpeed : 100.0f;
        int i = cmdIdx;
        while (i <= endIdx) {
            ThrottleSetting ts = this._commands.get(i);
            accumDist += trackSpeed * (float)ts.getTime() * timeRatio;
            accumTime += (float)ts.getTime() * timeRatio;
            if (changeDist + accumDist >= availDist) {
                float overDist = changeDist + accumDist - availDist;
                if (trackSpeed <= 0.0f) {
                    log.error("Cannot ramp to \"{}\". trackSpeed= {} in block \"{}\".", new Object[]{speedType, Float.valueOf(trackSpeed), curBlock.getDisplayName()});
                }
                deltaTime = accumTime -= overDist / trackSpeed;
                break;
            }
            ThrottleSetting.CommandValue cmdVal = ts.getValue();
            if (cmdVal.getType().equals((Object)ThrottleSetting.ValueType.VAL_FLOAT)) {
                scriptSpeed = cmdVal.getFloat();
                changeDist = this.getEntranceDistance(scriptSpeed, idxSpeedChange, speedType);
                modSetting = this._speedUtil.modifySpeed(scriptSpeed, currentSpeedType);
                trackSpeed = this._speedUtil.getTrackSpeed(modSetting);
                timeRatio = this._speedUtil.getTrackSpeed(scriptSpeed) / trackSpeed;
            }
            log.debug("{}: cmd#{} accumTime= {} accumDist= {} changeDist= {}", new Object[]{this.getDisplayName(), i + 1, Float.valueOf(accumTime), Float.valueOf(accumDist), Float.valueOf(changeDist)});
            ++i;
        }
        int waitTime = Math.round(deltaTime);
        if (log.isDebugEnabled()) {
            log.debug("{}: RAMP waitTime={}, waitThrottle={}, availDist={}, enterLen={} for ramp start", new Object[]{this.getDisplayName(), waitTime, Float.valueOf(modSetting), Float.valueOf(availDist), Float.valueOf(changeDist)});
        }
        this.rampSpeedDelay(waitTime -= 50, speedType, modSetting, idxSpeedChange - 1);
        return true;
    }

    private synchronized void rampSpeedDelay(long waitTime, String speedType, float waitSpeed, int endBlockIdx) {
        if (this._delayCommand != null) {
            if (this._delayCommand.isDuplicate(speedType, waitTime, endBlockIdx)) {
                return;
            }
            this.cancelDelayRamp();
        }
        if (waitTime <= 0L) {
            this._engineer.rampSpeedTo(speedType, endBlockIdx);
        } else {
            this._delayCommand = new CommandDelay(speedType, waitTime, waitSpeed, endBlockIdx);
            this._delayCommand.start();
            if (log.isDebugEnabled()) {
                log.debug("{}: CommandDelay: will wait {}ms, then Ramp to {} in block {}.", new Object[]{this.getDisplayName(), waitTime, speedType, this.getBlockAt(endBlockIdx).getDisplayName()});
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Warrant) {
            Warrant b = (Warrant)obj;
            DccLocoAddress addr = this._speedUtil.getDccAddress();
            if (addr == null) {
                if (b._speedUtil.getDccAddress() != null) {
                    return false;
                }
                return this.getSystemName().equals(b.getSystemName());
            }
            return this.getSystemName().equals(b.getSystemName()) && addr.equals(b._speedUtil.getDccAddress());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getSystemName().concat(this._speedUtil.getDccAddress().toString()).hashCode();
    }

    @Override
    public List<NamedBeanUsageReport> getUsageReport(NamedBean bean) {
        ArrayList<NamedBeanUsageReport> report = new ArrayList<NamedBeanUsageReport>();
        if (bean != null) {
            if (bean.equals(this.getBlockingWarrant())) {
                report.add(new NamedBeanUsageReport("WarrantBlocking"));
            }
            this.getBlockOrders().forEach(blockOrder -> {
                if (bean.equals(blockOrder.getBlock())) {
                    report.add(new NamedBeanUsageReport("WarrantBlock"));
                }
                if (bean.equals(blockOrder.getSignal())) {
                    report.add(new NamedBeanUsageReport("WarrantSignal"));
                }
            });
        }
        return report;
    }

    private class CommandDelay
    extends Thread {
        String nextSpeedType;
        long _startTime = 0L;
        long _waitTime = 0L;
        float _waitSpeed;
        boolean quit = false;
        int _endBlockIdx;

        CommandDelay(String speedType, long startWait, float waitSpeed, int endBlockIdx) {
            this.nextSpeedType = speedType;
            this._waitTime = startWait;
            this._waitSpeed = waitSpeed;
            this._endBlockIdx = endBlockIdx;
            this.setName("CommandDelay(" + Warrant.this.getTrainName() + ")");
        }

        boolean isDuplicate(String speedType, long startWait, int endBlockIdx) {
            return endBlockIdx == this._endBlockIdx && speedType.equals(this.nextSpeedType) && this._waitTime - (System.currentTimeMillis() - this._startTime) < startWait;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressFBWarnings(value={"WA_NOT_IN_LOOP"}, justification="notify never called on this thread")
        public void run() {
            CommandDelay commandDelay = this;
            synchronized (commandDelay) {
                this._startTime = System.currentTimeMillis();
                boolean ramping = Warrant.this._engineer.isRamping();
                if (ramping) {
                    long time = 0L;
                    while (time <= this._waitTime) {
                        if (Warrant.this._engineer.getSpeedSetting() > this._waitSpeed) break;
                        try {
                            this.wait(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            if (log.isDebugEnabled()) {
                                log.debug("CommandDelay interrupt.  Ramp to {} not done. warrant {}", (Object)this.nextSpeedType, (Object)Warrant.this.getDisplayName());
                            }
                            this.quit = true;
                        }
                        time += 50L;
                    }
                } else {
                    try {
                        this.wait(this._waitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        if (log.isDebugEnabled()) {
                            log.debug("CommandDelay interrupt.  Ramp to {} not done. warrant {}", (Object)this.nextSpeedType, (Object)Warrant.this.getDisplayName());
                        }
                        this.quit = true;
                    }
                }
                if (!this.quit && Warrant.this._engineer != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("{}: CommandDelay: after wait of {}ms, start Ramp to {}.", new Object[]{Warrant.this.getDisplayName(), this._waitTime, this.nextSpeedType});
                    }
                    Warrant.this._engineer.rampSpeedTo(this.nextSpeedType, this._endBlockIdx);
                }
            }
            Warrant.this.endDelayCommand();
        }
    }
}

