/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.implementation.AbstractInstanceInitializer;
import jmri.jmrit.display.LocoIcon;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.Tracker;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.logix.WarrantTableAction;
import jmri.jmrit.picker.PickListModel;
import jmri.jmrit.picker.PickPanel;
import jmri.util.DnDTableExportHandler;
import jmri.util.JmriJFrame;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackerTableAction
extends AbstractAction
implements PropertyChangeListener {
    static int STRUT_SIZE = 10;
    private final ArrayList<Tracker> _trackerList = new ArrayList();
    private final HashMap<OBlock, ArrayList<Tracker>> _trackerBlocks = new HashMap();
    protected TableFrame _frame;
    private ChooseTracker _trackerChooser;
    private boolean _requirePaths;
    private static final Logger log = LoggerFactory.getLogger(TrackerTableAction.class);

    private TrackerTableAction(String menuOption) {
        super(menuOption);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._frame != null) {
            this._frame.setVisible(true);
        } else {
            this._frame = new TableFrame();
        }
    }

    public synchronized boolean mouseClickedOnBlock(OBlock block) {
        if (this._frame != null) {
            return this._frame.mouseClickedOnBlock(block);
        }
        return false;
    }

    public boolean markNewTracker(OBlock block, String name, LocoIcon marker) {
        if (this._frame == null) {
            this._frame = new TableFrame();
        }
        if (name == null && marker != null) {
            name = marker.getUnRotatedText();
        }
        return this.makeTracker(block, name, marker);
    }

    private boolean makeTracker(OBlock block, String name, LocoIcon marker) {
        String msg = null;
        if ((block.getState() & 2) == 0) {
            msg = Bundle.getMessage("blockUnoccupied", block.getDisplayName());
        } else if (name == null || name.length() == 0) {
            msg = Bundle.getMessage("noTrainName");
        } else if (this.nameInuse(name)) {
            msg = Bundle.getMessage("duplicateName", name);
        } else {
            Tracker t = this.findTrackerIn(block);
            if (t != null && !name.equals(block.getValue())) {
                msg = Bundle.getMessage("blockInUse", t.getTrainName(), block.getDisplayName());
            } else {
                Warrant w = block.getWarrant();
                if (w != null) {
                    msg = Bundle.getMessage("AllocatedToWarrant", w.getDisplayName(), block.getDisplayName(), w.getTrainName());
                }
            }
        }
        if (msg != null) {
            JOptionPane.showMessageDialog(this._frame, msg, Bundle.getMessage("WarningTitle"), 2);
            return false;
        }
        block.setValue(name);
        new Tracker(block, name, marker, this);
        return true;
    }

    @Deprecated
    public Tracker addTracker(OBlock block, String name) {
        this.markNewTracker(block, name, null);
        return this.findTrackerIn(block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTracker(Tracker t) {
        TrackerTableAction trackerTableAction = this;
        synchronized (trackerTableAction) {
            this._trackerList.add(t);
        }
        this.addBlockListeners(t);
        if (this._frame == null) {
            this._frame = new TableFrame();
        }
        this._frame._model.fireTableDataChanged();
        this._frame.setStatus(Bundle.getMessage("startTracker", t.getTrainName(), t.getHeadBlock().getDisplayName()));
    }

    protected boolean checkBlock(OBlock b) {
        if (this.findTrackerIn(b) == null && b.getWarrant() == null) {
            b.setValue(null);
            return true;
        }
        return false;
    }

    boolean nameInuse(String name) {
        for (Tracker t : this._trackerList) {
            if (!name.equals(t.getTrainName())) continue;
            return true;
        }
        return false;
    }

    public void stopTracker(Tracker t, OBlock b) {
        if (this._frame == null) {
            this._frame = new TableFrame();
        }
        this.stopTrain(t, b);
    }

    protected void setStatus(String msg) {
        this._frame.setStatus(msg);
    }

    public Tracker findTrackerIn(OBlock b) {
        for (Tracker t : this._trackerList) {
            if (!t.getBlocksOccupied().contains(b)) continue;
            return t;
        }
        return null;
    }

    public void updateStatus() {
        this._frame._model.fireTableDataChanged();
    }

    protected void addBlockListeners(Tracker tracker) {
        List<OBlock> range = tracker.makeRange();
        for (OBlock oBlock : range) {
            this.addBlockListener(oBlock, tracker);
        }
    }

    private void addBlockListener(OBlock block, Tracker tracker) {
        ArrayList<Tracker> trackers = this._trackerBlocks.get(block);
        if (trackers == null) {
            trackers = new ArrayList();
            trackers.add(tracker);
            if ((block.getState() & 0x100) == 0) {
                this._trackerBlocks.put(block, trackers);
                block.addPropertyChangeListener(this);
            }
        } else {
            if (trackers.isEmpty() && (block.getState() & 0x100) == 0) {
                block.addPropertyChangeListener(this);
            }
            if (!trackers.contains(tracker)) {
                trackers.add(tracker);
            }
        }
    }

    private void adjustBlockListeners(List<OBlock> oldRange, List<OBlock> newRange, Tracker tracker) {
        for (OBlock b : newRange) {
            if (oldRange.contains(b)) {
                oldRange.remove(b);
                continue;
            }
            this.addBlockListener(b, tracker);
        }
        for (OBlock b : oldRange) {
            this.removeBlockListener(b, tracker);
        }
    }

    protected void removeBlockListeners(Tracker tracker) {
        for (OBlock block : this._trackerBlocks.keySet()) {
            this.removeBlockListener(block, tracker);
        }
    }

    private void removeBlockListener(OBlock block, Tracker tracker) {
        List trackers = this._trackerBlocks.get(block);
        if (trackers != null) {
            trackers.remove(tracker);
            if (trackers.isEmpty()) {
                block.removePropertyChangeListener(this);
            }
        }
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("state")) {
            int oldState;
            OBlock block = (OBlock)evt.getSource();
            int state = ((Number)evt.getNewValue()).intValue();
            if ((state & 4) == ((oldState = ((Number)evt.getOldValue()).intValue()) & 4) && (state & 2) == (oldState & 2)) {
                return;
            }
            ArrayList<Tracker> trackerListeners = this._trackerBlocks.get(block);
            if (trackerListeners == null || trackerListeners.isEmpty()) {
                log.error("No Trackers found for block \"{}\" going to state= {}", (Object)block.getDisplayName(), (Object)state);
                block.removePropertyChangeListener(this);
                return;
            }
            if ((state & 2) != 0) {
                List<Tracker> trackers = this.getAvailableTrackers(block);
                if (trackers.isEmpty()) {
                    return;
                }
                if (trackers.size() > 1) {
                    if (this._trackerChooser != null) {
                        this._trackerChooser.dispose();
                    }
                    Toolkit.getDefaultToolkit().beep();
                    this._trackerChooser = new ChooseTracker(block, trackers, state);
                    return;
                }
                Tracker tracker = trackers.get(0);
                if (block.getValue() != null && !block.getValue().equals(tracker.getTrainName())) {
                    log.error("Block \"{} \" going active with value= {} for Tracker {}! Who/What is \"{}\"?", new Object[]{block.getDisplayName(), block.getValue(), tracker.getTrainName(), block.getValue()});
                    return;
                }
                if (!this._requirePaths) {
                    try {
                        tracker.hasPathInto(block);
                    }
                    catch (JmriException je) {
                        log.error("{} {}", (Object)tracker.getTrainName(), (Object)je.getMessage());
                        return;
                    }
                }
                this.processTrackerStateChange(tracker, block, state);
            } else if ((state & 4) != 0) {
                if (this._trackerChooser != null) {
                    this._trackerChooser.checkClose(block);
                }
                for (Tracker t : trackerListeners) {
                    if (!t.getBlocksOccupied().contains(block)) continue;
                    this.processTrackerStateChange(t, block, state);
                    break;
                }
            }
        }
        this._frame._model.fireTableDataChanged();
    }

    private List<Tracker> getAvailableTrackers(OBlock block) {
        ArrayList<Object> trackers = new ArrayList();
        ArrayList<Tracker> trackerListeners = this._trackerBlocks.get(block);
        if (this._requirePaths) {
            ArrayList<Tracker> partials = new ArrayList<Tracker>();
            for (Tracker t : trackerListeners) {
                try {
                    switch (t.hasPathInto(block)) {
                        case SET: {
                            trackers.add(t);
                            break;
                        }
                        case PARTIAL: {
                            partials.add(t);
                            break;
                        }
                    }
                }
                catch (JmriException je) {
                    log.error("{} {}", (Object)t.getTrainName(), (Object)je.getMessage());
                }
            }
            if (trackers.isEmpty()) {
                trackers = !partials.isEmpty() ? partials : trackerListeners;
            }
        } else {
            trackers = trackerListeners;
        }
        return trackers;
    }

    private synchronized void processTrackerStateChange(Tracker tracker, OBlock block, int state) {
        List<OBlock> oldRange = tracker.makeRange();
        if (tracker.move(block, state)) {
            if (tracker._statusMessage != null) {
                this._frame.setStatus(tracker._statusMessage);
            } else {
                block._entryTime = System.currentTimeMillis();
                this.adjustBlockListeners(oldRange, tracker.makeRange(), tracker);
                this._frame.setStatus(Bundle.getMessage("TrackerBlockEnter", tracker.getTrainName(), block.getDisplayName()));
            }
        } else if (tracker._statusMessage != null) {
            this._frame.setStatus(tracker._statusMessage);
        } else if (this._trackerList.contains(tracker)) {
            this.adjustBlockListeners(oldRange, tracker.makeRange(), tracker);
            long et = (System.currentTimeMillis() - block._entryTime) / 1000L;
            this._frame.setStatus(Bundle.getMessage("TrackerBlockLeave", tracker.getTrainName(), block.getDisplayName(), et / 60L, et % 60L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopTrain(Tracker t, OBlock b) {
        t.stop();
        this.removeBlockListeners(t);
        TrackerTableAction trackerTableAction = this;
        synchronized (trackerTableAction) {
            this._trackerList.remove(t);
        }
        long et = (System.currentTimeMillis() - t._startTime) / 1000L;
        String location = b != null ? b.getDisplayName() : Bundle.getMessage("BeanStateUnknown");
        this._frame.setStatus(Bundle.getMessage("TrackerStopped", t.getTrainName(), location, et / 60L, et % 60L));
        this._frame._model.fireTableDataChanged();
    }

    /* synthetic */ TrackerTableAction(String string, TrackerTableAction trackerTableAction) {
        this(string);
    }

    class ChooseTracker
    extends JDialog
    implements ListSelectionListener {
        OBlock block;
        List<Tracker> trackers;
        int state;
        JList<Tracker> _jList;

        ChooseTracker(OBlock b, List<Tracker> ts, int s) {
            super(TrackerTableAction.this._frame);
            this.setTitle(Bundle.getMessage("TrackerTitle"));
            this.block = b;
            this.trackers = ts;
            this.state = s;
            JPanel contentPanel = new JPanel();
            contentPanel.setLayout(new BoxLayout(contentPanel, 1));
            contentPanel.add(Box.createVerticalStrut(STRUT_SIZE));
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            panel.add(new JLabel(Bundle.getMessage("MultipleTrackers", this.block.getDisplayName())));
            panel.add(new JLabel(Bundle.getMessage("ChooseTracker", this.block.getDisplayName())));
            JPanel p = new JPanel();
            p.add(panel);
            contentPanel.add(p);
            panel = new JPanel();
            panel.setBorder(BorderFactory.createLineBorder(Color.black, 2));
            this._jList = new JList();
            this._jList.setModel(new TrackerListModel());
            this._jList.setSelectionMode(0);
            this._jList.addListSelectionListener(this);
            panel.add(this._jList);
            p = new JPanel();
            p.add(panel);
            contentPanel.add(p);
            contentPanel.add(Box.createVerticalStrut(STRUT_SIZE));
            panel = new JPanel();
            JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
            cancelButton.addActionListener(a -> this.dispose());
            panel.add(cancelButton);
            contentPanel.add(panel);
            this.setContentPane(contentPanel);
            this.pack();
            this.setLocation(TrackerTableAction.this._frame.getLocation());
            this.setAlwaysOnTop(true);
            this.setVisible(true);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Tracker tr = this._jList.getSelectedValue();
            if (tr != null) {
                TrackerTableAction.this.processTrackerStateChange(tr, this.block, this.state);
                this.dispose();
            }
        }

        void checkClose(OBlock b) {
            if (this.block.equals(b)) {
                this.dispose();
            }
        }

        class TrackerListModel
        extends AbstractListModel<Tracker> {
            TrackerListModel() {
            }

            @Override
            public int getSize() {
                return ChooseTracker.this.trackers.size();
            }

            @Override
            public Tracker getElementAt(int index) {
                return ChooseTracker.this.trackers.get(index);
            }
        }
    }

    public static class Initializer
    extends AbstractInstanceInitializer {
        @Override
        @Nonnull
        public <T> Object getDefault(Class<T> type) {
            if (type.equals(TrackerTableAction.class)) {
                return new TrackerTableAction(Bundle.getMessage("MenuTrackers"), null);
            }
            return super.getDefault(type);
        }

        @Override
        @Nonnull
        public Set<Class<?>> getInitalizes() {
            Set<Class<?>> set = super.getInitalizes();
            set.add(TrackerTableAction.class);
            return set;
        }
    }

    class TableFrame
    extends JmriJFrame
    implements MouseListener {
        private final TrackerTableModel _model;
        private JmriJFrame _pickFrame;
        JDialog _dialog;
        JTextField _trainNameBox;
        JTextField _trainLocationBox;
        JTextField _status;
        ArrayList<String> _statusHistory;
        public int _maxHistorySize;

        TableFrame() {
            super(true, true);
            this._trainNameBox = new JTextField(30);
            this._trainLocationBox = new JTextField(30);
            this._status = new JTextField(80);
            this._statusHistory = new ArrayList();
            this._maxHistorySize = 20;
            this.setTitle(Bundle.getMessage("TrackerTable"));
            this._model = new TrackerTableModel();
            JTable table = new JTable(this._model);
            TableRowSorter<TrackerTableModel> sorter = new TableRowSorter<TrackerTableModel>(this._model);
            table.setRowSorter(sorter);
            table.getColumnModel().getColumn(2).setCellEditor(new ButtonEditor(new JButton()));
            table.getColumnModel().getColumn(2).setCellRenderer(new ButtonRenderer());
            int i = 0;
            while (i < this._model.getColumnCount()) {
                int width = this._model.getPreferredWidth(i);
                table.getColumnModel().getColumn(i).setPreferredWidth(width);
                ++i;
            }
            table.setDragEnabled(true);
            table.setTransferHandler(new DnDTableExportHandler());
            JScrollPane tablePane = new JScrollPane(table);
            Dimension dim = table.getPreferredSize();
            int height = new JButton((String)"STOPIT").getPreferredSize().height;
            dim.height = height * 2;
            tablePane.getViewport().setPreferredSize(dim);
            JPanel tablePanel = new JPanel();
            tablePanel.setLayout(new BoxLayout(tablePanel, 1));
            JLabel title = new JLabel(Bundle.getMessage("TrackerTable"));
            tablePanel.add((Component)title, "North");
            tablePanel.add((Component)tablePane, "Center");
            JPanel panel = new JPanel();
            JPanel p = new JPanel();
            p.add(new JLabel(Bundle.getMessage("lastEvent")));
            p.add(this._status);
            this._status.setEditable(false);
            this._status.setBackground(Color.white);
            this._status.addMouseListener(this);
            panel.add(p);
            tablePanel.add((Component)this.makeButtonPanel(), "Center");
            tablePanel.add((Component)panel, "Center");
            this.setContentPane(tablePanel);
            JMenuBar menuBar = new JMenuBar();
            JMenu optionMenu = new JMenu(Bundle.getMessage("MenuMoreOptions"));
            optionMenu.add(this.makePathRequirement());
            JMenuItem pickerMenu = new JMenuItem(Bundle.getMessage("MenuBlockPicker"));
            pickerMenu.addActionListener(a -> this.openPickList());
            optionMenu.add(pickerMenu);
            optionMenu.add(WarrantTableAction.getDefault().makeLogMenu());
            menuBar.add(optionMenu);
            this.setJMenuBar(menuBar);
            this.addHelpMenu("package.jmri.jmrit.logix.Tracker", true);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    TableFrame.this.setDefaultCloseOperation(1);
                    if (TableFrame.this._pickFrame != null) {
                        TableFrame.this._pickFrame.dispose();
                    }
                    TableFrame.this._model.fireTableDataChanged();
                }
            });
            this.setLocation(0, 100);
            this.setVisible(true);
            this.pack();
        }

        private JPanel makeButtonPanel() {
            JPanel panel = new JPanel();
            JButton button = new JButton(Bundle.getMessage("MenuNewTracker", "..."));
            button.addActionListener(a -> this.newTrackerDialog());
            panel.add(button);
            button = new JButton(Bundle.getMessage("MenuRefresh"));
            button.addActionListener(a -> this._model.fireTableDataChanged());
            panel.add(button);
            return panel;
        }

        private JMenuItem makePathRequirement() {
            JMenu pathkMenu = new JMenu(Bundle.getMessage("MenuPathRanking"));
            ButtonGroup pathButtonGroup = new ButtonGroup();
            JRadioButtonMenuItem r = new JRadioButtonMenuItem(Bundle.getMessage("showAllTrackers"));
            r.addActionListener(e -> {
                boolean bl = false;
                TrackerTableAction.this._requirePaths = false;
            });
            pathButtonGroup.add(r);
            r.setSelected(!TrackerTableAction.this._requirePaths);
            pathkMenu.add(r);
            r = new JRadioButtonMenuItem(Bundle.getMessage("showMostLikely"));
            r.addActionListener(e -> {
                boolean bl = true;
                TrackerTableAction.this._requirePaths = true;
            });
            pathButtonGroup.add(r);
            r.setSelected(TrackerTableAction.this._requirePaths);
            pathkMenu.add(r);
            return pathkMenu;
        }

        protected boolean mouseClickedOnBlock(OBlock block) {
            if (this._dialog != null) {
                if ((block.getState() & 2) != 0 && block.getValue() != null) {
                    TrackerTableAction.this.markNewTracker(block, (String)block.getValue(), null);
                    return true;
                }
                this._trainLocationBox.setText(block.getDisplayName());
                if (block.getValue() != null) {
                    this._trainNameBox.setText((String)block.getValue());
                }
                return true;
            }
            return false;
        }

        private void newTrackerDialog() {
            this._dialog = new JDialog(this, Bundle.getMessage("MenuNewTracker", ""), false);
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout(10, 10));
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new BoxLayout(mainPanel, 1));
            mainPanel.add(Box.createVerticalStrut(STRUT_SIZE));
            JPanel p = new JPanel();
            p.add(new JLabel(Bundle.getMessage("createTracker")));
            mainPanel.add(p);
            mainPanel.add(Box.createVerticalStrut(STRUT_SIZE));
            mainPanel.add(this.makeTrackerNamePanel());
            mainPanel.add(Box.createVerticalStrut(STRUT_SIZE));
            mainPanel.add(this.makeDoneButtonPanel());
            panel.add(mainPanel);
            this._dialog.getContentPane().add(panel);
            this._dialog.setLocation(this.getLocation().x + 100, this.getLocation().y + 100);
            this._dialog.pack();
            this._dialog.setVisible(true);
        }

        private JPanel makeTrackerNamePanel() {
            this._trainNameBox.setText("");
            this._trainLocationBox.setText("");
            JPanel namePanel = new JPanel();
            namePanel.setLayout(new BoxLayout(namePanel, 1));
            JPanel p = new JPanel();
            p.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridwidth = 1;
            c.gridheight = 1;
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 13;
            p.add((Component)new JLabel(Bundle.getMessage("TrainName")), c);
            c.gridy = 1;
            p.add((Component)new JLabel(Bundle.getMessage("TrainLocation")), c);
            c.gridx = 1;
            c.gridy = 0;
            c.anchor = 17;
            c.weightx = 1.0;
            c.fill = 2;
            p.add((Component)this._trainNameBox, c);
            this._trainNameBox.setToolTipText(Bundle.getMessage("TrackerNameTip"));
            c.gridy = 1;
            p.add((Component)this._trainLocationBox, c);
            this._trainLocationBox.setToolTipText(Bundle.getMessage("TrackerLocTip"));
            namePanel.add(p);
            return namePanel;
        }

        private JPanel makeDoneButtonPanel() {
            JPanel buttonPanel = new JPanel();
            JPanel panel0 = new JPanel();
            panel0.setLayout(new FlowLayout());
            JButton doneButton = new JButton(Bundle.getMessage("ButtonCreate"));
            doneButton.addActionListener(a -> {
                if (this.doDoneAction()) {
                    this._dialog.dispose();
                    this._dialog = null;
                }
            });
            panel0.add(doneButton);
            buttonPanel.add(panel0);
            return buttonPanel;
        }

        private boolean doDoneAction() {
            boolean retOK = false;
            String blockName = this._trainLocationBox.getText();
            if (blockName != null) {
                OBlock block = InstanceManager.getDefault(OBlockManager.class).getOBlock(blockName);
                if (block == null) {
                    JOptionPane.showMessageDialog(this, Bundle.getMessage("BlockNotFound", blockName), Bundle.getMessage("WarningTitle"), 2);
                } else {
                    retOK = TrackerTableAction.this.makeTracker(block, this._trainNameBox.getText(), null);
                }
            }
            return retOK;
        }

        void openPickList() {
            this._pickFrame = new JmriJFrame();
            JPanel content = new JPanel();
            content.setLayout(new BoxLayout(content, 1));
            JPanel blurb = new JPanel();
            blurb.setLayout(new BoxLayout(blurb, 1));
            blurb.add(Box.createVerticalStrut(5));
            blurb.add(new JLabel(Bundle.getMessage("DragBlockName")));
            blurb.add(Box.createVerticalStrut(5));
            JPanel panel = new JPanel();
            panel.add(blurb);
            content.add(panel);
            PickListModel[] models = new PickListModel[]{PickListModel.oBlockPickModelInstance()};
            content.add(new PickPanel(models));
            this._pickFrame.setContentPane(content);
            this._pickFrame.setLocationRelativeTo(this);
            this._pickFrame.toFront();
            this._pickFrame.setVisible(true);
            this._pickFrame.pack();
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            JPopupMenu popup = new JPopupMenu();
            int i = this._statusHistory.size() - 1;
            while (i >= 0) {
                popup.add(this._statusHistory.get(i));
                --i;
            }
            popup.show(this._status, 0, 0);
        }

        @Override
        public void mousePressed(MouseEvent event) {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
        }

        @Override
        public void mouseExited(MouseEvent event) {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
        }

        private void setStatus(String msg) {
            this._status.setText(msg);
            if (msg != null && msg.length() > 0) {
                WarrantTableAction.getDefault().writetoLog(msg);
                this._statusHistory.add(msg);
                while (this._statusHistory.size() > this._maxHistorySize) {
                    this._statusHistory.remove(0);
                }
            }
        }
    }

    private class TrackerTableModel
    extends AbstractTableModel {
        public static final int NAME_COL = 0;
        public static final int STATUS_COL = 1;
        public static final int STOP_COL = 2;
        public static final int NUMCOLS = 3;

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public synchronized int getRowCount() {
            return TrackerTableAction.this._trackerList.size();
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Bundle.getMessage("TrainName");
                }
                case 1: {
                    return Bundle.getMessage("status");
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((Tracker)TrackerTableAction.this._trackerList.get(rowIndex)).getTrainName();
                }
                case 1: {
                    return ((Tracker)TrackerTableAction.this._trackerList.get(rowIndex)).getStatus();
                }
                case 2: {
                    return Bundle.getMessage("Stop");
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 2) {
                Tracker t = (Tracker)TrackerTableAction.this._trackerList.get(row);
                TrackerTableAction.this.stopTrain(t, t.getHeadBlock());
                this.fireTableDataChanged();
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 2;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 2) {
                return JButton.class;
            }
            return String.class;
        }

        public int getPreferredWidth(int col) {
            switch (col) {
                case 0: {
                    return new JTextField((int)20).getPreferredSize().width;
                }
                case 1: {
                    return new JTextField((int)60).getPreferredSize().width;
                }
                case 2: {
                    return new JButton((String)"STOPIT").getPreferredSize().width;
                }
            }
            return 5;
        }
    }
}

