/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import java.text.NumberFormat;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Sensor;
import jmri.SpeedStepMode;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.logix.WarrantFrame;
import jmri.jmrit.logix.WarrantManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottleSetting {
    static final int CMD_SPEED = 1;
    static final int CMD_SPEEDSTEP = 2;
    static final int CMD_FORWARD = 3;
    static final int CMD_FTN = 4;
    static final int CMD_LATCH = 5;
    static final int CMD_NOOP = 6;
    static final int CMD_SET_SENSOR = 7;
    static final int CMD_WAIT_SENSOR = 8;
    static final int CMD_RUN_WARRANT = 9;
    static final int VALUE_FLOAT = 1;
    static final int VALUE_NOOP = 2;
    static final int VALUE_INT = 3;
    static final int VALUE_STEP = 4;
    static final int VALUE_TRUE = 10;
    static final int VALUE_FALSE = 11;
    static final int VALUE_ON = 20;
    static final int VALUE_OFF = 21;
    static final int VALUE_ACTIVE = 30;
    static final int VALUE_INACTIVE = 31;
    static final int IS_TRUE_FALSE = 1;
    static final int IS_ON_OFF = 2;
    static final int IS_SENSOR_STATE = 3;
    private long _time;
    private Command _command;
    private int _keyNum;
    private CommandValue _value;
    private NamedBeanHandle<? extends NamedBean> _namedHandle = null;
    private float _trackSpeed;
    private static final Logger log = LoggerFactory.getLogger(ThrottleSetting.class);

    public static Command getCommandTypeFromInt(int typeInt) {
        Command[] commandArray = Command.values();
        int n = commandArray.length;
        int n2 = 0;
        while (n2 < n) {
            Command type = commandArray[n2];
            if (type.getIntId() == typeInt) {
                return type;
            }
            ++n2;
        }
        throw new IllegalArgumentException(String.valueOf(typeInt) + " Command type ID is unknown");
    }

    public static ValueType getValueTypeFromInt(int typeInt) {
        ValueType[] valueTypeArray = ValueType.values();
        int n = valueTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ValueType type = valueTypeArray[n2];
            if (type.getIntId() == typeInt) {
                return type;
            }
            ++n2;
        }
        throw new IllegalArgumentException(String.valueOf(typeInt) + " ValueType ID is unknown");
    }

    public ThrottleSetting() {
        this._keyNum = -1;
    }

    public ThrottleSetting(long time, Command command, int key, ValueType vType, SpeedStepMode ss, float f, String beanName) {
        this._time = time;
        this._command = command;
        this._keyNum = key;
        this.setValue(vType, ss, f);
        this.setNamedBean(command, beanName);
        this._trackSpeed = 0.0f;
    }

    public ThrottleSetting(long time, Command command, int key, ValueType vType, SpeedStepMode ss, float f, String beanName, float trkSpd) {
        this._time = time;
        this._command = command;
        this._keyNum = key;
        this.setValue(vType, ss, f);
        this.setNamedBean(command, beanName);
        this._trackSpeed = trkSpd;
    }

    public ThrottleSetting(long time, String cmdStr, String value, String beanName) {
        this._time = time;
        this.setCommand(cmdStr);
        this.setValue(value);
        this.setNamedBean(this._command, beanName);
        this._trackSpeed = 0.0f;
    }

    public ThrottleSetting(long time, String cmdStr, String value, String beanName, float trkSpd) {
        this._time = time;
        this.setCommand(cmdStr);
        this.setValue(value);
        this.setNamedBean(this._command, beanName);
        this._trackSpeed = trkSpd;
    }

    public ThrottleSetting(long time, Command command, int key, String value, String beanName, float trkSpd) {
        this._time = time;
        this._command = command;
        this._keyNum = key;
        this.setValue(value);
        this._namedHandle = null;
        this._trackSpeed = trkSpd;
    }

    public ThrottleSetting(ThrottleSetting ts) {
        this._time = ts.getTime();
        this._command = ts.getCommand();
        this._keyNum = ts.getKeyNum();
        this.setValue(ts.getValue());
        this._namedHandle = ts.getNamedBeanHandle();
        this._trackSpeed = ts.getTrackSpeed();
    }

    private Command getCommandFromString(String cmdStr) throws JmriException {
        Command command;
        String cmd = cmdStr.trim().toUpperCase();
        if ("SPEED".equals(cmd) || Bundle.getMessage("speed").toUpperCase().equals(cmd)) {
            command = Command.SPEED;
            this._keyNum = -1;
        } else if ("SPEEDSTEP".equals(cmd) || Bundle.getMessage("speedstep").toUpperCase().equals(cmd)) {
            command = Command.SPEEDSTEP;
            this._keyNum = -1;
        } else if ("FORWARD".equals(cmd) || Bundle.getMessage("forward").toUpperCase().equals(cmd)) {
            command = Command.FORWARD;
            this._keyNum = -1;
        } else if (cmd.startsWith("F") || Bundle.getMessage("setFunction").toUpperCase().equals(cmd)) {
            command = Command.FKEY;
            try {
                this._keyNum = Integer.parseInt(cmd.substring(1));
            }
            catch (NumberFormatException nfe) {
                throw new JmriException(Bundle.getMessage("badFunctionNum"), nfe);
            }
        } else if (cmd.startsWith("LOCKF") || Bundle.getMessage("setKeyMomentary").toUpperCase().equals(cmd)) {
            command = Command.LATCHF;
            try {
                this._keyNum = Integer.parseInt(cmd.substring(5));
            }
            catch (NumberFormatException nfe) {
                throw new JmriException(Bundle.getMessage("badLockFNum"), nfe);
            }
        } else if ("NOOP".equals(cmd) || Bundle.getMessage("NoOp").toUpperCase().equals(cmd)) {
            command = Command.NOOP;
            this._keyNum = -1;
        } else if ("SENSOR".equals(cmd) || "SET SENSOR".equals(cmd) || "SET".equals(cmd) || Bundle.getMessage("SetSensor").toUpperCase().equals(cmd)) {
            command = Command.SET_SENSOR;
            this._keyNum = -1;
        } else if ("WAIT SENSOR".equals(cmd) || "WAIT".equals(cmd) || Bundle.getMessage("WaitSensor").toUpperCase().equals(cmd)) {
            command = Command.WAIT_SENSOR;
            this._keyNum = -1;
        } else if ("RUN WARRANT".equals(cmd) || Bundle.getMessage("runWarrant").toUpperCase().equals(cmd)) {
            command = Command.RUN_WARRANT;
            this._keyNum = -1;
        } else {
            throw new JmriException(Bundle.getMessage("badCommand", cmdStr));
        }
        return command;
    }

    private CommandValue getValueFromString(Command command, String valueStr) throws JmriException {
        ValueType type;
        float speed;
        SpeedStepMode mode;
        block29: {
            String val;
            block35: {
                block34: {
                    block33: {
                        block32: {
                            block31: {
                                block30: {
                                    if (command == null) {
                                        throw new JmriException(Bundle.getMessage("badCommand", "Command missing " + valueStr));
                                    }
                                    mode = SpeedStepMode.UNKNOWN;
                                    speed = 0.0f;
                                    val = valueStr.trim().toUpperCase();
                                    if (!"ON".equals(val) && !Bundle.getMessage("StateOn").toUpperCase().equals(val)) break block30;
                                    switch (command) {
                                        case FKEY: 
                                        case LATCHF: {
                                            type = ValueType.VAL_ON;
                                            break block29;
                                        }
                                        default: {
                                            throw new JmriException(Bundle.getMessage("badValue", new Object[]{valueStr, command}));
                                        }
                                    }
                                }
                                if (!"OFF".equals(val) && !Bundle.getMessage("StateOff").toUpperCase().equals(val)) break block31;
                                switch (command) {
                                    case FKEY: 
                                    case LATCHF: {
                                        type = ValueType.VAL_OFF;
                                        break block29;
                                    }
                                    default: {
                                        throw new JmriException(Bundle.getMessage("badValue", new Object[]{valueStr, command}));
                                    }
                                }
                            }
                            if (!"TRUE".equals(val) && !Bundle.getMessage("StateTrue").toUpperCase().equals(val)) break block32;
                            switch (command) {
                                case FORWARD: {
                                    type = ValueType.VAL_TRUE;
                                    break block29;
                                }
                                case FKEY: 
                                case LATCHF: {
                                    type = ValueType.VAL_ON;
                                    break block29;
                                }
                                default: {
                                    throw new JmriException(Bundle.getMessage("badValue", new Object[]{valueStr, command}));
                                }
                            }
                        }
                        if (!"FALSE".equals(val) && !Bundle.getMessage("StateFalse").toUpperCase().equals(val)) break block33;
                        switch (command) {
                            case FORWARD: {
                                type = ValueType.VAL_FALSE;
                                break block29;
                            }
                            case FKEY: 
                            case LATCHF: {
                                type = ValueType.VAL_OFF;
                                break block29;
                            }
                            default: {
                                throw new JmriException(Bundle.getMessage("badValue", new Object[]{valueStr, command}));
                            }
                        }
                    }
                    if (!"ACTIVE".equals(val) && !Bundle.getMessage("SensorStateActive").toUpperCase().equals(val)) break block34;
                    switch (command) {
                        case SET_SENSOR: 
                        case WAIT_SENSOR: {
                            type = ValueType.VAL_ACTIVE;
                            break block29;
                        }
                        default: {
                            throw new JmriException(Bundle.getMessage("badValue", new Object[]{valueStr, command}));
                        }
                    }
                }
                if (!"INACTIVE".equals(val) && !Bundle.getMessage("SensorStateInactive").toUpperCase().equals(val)) break block35;
                switch (command) {
                    case SET_SENSOR: 
                    case WAIT_SENSOR: {
                        type = ValueType.VAL_INACTIVE;
                        break block29;
                    }
                    default: {
                        throw new JmriException(Bundle.getMessage("badValue", new Object[]{valueStr, command}));
                    }
                }
            }
            try {
                switch (command) {
                    case SPEED: {
                        speed = Float.parseFloat(valueStr.replace(',', '.'));
                        type = ValueType.VAL_FLOAT;
                        break;
                    }
                    case NOOP: {
                        type = ValueType.VAL_NOOP;
                        break;
                    }
                    case RUN_WARRANT: {
                        speed = Float.parseFloat(valueStr.replace(',', '.'));
                        type = ValueType.VAL_INT;
                        break;
                    }
                    case SPEEDSTEP: {
                        mode = SpeedStepMode.getByName(val);
                        type = ValueType.VAL_STEP;
                        break;
                    }
                    default: {
                        throw new JmriException(Bundle.getMessage("badValue", new Object[]{valueStr, command}));
                    }
                }
            }
            catch (IllegalArgumentException | NullPointerException ex) {
                throw new JmriException(Bundle.getMessage("badValue", new Object[]{valueStr, command}), ex);
            }
        }
        return new CommandValue(type, mode, speed);
    }

    public void setTime(long time) {
        this._time = time;
    }

    public long getTime() {
        return this._time;
    }

    public void setCommand(String cmdStr) {
        try {
            this._command = this.getCommandFromString(cmdStr);
        }
        catch (JmriException je) {
            log.error("Cannot set command from string \"{}\" {}", (Object)cmdStr, (Object)je.toString());
        }
    }

    public void setCommand(Command command) {
        this._command = command;
    }

    public Command getCommand() {
        return this._command;
    }

    public void setKeyNum(int key) {
        this._keyNum = key;
    }

    public int getKeyNum() {
        return this._keyNum;
    }

    public void setValue(String valueStr) {
        try {
            this._value = this.getValueFromString(this._command, valueStr);
        }
        catch (JmriException je) {
            log.error("Cannot set value for command {}. {}", (Object)(this._command != null ? this._command.toString() : "null"), (Object)je.toString());
        }
    }

    public void setValue(CommandValue value) {
        this._value = value.clone();
    }

    public void setValue(ValueType t, SpeedStepMode s, float f) {
        this._value = new CommandValue(t, s, f);
    }

    public CommandValue getValue() {
        return this._value;
    }

    public void setTrackSpeed(float s) {
        this._trackSpeed = s;
    }

    public float getTrackSpeed() {
        return this._trackSpeed;
    }

    public String setNamedBean(Command cmd, String name) {
        String msg;
        if (log.isDebugEnabled()) {
            log.debug("setNamedBean({}, {})", (Object)cmd, (Object)name);
        }
        if ((msg = WarrantFrame.checkBeanName(cmd, name)) != null) {
            this._namedHandle = null;
            return msg;
        }
        try {
            if (cmd.equals((Object)Command.SET_SENSOR) || cmd.equals((Object)Command.WAIT_SENSOR)) {
                Sensor s = InstanceManager.sensorManagerInstance().provideSensor(name);
                this._namedHandle = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(name, s);
            } else if (cmd.equals((Object)Command.RUN_WARRANT)) {
                Warrant w = InstanceManager.getDefault(WarrantManager.class).provideWarrant(name);
                this._namedHandle = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(name, w);
            } else {
                OBlock b = InstanceManager.getDefault(OBlockManager.class).getOBlock(name);
                if (b != null) {
                    this._namedHandle = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(name, b);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            return Bundle.getMessage("badCommand", (Object)((Object)cmd) + iae.toString());
        }
        return null;
    }

    public <T extends NamedBean> void setNamedBeanHandle(NamedBeanHandle<T> bh) {
        this._namedHandle = bh;
    }

    public NamedBeanHandle<? extends NamedBean> getNamedBeanHandle() {
        return this._namedHandle;
    }

    public String getBeanDisplayName() {
        if (this._namedHandle == null) {
            return null;
        }
        return this._namedHandle.getBean().getDisplayName();
    }

    public String getBeanSystemName() {
        if (this._namedHandle == null) {
            return null;
        }
        return this._namedHandle.getBean().getSystemName();
    }

    public String toString() {
        return "ThrottleSetting: wait " + this._time + "ms then " + this._command.toString() + " with value " + this._value.showValue() + " for bean \"" + this.getBeanDisplayName() + "\" at trackSpeed " + this.getTrackSpeed() + "\"";
    }

    public static enum Command {
        SPEED(1, true, "speed"),
        FORWARD(3, true, "forward"),
        FKEY(4, true, "setFunction"),
        LATCHF(5, true, "setKeyMomentary"),
        SET_SENSOR(7, false, "SetSensor"),
        WAIT_SENSOR(8, false, "WaitSensor"),
        RUN_WARRANT(9, false, "runWarrant"),
        NOOP(6, true, "NoOp"),
        SPEEDSTEP(2, true, "speedstep");

        int _command;
        boolean _hasBlock;
        String _bundleKey;

        private Command(int cmd, boolean hasBlock, String bundleName) {
            this._command = cmd;
            this._hasBlock = hasBlock;
            this._bundleKey = bundleName;
        }

        public int getIntId() {
            return this._command;
        }

        boolean hasBlockName() {
            return this._hasBlock;
        }

        public String toString() {
            return Bundle.getMessage(this._bundleKey);
        }
    }

    public static class CommandValue {
        ValueType _type;
        SpeedStepMode _stepMode;
        float _floatValue;
        NumberFormat formatter = NumberFormat.getNumberInstance();
        NumberFormat intFormatter = NumberFormat.getIntegerInstance();

        public CommandValue(ValueType t, SpeedStepMode s, float f) {
            this._type = t;
            this._stepMode = s;
            this._floatValue = f;
        }

        protected CommandValue clone() {
            return new CommandValue(this._type, this._stepMode, this._floatValue);
        }

        public ValueType getType() {
            return this._type;
        }

        public SpeedStepMode getMode() {
            return this._stepMode;
        }

        void setFloat(float f) {
            this._floatValue = f;
        }

        public float getFloat() {
            return this._floatValue;
        }

        public String showValue() {
            if (this._type == ValueType.VAL_FLOAT) {
                return this.formatter.format(this._floatValue);
            }
            if (this._type == ValueType.VAL_INT) {
                return this.intFormatter.format(this._floatValue);
            }
            if (this._type == ValueType.VAL_STEP) {
                return this._stepMode.name;
            }
            return this._type.toString();
        }

        public String toString() {
            return "CommandValue type " + this._type.getIntId();
        }
    }

    public static enum ValueType {
        VAL_FLOAT(1, "NumData"),
        VAL_NOOP(2, "Mark"),
        VAL_INT(3, "NumData"),
        VAL_STEP(4, "speedstep"),
        VAL_TRUE(10, "StateTrue"),
        VAL_FALSE(11, "StateFalse"),
        VAL_ON(20, "StateOn"),
        VAL_OFF(21, "StateOff"),
        VAL_ACTIVE(30, "SensorStateActive"),
        VAL_INACTIVE(31, "SensorStateInactive");

        int _valueId;
        String _bundleKey;

        private ValueType(int id, String bundleName) {
            this._valueId = id;
            this._bundleKey = bundleName;
        }

        public int getIntId() {
            return this._valueId;
        }

        public String toString() {
            return Bundle.getMessage(this._bundleKey);
        }
    }
}

