/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.implementation.SignalSpeedMap;
import jmri.jmrit.XmlFile;
import jmri.jmrit.logix.BlockSpeedInfo;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.RampData;
import jmri.jmrit.logix.ThrottleSetting;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.logix.WarrantManager;
import jmri.jmrit.logix.WarrantPreferences;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.RosterSpeedProfile;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeedUtil {
    private DccLocoAddress _dccAddress;
    private String _rosterId;
    private RosterEntry _rosterEntry;
    private DccThrottle _throttle;
    private boolean _isForward = true;
    private float _rampThrottleIncrement;
    private int _rampTimeIncrement;
    private float _speedIncrement;
    private RosterSpeedProfile _mergeProfile;
    private RosterSpeedProfile _sessionProfile;
    private SignalSpeedMap _signalSpeedMap = InstanceManager.getDefault(SignalSpeedMap.class);
    private float _ma;
    private float _md;
    private ArrayList<BlockSpeedInfo> _speedInfo;
    public static final float SCALE_FACTOR = 45.0f;
    public static final float MAX_TGV_SPEED = 88889.0f;
    private long _timeAtSpeed;
    private float _prevSpeed;
    private float _distanceTravelled;
    private float _settingsTravelled;
    private long _changetime;
    private int _numchanges;
    private static final Logger log = LoggerFactory.getLogger(SpeedUtil.class);

    protected SpeedUtil() {
    }

    public RosterEntry getRosterEntry() {
        return this._rosterEntry;
    }

    public String getRosterId() {
        return this._rosterId;
    }

    public boolean setRosterId(String id) {
        if (log.isTraceEnabled()) {
            log.debug("setRosterId({}) old={}", (Object)id, (Object)this._rosterId);
        }
        if (id == null || id.isEmpty()) {
            this._rosterEntry = null;
            this._mergeProfile = null;
            this._sessionProfile = null;
            return false;
        }
        if (id.equals(this._rosterId)) {
            return true;
        }
        this._mergeProfile = null;
        this._sessionProfile = null;
        RosterEntry re = Roster.getDefault().getEntryForId(id);
        if (re != null) {
            this._rosterEntry = re;
            this._dccAddress = re.getDccLocoAddress();
            this._rosterId = id;
            return true;
        }
        return false;
    }

    public DccLocoAddress getDccAddress() {
        if (this._dccAddress == null && this._rosterEntry != null) {
            this._dccAddress = this._rosterEntry.getDccLocoAddress();
        }
        return this._dccAddress;
    }

    protected String getAddress() {
        if (this._dccAddress == null) {
            this._dccAddress = this.getDccAddress();
        }
        if (this._dccAddress != null) {
            return this._dccAddress.toString();
        }
        return null;
    }

    protected void setDccAddress(DccLocoAddress dccAddr) {
        if (log.isTraceEnabled()) {
            log.debug("setDccAddress(DccLocoAddress) _dccAddress= {}", (Object)this._dccAddress);
        }
        if (dccAddr == null) {
            this._mergeProfile = null;
            this._sessionProfile = null;
            this._rosterId = null;
            this._rosterEntry = null;
            this._dccAddress = null;
            return;
        }
        if (!dccAddr.equals(this._dccAddress)) {
            this._mergeProfile = null;
            this._sessionProfile = null;
            this._dccAddress = dccAddr;
        }
    }

    public boolean setDccAddress(int number, String type) {
        LocoAddress.Protocol protocol;
        if (log.isTraceEnabled()) {
            log.debug("setDccAddress({}, {})", (Object)number, (Object)type);
        }
        if (type.equals("L") || type.equals("l")) {
            protocol = LocoAddress.Protocol.DCC_LONG;
        } else if (type.equals("S") || type.equals("s")) {
            protocol = LocoAddress.Protocol.DCC_SHORT;
        } else {
            try {
                protocol = LocoAddress.Protocol.getByPeopleName(type);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    type = type.toLowerCase();
                    protocol = LocoAddress.Protocol.getByShortName(type);
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    this._dccAddress = null;
                    return false;
                }
            }
        }
        DccLocoAddress addr = new DccLocoAddress(number, protocol);
        if (this._rosterEntry != null && addr.equals(this._rosterEntry.getDccLocoAddress())) {
            return true;
        }
        this._dccAddress = addr;
        String numStr = String.valueOf(number);
        List<RosterEntry> l = Roster.getDefault().matchingList(null, null, numStr, null, null, null, null);
        if (!l.isEmpty()) {
            int size = l.size();
            if (size != 1) {
                log.info("{} entries for address {}, {}", new Object[]{l.size(), number, type});
            }
            this._rosterEntry = l.get(size - 1);
            this.setRosterId(this._rosterEntry.getId());
        } else {
            this._rosterId = "$" + this._dccAddress.toString() + "$";
            this._rosterEntry = new RosterEntry();
            this._rosterEntry.setId(this._rosterId);
            this._rosterEntry.setDccAddress(numStr);
            this._rosterEntry.setProtocol(protocol);
            this._mergeProfile = null;
            this._sessionProfile = null;
        }
        return true;
    }

    public boolean setAddress(String id) {
        int num;
        String type;
        String numId;
        if (log.isTraceEnabled()) {
            log.debug("setDccAddress: id= {}, _rosterId= {}", (Object)id, (Object)this._rosterId);
        }
        if (id == null || id.isEmpty()) {
            return false;
        }
        if (this.setRosterId(id)) {
            return true;
        }
        int index = -1;
        int i = 0;
        while (i < id.length()) {
            if (!Character.isDigit(id.charAt(i))) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            numId = id;
            type = null;
        } else {
            int beginIdx = id.charAt(index) == '(' ? index + 1 : index;
            int endIdx = id.charAt(id.length() - 1) == ')' ? id.length() - 1 : id.length();
            numId = id.substring(0, index);
            type = id.substring(beginIdx, endIdx);
        }
        try {
            num = Integer.parseInt(numId);
        }
        catch (NumberFormatException numberFormatException) {
            num = 0;
        }
        if (type == null) {
            type = num > 128 ? "L" : "S";
        }
        if (!this.setDccAddress(num, type)) {
            log.error("setDccAddress failed for  number={} type={}", (Object)num, (Object)type);
            return false;
        }
        if (log.isTraceEnabled()) {
            log.debug("setDccAddress({}): _rosterId= {}, _dccAddress= {}", new Object[]{id, this._rosterId, this._dccAddress.toString()});
        }
        return true;
    }

    protected float getRampThrottleIncrement() {
        if (this._rampThrottleIncrement <= 0.0f) {
            this._rampThrottleIncrement = WarrantPreferences.getDefault().getThrottleIncrement();
        }
        return this._rampThrottleIncrement;
    }

    protected void setRampThrottleIncrement(float incr) {
        this._rampThrottleIncrement = incr;
    }

    protected int getRampTimeIncrement() {
        if (this._rampTimeIncrement <= 0) {
            this._rampTimeIncrement = WarrantPreferences.getDefault().getTimeIncrement();
        }
        return this._rampTimeIncrement;
    }

    protected void setRampTimeIncrement(int incr) {
        this._rampTimeIncrement = incr;
    }

    protected float getMomentumTime(float delta, boolean increasing) {
        float incr = this.getThrottleSpeedStepIncrement();
        float time = increasing ? this._ma * Math.abs(delta) / incr : this._md * Math.abs(delta) / incr;
        if (time < 10.0f) {
            time = 10.0f;
        }
        return time;
    }

    protected float getThrottleSpeedStepIncrement() {
        if (this._throttle != null) {
            this._speedIncrement = this._throttle.getSpeedIncrement();
            return this._speedIncrement;
        }
        if (this._speedIncrement > 0.001f) {
            return this._speedIncrement;
        }
        return 0.007936508f;
    }

    protected synchronized RosterSpeedProfile getMergeProfile() {
        if (this._mergeProfile == null) {
            this.makeSpeedTree();
            this.makeRampParameters();
        }
        return this._mergeProfile;
    }

    protected void resetSpeedProfile() {
        this._mergeProfile = null;
    }

    private synchronized void makeSpeedTree() {
        if (log.isTraceEnabled()) {
            log.debug("makeSpeedTree for {}.", (Object)this._rosterId);
        }
        WarrantManager manager = InstanceManager.getDefault(WarrantManager.class);
        this._mergeProfile = manager.getMergeProfile(this._rosterId);
        this._sessionProfile = new RosterSpeedProfile(this._rosterEntry);
        if (log.isTraceEnabled()) {
            log.debug("SignalSpeedMap: throttle factor= {}, layout scale= {} convesion to mm/s= {}", new Object[]{Float.valueOf(this._signalSpeedMap.getDefaultThrottleFactor()), Float.valueOf(this._signalSpeedMap.getLayoutScale()), Float.valueOf(this._signalSpeedMap.getDefaultThrottleFactor() * this._signalSpeedMap.getLayoutScale() / 45.0f)});
        }
    }

    private void makeRampParameters() {
        this._rampTimeIncrement = this.getRampTimeIncrement();
        this._rampThrottleIncrement = this.getRampThrottleIncrement();
        this._ma = 10.0f;
        this._md = 10.0f;
        if (this._rosterEntry != null) {
            Element root;
            String fileName = String.valueOf(Roster.getDefault().getRosterFilesLocation()) + this._rosterEntry.getFileName();
            XmlFile xmlFile = new XmlFile(){};
            try {
                File file = new File(fileName);
                if (file.length() == 0L) {
                    return;
                }
                root = xmlFile.rootFromFile(file);
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
            catch (IOException | JDOMException eb) {
                log.error("Exception while loading warrant preferences: {}", eb);
                return;
            }
            if (root == null) {
                return;
            }
            Element child = root.getChild("locomotive");
            if (child == null) {
                return;
            }
            if ((child = child.getChild("values")) == null) {
                return;
            }
            List list = child.getChildren("CVvalue");
            int count = 0;
            for (Element cv : list) {
                Attribute attr = cv.getAttribute("name");
                if (attr != null) {
                    if (attr.getValue().equals("3")) {
                        this._ma += this.getMomentumFactor(cv);
                        ++count;
                    } else if (attr.getValue().equals("4")) {
                        this._md += this.getMomentumFactor(cv);
                        ++count;
                    } else if (attr.getValue().equals("23")) {
                        this._ma += this.getMomentumAdustment(cv);
                        ++count;
                    } else if (attr.getValue().equals("24")) {
                        this._md += this.getMomentumAdustment(cv);
                        ++count;
                    }
                }
                if (count > 3) break;
            }
            if (this._ma < 10.0f) {
                this._ma = 10.0f;
            }
            if (this._md < 10.0f) {
                this._md = 10.0f;
            }
            if ((float)this._rampTimeIncrement < this._ma) {
                this._rampTimeIncrement = (int)this._ma;
            }
            if ((float)this._rampTimeIncrement < this._md) {
                this._rampTimeIncrement = (int)this._md;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("makeRampParameters for {}, addr={}. _ma= {}ms/step, _md= {}ms/step. rampStepIncr= {} timeIncr= {} throttleStep= {}", new Object[]{this._rosterId, this.getAddress(), Float.valueOf(this._ma), Float.valueOf(this._md), Float.valueOf(this._rampThrottleIncrement), this._rampTimeIncrement, Float.valueOf(this.getThrottleSpeedStepIncrement())});
        }
    }

    private float getMomentumFactor(Element cv) {
        Attribute attr = cv.getAttribute("value");
        float num = 0.0f;
        if (attr != null) {
            try {
                num = Integer.parseInt(attr.getValue());
                num = (num + 1.0f) * 896.0f * this.getThrottleSpeedStepIncrement();
            }
            catch (NumberFormatException numberFormatException) {
                num = 0.0f;
            }
        }
        if (log.isTraceEnabled()) {
            log.debug("getMomentumFactor for cv {} {}, num= {}", new Object[]{cv.getAttribute("name"), attr, Float.valueOf(num)});
        }
        return num;
    }

    private float getMomentumAdustment(Element cv) {
        Attribute attr = cv.getAttribute("value");
        float num = 0.0f;
        if (attr != null) {
            try {
                int val = Integer.parseInt(attr.getValue());
                num = val & 0x3F;
                if ((val & 0x40) != 0) {
                    num = -num;
                }
            }
            catch (NumberFormatException numberFormatException) {
                num = 0.0f;
            }
        }
        if (log.isTraceEnabled()) {
            log.debug("getMomentumAdustment for cv {} {},  num= {}", new Object[]{cv.getAttribute("name"), attr, Float.valueOf(num)});
        }
        return num;
    }

    protected boolean profileHasSpeedInfo() {
        RosterSpeedProfile speedProfile = this.getMergeProfile();
        if (speedProfile == null) {
            return false;
        }
        return speedProfile.hasForwardSpeeds() || speedProfile.hasReverseSpeeds();
    }

    private void mergeEntries(Map.Entry<Integer, RosterSpeedProfile.SpeedStep> sEntry, Map.Entry<Integer, RosterSpeedProfile.SpeedStep> mEntry) {
        RosterSpeedProfile.SpeedStep sStep = sEntry.getValue();
        RosterSpeedProfile.SpeedStep mStep = mEntry.getValue();
        float sTrackSpeed = sStep.getForwardSpeed();
        float mTrackSpeed = mStep.getForwardSpeed();
        if (sTrackSpeed > 0.0f) {
            mTrackSpeed = mTrackSpeed > 0.0f ? (mTrackSpeed + sTrackSpeed) / 2.0f : sTrackSpeed;
            mStep.setForwardSpeed(mTrackSpeed);
        }
        sTrackSpeed = sStep.getReverseSpeed();
        mTrackSpeed = mStep.getReverseSpeed();
        if (sTrackSpeed > 0.0f) {
            if (sTrackSpeed > 0.0f) {
                mTrackSpeed = mTrackSpeed > 0.0f ? (mTrackSpeed + sTrackSpeed) / 2.0f : sTrackSpeed;
            }
            mStep.setReverseSpeed(mTrackSpeed);
        }
    }

    protected synchronized void stopRun(boolean updateSpeedProfile) {
        if (updateSpeedProfile) {
            int keyIncrement = Math.round(this.getThrottleSpeedStepIncrement() * 1000.0f);
            TreeMap<Integer, RosterSpeedProfile.SpeedStep> sSpeeds = this._sessionProfile.getProfileSpeeds();
            TreeMap<Integer, RosterSpeedProfile.SpeedStep> mSpeeds = this._mergeProfile.getProfileSpeeds();
            Map.Entry<Integer, RosterSpeedProfile.SpeedStep> sEntry = sSpeeds.firstEntry();
            while (sEntry != null) {
                Integer mKey;
                boolean merged = false;
                Integer sKey = sEntry.getKey();
                Map.Entry<Integer, RosterSpeedProfile.SpeedStep> mEntry = mSpeeds.floorEntry(sKey);
                if (mEntry != null && (mKey = mEntry.getKey()) != null && Math.abs(sKey - mKey) < keyIncrement) {
                    this.mergeEntries(sEntry, mEntry);
                    merged = true;
                }
                if (!merged && (mEntry = mSpeeds.ceilingEntry(sKey)) != null) {
                    mKey = mEntry.getKey();
                    if (Math.abs(sKey - mKey) < keyIncrement) {
                        this.mergeEntries(sEntry, mEntry);
                        merged = true;
                    }
                }
                if (!merged) {
                    RosterSpeedProfile.SpeedStep sStep = sEntry.getValue();
                    this._mergeProfile.setSpeed(sKey, sStep.getForwardSpeed(), sStep.getReverseSpeed());
                }
                sEntry = mSpeeds.higherEntry(sKey);
            }
            WarrantManager manager = InstanceManager.getDefault(WarrantManager.class);
            manager.setMergeProfile(this._rosterId, this._mergeProfile);
        }
    }

    protected void setIsForward(boolean direction) {
        this._isForward = direction;
    }

    protected boolean getIsForward() {
        if (this._throttle != null) {
            this._isForward = this._throttle.getIsForward();
        }
        return this._isForward;
    }

    protected void setThrottle(DccThrottle throttle) {
        this._throttle = throttle;
        this.getMergeProfile();
        float stepIncrement = this._throttle.getSpeedIncrement();
        this._rampThrottleIncrement = stepIncrement * (float)Math.round(this.getRampThrottleIncrement() / stepIncrement);
        if (log.isTraceEnabled()) {
            log.debug("User's Ramp increment modified to {} ({} speed steps)", (Object)Float.valueOf(this._rampThrottleIncrement), (Object)Math.round(this._rampThrottleIncrement / stepIncrement));
        }
    }

    protected DccThrottle getThrottle() {
        return this._throttle;
    }

    protected boolean secondGreaterThanFirst(String speed1, String speed2) {
        float s2;
        if (speed2 == null) {
            return false;
        }
        if (speed1 == null) {
            return true;
        }
        float s1 = this._signalSpeedMap.getSpeed(speed1);
        return s1 < (s2 = this._signalSpeedMap.getSpeed(speed2));
    }

    protected float modifySpeed(float tSpeed, String sType) {
        log.trace("modifySpeed speed= {} for SpeedType= \"{}\"", (Object)Float.valueOf(tSpeed), (Object)sType);
        if (sType.equals(Warrant.Stop)) {
            return 0.0f;
        }
        if (sType.equals(Warrant.EStop)) {
            return -1.0f;
        }
        float throttleSpeed = tSpeed;
        if (sType.equals("Normal")) {
            return throttleSpeed;
        }
        float signalSpeed = this._signalSpeedMap.getSpeed(sType);
        switch (this._signalSpeedMap.getInterpretation()) {
            case 1: {
                throttleSpeed *= signalSpeed / 100.0f;
                break;
            }
            case 2: {
                signalSpeed /= 100.0f;
                if (!(signalSpeed < throttleSpeed)) break;
                throttleSpeed = signalSpeed;
                break;
            }
            case 3: {
                signalSpeed /= this._signalSpeedMap.getLayoutScale();
                signalSpeed /= 2.2369363f;
                float trackSpeed = this.getTrackSpeed(throttleSpeed);
                if (!(signalSpeed < trackSpeed)) break;
                throttleSpeed = this.getThrottleSettingForSpeed(signalSpeed);
                break;
            }
            case 4: {
                signalSpeed /= this._signalSpeedMap.getLayoutScale();
                signalSpeed /= 3.6f;
                float trackSpeed = this.getTrackSpeed(throttleSpeed);
                if (!(signalSpeed < trackSpeed)) break;
                throttleSpeed = this.getThrottleSettingForSpeed(signalSpeed);
                break;
            }
            default: {
                log.error("Unknown speed interpretation {}", (Object)this._signalSpeedMap.getInterpretation());
                throw new IllegalArgumentException("Unknown speed interpretation " + this._signalSpeedMap.getInterpretation());
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("modifySpeed: from {}, to {}, signalSpeed= {}. interpretation= {}", new Object[]{Float.valueOf(tSpeed), Float.valueOf(throttleSpeed), Float.valueOf(signalSpeed), this._signalSpeedMap.getInterpretation()});
        }
        return throttleSpeed;
    }

    protected static long modifyTime(float speed, long time, float modifiedSpeed) {
        if (Math.abs(speed - modifiedSpeed) > 1.0E-4f) {
            return (long)(speed / modifiedSpeed * (float)time);
        }
        return time;
    }

    protected float getTrackSpeed(float throttleSetting) {
        if (throttleSetting <= 0.0f) {
            return 0.0f;
        }
        if (this._dccAddress == null) {
            return this.factorSpeed(throttleSetting);
        }
        boolean isForward = this.getIsForward();
        RosterSpeedProfile speedProfile = this.getMergeProfile();
        float speed = speedProfile.getSpeed(throttleSetting, isForward) / 1000.0f;
        if (speed <= 0.0f) {
            speed = speedProfile.getSpeed(throttleSetting, !isForward) / 1000.0f;
        }
        if (speed <= 0.0f) {
            return this.factorSpeed(throttleSetting);
        }
        return speed;
    }

    private float factorSpeed(float throttleSetting) {
        float factor = this._signalSpeedMap.getDefaultThrottleFactor() * 45.0f / this._signalSpeedMap.getLayoutScale();
        return throttleSetting * factor;
    }

    protected float getThrottleSettingForSpeed(float trackSpeed) {
        RosterSpeedProfile speedProfile = this.getMergeProfile();
        float throttleSpeed = speedProfile.getThrottleSetting(trackSpeed * 1000.0f, this.getIsForward());
        if (throttleSpeed <= 0.0f) {
            throttleSpeed = trackSpeed * this._signalSpeedMap.getLayoutScale() / (45.0f * this._signalSpeedMap.getDefaultThrottleFactor());
        }
        return throttleSpeed;
    }

    protected float getDistanceTraveled(float speedSetting, String speedtype, float time) {
        if (time <= 0.0f) {
            return 0.0f;
        }
        float throttleSetting = this.modifySpeed(speedSetting, speedtype);
        return this.getTrackSpeed(throttleSetting) * time;
    }

    protected float getTimeForDistance(float throttleSetting, float distance) {
        float speed = this.getTrackSpeed(throttleSetting);
        if (distance <= 0.0f || speed <= 0.0f) {
            return 0.0f;
        }
        return distance / speed;
    }

    protected void getBlockSpeedTimes(List<ThrottleSetting> commands) {
        this._distanceTravelled = 0.0f;
        this._speedInfo = new ArrayList();
        String blkName = null;
        float firstSpeed = 0.0f;
        float maxSpeed = 0.0f;
        float lastSpeed = 0.0f;
        float prevSpeed = 0.0f;
        long blkTime = 0L;
        float blkDist = 0.0f;
        int firstIdx = 0;
        ThrottleSetting ts = commands.get(0);
        blkName = ts.getBeanDisplayName();
        int i = 0;
        while (i < commands.size()) {
            ts = commands.get(i);
            ThrottleSetting.CommandValue cmdVal = ts.getValue();
            long time = ts.getTime();
            blkTime += time;
            blkDist += this.getDistanceOfSpeedChange(prevSpeed, lastSpeed, time);
            if (cmdVal.getType() == ThrottleSetting.ValueType.VAL_FLOAT) {
                prevSpeed = lastSpeed;
                lastSpeed = cmdVal.getFloat();
                if (lastSpeed > maxSpeed) {
                    maxSpeed = lastSpeed;
                }
            }
            if (ts.getCommand().equals((Object)ThrottleSetting.Command.NOOP)) {
                this._speedInfo.add(new BlockSpeedInfo(blkName, firstSpeed, maxSpeed, lastSpeed, blkTime, blkDist, firstIdx, i));
                if (log.isDebugEnabled()) {
                    log.debug("block: {} speeds: entrance= {} max= {} exit= {} time: {}ms distance= {}. index {} to {}", new Object[]{blkName, Float.valueOf(firstSpeed), Float.valueOf(maxSpeed), Float.valueOf(lastSpeed), blkTime, Float.valueOf(blkDist), firstIdx, i});
                }
                blkName = ts.getBeanDisplayName();
                blkTime = 0L;
                blkDist = 0.0f;
                firstSpeed = lastSpeed;
                maxSpeed = lastSpeed;
                prevSpeed = lastSpeed;
                firstIdx = i + 1;
            }
            this.clearStats();
            this._prevSpeed = 0.0f;
            ++i;
        }
        this._speedInfo.add(new BlockSpeedInfo(blkName, firstSpeed, maxSpeed, lastSpeed, blkTime, blkDist, firstIdx, commands.size() - 1));
        if (log.isDebugEnabled()) {
            log.debug("block: {} speeds: entrance= {} max= {} exit= {} time: {}ms distance= {}. index {} to {}", new Object[]{blkName, Math.round(firstSpeed * 100.0f) / 100, Math.round(maxSpeed * 100.0f) / 100, Math.round(lastSpeed * 100.0f) / 100, blkTime, Float.valueOf(blkDist), firstIdx, commands.size() - 1});
        }
    }

    protected BlockSpeedInfo getBlockSpeedInfo(int idxBlockOrder) {
        return this._speedInfo.get(idxBlockOrder);
    }

    protected RampData getRampForSpeedChange(float fromSpeed, float toSpeed) {
        RampData ramp = new RampData(this, this.getRampThrottleIncrement(), this.getRampTimeIncrement(), fromSpeed, toSpeed);
        return ramp;
    }

    protected float getDistanceOfSpeedChange(float prevSpeed, float currSpeed, long speedTime) {
        boolean increasing;
        float momentumTime;
        if (currSpeed < 0.0f) {
            currSpeed = 0.0f;
        }
        if (prevSpeed < 0.0f) {
            prevSpeed = 0.0f;
        }
        if ((float)speedTime <= (momentumTime = this.getMomentumTime(currSpeed - prevSpeed, increasing = prevSpeed <= currSpeed))) {
            return this.getTrackSpeed((prevSpeed + currSpeed) / 2.0f) * (float)speedTime;
        }
        float dist = this.getTrackSpeed((prevSpeed + currSpeed) / 2.0f) * momentumTime;
        if ((float)speedTime > momentumTime) {
            dist += this.getTrackSpeed(currSpeed) * ((float)speedTime - momentumTime);
        }
        return dist;
    }

    protected void leavingBlock(OBlock block, float length) {
        float distRatio;
        long exitTime = System.currentTimeMillis();
        boolean isForward = this.getIsForward();
        float throttle = this._throttle.getSpeedSetting();
        if (this._changetime > 0L) {
            long elapsedTime = exitTime - this._changetime;
            this._distanceTravelled += this.getDistanceOfSpeedChange(this._prevSpeed, throttle, elapsedTime);
            this._settingsTravelled += throttle * (float)elapsedTime;
            this._timeAtSpeed += elapsedTime;
        }
        float measuredSpeed = 0.0f;
        float aveSettings = 0.0f;
        if (length <= 0.0f) {
            measuredSpeed = this._distanceTravelled / (float)this._timeAtSpeed;
            distRatio = 1.0f;
        } else {
            measuredSpeed = length / (float)this._timeAtSpeed;
            distRatio = length / this._distanceTravelled;
        }
        measuredSpeed *= 1000.0f;
        aveSettings = this._settingsTravelled / (float)this._timeAtSpeed;
        if ((double)aveSettings > 1.0 || measuredSpeed > 88889.0f * aveSettings / this._signalSpeedMap.getLayoutScale() || distRatio > 1.2f || distRatio < 0.8f) {
            if (log.isDebugEnabled()) {
                log.info("Bad speed measurements data for block {}. aveThrottle= {},  measuredSpeed= {},(TGVmax= {}), distTravelled= {}, pathLen= {}", new Object[]{block.getDisplayName(), Float.valueOf(aveSettings), Float.valueOf(measuredSpeed), Float.valueOf(88889.0f * aveSettings / this._signalSpeedMap.getLayoutScale()), Float.valueOf(this._distanceTravelled), Float.valueOf(length)});
            }
        } else if (this._numchanges < 2) {
            this.setSpeedProfile(this._sessionProfile, aveSettings, measuredSpeed, isForward);
        }
        if (log.isDebugEnabled()) {
            log.debug("{} changes in block '{}\". measuredDist={}, pathLen={}, measuredThrottle={},  measuredTrkSpd={}, profileTrkSpd={} curThrottle={}.", new Object[]{this._numchanges, block.getDisplayName(), Math.round(this._distanceTravelled), Float.valueOf(length), Float.valueOf(aveSettings), Float.valueOf(measuredSpeed), Float.valueOf(this.getTrackSpeed(measuredSpeed)), Float.valueOf(throttle)});
        }
        this.clearStats();
        this._changetime = exitTime;
    }

    private void setSpeedProfile(RosterSpeedProfile profile, float throttle, float measuredSpeed, boolean isForward) {
        int key;
        int keyIncrement = Math.round(this.getThrottleSpeedStepIncrement() * 1000.0f);
        TreeMap<Integer, RosterSpeedProfile.SpeedStep> speeds = profile.getProfileSpeeds();
        Map.Entry<Integer, RosterSpeedProfile.SpeedStep> entry = speeds.floorEntry(key = Math.round(throttle * 1000.0f));
        if (entry != null && this.mergeEntry(key, measuredSpeed, entry, keyIncrement, isForward)) {
            return;
        }
        entry = speeds.ceilingEntry(key);
        if (entry != null && this.mergeEntry(key, measuredSpeed, entry, keyIncrement, isForward)) {
            return;
        }
        if (isForward) {
            profile.setForwardSpeed(throttle, measuredSpeed, this._throttle.getSpeedIncrement());
        } else {
            profile.setReverseSpeed(throttle, measuredSpeed, this._throttle.getSpeedIncrement());
        }
    }

    private boolean mergeEntry(int key, float measuredSpeed, Map.Entry<Integer, RosterSpeedProfile.SpeedStep> entry, int keyIncrement, boolean isForward) {
        Integer sKey = entry.getKey();
        if (Math.abs(sKey - key) < keyIncrement) {
            RosterSpeedProfile.SpeedStep sStep = entry.getValue();
            if (isForward) {
                float sTrackSpeed = sStep.getForwardSpeed();
                if (sTrackSpeed > 0.0f) {
                    sTrackSpeed = sTrackSpeed > 0.0f ? (sTrackSpeed + measuredSpeed) / 2.0f : measuredSpeed;
                    sStep.setForwardSpeed(sTrackSpeed);
                }
            } else {
                float sTrackSpeed = sStep.getReverseSpeed();
                if (sTrackSpeed > 0.0f) {
                    sTrackSpeed = sTrackSpeed > 0.0f ? (sTrackSpeed + measuredSpeed) / 2.0f : measuredSpeed;
                    sStep.setReverseSpeed(sTrackSpeed);
                }
            }
        }
        return false;
    }

    private void clearStats() {
        this._timeAtSpeed = 0L;
        this._changetime = 0L;
        this._distanceTravelled = 0.0f;
        this._settingsTravelled = 0.0f;
        this._numchanges = 0;
    }

    protected float getDistanceTravelled() {
        float speed = this._throttle.getSpeedSetting();
        if (speed > 0.0f) {
            this.speedChange(speed);
        }
        return this._distanceTravelled;
    }

    protected synchronized void speedChange(float newSpeed) {
        ++this._numchanges;
        float throttleSetting = this._throttle.getSpeedSetting();
        long time = System.currentTimeMillis();
        if (throttleSetting < 0.0f) {
            throttleSetting = 0.0f;
        }
        if (this._changetime > 0L) {
            long elapsedTime = time - this._changetime;
            if (throttleSetting > 0.0f) {
                this._distanceTravelled += this.getTrackSpeed(throttleSetting) * (float)elapsedTime;
                this._distanceTravelled += this.getDistanceOfSpeedChange(this._prevSpeed, throttleSetting, elapsedTime);
                this._timeAtSpeed += elapsedTime;
            }
            if (log.isDebugEnabled()) {
                log.debug("speedChange: dist={}, {}ms at speed {}. _distanceTravelled={} settingsTravelled={}, timeAtSpeed= {}", new Object[]{Float.valueOf(throttleSetting * (float)elapsedTime), elapsedTime, Float.valueOf(this._distanceTravelled), Float.valueOf(throttleSetting), Float.valueOf(this._settingsTravelled), this._timeAtSpeed});
            }
        }
        this._changetime = newSpeed > 0.0f ? time : 0L;
        this._prevSpeed = throttleSetting;
    }
}

