/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.MergePrompt;
import jmri.jmrit.roster.RosterSpeedProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeedProfilePanel
extends JPanel {
    JTable _table;
    JScrollPane _scrollPane;
    static Color myRed = new Color(255, 120, 120);
    static String entryFlavorType = "application/x-java-jvm-local-objectref;class=java.util.AbstractMap";
    DataFlavor _entryFlavor;
    private static final Logger log = LoggerFactory.getLogger(SpeedProfilePanel.class);

    public SpeedProfilePanel(RosterSpeedProfile speedProfile, boolean editable, Map<Integer, Boolean> anomalies) {
        SpeedTableModel model = new SpeedTableModel(speedProfile, editable, anomalies);
        this._table = new JTable(model);
        int tablewidth = 0;
        int i = 0;
        while (i < model.getColumnCount()) {
            TableColumn column = this._table.getColumnModel().getColumn(i);
            int width = model.getPreferredWidth(i);
            column.setPreferredWidth(width);
            tablewidth += width;
            ++i;
        }
        if (editable) {
            this._table.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent ke) {
                    char ch = ke.getKeyChar();
                    if (ch == '\u007f' || ch == 'X') {
                        SpeedProfilePanel.this.deleteRow();
                    } else if (ch == '\n') {
                        int row = SpeedProfilePanel.this._table.getEditingRow();
                        if (row < 0) {
                            row = SpeedProfilePanel.this._table.getSelectedRow();
                        }
                        if (row >= 0) {
                            SpeedProfilePanel.this.rePack(row);
                        }
                    }
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }
            });
            this._table.getColumnModel().getColumn(2).setCellRenderer(new ColorCellRenderer());
            this._table.getColumnModel().getColumn(3).setCellRenderer(new ColorCellRenderer());
        }
        this._scrollPane = new JScrollPane(this._table);
        int barWidth = 5 + this._scrollPane.getVerticalScrollBar().getPreferredSize().width;
        this._scrollPane.setPreferredSize(new Dimension(tablewidth += barWidth, tablewidth));
        try {
            this._entryFlavor = new DataFlavor(entryFlavorType);
            if (editable) {
                this._table.setTransferHandler(new ImportEntryTranferHandler());
                this._table.setDragEnabled(true);
                this._scrollPane.setTransferHandler(new ImportEntryTranferHandler());
            } else {
                this._table.setTransferHandler(new ExportEntryTranferHandler());
                this._table.setDragEnabled(true);
            }
        }
        catch (ClassNotFoundException cnfe) {
            log.error("SpeedProfilePanel unable to Drag and Drop {}", (Throwable)cnfe);
        }
        this.add(this._scrollPane);
        if (anomalies != null) {
            this.setAnomalies(anomalies);
        }
    }

    void setAnomalies(Map<Integer, Boolean> anomalies) {
        SpeedTableModel model = (SpeedTableModel)this._table.getModel();
        model.setAnomaly(anomalies);
        if (anomalies != null && anomalies.size() > 0) {
            JScrollBar bar = this._scrollPane.getVerticalScrollBar();
            bar.setValue(50);
            int numRows = model.getRowCount();
            Integer key = 1000;
            for (int k : anomalies.keySet()) {
                if (k >= key) continue;
                key = k;
            }
            TreeMap<Integer, RosterSpeedProfile.SpeedStep> speeds = model.getProfileSpeeds();
            Map.Entry<Integer, RosterSpeedProfile.SpeedStep> entry = speeds.higherEntry(key);
            if (entry == null) {
                entry = speeds.lowerEntry(key);
            }
            int row = model.getRow(entry);
            int pos = (int)((double)((float)row * (float)bar.getMaximum() / (float)numRows) + 0.5);
            bar.setValue(pos);
        }
    }

    private void deleteRow() {
        int row = this._table.getSelectedRow();
        if (row >= 0) {
            SpeedTableModel model = (SpeedTableModel)this._table.getModel();
            Map.Entry<Integer, RosterSpeedProfile.SpeedStep> entry = model.speedArray.get(row);
            model.speedArray.remove(entry);
            model._profile.deleteStep(entry.getKey());
            model.fireTableDataChanged();
        }
    }

    private void rePack(int row) {
        SpeedTableModel model = (SpeedTableModel)this._table.getModel();
        Map.Entry<Integer, RosterSpeedProfile.SpeedStep> entry = model.getRowEntry(row);
        this.setAnomalies(model.updateAnomaly(entry));
        model.fireTableDataChanged();
    }

    public static class ColorCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            SpeedTableModel model = (SpeedTableModel)table.getModel();
            Map<Integer, Boolean> anomalies = model.getAnomalies();
            if (anomalies == null || anomalies.size() == 0) {
                c.setBackground(table.getBackground());
                return c;
            }
            Map.Entry<Integer, RosterSpeedProfile.SpeedStep> entry = model.getRowEntry(row);
            Boolean direction = anomalies.get(entry.getKey());
            if (direction == null) {
                c.setBackground(table.getBackground());
                return c;
            }
            boolean dir = direction;
            if (dir && col == 2) {
                c.setBackground(myRed);
            } else if (!dir && col == 3) {
                c.setBackground(myRed);
            }
            return c;
        }
    }

    class EntrySelection
    implements Transferable {
        Integer _key;
        RosterSpeedProfile.SpeedStep _step;

        public EntrySelection(Map.Entry<Integer, RosterSpeedProfile.SpeedStep> entry) {
            this._key = entry.getKey();
            this._step = new RosterSpeedProfile.SpeedStep();
            RosterSpeedProfile.SpeedStep step = entry.getValue();
            this._step.setForwardSpeed(step.getForwardSpeed());
            this._step.setReverseSpeed(step.getReverseSpeed());
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{SpeedProfilePanel.this._entryFlavor, DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            if (SpeedProfilePanel.this._entryFlavor.equals(flavor)) {
                return true;
            }
            return DataFlavor.stringFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (SpeedProfilePanel.this._entryFlavor.equals(flavor)) {
                return new AbstractMap.SimpleEntry<Integer, RosterSpeedProfile.SpeedStep>(this._key, this._step);
            }
            if (DataFlavor.stringFlavor.equals(flavor)) {
                StringBuilder msg = new StringBuilder();
                msg.append(this._key.toString());
                msg.append(',');
                msg.append(this._step.getForwardSpeed());
                msg.append(',');
                msg.append(this._step.getReverseSpeed());
                return msg.toString();
            }
            log.warn("EntrySelection.getTransferData: {}", (Object)flavor);
            throw new UnsupportedFlavorException(flavor);
        }
    }

    class ExportEntryTranferHandler
    extends TransferHandler {
        ExportEntryTranferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        public Transferable createTransferable(JComponent c) {
            if (!(c instanceof JTable)) {
                return null;
            }
            JTable table = (JTable)c;
            int row = table.getSelectedRow();
            if (row < 0) {
                return null;
            }
            row = table.convertRowIndexToModel(row);
            SpeedTableModel model = (SpeedTableModel)table.getModel();
            return new EntrySelection(model.getRowEntry(row));
        }
    }

    class ImportEntryTranferHandler
    extends ExportEntryTranferHandler {
        ImportEntryTranferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            DataFlavor[] flavors = support.getDataFlavors();
            if (flavors == null) {
                return false;
            }
            int k = 0;
            while (k < flavors.length) {
                if (SpeedProfilePanel.this._entryFlavor.equals(flavors[k])) {
                    return true;
                }
                ++k;
            }
            return false;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            Object obj;
            JTable table;
            block13: {
                if (!this.canImport(support)) {
                    return false;
                }
                if (!support.isDrop()) {
                    return false;
                }
                table = SpeedProfilePanel.this._table;
                Transferable trans = support.getTransferable();
                obj = trans.getTransferData(SpeedProfilePanel.this._entryFlavor);
                if (obj instanceof Map.Entry) break block13;
                return false;
            }
            try {
                Map.Entry sourceEntry = (Map.Entry)obj;
                RosterSpeedProfile.SpeedStep sss = (RosterSpeedProfile.SpeedStep)sourceEntry.getValue();
                SpeedTableModel model = (SpeedTableModel)table.getModel();
                Integer key = (Integer)sourceEntry.getKey();
                Map.Entry<Integer, RosterSpeedProfile.SpeedStep> entry = model.getKeyEntry(key);
                if (entry != null) {
                    RosterSpeedProfile.SpeedStep ss = entry.getValue();
                    if (sss.getForwardSpeed() > 0.0f) {
                        if (ss.getForwardSpeed() <= 0.0f) {
                            ss.setForwardSpeed(sss.getForwardSpeed());
                        } else {
                            ss.setForwardSpeed((sss.getForwardSpeed() + ss.getForwardSpeed()) / 2.0f);
                        }
                    }
                    if (sss.getReverseSpeed() > 0.0f) {
                        if (ss.getReverseSpeed() <= 0.0f) {
                            ss.setReverseSpeed(sss.getReverseSpeed());
                        } else {
                            ss.setReverseSpeed((sss.getReverseSpeed() + ss.getReverseSpeed()) / 2.0f);
                        }
                    }
                } else {
                    model.addEntry(sourceEntry);
                }
                this.rePack(key);
                return true;
            }
            catch (UnsupportedFlavorException | IOException ufe) {
                log.warn("MergeTranferHandler.importData: {}", (Throwable)ufe);
                return false;
            }
        }

        private void rePack(Integer key) {
            SpeedTableModel model = (SpeedTableModel)SpeedProfilePanel.this._table.getModel();
            SpeedProfilePanel.this.setAnomalies(model.updateAnomaly(model.getKeyEntry(key)));
            model.fireTableDataChanged();
        }
    }

    static class SpeedTableModel
    extends AbstractTableModel {
        static final int STEP_COL = 0;
        static final int THROTTLE_COL = 1;
        static final int FORWARD_SPEED_COL = 2;
        static final int REVERSE_SPEED_COL = 3;
        static final int NUMCOLS = 4;
        DecimalFormat threeDigit = new DecimalFormat("0.000");
        ArrayList<Map.Entry<Integer, RosterSpeedProfile.SpeedStep>> speedArray = new ArrayList();
        RosterSpeedProfile _profile;
        Boolean _editable;
        Map<Integer, Boolean> _anomaly;

        SpeedTableModel(RosterSpeedProfile sp, boolean editable, Map<Integer, Boolean> anomalies) {
            this._profile = sp;
            this._editable = editable;
            this._anomaly = anomalies;
            TreeMap<Integer, RosterSpeedProfile.SpeedStep> speeds = sp.getProfileSpeeds();
            Map.Entry<Integer, RosterSpeedProfile.SpeedStep> entry = speeds.firstEntry();
            while (entry != null) {
                this.speedArray.add(entry);
                entry = speeds.higherEntry(entry.getKey());
            }
        }

        Map<Integer, Boolean> getAnomalies() {
            return this._anomaly;
        }

        void setAnomaly(Map<Integer, Boolean> an) {
            this._anomaly = an;
        }

        private Map<Integer, Boolean> updateAnomaly(Map.Entry<Integer, RosterSpeedProfile.SpeedStep> entry) {
            RosterSpeedProfile.SpeedStep ss = entry.getValue();
            this._profile.setSpeed(entry.getKey(), ss.getForwardSpeed(), ss.getReverseSpeed());
            this._anomaly = MergePrompt.validateSpeedProfile(this._profile);
            log.debug("updateAnomaly size={}", (Object)this._anomaly.size());
            return this._anomaly;
        }

        Map.Entry<Integer, RosterSpeedProfile.SpeedStep> getRowEntry(int row) {
            return this.speedArray.get(row);
        }

        Map.Entry<Integer, RosterSpeedProfile.SpeedStep> getKeyEntry(Integer key) {
            for (Map.Entry<Integer, RosterSpeedProfile.SpeedStep> entry : this.speedArray) {
                if (!entry.getKey().equals(key)) continue;
                return entry;
            }
            return null;
        }

        TreeMap<Integer, RosterSpeedProfile.SpeedStep> getProfileSpeeds() {
            return this._profile.getProfileSpeeds();
        }

        void addEntry(Map.Entry<Integer, RosterSpeedProfile.SpeedStep> entry) {
            RosterSpeedProfile.SpeedStep ss = entry.getValue();
            Integer key = entry.getKey();
            this._profile.setSpeed(key, ss.getForwardSpeed(), ss.getReverseSpeed());
            int row = 0;
            while (row < this.speedArray.size()) {
                int k = this.speedArray.get(row).getKey();
                if (key < k) {
                    this.speedArray.add(row, entry);
                    log.debug("addEntry _profile size={}, speedArray size={}", (Object)this._profile.getProfileSize(), (Object)this.speedArray.size());
                    return;
                }
                ++row;
            }
            this.speedArray.add(entry);
        }

        int getRow(Map.Entry<Integer, RosterSpeedProfile.SpeedStep> entry) {
            return this.speedArray.indexOf(entry);
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.speedArray.size();
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Bundle.getMessage("step");
                }
                case 1: {
                    return Bundle.getMessage("throttle");
                }
                case 2: {
                    return Bundle.getMessage("forward");
                }
                case 3: {
                    return Bundle.getMessage("reverse");
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return String.class;
        }

        public int getPreferredWidth(int col) {
            switch (col) {
                case 0: {
                    return new JTextField((int)3).getPreferredSize().width;
                }
                case 1: {
                    return new JTextField((int)6).getPreferredSize().width;
                }
                case 2: 
                case 3: {
                    return new JTextField((int)8).getPreferredSize().width;
                }
            }
            return new JTextField((int)8).getPreferredSize().width;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return this._editable != false && (col == 2 || col == 3);
        }

        @Override
        public Object getValueAt(int row, int col) {
            Map.Entry<Integer, RosterSpeedProfile.SpeedStep> entry = this.speedArray.get(row);
            switch (col) {
                case 0: {
                    return Math.round((float)(entry.getKey() * 126) / 1000.0f);
                }
                case 1: {
                    return this.threeDigit.format((float)entry.getKey().intValue() / 1000.0f);
                }
                case 2: {
                    float speed = entry.getValue().getForwardSpeed();
                    return this.threeDigit.format(speed);
                }
                case 3: {
                    float speed = entry.getValue().getReverseSpeed();
                    return this.threeDigit.format(speed);
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (!this._editable.booleanValue()) {
                return;
            }
            Map.Entry<Integer, RosterSpeedProfile.SpeedStep> entry = this.speedArray.get(row);
            try {
                switch (col) {
                    case 2: {
                        entry.getValue().setForwardSpeed(Float.parseFloat(((String)value).replace(',', '.')));
                        return;
                    }
                    case 3: {
                        entry.getValue().setReverseSpeed(Float.parseFloat(((String)value).replace(',', '.')));
                        return;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                log.error("SpeedTableModel ({}, {}) value={}", new Object[]{row, col, value});
            }
        }
    }
}

