/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import java.util.ArrayList;
import java.util.ListIterator;
import jmri.jmrit.logix.SpeedUtil;

public class RampData {
    private int _timeInterval;
    private float _throttleInterval;
    private ArrayList<Float> _settings;
    private boolean _upRamp;
    private SpeedUtil _speedUtil;
    static float INCRE_RATE = 1.1f;

    RampData(SpeedUtil util, float throttleIncre, int timeIncre, float fromSet, float toSet) {
        this._throttleInterval = throttleIncre;
        this._timeInterval = timeIncre;
        this._speedUtil = util;
        this.makeThrottleSettings(fromSet, toSet);
    }

    protected boolean isUpRamp() {
        return this._upRamp;
    }

    private void makeThrottleSettings(float fromSet, float toSet) {
        float highSetting;
        float lowSetting;
        this._upRamp = toSet >= fromSet;
        this._settings = new ArrayList();
        float throttleIncre = this._throttleInterval;
        if (this._upRamp) {
            lowSetting = fromSet;
            highSetting = toSet;
        } else {
            lowSetting = toSet;
            highSetting = fromSet;
        }
        while (lowSetting < highSetting) {
            this._settings.add(Float.valueOf(lowSetting));
            lowSetting += throttleIncre;
            throttleIncre *= INCRE_RATE;
        }
        this._settings.add(Float.valueOf(highSetting));
    }

    protected float getRampLength(String speedType) {
        float rampLength = 0.0f;
        if (this._upRamp) {
            ListIterator<Float> iter = this.speedIterator(true);
            float prevSetting = 0.0f;
            if (iter.hasNext()) {
                prevSetting = iter.next().floatValue();
            }
            while (iter.hasNext()) {
                float nextSetting = iter.next().floatValue();
                rampLength += this._speedUtil.getDistanceOfSpeedChange(prevSetting, nextSetting, this._timeInterval);
                prevSetting = nextSetting;
            }
        } else {
            ListIterator<Float> iter = this.speedIterator(false);
            float prevSetting = 1.0f;
            if (iter.hasPrevious()) {
                prevSetting = iter.previous().floatValue();
            }
            while (iter.hasPrevious()) {
                float nextSetting = iter.previous().floatValue();
                rampLength += this._speedUtil.getDistanceOfSpeedChange(prevSetting, nextSetting, this._timeInterval);
                prevSetting = nextSetting;
            }
        }
        return rampLength;
    }

    protected int getNumSteps() {
        return this._settings.size();
    }

    protected int getRamptime() {
        return (this._settings.size() - 1) * this._timeInterval;
    }

    protected float getMaxSpeed() {
        if (this._settings == null) {
            throw new IllegalArgumentException("Null array of throttle settings");
        }
        return this._settings.get(this._settings.size() - 1).floatValue();
    }

    protected ListIterator<Float> speedIterator(boolean up) {
        if (up) {
            return this._settings.listIterator(0);
        }
        return this._settings.listIterator(this._settings.size());
    }

    protected int getRampTimeIncrement() {
        return this._timeInterval;
    }
}

