/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jmri.Block;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.Signal;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.implementation.SignalSpeedMap;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OPath;
import jmri.jmrit.logix.PortalManager;
import jmri.jmrit.logix.WarrantManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Portal {
    private static final String NAME_CHANGE = "NameChange";
    private static final String SIGNAL_CHANGE = "signalChange";
    private static final String ENTRANCE = "entrance";
    private final ArrayList<OPath> _fromPaths = new ArrayList();
    private OBlock _fromBlock;
    private NamedBean _fromSignal;
    private float _fromSignalOffset;
    private final ArrayList<OPath> _toPaths = new ArrayList();
    private OBlock _toBlock;
    private NamedBean _toSignal;
    private float _toSignalOffset;
    private String _name;
    private int _state = 1;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    public static final int UNKNOWN = 1;
    public static final int ENTER_TO_BLOCK = 2;
    public static final int ENTER_FROM_BLOCK = 4;
    private static final Logger log = LoggerFactory.getLogger(Portal.class);

    public Portal(String uName) {
        this._name = uName;
    }

    public boolean addPath(@Nonnull OPath path) {
        Block block = path.getBlock();
        if (block == null) {
            log.error("Path \"{}\" has no block.", (Object)path.getName());
            return false;
        }
        if (!this.equals(path.getFromPortal()) && !this.equals(path.getToPortal())) {
            return false;
        }
        if (this._fromBlock != null && this._fromBlock.equals(block)) {
            return this.addPath(this._fromPaths, path);
        }
        if (this._toBlock != null && this._toBlock.equals(block)) {
            return this.addPath(this._toPaths, path);
        }
        return false;
    }

    private boolean addPath(@Nonnull List<OPath> list, @Nonnull OPath path) {
        String pName = path.getName();
        for (OPath p : list) {
            if (p.equals(path)) {
                if (pName.equals(p.getName())) {
                    return true;
                }
                log.warn("Path \"{}\" is duplicate of path \"{}\" in Portal \"{}\" from block {}.", new Object[]{path.getName(), p.getName(), this._name, path.getBlock().getDisplayName()});
                return false;
            }
            if (!pName.equals(p.getName())) continue;
            log.warn("Path \"{}\" is duplicate name for another path in Portal \"{}\" from block {}.", new Object[]{path.getName(), this._name, path.getBlock().getDisplayName()});
            return false;
        }
        list.add(path);
        return true;
    }

    public void removePath(@Nonnull OPath path) {
        Block block = path.getBlock();
        if (block == null) {
            log.error("Path \"{}\" has no block.", (Object)path.getName());
            return;
        }
        log.debug("removePath: {}", (Object)this);
        if (!this.equals(path.getFromPortal()) && !this.equals(path.getToPortal())) {
            return;
        }
        if (this._fromBlock != null && this._fromBlock.equals(block)) {
            this._fromPaths.remove(path);
        } else if (this._toBlock != null && this._toBlock.equals(block)) {
            this._toPaths.remove(path);
        }
    }

    public String setName(String newName) {
        if (newName == null || newName.length() == 0) {
            return null;
        }
        String oldName = this._name;
        if (newName.equals(oldName)) {
            return null;
        }
        Portal p = InstanceManager.getDefault(PortalManager.class).getPortal(newName);
        if (p != null) {
            return Bundle.getMessage("DuplicatePortalName", newName, p.getDescription());
        }
        this._name = newName;
        InstanceManager.getDefault(WarrantManager.class).portalNameChange(oldName, newName);
        if (this._toBlock != null) {
            this._toBlock.pseudoPropertyChange(NAME_CHANGE, oldName, this);
        } else if (this._fromBlock != null) {
            this._fromBlock.pseudoPropertyChange(NAME_CHANGE, oldName, this);
        }
        this.pcs.firePropertyChange(NAME_CHANGE, oldName, newName);
        return null;
    }

    public String getName() {
        return this._name;
    }

    public boolean setToBlock(OBlock block, boolean changePaths) {
        if (block != null && block.equals(this._toBlock) || block == null && this._toBlock == null) {
            return true;
        }
        if (changePaths) {
            for (OPath opa : this._toPaths) {
                opa.setBlock(block);
            }
        } else if (!Portal.verify(this._toPaths, block)) {
            return false;
        }
        log.debug("setToBlock: oldBlock= \"{}\" newBlock \"{}\".", (Object)this.getToBlockName(), (Object)(block != null ? block.getDisplayName() : null));
        OBlock oldBlock = this._toBlock;
        if (this._toBlock != null) {
            this._toBlock.removePortal(this);
        }
        this._toBlock = block;
        if (this._toBlock != null) {
            this._toBlock.addPortal(this);
        }
        this.pcs.firePropertyChange("BlockChanged", oldBlock, this._toBlock);
        return true;
    }

    public OBlock getToBlock() {
        return this._toBlock;
    }

    public String getToBlockName() {
        return this._toBlock != null ? this._toBlock.getDisplayName() : null;
    }

    public List<OPath> getToPaths() {
        return this._toPaths;
    }

    public boolean setFromBlock(OBlock block, boolean changePaths) {
        if (block != null && block.equals(this._fromBlock) || block == null && this._fromBlock == null) {
            return true;
        }
        if (changePaths) {
            for (OPath fromPath : this._fromPaths) {
                fromPath.setBlock(block);
            }
        } else if (!Portal.verify(this._fromPaths, block)) {
            return false;
        }
        log.debug("setFromBlock: oldBlock= \"{}\" newBlock \"{}\".", (Object)this.getFromBlockName(), (Object)(block != null ? block.getDisplayName() : null));
        OBlock oldBlock = this._fromBlock;
        if (this._fromBlock != null) {
            this._fromBlock.removePortal(this);
        }
        this._fromBlock = block;
        if (this._fromBlock != null) {
            this._fromBlock.addPortal(this);
        }
        this.pcs.firePropertyChange("BlockChanged", oldBlock, this._fromBlock);
        return true;
    }

    public OBlock getFromBlock() {
        return this._fromBlock;
    }

    public String getFromBlockName() {
        return this._fromBlock != null ? this._fromBlock.getDisplayName() : null;
    }

    public List<OPath> getFromPaths() {
        return this._fromPaths;
    }

    public boolean setProtectSignal(@Nullable NamedBean signal, float length, OBlock protectedBlock) {
        if (protectedBlock == null) {
            return false;
        }
        boolean ret = false;
        if (this._fromBlock != null && this._fromBlock.equals(protectedBlock)) {
            this._toSignal = signal;
            this._toSignalOffset = length;
            log.debug("OPortal FromBlock Offset set to {} on signal {}", (Object)Float.valueOf(this._toSignalOffset), (Object)(this._toSignal != null ? this._toSignal.getDisplayName() : "<removed>"));
            ret = true;
        }
        if (this._toBlock != null && this._toBlock.equals(protectedBlock)) {
            this._fromSignal = signal;
            this._fromSignalOffset = length;
            log.debug("OPortal ToBlock Offset set to {} on signal {}", (Object)Float.valueOf(this._fromSignalOffset), (Object)(this._fromSignal != null ? this._fromSignal.getDisplayName() : "<removed>"));
            ret = true;
        }
        if (ret) {
            protectedBlock.pseudoPropertyChange(SIGNAL_CHANGE, false, true);
            this.pcs.firePropertyChange(SIGNAL_CHANGE, false, true);
            log.debug("setProtectSignal: \"{}\" for Block= {} at Portal {}", new Object[]{signal != null ? signal.getDisplayName() : "null", protectedBlock.getDisplayName(), this._name});
        }
        return ret;
    }

    public NamedBean getSignalProtectingBlock(@Nonnull OBlock block) {
        if (block.equals(this._toBlock)) {
            return this._fromSignal;
        }
        if (block.equals(this._fromBlock)) {
            return this._toSignal;
        }
        return null;
    }

    public OBlock getProtectedBlock(NamedBean signal) {
        if (signal == null) {
            return null;
        }
        if (signal.equals(this._fromSignal)) {
            return this._toBlock;
        }
        if (signal.equals(this._toSignal)) {
            return this._fromBlock;
        }
        return null;
    }

    public NamedBean getFromSignal() {
        return this._fromSignal;
    }

    public String getFromSignalName() {
        return this._fromSignal != null ? this._fromSignal.getDisplayName() : null;
    }

    public float getFromSignalOffset() {
        return this._fromSignalOffset;
    }

    public NamedBean getToSignal() {
        return this._toSignal;
    }

    public String getToSignalName() {
        return this._toSignal != null ? this._toSignal.getDisplayName() : null;
    }

    public float getToSignalOffset() {
        return this._toSignalOffset;
    }

    public void deleteSignal(@Nonnull NamedBean signal) {
        if (signal.equals(this._toSignal)) {
            this._toSignal = null;
            this._toSignalOffset = 0.0f;
            if (this._fromBlock != null) {
                this._fromBlock.pseudoPropertyChange(SIGNAL_CHANGE, false, false);
                this.pcs.firePropertyChange(SIGNAL_CHANGE, false, false);
            }
        } else if (signal.equals(this._fromSignal)) {
            this._fromSignal = null;
            this._fromSignalOffset = 0.0f;
            if (this._toBlock != null) {
                this._toBlock.pseudoPropertyChange(SIGNAL_CHANGE, false, false);
                this.pcs.firePropertyChange(SIGNAL_CHANGE, false, false);
            }
        }
    }

    public static NamedBean getSignal(String name) {
        Signal signal = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(name);
        if (signal == null) {
            signal = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(name);
        }
        return signal;
    }

    public List<OPath> getPathsWithinBlock(OBlock block) {
        if (block == null) {
            return null;
        }
        if (block.equals(this._fromBlock)) {
            return this._fromPaths;
        }
        if (block.equals(this._toBlock)) {
            return this._toPaths;
        }
        return null;
    }

    public OBlock getOpposingBlock(@Nonnull OBlock block) {
        if (block.equals(this._fromBlock)) {
            return this._toBlock;
        }
        if (block.equals(this._toBlock)) {
            return this._fromBlock;
        }
        return null;
    }

    public List<OPath> getPathsFromOpposingBlock(@Nonnull OBlock block) {
        if (block.equals(this._fromBlock)) {
            return this._toPaths;
        }
        if (block.equals(this._toBlock)) {
            return this._fromPaths;
        }
        return null;
    }

    protected void setEntryState(OBlock block) {
        if (block == null) {
            this._state = 1;
        } else if (block.equals(this._fromBlock)) {
            this.setState(4);
        } else if (block.equals(this._toBlock)) {
            this.setState(2);
        }
    }

    public void setState(int s) {
        int old = this._state;
        this._state = s;
        this.pcs.firePropertyChange("Direction", old, this._state);
    }

    public int getState() {
        return this._state;
    }

    @OverridingMethodsMustInvokeSuper
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @OverridingMethodsMustInvokeSuper
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Deprecated
    public String getPermissibleEntranceSpeed(@Nonnull OBlock block) {
        return this.getPermissibleSpeed(block, true);
    }

    public void setEntranceSpaceForBlock(@Nonnull OBlock block, float distance) {
        if (block.equals(this._toBlock)) {
            if (this._fromSignal != null) {
                this._fromSignalOffset = distance;
            }
        } else if (block.equals(this._fromBlock) && this._toSignal != null) {
            this._toSignalOffset = distance;
        }
    }

    public float getEntranceSpaceForBlock(@Nonnull OBlock block) {
        if (block.equals(this._toBlock)) {
            if (this._fromSignal != null) {
                return this._fromSignalOffset;
            }
        } else if (block.equals(this._fromBlock) && this._toSignal != null) {
            return this._toSignalOffset;
        }
        return 0.0f;
    }

    @Deprecated
    public String getPermissibleExitSpeed(@Nonnull OBlock block) {
        return this.getPermissibleSpeed(block, false);
    }

    public String getPermissibleSpeed(@Nonnull OBlock block, boolean entrance) {
        String speed = null;
        String blockName = block.getDisplayName();
        if (block.equals(this._toBlock)) {
            if (this._fromSignal != null) {
                speed = this._fromSignal instanceof SignalHead ? Portal.getPermissibleSignalSpeed((SignalHead)this._fromSignal, entrance) : Portal.getPermissibleSignalSpeed((SignalMast)this._fromSignal, entrance);
            }
        } else if (block.equals(this._fromBlock)) {
            if (this._toSignal != null) {
                speed = this._toSignal instanceof SignalHead ? Portal.getPermissibleSignalSpeed((SignalHead)this._toSignal, entrance) : Portal.getPermissibleSignalSpeed((SignalMast)this._toSignal, entrance);
            }
        } else {
            log.error("Block \"{}\" is not in Portal \"{}\".", (Object)blockName, (Object)this._name);
        }
        if (log.isDebugEnabled() && speed != null) {
            log.debug("Portal \"{}\" has {} speed= {} into \"{}\" from signal.", new Object[]{this._name, entrance ? "ENTRANCE" : "EXIT", speed, blockName});
        }
        return speed;
    }

    @Nonnull
    private static String getPermissibleSignalSpeed(@Nonnull SignalHead signal, boolean entrance) {
        int appearance = signal.getAppearance();
        String speed = InstanceManager.getDefault(SignalSpeedMap.class).getAppearanceSpeed(signal.getAppearanceName(appearance));
        if (speed == null) {
            log.error("SignalHead \"{}\" has no {} speed specified for appearance \"{}\"! - Restricting Movement!", new Object[]{signal.getDisplayName(), entrance ? ENTRANCE : "exit", signal.getAppearanceName(appearance)});
            speed = "Restricted";
        }
        log.debug("SignalHead \"{}\" has {} speed notch= {} from appearance \"{}\"", new Object[]{signal.getDisplayName(), entrance ? ENTRANCE : "exit", speed, signal.getAppearanceName(appearance)});
        return speed;
    }

    @Nonnull
    private static String getPermissibleSignalSpeed(@Nonnull SignalMast signal, boolean entrance) {
        String aspect = signal.getAspect();
        String speed = entrance ? InstanceManager.getDefault(SignalSpeedMap.class).getAspectSpeed(aspect, signal.getSignalSystem()) : InstanceManager.getDefault(SignalSpeedMap.class).getAspectExitSpeed(aspect, signal.getSignalSystem());
        if (speed == null) {
            log.error("SignalMast \"{}\" has no {} speed specified for aspect \"{}\"! - Restricting Movement!", new Object[]{signal.getDisplayName(), entrance ? ENTRANCE : "exit", aspect});
            speed = "Restricted";
        }
        log.debug("SignalMast \"{}\" has {} speed notch= {} from aspect \"{}\"", new Object[]{signal.getDisplayName(), entrance ? ENTRANCE : "exit", speed, aspect});
        return speed;
    }

    private static boolean verify(List<OPath> paths, OBlock block) {
        if (block == null) {
            return paths.isEmpty();
        }
        String name = block.getSystemName();
        for (OPath path : paths) {
            Block blk = path.getBlock();
            if (blk == null) {
                log.error("Path \"{}\" belongs to null block. Cannot verify set block to \"{}\"", (Object)path.getName(), (Object)name);
                return false;
            }
            String pathName = blk.getSystemName();
            if (pathName.equals(name)) continue;
            log.warn("Path \"{}\" belongs to block \"{}\". Cannot verify set block to \"{}\"", new Object[]{path.getName(), pathName, name});
            return false;
        }
        return true;
    }

    public boolean isValidPath(OPath path) {
        String name = path.getName();
        for (OPath toPath : this._toPaths) {
            if (!toPath.getName().equals(name)) continue;
            return true;
        }
        for (OPath fromPath : this._fromPaths) {
            if (!fromPath.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isValid() {
        if (this._toBlock == null || this._fromBlock == null) {
            return false;
        }
        return !this._toBlock.equals(this._fromBlock);
    }

    @OverridingMethodsMustInvokeSuper
    public boolean dispose() {
        PropertyChangeListener[] listeners;
        if (!InstanceManager.getDefault(WarrantManager.class).okToRemovePortal(this)) {
            return false;
        }
        if (this._toBlock != null) {
            this._toBlock.removePortal(this);
        }
        if (this._fromBlock != null) {
            this._fromBlock.removePortal(this);
        }
        this.pcs.firePropertyChange("portalDelete", true, false);
        PropertyChangeListener[] propertyChangeListenerArray = listeners = this.pcs.getPropertyChangeListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener l = propertyChangeListenerArray[n2];
            this.pcs.removePropertyChangeListener(l);
            ++n2;
        }
        return true;
    }

    public String getDescription() {
        return Bundle.getMessage("PortalDescription", this._name, this.getFromBlockName(), this.getToBlockName());
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder("Portal \"");
        sb.append(this._name);
        sb.append("\" from block \"");
        sb.append(this.getFromBlockName());
        sb.append("\" to block \"");
        sb.append(this.getToBlockName());
        sb.append("\"");
        return sb.toString();
    }
}

