/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.Timer;
import jmri.BeanSetting;
import jmri.Block;
import jmri.InstanceManager;
import jmri.Path;
import jmri.Turnout;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.Portal;
import jmri.jmrit.logix.WarrantManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OPath
extends Path {
    private Portal _fromPortal;
    private Portal _toPortal;
    private String _name;
    private Timer _timer;
    private boolean _timerActive = false;
    private TimeTurnout _listener;
    private static final Logger log = LoggerFactory.getLogger(OPath.class);

    public OPath(Block owner, String name) {
        super(owner, 0, 0);
        this._name = name;
    }

    public OPath(String name, OBlock owner, Portal entry, Portal exit, List<BeanSetting> settings) {
        super(owner, 0, 0);
        this._name = name;
        this._fromPortal = entry;
        this._toPortal = exit;
        if (settings != null) {
            for (BeanSetting setting : settings) {
                this.addSetting(setting);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("OPath Ctor: name= {}, block= {}, fromPortal= {}, toPortal= {}", new Object[]{name, owner.getDisplayName(), this._fromPortal == null ? "null" : this._fromPortal.getName(), this._toPortal == null ? "null" : this._toPortal.getName()});
        }
    }

    protected String getOppositePortalName(String name) {
        if (this._fromPortal != null && this._fromPortal.getName().equals(name) && this._toPortal != null) {
            return this._toPortal.getName();
        }
        if (this._toPortal != null && this._toPortal.getName().equals(name) && this._fromPortal != null) {
            return this._fromPortal.getName();
        }
        return null;
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="OBlock extends Block")
    public void setName(String name) {
        log.debug("OPath \"{}\" setName to \"{}\"", (Object)this._name, (Object)name);
        if (name == null || name.length() == 0) {
            return;
        }
        String oldName = this._name;
        this._name = name;
        OBlock block = (OBlock)this.getBlock();
        block.pseudoPropertyChange("pathName", oldName, this._name);
        InstanceManager.getDefault(WarrantManager.class).pathNameChange(block, oldName, this._name);
        if (this._fromPortal != null && this._fromPortal.addPath(this)) {
            return;
        }
        if (this._toPortal != null) {
            this._toPortal.addPath(this);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setFromPortal(Portal p) {
        if (p != null) {
            log.debug("OPath \"{}\" setFromPortal= \"{}\"", (Object)this._name, (Object)p.getName());
        }
        this._fromPortal = p;
    }

    public Portal getFromPortal() {
        return this._fromPortal;
    }

    public void setToPortal(Portal p) {
        if (p != null) {
            log.debug("OPath \"{}\" setToPortal= \"{}\"", (Object)this._name, (Object)p.getName());
        }
        this._toPortal = p;
    }

    public Portal getToPortal() {
        return this._toPortal;
    }

    public void setTurnouts(int delay, boolean set, int lockState, boolean lock) {
        if (delay > 0) {
            if (!this._timerActive) {
                if (this._timer == null) {
                    this._listener = new TimeTurnout();
                    this._timer = new Timer(2000, this._listener);
                    this._timer.setRepeats(false);
                }
                this._listener.setList(this.getSettings());
                this._listener.setParams(set, lockState, lock);
                this._timer.setInitialDelay(delay * 1000);
                this._timer.start();
                this._timerActive = true;
            } else {
                log.warn("timer already active for delayed turnout action on path {}", (Object)this);
            }
        } else {
            this.fireTurnouts(this.getSettings(), set, lockState, lock);
        }
    }

    private void fireTurnouts(List<BeanSetting> list, boolean set, int lockState, boolean lock) {
        for (BeanSetting bs : list) {
            Turnout t = (Turnout)bs.getBean();
            if (set) {
                t.setCommandedState(bs.getSetting());
            }
            if (lockState <= 0) continue;
            t.setLocked(lockState, lock);
        }
    }

    public void dispose() {
        if (this._fromPortal != null) {
            this._fromPortal.removePath(this);
        }
        if (this._toPortal != null) {
            this._toPortal.removePath(this);
        }
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder("\"");
        sb.append(this._name);
        sb.append("\" from portal \"");
        sb.append(this._fromPortal == null ? "null" : this._fromPortal.getName());
        sb.append("\" to portal \"");
        sb.append(this._toPortal == null ? "null" : this._toPortal.getName());
        sb.append("\"");
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("OPath \"");
        sb.append(this._name);
        sb.append("\" on block \"");
        sb.append(this.getBlock() == null ? "null" : this.getBlock().getDisplayName());
        sb.append("\" from portal \"");
        sb.append(this._fromPortal == null ? "null" : this._fromPortal.getName());
        sb.append("\" to portal \"");
        sb.append(this._toPortal == null ? "null" : this._toPortal.getName());
        sb.append("\" sets ");
        sb.append(this.getSettings().size());
        sb.append("\" turnouts.");
        return sb.toString();
    }

    @Override
    public void addSetting(BeanSetting t) {
        for (BeanSetting bs : this.getSettings()) {
            if (!bs.getBeanName().equals(t.getBeanName())) continue;
            log.error("TO setting for \"{}\" already set to {}", (Object)t.getBeanName(), (Object)bs.getSetting());
            return;
        }
        super.addSetting(t);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.getBlock());
        hash = 67 * hash + Objects.hashCode(this._fromPortal);
        hash = 67 * hash + Objects.hashCode(this._toPortal);
        hash = 67 * hash + Objects.hashCode(this.getSettings());
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OPath path = (OPath)obj;
        if (this.getBlock() != path.getBlock()) {
            return false;
        }
        Portal fromPort = path.getFromPortal();
        Portal toPort = path.getToPortal();
        int numPortals = 0;
        if (fromPort != null) {
            ++numPortals;
        }
        if (toPort != null) {
            ++numPortals;
        }
        if (this._fromPortal != null) {
            --numPortals;
        }
        if (this._toPortal != null) {
            --numPortals;
        }
        if (numPortals != 0) {
            return false;
        }
        if (this._fromPortal != null && !this._fromPortal.equals(fromPort) && !this._fromPortal.equals(toPort)) {
            return false;
        }
        if (this._toPortal != null && !this._toPortal.equals(toPort) && !this._toPortal.equals(fromPort)) {
            return false;
        }
        List<BeanSetting> settings = path.getSettings();
        if (settings.size() != this.getSettings().size()) {
            return false;
        }
        Iterator<BeanSetting> iter = settings.iterator();
        Iterator<BeanSetting> it = this.getSettings().iterator();
        boolean found = false;
        while (iter.hasNext()) {
            BeanSetting beanSetting = iter.next();
            while (it.hasNext()) {
                found = false;
                BeanSetting bs = it.next();
                if (!bs.getBean().getSystemName().equals(beanSetting.getBean().getSystemName()) || bs.getSetting() != beanSetting.getSetting()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    class TimeTurnout
    implements ActionListener {
        private List<BeanSetting> list;
        private int lockState;
        boolean set;
        boolean lock;

        void setList(List<BeanSetting> l) {
            this.list = l;
        }

        void setParams(boolean s, int ls, boolean l) {
            this.set = s;
            this.lockState = ls;
            this.lock = l;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            OPath.this.fireTurnouts(this.list, this.set, this.lockState, this.lock);
            if (OPath.this._timer != null) {
                OPath.this._timer.stop();
                OPath.this._timerActive = false;
            }
        }
    }
}

