/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jmri.Block;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.Path;
import jmri.Sensor;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.OPath;
import jmri.jmrit.logix.Portal;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.logix.WarrantManager;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBlock
extends Block
implements PropertyChangeListener {
    public static final int ALLOCATED = 16;
    public static final int RUNNING = 32;
    public static final int OUT_OF_SERVICE = 64;
    public static final int TRACK_ERROR = 128;
    private static final Color DEFAULT_FILL_COLOR = new Color(200, 0, 200);
    private static final String ALLOCATED_TO_WARRANT = "AllocatedToWarrant";
    private List<Portal> _portals = new ArrayList<Portal>();
    private Warrant _warrant;
    private String _pathName;
    protected long _entryTime;
    private boolean _metric = false;
    private NamedBeanHandle<Sensor> _errNamedSensor;
    private final HashMap<String, List<HashMap<OBlock, List<OPath>>>> _sharedTO = new HashMap();
    private boolean _ownsTOs = false;
    private Color _markerForeground = Color.WHITE;
    private Color _markerBackground = DEFAULT_FILL_COLOR;
    private Font _markerFont;
    private static final Logger log = LoggerFactory.getLogger(OBlock.class);

    public static String getLocalStatusName(String str) {
        return OBlockStatus.getByName(str).descr;
    }

    public static String getSystemStatusName(String str) {
        return OBlockStatus.getByDescr(str).name;
    }

    public OBlock(@Nonnull String systemName) {
        super(systemName);
        this.setState(256);
    }

    public OBlock(@Nonnull String systemName, String userName) {
        super(systemName, userName);
        this.setState(256);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!((OBlock)obj).getSystemName().equals(this.getSystemName())) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.getSystemName().hashCode();
    }

    @Override
    public boolean setSensor(String pName) {
        Sensor oldSensor = this.getSensor();
        Sensor newSensor = null;
        if (pName != null && pName.trim().length() > 0) {
            newSensor = InstanceManager.sensorManagerInstance().getByUserName(pName);
            if (newSensor == null) {
                newSensor = InstanceManager.sensorManagerInstance().getBySystemName(pName);
            }
            if (newSensor == null) {
                log.error("No sensor named '{}' exists.", (Object)pName);
                return false;
            }
        }
        if (oldSensor != null && oldSensor.equals(newSensor)) {
            return true;
        }
        int saveState = this.getState() & 0xFFFFFEF0;
        if (newSensor == null || pName == null) {
            this.setNamedSensor(null);
        } else {
            this.setNamedSensor(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, newSensor));
        }
        this.setState(this.getState() | saveState);
        this.firePropertyChange("OccupancySensorChange", oldSensor, newSensor);
        return true;
    }

    @Override
    public void setNamedSensor(NamedBeanHandle<Sensor> namedSensor) {
        super.setNamedSensor(namedSensor);
        if (namedSensor != null) {
            this.setState(this.getSensor().getState() & 0xFFFFFEFF);
        }
    }

    public boolean setErrorSensor(String pName) {
        NamedBeanHandle<Sensor> newErrSensorHdl = null;
        Sensor newErrSensor = null;
        if (pName != null && pName.trim().length() > 0) {
            newErrSensor = InstanceManager.sensorManagerInstance().getByUserName(pName);
            if (newErrSensor == null) {
                newErrSensor = InstanceManager.sensorManagerInstance().getBySystemName(pName);
            }
            if (newErrSensor != null) {
                newErrSensorHdl = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, newErrSensor);
            }
            if (newErrSensor == null) {
                log.error("No sensor named '{}' exists.", (Object)pName);
                return false;
            }
        }
        if (this._errNamedSensor != null) {
            if (this._errNamedSensor.equals(newErrSensorHdl)) {
                return true;
            }
            this.getErrorSensor().removePropertyChangeListener(this);
        }
        this._errNamedSensor = newErrSensorHdl;
        this.setState(this.getState() & 0xFFFFFF7F);
        if (newErrSensor != null) {
            newErrSensor.addPropertyChangeListener(this, this._errNamedSensor.getName(), "OBlock Error Sensor " + this.getDisplayName());
            if (newErrSensor.getState() == 2) {
                this.setState(this.getState() | 0x80);
            } else {
                this.setState(this.getState() & 0xFFFFFF7F);
            }
        }
        return true;
    }

    public Sensor getErrorSensor() {
        if (this._errNamedSensor == null) {
            return null;
        }
        return this._errNamedSensor.getBean();
    }

    public NamedBeanHandle<Sensor> getNamedErrorSensor() {
        return this._errNamedSensor;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (log.isDebugEnabled()) {
            log.debug("property change: of \"{}\" property {} is now {} from {}", new Object[]{this.getDisplayName(), evt.getPropertyName(), evt.getNewValue(), evt.getSource().getClass().getName()});
        }
        if (this.getErrorSensor() != null && evt.getSource().equals(this.getErrorSensor()) && evt.getPropertyName().equals("KnownState")) {
            int errState = (Integer)evt.getNewValue();
            int oldState = this.getState();
            if (errState == 2) {
                this.setState(oldState | 0x80);
            } else {
                this.setState(oldState & 0xFFFFFF7F);
            }
            this.firePropertyChange("pathState", oldState, this.getState());
        }
    }

    public boolean addSharedTurnout(OPath key, OBlock block, OPath path) {
        List<HashMap<OBlock, List<OPath>>> blockList = this._sharedTO.get(key.getName());
        if (blockList != null) {
            for (HashMap<OBlock, List<OPath>> hashMap : blockList) {
                Iterator<Map.Entry<OBlock, List<OPath>>> iterator = hashMap.entrySet().iterator();
                if (!iterator.hasNext()) continue;
                Map.Entry<OBlock, List<OPath>> entry = iterator.next();
                OBlock b = entry.getKey();
                if (b.equals(block)) {
                    List<OPath> pathList = entry.getValue();
                    if (pathList.contains(path)) {
                        return false;
                    }
                    pathList.add(path);
                    log.debug("Block \"{}\" adds path for key \"{}\" (blockKey=\"{}\", path= \"{}\")", new Object[]{this.getDisplayName(), key.getName(), block.getDisplayName(), path.getName()});
                    return true;
                }
                ArrayList<OPath> pathList = new ArrayList<OPath>();
                pathList.add(path);
                hashMap.put(block, pathList);
                log.debug("Block \"{}\" adds pathList for key \"{}\" (blockKey=\"{}\", path= \"{}\")", new Object[]{this.getDisplayName(), key.getName(), block.getDisplayName(), path.getName()});
                return true;
            }
            HashMap hashMap = new HashMap();
            ArrayList<OPath> pathList = new ArrayList<OPath>();
            pathList.add(path);
            hashMap.put(block, pathList);
            blockList.add(hashMap);
            return true;
        }
        ArrayList<OPath> arrayList = new ArrayList<OPath>();
        arrayList.add(path);
        HashMap<OBlock, ArrayList<OPath>> map = new HashMap<OBlock, ArrayList<OPath>>();
        map.put(block, arrayList);
        blockList = new ArrayList<HashMap<OBlock, List<OPath>>>();
        blockList.add(map);
        this._sharedTO.put(key.getName(), blockList);
        log.debug("Block \"{}\" adds _sharedTO entry for key \"{}\" (blockKey=\"{}\", path= \"{}\")", new Object[]{this.getDisplayName(), key.getName(), block.getDisplayName(), path.getName()});
        return true;
    }

    private String checkSharedTO() {
        List<HashMap<OBlock, List<OPath>>> blockList = this._sharedTO.get(this._pathName);
        if (blockList != null) {
            Iterator<HashMap<OBlock, List<OPath>>> iter = blockList.iterator();
            log.debug("Path \"{}\" in block \"{}\" has turnouts thrown from {} other blocks", new Object[]{this._pathName, this.getDisplayName(), blockList.size()});
            while (iter.hasNext()) {
                HashMap<OBlock, List<OPath>> map = iter.next();
                for (Map.Entry<OBlock, List<OPath>> entry : map.entrySet()) {
                    OBlock block = entry.getKey();
                    for (OPath path : entry.getValue()) {
                        String warrantName = block.isPathSet(path.getName());
                        if (warrantName == null || warrantName.equals(this._warrant.getDisplayName())) continue;
                        this._warrant.setShareTOBlock(block, this);
                        return Bundle.getMessage("pathIsSet", this._pathName, this.getDisplayName(), this._warrant.getDisplayName(), path.getName(), block.getDisplayName(), warrantName);
                    }
                }
            }
        }
        this._ownsTOs = true;
        return null;
    }

    public String isPathSet(String path) {
        String msg = null;
        if (this._warrant != null && path.equals(this._pathName)) {
            msg = this._warrant.getDisplayName();
        }
        log.trace("Path \"{}\" in oblock \"{}\" {}", new Object[]{path, this.getDisplayName(), msg == null ? "not set" : " set in warrant " + msg});
        return msg;
    }

    public Warrant getWarrant() {
        return this._warrant;
    }

    protected boolean releaseWarrant(Warrant w) {
        if (w != null && w.equals(this._warrant)) {
            if (this._pathName != null) {
                OPath path = this.getPathByName(this._pathName);
                if (path != null) {
                    int lockState = 0;
                    path.setTurnouts(0, false, lockState, false);
                    Portal portal = path.getFromPortal();
                    if (portal != null) {
                        portal.setState(1);
                    }
                    if ((portal = path.getToPortal()) != null) {
                        portal.setState(1);
                    }
                }
                this._pathName = null;
            }
            this._ownsTOs = false;
            this._warrant = null;
            this.setState(this.getState() & 0xFFFFFFCF);
            return true;
        }
        return false;
    }

    public boolean isAllocatedTo(Warrant warrant) {
        if (warrant == null) {
            return false;
        }
        return warrant.equals(this._warrant);
    }

    public String getAllocatedPathName() {
        return this._pathName;
    }

    public void setMetricUnits(boolean type) {
        this._metric = type;
    }

    public boolean isMetric() {
        return this._metric;
    }

    public void setMarkerForeground(Color c) {
        this._markerForeground = c;
    }

    public Color getMarkerForeground() {
        return this._markerForeground;
    }

    public void setMarkerBackground(Color c) {
        this._markerBackground = c;
    }

    public Color getMarkerBackground() {
        return this._markerBackground;
    }

    public void setMarkerFont(Font f) {
        this._markerFont = f;
    }

    public Font getMarkerFont() {
        return this._markerFont;
    }

    @Override
    public void setState(int v) {
        int old = this.getState();
        super.setState(v);
        this.firePropertyChange("state", old, this.getState());
    }

    @Override
    public void setValue(Object o) {
        super.setValue(o);
        if (o == null) {
            this._markerForeground = Color.WHITE;
            this._markerBackground = DEFAULT_FILL_COLOR;
            this._markerFont = null;
        }
    }

    public boolean statusIs(String statusName) {
        OBlockStatus oblockStatus = OBlockStatus.getByName(statusName);
        if (oblockStatus != null) {
            return (this.getState() & oblockStatus.status) != 0;
        }
        log.error("\"{}\" type not found.  Update Conditional State Variable testing OBlock \"{}\" status", (Object)this.getDisplayName(), (Object)statusName);
        return false;
    }

    public boolean isFree() {
        int state = this.getState();
        return (state & 0x10) == 0 && (state & 2) == 0;
    }

    public String allocate(Warrant warrant) {
        int state;
        if (warrant == null) {
            return "ERROR! allocate called with null warrant in block \"" + this.getDisplayName() + "\"!";
        }
        String msg = null;
        if (this._warrant != null) {
            if (!warrant.equals(this._warrant)) {
                msg = Bundle.getMessage(ALLOCATED_TO_WARRANT, this._warrant.getDisplayName(), this.getDisplayName(), this._warrant.getTrainName());
            } else {
                return null;
            }
        }
        if (msg == null && ((state = this.getState()) & 0x40) != 0) {
            msg = Bundle.getMessage("BlockOutOfService", this.getDisplayName());
        }
        if (msg == null) {
            if (this._pathName == null) {
                this._pathName = warrant.getRoutePathInBlock(this);
            }
            this._warrant = warrant;
            this.setState(this.getState() | 0x10);
            log.debug("Allocate oblock \"{}\" to warrant \"{}\".", (Object)this.getDisplayName(), (Object)warrant.getDisplayName());
        } else {
            log.debug("Allocate oblock \"{}\" failed for warrant {}. err= {}", new Object[]{this.getDisplayName(), warrant.getDisplayName(), msg});
        }
        return msg;
    }

    public String allocatePath(String pathName) {
        log.debug("Allocate OBlock path \"{}\" in block \"{}\", state= {}", new Object[]{pathName, this.getSystemName(), this.getState()});
        if (pathName == null) {
            log.error("allocate called with null pathName in block \"{}\"!", (Object)this.getDisplayName());
            return null;
        }
        if (this._warrant != null) {
            return Bundle.getMessage(ALLOCATED_TO_WARRANT, this._warrant.getDisplayName(), this.getDisplayName(), this._warrant.getTrainName());
        }
        if (this._pathName != null && !this._pathName.equals(pathName)) {
            return Bundle.getMessage("AllocatedToPath", pathName, this.getDisplayName(), this._pathName);
        }
        this._pathName = pathName;
        return null;
    }

    public String getAllocatingWarrantName() {
        if (this._warrant == null) {
            return "no warrant";
        }
        return this._warrant.getDisplayName();
    }

    public boolean deAllocate(Warrant warrant) {
        if (this._warrant != null) {
            if (!this._warrant.equals(warrant) && InstanceManager.getDefault(WarrantManager.class).getBySystemName(this._warrant.getSystemName()) != null) {
                StringBuilder sb = new StringBuilder("Cannot deallocate Block \"");
                sb.append(this.getDisplayName());
                sb.append("\"! Owned by warrant \"");
                sb.append(this._warrant.getDisplayName());
                sb.append("\".");
                log.warn(sb.toString());
                return false;
            }
            try {
                log.debug("deAllocate block \"{}\" from warrant \"{}\"", (Object)this.getDisplayName(), (Object)warrant.getDisplayName());
                this.removePropertyChangeListener(this._warrant);
            }
            catch (Exception ex) {
                log.debug("Warrant {} unregistered.", (Object)this._warrant.getDisplayName(), (Object)ex);
            }
        }
        if (warrant == null) {
            return false;
        }
        return this.releaseWarrant(warrant);
    }

    public void setOutOfService(boolean set) {
        if (set) {
            this.setState(this.getState() | 0x40);
        } else {
            this.setState(this.getState() & 0xFFFFFFBF);
        }
    }

    public void setError(boolean set) {
        if (set) {
            this.setState(this.getState() | 0x80);
        } else {
            this.setState(this.getState() & 0xFFFFFF7F);
        }
    }

    public void addPortal(Portal portal) {
        String name = this.getDisplayName();
        if (!name.equals(portal.getFromBlockName()) && !name.equals(portal.getToBlockName())) {
            log.warn("{} not in block {}", (Object)portal.getDescription(), (Object)this.getDisplayName());
            return;
        }
        String pName = portal.getName();
        if (pName != null) {
            for (Portal value : this._portals) {
                if (!pName.equals(value.getName())) continue;
                return;
            }
        }
        int oldSize = this._portals.size();
        this._portals.add(portal);
        log.debug("add portal \"{}\" to Block \"{}\"", (Object)portal.getName(), (Object)this.getDisplayName());
        this.firePropertyChange("portalCount", oldSize, this._portals.size());
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="OPath extends Path")
    protected void removePortal(Portal portal) {
        if (portal != null) {
            for (OPath oPath : this.getPaths()) {
                if (portal.equals(oPath.getFromPortal())) {
                    oPath.setFromPortal(null);
                    log.debug("removed Portal {} from Path \"{}\" in oblock {}", new Object[]{portal.getName(), oPath.getName(), this.getDisplayName()});
                }
                if (!portal.equals(oPath.getToPortal())) continue;
                oPath.setToPortal(null);
                log.debug("removed Portal {} from Path \"{}\" in oblock {}", new Object[]{portal.getName(), oPath.getName(), this.getDisplayName()});
            }
            for (OPath oPath : this.getPaths()) {
                if (oPath.getFromPortal() != null || oPath.getToPortal() != null) continue;
                this.removeOPath(oPath);
                log.debug("removed Path \"{}\" from oblock {}", (Object)oPath.getName(), (Object)this.getDisplayName());
            }
            int n = this._portals.size();
            this._portals = this._portals.stream().filter(p -> !Objects.equals(p, portal)).collect(Collectors.toList());
            this.firePropertyChange("portalCount", n, this._portals.size());
        }
    }

    public Portal getPortalByName(String name) {
        for (Portal po : this._portals) {
            if (!po.getName().equals(name)) continue;
            return po;
        }
        return null;
    }

    @Nonnull
    public List<Portal> getPortals() {
        return new ArrayList<Portal>(this._portals);
    }

    public void setPortals(ArrayList<Portal> portals) {
        this._portals = portals;
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="OPath extends Path")
    public OPath getPathByName(String name) {
        for (Path opa : this.getPaths()) {
            OPath path = (OPath)opa;
            if (!path.getName().equals(name)) continue;
            return path;
        }
        return null;
    }

    @Override
    public void setLength(float len) {
        float oldLen = this.getLengthMm();
        if (oldLen > 0.0f) {
            float ratio = this.getLengthMm() / oldLen;
            this.getPaths().forEach(path -> path.setLength(path.getLength() * ratio));
        }
        super.setLength(len);
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="OPath extends Path")
    public boolean addPath(OPath path) {
        String pName = path.getName();
        log.debug("addPath \"{}\" to OBlock {}", (Object)pName, (Object)this.getSystemName());
        List<Path> list = this.getPaths();
        for (Path p : list) {
            if (((OPath)p).equals(path)) {
                log.debug("Path \"{}\" duplicated in OBlock {}", (Object)pName, (Object)this.getSystemName());
                return false;
            }
            if (!pName.equals(((OPath)p).getName())) continue;
            log.debug("Path named \"{}\" already exists in OBlock {}", (Object)pName, (Object)this.getSystemName());
            return false;
        }
        OBlock pathBlock = (OBlock)path.getBlock();
        if (pathBlock != null && !this.equals(pathBlock)) {
            log.warn("Path \"{}\" already in block {}, cannot be added to block {}", new Object[]{pName, pathBlock.getDisplayName(), this.getDisplayName()});
            return false;
        }
        path.setBlock(this);
        Portal portal = path.getFromPortal();
        if (portal != null && !portal.addPath(path)) {
            log.debug("Path \"{}\" rejected by portal  {}", (Object)pName, (Object)portal.getName());
            return false;
        }
        portal = path.getToPortal();
        if (portal != null && !portal.addPath(path)) {
            log.debug("Path \"{}\" rejected by portal  {}", (Object)pName, (Object)portal.getName());
            return false;
        }
        super.addPath(path);
        this.firePropertyChange("pathCount", null, this.getPaths().size());
        return true;
    }

    public boolean removeOPath(OPath path) {
        Block block = path.getBlock();
        if (block != null && !this.getSystemName().equals(block.getSystemName())) {
            return false;
        }
        if (!InstanceManager.getDefault(WarrantManager.class).okToRemoveBlockPath(this, path)) {
            return false;
        }
        path.clearSettings();
        super.removePath(path);
        Portal portal = path.getToPortal();
        if (portal != null) {
            portal.removePath(path);
        }
        if ((portal = path.getFromPortal()) != null) {
            portal.removePath(path);
        }
        path.dispose();
        this.firePropertyChange("pathCount", path, this.getPaths().size());
        return true;
    }

    protected String setPath(String pathName, Warrant warrant) {
        if (this._warrant != null && !this._warrant.equals(warrant)) {
            return Bundle.getMessage(ALLOCATED_TO_WARRANT, this._warrant.getDisplayName(), this.getDisplayName(), this._warrant.getTrainName());
        }
        String msg = null;
        if (pathName == null || warrant == null) {
            return Bundle.getMessage("PathNotFound", pathName, this.getDisplayName());
        }
        OPath path = this.getPathByName(pathName = pathName.trim());
        if (path == null) {
            msg = Bundle.getMessage("PathNotFound", pathName, this.getDisplayName());
        }
        if (msg == null && (this.getState() & 0x10) == 0) {
            msg = Bundle.getMessage("PathNotSet", pathName, this.getDisplayName());
        }
        if (msg != null) {
            log.warn(msg);
            return msg;
        }
        this._pathName = pathName;
        this._warrant = warrant;
        if (!this._ownsTOs) {
            msg = this.checkSharedTO();
        }
        if (msg == null && path != null) {
            int lockState = 0;
            path.setTurnouts(0, true, lockState, true);
            this.firePropertyChange("pathState", 0, this.getState());
        }
        log.debug("setPath: Path \"{}\" in OBlock \"{}\" {} set for warrant {}", new Object[]{pathName, this.getDisplayName(), warrant.getDisplayName()});
        return msg;
    }

    public void pseudoPropertyChange(String propName, Object old, Object n) {
        log.debug("pseudoPropertyChange: Block \"{}\" property \"{}\" new value= {}", new Object[]{this.getSystemName(), propName, n});
        this.firePropertyChange(propName, old, n);
    }

    @Override
    public void goingInactive() {
        log.debug("OBlock \"{} going UNOCCUPIED from state= {}", (Object)this.getDisplayName(), (Object)this.getState());
        this.setState(this.getState() & 0xFFFFFFD4 | 4);
        this.setValue(null);
        if (this._warrant != null) {
            ThreadingUtil.runOnLayout(() -> this._warrant.goingInactive(this));
        }
    }

    @Override
    public void goingActive() {
        log.debug("OBlock \"{}\" going OCCUPIED with path \"{}\" from state= {}", new Object[]{this.getDisplayName(), this._pathName, this.getState()});
        this.setState(this.getState() & 0xFFFFFFF2 | 2);
        if (this._warrant != null) {
            ThreadingUtil.runOnLayout(() -> this._warrant.goingActive(this));
        }
    }

    @Override
    public void goingUnknown() {
        log.debug("OBlock \"{} going UNKNOWN from state= {}", (Object)this.getDisplayName(), (Object)this.getState());
        this.setState(this.getState() & 0xFFFFFFF1 | 1);
    }

    @Override
    public void goingInconsistent() {
        log.debug("OBlock \"{} going INCONSISTENT from state= {}", (Object)this.getDisplayName(), (Object)this.getState());
        this.setState(this.getState() & 0xFFFFFFF8 | 8);
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="OPath extends Path")
    public void dispose() {
        if (!InstanceManager.getDefault(WarrantManager.class).okToRemoveBlock(this)) {
            return;
        }
        this.firePropertyChange("deleted", null, null);
        for (Path pa : this.getPaths()) {
            this.removeOPath((OPath)pa);
        }
        for (Portal portal : this.getPortals()) {
            if (log.isDebugEnabled()) {
                log.debug("this = {}, toBlock = {}, fromblock= {}", new Object[]{this.getDisplayName(), portal.getToBlock().getDisplayName(), portal.getFromBlock().getDisplayName()});
            }
            if (this.equals(portal.getToBlock())) {
                portal.setToBlock(null, false);
            }
            if (!this.equals(portal.getFromBlock())) continue;
            portal.setFromBlock(null, false);
        }
        this._portals.clear();
        PropertyChangeListener[] propertyChangeListenerArray = this.getPropertyChangeListeners();
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener listener = propertyChangeListenerArray[n2];
            this.removePropertyChangeListener(listener);
            ++n2;
        }
        InstanceManager.getDefault(OBlockManager.class).deregister(this);
        super.dispose();
    }

    public String getDescription() {
        return MessageFormat.format(Bundle.getMessage("BlockDescription"), this.getDisplayName());
    }

    @Override
    public List<NamedBeanUsageReport> getUsageReport(NamedBean bean) {
        ArrayList<NamedBeanUsageReport> report = new ArrayList<NamedBeanUsageReport>();
        ArrayList duplicateCheck = new ArrayList();
        if (bean != null) {
            if (log.isDebugEnabled()) {
                Sensor s = this.getSensor();
                log.debug("oblock: {}, sensor = {}", (Object)this.getDisplayName(), (Object)(s == null ? "Dark OBlock" : s.getDisplayName()));
            }
            if (bean.equals(this.getSensor())) {
                report.add(new NamedBeanUsageReport("OBlockSensor"));
            }
            if (bean.equals(this.getErrorSensor())) {
                report.add(new NamedBeanUsageReport("OBlockSensorError"));
            }
            if (bean.equals(this.getWarrant())) {
                report.add(new NamedBeanUsageReport("OBlockWarant"));
            }
            this.getPortals().forEach(portal -> {
                log.debug("    portal: {}, fb = {}, tb = {}, fs = {}, ts = {}", new Object[]{portal.getName(), portal.getFromBlockName(), portal.getToBlockName(), portal.getFromSignalName(), portal.getToSignalName()});
                if (bean.equals(portal.getFromBlock()) || bean.equals(portal.getToBlock())) {
                    report.add(new NamedBeanUsageReport("OBlockPortalNeighborOBlock", portal.getName()));
                }
                if (bean.equals(portal.getFromSignal()) || bean.equals(portal.getToSignal())) {
                    report.add(new NamedBeanUsageReport("OBlockPortalSignal", portal.getName()));
                }
                portal.getFromPaths().forEach(path -> {
                    log.debug("        from path = {}", (Object)path.getName());
                    path.getSettings().forEach(setting -> {
                        log.debug("            turnout = {}", (Object)setting.getBean().getDisplayName());
                        if (bean.equals(setting.getBean()) && !duplicateCheck.contains(bean)) {
                            report.add(new NamedBeanUsageReport("OBlockPortalPathTurnout", portal.getName()));
                            duplicateCheck.add(bean);
                        }
                    });
                });
                portal.getToPaths().forEach(path -> {
                    log.debug("        to path   = {}", (Object)path.getName());
                    path.getSettings().forEach(setting -> {
                        log.debug("            turnout = {}", (Object)setting.getBean().getDisplayName());
                        if (bean.equals(setting.getBean()) && !duplicateCheck.contains(bean)) {
                            report.add(new NamedBeanUsageReport("OBlockPortalPathTurnout", portal.getName()));
                            duplicateCheck.add(bean);
                        }
                    });
                });
            });
        }
        return report;
    }

    @Override
    @Nonnull
    public String getBeanType() {
        return Bundle.getMessage("BeanNameOBlock");
    }

    public static enum OBlockStatus {
        Unoccupied(4, "unoccupied", Bundle.getMessage("unoccupied")),
        Occupied(2, "occupied", Bundle.getMessage("occupied")),
        Allocated(16, "allocated", Bundle.getMessage("allocated")),
        Running(32, "running", Bundle.getMessage("running")),
        OutOfService(64, "outOfService", Bundle.getMessage("outOfService")),
        Dark(256, "dark", Bundle.getMessage("dark")),
        TrackError(128, "powerError", Bundle.getMessage("powerError"));

        private final int status;
        private final String name;
        private final String descr;
        private static final Map<String, OBlockStatus> map;
        private static final Map<String, OBlockStatus> reverseMap;

        static {
            map = new HashMap<String, OBlockStatus>();
            reverseMap = new HashMap<String, OBlockStatus>();
            OBlockStatus[] oBlockStatusArray = OBlockStatus.values();
            int n = oBlockStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                OBlockStatus oblockStatus = oBlockStatusArray[n2];
                map.put(oblockStatus.name, oblockStatus);
                reverseMap.put(oblockStatus.descr, oblockStatus);
                ++n2;
            }
        }

        private OBlockStatus(int status, String name, String descr) {
            this.status = status;
            this.name = name;
            this.descr = descr;
        }

        public int getStatus() {
            return this.status;
        }

        public String getName() {
            return this.name;
        }

        public String getDescr() {
            return this.descr;
        }

        public static OBlockStatus getByName(String name) {
            return map.get(name);
        }

        public static OBlockStatus getByDescr(String descr) {
            return reverseMap.get(descr);
        }
    }
}

