/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import jmri.JmriException;
import jmri.jmrit.logix.BlockOrder;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.logix.WarrantPreferences;
import jmri.jmrit.logix.WarrantPreferencesPanel;
import jmri.jmrit.logix.WarrantRoute;
import jmri.jmrit.logix.WarrantTableAction;
import jmri.jmrit.logix.WarrantTableFrame;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NXFrame
extends WarrantRoute {
    private float _maxThrottle = 0.75f;
    private float _startDist;
    private float _stopDist;
    private final JTextField _maxThrottleBox = new JTextField(6);
    private final JTextField _maxSpeedBox = new JTextField(6);
    private final JLabel _maxSpeedBoxLabel = new JLabel(Bundle.getMessage("scaleSpeed"));
    private WarrantRoute.DisplayButton _speedUnits;
    private final JTextField _originDist = new JTextField(6);
    private WarrantRoute.DisplayButton _originUnits;
    private final JTextField _destDist = new JTextField(6);
    private WarrantRoute.DisplayButton _destUnits;
    private final JSpinner _timeIncre = new JSpinner(new SpinnerNumberModel(750, 200, 9000, 1));
    private final JTextField _rampIncre = new JTextField(6);
    private final JRadioButton _forward = new JRadioButton();
    private final JRadioButton _reverse = new JRadioButton();
    private final JCheckBox _noRamp = new JCheckBox();
    private final JCheckBox _noSound = new JCheckBox();
    private final JCheckBox _stageEStop = new JCheckBox();
    private final JCheckBox _shareRouteBox = new JCheckBox();
    private final JCheckBox _haltStartBox = new JCheckBox();
    private final JCheckBox _addTracker = new JCheckBox();
    private final JRadioButton _runAuto = new JRadioButton(Bundle.getMessage("RunAuto"));
    private final JRadioButton _runManual = new JRadioButton(Bundle.getMessage("RunManual"));
    private JPanel _routePanel = new JPanel();
    private JPanel _autoRunPanel;
    private final JPanel __trainHolder = new JPanel();
    private JPanel _switchPanel;
    private JPanel _trainPanel;
    private static final Logger log = LoggerFactory.getLogger(NXFrame.class);

    protected NXFrame() {
        this.init();
    }

    private void init() {
        if (log.isDebugEnabled()) {
            log.debug("newInstance");
        }
        this.makeMenus();
        this._routePanel = new JPanel();
        this._routePanel.setLayout(new BoxLayout(this._routePanel, 3));
        this._routePanel.add(Box.createVerticalGlue());
        this._routePanel.add(this.makeBlockPanels(true));
        this._forward.setSelected(true);
        this._speedUtil.setIsForward(true);
        this._stageEStop.setSelected(false);
        this._haltStartBox.setSelected(false);
        this._runAuto.setSelected(true);
        this._autoRunPanel = this.makeAutoRunPanel();
        this._switchPanel = this.makeSwitchPanel();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 3));
        mainPanel.add(this._routePanel);
        this.getContentPane().add(mainPanel);
        float prefMaxThrottle = WarrantPreferences.getDefault().getThrottleScale() * 100.0f;
        this._maxThrottleBox.setText(NumberFormat.getNumberInstance().format(prefMaxThrottle));
        this.maxThrottleEventAction();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WarrantTableAction.getDefault().closeNXFrame();
            }
        });
        this.setAlwaysOnTop(true);
        this.setVisible(true);
        this.pack();
    }

    protected boolean isRouteSeaching() {
        return this._routePanel.isVisible();
    }

    private void setPanel() {
        this.__trainHolder.add(this._trainPanel);
    }

    private void setPanel(JPanel p) {
        JPanel con = (JPanel)this.getContentPane().getComponent(0);
        con.removeAll();
        con.add(p);
        con.add(this._switchPanel);
        this.pack();
    }

    private JPanel makeSwitchPanel() {
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._runAuto);
        bg.add(this._runManual);
        this._runAuto.addActionListener(event -> {
            this.setPanel();
            this.setPanel(this._autoRunPanel);
        });
        this._runManual.addActionListener(event -> {
            this.setPanel(this._trainPanel);
            this._stageEStop.setSelected(false);
            this._shareRouteBox.setSelected(false);
            this._haltStartBox.setSelected(false);
            this._addTracker.setSelected(false);
        });
        JPanel pp = new JPanel();
        pp.setLayout(new BoxLayout(pp, 2));
        pp.add(Box.createHorizontalGlue());
        pp.add(this._runAuto);
        pp.add(Box.createHorizontalStrut(STRUT_SIZE));
        pp.add(this._runManual);
        pp.add(Box.createHorizontalGlue());
        JPanel p = new JPanel();
        p.add(Box.createGlue());
        JButton button = new JButton(Bundle.getMessage("ButtonRoute"));
        button.addActionListener(e -> {
            this.clearTempWarrant();
            JPanel con = (JPanel)this.getContentPane().getComponent(0);
            con.removeAll();
            con.add(this._routePanel);
            this.pack();
        });
        p.add(button);
        p.add(Box.createHorizontalStrut(2 * STRUT_SIZE));
        button = new JButton(Bundle.getMessage("ButtonRunNX"));
        button.addActionListener(e -> {
            this.clearTempWarrant();
            this.makeAndRunWarrant();
        });
        p.add(button);
        p.add(Box.createHorizontalStrut(2 * STRUT_SIZE));
        button = new JButton(Bundle.getMessage("ButtonCancel"));
        button.addActionListener(e -> WarrantTableAction.getDefault().closeNXFrame());
        p.add(button);
        p.add(Box.createGlue());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(pp);
        panel.add(p);
        return panel;
    }

    @Override
    protected void maxThrottleEventAction() {
        NumberFormat formatter = NumberFormat.getNumberInstance();
        float num = 0.0f;
        try {
            num = formatter.parse(this._maxThrottleBox.getText()).floatValue();
            num = Math.min(100.0f, Math.max(num, 0.0f));
            this._maxThrottleBox.setText(formatter.format(num));
        }
        catch (ParseException parseException) {
            this._maxThrottleBox.setText(null);
            this._maxSpeedBox.setText(null);
            return;
        }
        float speed = this._speedUtil.getTrackSpeed(num / 100.0f);
        switch (this._displayPref) {
            case MPH: {
                this._maxSpeedBox.setText(formatter.format(speed * this._scale * 2.2369363f));
                break;
            }
            case KPH: {
                this._maxSpeedBox.setText(formatter.format(speed * this._scale * 3.6f));
                break;
            }
            case MMPS: {
                this._maxSpeedBox.setText(formatter.format(speed * 1000.0f));
                break;
            }
            default: {
                this._maxSpeedBox.setText(formatter.format(speed * 39.37f));
            }
        }
    }

    private void unitsEventAction(JButton button, JTextField field) {
        this._units = button.getText().equals(WarrantRoute.Display.IN.toString()) ? WarrantRoute.Display.CM : WarrantRoute.Display.IN;
        this.setFieldText(button, field);
    }

    private void setFieldText(JButton button, JTextField field) {
        NumberFormat formatter = NumberFormat.getNumberInstance();
        float num = 0.0f;
        try {
            num = formatter.parse(field.getText()).floatValue();
        }
        catch (ParseException parseException) {}
        num = this._units.equals((Object)WarrantRoute.Display.IN) ? (float)Math.round(num * 0.393701f) : (float)Math.round(num * 2.54f);
        button.setText(this._units.toString());
        field.setText(formatter.format(num));
    }

    private JPanel makeAutoRunPanel() {
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 3));
        this._speedUnits = new WarrantRoute.DisplayButton(this._displayPref);
        this._originUnits = new WarrantRoute.DisplayButton(this._units);
        this._destUnits = new WarrantRoute.DisplayButton(this._units);
        this._maxThrottleBox.addActionListener(evt -> this.maxThrottleEventAction());
        this._maxSpeedBox.addActionListener(evt -> {
            float maxNum;
            NumberFormat formatter = NumberFormat.getNumberInstance();
            float num = 0.0f;
            try {
                num = formatter.parse(this._maxSpeedBox.getText()).floatValue();
            }
            catch (ParseException parseException) {
                this._maxSpeedBox.setText("");
                return;
            }
            if (num < 0.0f) {
                this._maxSpeedBox.setText(formatter.format(0L));
                this._maxThrottleBox.setText(formatter.format(0L));
                return;
            }
            float maxSpeed = this._speedUtil.getTrackSpeed(1.0f);
            switch (this._displayPref) {
                case MPH: {
                    maxNum = maxSpeed * 2.2369363f * this._scale;
                    break;
                }
                case KPH: {
                    maxNum = maxSpeed * 3.6f * this._scale;
                    break;
                }
                case MMPS: {
                    maxNum = maxSpeed * 1000.0f;
                    break;
                }
                default: {
                    maxNum = maxSpeed * 39.37f;
                }
            }
            if (num > maxNum) {
                String name = this._speedUtil.getRosterId();
                if (!(name != null && name.charAt(0) != '$' || (name = this.getTrainName()) != null && !name.isEmpty())) {
                    name = Bundle.getMessage("unknownTrain");
                }
                JOptionPane.showMessageDialog(null, Bundle.getMessage("maxSpeedLimit", name, formatter.format(maxNum), this._speedUnits.getText()), Bundle.getMessage("MessageTitle"), 1);
                this._maxSpeedBox.setText(formatter.format(maxNum));
                this._maxThrottleBox.setText(formatter.format(100L));
                return;
            }
            switch (this._displayPref) {
                case MPH: {
                    num = num * 0.44704f / this._scale;
                    break;
                }
                case KPH: {
                    num = num * 0.277778f / this._scale;
                    break;
                }
                case MMPS: {
                    num /= 1000.0f;
                    break;
                }
                default: {
                    num /= 39.37f;
                }
            }
            float throttle = this._speedUtil.getThrottleSettingForSpeed(num) * 100.0f;
            this._maxThrottleBox.setText(formatter.format(throttle));
        });
        this._speedUnits.addActionListener(evt -> {
            NumberFormat formatter = NumberFormat.getNumberInstance();
            float num = 0.0f;
            try {
                num = formatter.parse(this._maxSpeedBox.getText()).floatValue();
            }
            catch (ParseException parseException) {
                this._maxSpeedBox.setText(null);
                return;
            }
            switch (this._displayPref) {
                case MPH: {
                    this._displayPref = WarrantRoute.Display.KPH;
                    this._maxSpeedBox.setText(formatter.format(num * 1.60934f));
                    break;
                }
                case KPH: {
                    this._displayPref = WarrantRoute.Display.MMPS;
                    this._maxSpeedBox.setText(formatter.format(num * 277.778f / this._scale));
                    this._maxSpeedBoxLabel.setText(Bundle.getMessage("trackSpeed"));
                    break;
                }
                case MMPS: {
                    this._displayPref = WarrantRoute.Display.INPS;
                    this._maxSpeedBox.setText(formatter.format(num * 0.03937f));
                    break;
                }
                default: {
                    this._displayPref = WarrantRoute.Display.MPH;
                    this._maxSpeedBox.setText(formatter.format(num * 0.056818f * this._scale));
                    this._maxSpeedBoxLabel.setText(Bundle.getMessage("scaleSpeed"));
                }
            }
            this._speedUnits.setDisplayPref(this._displayPref);
        });
        p1.add(NXFrame.makeTextAndButtonPanel(this._maxThrottleBox, new JLabel(Bundle.getMessage("percent")), new JLabel(Bundle.getMessage("MaxSpeed")), "ToolTipPercentThrottle"));
        p1.add(NXFrame.makeTextAndButtonPanel(this._maxSpeedBox, this._speedUnits, this._maxSpeedBoxLabel, "ToolTipScaleSpeed"));
        this._originUnits.addActionListener(evt -> {
            this.unitsEventAction(this._originUnits, this._originDist);
            this.setFieldText(this._destUnits, this._destDist);
        });
        this._destUnits.addActionListener(evt -> {
            this.unitsEventAction(this._destUnits, this._destDist);
            this.setFieldText(this._originUnits, this._originDist);
        });
        p1.add(NXFrame.makeTextAndButtonPanel(this._originDist, this._originUnits, new JLabel(Bundle.getMessage("startDistance")), "ToolTipStartDistance"));
        p1.add(NXFrame.makeTextAndButtonPanel(this._destDist, this._destUnits, new JLabel(Bundle.getMessage("stopDistance")), "ToolTipStopDistance"));
        p1.add(WarrantPreferencesPanel.timeIncrementPanel(false, this._timeIncre));
        p1.add(WarrantPreferencesPanel.throttleIncrementPanel(false, this._rampIncre));
        this._rampIncre.addActionListener(e -> {
            String text = this._rampIncre.getText();
            boolean showdialog = false;
            try {
                float incr = NumberFormat.getNumberInstance().parse(text).floatValue();
                showdialog = incr < 0.5f || incr > 25.0f;
            }
            catch (ParseException parseException) {
                showdialog = true;
            }
            if (showdialog) {
                JOptionPane.showMessageDialog(null, Bundle.getMessage("rampIncrWarning", text), Bundle.getMessage("WarningTitle"), 2);
            }
        });
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._forward);
        bg.add(this._reverse);
        JPanel pp = new JPanel();
        pp.setLayout(new BoxLayout(pp, 2));
        pp.add(Box.createHorizontalGlue());
        pp.add(NXFrame.makeTextBoxPanel(false, this._forward, "forward", null));
        pp.add(NXFrame.makeTextBoxPanel(false, this._reverse, "reverse", null));
        pp.add(Box.createHorizontalGlue());
        p1.add(pp);
        this.__trainHolder.setLayout(new BoxLayout(this.__trainHolder, 3));
        this._trainPanel = this.makeTrainIdPanel(null);
        this.__trainHolder.add(this._trainPanel);
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 3));
        p2.add(this.__trainHolder);
        p2.add(NXFrame.makeTextBoxPanel(this._noRamp, "NoRamping", "ToolTipNoRamping"));
        p2.add(NXFrame.makeTextBoxPanel(this._noSound, "NoSound", "ToolTipNoSound"));
        p2.add(NXFrame.makeTextBoxPanel(this._stageEStop, "StageEStop", null));
        p2.add(NXFrame.makeTextBoxPanel(this._haltStartBox, "HaltAtStart", null));
        p2.add(NXFrame.makeTextBoxPanel(this._shareRouteBox, "ShareRoute", "ToolTipShareRoute"));
        p2.add(NXFrame.makeTextBoxPanel(this._addTracker, "AddTracker", "ToolTipAddTracker"));
        JPanel autoRunPanel = new JPanel();
        autoRunPanel.setLayout(new BoxLayout(autoRunPanel, 3));
        JPanel ppp = new JPanel();
        ppp.setLayout(new BoxLayout(ppp, 2));
        ppp.add(Box.createHorizontalStrut(STRUT_SIZE));
        ppp.add(p1);
        ppp.add(Box.createHorizontalGlue());
        ppp.add(p2);
        ppp.add(Box.createHorizontalStrut(STRUT_SIZE));
        autoRunPanel.add(ppp);
        this._forward.addActionListener(evt -> this.maxThrottleEventAction());
        this._reverse.addActionListener(evt -> this.maxThrottleEventAction());
        return autoRunPanel;
    }

    private void updateAutoRunPanel() {
        this._startDist = this.getPathLength((BlockOrder)this._orders.get(0)) / 2.0f;
        this._stopDist = this.getPathLength((BlockOrder)this._orders.get(this._orders.size() - 1)) / 2.0f;
        NumberFormat formatter = NumberFormat.getNumberInstance();
        if (this._units.equals((Object)WarrantRoute.Display.IN)) {
            this._originDist.setText(formatter.format((double)this._startDist * 0.0393701));
            this._destDist.setText(formatter.format((double)this._stopDist * 0.0393701));
        } else {
            this._originDist.setText(formatter.format(this._startDist / 10.0f));
            this._destDist.setText(formatter.format(this._stopDist / 10.0f));
        }
        this._autoRunPanel.repaint();
    }

    private void makeMenus() {
        this.setTitle(Bundle.getMessage("AutoWarrant"));
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.logix.NXWarrant", true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String property = e.getPropertyName();
        log.trace("propertyChange \"{}\" old= {} new= {} source= {}", new Object[]{property, e.getOldValue(), e.getNewValue(), e.getSource().getClass().getName()});
        if (property.equals("DnDrop")) {
            this.doAction(e.getSource());
        }
    }

    @Override
    protected void selectedRoute(ArrayList<BlockOrder> orders) {
        JPanel con = (JPanel)this.getContentPane().getComponent(0);
        con.removeAll();
        if (this._runAuto.isSelected()) {
            con.add(this._autoRunPanel);
        } else {
            con.add(this._trainPanel);
        }
        con.add(this._switchPanel);
        this.updateAutoRunPanel();
        this.pack();
    }

    private void makeAndRunWarrant() {
        int mode;
        String msg;
        if (log.isDebugEnabled()) {
            log.debug("NXFrame selectedRoute()");
        }
        if ((msg = this.getBoxData()) == null) {
            msg = this.checkLocoAddress();
        }
        if (msg != null) {
            JOptionPane.showMessageDialog(this, msg, Bundle.getMessage("WarningTitle"), 2);
            return;
        }
        String s = ("" + Math.random()).substring(2);
        Warrant warrant = new Warrant("IW" + s, "NX(" + this.getAddress() + ")");
        warrant.setBlockOrders(this._orders);
        warrant.setTrainName(this.getTrainName());
        warrant.setNoRamp(this._noRamp.isSelected());
        this._speedUtil.setIsForward(this._forward.isSelected());
        warrant.setSpeedUtil(this._speedUtil);
        log.debug("Warrant {}. Route and loco set.", (Object)warrant.getDisplayName());
        if (!this._runManual.isSelected()) {
            mode = 2;
            warrant.setShareRoute(this._shareRouteBox.isSelected());
            warrant.setAddTracker(this._addTracker.isSelected());
            msg = this.makeCommands(warrant);
        } else {
            mode = 3;
        }
        if (msg == null) {
            WarrantTableFrame tableFrame = WarrantTableFrame.getDefault();
            tableFrame.setVisible(true);
            warrant.setNXWarrant(true);
            tableFrame.getModel().addNXWarrant(warrant);
            if (log.isDebugEnabled()) {
                log.debug("NXWarrant added to table");
            }
            if ((msg = tableFrame.runTrain(warrant, mode)) != null) {
                log.debug("WarrantTableFrame run warrant. msg= {} Remove warrant {}", (Object)msg, (Object)warrant.getDisplayName());
                tableFrame.getModel().removeWarrant(warrant, false);
            }
        }
        if (msg == null && mode == 2 && this._haltStartBox.isSelected()) {
            class Halter
            implements Runnable {
                Warrant war;

                Halter(Warrant w) {
                    this.war = w;
                }

                @Override
                public void run() {
                    int limit = 0;
                    try {
                        while (!this.war.controlRunTrain(1) && limit < 3000) {
                            Thread.sleep(200L);
                            limit += 200;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        this.war.controlRunTrain(1);
                    }
                }
            }
            Halter h = new Halter(warrant);
            ThreadingUtil.newThread(h).start();
        }
        if (msg != null) {
            JOptionPane.showMessageDialog(this, msg, Bundle.getMessage("WarningTitle"), 2);
        } else {
            WarrantTableAction.getDefault().closeNXFrame();
        }
    }

    protected void setMaxSpeed(float s) {
        this._maxThrottle = s;
        this._maxThrottleBox.setText(NumberFormat.getNumberInstance().format(s));
    }

    private String getBoxData() {
        float maxSpeed;
        String text = null;
        NumberFormat formatter = NumberFormat.getNumberInstance();
        try {
            text = this._maxThrottleBox.getText();
            maxSpeed = formatter.parse(text).floatValue();
        }
        catch (ParseException parseException) {
            if (text == null) {
                text = "\"\"";
            }
            return Bundle.getMessage("badSpeed100", text);
        }
        try {
            this._startDist = this.getDistance(this._originDist, (BlockOrder)this._orders.get(0));
        }
        catch (JmriException je) {
            return je.getMessage();
        }
        try {
            this._stopDist = this.getDistance(this._destDist, (BlockOrder)this._orders.get(this._orders.size() - 1));
        }
        catch (JmriException je) {
            return je.getMessage();
        }
        if (maxSpeed > 100.0f || maxSpeed < 0.001f) {
            return Bundle.getMessage("badSpeed100", Float.valueOf(maxSpeed));
        }
        this._maxThrottle = maxSpeed / 100.0f;
        String msg = this.setAddress();
        if (msg != null) {
            return msg;
        }
        int time = (Integer)this._timeIncre.getValue();
        this._speedUtil.setRampTimeIncrement(time);
        try {
            text = this._rampIncre.getText();
            float incre = NumberFormat.getNumberInstance().parse(text).floatValue();
            if (incre < 0.5f || incre > 25.0f) {
                return Bundle.getMessage("rampIncrWarning", text);
            }
            this._speedUtil.setRampThrottleIncrement(incre / 100.0f);
        }
        catch (ParseException parseException) {
            return Bundle.getMessage("MustBeFloat", text);
        }
        this._speedUtil.resetSpeedProfile();
        return null;
    }

    private float getDistance(JTextField field, BlockOrder bo) throws JmriException {
        float distance;
        NumberFormat formatter = NumberFormat.getNumberInstance();
        String text = field.getText();
        try {
            distance = formatter.parse(text).floatValue();
        }
        catch (ParseException parseException) {
            throw new JmriException(Bundle.getMessage("MustBeFloat", text));
        }
        float pathLen = this.getPathLength(bo);
        if (pathLen <= 0.0f) {
            throw new JmriException(Bundle.getMessage("zeroPathLength", bo.getPathName(), bo.getBlock().getDisplayName()));
        }
        if (this._units.equals((Object)WarrantRoute.Display.IN)) {
            if ((distance *= 25.4f) < 0.0f || distance > pathLen) {
                field.setText(formatter.format((double)pathLen * 12.07));
                throw new JmriException(Bundle.getMessage("BadLengthIn", bo.getPathName(), bo.getBlock().getDisplayName(), Float.valueOf(pathLen * 0.039701f), text));
            }
        } else if ((distance *= 10.0f) < 0.0f || distance > pathLen) {
            field.setText(formatter.format(pathLen * 5.0f));
            throw new JmriException(Bundle.getMessage("BadLengthCm", bo.getPathName(), bo.getBlock().getDisplayName(), Float.valueOf(pathLen * 0.5f), text));
        }
        return distance;
    }

    private float getPathLength(BlockOrder bo) {
        float len = bo.getPath().getLengthMm();
        if (len <= 0.0f && (len = bo.getTempPathLen()) <= 0.0f) {
            String sLen = JOptionPane.showInputDialog(this, String.valueOf(Bundle.getMessage("zeroPathLength", bo.getPathName(), bo.getBlock().getDisplayName())) + Bundle.getMessage("getPathLength", bo.getPathName(), bo.getBlock().getDisplayName()), Bundle.getMessage("WarningTitle"), 2);
            try {
                len = NumberFormat.getNumberInstance().parse(sLen).floatValue();
            }
            catch (NullPointerException | ParseException exception) {
                len = 0.0f;
            }
            bo.setTempPathLen(len);
        }
        return len;
    }

    private float adjustdistance(float fromSpeed, float toSpeed, float distance, BlockOrder bo) throws JmriException {
        float pathLen = this.getPathLength(bo);
        if (pathLen <= 0.0f) {
            throw new JmriException(Bundle.getMessage("zeroPathLength", bo.getPathName(), bo.getBlock().getDisplayName()));
        }
        int timeIncrement = this._speedUtil.getRampTimeIncrement();
        float minDist = this._speedUtil.getDistanceOfSpeedChange(fromSpeed, toSpeed, timeIncrement) + 0.1f;
        if (distance < minDist) {
            distance = minDist;
        } else if (distance > pathLen - minDist) {
            distance = pathLen - minDist;
        }
        return distance;
    }

    private float getTotalLength() throws JmriException {
        float totalLen = 0.0f;
        List<BlockOrder> orders = this.getOrders();
        float throttleIncrement = this._speedUtil.getRampThrottleIncrement();
        totalLen = this._startDist = this.adjustdistance(0.0f, throttleIncrement, this._startDist, orders.get(0));
        int i = 1;
        while (i < orders.size() - 1) {
            BlockOrder bo = orders.get(i);
            float pathLen = this.getPathLength(bo);
            if (pathLen <= 0.0f) {
                throw new JmriException(Bundle.getMessage("zeroPathLength", bo.getPathName(), bo.getBlock().getDisplayName()));
            }
            totalLen += pathLen;
            ++i;
        }
        this._stopDist = this.adjustdistance(throttleIncrement, 0.0f, this._stopDist, orders.get(0));
        return totalLen += this._stopDist;
    }

    /*
     * Exception decompiling
     */
    private String makeCommands(Warrant w) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

