/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JDesktopPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.PowerManager;
import jmri.SpeedStepMode;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.LearnControlPanel;
import jmri.jmrit.logix.LearnFunctionPanel;
import jmri.jmrit.logix.LearnSpeedPanel;
import jmri.jmrit.logix.WarrantFrame;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.throttle.FunctionButton;
import jmri.util.JmriJFrame;
import jmri.util.PlaceWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LearnThrottleFrame
extends JmriJFrame {
    private WarrantFrame _warrantFrame;
    private PowerManager powerMgr = null;
    private LearnControlPanel _controlPanel;
    private LearnFunctionPanel _functionPanel;
    private LearnSpeedPanel _speedPanel;
    private static final Logger log = LoggerFactory.getLogger(LearnThrottleFrame.class);

    public LearnThrottleFrame(WarrantFrame warrantFrame) {
        super(false, false);
        this._warrantFrame = warrantFrame;
        this.powerMgr = InstanceManager.getNullableDefault(PowerManager.class);
        if (this.powerMgr == null) {
            log.info("No power manager instance found, panel not active");
        }
        this.initGUI();
        this.setVisible(true);
    }

    public void notifyThrottleFound(DccThrottle t) {
        RosterEntry re;
        if (log.isDebugEnabled()) {
            log.debug("notifyThrottleFound address= {} class= {}", (Object)t.getLocoAddress(), (Object)t.getClass().getName());
        }
        this._controlPanel.notifyAddressThrottleFound(t);
        this._functionPanel.notifyAddressThrottleFound(t);
        this._speedPanel.notifyAddressThrottleFound(t);
        this.setSpeedSetting(0.0f);
        this.setButtonForward(t.getIsForward());
        String name = this._warrantFrame.getTrainName();
        name = name == null || name.isEmpty() ? ((re = this._warrantFrame._speedUtil.getRosterEntry()) != null ? re.getId() : t.getLocoAddress().toString()) : String.valueOf(name) + " - " + t.getLocoAddress().toString();
        this.setTitle(name);
    }

    private void initGUI() {
        this.setTitle("Throttle");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LearnThrottleFrame.this._warrantFrame.close();
                LearnThrottleFrame.this.dispose();
            }
        });
        this.initializeMenu();
        this._controlPanel = new LearnControlPanel(this);
        this._controlPanel.setVisible(true);
        this._controlPanel.setEnabled(false);
        this._controlPanel.setTitle(Bundle.getMessage("speed"));
        this._controlPanel.setSize(this._controlPanel.getPreferredSize());
        int width = 3 * FunctionButton.getButtonWidth() + 30 + 11;
        int height = 9 * FunctionButton.getButtonHeight() + 60 + 20;
        this._functionPanel = new LearnFunctionPanel(this);
        this._functionPanel.setSize(width, height);
        this._functionPanel.setVisible(true);
        this._functionPanel.setEnabled(false);
        this._functionPanel.setTitle(Bundle.getMessage("setFunction"));
        this._speedPanel = new LearnSpeedPanel(this._warrantFrame.getWarrant());
        this._speedPanel.setSize(this._functionPanel.getWidth(), this._controlPanel.getHeight() - this._functionPanel.getHeight());
        this._speedPanel.setVisible(true);
        this._speedPanel.setClosable(true);
        this._speedPanel.setTitle(ResourceBundle.getBundle("jmri/jmrit/throttle/ThrottleBundle").getString("ThrottleMenuViewSpeedPanel"));
        this._controlPanel.setLocation(0, 0);
        this._functionPanel.setLocation(this._controlPanel.getWidth(), 0);
        this._speedPanel.setLocation(this._controlPanel.getWidth(), this._functionPanel.getHeight());
        JDesktopPane desktop = new JDesktopPane();
        this.getContentPane().add(desktop);
        desktop.add(this._controlPanel);
        desktop.add(this._functionPanel);
        desktop.add(this._speedPanel);
        desktop.setPreferredSize(new Dimension(this._controlPanel.getWidth() + this._functionPanel.getWidth(), this._controlPanel.getHeight()));
        this.setResizable(false);
        PlaceWindow.getDefault().nextTo(this._warrantFrame, null, this);
        this.pack();
    }

    private void initializeMenu() {
        JMenu speedControl = new JMenu(Bundle.getMessage("SpeedControl"));
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem displaySlider = new JRadioButtonMenuItem(Bundle.getMessage("ButtonDisplaySpeedSlider"));
        displaySlider.addActionListener(e -> this._controlPanel.setSpeedController(2));
        displaySlider.setSelected(true);
        buttonGroup.add(displaySlider);
        speedControl.add(displaySlider);
        JRadioButtonMenuItem displaySteps = new JRadioButtonMenuItem(Bundle.getMessage("ButtonDisplaySpeedSteps"));
        displaySteps.addActionListener(e -> this._controlPanel.setSpeedController(1));
        buttonGroup.add(displaySteps);
        speedControl.add(displaySteps);
        this.setJMenuBar(new JMenuBar());
        this.getJMenuBar().add(speedControl);
        if (this.powerMgr != null) {
            JMenu powerMenu = new JMenu(Bundle.getMessage("ThrottleMenuPower"));
            JMenuItem powerOn = new JMenuItem(Bundle.getMessage("ThrottleMenuPowerOn"));
            powerMenu.add(powerOn);
            powerOn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        LearnThrottleFrame.this.powerMgr.setPower(2);
                    }
                    catch (JmriException e1) {
                        log.error("Error when setting power {}", (Throwable)e1);
                    }
                }
            });
            JMenuItem powerOff = new JMenuItem(Bundle.getMessage("ThrottleMenuPowerOff"));
            powerMenu.add(powerOff);
            powerOff.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        LearnThrottleFrame.this.powerMgr.setPower(4);
                    }
                    catch (JmriException e1) {
                        log.error("Error when setting power {}", (Throwable)e1);
                    }
                }
            });
            this.getJMenuBar().add(powerMenu);
        }
        this.addHelpMenu("package.jmri.jmrit.throttle.ThrottleFrame", true);
    }

    @Override
    public void dispose() {
        this._controlPanel.destroy();
        this._functionPanel.destroy();
        this._speedPanel.destroy();
        this._controlPanel.dispose();
        this._functionPanel.dispose();
        super.dispose();
    }

    protected void setSpeedSetting(float speed) {
        this._warrantFrame.setSpeedCommand(speed);
    }

    protected void setSpeedStepMode(SpeedStepMode speedStep) {
        this._warrantFrame.setThrottleCommand("SpeedStep", speedStep.name);
    }

    protected void setFunctionState(String FNum, boolean isSet) {
        this._warrantFrame.setThrottleCommand(FNum, Boolean.toString(isSet));
    }

    protected void setFunctionLock(String FMom, boolean isLockable) {
        this._warrantFrame.setThrottleCommand(FMom, Boolean.toString(isLockable));
    }

    protected void setButtonForward(boolean isForward) {
        this._warrantFrame.setThrottleCommand("Forward", Boolean.toString(isForward));
    }
}

