/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.ListIterator;
import jmri.DccThrottle;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.Sensor;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.RampData;
import jmri.jmrit.logix.SpeedUtil;
import jmri.jmrit.logix.ThrottleSetting;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.logix.WarrantPreferences;
import jmri.jmrit.logix.WarrantTableFrame;
import jmri.jmrit.logix.WarrantTableModel;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Engineer
extends Thread
implements PropertyChangeListener {
    private int _idxCurrentCommand;
    private ThrottleSetting _currentCommand;
    private long _commandTime = 0L;
    private int _idxSkipToSpeedCommand;
    private float _normalSpeed = 0.0f;
    private String _speedType = "Normal";
    private float _timeRatio = 1.0f;
    private boolean _abort = false;
    private boolean _halt = false;
    private boolean _stopPending = false;
    private boolean _waitForClear = false;
    private boolean _waitForSensor = false;
    private boolean _runOnET = false;
    private boolean _setRunOnET = false;
    protected DccThrottle _throttle;
    private final Warrant _warrant;
    private final List<ThrottleSetting> _commands;
    private Sensor _waitSensor;
    private int _sensorWaitState;
    private Object _rampLockObject = new Object();
    private ThrottleRamp _ramp;
    private boolean _atHalt = false;
    private boolean _atClear = false;
    private final SpeedUtil _speedUtil;
    private OBlock _synchBlock = null;
    private Thread _checker = null;
    private static final Logger log = LoggerFactory.getLogger(Engineer.class);

    Engineer(Warrant warrant, DccThrottle throttle) {
        this._warrant = warrant;
        this._throttle = throttle;
        this._speedUtil = warrant.getSpeedUtil();
        this._commands = this._warrant.getThrottleCommands();
        this._idxCurrentCommand = 0;
        this._idxSkipToSpeedCommand = 0;
        this._waitForSensor = false;
        this.setName("Engineer(" + this._warrant.getTrainName() + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @SuppressFBWarnings(value={"UW_UNCOND_WAIT"}, justification="waits may be indefinite until satisfied or thread aborted")
    public void run() {
        if (Engineer.log.isDebugEnabled()) {
            Engineer.log.debug("Engineer started warrant {} _throttle= {}", (Object)this._warrant.getDisplayName(), (Object)this._throttle.getClass().getName());
        }
        cmdBlockIdx = 0;
        ** GOTO lbl187
        {
            if (Engineer.log.isDebugEnabled()) {
                ts = this._commands.get(this._idxCurrentCommand);
                Engineer.log.debug("{}: Skip Cmd #{}: {} Warrant {}", new Object[]{this._warrant.getDisplayName(), this._idxCurrentCommand + 1, ts});
            }
            ++this._idxCurrentCommand;
            do {
                if (this._idxSkipToSpeedCommand > this._idxCurrentCommand) continue block32;
                if (this._idxCurrentCommand == this._commands.size()) break block32;
                this._currentCommand = this._commands.get(this._idxCurrentCommand);
                cmdWaitTime = this._currentCommand.getTime();
                command = this._currentCommand.getCommand();
                this._runOnET = this._setRunOnET;
                if (command.hasBlockName() && (idx = this._warrant.getIndexOfBlock(this._currentCommand.getBeanDisplayName(), cmdBlockIdx)) >= 0) {
                    cmdBlockIdx = idx;
                }
                if (cmdBlockIdx < this._warrant.getCurrentOrderIndex() || command.equals((Object)ThrottleSetting.Command.NOOP) && cmdBlockIdx <= this._warrant.getCurrentOrderIndex()) {
                    cmdWaitTime = Math.min(cmdWaitTime, 200L);
                    if (Engineer.log.isDebugEnabled()) {
                        Engineer.log.debug("{}: Train reached block \"{}\" before script et={}ms", new Object[]{this._warrant.getDisplayName(), this._warrant.getCurrentBlockName(), this._currentCommand.getTime()});
                    }
                }
                if (this._abort) break block32;
                cmdStart = System.currentTimeMillis();
                if (Engineer.log.isDebugEnabled()) {
                    Engineer.log.debug("{}: Start Cmd #{} for block \"{}\" currently in \"{}\". wait {}ms to do cmd {}", new Object[]{this._warrant.getDisplayName(), this._idxCurrentCommand + 1, this._currentCommand.getBeanDisplayName(), this._warrant.getCurrentBlockName(), cmdWaitTime, command.toString()});
                }
                var7_7 = this;
                synchronized (var7_7) {
                    if (!"Normal".equals(this._speedType)) {
                        cmdWaitTime = (long)((float)cmdWaitTime * this._timeRatio);
                    }
                    try {
                        if (cmdWaitTime > 0L) {
                            this.wait(cmdWaitTime);
                        }
                    }
                    catch (InterruptedException ie) {
                        Engineer.log.debug("InterruptedException during time wait {}", (Throwable)ie);
                        this._warrant.debugInfo();
                        Thread.currentThread().interrupt();
                    }
                    catch (IllegalArgumentException iae) {
                        Engineer.log.error("At time wait {}", (Throwable)iae);
                    }
                }
                if (this._abort) break block32;
                if (!this._runOnET && cmdBlockIdx > this._warrant.getCurrentOrderIndex()) {
                    this._synchBlock = this._warrant.getBlockAt(cmdBlockIdx);
                    _synchIdx = cmdBlockIdx;
                    bumpedSpeed = false;
                    speed = this._throttle.getSpeedSetting();
                    if (Engineer.log.isDebugEnabled()) {
                        Engineer.log.debug("{}: Wait for train to enter \"{}\".", (Object)this._warrant.getDisplayName(), (Object)this._synchBlock.getDisplayName());
                    }
                    this._warrant.fireRunStatus("WaitForSync", this._idxCurrentCommand - 1, this._idxCurrentCommand);
                    waittime = 36000000;
                    throttleIncrement = this._speedUtil.getRampThrottleIncrement();
                    useSpeedHelp = WarrantPreferences.getDefault().getSpeedAssistance();
                    if (speed < useSpeedHelp) {
                        waittime = 10000;
                    }
                    while (_synchIdx > this._warrant.getCurrentOrderIndex()) {
                        var13_22 = this;
                        synchronized (var13_22) {
                            block59: {
                                try {
                                    try {
                                        this.wait(waittime);
                                    }
                                    catch (InterruptedException ie) {
                                        Engineer.log.debug("InterruptedException during _waitForSync {}", (Throwable)ie);
                                        this._warrant.debugInfo();
                                        Thread.currentThread().interrupt();
                                        _synchIdx = -1;
                                        break block59;
                                    }
                                }
                                catch (Throwable var15_26) {
                                    _synchIdx = -1;
                                    throw var15_26;
                                }
                                _synchIdx = -1;
                            }
                        }
                        if (bumpedSpeed) {
                            this.setSpeed(speed);
                        }
                        if (speed < useSpeedHelp) {
                            speed += throttleIncrement;
                            bumpedSpeed = true;
                        } else {
                            waittime = 36000000;
                        }
                        if (this._abort) break;
                    }
                    if (bumpedSpeed) {
                        idx = this._warrant.getCurrentOrderIndex();
                        this._normalSpeed = this._speedUtil.getBlockSpeedInfo(idx).getEntranceSpeed();
                        entrySpeed = this._speedUtil.modifySpeed(this._speedUtil.getBlockSpeedInfo(idx).getEntranceSpeed(), this._speedType);
                        this.setSpeed(entrySpeed);
                    }
                    this._synchBlock = null;
                }
                if (this._abort) break block32;
                var7_7 = this;
                synchronized (var7_7) {
                    block61: {
                        if (this._waitForClear) {
                            try {
                                try {
                                    this._atClear = true;
                                    if (Engineer.log.isDebugEnabled()) {
                                        Engineer.log.debug("{}: Waiting for clearance. _waitForClear= {} _halt= {} at block \"{}\" Cmd#{}.", new Object[]{this._warrant.getDisplayName(), this._waitForClear, this._halt, this._warrant.getBlockAt(cmdBlockIdx).getDisplayName(), this._idxCurrentCommand + 1});
                                    }
                                    this.wait();
                                }
                                catch (InterruptedException ie) {
                                    Engineer.log.debug("InterruptedException during _atClear {}", (Throwable)ie);
                                    this._warrant.debugInfo();
                                    Thread.currentThread().interrupt();
                                    this._waitForClear = false;
                                    this._atClear = false;
                                    break block61;
                                }
                            }
                            catch (Throwable var9_17) {
                                this._waitForClear = false;
                                this._atClear = false;
                                throw var9_17;
                            }
                            this._waitForClear = false;
                            this._atClear = false;
                        }
                    }
                }
                if (this._abort) break block32;
                var7_7 = this;
                synchronized (var7_7) {
                    block63: {
                        if (this._halt) {
                            try {
                                try {
                                    this._atHalt = true;
                                    if (Engineer.log.isDebugEnabled()) {
                                        Engineer.log.debug("{}: Waiting to Resume. _halt= {}, _waitForClear= {}, Block \"{}\".", new Object[]{this._warrant.getDisplayName(), this._halt, this._waitForClear, this._warrant.getBlockAt(cmdBlockIdx).getDisplayName()});
                                    }
                                    this.wait();
                                }
                                catch (InterruptedException ie) {
                                    Engineer.log.debug("InterruptedException during _atHalt {}", (Throwable)ie);
                                    this._warrant.debugInfo();
                                    Thread.currentThread().interrupt();
                                    this._halt = false;
                                    this._atHalt = false;
                                    break block63;
                                }
                            }
                            catch (Throwable var9_18) {
                                this._halt = false;
                                this._atHalt = false;
                                throw var9_18;
                            }
                            this._halt = false;
                            this._atHalt = false;
                        }
                    }
                }
                if (this._abort) break block32;
                var7_7 = this;
                synchronized (var7_7) {
                    while (this._ramp != null && (!ThrottleRamp.access$0(this._ramp) || ThrottleRamp.access$1(this._ramp))) {
                        idx = this._idxCurrentCommand;
                        try {
                            if (Engineer.log.isDebugEnabled()) {
                                Engineer.log.debug("{}: Waiting for ramp to finish at Cmd #{}.", (Object)this._warrant.getDisplayName(), (Object)(this._idxCurrentCommand + 1));
                            }
                            this.wait();
                        }
                        catch (InterruptedException v4) {
                            this._warrant.debugInfo();
                            Thread.currentThread().interrupt();
                        }
                        if (!Engineer.log.isDebugEnabled()) continue;
                        Engineer.log.debug("{}: Cmd #{} held for {}ms. {}", new Object[]{this._warrant.getDisplayName(), idx + 1, System.currentTimeMillis() - cmdStart, this._currentCommand});
                    }
                    if (this._idxSkipToSpeedCommand <= this._idxCurrentCommand) {
                        this.executeComand(this._currentCommand, System.currentTimeMillis() - cmdStart);
                        ++this._idxCurrentCommand;
                    }
                    if (this._checker != null) {
                        break block32;
                    }
                }
lbl187:
                // 2 sources

            } while (this._idxCurrentCommand < this._commands.size());
        }
        this.setSpeed(0.0f);
        this._warrant.stopWarrant(this._abort, true);
    }

    private void executeComand(ThrottleSetting ts, long et) {
        ThrottleSetting.Command command = ts.getCommand();
        ThrottleSetting.CommandValue cmdVal = ts.getValue();
        switch (command) {
            case SPEED: {
                this._normalSpeed = cmdVal.getFloat();
                float speedMod = this._speedUtil.modifySpeed(this._normalSpeed, this._speedType);
                if (this._normalSpeed > speedMod) {
                    this._timeRatio = this._normalSpeed / speedMod;
                    this.setSpeed(speedMod);
                    break;
                }
                this._timeRatio = 1.0f;
                this.setSpeed(this._normalSpeed);
                break;
            }
            case NOOP: {
                break;
            }
            case SET_SENSOR: {
                ThreadingUtil.runOnGUIEventually(() -> this.setSensor(ts.getNamedBeanHandle(), cmdVal));
                break;
            }
            case FKEY: {
                this.setFunction(ts.getKeyNum(), cmdVal.getType());
                break;
            }
            case FORWARD: {
                this.setForward(cmdVal.getType());
                break;
            }
            case LATCHF: {
                this.setFunctionMomentary(ts.getKeyNum(), cmdVal.getType());
                break;
            }
            case WAIT_SENSOR: {
                this.waitForSensor(ts.getNamedBeanHandle(), cmdVal);
                break;
            }
            case RUN_WARRANT: {
                this.runWarrant(ts.getNamedBeanHandle(), cmdVal);
                break;
            }
        }
        this._commandTime = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("{}: Cmd #{} done. et={}. {}", new Object[]{this._warrant.getDisplayName(), this._idxCurrentCommand + 1, et, ts});
        }
    }

    protected int getCurrentCommandIndex() {
        return this._idxCurrentCommand;
    }

    private void advanceToCommandIndex(int idx) {
        this._idxSkipToSpeedCommand = idx;
        if (log.isTraceEnabled()) {
            log.debug("advanceToCommandIndex to {} - {}", (Object)(this._idxSkipToSpeedCommand + 1), (Object)this._commands.get(idx));
        }
    }

    protected void setRunOnET(boolean set) {
        if (log.isDebugEnabled() && this._setRunOnET != set) {
            log.debug("{}: setRunOnET {} command #{}", new Object[]{this._warrant.getDisplayName(), set, this._idxCurrentCommand + 1});
        }
        this._setRunOnET = set;
        if (!set) {
            this._runOnET = false;
        }
    }

    protected boolean getRunOnET() {
        return this._setRunOnET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearWaitForSync(OBlock block) {
        if (log.isDebugEnabled()) {
            log.debug("{}: clearWaitForSync from block \"{}\".", (Object)this._warrant.getDisplayName(), (Object)block.getDisplayName());
        }
        boolean waitForSync = true;
        if (block.equals(this._synchBlock)) {
            Engineer engineer = this;
            synchronized (engineer) {
                this.notifyAll();
                waitForSync = false;
            }
        } else if (this._synchBlock != null) {
            log.warn("{}: clearWaitForSync called from block \"{}\". _synchBlock = \"{}\"", new Object[]{this._warrant.getDisplayName(), block.getDisplayName(), this._synchBlock.getDisplayName()});
        }
        if (log.isDebugEnabled()) {
            log.debug("{}: clearWaitForSync from block \"{}\". notifyAll() {} called.  isRamping()={}", new Object[]{this._warrant.getDisplayName(), block.getDisplayName(), waitForSync ? "NOT" : "", this.isRamping()});
        }
    }

    private static void setFrameStatusText(String m, Color c, boolean save) {
        ThreadingUtil.runOnGUIEventually(() -> WarrantTableFrame.getDefault().setStatusText(m, c, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void rampSpeedTo(String endSpeedType, int endBlockIdx) {
        this.setWaitforClear(true);
        if (endSpeedType.equals(Warrant.Stop) && this.getSpeedSetting() == 0.0f) {
            return;
        }
        if (endSpeedType.equals(Warrant.EStop)) {
            this.setStop(true);
            return;
        }
        Engineer engineer = this;
        synchronized (engineer) {
            if (log.isDebugEnabled()) {
                log.debug("{}: rampSpeedTo: type= {}, throttle from {} to {}.", new Object[]{this._warrant.getDisplayName(), endSpeedType, Float.valueOf(this.getSpeedSetting()), Float.valueOf(this._speedUtil.modifySpeed(this._normalSpeed, endSpeedType))});
            }
            if (this._ramp == null) {
                this._ramp = new ThrottleRamp();
                this._ramp.start();
            } else if (!this._ramp.ready) {
                if (this._ramp.duplicate(endSpeedType, endBlockIdx)) {
                    return;
                }
                this._ramp.holdRamp = true;
                this._ramp.quit(false);
            }
            long time = 0L;
            int pause = this._speedUtil.getRampTimeIncrement() + 20;
            while (time < (long)pause && !this._ramp.ready) {
                try {
                    this.wait(20L);
                    time += 20L;
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this._ramp.ready) {
                this._ramp.setParameters(endSpeedType, endBlockIdx);
                this._ramp.holdRamp = false;
                Object object = this._rampLockObject;
                synchronized (object) {
                    this._rampLockObject.notifyAll();
                    log.debug("{}: rampSpeedTo called notify _ramp.ready= {}", (Object)this._warrant.getDisplayName(), (Object)this._ramp.ready);
                }
            } else {
                log.error("Can't launch ramp for speed {}! _ramp Thread.State= {}. Waited {}ms", new Object[]{endSpeedType, this._ramp.getState(), time - 20L});
                this._warrant.debugInfo();
            }
        }
    }

    protected boolean isRamping() {
        return this._ramp != null && !this._ramp.ready;
    }

    protected String getSpeedType(boolean rampType) {
        if (rampType) {
            if (this.isRamping()) {
                return this._ramp._endSpeedType;
            }
            if (this._waitForClear || this._halt) {
                return Warrant.Stop;
            }
        }
        return this._speedType;
    }

    protected synchronized boolean cancelRamp(boolean die) {
        if (this._ramp != null) {
            if (die) {
                this._ramp.quit(true);
            } else if (!this._ramp.ready) {
                this._ramp.quit(false);
                return true;
            }
        }
        return false;
    }

    protected void setSpeed(float speed) {
        this._speedUtil.speedChange(speed);
        this._throttle.setSpeedSetting(speed);
        this._warrant.fireRunStatus("SpeedChange", null, null);
        if (log.isDebugEnabled()) {
            log.debug("{}: _throttle.setSpeedSetting({}) called, ({}).", new Object[]{this._warrant.getDisplayName(), Float.valueOf(speed), this._speedType});
        }
    }

    protected float getSpeedSetting() {
        float speed = this._throttle.getSpeedSetting();
        if (speed < 0.0f) {
            this._throttle.setSpeedSetting(0.0f);
            speed = this._throttle.getSpeedSetting();
        }
        return speed;
    }

    protected float getScriptSpeed() {
        return this._normalSpeed;
    }

    private void setSpeedRatio(String speedType) {
        if (speedType.equals("Normal")) {
            this._timeRatio = 1.0f;
        } else {
            float speedMod = this._speedUtil.modifySpeed(1.0f, speedType);
            this._timeRatio = 1.0f / speedMod;
        }
    }

    protected synchronized void setSpeedToType(String speedType) {
        float speed = this.getSpeedSetting();
        if (log.isDebugEnabled()) {
            log.debug("{}: setSpeedToType({}) speed={} scriptSpeed={}", new Object[]{this._warrant.getDisplayName(), speedType, Float.valueOf(speed), Float.valueOf(this._normalSpeed)});
        }
        if (speedType.equals(Warrant.EStop)) {
            this.setStop(true);
            this.advanceToCommandIndex(this._idxCurrentCommand + 1);
        } else if (speedType.equals(Warrant.Stop)) {
            this.setStop(false);
            this.advanceToCommandIndex(this._idxCurrentCommand + 1);
        } else {
            if (speed <= 0.0f || this._ramp != null && this._ramp._endSpeedType.equals(Warrant.Stop)) {
                return;
            }
            if (speedType.equals(this.getSpeedType(true))) {
                return;
            }
            this._speedType = speedType;
            this.setSpeedRatio(speedType);
        }
    }

    public synchronized void setHalt(boolean halt) {
        if (log.isDebugEnabled()) {
            log.debug("{}: setHalt({}): _atHalt= {}, _waitForClear= {}", new Object[]{this._warrant.getDisplayName(), halt, this._atHalt, this._waitForClear});
        }
        if (!halt) {
            this._halt = false;
            if (!this._atClear) {
                if (log.isDebugEnabled()) {
                    log.debug("setHalt calls notify()");
                }
                this.notifyAll();
            }
        } else {
            this._halt = true;
        }
    }

    private long getTimeToNextCommand() {
        if (this._commandTime > 0L) {
            long elapsedTime = System.currentTimeMillis() - this._commandTime;
            return Math.max(0L, this._currentCommand.getTime() - elapsedTime);
        }
        return 0L;
    }

    private synchronized void setWaitforClear(boolean wait) {
        if (log.isDebugEnabled()) {
            log.debug("{}: setWaitforClear({}): _atClear= {}, throttle speed= {}, _halt= {}", new Object[]{this._warrant.getDisplayName(), wait, this._atClear, Float.valueOf(this.getSpeedSetting()), this._halt});
        }
        if (!wait) {
            this._waitForClear = false;
            if (!this._atHalt) {
                if (log.isDebugEnabled()) {
                    log.debug("setWaitforClear calls notify");
                }
                this.notifyAll();
            }
        } else {
            this._waitForClear = true;
        }
    }

    String debugInfo() {
        StackTraceElement elem;
        StringBuffer info = new StringBuffer("\nEngineer ");
        info.append(this.getName());
        info.append(", Thread.State= ");
        info.append((Object)this.getState());
        info.append(", isAlive= ");
        info.append(this.isAlive());
        info.append(", isInterrupted= ");
        info.append(this.isInterrupted());
        info.append("\n\tThrottle setting= ");
        info.append(this.getSpeedSetting());
        info.append(", scriptSpeed= ");
        info.append(this.getScriptSpeed());
        info.append(". runstate= ");
        info.append(Warrant.RUN_STATE[this.getRunState()]);
        int cmdIdx = this.getCurrentCommandIndex();
        if (cmdIdx < this._commands.size()) {
            info.append("\n\tCommand #");
            info.append(cmdIdx + 1);
            info.append(": ");
            info.append(this._commands.get(cmdIdx).toString());
        } else {
            info.append("\n\t\tAt last command.");
        }
        info.append("\n\tEngineer flags: _waitForClear= ");
        info.append(this._waitForClear);
        info.append(", _atclear= ");
        info.append(this._atClear);
        info.append(", _halt= ");
        info.append(this._halt);
        info.append(", _atHalt= ");
        info.append(this._atHalt);
        if (this._synchBlock != null) {
            info.append("\n\t\tWaiting for Sync at \"");
            info.append(this._synchBlock.getDisplayName());
        }
        info.append("\"\n\t\t_setRunOnET= ");
        info.append(this._setRunOnET);
        info.append(", _runOnET= ");
        info.append(this._runOnET);
        info.append("\n\t\t_stopPending= ");
        info.append(this._stopPending);
        info.append(", _abort= ");
        info.append(this._abort);
        info.append("\n\t\t_speedType= \"");
        info.append(this._speedType);
        info.append("\"");
        info.append("\n\tStack trace:");
        StackTraceElement[] stackTraceElementArray = this.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            elem = stackTraceElementArray[n2];
            info.append("\n\t\t");
            info.append(elem.getClassName());
            info.append(".");
            info.append(elem.getMethodName());
            info.append(", line ");
            info.append(elem.getLineNumber());
            ++n2;
        }
        if (this._ramp != null) {
            info.append("\n\tRamp Thread.State= ");
            info.append((Object)this._ramp.getState());
            info.append(", isAlive= ");
            info.append(this._ramp.isAlive());
            info.append(", isInterrupted= ");
            info.append(this._ramp.isInterrupted());
            info.append("\n\tRamp flags: ready= ");
            info.append(this._ramp.isReady());
            info.append(", holdRamp= ");
            info.append(this._ramp.holdRamp);
            info.append(", stop= ");
            info.append(this._ramp.stop);
            info.append(", _die= ");
            info.append(this._ramp._die);
            info.append("\n\t\tEndSpeedType= \"");
            info.append(this._ramp._endSpeedType);
            info.append("\"");
            info.append("\n\tStack trace:");
            stackTraceElementArray = this._ramp.getStackTrace();
            n = stackTraceElementArray.length;
            n2 = 0;
            while (n2 < n) {
                elem = stackTraceElementArray[n2];
                info.append("\n\t\t");
                info.append(elem.getClassName());
                info.append(".");
                info.append(elem.getMethodName());
                info.append(", line ");
                info.append(elem.getLineNumber());
                ++n2;
            }
        } else {
            info.append("\n\tNo ramp.");
        }
        return info.toString();
    }

    private synchronized void setStop(boolean eStop) {
        float speed = this._throttle.getSpeedSetting();
        if (speed > 0.0f) {
            this.cancelRamp(false);
        }
        if (eStop) {
            this.setHalt(true);
            this.setSpeed(-0.1f);
            this.setSpeed(0.0f);
        } else {
            this.setSpeed(0.0f);
            this.setWaitforClear(true);
        }
        if (log.isDebugEnabled()) {
            log.debug("{}: setStop({}) speed={} scriptSpeed={}", new Object[]{this._warrant.getDisplayName(), Float.valueOf(speed), Float.valueOf(this._normalSpeed)});
        }
    }

    public int getRunState() {
        if (this._stopPending) {
            if (this._halt) {
                return 6;
            }
            return 14;
        }
        if (this._halt) {
            return 1;
        }
        if (this._waitForClear) {
            return 9;
        }
        if (this._waitForSensor) {
            return 10;
        }
        if (this._abort) {
            return 3;
        }
        if (this._synchBlock != null) {
            return 11;
        }
        if (this.isRamping()) {
            return 8;
        }
        return 7;
    }

    public void stopRun(boolean abort, boolean turnOffFunctions) {
        if (abort) {
            this._abort = true;
        }
        if (this._waitSensor != null) {
            this._waitSensor.removePropertyChangeListener(this);
        }
        this.cancelRamp(true);
        if (this._throttle != null) {
            if (this._throttle.getSpeedSetting() > 0.0f) {
                if (abort) {
                    this._throttle.setSpeedSetting(-1.0f);
                }
                this.setSpeed(0.0f);
                if (turnOffFunctions) {
                    this._throttle.setF0(false);
                    this._throttle.setF1(false);
                    this._throttle.setF2(false);
                    this._throttle.setF3(false);
                }
            }
            this._warrant.releaseThrottle(this._throttle);
        }
    }

    private void setForward(ThrottleSetting.ValueType type) {
        if (type == ThrottleSetting.ValueType.VAL_TRUE) {
            this._throttle.setIsForward(true);
        } else if (type == ThrottleSetting.ValueType.VAL_FALSE) {
            this._throttle.setIsForward(false);
        } else {
            throw new IllegalArgumentException("setForward type " + (Object)((Object)type) + " wrong");
        }
    }

    private void setFunction(int cmdNum, ThrottleSetting.ValueType type) {
        if (cmdNum < 0 || cmdNum > 28) {
            throw new IllegalArgumentException("setFunction " + cmdNum + " out of range");
        }
        if (type == ThrottleSetting.ValueType.VAL_ON) {
            this._throttle.setFunction(cmdNum, true);
        } else if (type == ThrottleSetting.ValueType.VAL_OFF) {
            this._throttle.setFunction(cmdNum, false);
        } else {
            throw new IllegalArgumentException("setFunction type " + (Object)((Object)type) + " wrong");
        }
    }

    private void setFunctionMomentary(int cmdNum, ThrottleSetting.ValueType type) {
        if (cmdNum < 0 || cmdNum > 28) {
            log.error("Function value {} out of range", (Object)cmdNum);
            throw new IllegalArgumentException("setFunctionMomentary " + cmdNum + " out of range");
        }
        if (type == ThrottleSetting.ValueType.VAL_ON) {
            this._throttle.setFunctionMomentary(cmdNum, true);
        } else if (type == ThrottleSetting.ValueType.VAL_OFF) {
            this._throttle.setFunctionMomentary(cmdNum, false);
        } else {
            throw new IllegalArgumentException("setFunctionMomentary type " + (Object)((Object)type) + " wrong");
        }
    }

    private void setSensor(NamedBeanHandle<?> handle, ThrottleSetting.CommandValue cmdVal) {
        Object bean = handle.getBean();
        if (!(bean instanceof Sensor)) {
            log.error("setSensor: {} not a Sensor!", (Object)bean.getDisplayName());
            return;
        }
        Sensor s = (Sensor)bean;
        ThrottleSetting.ValueType type = cmdVal.getType();
        try {
            if (type == ThrottleSetting.ValueType.VAL_ACTIVE) {
                s.setKnownState(2);
            } else if (type == ThrottleSetting.ValueType.VAL_INACTIVE) {
                s.setKnownState(4);
            } else {
                throw new IllegalArgumentException("setSensor type " + (Object)((Object)type) + " wrong");
            }
            this._warrant.fireRunStatus("SensorSetCommand", type.toString(), s.getDisplayName());
        }
        catch (JmriException jmriException) {
            log.warn("Exception setting sensor {} in action", (Object)handle.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForSensor(NamedBeanHandle<?> handle, ThrottleSetting.CommandValue cmdVal) {
        Object bean;
        if (this._waitSensor != null) {
            this._waitSensor.removePropertyChangeListener(this);
        }
        if (!((bean = handle.getBean()) instanceof Sensor)) {
            log.error("setSensor: {} not a Sensor!", (Object)bean.getDisplayName());
            return;
        }
        this._waitSensor = (Sensor)bean;
        ThrottleSetting.ValueType type = cmdVal.getType();
        if (type == ThrottleSetting.ValueType.VAL_ACTIVE) {
            this._sensorWaitState = 2;
        } else if (type == ThrottleSetting.ValueType.VAL_INACTIVE) {
            this._sensorWaitState = 4;
        } else {
            throw new IllegalArgumentException("waitForSensor type " + (Object)((Object)type) + " wrong");
        }
        int state = this._waitSensor.getKnownState();
        if (state == this._sensorWaitState) {
            log.info("Engineer: state of event sensor {} already at state {}", (Object)this._waitSensor.getDisplayName(), (Object)type.toString());
            return;
        }
        this._waitSensor.addPropertyChangeListener(this);
        if (log.isDebugEnabled()) {
            log.debug("Listen for propertyChange of {}, wait for State= {}", (Object)this._waitSensor.getDisplayName(), (Object)this._sensorWaitState);
        }
        Engineer engineer = this;
        synchronized (engineer) {
            this._waitForSensor = true;
            while (this._waitForSensor) {
                try {
                    try {
                        this._warrant.fireRunStatus("SensorWaitCommand", type.toString(), this._waitSensor.getDisplayName());
                        this.wait();
                        String name = this._waitSensor.getDisplayName();
                        this._warrant.fireRunStatus("SensorWaitCommand", null, name);
                    }
                    catch (InterruptedException ie) {
                        log.error("Engineer interrupted at _waitForSensor ", (Throwable)ie);
                        this._warrant.debugInfo();
                        Thread.currentThread().interrupt();
                        this.clearSensor();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    this.clearSensor();
                    throw throwable;
                }
                this.clearSensor();
            }
        }
    }

    private void clearSensor() {
        if (this._waitSensor != null) {
            this._waitSensor.removePropertyChangeListener(this);
        }
        this._sensorWaitState = 0;
        this._waitForSensor = false;
        this._waitSensor = null;
    }

    protected Sensor getWaitSensor() {
        return this._waitSensor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"}, justification="Sensor change on another thread is expected even when Engineer (this) has not done any modifing")
    public void propertyChange(PropertyChangeEvent evt) {
        if (log.isDebugEnabled()) {
            log.debug("propertyChange {} new value= {}", (Object)evt.getPropertyName(), evt.getNewValue());
        }
        if (evt.getPropertyName().equals("KnownState") && ((Number)evt.getNewValue()).intValue() == this._sensorWaitState) {
            Engineer engineer = this;
            synchronized (engineer) {
                this.notifyAll();
            }
        }
    }

    private void runWarrant(NamedBeanHandle<?> handle, ThrottleSetting.CommandValue cmdVal) {
        Object bean = handle.getBean();
        if (!(bean instanceof Warrant)) {
            log.error("runWarrant: {} not a warrant!", (Object)bean.getDisplayName());
            return;
        }
        Warrant warrant = (Warrant)bean;
        int num = Math.round(cmdVal.getFloat());
        if (num <= 0) {
            return;
        }
        cmdVal.setFloat(--num);
        Color color = Color.red;
        String msg = null;
        if (this._warrant.getSpeedUtil().getDccAddress().equals(warrant.getSpeedUtil().getDccAddress())) {
            if (log.isDebugEnabled()) {
                log.debug("Loco address {} finishes warrant {} and starts warrant {}", new Object[]{warrant.getSpeedUtil().getDccAddress(), this._warrant.getDisplayName(), warrant.getDisplayName()});
            }
            long time = 30000L;
            int i = this._idxCurrentCommand + 1;
            while (i < this._commands.size()) {
                time += this._commands.get(i).getTime();
                ++i;
            }
            this._warrant.deAllocate();
            this._checker = new CheckForTermination(this._warrant, warrant, num, time);
            this._checker.start();
            if (log.isDebugEnabled()) {
                log.debug("Exit runWarrant");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Loco address {} on warrant {} and starts loco {} on warrant {}", new Object[]{this._warrant.getSpeedUtil().getDccAddress(), this._warrant.getDisplayName(), warrant.getSpeedUtil().getDccAddress(), warrant.getDisplayName()});
        }
        if ((msg = WarrantTableFrame.getDefault().runTrain(warrant, 2)) != null) {
            msg = Bundle.getMessage("CannotRun", warrant.getDisplayName(), msg);
        } else {
            msg = Bundle.getMessage("linkedLaunch", warrant.getDisplayName(), this._warrant.getDisplayName(), warrant.getfirstOrder().getBlock().getDisplayName(), this._warrant.getfirstOrder().getBlock().getDisplayName());
            color = WarrantTableModel.myGreen;
        }
        String m = msg;
        Color c = color;
        Engineer.setFrameStatusText(m, c, true);
        log.debug("Exit runWarrant - {}", (Object)msg);
    }

    private void checkerDone(Warrant oldWarrant, Warrant newWarrant) {
        Color color;
        OBlock endBlock = oldWarrant.getLastOrder().getBlock();
        if (oldWarrant.getRunMode() != 0) {
            log.error(Bundle.getMessage("cannotLaunch", newWarrant.getDisplayName(), oldWarrant.getDisplayName(), endBlock.getDisplayName()));
            return;
        }
        String msg = null;
        msg = WarrantTableFrame.getDefault().runTrain(newWarrant, 2);
        if (msg != null) {
            msg = Bundle.getMessage("CannotRun", newWarrant.getDisplayName(), msg);
            color = Color.red;
        } else {
            ThrottleSetting.CommandValue cmdVal = this._currentCommand.getValue();
            int num = Math.round(cmdVal.getFloat());
            msg = oldWarrant.equals(newWarrant) ? Bundle.getMessage("reLaunch", oldWarrant.getDisplayName(), num < 0 ? "unlimited" : Integer.valueOf(num)) : Bundle.getMessage("linkedLaunch", newWarrant.getDisplayName(), oldWarrant.getDisplayName(), newWarrant.getfirstOrder().getBlock().getDisplayName(), endBlock.getDisplayName());
            color = WarrantTableModel.myGreen;
        }
        String m = msg;
        Color c = color;
        Engineer.setFrameStatusText(m, c, true);
        try {
            try {
                this._checker.join(200L);
            }
            catch (InterruptedException interruptedException) {
                this._checker = null;
            }
        }
        finally {
            this._checker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"}, justification="rampDone is called by ramp thread to clear Engineer waiting for it to finish")
    private void rampDone(boolean stop, String speedType) {
        if (!stop && !speedType.equals(Warrant.Stop)) {
            this._speedType = speedType;
            this.setSpeedRatio(speedType);
            this.setWaitforClear(false);
            this.setHalt(false);
        }
        this._stopPending = false;
        if (!(this._waitForClear || this._atHalt || this._atClear || this._ramp.holdRamp)) {
            Engineer engineer = this;
            synchronized (engineer) {
                this.notifyAll();
            }
            log.debug("{}: rampDone called notify.", (Object)this._warrant.getDisplayName());
            if (this._currentCommand.getCommand().equals((Object)ThrottleSetting.Command.NOOP)) {
                --this._idxCurrentCommand;
            }
        }
        if (!stop) {
            this._warrant.fireRunStatus("RampDone", this._halt, speedType);
        }
        if (log.isDebugEnabled()) {
            log.debug("{}: ThrottleRamp {} for speedType \"{}\". Thread.State= {}}", new Object[]{this._warrant.getDisplayName(), stop ? "stopped" : "completed", speedType, this._ramp != null ? this._ramp.getState() : "_ramp is null!"});
        }
    }

    private class CheckForTermination
    extends Thread {
        Warrant oldWarrant;
        Warrant newWarrant;
        long timeLimit;

        CheckForTermination(Warrant oldWar, Warrant newWar, int num, long limit) {
            this.oldWarrant = oldWar;
            this.newWarrant = newWar;
            this.timeLimit = limit;
            if (log.isDebugEnabled()) {
                log.debug("checkForTermination({}, {}, {}, {})", new Object[]{this.oldWarrant.getDisplayName(), this.newWarrant.getDisplayName(), num, this.timeLimit});
            }
        }

        @Override
        public void run() {
            long time = 0L;
            while (time <= this.timeLimit && Engineer.this._throttle != null) {
                if (this.oldWarrant.getRunMode() == 0) break;
                try {
                    Thread.sleep(100L);
                    time += 100L;
                }
                catch (InterruptedException interruptedException) {
                    time = this.timeLimit;
                }
            }
            if (time >= this.timeLimit || log.isDebugEnabled()) {
                log.info("Waited {}ms for warrant \"{}\" to terminate. runMode={}", new Object[]{time, this.oldWarrant.getDisplayName(), this.oldWarrant.getRunMode()});
            }
            Engineer.this.checkerDone(this.oldWarrant, this.newWarrant);
        }
    }

    class ThrottleRamp
    extends Thread {
        private String _endSpeedType;
        private int _endBlockIdx;
        private boolean stop = false;
        private boolean ready = false;
        private boolean _die = false;
        private boolean holdRamp = false;

        ThrottleRamp() {
            this.setName("Ramp(" + Engineer.this._warrant.getTrainName() + ")");
            this._endBlockIdx = -1;
        }

        boolean isReady() {
            return this.ready;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"}, justification="quit is called another thread to clear all ramp waits")
        void quit(boolean die) {
            this.stop = true;
            if (die) {
                this._die = die;
            }
            Object object = Engineer.this._rampLockObject;
            synchronized (object) {
                Engineer.this._rampLockObject.notifyAll();
                log.debug("{}: ThrottleRamp clears _ramp waits", (Object)Engineer.this._warrant.getDisplayName());
                ThrottleRamp throttleRamp = this;
                synchronized (throttleRamp) {
                    this.notifyAll();
                }
                log.debug("{}: ThrottleRamp clears engineer waits", (Object)Engineer.this._warrant.getDisplayName());
            }
        }

        void setParameters(String endSpeedType, int endBlockIdx) {
            this._endSpeedType = endSpeedType;
            this._endBlockIdx = endBlockIdx;
            Engineer.this._stopPending = endSpeedType.equals(Warrant.Stop);
        }

        boolean duplicate(String endSpeedType, int endBlockIdx) {
            return endBlockIdx == this._endBlockIdx && endSpeedType.equals(this._endSpeedType);
        }

        int getEndBlockIndex() {
            return this._endBlockIdx;
        }

        int getCommandIndexLimit(int blockIdx, int cmdIdx) {
            ThrottleSetting ts;
            int cmd;
            String endBlkName;
            int limit = Engineer.this._commands.size();
            String curBlkName = Engineer.this._warrant.getCurrentBlockName();
            if (!curBlkName.contentEquals(endBlkName = Engineer.this._warrant.getBlockAt(blockIdx).getDisplayName())) {
                cmd = cmdIdx;
                while (cmd < Engineer.this._commands.size()) {
                    ts = (ThrottleSetting)Engineer.this._commands.get(cmd);
                    if (ts.getBeanDisplayName().equals(endBlkName)) {
                        cmdIdx = cmd;
                        break;
                    }
                    ++cmd;
                }
            }
            endBlkName = Engineer.this._warrant.getBlockAt(blockIdx + 1).getDisplayName();
            cmd = cmdIdx;
            while (cmd < Engineer.this._commands.size()) {
                ts = (ThrottleSetting)Engineer.this._commands.get(cmd);
                if (ts.getBeanDisplayName().equals(endBlkName) && ts.getValue().getType().equals((Object)ThrottleSetting.ValueType.VAL_NOOP)) {
                    limit = cmd;
                    break;
                }
                ++cmd;
            }
            log.debug("getCommandIndexLimit: in end block {}, limitIdx = {} in block {}", new Object[]{curBlkName, limit + 1, Engineer.this._warrant.getBlockAt(blockIdx).getDisplayName()});
            return limit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressFBWarnings(value={"UW_UNCOND_WAIT"}, justification="waits may be indefinite until satisfied or thread aborted")
        public void run() {
            this.ready = true;
            while (!this._die) {
                Object object = Engineer.this._rampLockObject;
                synchronized (object) {
                    try {
                        Engineer.this._rampLockObject.wait();
                    }
                    catch (InterruptedException ie) {
                        log.debug("As expected {}", (Throwable)ie);
                    }
                }
                this.ready = false;
                this.stop = false;
                this.holdRamp = false;
                if (this._die) continue;
                this.doRamp();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doRamp() {
            float endSpeed;
            int commandIndexLimit;
            float speed = Engineer.this.getSpeedSetting();
            if (this._endBlockIdx >= 0) {
                commandIndexLimit = this.getCommandIndexLimit(this._endBlockIdx, Engineer.this._idxCurrentCommand);
                endSpeed = Engineer.this._speedUtil.getBlockSpeedInfo(this._endBlockIdx).getExitSpeed();
                endSpeed = Engineer.this._speedUtil.modifySpeed(endSpeed, this._endSpeedType);
            } else {
                commandIndexLimit = Engineer.this._commands.size();
                endSpeed = Engineer.this._speedUtil.modifySpeed(Engineer.this._normalSpeed, this._endSpeedType);
            }
            ThrottleSetting.CommandValue cmdVal = Engineer.this._currentCommand.getValue();
            long timeToSpeedCmd = Engineer.this.getTimeToNextCommand();
            if (log.isDebugEnabled()) {
                log.debug("RAMP {} \"{}\" speed from {}, to {}, at EndBlock \"{}\" at Cmd#{} to Cmd#{}. timeToNextCmd= {}", new Object[]{endSpeed > speed ? "UP" : "DOWN", this._endSpeedType, Float.valueOf(speed), Float.valueOf(endSpeed), this._endBlockIdx >= 0 ? Engineer.this._warrant.getBlockAt(this._endBlockIdx).getDisplayName() : "not required", Engineer.this._idxCurrentCommand + 1, commandIndexLimit, timeToSpeedCmd});
            }
            float throttleIncrement = Engineer.this._speedUtil.getRampThrottleIncrement();
            float scriptTrackSpeed = Engineer.this._speedUtil.getTrackSpeed(Engineer.this._normalSpeed);
            ThrottleRamp throttleRamp = this;
            synchronized (throttleRamp) {
                block43: {
                    try {
                        if (endSpeed > speed) {
                            RampData rampData = Engineer.this._speedUtil.getRampForSpeedChange(speed, 1.0f);
                            int timeIncrement = rampData.getRampTimeIncrement();
                            ListIterator<Float> iter = rampData.speedIterator(true);
                            speed = iter.next().floatValue();
                            float rampDist = 0.0f;
                            float cmdDist = (float)timeToSpeedCmd * scriptTrackSpeed;
                            while (!this.stop && iter.hasNext()) {
                                float s;
                                speed = iter.next().floatValue();
                                if (speed > (s = Engineer.this._speedUtil.modifySpeed(Engineer.this._normalSpeed, this._endSpeedType))) {
                                    Engineer.this.setSpeed(s);
                                    break block43;
                                }
                                Engineer.this.setSpeed(speed);
                                if (!this.stop && rampDist >= cmdDist && Engineer.this._idxCurrentCommand < commandIndexLimit) {
                                    cmdVal = Engineer.this._currentCommand.getValue();
                                    if (cmdVal.getType().equals((Object)ThrottleSetting.ValueType.VAL_FLOAT)) {
                                        Engineer.this._normalSpeed = cmdVal.getFloat();
                                        scriptTrackSpeed = Engineer.this._speedUtil.getTrackSpeed(Engineer.this._normalSpeed);
                                        if (log.isDebugEnabled()) {
                                            log.debug("Cmd #{} for speed= {} skipped.", (Object)(Engineer.this._idxCurrentCommand + 1), (Object)Float.valueOf(Engineer.this._normalSpeed));
                                        }
                                        cmdDist = 0.0f;
                                    } else {
                                        Engineer.this.executeComand(Engineer.this._currentCommand, timeIncrement);
                                    }
                                    List list = Engineer.this._commands;
                                    Engineer engineer = Engineer.this;
                                    int n = engineer._idxCurrentCommand + 1;
                                    engineer._idxCurrentCommand = n;
                                    Engineer.this._currentCommand = (ThrottleSetting)list.get(n);
                                    cmdDist = scriptTrackSpeed * (float)Engineer.this._currentCommand.getTime();
                                    rampDist = 0.0f;
                                    Engineer.this.advanceToCommandIndex(Engineer.this._idxCurrentCommand);
                                }
                                try {
                                    this.wait(timeIncrement);
                                }
                                catch (InterruptedException interruptedException) {
                                    this.stop = true;
                                }
                                rampDist += Engineer.this._speedUtil.getDistanceTraveled(speed, Engineer.this._speedType, timeIncrement);
                            }
                            break block43;
                        }
                        RampData rampData = Engineer.this._speedUtil.getRampForSpeedChange(speed, endSpeed);
                        int timeIncrement = rampData.getRampTimeIncrement();
                        ListIterator<Float> iter = rampData.speedIterator(false);
                        speed = iter.previous().floatValue();
                        float rampDist = 0.0f;
                        float cmdDist = (float)timeToSpeedCmd * scriptTrackSpeed;
                        while (!this.stop && iter.hasPrevious()) {
                            speed = iter.previous().floatValue();
                            Engineer.this.setSpeed(speed);
                            if (this._endBlockIdx >= 0) {
                                if (Engineer.this._warrant.getCurrentOrderIndex() > this._endBlockIdx) {
                                    Engineer.this.setSpeed(endSpeed);
                                    this.stop = true;
                                } else if (Engineer.this._warrant.getCurrentOrderIndex() < this._endBlockIdx && this._endSpeedType.equals(Warrant.Stop) && Math.abs(speed - endSpeed) < 0.001f) {
                                    if (log.isDebugEnabled()) {
                                        log.debug("Extending ramp to reach block {}. speed= {}", (Object)Engineer.this._warrant.getBlockAt(this._endBlockIdx).getDisplayName(), (Object)Float.valueOf(speed));
                                    }
                                    int waittime = 0;
                                    while (this._endBlockIdx > Engineer.this._warrant.getCurrentOrderIndex() && waittime <= 60 * timeIncrement && Engineer.this.getSpeedSetting() > 0.0f) {
                                        if (waittime == 5 * timeIncrement || waittime == 10 * timeIncrement || waittime == 15 * timeIncrement || waittime == 20 * timeIncrement) {
                                            Engineer.this.setSpeed(Engineer.this.getSpeedSetting() + throttleIncrement);
                                        }
                                        try {
                                            this.wait(timeIncrement);
                                            waittime += timeIncrement;
                                        }
                                        catch (InterruptedException interruptedException) {
                                            this.stop = true;
                                        }
                                    }
                                    try {
                                        this.wait(timeIncrement);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        this.stop = true;
                                    }
                                }
                            }
                            if (!this.stop && rampDist >= cmdDist && Engineer.this._idxCurrentCommand < commandIndexLimit) {
                                cmdVal = Engineer.this._currentCommand.getValue();
                                if (cmdVal.getType().equals((Object)ThrottleSetting.ValueType.VAL_FLOAT)) {
                                    Engineer.this._normalSpeed = cmdVal.getFloat();
                                    scriptTrackSpeed = Engineer.this._speedUtil.getTrackSpeed(Engineer.this._normalSpeed);
                                    if (log.isDebugEnabled()) {
                                        log.debug("Cmd #{} for speed= {} skipped.", (Object)(Engineer.this._idxCurrentCommand + 1), (Object)Float.valueOf(Engineer.this._normalSpeed));
                                    }
                                    cmdDist = 0.0f;
                                } else {
                                    Engineer.this.executeComand(Engineer.this._currentCommand, timeIncrement);
                                }
                                List list = Engineer.this._commands;
                                Engineer engineer = Engineer.this;
                                int n = engineer._idxCurrentCommand + 1;
                                engineer._idxCurrentCommand = n;
                                Engineer.this._currentCommand = (ThrottleSetting)list.get(n);
                                cmdDist = scriptTrackSpeed * (float)Engineer.this._currentCommand.getTime();
                                rampDist = 0.0f;
                                Engineer.this.advanceToCommandIndex(Engineer.this._idxCurrentCommand);
                            }
                            try {
                                this.wait(timeIncrement);
                            }
                            catch (InterruptedException interruptedException) {
                                this.stop = true;
                            }
                            rampDist += Engineer.this._speedUtil.getDistanceTraveled(speed, Engineer.this._speedType, timeIncrement);
                        }
                        if (this._endBlockIdx < 0 || commandIndexLimit >= Engineer.this._commands.size()) break block43;
                        long cmdStart = System.currentTimeMillis();
                        while (Engineer.this._idxCurrentCommand < commandIndexLimit) {
                            NamedBean bean = Engineer.this._currentCommand.getNamedBeanHandle().getBean();
                            if (bean instanceof OBlock) {
                                OBlock blk = (OBlock)bean;
                                if (this._endBlockIdx < Engineer.this._warrant.getIndexOfBlock(blk, this._endBlockIdx)) break;
                            }
                            if (!(cmdVal = Engineer.this._currentCommand.getValue()).getType().equals((Object)ThrottleSetting.ValueType.VAL_FLOAT)) {
                                Engineer.this.executeComand(Engineer.this._currentCommand, System.currentTimeMillis() - cmdStart);
                            } else {
                                Engineer.this._normalSpeed = cmdVal.getFloat();
                                if (log.isDebugEnabled()) {
                                    log.debug("Cmd #{} for speed {} skipped. warrant {}", new Object[]{Engineer.this._idxCurrentCommand + 1, Float.valueOf(Engineer.this._normalSpeed), Engineer.this._warrant.getDisplayName()});
                                }
                            }
                            List list = Engineer.this._commands;
                            Engineer engineer = Engineer.this;
                            int n = engineer._idxCurrentCommand + 1;
                            engineer._idxCurrentCommand = n;
                            Engineer.this._currentCommand = (ThrottleSetting)list.get(n);
                            Engineer.this.advanceToCommandIndex(Engineer.this._idxCurrentCommand);
                        }
                    }
                    catch (Throwable throwable) {
                        if (log.isDebugEnabled()) {
                            log.debug("Ramp Done. End Blk= {}, _idxCurrentCommand={} resumeIdx={}, commandIndexLimit={}. warrant {}", new Object[]{this._endBlockIdx >= 0 ? Engineer.this._warrant.getBlockAt(this._endBlockIdx).getDisplayName() : "not required", Engineer.this._idxCurrentCommand + 1, Engineer.this._idxSkipToSpeedCommand, commandIndexLimit, Engineer.this._warrant.getDisplayName()});
                        }
                        throw throwable;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("Ramp Done. End Blk= {}, _idxCurrentCommand={} resumeIdx={}, commandIndexLimit={}. warrant {}", new Object[]{this._endBlockIdx >= 0 ? Engineer.this._warrant.getBlockAt(this._endBlockIdx).getDisplayName() : "not required", Engineer.this._idxCurrentCommand + 1, Engineer.this._idxSkipToSpeedCommand, commandIndexLimit, Engineer.this._warrant.getDisplayName()});
                }
            }
            this.ready = true;
            Engineer.this.rampDone(this.stop, this._endSpeedType);
            this.stop = false;
        }
    }
}

