/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import jmri.NamedBean;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OPath;
import jmri.jmrit.logix.Portal;
import jmri.jmrit.logix.Warrant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockOrder {
    private static final Logger log = LoggerFactory.getLogger(BlockOrder.class);
    private OBlock _block;
    private String _pathName;
    private String _entryName;
    private String _exitName;
    private float _tempPathLen;

    public BlockOrder(OBlock block) {
        this._block = block;
    }

    public BlockOrder(OBlock block, String path, String entry, String exit) {
        this(block);
        this._pathName = path;
        this._entryName = entry;
        this._exitName = exit;
        log.debug("ctor1: {}", (Object)this);
    }

    protected BlockOrder(BlockOrder bo) {
        this._block = bo._block;
        this._pathName = bo._pathName;
        this._entryName = bo._entryName;
        this._exitName = bo._exitName;
        log.debug("ctor2: {}", (Object)this);
    }

    protected void setEntryName(String name) {
        this._entryName = name;
    }

    public String getEntryName() {
        return this._entryName;
    }

    protected void setExitName(String name) {
        this._exitName = name;
    }

    public String getExitName() {
        return this._exitName;
    }

    protected void setPathName(String path) {
        this._pathName = path;
        this._tempPathLen = 0.0f;
    }

    public String getPathName() {
        return this._pathName;
    }

    protected OPath getPath() {
        return this._block.getPathByName(this._pathName);
    }

    protected String setPath(Warrant warrant) {
        Portal p;
        String msg = this._block.setPath(this.getPathName(), warrant);
        if (msg == null && (p = this.getEntryPortal()) != null) {
            p.setEntryState(this._block);
        }
        return msg;
    }

    protected void setTempPathLen(float len) {
        this._tempPathLen = len;
    }

    protected float getTempPathLen() {
        return this._tempPathLen;
    }

    protected void setBlock(OBlock block) {
        this._block = block;
    }

    public OBlock getBlock() {
        return this._block;
    }

    protected Portal getEntryPortal() {
        if (this._entryName == null) {
            return null;
        }
        return this._block.getPortalByName(this._entryName);
    }

    protected Portal getExitPortal() {
        if (this._exitName == null) {
            return null;
        }
        return this._block.getPortalByName(this._exitName);
    }

    protected String getPermissibleEntranceSpeed() {
        Portal portal = this._block.getPortalByName(this.getEntryName());
        if (portal != null) {
            return portal.getPermissibleSpeed(this._block, true);
        }
        return null;
    }

    protected float getEntranceSpace() {
        Portal portal = this._block.getPortalByName(this.getEntryName());
        if (portal != null) {
            return portal.getEntranceSpaceForBlock(this._block);
        }
        return 0.0f;
    }

    protected NamedBean getSignal() {
        Portal portal = this.getEntryPortal();
        if (portal != null) {
            return portal.getSignalProtectingBlock(this._block);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BlockOrder: Block \"");
        sb.append(this._block.getDisplayName());
        sb.append("\" has Path \"");
        sb.append(this._pathName);
        sb.append("\" with Portals, entry= \"");
        sb.append(this._entryName);
        sb.append("\" and exit= \"");
        sb.append(this._exitName);
        sb.append("\"");
        return sb.toString();
    }
}

