/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.jython;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.script.ScriptException;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import jmri.jmrit.jython.Bundle;
import jmri.script.JmriScriptEngineManager;
import jmri.script.ScriptFileChooser;
import jmri.util.FileUtil;
import jmri.util.swing.JmriAbstractAction;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WindowInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunJythonScript
extends JmriAbstractAction {
    File configuredFile;
    static JFileChooser fci = null;
    private static final Logger log = LoggerFactory.getLogger(RunJythonScript.class);

    public RunJythonScript(String s, WindowInterface wi) {
        super(s, wi);
    }

    public RunJythonScript(String s, Icon i, WindowInterface wi) {
        super(s, i, wi);
    }

    public RunJythonScript(String name) {
        super(name);
        this.configuredFile = null;
    }

    public RunJythonScript(String name, File file) {
        super(name);
        this.configuredFile = file;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File thisFile = this.configuredFile != null ? this.configuredFile : this.selectFile();
        if (thisFile != null) {
            this.invoke(thisFile);
        } else {
            log.info("No file selected");
        }
    }

    File selectFile() {
        if (fci == null) {
            fci = new ScriptFileChooser(FileUtil.getScriptsPath());
            fci.setDialogTitle(Bundle.getMessage("FindDesiredScriptFile"));
        } else {
            fci.rescanCurrentDirectory();
        }
        int retVal = fci.showOpenDialog(null);
        if (retVal == 0) {
            File file = fci.getSelectedFile();
            return file;
        }
        return null;
    }

    void invoke(File file) {
        try {
            JmriScriptEngineManager.getDefault().eval(file);
        }
        catch (IOException | ScriptException ex) {
            log.error("Unable to execute script.", (Throwable)ex);
        }
    }

    @Override
    public JmriPanel makePanel() {
        throw new IllegalArgumentException("Should not be invoked");
    }
}

