/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.jython;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.HeadlessException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.script.ScriptException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.jython.Bundle;
import jmri.script.JmriScriptEngineManager;
import jmri.script.ScriptFileChooser;
import jmri.script.ScriptOutput;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import org.python.google.common.io.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputWindow
extends JPanel {
    JTextArea area;
    JButton button;
    JButton loadButton;
    JButton storeButton;
    private UserPreferencesManager pref;
    JLabel status;
    JCheckBox alwaysOnTopCheckBox = new JCheckBox();
    JComboBox<String> languages = new JComboBox();
    JFileChooser userFileChooser = new ScriptFileChooser(FileUtil.getScriptsPath());
    public static final String languageSelection = String.valueOf(InputWindow.class.getName()) + ".language";
    public static final String alwaysOnTopChecked = String.valueOf(InputWindow.class.getName()) + ".alwaysOnTopChecked";
    private static final Logger log = LoggerFactory.getLogger(InputWindow.class);

    public InputWindow() {
        this.pref = InstanceManager.getDefault(UserPreferencesManager.class);
        this.setLayout(new BorderLayout());
        this.area = new JTextArea(12, 50);
        this.area.addCaretListener(e -> {
            JTextArea editArea = (JTextArea)e.getSource();
            int linenum = 1;
            int columnnum = 1;
            try {
                int caretpos = editArea.getCaretPosition();
                linenum = editArea.getLineOfOffset(caretpos);
                columnnum = caretpos - editArea.getLineStartOffset(linenum);
                ++linenum;
            }
            catch (BadLocationException badLocationException) {}
            this.updateStatus(linenum, columnnum);
        });
        JScrollPane js = new JScrollPane(this.area);
        js.setHorizontalScrollBarPolicy(30);
        js.setVerticalScrollBarPolicy(20);
        this.add((Component)js, "Center");
        ArrayList names = new ArrayList();
        JmriScriptEngineManager.getDefault().getManager().getEngineFactories().stream().forEach(factory -> names.add(factory.getLanguageName()));
        this.languages = new JComboBox<String>(names.toArray(new String[names.size()]));
        if (this.pref.getComboBoxLastSelection(languageSelection) != null) {
            this.languages.setSelectedItem(this.pref.getComboBoxLastSelection(languageSelection));
        }
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        this.loadButton = new JButton(Bundle.getMessage("ButtonLoad_"));
        p.add(this.loadButton);
        this.storeButton = new JButton(Bundle.getMessage("ButtonStore_"));
        p.add(this.storeButton);
        p.add(this.languages);
        this.button = new JButton(Bundle.getMessage("ButtonExecute"));
        p.add(this.button);
        this.alwaysOnTopCheckBox.setText(Bundle.getMessage("WindowAlwaysOnTop"));
        this.alwaysOnTopCheckBox.setVisible(true);
        this.alwaysOnTopCheckBox.setToolTipText(Bundle.getMessage("WindowAlwaysOnTopToolTip"));
        p.add(this.alwaysOnTopCheckBox);
        this.status = new JLabel("         ");
        p.add(this.status);
        this.updateStatus(1, 0);
        this.add((Component)p, "South");
        this.button.addActionListener(e -> this.buttonPressed());
        this.loadButton.addActionListener(e -> this.loadButtonPressed());
        this.storeButton.addActionListener(e -> this.storeButtonPressed());
        this.languages.addItemListener(e -> this.pref.setComboBoxLastSelection(languageSelection, (String)this.languages.getSelectedItem()));
        this.alwaysOnTopCheckBox.addActionListener(e -> {
            if (this.getTopLevelAncestor() != null) {
                ((JmriJFrame)this.getTopLevelAncestor()).setAlwaysOnTop(this.alwaysOnTopCheckBox.isSelected());
            }
            this.pref.setSimplePreferenceState(alwaysOnTopChecked, this.alwaysOnTopCheckBox.isSelected());
        });
        this.alwaysOnTopCheckBox.setSelected(this.pref.getSimplePreferenceState(alwaysOnTopChecked));
        int size = this.area.getFont().getSize();
        this.area.setFont(new Font("Monospaced", 0, size));
    }

    private void updateStatus(int linenumber, int columnnumber) {
        this.status.setText("    " + linenumber + ":" + columnnumber);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Should crash if missing ScriptEngine dependencies are not present")
    protected boolean loadFile(JFileChooser fileChooser) {
        boolean results = false;
        File file = InputWindow.getFile(fileChooser);
        if (file != null) {
            try {
                try {
                    this.languages.setSelectedItem(JmriScriptEngineManager.getDefault().getFactoryByExtension(Files.getFileExtension((String)file.getName())).getLanguageName());
                }
                catch (ScriptException scriptException) {
                    log.error("Unable to identify script language for {}, assuming its Python.", (Object)file);
                    this.languages.setSelectedItem(JmriScriptEngineManager.getDefault().getFactory("jython").getLanguageName());
                }
                StringBuilder fileData = new StringBuilder(1024);
                Throwable throwable = null;
                Object var6_8 = null;
                try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                    int numRead;
                    char[] buf = new char[1024];
                    while ((numRead = reader.read(buf)) != -1) {
                        String readData = String.valueOf(buf, 0, numRead);
                        fileData.append(readData);
                        buf = new char[1024];
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                this.area.setText(fileData.toString());
                results = true;
            }
            catch (IOException e) {
                log.error("Unhandled problem in loadFile: {}", (Throwable)e);
            }
        } else {
            results = true;
        }
        return results;
    }

    protected boolean storeFile(JFileChooser fileChooser) {
        boolean results = false;
        File file = InputWindow.getFile(fileChooser);
        if (file != null) {
            try {
                int selectedValue;
                if (file.exists() && (selectedValue = JOptionPane.showConfirmDialog(null, Bundle.getMessage("ConfirmDialogMessage", file.getName()), Bundle.getMessage("ConfirmDialogTitle"), 2)) != 0) {
                    results = false;
                    return results;
                }
                StringBuilder fileData = new StringBuilder(this.area.getText());
                Throwable throwable = null;
                Object var6_9 = null;
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                    writer.append(fileData);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                results = true;
            }
            catch (HeadlessException | IOException e) {
                log.error("Unhandled problem in storeFile: {}", (Throwable)e);
            }
        } else {
            results = true;
        }
        return results;
    }

    public static File getFile(JFileChooser fileChooser) {
        fileChooser.rescanCurrentDirectory();
        int retVal = fileChooser.showDialog(null, null);
        if (retVal != 0) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Open file: {}", (Object)fileChooser.getSelectedFile().getPath());
        }
        return fileChooser.getSelectedFile();
    }

    void loadButtonPressed() {
        this.userFileChooser.setDialogType(0);
        this.userFileChooser.setApproveButtonText(Bundle.getMessage("MenuItemLoad"));
        this.userFileChooser.setDialogTitle(Bundle.getMessage("MenuItemLoad"));
        boolean results = this.loadFile(this.userFileChooser);
        log.debug(results ? "load was successful" : "load failed");
        if (!results) {
            log.warn("Not loading file: {}", (Object)this.userFileChooser.getSelectedFile().getPath());
        }
    }

    void storeButtonPressed() {
        this.userFileChooser.setDialogType(1);
        this.userFileChooser.setApproveButtonText(Bundle.getMessage("MenuItemStore"));
        this.userFileChooser.setDialogTitle(Bundle.getMessage("MenuItemStore"));
        boolean results = this.storeFile(this.userFileChooser);
        log.debug(results ? "store was successful" : "store failed");
        if (!results) {
            log.warn("Not storing file: {}", (Object)this.userFileChooser.getSelectedFile().getPath());
        }
    }

    void buttonPressed() {
        ScriptOutput.writeScript(this.area.getText());
        try {
            JmriScriptEngineManager.getDefault().eval(this.area.getText(), JmriScriptEngineManager.getDefault().getEngineByName((String)this.languages.getSelectedItem()));
        }
        catch (ScriptException ex) {
            log.error("Error executing script", (Throwable)ex);
        }
    }
}

