/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.entryexit.configurexml;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.entryexit.EntryExitPairs;
import jmri.util.ColorUtil;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryExitPairsXml
extends AbstractXmlAdapter {
    private static final Logger log = LoggerFactory.getLogger(EntryExitPairsXml.class);

    @Override
    public Element store(Object o) {
        String memoryName;
        int memoryClearDelay;
        int overLap;
        EntryExitPairs p = (EntryExitPairs)o;
        Element element = new Element("entryexitpairs");
        this.setStoreElementClass(element);
        List<LayoutEditor> editors = p.getSourcePanelList();
        if (editors.isEmpty()) {
            return null;
        }
        Collections.sort(editors, new Comparator<LayoutEditor>(){

            @Override
            public int compare(LayoutEditor o1, LayoutEditor o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        int clearDown = p.getClearDownOption();
        if (clearDown > 0) {
            element.addContent((Content)new Element("cleardown").addContent("" + clearDown));
        }
        if ((overLap = p.getOverlapOption()) > 0) {
            element.addContent((Content)new Element("overlap").addContent("" + overLap));
        }
        if ((memoryClearDelay = p.getMemoryClearDelay()) > 0) {
            element.addContent((Content)new Element("memorycleardelay").addContent("" + memoryClearDelay));
        }
        if (!(memoryName = p.getMemoryOption()).isEmpty()) {
            element.addContent((Content)new Element("memoryname").addContent(memoryName));
        }
        if (p.getDispatcherIntegration()) {
            element.addContent((Content)new Element("dispatcherintegration").addContent("yes"));
        }
        if (p.useDifferentColorWhenSetting()) {
            element.addContent((Content)new Element("colourwhilesetting").addContent(ColorUtil.colorToColorName(p.getSettingRouteColor())));
            element.addContent((Content)new Element("settingTimer").addContent("" + p.getSettingTimer()));
        }
        int k = 0;
        while (k < editors.size()) {
            LayoutEditor panel = editors.get(k);
            List<Object> nxpair = p.getSourceList(panel);
            Collections.sort(nxpair, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            });
            Element panelElem = new Element("layoutPanel");
            panelElem.setAttribute("name", panel.getLayoutName());
            int j = 0;
            while (j < nxpair.size()) {
                Object key = nxpair.get(j);
                Element source = new Element("source");
                String type = "";
                String item = "";
                if (key instanceof SignalMast) {
                    type = "signalMast";
                    item = ((SignalMast)key).getDisplayName();
                } else if (key instanceof Sensor) {
                    type = "sensor";
                    item = ((Sensor)key).getDisplayName();
                } else if (key instanceof SignalHead) {
                    type = "signalHead";
                    item = ((SignalHead)key).getDisplayName();
                }
                source.setAttribute("type", type);
                source.setAttribute("item", item);
                List<Object> a = p.getDestinationList(key, panel);
                Collections.sort(a, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        return o1.toString().compareTo(o2.toString());
                    }
                });
                int i = 0;
                while (i < a.size()) {
                    Object keyDest = a.get(i);
                    String typeDest = "";
                    String itemDest = "";
                    if (keyDest instanceof SignalMast) {
                        typeDest = "signalMast";
                        itemDest = ((SignalMast)keyDest).getDisplayName();
                    } else if (keyDest instanceof Sensor) {
                        typeDest = "sensor";
                        itemDest = ((Sensor)keyDest).getDisplayName();
                    } else if (keyDest instanceof SignalHead) {
                        typeDest = "signalHead";
                        itemDest = ((SignalHead)keyDest).getDisplayName();
                    }
                    Element dest = new Element("destination");
                    dest.setAttribute("type", typeDest);
                    dest.setAttribute("item", itemDest);
                    if (!p.isUniDirection(key, panel, keyDest)) {
                        dest.setAttribute("uniDirection", "no");
                    }
                    if (!p.isEnabled(key, panel, keyDest)) {
                        dest.setAttribute("enabled", "no");
                    }
                    int nxType = p.getEntryExitType(key, panel, keyDest);
                    switch (nxType) {
                        case 1: {
                            dest.setAttribute("nxType", "signalmastlogic");
                            break;
                        }
                        case 2: {
                            dest.setAttribute("nxType", "fullinterlocking");
                            break;
                        }
                        default: {
                            dest.setAttribute("nxType", "turnoutsetting");
                        }
                    }
                    if (p.getUniqueId(key, panel, keyDest) != null) {
                        dest.setAttribute("uniqueid", p.getUniqueId(key, panel, keyDest));
                    }
                    source.addContent((Content)dest);
                    ++i;
                }
                panelElem.addContent((Content)source);
                ++j;
            }
            element.addContent((Content)panelElem);
            ++k;
        }
        return element;
    }

    public void setStoreElementClass(Element messages) {
        messages.setAttribute("class", "jmri.jmrit.entryexit.configurexml.EntryExitPairsXml");
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        List<Object> loadedPanel;
        ConfigureManager cm;
        EntryExitPairs eep = InstanceManager.getDefault(EntryExitPairs.class);
        String nodeText = shared.getChildText("cleardown");
        if (nodeText != null) {
            eep.setClearDownOption(Integer.parseInt(nodeText));
        }
        if ((nodeText = shared.getChildText("overlap")) != null) {
            eep.setOverlapOption(Integer.parseInt(nodeText));
        }
        if ((nodeText = shared.getChildText("memorycleardelay")) != null) {
            eep.setMemoryClearDelay(Integer.parseInt(nodeText));
        }
        if ((nodeText = shared.getChildText("memoryname")) != null) {
            eep.setMemoryOption(nodeText);
        }
        if ((cm = InstanceManager.getNullableDefault(ConfigureManager.class)) != null) {
            loadedPanel = cm.getInstanceList(LayoutEditor.class);
        } else {
            log.error("Failed getting optional default config manager");
            loadedPanel = new ArrayList<Object>();
        }
        if (shared.getChild("dispatcherintegration") != null && shared.getChild("dispatcherintegration").getText().equals("yes")) {
            eep.setDispatcherIntegration(true);
        }
        if (shared.getChild("colourwhilesetting") != null) {
            try {
                eep.setSettingRouteColor(ColorUtil.stringToColor(shared.getChild("colourwhilesetting").getText()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                eep.setSettingRouteColor(Color.BLACK);
                log.error("Invalid color {}; using black", (Object)shared.getChild("colourwhilesetting").getText());
            }
            int settingTimer = 2000;
            try {
                settingTimer = Integer.parseInt(shared.getChild("settingTimer").getText());
            }
            catch (NumberFormatException numberFormatException) {
                log.error("Error in converting timer to int {}", (Object)shared.getChild("settingTimer"));
            }
            eep.setSettingTimer(settingTimer);
        }
        List panelList = shared.getChildren("layoutPanel");
        int k = 0;
        while (k < panelList.size()) {
            block67: {
                block62: {
                    String panelName = ((Element)panelList.get(k)).getAttribute("name").getValue();
                    LayoutEditor panel = null;
                    int i = 0;
                    while (i < loadedPanel.size()) {
                        LayoutEditor tmp = (LayoutEditor)loadedPanel.get(i);
                        if (tmp.getLayoutName().equals(panelName)) {
                            panel = tmp;
                            break;
                        }
                        ++i;
                    }
                    if (panel == null) break block62;
                    List sourceList = ((Element)panelList.get(k)).getChildren("source");
                    int i2 = 0;
                    while (i2 < sourceList.size()) {
                        String sourceType = ((Element)sourceList.get(i2)).getAttribute("type").getValue();
                        String sourceItem = ((Element)sourceList.get(i2)).getAttribute("item").getValue();
                        NamedBean source = null;
                        switch (sourceType) {
                            case "signalMast": {
                                source = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(sourceItem);
                                break;
                            }
                            case "sensor": {
                                source = InstanceManager.getDefault(SensorManager.class).getSensor(sourceItem);
                                break;
                            }
                            case "signalHead": {
                                source = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(sourceItem);
                                break;
                            }
                        }
                        List destinationList = ((Element)sourceList.get(i2)).getChildren("destination");
                        if (destinationList.size() > 0) {
                            eep.addNXSourcePoint(source, panel);
                        }
                        int j = 0;
                        while (j < destinationList.size()) {
                            block65: {
                                String nxType;
                                String id = null;
                                if (((Element)destinationList.get(j)).getAttribute("uniqueid") != null && !(id = ((Element)destinationList.get(j)).getAttribute("uniqueid").getValue()).startsWith("IN:")) {
                                    id = "IN:" + id;
                                }
                                String destType = ((Element)destinationList.get(j)).getAttribute("type").getValue();
                                String destItem = ((Element)destinationList.get(j)).getAttribute("item").getValue();
                                NamedBean dest = null;
                                switch (destType) {
                                    case "signalMast": {
                                        dest = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(destItem);
                                        break;
                                    }
                                    case "sensor": {
                                        dest = InstanceManager.getDefault(SensorManager.class).getSensor(destItem);
                                        break;
                                    }
                                    case "signalHead": {
                                        dest = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(destItem);
                                        break;
                                    }
                                }
                                try {
                                    eep.addNXDestination(source, dest, panel, id);
                                }
                                catch (NullPointerException nullPointerException) {
                                    log.error("An error occurred while trying to add a point");
                                }
                                if (((Element)destinationList.get(j)).getAttribute("uniDirection") != null && ((Element)destinationList.get(j)).getAttribute("uniDirection").getValue().equals("no")) {
                                    eep.setUniDirection(source, panel, dest, false);
                                }
                                if (((Element)destinationList.get(j)).getAttribute("enabled") != null && ((Element)destinationList.get(j)).getAttribute("enabled").getValue().equals("no")) {
                                    eep.setEnabled(source, panel, dest, false);
                                }
                                if (((Element)destinationList.get(j)).getAttribute("nxType") == null) break block65;
                                switch (nxType = ((Element)destinationList.get(j)).getAttribute("nxType").getValue()) {
                                    case "turnoutsetting": {
                                        eep.setEntryExitType(source, panel, dest, 0);
                                        break;
                                    }
                                    case "signalmastlogic": {
                                        eep.setEntryExitType(source, panel, dest, 1);
                                        break;
                                    }
                                    case "fullinterlocking": {
                                        eep.setEntryExitType(source, panel, dest, 2);
                                        break;
                                    }
                                }
                            }
                            ++j;
                        }
                        ++i2;
                    }
                    break block67;
                }
                log.error("Panel has not been loaded");
            }
            ++k;
        }
        return true;
    }

    @Override
    public int loadOrder() {
        return InstanceManager.getDefault(EntryExitPairs.class).getXMLOrder();
    }
}

