/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.entryexit;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import jmri.ConditionalAction;
import jmri.ConditionalVariable;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.JmriException;
import jmri.Logix;
import jmri.LogixManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.SignalMastLogicManager;
import jmri.SystemConnectionMemo;
import jmri.beans.VetoableChangeSupport;
import jmri.implementation.DefaultConditional;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockConnectivityTools;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.entryexit.Bundle;
import jmri.jmrit.entryexit.DestinationPoints;
import jmri.jmrit.entryexit.PointDetails;
import jmri.jmrit.entryexit.Source;
import jmri.jmrit.entryexit.StackNXPanel;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import jmri.util.LoggingUtil;
import jmri.util.NamedBeanComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryExitPairs
extends VetoableChangeSupport
implements Manager<DestinationPoints>,
InstanceManagerAutoDefault,
PropertyChangeListener {
    public LayoutBlockConnectivityTools.Metric routingMethod = LayoutBlockConnectivityTools.Metric.METRIC;
    public static final int NXBUTTONSELECTED = 8;
    public static final int NXBUTTONACTIVE = 2;
    public static final int NXBUTTONINACTIVE = 4;
    private final SystemConnectionMemo memo;
    private final Map<String, Boolean> silencedProperties = new HashMap<String, Boolean>();
    private int settingTimer = 2000;
    private Color settingRouteColor = null;
    public static final int SETUPTURNOUTSONLY = 0;
    public static final int SETUPSIGNALMASTLOGIC = 1;
    public static final int FULLINTERLOCK = 2;
    boolean allocateToDispatcher = false;
    public static final int PROMPTUSER = 0;
    public static final int AUTOCLEAR = 1;
    public static final int AUTOCANCEL = 2;
    public static final int AUTOSTACK = 3;
    public static final int OVERLAP_CANCEL = 1;
    public static final int OVERLAP_STACK = 2;
    int routeClearOption = 0;
    int routeOverlapOption = 0;
    String memoryOption = "";
    int memoryClearDelay = 0;
    static JPanel glassPane = new JPanel();
    public int turnoutSetDelay = 0;
    HashMap<PointDetails, Source> nxpair = new HashMap();
    int refCounter = 0;
    List<SourceToDest> routesToSet = new ArrayList<SourceToDest>();
    int currentDealing = 0;
    protected PropertyChangeListener propertyDestinationListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            ((DestinationPoints)e.getSource()).removePropertyChangeListener(this);
            if (e.getPropertyName().equals("active")) {
                EntryExitPairs.this.processRoutesToSet();
            } else if (e.getPropertyName().equals("stacked") || e.getPropertyName().equals("failed") || e.getPropertyName().equals("noChange")) {
                EntryExitPairs.this.removeRemainingRoute();
            }
        }
    };
    List<Object> destinationList = new ArrayList<Object>();
    List<DeletePair> deletePairList = new ArrayList<DeletePair>();
    SignalMastLogicManager smlm = InstanceManager.getDefault(SignalMastLogicManager.class);
    public static final int CANCELROUTE = 0;
    public static final int CLEARROUTE = 1;
    public static final int EXITROUTE = 2;
    public static final int STACKROUTE = 4;
    static List<PointDetails> pointDetails = new ArrayList<PointDetails>();
    List<StackDetails> stackList = new ArrayList<StackDetails>();
    StackNXPanel stackPanel = null;
    JDialog stackDialog = null;
    Timer checkTimer = new Timer(10000, e -> this.checkRoute());
    boolean runWhenStabilised = false;
    LayoutEditor toUseWhenStable;
    int interlockTypeToUseWhenStable;
    protected PropertyChangeListener propertyBlockManagerListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            boolean newValue;
            if (e.getPropertyName().equals("topology") && (newValue = ((Boolean)e.getNewValue()).booleanValue()) && EntryExitPairs.this.runWhenStabilised) {
                try {
                    EntryExitPairs.this.automaticallyDiscoverEntryExitPairs(EntryExitPairs.this.toUseWhenStable, EntryExitPairs.this.interlockTypeToUseWhenStable);
                }
                catch (JmriException jmriException) {}
            }
        }
    };
    final List<Manager.ManagerDataListener<DestinationPoints>> listeners = new ArrayList<Manager.ManagerDataListener<DestinationPoints>>();
    private static final Logger log = LoggerFactory.getLogger(EntryExitPairs.class);

    public int getSettingTimer() {
        return this.settingTimer;
    }

    public void setSettingTimer(int i) {
        this.settingTimer = i;
    }

    public boolean useDifferentColorWhenSetting() {
        return this.settingRouteColor != null;
    }

    public Color getSettingRouteColor() {
        return this.settingRouteColor;
    }

    public void setSettingRouteColor(Color col) {
        this.settingRouteColor = col;
    }

    public EntryExitPairs() {
        this.memo = InstanceManager.getDefault(InternalSystemConnectionMemo.class);
        InstanceManager.getOptionalDefault(ConfigureManager.class).ifPresent(cm -> cm.registerUser(this));
        InstanceManager.getDefault(LayoutBlockManager.class).addPropertyChangeListener(this.propertyBlockManagerListener);
        glassPane.setOpaque(false);
        glassPane.setLayout(null);
        glassPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                e.consume();
            }
        });
    }

    public void setDispatcherIntegration(boolean boo) {
        this.allocateToDispatcher = boo;
    }

    public boolean getDispatcherIntegration() {
        return this.allocateToDispatcher;
    }

    public JPanel getGlassPane() {
        return glassPane;
    }

    public void addNXSourcePoint(LayoutBlock facing, List<LayoutBlock> protecting, NamedBean loc, LayoutEditor panel) {
        PointDetails point = this.providePoint(facing, protecting, panel);
        point.setRefObject(loc);
    }

    public void addNXSourcePoint(NamedBean source) {
        PointDetails point = null;
        for (LayoutEditor editor : InstanceManager.getDefault(EditorManager.class).getAll(LayoutEditor.class)) {
            point = this.providePoint(source, editor);
        }
        if (point == null) {
            log.error("Unable to find a location on any panel for item {}", (Object)source.getDisplayName());
        }
    }

    public void addNXSourcePoint(NamedBean source, LayoutEditor panel) {
        if (source == null) {
            log.error("source bean supplied is null");
            return;
        }
        if (panel == null) {
            log.error("panel supplied is null");
            return;
        }
        PointDetails point = this.providePoint(source, panel);
        if (point == null) {
            log.error("Unable to find a location on the panel {} for item {}", (Object)panel.getLayoutName(), (Object)source.getDisplayName());
        }
    }

    public Object getEndPointLocation(NamedBean source, LayoutEditor panel) {
        if (source == null) {
            log.error("Source bean past is null");
            return null;
        }
        if (panel == null) {
            log.error("panel passed is null");
            return null;
        }
        PointDetails sourcePoint = this.getPointDetails(source, panel);
        if (sourcePoint == null) {
            log.error("Point is not located");
            return null;
        }
        return sourcePoint.getRefLocation();
    }

    @Override
    public int getXMLOrder() {
        return 280;
    }

    @Override
    public DestinationPoints getBySystemName(String systemName) {
        for (Source e : this.nxpair.values()) {
            DestinationPoints pd = e.getByUniqueId(systemName);
            if (pd == null) continue;
            return pd;
        }
        return null;
    }

    @Override
    public DestinationPoints getByUserName(@Nonnull String userName) {
        for (Source e : this.nxpair.values()) {
            DestinationPoints pd = e.getByUserName(userName);
            if (pd == null) continue;
            return pd;
        }
        return null;
    }

    @Override
    public DestinationPoints getNamedBean(@Nonnull String name) {
        DestinationPoints b = this.getByUserName(name);
        if (b != null) {
            return b;
        }
        return this.getBySystemName(name);
    }

    @Override
    @Nonnull
    public SystemConnectionMemo getMemo() {
        return this.memo;
    }

    @Override
    @Nonnull
    public String getSystemPrefix() {
        return this.memo.getSystemPrefix();
    }

    @Override
    public char typeLetter() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @Nonnull
    public String makeSystemName(@Nonnull String s) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @CheckReturnValue
    public int getObjectCount() {
        return this.getNamedBeanSet().size();
    }

    @Override
    @Nonnull
    @Deprecated
    public List<String> getSystemNameList() {
        LoggingUtil.deprecationWarning(log, "getSystemNameList");
        return this.getEntryExitList();
    }

    @Override
    @Nonnull
    @Deprecated
    public List<DestinationPoints> getNamedBeanList() {
        LoggingUtil.deprecationWarning(log, "getNamedBeanList");
        ArrayList<DestinationPoints> beanList = new ArrayList<DestinationPoints>();
        for (Source e : this.nxpair.values()) {
            ArrayList<String> uidList = e.getDestinationUniqueId();
            for (String uid : uidList) {
                beanList.add(e.getByUniqueId(uid));
            }
        }
        return beanList;
    }

    @Override
    @Nonnull
    public SortedSet<DestinationPoints> getNamedBeanSet() {
        TreeSet<DestinationPoints> beanList = new TreeSet<DestinationPoints>(new NamedBeanComparator());
        for (Source e : this.nxpair.values()) {
            ArrayList<String> uidList = e.getDestinationUniqueId();
            for (String uid : uidList) {
                beanList.add(e.getByUniqueId(uid));
            }
        }
        return beanList;
    }

    @Override
    public void register(@Nonnull DestinationPoints n) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void deregister(@Nonnull DestinationPoints n) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setClearDownOption(int i) {
        this.routeClearOption = i;
    }

    public int getClearDownOption() {
        return this.routeClearOption;
    }

    public void setOverlapOption(int i) {
        this.routeOverlapOption = i;
    }

    public int getOverlapOption() {
        return this.routeOverlapOption;
    }

    public void setMemoryOption(String memoryName) {
        this.memoryOption = memoryName;
    }

    public String getMemoryOption() {
        return this.memoryOption;
    }

    public void setMemoryClearDelay(int secs) {
        this.memoryClearDelay = secs;
    }

    public int getMemoryClearDelay() {
        return this.memoryClearDelay;
    }

    @Override
    public void dispose() {
    }

    public PointDetails providePoint(NamedBean source, LayoutEditor panel) {
        PointDetails sourcePoint = this.getPointDetails(source, panel);
        if (sourcePoint == null) {
            LayoutBlock facing = InstanceManager.getDefault(LayoutBlockManager.class).getFacingBlockByNamedBean(source, null);
            List<LayoutBlock> protecting = InstanceManager.getDefault(LayoutBlockManager.class).getProtectingBlocksByNamedBean(source, null);
            if (facing == null && protecting.size() == 0) {
                log.error("Unable to find facing and protecting blocks");
                return null;
            }
            sourcePoint = this.providePoint(facing, protecting, panel);
            sourcePoint.setRefObject(source);
        }
        return sourcePoint;
    }

    public List<Object> getSourceList(LayoutEditor panel) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Map.Entry<PointDetails, Source> e : this.nxpair.entrySet()) {
            NamedBean obj = e.getKey().getRefObject();
            LayoutEditor pan = e.getKey().getPanel();
            if (pan != panel || list.contains(obj)) continue;
            list.add(obj);
        }
        return list;
    }

    public Source getSourceForPoint(PointDetails pd) {
        return this.nxpair.get(pd);
    }

    public int getNxPairNumbers(LayoutEditor panel) {
        int total = 0;
        for (Map.Entry<PointDetails, Source> e : this.nxpair.entrySet()) {
            PointDetails key = e.getKey();
            LayoutEditor pan = key.getPanel();
            if (pan != panel) continue;
            total += e.getValue().getNumberOfDestinations();
        }
        return total;
    }

    public void setSingleSegmentRoute(String nxPair) {
        DestinationPoints dp = this.getNamedBean(nxPair);
        if (dp != null) {
            String destUUID = dp.getUniqueId();
            this.nxpair.forEach((pd, src) -> {
                for (String srcUUID : src.getDestinationUniqueId()) {
                    if (!destUUID.equals(srcUUID)) continue;
                    log.debug("Found the correct source: src = {}, dest = {}", (Object)pd.getSensor().getDisplayName(), (Object)dp.getDestPoint().getSensor().getDisplayName());
                    this.setMultiPointRoute((PointDetails)pd, dp.getDestPoint());
                    return;
                }
            });
        }
    }

    public void setMultiPointRoute(PointDetails requestpd, LayoutEditor panel) {
        for (PointDetails pd : pointDetails) {
            if (pd == requestpd || pd.getNXState() != 8) continue;
            this.setMultiPointRoute(pd, requestpd);
            return;
        }
    }

    private void setMultiPointRoute(PointDetails fromPd, PointDetails toPd) {
        boolean cleardown = false;
        if (fromPd.isRouteFromPointSet() && toPd.isRouteToPointSet()) {
            cleardown = true;
        }
        for (LayoutBlock pro : fromPd.getProtecting()) {
            try {
                Source s;
                List<LayoutBlock> blkList;
                boolean result;
                LayoutBlockManager lbm = InstanceManager.getDefault(LayoutBlockManager.class);
                LayoutBlock toProt = null;
                if (!toPd.getProtecting().isEmpty()) {
                    toProt = toPd.getProtecting().get(0);
                }
                if (!(result = lbm.getLayoutBlockConnectivityTools().checkValidDest(fromPd.getFacing(), pro, toPd.getFacing(), toProt, LayoutBlockConnectivityTools.Routing.SENSORTOSENSOR)) || (blkList = lbm.getLayoutBlockConnectivityTools().getLayoutBlocks(fromPd.getFacing(), toPd.getFacing(), pro, cleardown, LayoutBlockConnectivityTools.Routing.NONE)).isEmpty()) continue;
                if (log.isDebugEnabled()) {
                    for (LayoutBlock blk : blkList) {
                        log.debug("blk = {}", (Object)blk.getDisplayName());
                    }
                }
                List<NamedBean> beanList = lbm.getLayoutBlockConnectivityTools().getBeansInPath(blkList, null, Sensor.class);
                PointDetails fromPoint = fromPd;
                ++this.refCounter;
                if (!beanList.isEmpty()) {
                    if (log.isDebugEnabled()) {
                        for (NamedBean xnb : beanList) {
                            log.debug("xnb = {}", (Object)xnb.getDisplayName());
                        }
                    }
                    int i = 1;
                    while (i < beanList.size()) {
                        NamedBean nb = beanList.get(i);
                        PointDetails cur = this.getPointDetails(nb, fromPd.getPanel());
                        Source s2 = this.nxpair.get(fromPoint);
                        if (s2 != null) {
                            this.routesToSet.add(new SourceToDest(s2, s2.getDestForPoint(cur), false, this.refCounter));
                        }
                        fromPoint = cur;
                        ++i;
                    }
                }
                if ((s = this.nxpair.get(fromPoint)) != null && s.getDestForPoint(toPd) != null) {
                    this.routesToSet.add(new SourceToDest(s, s.getDestForPoint(toPd), false, this.refCounter));
                }
                this.processRoutesToSet();
                return;
            }
            catch (JmriException jmriException) {}
        }
        fromPd.setNXButtonState(4);
        toPd.setNXButtonState(4);
    }

    synchronized void processRoutesToSet() {
        if (log.isDebugEnabled()) {
            for (SourceToDest sd : this.routesToSet) {
                String dpName = sd.dp == null ? "- null -" : sd.dp.getDestPoint().getSensor().getDisplayName();
                log.debug("processRoutesToSet: {} -- {} -- {}", new Object[]{sd.s.getPoint().getSensor().getDisplayName(), dpName, sd.ref});
            }
        }
        if (this.routesToSet.isEmpty()) {
            return;
        }
        Source s = this.routesToSet.get((int)0).s;
        DestinationPoints dp = this.routesToSet.get((int)0).dp;
        boolean dir = this.routesToSet.get((int)0).direction;
        this.currentDealing = this.routesToSet.get((int)0).ref;
        this.routesToSet.remove(0);
        dp.addPropertyChangeListener(this.propertyDestinationListener);
        s.activeBean(dp, dir);
    }

    synchronized void removeRemainingRoute() {
        ArrayList<SourceToDest> toRemove = new ArrayList<SourceToDest>();
        for (SourceToDest rts : this.routesToSet) {
            if (rts.ref != this.currentDealing) continue;
            toRemove.add(rts);
            rts.dp.getDestPoint().setNXButtonState(4);
        }
        for (SourceToDest rts : toRemove) {
            this.routesToSet.remove(rts);
        }
    }

    public List<Object> getNxSource(LayoutEditor panel) {
        ArrayList<Object> source = new ArrayList<Object>();
        this.destinationList = new ArrayList<Object>();
        for (Map.Entry<PointDetails, Source> e : this.nxpair.entrySet()) {
            PointDetails key = e.getKey();
            LayoutEditor pan = key.getPanel();
            if (pan != panel) continue;
            ArrayList<PointDetails> dest = this.nxpair.get(key).getDestinationPoints();
            int i = 0;
            while (i < dest.size()) {
                this.destinationList.add(((PointDetails)dest.get(i)).getRefObject());
                source.add(key.getRefObject());
                ++i;
            }
        }
        return source;
    }

    public List<Object> getNxDestination() {
        return this.destinationList;
    }

    public List<LayoutEditor> getSourcePanelList() {
        ArrayList<LayoutEditor> list = new ArrayList<LayoutEditor>();
        for (Map.Entry<PointDetails, Source> e : this.nxpair.entrySet()) {
            PointDetails key = e.getKey();
            LayoutEditor pan = key.getPanel();
            if (list.contains(pan)) continue;
            list.add(pan);
        }
        return list;
    }

    private PointDetails providePoint(LayoutBlock source, List<LayoutBlock> protecting, LayoutEditor panel) {
        PointDetails sourcePoint = this.getPointDetails(source, protecting, panel);
        if (sourcePoint == null) {
            sourcePoint = new PointDetails(source, protecting);
            sourcePoint.setPanel(panel);
        }
        return sourcePoint;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange("active", evt.getOldValue(), evt.getNewValue());
    }

    public void addNXDestination(NamedBean source, NamedBean destination, LayoutEditor panel) {
        this.addNXDestination(source, destination, panel, null);
    }

    public void addNXDestination(NamedBean source, NamedBean destination, LayoutEditor panel, String id) {
        if (source == null) {
            log.error("no source Object provided");
            return;
        }
        if (destination == null) {
            log.error("no destination Object provided");
            return;
        }
        PointDetails sourcePoint = this.providePoint(source, panel);
        if (sourcePoint == null) {
            log.error("source point for {} not created addNXDes", (Object)source.getDisplayName());
            return;
        }
        sourcePoint.setPanel(panel);
        sourcePoint.setRefObject(source);
        PointDetails destPoint = this.providePoint(destination, panel);
        if (destPoint != null) {
            destPoint.setPanel(panel);
            destPoint.setRefObject(destination);
            destPoint.getSignal();
            if (!this.nxpair.containsKey(sourcePoint)) {
                Source sp = new Source(sourcePoint);
                this.nxpair.put(sourcePoint, sp);
                sp.removePropertyChangeListener(this);
                sp.addPropertyChangeListener(this);
            }
            this.nxpair.get(sourcePoint).addDestination(destPoint, id);
        }
        this.firePropertyChange("length", null, null);
    }

    public List<Object> getDestinationList(Object obj, LayoutEditor panel) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.nxpair.containsKey(this.getPointDetails(obj, panel))) {
            ArrayList<PointDetails> from = this.nxpair.get(this.getPointDetails(obj, panel)).getDestinationPoints();
            int i = 0;
            while (i < from.size()) {
                list.add(((PointDetails)from.get(i)).getRefObject());
                ++i;
            }
        }
        return list;
    }

    public void removeNXSensor(Sensor sensor) {
        log.info("panel maintenance has resulting in the request to remove a sensor: {}", (Object)sensor.getDisplayName());
    }

    public boolean deleteNxPair(NamedBean sensor) {
        if (sensor == null) {
            log.error("deleteNxPair: sensor is null");
            return false;
        }
        this.createDeletePairList(sensor);
        if (this.checkNxPairs() && this.confirmDeletePairs()) {
            this.deleteNxPairs();
            return true;
        }
        return false;
    }

    public boolean deleteNxPair(NamedBean entrySensor, NamedBean exitSensor, LayoutEditor panel) {
        if (entrySensor == null || exitSensor == null || panel == null) {
            log.error("deleteNxPair: One or more null inputs");
            return false;
        }
        this.deletePairList.clear();
        this.deletePairList.add(new DeletePair(entrySensor, exitSensor, panel));
        if (this.checkNxPairs()) {
            this.deleteNxPairs();
            return true;
        }
        return false;
    }

    private boolean checkNxPairs() {
        LogixManager mgr = InstanceManager.getDefault(LogixManager.class);
        ArrayList<String> conditionalReferences = new ArrayList<String>();
        for (DeletePair dPair : this.deletePairList) {
            if (dPair.dp == null) continue;
            for (Logix lgx : mgr.getNamedBeanSet()) {
                int i = 0;
                while (i < lgx.getNumConditionals()) {
                    String refName;
                    String cdlName = lgx.getConditionalByNumberOrder(i);
                    DefaultConditional cdl = (DefaultConditional)lgx.getConditional(cdlName);
                    String cdlUserName = cdl.getUserName();
                    if (cdlUserName == null) {
                        cdlUserName = "";
                    }
                    for (ConditionalVariable var : cdl.getStateVariableList()) {
                        if (var.getBean() != dPair.dp) continue;
                        String string = refName = cdlUserName.equals("") ? cdlName : String.valueOf(cdlName) + "  ( " + cdlUserName + " )";
                        if (conditionalReferences.contains(refName)) continue;
                        conditionalReferences.add(refName);
                    }
                    for (ConditionalAction act : cdl.getActionList()) {
                        if (act.getBean() != dPair.dp) continue;
                        String string = refName = cdlUserName.equals("") ? cdlName : String.valueOf(cdlName) + "  ( " + cdlUserName + " )";
                        if (conditionalReferences.contains(refName)) continue;
                        conditionalReferences.add(refName);
                    }
                    ++i;
                }
            }
        }
        if (conditionalReferences.isEmpty()) {
            return true;
        }
        conditionalReferences.sort(null);
        StringBuilder msg = new StringBuilder(Bundle.getMessage("DeleteReferences"));
        for (String ref : conditionalReferences) {
            msg.append("\n    " + ref);
        }
        JOptionPane.showMessageDialog(null, msg.toString(), Bundle.getMessage("WarningTitle"), 2);
        return false;
    }

    private boolean confirmDeletePairs() {
        if (this.deletePairList.size() > 0) {
            StringBuilder msg = new StringBuilder(Bundle.getMessage("DeletePairs"));
            for (DeletePair dPair : this.deletePairList) {
                if (dPair.dp == null) continue;
                msg.append("\n    " + dPair.dp.getDisplayName());
            }
            msg.append("\n" + Bundle.getMessage("DeleteContinue"));
            int resp = JOptionPane.showConfirmDialog(null, msg.toString(), Bundle.getMessage("WarningTitle"), 0, 3);
            if (resp != 0) {
                return false;
            }
        }
        return true;
    }

    private void deleteNxPairs() {
        for (DeletePair dp : this.deletePairList) {
            PointDetails sourcePoint = this.getPointDetails(dp.src, dp.pnl);
            PointDetails destPoint = this.getPointDetails(dp.dest, dp.pnl);
            this.nxpair.get(sourcePoint).removeDestination(destPoint);
            this.firePropertyChange("length", null, null);
            if (!this.nxpair.get(sourcePoint).getDestinationPoints().isEmpty()) continue;
            this.nxpair.get(sourcePoint).removePropertyChangeListener(this);
            this.nxpair.remove(sourcePoint);
        }
    }

    void createDeletePairList(NamedBean sensor) {
        this.deletePairList.clear();
        this.nxpair.forEach((pdSrc, src) -> {
            Sensor sBean = pdSrc.getSensor();
            LayoutEditor sPanel = pdSrc.getPanel();
            for (PointDetails pdDest : src.getDestinationPoints()) {
                Sensor dBean = pdDest.getSensor();
                if (sensor != sBean && sensor != dBean) continue;
                log.debug("Delete pair: {} to {}, panel = {}", new Object[]{sBean.getDisplayName(), dBean.getDisplayName(), sPanel.getLayoutName()});
                this.deletePairList.add(new DeletePair(sBean, dBean, sPanel));
            }
        });
    }

    public List<String> layoutBlockSensors(@Nonnull LayoutBlock layoutBlock) {
        log.debug("layoutBlockSensors: {}", (Object)layoutBlock.getDisplayName());
        ArrayList<String> blockSensors = new ArrayList<String>();
        this.nxpair.forEach((pdSrc, src) -> {
            Sensor sBean = pdSrc.getSensor();
            for (LayoutBlock sProtect : pdSrc.getProtecting()) {
                if (layoutBlock != pdSrc.getFacing() && layoutBlock != sProtect) continue;
                log.debug("  Source = '{}', Facing = '{}', Protecting = '{}'         ", new Object[]{sBean.getDisplayName(), pdSrc.getFacing().getDisplayName(), sProtect.getDisplayName()});
                blockSensors.add(sBean.getDisplayName());
            }
            for (PointDetails pdDest : src.getDestinationPoints()) {
                Sensor dBean = pdDest.getSensor();
                for (LayoutBlock dProtect : pdDest.getProtecting()) {
                    if (layoutBlock != pdDest.getFacing() && layoutBlock != dProtect) continue;
                    log.debug("    Destination = '{}', Facing = '{}', Protecting = '{}'     ", new Object[]{dBean.getDisplayName(), pdDest.getFacing().getDisplayName(), dProtect.getDisplayName()});
                    blockSensors.add(dBean.getDisplayName());
                }
            }
        });
        return blockSensors;
    }

    public boolean isDestinationValid(Object source, Object dest, LayoutEditor panel) {
        if (this.nxpair.containsKey(this.getPointDetails(source, panel))) {
            return this.nxpair.get(this.getPointDetails(source, panel)).isDestinationValid(this.getPointDetails(dest, panel));
        }
        return false;
    }

    public boolean isUniDirection(Object source, LayoutEditor panel, Object dest) {
        if (this.nxpair.containsKey(this.getPointDetails(source, panel))) {
            return this.nxpair.get(this.getPointDetails(source, panel)).getUniDirection(dest, panel);
        }
        return false;
    }

    public void setUniDirection(Object source, LayoutEditor panel, Object dest, boolean set) {
        if (this.nxpair.containsKey(this.getPointDetails(source, panel))) {
            this.nxpair.get(this.getPointDetails(source, panel)).setUniDirection(dest, panel, set);
        }
    }

    public boolean canBeBiDirectional(Object source, LayoutEditor panel, Object dest) {
        if (this.nxpair.containsKey(this.getPointDetails(source, panel))) {
            return this.nxpair.get(this.getPointDetails(source, panel)).canBeBiDirection(dest, panel);
        }
        return false;
    }

    public boolean isEnabled(Object source, LayoutEditor panel, Object dest) {
        if (this.nxpair.containsKey(this.getPointDetails(source, panel))) {
            return this.nxpair.get(this.getPointDetails(source, panel)).isEnabled(dest, panel);
        }
        return false;
    }

    public void setEnabled(Object source, LayoutEditor panel, Object dest, boolean set) {
        if (this.nxpair.containsKey(this.getPointDetails(source, panel))) {
            this.nxpair.get(this.getPointDetails(source, panel)).setEnabled(dest, panel, set);
        }
    }

    public void setEntryExitType(Object source, LayoutEditor panel, Object dest, int set) {
        if (this.nxpair.containsKey(this.getPointDetails(source, panel))) {
            this.nxpair.get(this.getPointDetails(source, panel)).setEntryExitType(dest, panel, set);
        }
    }

    public int getEntryExitType(Object source, LayoutEditor panel, Object dest) {
        if (this.nxpair.containsKey(this.getPointDetails(source, panel))) {
            return this.nxpair.get(this.getPointDetails(source, panel)).getEntryExitType(dest, panel);
        }
        return 0;
    }

    public String getUniqueId(Object source, LayoutEditor panel, Object dest) {
        if (this.nxpair.containsKey(this.getPointDetails(source, panel))) {
            return this.nxpair.get(this.getPointDetails(source, panel)).getUniqueId(dest, panel);
        }
        return null;
    }

    public List<String> getEntryExitList() {
        ArrayList<String> destlist = new ArrayList<String>();
        for (Source e : this.nxpair.values()) {
            destlist.addAll(e.getDestinationUniqueId());
        }
        return destlist;
    }

    public boolean isPathActive(Object sourceObj, Object destObj, LayoutEditor panel) {
        PointDetails pd = this.getPointDetails(sourceObj, panel);
        if (this.nxpair.containsKey(pd)) {
            Source source = this.nxpair.get(pd);
            return source.isRouteActive(this.getPointDetails(destObj, panel));
        }
        return false;
    }

    public void cancelInterlock(Object source, LayoutEditor panel, Object dest) {
        if (this.nxpair.containsKey(this.getPointDetails(source, panel))) {
            this.nxpair.get(this.getPointDetails(source, panel)).cancelInterlock(dest, panel);
        }
    }

    public PointDetails getPointDetails(Object obj, LayoutEditor panel) {
        int i = 0;
        while (i < pointDetails.size()) {
            if (pointDetails.get(i).getRefObject() == obj) {
                return pointDetails.get(i);
            }
            ++i;
        }
        return null;
    }

    PointDetails getPointDetails(LayoutBlock source, List<LayoutBlock> destination, LayoutEditor panel) {
        PointDetails newPoint = new PointDetails(source, destination);
        newPoint.setPanel(panel);
        int i = 0;
        while (i < pointDetails.size()) {
            if (pointDetails.get(i).equals(newPoint)) {
                return pointDetails.get(i);
            }
            ++i;
        }
        pointDetails.add(newPoint);
        return newPoint;
    }

    public String getPointAsString(NamedBean obj, LayoutEditor panel) {
        if (obj == null) {
            return "null";
        }
        PointDetails valid = this.getPointDetails(obj, panel);
        if (valid != null) {
            return valid.getDisplayName();
        }
        return "empty";
    }

    public synchronized void stackNXRoute(DestinationPoints dp, boolean reverse) {
        if (this.isRouteStacked(dp, reverse)) {
            return;
        }
        this.stackList.add(new StackDetails(dp, reverse));
        this.checkTimer.start();
        if (this.stackPanel == null) {
            this.stackPanel = new StackNXPanel();
        }
        if (this.stackDialog == null) {
            this.stackDialog = new JDialog();
            this.stackDialog.setTitle(Bundle.getMessage("WindowTitleStackRoutes"));
            this.stackDialog.add(this.stackPanel);
        }
        this.stackPanel.updateGUI();
        this.stackDialog.pack();
        this.stackDialog.setModal(false);
        this.stackDialog.setVisible(true);
    }

    public List<DestinationPoints> getStackedInterlocks() {
        ArrayList<DestinationPoints> dpList = new ArrayList<DestinationPoints>();
        for (StackDetails st : this.stackList) {
            dpList.add(st.getDestinationPoint());
        }
        return dpList;
    }

    public boolean isRouteStacked(DestinationPoints dp, boolean reverse) {
        for (StackDetails st : this.stackList) {
            if (st.getDestinationPoint() != dp || st.getReverse() != reverse) continue;
            return true;
        }
        return false;
    }

    public synchronized void cancelStackedRoute(DestinationPoints dp, boolean reverse) {
        Iterator<StackDetails> iter = this.stackList.iterator();
        while (iter.hasNext()) {
            StackDetails st = iter.next();
            if (st.getDestinationPoint() != dp || st.getReverse() != reverse) continue;
            iter.remove();
        }
        this.stackPanel.updateGUI();
        if (this.stackList.isEmpty()) {
            this.stackDialog.setVisible(false);
            this.checkTimer.stop();
        }
    }

    synchronized void checkRoute() {
        this.checkTimer.stop();
        StackDetails[] tmp = new StackDetails[this.stackList.size()];
        this.stackList.toArray(tmp);
        StackDetails[] stackDetailsArray = tmp;
        int n = tmp.length;
        int n2 = 0;
        while (n2 < n) {
            StackDetails st = stackDetailsArray[n2];
            if (!st.getDestinationPoint().isActive()) {
                st.getDestinationPoint().setInterlockRoute(st.getReverse());
            }
            ++n2;
        }
        if (!this.stackList.isEmpty()) {
            this.checkTimer.start();
        } else {
            this.stackDialog.setVisible(false);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener list, NamedBean obj, LayoutEditor panel) {
        if (obj == null) {
            return;
        }
        PointDetails valid = this.getPointDetails(obj, panel);
        if (valid != null) {
            valid.removePropertyChangeListener(list);
        }
    }

    public void automaticallyDiscoverEntryExitPairs(LayoutEditor editor, int interlockType) throws JmriException {
        this.runWhenStabilised = false;
        LayoutBlockManager lbm = InstanceManager.getDefault(LayoutBlockManager.class);
        if (!lbm.isAdvancedRoutingEnabled()) {
            throw new JmriException("advanced routing not enabled");
        }
        if (!lbm.routingStablised()) {
            this.runWhenStabilised = true;
            this.toUseWhenStable = editor;
            this.interlockTypeToUseWhenStable = interlockType;
            log.debug("Layout block routing has not yet stabilised, discovery will happen once it has");
            return;
        }
        HashMap<NamedBean, List<NamedBean>> validPaths = lbm.getLayoutBlockConnectivityTools().discoverValidBeanPairs(null, Sensor.class, LayoutBlockConnectivityTools.Routing.SENSORTOSENSOR);
        EntryExitPairs eep = this;
        for (Map.Entry<NamedBean, List<NamedBean>> entry : validPaths.entrySet()) {
            NamedBean key = entry.getKey();
            List<NamedBean> validDestMast = validPaths.get(key);
            if (validDestMast.size() <= 0) continue;
            eep.addNXSourcePoint(key, editor);
            int i = 0;
            while (i < validDestMast.size()) {
                if (!eep.isDestinationValid(key, validDestMast.get(i), editor)) {
                    eep.addNXDestination(key, validDestMast.get(i), editor);
                    eep.setEntryExitType(key, editor, validDestMast.get(i), interlockType);
                }
                ++i;
            }
        }
        this.firePropertyChange("autoGenerateComplete", null, null);
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    @Override
    public void deleteBean(@Nonnull DestinationPoints bean, @Nonnull String property) throws PropertyVetoException {
    }

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameTransits" : "BeanNameTransit");
    }

    @Override
    public Class<DestinationPoints> getNamedBeanClass() {
        return DestinationPoints.class;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void setPropertyChangesSilenced(@Nonnull String propertyName, boolean silenced) {
        if (!"beans".equals(propertyName)) {
            throw new IllegalArgumentException("Property " + propertyName + " cannot be silenced.");
        }
        this.silencedProperties.put(propertyName, silenced);
        if (propertyName.equals("beans") && !silenced) {
            this.fireIndexedPropertyChange("beans", this.getNamedBeanSet().size(), null, null);
        }
    }

    @Override
    @Deprecated
    public void addDataListener(Manager.ManagerDataListener<DestinationPoints> e) {
        if (e != null) {
            this.listeners.add(e);
        }
    }

    @Override
    @Deprecated
    public void removeDataListener(Manager.ManagerDataListener<DestinationPoints> e) {
        if (e != null) {
            this.listeners.remove(e);
        }
    }

    class DeletePair {
        NamedBean src = null;
        NamedBean dest = null;
        LayoutEditor pnl = null;
        DestinationPoints dp = null;

        DeletePair(NamedBean src, NamedBean dest, LayoutEditor pnl) {
            this.src = src;
            this.dest = dest;
            this.pnl = pnl;
            PointDetails sourcePoint = EntryExitPairs.this.getPointDetails(src, pnl);
            PointDetails destPoint = EntryExitPairs.this.getPointDetails(dest, pnl);
            if (sourcePoint != null && destPoint != null && EntryExitPairs.this.nxpair.containsKey(sourcePoint)) {
                this.dp = EntryExitPairs.this.nxpair.get(sourcePoint).getDestForPoint(destPoint);
            }
        }
    }

    static class SourceToDest {
        Source s = null;
        DestinationPoints dp = null;
        boolean direction = false;
        int ref = -1;

        SourceToDest(Source s, DestinationPoints dp, boolean dir, int ref) {
            this.s = s;
            this.dp = dp;
            this.direction = dir;
            this.ref = ref;
        }
    }

    static class StackDetails {
        DestinationPoints dp;
        boolean reverse;

        StackDetails(DestinationPoints dp, boolean reverse) {
            this.dp = dp;
            this.reverse = reverse;
        }

        boolean getReverse() {
            return this.reverse;
        }

        DestinationPoints getDestinationPoint() {
            return this.dp;
        }
    }
}

