/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.entryexit;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.UIManager;
import jmri.Block;
import jmri.EntryPoint;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.Path;
import jmri.Section;
import jmri.SectionManager;
import jmri.Sensor;
import jmri.SignalHead;
import jmri.SignalMast;
import jmri.SignalMastLogic;
import jmri.SignalMastLogicManager;
import jmri.Turnout;
import jmri.implementation.AbstractNamedBean;
import jmri.jmrit.dispatcher.ActiveTrain;
import jmri.jmrit.dispatcher.DispatcherFrame;
import jmri.jmrit.display.layoutEditor.ConnectivityUtil;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockConnectivityTools;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutSlip;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.entryexit.Bundle;
import jmri.jmrit.entryexit.EntryExitPairs;
import jmri.jmrit.entryexit.PointDetails;
import jmri.jmrit.entryexit.Source;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestinationPoints
extends AbstractNamedBean {
    transient PointDetails point = null;
    Boolean uniDirection = true;
    int entryExitType = 0;
    boolean enabled = true;
    boolean activeEntryExit = false;
    List<LayoutBlock> routeDetails = new ArrayList<LayoutBlock>();
    LayoutBlock destination;
    boolean disposed = false;
    transient EntryExitPairs manager = InstanceManager.getDefault(EntryExitPairs.class);
    transient SignalMastLogic sml;
    static final int NXMESSAGEBOXCLEARTIMEOUT = 30;
    transient Source src = null;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="No auto serialization")
    protected transient PropertyChangeListener propertyBlockListener;
    Object lastSeenActiveBlockObject;
    private JFrame cancelClearFrame;
    private transient Thread threadAutoClearFrame = null;
    JButton jButton_Stack = new JButton(Bundle.getMessage("Stack"));
    private static final Logger log = LoggerFactory.getLogger(DestinationPoints.class);

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameDestination");
    }

    boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean boo) {
        this.enabled = boo;
        Sensor sourceSensor = this.src.getPoint().getSensor();
        if (sourceSensor == null) {
            return;
        }
        SignalMast sourceMast = this.src.getPoint().getSignalMast();
        if (sourceMast == null) {
            return;
        }
        if (this.enabled) {
            sourceMast.setHeld(true);
        } else {
            for (PointDetails pd : this.src.getDestinationPoints()) {
                if (!this.src.getDestForPoint(pd).isEnabled()) continue;
                return;
            }
            sourceMast.setHeld(false);
        }
    }

    protected DestinationPoints(PointDetails point, String id, Source src) {
        super(id != null ? id : "IN:" + UUID.randomUUID().toString());
        this.src = src;
        this.point = point;
        this.setUserName(String.valueOf(src.getPoint().getDisplayName()) + " to " + this.point.getDisplayName());
        this.propertyBlockListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                DestinationPoints.this.blockStateUpdated(e);
            }
        };
    }

    String getUniqueId() {
        return this.getSystemName();
    }

    public PointDetails getDestPoint() {
        return this.point;
    }

    public Source getSource() {
        return this.src;
    }

    boolean getUniDirection() {
        return this.uniDirection;
    }

    void setUniDirection(boolean uni) {
        this.uniDirection = uni;
    }

    NamedBean getSignal() {
        return this.point.getSignal();
    }

    void setRouteTo(boolean set) {
        if (set && this.getEntryExitType() == 2) {
            this.point.setRouteTo(true);
            this.point.setNXButtonState(2);
        } else {
            this.point.setRouteTo(false);
            this.point.setNXButtonState(4);
        }
    }

    void setRouteFrom(boolean set) {
        if (set && this.getEntryExitType() == 2) {
            this.src.pd.setRouteFrom(true);
            this.src.pd.setNXButtonState(2);
        } else {
            this.src.pd.setRouteFrom(false);
            this.src.pd.setNXButtonState(4);
        }
    }

    boolean isRouteToPointSet() {
        return this.point.isRouteToPointSet();
    }

    LayoutBlock getFacing() {
        return this.point.getFacing();
    }

    List<LayoutBlock> getProtecting() {
        return this.point.getProtecting();
    }

    int getEntryExitType() {
        return this.entryExitType;
    }

    void setEntryExitType(int type) {
        this.entryExitType = type;
        if (type != 0 && this.getSignal() != null && this.point.getSignal() != null) {
            this.uniDirection = true;
        }
    }

    protected void blockStateUpdated(PropertyChangeEvent e) {
        Block blk = (Block)e.getSource();
        if (e.getPropertyName().equals("state")) {
            int now;
            if (log.isDebugEnabled()) {
                log.debug("{}  We have a change of state on the block {}", (Object)this.getUserName(), (Object)blk.getDisplayName());
            }
            if ((now = ((Integer)e.getNewValue()).intValue()) == 2) {
                LayoutBlock lBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(blk);
                if (lBlock == null) {
                    log.error("Unable to get layout block from block {}", (Object)blk);
                    return;
                }
                lBlock.setUseExtraColor(false);
                blk.removePropertyChangeListener(this.propertyBlockListener);
                this.removeBlockFromRoute(lBlock);
            } else {
                log.debug("state was {} and did not go through reset", (Object)now);
            }
        }
    }

    synchronized void removeBlockFromRoute(LayoutBlock lBlock) {
        if (this.routeDetails != null) {
            if (this.routeDetails.indexOf(lBlock) == -1) {
                if (this.src.getStart() == lBlock) {
                    log.debug("Start block went active");
                    this.lastSeenActiveBlockObject = this.src.getStart().getBlock().getValue();
                    lBlock.getBlock().removePropertyChangeListener(this.propertyBlockListener);
                    return;
                }
                log.error("Block {} went active but it is not part of our NX path", (Object)lBlock.getDisplayName());
            }
            if (this.routeDetails.indexOf(lBlock) != 0) {
                log.debug("A block has been skipped will set the value of the active block to that of the original one");
                lBlock.getBlock().setValue(this.lastSeenActiveBlockObject);
                if (this.routeDetails.indexOf(lBlock) != -1) {
                    while (this.routeDetails.indexOf(lBlock) != 0) {
                        LayoutBlock tbr = this.routeDetails.get(0);
                        log.debug("Block skipped {} and removed from list", (Object)tbr.getDisplayName());
                        tbr.getBlock().removePropertyChangeListener(this.propertyBlockListener);
                        tbr.setUseExtraColor(false);
                        this.routeDetails.remove(0);
                    }
                }
            }
            if (this.routeDetails.contains(lBlock)) {
                this.routeDetails.remove(lBlock);
                this.setRouteFrom(false);
                this.src.pd.setNXButtonState(4);
                if (this.sml != null && this.getEntryExitType() == 2) {
                    this.sml.getSourceMast().setHeld(true);
                    SignalMast mast = (SignalMast)this.getSignal();
                    if (this.sml.getStoreState(mast) == 4) {
                        this.sml.removeDestination(mast);
                    }
                }
            } else {
                log.error("Block {} that went Occupied was not in the routeDetails list", (Object)lBlock.getDisplayName());
            }
            if (log.isDebugEnabled()) {
                log.debug("Route details contents {}", this.routeDetails);
                int i = 0;
                while (i < this.routeDetails.size()) {
                    log.debug("      {}", (Object)this.routeDetails.get(i).getDisplayName());
                    ++i;
                }
            }
            if (this.routeDetails.size() == 1 && this.routeDetails.contains(this.destination)) {
                this.routeDetails.get(0).getBlock().removePropertyChangeListener(this.propertyBlockListener);
                this.routeDetails.remove(this.destination);
            }
        }
        this.lastSeenActiveBlockObject = lBlock.getBlock().getValue();
        if (this.routeDetails == null || this.routeDetails.size() == 0) {
            this.routeDetails = null;
            this.setRouteTo(false);
            this.setRouteFrom(false);
            this.setActiveEntryExit(false);
            this.lastSeenActiveBlockObject = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRoute(boolean state) {
        if (log.isDebugEnabled()) {
            log.debug("Set route {}", (Object)this.src.getPoint().getDisplayName());
        }
        if (this.disposed) {
            log.error("Set route called even though interlock has been disposed of");
            return;
        }
        if (this.routeDetails == null) {
            NamedBean mast;
            log.error("No route to set or clear down");
            this.setActiveEntryExit(false);
            this.setRouteTo(false);
            this.setRouteFrom(false);
            if (this.getSignal() instanceof SignalMast && this.getEntryExitType() != 2) {
                mast = (SignalMast)this.getSignal();
                mast.setHeld(false);
            }
            mast = this;
            synchronized (mast) {
                this.destination = null;
            }
            return;
        }
        if (!state) {
            switch (this.manager.getClearDownOption()) {
                case 0: {
                    this.cancelClearOptionBox();
                    break;
                }
                case 2: {
                    this.cancelClearInterlock(0);
                    break;
                }
                case 1: {
                    this.cancelClearInterlock(1);
                    break;
                }
                case 3: {
                    this.cancelClearInterlock(4);
                    break;
                }
                default: {
                    this.cancelClearOptionBox();
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Exit {}", (Object)this.src.getPoint().getDisplayName());
            }
            return;
        }
        if (this.manager.isRouteStacked(this, false)) {
            this.manager.cancelStackedRoute(this, false);
        }
        final ArrayList<Color> realColorStd = new ArrayList<Color>();
        final ArrayList<Color> realColorXtra = new ArrayList<Color>();
        final ArrayList<LayoutBlock> routeBlocks = new ArrayList<LayoutBlock>();
        if (this.manager.useDifferentColorWhenSetting()) {
            boolean first = true;
            for (LayoutBlock lbk : this.routeDetails) {
                if (first) {
                    first = false;
                    continue;
                }
                routeBlocks.add(lbk);
                realColorXtra.add(lbk.getBlockExtraColor());
                realColorStd.add(lbk.getBlockTrackColor());
                lbk.setBlockExtraColor(this.manager.getSettingRouteColor());
                lbk.setBlockTrackColor(this.manager.getSettingRouteColor());
            }
            this.src.getPoint().getPanel().redrawPanel();
        }
        ActiveTrain tmpat = null;
        if (this.manager.getDispatcherIntegration() && InstanceManager.getNullableDefault(DispatcherFrame.class) != null) {
            DispatcherFrame df = InstanceManager.getDefault(DispatcherFrame.class);
            for (ActiveTrain atl : df.getActiveTrainsList()) {
                if (atl.getEndBlock() != this.src.getStart().getBlock() || atl.getLastAllocatedSection() != atl.getEndBlockSection()) continue;
                if (!atl.getReverseAtEnd() && !atl.getResetWhenDone()) {
                    tmpat = atl;
                    break;
                }
                log.warn("Interlock will not be added to existing Active Train as it is set for back and forth operation");
            }
        }
        final ActiveTrain at = tmpat;
        Runnable setRouteRun = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Could not resolve type clashes
             * Unable to fully structure code
             */
            @Override
            public void run() {
                block47: {
                    block48: {
                        DestinationPoints.this.src.getPoint().getPanel().getGlassPane().setVisible(true);
                        try {
                            turnoutSettings = new Hashtable<Turnout, Integer>();
                            connection = new ConnectivityUtil(DestinationPoints.this.point.getPanel());
                            i = 0;
                            while (i < DestinationPoints.this.routeDetails.size()) {
                                if (at == null && DestinationPoints.access$0(DestinationPoints.this) && i > 0) {
                                    nxtBlk = i + 1;
                                    preBlk = i - 1;
                                    if (i < DestinationPoints.this.routeDetails.size() - 1) {
                                        turnoutlist = connection.getTurnoutList(DestinationPoints.this.routeDetails.get(i).getBlock(), DestinationPoints.this.routeDetails.get(preBlk).getBlock(), DestinationPoints.this.routeDetails.get(nxtBlk).getBlock());
                                        x = 0;
                                        while (x < turnoutlist.size()) {
                                            if (turnoutlist.get(x).getObject() instanceof LayoutSlip) {
                                                slipState = turnoutlist.get(x).getExpectedState();
                                                ls = (LayoutSlip)turnoutlist.get(x).getObject();
                                                taState = ls.getTurnoutState(slipState);
                                                t = ls.getTurnout();
                                                if (t == null) {
                                                    DestinationPoints.access$1().warn("Found unexpected Turnout reference at {}: {}", (Object)i, (Object)ls);
                                                } else {
                                                    turnoutSettings.put(t, taState);
                                                    tbState = ls.getTurnoutBState(slipState);
                                                    ls.getTurnoutB().setCommandedState(tbState);
                                                    turnoutSettings.put(ls.getTurnoutB(), tbState);
                                                }
                                            } else {
                                                t = ((LayoutTurnout)turnoutlist.get(x).getObject()).getTurnoutName();
                                                turnout = InstanceManager.turnoutManagerInstance().getTurnout(t);
                                                if (turnout != null) {
                                                    turnoutSettings.put(turnout, turnoutlist.get(x).getExpectedState());
                                                    if (((LayoutTurnout)turnoutlist.get(x).getObject()).getSecondTurnout() != null) {
                                                        turnoutSettings.put(((LayoutTurnout)turnoutlist.get(x).getObject()).getSecondTurnout(), turnoutlist.get(x).getExpectedState());
                                                    }
                                                }
                                            }
                                            ++x;
                                        }
                                    }
                                }
                                if (DestinationPoints.this.getEntryExitType() == 2) {
                                    DestinationPoints.this.routeDetails.get(i).getBlock().addPropertyChangeListener(DestinationPoints.this.propertyBlockListener);
                                    if (i > 0) {
                                        DestinationPoints.this.routeDetails.get(i).setUseExtraColor(true);
                                    }
                                } else {
                                    DestinationPoints.this.routeDetails.get(i).getBlock().removePropertyChangeListener(DestinationPoints.this.propertyBlockListener);
                                }
                                ++i;
                            }
                            if (at == null) {
                                if (!DestinationPoints.access$0(DestinationPoints.this)) {
                                    tmSml = InstanceManager.getDefault(SignalMastLogicManager.class).getSignalMastLogic((SignalMast)DestinationPoints.this.src.sourceSignal);
                                    for (Object t : tmSml.getAutoTurnouts((SignalMast)DestinationPoints.this.getSignal())) {
                                        turnoutSettings.put((Turnout)t, tmSml.getAutoTurnoutState((Turnout)t, (SignalMast)DestinationPoints.this.getSignal()));
                                    }
                                }
                                for (Map.Entry<K, V> entry : turnoutSettings.entrySet()) {
                                    ((Turnout)entry.getKey()).setCommandedState((Integer)entry.getValue());
                                    r = new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                Thread.sleep(250 + (this).DestinationPoints.this.manager.turnoutSetDelay);
                                            }
                                            catch (InterruptedException interruptedException) {
                                                Thread.currentThread().interrupt();
                                            }
                                        }
                                    };
                                    thr = ThreadingUtil.newThread(r, "Entry Exit Route: Turnout Setting");
                                    thr.start();
                                    try {
                                        thr.join();
                                    }
                                    catch (InterruptedException v0) {}
                                }
                            }
                            DestinationPoints.this.src.getPoint().getPanel().redrawPanel();
                            if (DestinationPoints.this.getEntryExitType() != 0) {
                                if (DestinationPoints.this.getEntryExitType() == 2 && DestinationPoints.this.src.getStart().getState() == 2) {
                                    DestinationPoints.this.src.getStart().removePropertyChangeListener(DestinationPoints.this.propertyBlockListener);
                                    DestinationPoints.this.lastSeenActiveBlockObject = DestinationPoints.this.src.getStart().getBlock().getValue();
                                    DestinationPoints.access$1().debug("Last seen value {}", DestinationPoints.this.lastSeenActiveBlockObject);
                                }
                                if (DestinationPoints.this.src.sourceSignal instanceof SignalMast && DestinationPoints.this.getSignal() instanceof SignalMast) {
                                    smSource = (SignalMast)DestinationPoints.this.src.sourceSignal;
                                    smDest = (SignalMast)DestinationPoints.this.getSignal();
                                    r = this;
                                    synchronized (r) {
                                        DestinationPoints.this.sml = InstanceManager.getDefault(SignalMastLogicManager.class).newSignalMastLogic(smSource);
                                        if (!DestinationPoints.this.sml.isDestinationValid(smDest)) {
                                            DestinationPoints.this.sml.setDestinationMast(smDest);
                                            DestinationPoints.this.sml.setStore(4, smDest);
                                        }
                                    }
                                    DestinationPoints.this.routeDetails.remove(0);
                                    r = this;
                                    synchronized (r) {
                                        DestinationPoints.access$2(DestinationPoints.this, smSource, turnoutSettings);
                                        if (DestinationPoints.this.sml.getStoreState(smDest) == 4) {
                                            blks = new LinkedHashMap<Block, Integer>();
                                            i = 0;
                                            while (i < DestinationPoints.this.routeDetails.size()) {
                                                if (DestinationPoints.this.routeDetails.get(i).getBlock().getState() == 1) {
                                                    DestinationPoints.this.routeDetails.get(i).getBlock().setState(4);
                                                }
                                                blks.put(DestinationPoints.this.routeDetails.get(i).getBlock(), 4);
                                                ++i;
                                            }
                                            DestinationPoints.this.sml.setAutoBlocks(blks, smDest);
                                            DestinationPoints.this.sml.setAutoTurnouts(turnoutSettings, smDest);
                                            DestinationPoints.this.sml.initialise(smDest);
                                        }
                                    }
                                    smSource.addPropertyChangeListener(new PropertyChangeListener(){

                                        @Override
                                        public void propertyChange(PropertyChangeEvent e) {
                                            SignalMast source = (SignalMast)e.getSource();
                                            source.removePropertyChangeListener(this);
                                            DestinationPoints.this.setRouteFrom(true);
                                            DestinationPoints.this.setRouteTo(true);
                                        }
                                    });
                                    DestinationPoints.this.src.pd.extendedtime = true;
                                    DestinationPoints.this.point.extendedtime = true;
                                } else {
                                    if (DestinationPoints.this.src.sourceSignal instanceof SignalMast) {
                                        mast = (SignalMast)DestinationPoints.this.src.sourceSignal;
                                        DestinationPoints.access$2(DestinationPoints.this, mast, turnoutSettings);
                                    } else if (DestinationPoints.this.src.sourceSignal instanceof SignalHead) {
                                        head = (SignalHead)DestinationPoints.this.src.sourceSignal;
                                        head.setHeld(false);
                                    }
                                    DestinationPoints.this.setRouteFrom(true);
                                    DestinationPoints.this.setRouteTo(true);
                                }
                            }
                            if (DestinationPoints.this.manager.useDifferentColorWhenSetting()) {
                                resetColorBack = new Timer(DestinationPoints.this.manager.getSettingTimer(), new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        int i = 0;
                                        while (i < routeBlocks.size()) {
                                            LayoutBlock lbk = (LayoutBlock)routeBlocks.get(i);
                                            lbk.setBlockExtraColor((Color)realColorXtra.get(i));
                                            lbk.setBlockTrackColor((Color)realColorStd.get(i));
                                            ++i;
                                        }
                                        (this).DestinationPoints.this.src.getPoint().getPanel().redrawPanel();
                                    }
                                });
                                resetColorBack.setRepeats(false);
                                resetColorBack.start();
                            }
                            if (at != null) {
                                if (DestinationPoints.this.sml != null && DestinationPoints.this.sml.getAssociatedSection((SignalMast)DestinationPoints.this.getSignal()) != null) {
                                    sec = DestinationPoints.this.sml.getAssociatedSection((SignalMast)DestinationPoints.this.getSignal());
                                } else {
                                    secUserName = String.valueOf(DestinationPoints.this.src.getPoint().getDisplayName()) + ":" + DestinationPoints.this.point.getDisplayName();
                                    sec = InstanceManager.getDefault(SectionManager.class).getSection(secUserName);
                                    if (sec == null) {
                                        sec = InstanceManager.getDefault(SectionManager.class).createNewSection(secUserName);
                                        sec.setSectionType(0);
                                    }
                                    if (sec.getSectionType() == 0) {
                                        sec.removeAllBlocksFromSection();
                                        for (LayoutBlock key : DestinationPoints.this.routeDetails) {
                                            if (key == DestinationPoints.this.src.getStart()) continue;
                                            sec.addBlock(key.getBlock());
                                        }
                                        dir = Path.decodeDirection(DestinationPoints.this.src.getStart().getNeighbourDirection(DestinationPoints.this.routeDetails.get(0).getBlock()));
                                        ep = new EntryPoint(DestinationPoints.this.routeDetails.get(0).getBlock(), DestinationPoints.this.src.getStart().getBlock(), dir);
                                        ep.setTypeForward();
                                        sec.addToForwardList(ep);
                                        proDestLBlock = DestinationPoints.this.point.getProtecting().get(0);
                                        if (proDestLBlock != null) {
                                            dir = Path.decodeDirection(proDestLBlock.getNeighbourDirection(DestinationPoints.this.point.getFacing()));
                                            ep = new EntryPoint(DestinationPoints.this.point.getFacing().getBlock(), proDestLBlock.getBlock(), dir);
                                            ep.setTypeReverse();
                                            sec.addToReverseList(ep);
                                        }
                                    }
                                }
                                InstanceManager.getDefault(DispatcherFrame.class).extendActiveTrainsPath(sec, at, DestinationPoints.this.src.getPoint().getPanel());
                            }
                            DestinationPoints.this.src.pd.setNXButtonState(4);
                            DestinationPoints.this.point.setNXButtonState(4);
                            break block47;
                        }
                        catch (RuntimeException ex) {
                            DestinationPoints.access$1().error("An error occurred while setting the route", (Throwable)ex);
                            DestinationPoints.this.src.pd.setNXButtonState(4);
                            DestinationPoints.this.point.setNXButtonState(4);
                            if (!DestinationPoints.this.manager.useDifferentColorWhenSetting()) break block48;
                            i = 0;
                            ** while (i < routeBlocks.size())
                        }
lbl-1000:
                        // 1 sources

                        {
                            lbk = (LayoutBlock)routeBlocks.get(i);
                            lbk.setBlockExtraColor((Color)realColorXtra.get(i));
                            lbk.setBlockTrackColor((Color)realColorStd.get(i));
                            ++i;
                            continue;
                        }
                    }
                    DestinationPoints.this.src.getPoint().getPanel().redrawPanel();
                }
                DestinationPoints.this.src.getPoint().getPanel().getGlassPane().setVisible(false);
            }
        };
        Thread thrMain = ThreadingUtil.newThread(setRouteRun, "Entry Exit Set Route");
        thrMain.start();
        try {
            thrMain.join();
        }
        catch (InterruptedException e) {
            log.error("Interuption exception {}", (Object)e.toString());
        }
        if (log.isDebugEnabled()) {
            log.debug("finish route {}", (Object)this.src.getPoint().getDisplayName());
        }
    }

    private void releaseMast(final SignalMast mast, Hashtable<Turnout, Integer> turnoutSettings) {
        final Hashtable<Turnout, Integer> turnoutList = new Hashtable<Turnout, Integer>(turnoutSettings);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    int i = 20;
                    while (i > 0) {
                        int active = 0;
                        for (Map.Entry entry : turnoutList.entrySet()) {
                            Turnout tout = (Turnout)entry.getKey();
                            if (tout.getFeedbackMode() != 16 || tout.getKnownState() == tout.getCommandedState()) continue;
                            ++active;
                        }
                        if (active == 0) break;
                        Thread.sleep(500L);
                        --i;
                    }
                    log.debug("Release mast: {}", (Object)mast.getDisplayName());
                    mast.setHeld(false);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        };
        Thread thr = ThreadingUtil.newThread(r, "Entry Exit Route: Release Mast");
        thr.start();
    }

    private boolean isSignalLogicDynamic() {
        if (this.src.sourceSignal instanceof SignalMast && this.getSignal() instanceof SignalMast) {
            SignalMast smSource = (SignalMast)this.src.sourceSignal;
            SignalMast smDest = (SignalMast)this.getSignal();
            if (InstanceManager.getDefault(SignalMastLogicManager.class).getSignalMastLogic(smSource) != null && InstanceManager.getDefault(SignalMastLogicManager.class).getSignalMastLogic(smSource).getStoreState(smDest) != 4) {
                return false;
            }
        }
        return true;
    }

    void cancelClearOptionBox() {
        if (this.cancelClearFrame == null) {
            JButton jButton_Clear = new JButton(Bundle.getMessage("ClearDown"));
            JButton jButton_Cancel = new JButton(Bundle.getMessage("ButtonCancel"));
            JButton jButton_Exit = new JButton(Bundle.getMessage("Exit"));
            JLabel jLabel = new JLabel(Bundle.getMessage("InterlockPrompt"));
            JLabel jIcon = new JLabel(UIManager.getIcon("OptionPane.questionIcon"));
            this.cancelClearFrame = new JFrame(Bundle.getMessage("Interlock"));
            Container cont = this.cancelClearFrame.getContentPane();
            JPanel qPanel = new JPanel();
            qPanel.add(jIcon);
            qPanel.add(jLabel);
            cont.add((Component)qPanel, "Center");
            JPanel buttonsPanel = new JPanel();
            buttonsPanel.add(jButton_Cancel);
            buttonsPanel.add(jButton_Clear);
            buttonsPanel.add(this.jButton_Stack);
            buttonsPanel.add(jButton_Exit);
            cont.add((Component)buttonsPanel, "South");
            this.cancelClearFrame.pack();
            jButton_Clear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DestinationPoints.this.cancelClearFrame.setVisible(false);
                    DestinationPoints.this.threadAutoClearFrame.interrupt();
                    DestinationPoints.this.cancelClearInterlock(1);
                }
            });
            jButton_Cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DestinationPoints.this.cancelClearFrame.setVisible(false);
                    DestinationPoints.this.threadAutoClearFrame.interrupt();
                    DestinationPoints.this.cancelClearInterlock(0);
                }
            });
            this.jButton_Stack.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DestinationPoints.this.cancelClearFrame.setVisible(false);
                    DestinationPoints.this.threadAutoClearFrame.interrupt();
                    DestinationPoints.this.cancelClearInterlock(4);
                }
            });
            jButton_Exit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DestinationPoints.this.cancelClearFrame.setVisible(false);
                    DestinationPoints.this.threadAutoClearFrame.interrupt();
                    DestinationPoints.this.cancelClearInterlock(2);
                    DestinationPoints.this.firePropertyChange("noChange", null, null);
                }
            });
            this.src.getPoint().getPanel().setGlassPane(this.manager.getGlassPane());
        }
        this.cancelClearFrame.setTitle(this.getUserName());
        if (this.manager.isRouteStacked(this, false)) {
            this.jButton_Stack.setEnabled(false);
        } else {
            this.jButton_Stack.setEnabled(true);
        }
        if (this.cancelClearFrame.isVisible()) {
            return;
        }
        this.src.pd.extendedtime = true;
        this.point.extendedtime = true;
        class MessageTimeOut
        implements Runnable {
            MessageTimeOut() {
            }

            @Override
            public void run() {
                try {
                    Thread.sleep(30000L);
                    DestinationPoints.this.cancelClearFrame.setVisible(false);
                    DestinationPoints.this.cancelClearInterlock(2);
                }
                catch (InterruptedException interruptedException) {
                    log.debug("Flash timer cancelled");
                }
            }
        }
        MessageTimeOut mt = new MessageTimeOut();
        this.threadAutoClearFrame = ThreadingUtil.newThread(mt, "NX Button Clear Message Timeout ");
        this.threadAutoClearFrame.start();
        this.cancelClearFrame.setAlwaysOnTop(true);
        this.src.getPoint().getPanel().getGlassPane().setVisible(true);
        int w = this.cancelClearFrame.getSize().width;
        int h = this.cancelClearFrame.getSize().height;
        int x = (int)this.src.getPoint().getPanel().getLocation().getX() + (this.src.getPoint().getPanel().getSize().width - w) / 2;
        int y = (int)this.src.getPoint().getPanel().getLocation().getY() + (this.src.getPoint().getPanel().getSize().height - h) / 2;
        this.cancelClearFrame.setLocation(x, y);
        this.cancelClearFrame.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelClearInterlock(int cancelClear) {
        NamedBean head;
        if (cancelClear == 2 || cancelClear == 4) {
            this.src.pd.setNXButtonState(4);
            this.point.setNXButtonState(4);
            this.src.getPoint().getPanel().getGlassPane().setVisible(false);
            if (cancelClear == 4) {
                this.manager.stackNXRoute(this, false);
            }
            return;
        }
        if (cancelClear == 0 && this.manager.getDispatcherIntegration() && InstanceManager.getNullableDefault(DispatcherFrame.class) != null) {
            DispatcherFrame df = InstanceManager.getDefault(DispatcherFrame.class);
            ActiveTrain at = null;
            for (ActiveTrain atl : df.getActiveTrainsList()) {
                if (atl.getEndBlock() != this.point.getFacing().getBlock() || atl.getLastAllocatedSection() != atl.getEndBlockSection()) continue;
                at = atl;
                break;
            }
            if (at != null) {
                Object sec = null;
                DestinationPoints destinationPoints = this;
                synchronized (destinationPoints) {
                    sec = this.sml != null && this.sml.getAssociatedSection((SignalMast)this.getSignal()) != null ? this.sml.getAssociatedSection((SignalMast)this.getSignal()) : InstanceManager.getDefault(SectionManager.class).getSection(String.valueOf(this.src.getPoint().getDisplayName()) + ":" + this.point.getDisplayName());
                }
                if (sec != null) {
                    if (!df.removeFromActiveTrainPath((Section)sec, at, this.src.getPoint().getPanel())) {
                        log.error("Unable to remove allocation from dispathcer, leave interlock in place");
                        this.src.pd.cancelNXButtonTimeOut();
                        this.point.cancelNXButtonTimeOut();
                        this.src.getPoint().getPanel().getGlassPane().setVisible(false);
                        return;
                    }
                    if (((Section)sec).getSectionType() == 0) {
                        ((Section)sec).removeAllBlocksFromSection();
                    }
                }
            }
        }
        this.src.setMenuEnabled(false);
        if (this.src.sourceSignal instanceof SignalMast) {
            SignalMast mast = (SignalMast)this.src.sourceSignal;
            mast.setAspect(mast.getAppearanceMap().getSpecificAppearance(2));
            mast.setHeld(true);
        } else if (this.src.sourceSignal instanceof SignalHead) {
            head = (SignalHead)this.src.sourceSignal;
            head.setHeld(true);
        } else {
            log.debug("No signal found");
        }
        head = this;
        synchronized (head) {
            SignalMast mast;
            if (this.getSignal() instanceof SignalMast && this.sml != null && this.sml.getStoreState(mast = (SignalMast)this.getSignal()) == 4) {
                this.sml.removeDestination(mast);
            }
            this.sml = null;
        }
        if (this.routeDetails == null) {
            return;
        }
        boolean facing = this.getSource().getSourceSignal() == null;
        for (LayoutBlock blk : this.routeDetails) {
            if (facing) {
                facing = false;
                continue;
            }
            if (this.getEntryExitType() == 2) {
                blk.setUseExtraColor(false);
            }
            blk.getBlock().removePropertyChangeListener(this.propertyBlockListener);
        }
        if (cancelClear == 1) {
            if (this.routeDetails.size() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("{}  all blocks have automatically been cleared down", (Object)this.getUserName());
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("{}  No blocks were cleared down {}", (Object)this.getUserName(), (Object)this.routeDetails.size());
                }
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("{}  set first block as active so that we can manually clear this down {}", (Object)this.getUserName(), (Object)this.routeDetails.get(0).getBlock().getUserName());
                    }
                    if (this.routeDetails.get(0).getOccupancySensor() != null) {
                        this.routeDetails.get(0).getOccupancySensor().setState(2);
                    } else {
                        this.routeDetails.get(0).getBlock().goingActive();
                    }
                    if (this.src.getStart().getOccupancySensor() != null) {
                        this.src.getStart().getOccupancySensor().setState(4);
                    } else {
                        this.src.getStart().getBlock().goingInactive();
                    }
                }
                catch (NullPointerException e) {
                    log.error("error in clear route A {}", (Throwable)e);
                }
                catch (JmriException e) {
                    log.error("error in clear route A {}", (Throwable)e);
                }
                if (log.isDebugEnabled()) {
                    log.debug("{}  Going to clear routeDetails down {}", (Object)this.getUserName(), (Object)this.routeDetails.size());
                    int i = 0;
                    while (i < this.routeDetails.size()) {
                        log.debug("Block at {} {}", (Object)i, (Object)this.routeDetails.get(i).getDisplayName());
                        ++i;
                    }
                }
                if (this.routeDetails.size() > 1) {
                    int i = 1;
                    while (i < this.routeDetails.size() - 1) {
                        if (log.isDebugEnabled()) {
                            log.debug("{} in loop Set active {} {}", new Object[]{this.getUserName(), this.routeDetails.get(i).getDisplayName(), this.routeDetails.get(i).getBlock().getSystemName()});
                        }
                        try {
                            if (this.routeDetails.get(i).getOccupancySensor() != null) {
                                this.routeDetails.get(i).getOccupancySensor().setState(2);
                            } else {
                                this.routeDetails.get(i).getBlock().goingActive();
                            }
                            if (log.isDebugEnabled()) {
                                log.debug("{} in loop Set inactive {} {}", new Object[]{this.getUserName(), this.routeDetails.get(i - 1).getDisplayName(), this.routeDetails.get(i - 1).getBlock().getSystemName()});
                            }
                            if (this.routeDetails.get(i - 1).getOccupancySensor() != null) {
                                this.routeDetails.get(i - 1).getOccupancySensor().setState(4);
                            } else {
                                this.routeDetails.get(i - 1).getBlock().goingInactive();
                            }
                        }
                        catch (NullPointerException | JmriException e) {
                            log.error("error in clear route b ", (Throwable)e);
                        }
                        ++i;
                    }
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug("{} out of loop Set active {} {}", new Object[]{this.getUserName(), this.routeDetails.get(this.routeDetails.size() - 1).getDisplayName(), this.routeDetails.get(this.routeDetails.size() - 1).getBlock().getSystemName()});
                        }
                        if (this.routeDetails.get(this.routeDetails.size() - 1).getOccupancySensor() != null) {
                            this.routeDetails.get(this.routeDetails.size() - 1).getOccupancySensor().setState(2);
                        } else {
                            this.routeDetails.get(this.routeDetails.size() - 1).getBlock().goingActive();
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("{} out of loop Set inactive {} {}", new Object[]{this.getUserName(), this.routeDetails.get(this.routeDetails.size() - 2).getUserName(), this.routeDetails.get(this.routeDetails.size() - 2).getBlock().getSystemName()});
                        }
                        if (this.routeDetails.get(this.routeDetails.size() - 2).getOccupancySensor() != null) {
                            this.routeDetails.get(this.routeDetails.size() - 2).getOccupancySensor().setState(4);
                        } else {
                            this.routeDetails.get(this.routeDetails.size() - 2).getBlock().goingInactive();
                        }
                    }
                    catch (NullPointerException e) {
                        log.error("error in clear route c {}", (Throwable)e);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        log.error("error in clear route c {}", (Throwable)e);
                    }
                    catch (JmriException e) {
                        log.error("error in clear route c {}", (Throwable)e);
                    }
                }
            }
        }
        this.setActiveEntryExit(false);
        this.setRouteFrom(false);
        this.setRouteTo(false);
        this.routeDetails = null;
        DestinationPoints destinationPoints = this;
        synchronized (destinationPoints) {
            this.lastSeenActiveBlockObject = null;
        }
        this.src.pd.cancelNXButtonTimeOut();
        this.point.cancelNXButtonTimeOut();
        this.src.getPoint().getPanel().getGlassPane().setVisible(false);
    }

    public void setInterlockRoute(boolean reverseDirection) {
        if (this.activeEntryExit) {
            return;
        }
        this.activeBean(reverseDirection, false);
    }

    void activeBean(boolean reverseDirection) {
        this.activeBean(reverseDirection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void activeBean(boolean reverseDirection, boolean showMessage) {
        MemoryManager mgr = InstanceManager.getDefault(MemoryManager.class);
        Memory nxMem = mgr.getMemory(this.manager.getMemoryOption());
        if (nxMem != null) {
            nxMem.setValue("");
        }
        if (!this.isEnabled()) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("RouteDisabled", this.getDisplayName()));
            this.src.pd.setNXButtonState(4);
            this.point.setNXButtonState(4);
            return;
        }
        if (this.activeEntryExit) {
            if (!this.isEnabled()) {
                log.debug("A disabled entry exit has been called will bomb out");
                return;
            }
            log.debug("{}  We have a valid match on our end point so we can clear down", (Object)this.getUserName());
            this.setRoute(false);
        } else {
            LayoutBlock destinationLBlock;
            LayoutBlock protectLBlock;
            if (this.isRouteToPointSet()) {
                log.debug("{}  route to this point is set therefore can not set another to it ", (Object)this.getUserName());
                if (showMessage && !this.manager.isRouteStacked(this, false)) {
                    this.handleNoCurrentRoute(reverseDirection, "Route already set to the destination point");
                }
                this.src.pd.setNXButtonState(4);
                this.point.setNXButtonState(4);
                return;
            }
            LayoutBlock startlBlock = this.src.getStart();
            class BestPath {
                LayoutBlock srcProtecting = null;
                LayoutBlock srcStart = null;
                LayoutBlock destination = null;
                List<LayoutBlock> listOfBlocks = new ArrayList<LayoutBlock>(0);
                String errorMessage = "";

                BestPath(LayoutBlock startPro, LayoutBlock sourceProtecting, LayoutBlock destinationBlock, List<LayoutBlock> blocks) {
                    this.srcStart = startPro;
                    this.srcProtecting = sourceProtecting;
                    this.destination = destinationBlock;
                    this.listOfBlocks = blocks;
                }

                LayoutBlock getStartBlock() {
                    return this.srcStart;
                }

                LayoutBlock getProtectingBlock() {
                    return this.srcProtecting;
                }

                LayoutBlock getDestinationBlock() {
                    return this.destination;
                }

                List<LayoutBlock> getListOfBlocks() {
                    return this.listOfBlocks;
                }

                void setErrorMessage(String msg) {
                    this.errorMessage = msg;
                }

                String getErrorMessage() {
                    return this.errorMessage;
                }
            }
            ArrayList<BestPath> pathList = new ArrayList<BestPath>(2);
            Iterator<LayoutBlock> iterator = this.src.getSourceProtecting().iterator();
            while (iterator.hasNext()) {
                LayoutBlock srcProLBlock;
                protectLBlock = srcProLBlock = iterator.next();
                if (!reverseDirection) {
                    destinationLBlock = this.getFacing();
                    ArrayList<LayoutBlock> blocks = new ArrayList();
                    String errorMessage = null;
                    try {
                        blocks = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlockConnectivityTools().getLayoutBlocks(startlBlock, destinationLBlock, protectLBlock, false, LayoutBlockConnectivityTools.Routing.MASTTOMAST);
                    }
                    catch (Exception e) {
                        errorMessage = e.getMessage();
                    }
                    BestPath toadd = new BestPath(startlBlock, protectLBlock, destinationLBlock, blocks);
                    toadd.setErrorMessage(errorMessage);
                    pathList.add(toadd);
                    continue;
                }
                startlBlock = srcProLBlock;
                protectLBlock = this.getFacing();
                destinationLBlock = this.src.getStart();
                if (log.isDebugEnabled()) {
                    log.debug("reverse set destination is set going for {} {} {}", new Object[]{startlBlock.getDisplayName(), destinationLBlock.getDisplayName(), protectLBlock.getDisplayName()});
                }
                try {
                    BestPath toadd;
                    LayoutBlock srcPro = this.src.getSourceProtecting().get(0);
                    if (!InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlockConnectivityTools().checkValidDest(startlBlock, protectLBlock, srcPro, this.src.getStart(), LayoutBlockConnectivityTools.Routing.SENSORTOSENSOR)) {
                        startlBlock = this.getFacing();
                        protectLBlock = srcProLBlock;
                        if (log.isDebugEnabled()) {
                            log.debug("That didn't work so try  {} {} {}", new Object[]{startlBlock.getDisplayName(), destinationLBlock.getDisplayName(), protectLBlock.getDisplayName()});
                        }
                        if (!InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlockConnectivityTools().checkValidDest(startlBlock, protectLBlock, srcPro, this.src.getStart(), LayoutBlockConnectivityTools.Routing.SENSORTOSENSOR)) {
                            log.error("No route found");
                            JOptionPane.showMessageDialog(null, "No Valid path found");
                            this.src.pd.setNXButtonState(4);
                            this.point.setNXButtonState(4);
                            return;
                        }
                        ArrayList<LayoutBlock> blocks = new ArrayList();
                        String errorMessage = null;
                        try {
                            blocks = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlockConnectivityTools().getLayoutBlocks(startlBlock, destinationLBlock, protectLBlock, false, LayoutBlockConnectivityTools.Routing.MASTTOMAST);
                        }
                        catch (Exception e) {
                            errorMessage = e.getMessage();
                        }
                        toadd = new BestPath(startlBlock, protectLBlock, destinationLBlock, blocks);
                        toadd.setErrorMessage(errorMessage);
                        pathList.add(toadd);
                        continue;
                    }
                    if (InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlockConnectivityTools().checkValidDest(this.getFacing(), srcProLBlock, srcPro, this.src.getStart(), LayoutBlockConnectivityTools.Routing.SENSORTOSENSOR)) {
                        int distance2;
                        int distance = startlBlock.getBlockHopCount(destinationLBlock.getBlock(), protectLBlock.getBlock());
                        if (distance > (distance2 = this.getFacing().getBlockHopCount(destinationLBlock.getBlock(), srcProLBlock.getBlock()))) {
                            startlBlock = this.getFacing();
                            protectLBlock = srcProLBlock;
                        }
                        ArrayList<LayoutBlock> blocks = new ArrayList();
                        String errorMessage = "";
                        try {
                            blocks = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlockConnectivityTools().getLayoutBlocks(startlBlock, destinationLBlock, protectLBlock, false, LayoutBlockConnectivityTools.Routing.NONE);
                        }
                        catch (Exception e) {
                            errorMessage = e.getMessage();
                        }
                        BestPath toadd2 = new BestPath(startlBlock, protectLBlock, destinationLBlock, blocks);
                        toadd2.setErrorMessage(errorMessage);
                        pathList.add(toadd2);
                        continue;
                    }
                    ArrayList<LayoutBlock> blocks = new ArrayList();
                    String errorMessage = "";
                    try {
                        blocks = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlockConnectivityTools().getLayoutBlocks(startlBlock, destinationLBlock, protectLBlock, false, LayoutBlockConnectivityTools.Routing.NONE);
                    }
                    catch (Exception e) {
                        errorMessage = e.getMessage();
                    }
                    toadd = new BestPath(startlBlock, protectLBlock, destinationLBlock, blocks);
                    toadd.setErrorMessage(errorMessage);
                    pathList.add(toadd);
                }
                catch (JmriException ex) {
                    log.error("Exception {}", (Object)ex.getMessage());
                    if (showMessage) {
                        JOptionPane.showMessageDialog(null, ex.getMessage());
                    }
                    this.src.pd.setNXButtonState(4);
                    this.point.setNXButtonState(4);
                    return;
                }
            }
            if (pathList.isEmpty()) {
                log.debug("Path list empty so exiting");
                return;
            }
            BestPath pathToUse = null;
            if (pathList.size() == 1) {
                if (!((BestPath)pathList.get(0)).getListOfBlocks().isEmpty()) {
                    pathToUse = (BestPath)pathList.get(0);
                }
            } else {
                int noOfBlocks = 0;
                for (BestPath bp : pathList) {
                    if (bp.getListOfBlocks().isEmpty() || noOfBlocks != 0 && bp.getListOfBlocks().size() >= noOfBlocks) continue;
                    noOfBlocks = bp.getListOfBlocks().size();
                    pathToUse = bp;
                }
            }
            if (pathToUse == null) {
                if (((BestPath)pathList.get(0)).getListOfBlocks().isEmpty()) {
                    if (showMessage) {
                        this.handleNoCurrentRoute(reverseDirection, ((BestPath)pathList.get(0)).getErrorMessage());
                        this.src.pd.setNXButtonState(4);
                        this.point.setNXButtonState(4);
                    }
                    return;
                }
                pathToUse = (BestPath)pathList.get(0);
            }
            startlBlock = pathToUse.getStartBlock();
            protectLBlock = pathToUse.getProtectingBlock();
            destinationLBlock = pathToUse.getDestinationBlock();
            this.routeDetails = pathToUse.getListOfBlocks();
            if (log.isDebugEnabled()) {
                log.debug("Path chosen start = {}, dest = {}, protect = {}", new Object[]{startlBlock.getDisplayName(), destinationLBlock.getDisplayName(), protectLBlock.getDisplayName()});
            }
            DestinationPoints noOfBlocks = this;
            synchronized (noOfBlocks) {
                this.destination = destinationLBlock;
            }
            if (log.isDebugEnabled()) {
                log.debug("Route details:");
                for (LayoutBlock blk : this.routeDetails) {
                    log.debug("  {}", (Object)blk.getDisplayName());
                }
            }
            if (this.getEntryExitType() == 2) {
                this.setActiveEntryExit(true);
            }
            this.setRoute(true);
        }
    }

    void handleNoCurrentRoute(boolean reverse, String message) {
        int opt = this.manager.getOverlapOption();
        if (opt == 0) {
            Object[] options = new Object[]{Bundle.getMessage("ButtonYes"), Bundle.getMessage("ButtonNo")};
            int ans = JOptionPane.showOptionDialog(null, String.valueOf(message) + "\n" + Bundle.getMessage("StackRouteAsk"), Bundle.getMessage("RouteNotClear"), 1, 3, null, options, options[1]);
            opt = ans == 0 ? 2 : 1;
        }
        if (opt == 2) {
            this.manager.stackNXRoute(this, reverse);
            this.firePropertyChange("stacked", null, null);
        } else {
            this.firePropertyChange("failed", null, null);
        }
        MemoryManager mgr = InstanceManager.getDefault(MemoryManager.class);
        final Memory nxMem = mgr.getMemory(this.manager.getMemoryOption());
        if (nxMem != null) {
            String optString = opt == 2 ? Bundle.getMessage("StackRoute") : Bundle.getMessage("CancelRoute");
            nxMem.setValue(Bundle.getMessage("MemoryMessage", message, optString));
            int delay = this.manager.getMemoryClearDelay() * 1000;
            if (delay > 0) {
                Timer memoryClear = new Timer(delay, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        nxMem.setValue("");
                    }
                });
                memoryClear.setRepeats(false);
                memoryClear.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.enabled = false;
        this.setActiveEntryExit(false);
        this.cancelClearInterlock(0);
        this.setRouteFrom(false);
        this.setRouteTo(false);
        this.point.removeDestination(this);
        DestinationPoints destinationPoints = this;
        synchronized (destinationPoints) {
            this.lastSeenActiveBlockObject = null;
        }
        this.disposed = true;
        super.dispose();
    }

    @Override
    public int getState() {
        if (this.activeEntryExit) {
            return 2;
        }
        return 4;
    }

    public boolean isActive() {
        return this.activeEntryExit;
    }

    @Override
    public void setState(int state) {
    }

    protected void setActiveEntryExit(boolean boo) {
        int oldvalue = this.getState();
        this.activeEntryExit = boo;
        this.src.setMenuEnabled(boo);
        this.firePropertyChange("active", oldvalue, this.getState());
    }

    @Override
    public List<NamedBeanUsageReport> getUsageReport(NamedBean bean) {
        ArrayList<NamedBeanUsageReport> report = new ArrayList<NamedBeanUsageReport>();
        if (bean != null) {
            if (bean.equals(this.getSource().getPoint().getSensor())) {
                report.add(new NamedBeanUsageReport("EntryExitSourceSensor"));
            }
            if (bean.equals(this.getSource().getPoint().getSignal())) {
                report.add(new NamedBeanUsageReport("EntryExitSourceSignal"));
            }
            if (bean.equals(this.getDestPoint().getSensor())) {
                report.add(new NamedBeanUsageReport("EntryExitDestinationSensor"));
            }
            if (bean.equals(this.getDestPoint().getSignal())) {
                report.add(new NamedBeanUsageReport("EntryExitDesinationSignal"));
            }
        }
        return report;
    }

    static /* synthetic */ boolean access$0(DestinationPoints destinationPoints) {
        return destinationPoints.isSignalLogicDynamic();
    }

    static /* synthetic */ void access$2(DestinationPoints destinationPoints, SignalMast signalMast, Hashtable hashtable) {
        destinationPoints.releaseMast(signalMast, hashtable);
    }
}

