/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.entryexit;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutSlip;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.LevelXing;
import jmri.jmrit.display.layoutEditor.PositionablePoint;
import jmri.jmrit.entryexit.Bundle;
import jmri.jmrit.entryexit.EntryExitPairs;
import jmri.swing.NamedBeanComboBox;
import jmri.util.JmriJFrame;
import jmri.util.swing.JComboBoxUtil;
import jmri.util.swing.JmriPanel;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddEntryExitPairPanel
extends JmriPanel {
    JComboBox<String> selectPanel = new JComboBox();
    JComboBox<String> fromPoint = new JComboBox();
    JComboBox<String> toPoint = new JComboBox();
    String[] interlockTypes = new String[]{Bundle.getMessage("SetTurnoutsOnly"), Bundle.getMessage("SetTurnoutsAndSignalMasts"), Bundle.getMessage("FullInterlock")};
    JComboBox<String> typeBox = new JComboBox<String>(this.interlockTypes);
    List<LayoutEditor> panels;
    EntryExitPairs nxPairs = InstanceManager.getDefault(EntryExitPairs.class);
    LayoutEditor panel;
    JmriJFrame entryExitFrame = null;
    JLabel sourceLabel = new JLabel();
    List<ValidPoints> validPoints = new ArrayList<ValidPoints>();
    boolean doFromCombo;
    SortedSet<String> fromSet = new TreeSet<String>();
    SortedSet<String> toSet = new TreeSet<String>();
    JTable nxDataTable;
    JScrollPane nxDataScroll;
    TableModel nxModel;
    static final int FROMPOINTCOL = 0;
    static final int TOPOINTCOL = 1;
    static final int ACTIVECOL = 2;
    static final int CLEARCOL = 3;
    static final int BOTHWAYCOL = 4;
    static final int DELETECOL = 5;
    static final int TYPECOL = 6;
    static final int ENABLEDCOL = 7;
    static final int NUMCOL = 8;
    String[] NXTYPE_NAMES = new String[]{Bundle.getMessage("SetTurnoutsOnly"), Bundle.getMessage("SetTurnoutsAndSignalMasts"), Bundle.getMessage("FullInterlock")};
    JmriJFrame optionsFrame = null;
    Container optionsPane = null;
    String[] clearOptions = new String[]{Bundle.getMessage("PromptUser"), Bundle.getMessage("ClearRoute"), Bundle.getMessage("CancelRoute"), Bundle.getMessage("StackRoute")};
    JComboBox<String> clearEntry = new JComboBox<String>(this.clearOptions);
    String[] overlapOptions = new String[]{Bundle.getMessage("PromptUser"), Bundle.getMessage("CancelRoute"), Bundle.getMessage("StackRoute")};
    JComboBox<String> overlapEntry = new JComboBox<String>(this.overlapOptions);
    NamedBeanComboBox<Memory> memoryComboBox = new NamedBeanComboBox(InstanceManager.getDefault(MemoryManager.class));
    JSpinner memoryClearDelay = new JSpinner(new SpinnerNumberModel(0, 0, 99, 1));
    JTextField durationSetting = new JTextField(10);
    String[] colorText = new String[]{"ColorClear", "Black", "DarkGray", "Gray", "LightGray", "White", "Red", "Pink", "Orange", "Yellow", "Green", "Blue", "Magenta", "Cyan"};
    Color[] colorCode;
    int numColors;
    JCheckBox dispatcherUse;
    JComboBox<String> settingTrackColorBox;
    private static final Logger log = LoggerFactory.getLogger(AddEntryExitPairPanel.class);

    public AddEntryExitPairPanel(LayoutEditor panel) {
        Color[] colorArray = new Color[14];
        colorArray[1] = Color.black;
        colorArray[2] = Color.darkGray;
        colorArray[3] = Color.gray;
        colorArray[4] = Color.lightGray;
        colorArray[5] = Color.white;
        colorArray[6] = Color.red;
        colorArray[7] = Color.pink;
        colorArray[8] = Color.orange;
        colorArray[9] = Color.yellow;
        colorArray[10] = Color.green;
        colorArray[11] = Color.blue;
        colorArray[12] = Color.magenta;
        colorArray[13] = Color.cyan;
        this.colorCode = colorArray;
        this.numColors = 14;
        this.dispatcherUse = new JCheckBox(Bundle.getMessage("DispatcherInt"));
        this.settingTrackColorBox = new JComboBox();
        this.setLayout(new BoxLayout(this, 1));
        JPanel top = new JPanel();
        top.setBorder(BorderFactory.createEtchedBorder());
        top.setLayout(new GridLayout(4, 2));
        top.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("SelectPanel")), 4));
        top.add(this.selectPanel);
        this.selectPanel.removeAllItems();
        this.panels = InstanceManager.getDefault(EditorManager.class).getList(LayoutEditor.class);
        int i = 0;
        while (i < this.panels.size()) {
            this.selectPanel.addItem(this.panels.get(i).getLayoutName());
            ++i;
        }
        if (panel != null) {
            this.selectPanel.setSelectedItem(panel.getLayoutName());
        }
        top.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("FromLocation")), 4));
        top.add(this.fromPoint);
        ActionListener selectPanelListener = e -> {
            this.selectPointsFromPanel();
            this.nxModel.setPanel(this.panels.get(this.selectPanel.getSelectedIndex()));
        };
        this.selectPointsFromPanel();
        this.selectPanel.addActionListener(selectPanelListener);
        top.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("ToLocation")), 4));
        top.add(this.toPoint);
        JComboBoxUtil.setupComboBoxMaxRows(this.fromPoint);
        JComboBoxUtil.setupComboBoxMaxRows(this.toPoint);
        top.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("NXType")), 4));
        top.add(this.typeBox);
        this.add(top);
        JPanel p = new JPanel();
        JButton ok = new JButton(Bundle.getMessage("AddPair"));
        p.add(ok);
        ok.addActionListener(e -> this.addButton());
        p.setLayout(new BoxLayout(p, 0));
        JButton auto = new JButton(Bundle.getMessage("AutoGenerate"));
        p.add(auto);
        auto.addActionListener(e -> this.autoDiscovery());
        p.add(auto);
        this.add(p);
        this.nxModel = new TableModel(panel);
        this.nxDataTable = new JTable(this.nxModel);
        this.nxDataTable.setRowSorter(new TableRowSorter<TableModel>(this.nxModel));
        this.nxDataScroll = new JScrollPane(this.nxDataTable);
        this.nxModel.configureTable(this.nxDataTable);
        Dimension dataTableSize = this.nxDataTable.getPreferredSize();
        dataTableSize.height = Math.max(dataTableSize.height, 400);
        this.nxDataScroll.getViewport().setPreferredSize(dataTableSize);
        this.add(this.nxDataScroll);
    }

    private void addButton() {
        ValidPoints from = this.getValidPointFromCombo(this.fromPoint);
        ValidPoints to = this.getValidPointFromCombo(this.toPoint);
        if (from == null || to == null) {
            return;
        }
        this.nxPairs.addNXDestination(from.getPoint(), to.getPoint(), this.panel);
        this.nxPairs.setEntryExitType(from.getPoint(), this.panel, to.getPoint(), this.typeBox.getSelectedIndex());
    }

    private void autoDiscovery() {
        int response;
        if (!InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled() && (response = JOptionPane.showConfirmDialog(null, Bundle.getMessage("EnableLayoutBlockRouting"))) == 0) {
            InstanceManager.getDefault(LayoutBlockManager.class).enableAdvancedRouting(true);
            JOptionPane.showMessageDialog(null, Bundle.getMessage("LayoutBlockRoutingEnabled"));
        }
        this.entryExitFrame = new JmriJFrame(Bundle.getMessage("DiscoverEntryExitPairs"), false, false);
        this.entryExitFrame.setPreferredSize(null);
        JPanel panel1 = new JPanel();
        this.sourceLabel = new JLabel(Bundle.getMessage("DiscoveringEntryExitPairs"));
        panel1.add(this.sourceLabel);
        this.entryExitFrame.add(panel1);
        this.entryExitFrame.pack();
        this.entryExitFrame.setVisible(true);
        int retval = JOptionPane.showOptionDialog(null, Bundle.getMessage("AutoGenEntryExitMessage"), Bundle.getMessage("AutoGenEntryExitTitle"), 0, 3, null, null, null);
        if (retval == 0) {
            PropertyChangeListener propertyNXListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("autoGenerateComplete")) {
                        if (AddEntryExitPairPanel.this.entryExitFrame != null) {
                            AddEntryExitPairPanel.this.entryExitFrame.setVisible(false);
                            AddEntryExitPairPanel.this.entryExitFrame.dispose();
                        }
                        AddEntryExitPairPanel.this.nxPairs.removePropertyChangeListener(this);
                        JOptionPane.showMessageDialog(null, Bundle.getMessage("AutoGenComplete"));
                    }
                }
            };
            try {
                this.nxPairs.addPropertyChangeListener(propertyNXListener);
                this.nxPairs.automaticallyDiscoverEntryExitPairs(this.panels.get(this.selectPanel.getSelectedIndex()), this.typeBox.getSelectedIndex());
            }
            catch (JmriException e) {
                this.nxPairs.removePropertyChangeListener(propertyNXListener);
                JOptionPane.showMessageDialog(null, e.toString());
                this.entryExitFrame.setVisible(false);
            }
        } else {
            this.entryExitFrame.setVisible(false);
        }
    }

    ValidPoints getValidPointFromCombo(JComboBox<String> box) {
        String item = (String)box.getSelectedItem();
        int i = 0;
        while (i < this.validPoints.size()) {
            if (this.validPoints.get(i).getDescription().equals(item)) {
                return this.validPoints.get(i);
            }
            ++i;
        }
        return null;
    }

    private void selectPointsFromPanel() {
        if (this.selectPanel.getSelectedIndex() == -1) {
            return;
        }
        if (this.panel == this.panels.get(this.selectPanel.getSelectedIndex())) {
            return;
        }
        this.panel = this.panels.get(this.selectPanel.getSelectedIndex());
        this.fromSet.clear();
        this.toSet.clear();
        this.doFromCombo = true;
        this.selectPoints(this.panel);
        this.doFromCombo = false;
        this.panels = InstanceManager.getDefault(EditorManager.class).getList(LayoutEditor.class);
        int i = 0;
        while (i < this.panels.size()) {
            if (this.panels.get(i) != this.panel) {
                this.selectPoints(this.panels.get(i));
            }
            ++i;
        }
        this.fromPoint.removeAllItems();
        this.fromSet.forEach(ent -> this.fromPoint.addItem((String)ent));
        this.toPoint.removeAllItems();
        this.toSet.forEach(ent -> this.toPoint.addItem((String)ent));
    }

    private void selectPoints(LayoutEditor panel) {
        for (PositionablePoint pp : panel.getPositionablePoints()) {
            this.addPointToCombo(pp.getWestBoundSignalMastName(), pp.getWestBoundSensorName());
            this.addPointToCombo(pp.getEastBoundSignalMastName(), pp.getEastBoundSensorName());
        }
        for (LayoutTurnout t : panel.getLayoutTurnouts()) {
            this.addPointToCombo(t.getSignalAMastName(), t.getSensorAName());
            this.addPointToCombo(t.getSignalBMastName(), t.getSensorBName());
            this.addPointToCombo(t.getSignalCMastName(), t.getSensorCName());
            this.addPointToCombo(t.getSignalDMastName(), t.getSensorDName());
        }
        for (LevelXing xing : panel.getLevelXings()) {
            this.addPointToCombo(xing.getSignalAMastName(), xing.getSensorAName());
            this.addPointToCombo(xing.getSignalBMastName(), xing.getSensorBName());
            this.addPointToCombo(xing.getSignalCMastName(), xing.getSensorCName());
            this.addPointToCombo(xing.getSignalDMastName(), xing.getSensorDName());
        }
        for (LayoutSlip slip : panel.getLayoutSlips()) {
            this.addPointToCombo(slip.getSignalAMastName(), slip.getSensorAName());
            this.addPointToCombo(slip.getSignalBMastName(), slip.getSensorBName());
            this.addPointToCombo(slip.getSignalCMastName(), slip.getSensorCName());
            this.addPointToCombo(slip.getSignalDMastName(), slip.getSensorDName());
        }
    }

    void addPointToCombo(String signalMastName, String sensorName) {
        if (sensorName != null && !sensorName.isEmpty()) {
            String description = sensorName;
            Sensor source = InstanceManager.sensorManagerInstance().getSensor(sensorName);
            if (signalMastName != null && !signalMastName.isEmpty()) {
                description = String.valueOf(sensorName) + " (" + signalMastName + ")";
            }
            this.validPoints.add(new ValidPoints(source, description));
            if (this.doFromCombo) {
                this.fromSet.add(description);
            }
            this.toSet.add(description);
        }
    }

    protected void configDeleteColumn(JTable table) {
        this.setColumnToHoldButton(table, 5, new JButton(Bundle.getMessage("ButtonDelete")));
        this.setColumnToHoldButton(table, 3, new JButton(Bundle.getMessage("ButtonClear")));
        JComboBox<String> typeCombo = new JComboBox<String>(this.NXTYPE_NAMES);
        TableColumn col = table.getColumnModel().getColumn(6);
        col.setCellEditor(new DefaultCellEditor(typeCombo));
    }

    protected void setColumnToHoldButton(JTable table, int column, JButton sample) {
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        table.setDefaultRenderer(JButton.class, buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        table.setDefaultEditor(JButton.class, buttonEditor);
        table.setRowHeight(sample.getPreferredSize().height);
        table.getColumnModel().getColumn(column).setPreferredWidth(sample.getPreferredSize().width + 4);
    }

    private void initializeColorCombo(JComboBox<String> colorCombo) {
        colorCombo.removeAllItems();
        int i = 0;
        while (i < this.numColors) {
            colorCombo.addItem(Bundle.getMessage(this.colorText[i]));
            ++i;
        }
    }

    private void setColorCombo(JComboBox<String> colorCombo, Color color) {
        int i = 0;
        while (i < this.numColors) {
            if (color == this.colorCode[i]) {
                colorCombo.setSelectedIndex(i);
                return;
            }
            ++i;
        }
    }

    private Color getSelectedColor(JComboBox<String> colorCombo) {
        return this.colorCode[colorCombo.getSelectedIndex()];
    }

    protected void optionWindow(ActionEvent e) {
        if (this.optionsFrame == null) {
            this.optionsFrame = new JmriJFrame(Bundle.getMessage("OptionsTitle"), false, true);
            this.optionsPane = this.optionsFrame.getContentPane();
            this.optionsPane.setLayout(new BoxLayout(this.optionsFrame.getContentPane(), 1));
            this.clearEntry.setSelectedIndex(this.nxPairs.getClearDownOption());
            JPanel p1 = new JPanel();
            this.clearEntry.setToolTipText(Bundle.getMessage("ReselectionTip"));
            p1.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("Reselection"))));
            p1.add(this.clearEntry);
            this.optionsPane.add(p1);
            this.overlapEntry.setSelectedIndex(this.nxPairs.getOverlapOption());
            JPanel p1a = new JPanel();
            this.overlapEntry.setToolTipText(Bundle.getMessage("OverlapSelectedTip"));
            p1a.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("OverlapSelected"))));
            p1a.add(this.overlapEntry);
            this.optionsPane.add(p1a);
            LayoutEditor.setupComboBox(this.memoryComboBox, false, true, false);
            this.memoryComboBox.setSelectedItemByName(this.nxPairs.getMemoryOption());
            JPanel p1b = new JPanel();
            this.memoryComboBox.setToolTipText(Bundle.getMessage("MemoryOptionTip"));
            p1b.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("MemoryOption"))));
            p1b.add(this.memoryComboBox);
            this.optionsPane.add(p1b);
            this.memoryClearDelay.setValue(this.nxPairs.getMemoryClearDelay());
            JPanel p1c = new JPanel();
            this.memoryClearDelay.setToolTipText(Bundle.getMessage("MemoryClearTip"));
            p1c.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("MemoryClear"))));
            p1c.add(this.memoryClearDelay);
            this.optionsPane.add(p1c);
            JPanel p2 = new JPanel();
            this.initializeColorCombo(this.settingTrackColorBox);
            this.setColorCombo(this.settingTrackColorBox, this.nxPairs.getSettingRouteColor());
            ActionListener settingTrackColorListener = e1 -> {
                if (this.getSelectedColor(this.settingTrackColorBox) != null) {
                    this.durationSetting.setEnabled(true);
                } else {
                    this.durationSetting.setEnabled(false);
                }
            };
            this.settingTrackColorBox.addActionListener(settingTrackColorListener);
            p2.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("RouteSetColour"))));
            p2.add(this.settingTrackColorBox);
            this.optionsPane.add(p2);
            this.durationSetting.setText("" + this.nxPairs.getSettingTimer());
            if (this.nxPairs.useDifferentColorWhenSetting()) {
                this.durationSetting.setEnabled(true);
            } else {
                this.durationSetting.setEnabled(false);
            }
            JPanel p3 = new JPanel();
            p3.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("SettingDuration"))));
            p3.add(this.durationSetting);
            this.optionsPane.add(p3);
            JPanel p4 = new JPanel();
            p4.add(this.dispatcherUse);
            this.dispatcherUse.setSelected(this.nxPairs.getDispatcherIntegration());
            this.optionsPane.add(p4);
            JButton ok = new JButton(Bundle.getMessage("ButtonOK"));
            this.optionsPane.add(ok);
            ok.addActionListener(e1 -> this.optionSaveButton());
        }
        this.optionsFrame.pack();
        this.optionsFrame.setVisible(true);
    }

    void optionSaveButton() {
        int settingTimer = 2000;
        try {
            settingTimer = Integer.parseInt(this.durationSetting.getText());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("ValueBeNumber"));
            return;
        }
        this.nxPairs.setSettingTimer(settingTimer);
        this.nxPairs.setSettingRouteColor(this.getSelectedColor(this.settingTrackColorBox));
        this.nxPairs.setClearDownOption(this.clearEntry.getSelectedIndex());
        this.nxPairs.setOverlapOption(this.overlapEntry.getSelectedIndex());
        this.nxPairs.setMemoryClearDelay((Integer)this.memoryClearDelay.getValue());
        this.nxPairs.setDispatcherIntegration(this.dispatcherUse.isSelected());
        String memoryName = this.memoryComboBox.getSelectedItemDisplayName();
        this.nxPairs.setMemoryOption(memoryName == null ? "" : memoryName);
        this.optionsFrame.setVisible(false);
    }

    class TableModel
    extends AbstractTableModel
    implements PropertyChangeListener {
        LayoutEditor panel;
        List<Object> source = null;
        List<Object> dest = null;
        int rowCount = 0;

        TableModel(LayoutEditor panel) {
            this.setPanel(panel);
            AddEntryExitPairPanel.this.nxPairs.addPropertyChangeListener(this);
            this.source = AddEntryExitPairPanel.this.nxPairs.getNxSource(panel);
            this.dest = AddEntryExitPairPanel.this.nxPairs.getNxDestination();
        }

        void setPanel(LayoutEditor panel) {
            if (this.panel == panel) {
                return;
            }
            this.panel = panel;
            this.rowCount = AddEntryExitPairPanel.this.nxPairs.getNxPairNumbers(panel);
            this.updateNameList();
            this.fireTableDataChanged();
        }

        void updateNameList() {
            this.source = AddEntryExitPairPanel.this.nxPairs.getNxSource(this.panel);
            this.dest = AddEntryExitPairPanel.this.nxPairs.getNxDestination();
        }

        @Override
        public int getRowCount() {
            return this.rowCount;
        }

        public void configureTable(JTable table) {
            table.getTableHeader().setReorderingAllowed(true);
            table.setAutoResizeMode(0);
            int i = 0;
            while (i < table.getColumnCount()) {
                int width = this.getPreferredWidth(i);
                table.getColumnModel().getColumn(i).setPreferredWidth(width);
                ++i;
            }
            table.sizeColumnsToFit(-1);
            AddEntryExitPairPanel.this.configDeleteColumn(table);
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.panel == null) {
                log.debug("no panel selected!");
                return Bundle.getMessage("ErrorTitle");
            }
            switch (col) {
                case 0: {
                    return AddEntryExitPairPanel.this.nxPairs.getPointAsString((NamedBean)this.source.get(row), this.panel);
                }
                case 1: {
                    return AddEntryExitPairPanel.this.nxPairs.getPointAsString((NamedBean)this.dest.get(row), this.panel);
                }
                case 2: {
                    return this.isPairActive(row);
                }
                case 4: {
                    return !AddEntryExitPairPanel.this.nxPairs.isUniDirection(this.source.get(row), this.panel, this.dest.get(row));
                }
                case 7: {
                    return !AddEntryExitPairPanel.this.nxPairs.isEnabled(this.source.get(row), this.panel, this.dest.get(row));
                }
                case 3: {
                    return Bundle.getMessage("ButtonClear");
                }
                case 5: {
                    return Bundle.getMessage("ButtonDelete");
                }
                case 6: {
                    return AddEntryExitPairPanel.this.NXTYPE_NAMES[AddEntryExitPairPanel.this.nxPairs.getEntryExitType(this.source.get(row), this.panel, this.dest.get(row))];
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            boolean b;
            if (col == 5) {
                this.deleteEntryExit(row, col);
            }
            if (col == 3) {
                AddEntryExitPairPanel.this.nxPairs.cancelInterlock(this.source.get(row), this.panel, this.dest.get(row));
            }
            if (col == 4) {
                b = (Boolean)value == false;
                AddEntryExitPairPanel.this.nxPairs.setUniDirection(this.source.get(row), this.panel, this.dest.get(row), b);
            }
            if (col == 7) {
                b = (Boolean)value == false;
                AddEntryExitPairPanel.this.nxPairs.setEnabled(this.source.get(row), this.panel, this.dest.get(row), b);
            }
            if (col == 6) {
                String val = (String)value;
                if (val.equals(Bundle.getMessage("SetTurnoutsOnly"))) {
                    AddEntryExitPairPanel.this.nxPairs.setEntryExitType(this.source.get(row), this.panel, this.dest.get(row), 0);
                } else if (val.equals(Bundle.getMessage("SetTurnoutsAndSignalMasts"))) {
                    AddEntryExitPairPanel.this.nxPairs.setEntryExitType(this.source.get(row), this.panel, this.dest.get(row), 1);
                } else if (val.equals(Bundle.getMessage("FullInterlock"))) {
                    AddEntryExitPairPanel.this.nxPairs.setEntryExitType(this.source.get(row), this.panel, this.dest.get(row), 2);
                }
            }
        }

        public int getPreferredWidth(int col) {
            switch (col) {
                case 0: 
                case 1: {
                    return new JTextField((int)15).getPreferredSize().width;
                }
                case 2: 
                case 4: 
                case 7: {
                    return new JTextField((int)5).getPreferredSize().width;
                }
                case 3: 
                case 5: {
                    return new JTextField((int)22).getPreferredSize().width;
                }
                case 6: {
                    return new JTextField((int)10).getPreferredSize().width;
                }
            }
            log.warn("Unexpected column in getPreferredWidth: {}", (Object)col);
            return new JTextField((int)8).getPreferredSize().width;
        }

        protected void deleteEntryExit(int row, int col) {
            NamedBean nbSource = (NamedBean)this.source.get(row);
            NamedBean nbDest = (NamedBean)this.dest.get(row);
            AddEntryExitPairPanel.this.nxPairs.deleteNxPair(nbSource, nbDest, this.panel);
        }

        String isPairActive(int row) {
            if (AddEntryExitPairPanel.this.nxPairs.isPathActive(this.source.get(row), this.dest.get(row), this.panel)) {
                return Bundle.getMessage("ButtonYes");
            }
            return "";
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Bundle.getMessage("ColumnFrom");
                }
                case 1: {
                    return Bundle.getMessage("ColumnTo");
                }
                case 2: {
                    return Bundle.getMessage("SensorStateActive");
                }
                case 5: {
                    return "";
                }
                case 3: {
                    return "";
                }
                case 4: {
                    return Bundle.getMessage("ColumnBoth");
                }
                case 6: {
                    return Bundle.getMessage("NXType");
                }
                case 7: {
                    return Bundle.getMessage("Disabled");
                }
            }
            return "<UNKNOWN>";
        }

        @Override
        public Class<?> getColumnClass(int col) {
            switch (col) {
                case 0: 
                case 1: 
                case 2: {
                    return String.class;
                }
                case 3: 
                case 5: {
                    return JButton.class;
                }
                case 4: 
                case 7: {
                    return Boolean.class;
                }
                case 6: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 4: {
                    PositionablePoint point;
                    Object obj = AddEntryExitPairPanel.this.nxPairs.getEndPointLocation((NamedBean)this.dest.get(row), this.panel);
                    if (obj instanceof PositionablePoint && (point = (PositionablePoint)obj).getType() == PositionablePoint.PointType.END_BUMPER) {
                        JOptionPane.showMessageDialog(null, Bundle.getMessage("EndBumperPoint"));
                        return false;
                    }
                    if (!AddEntryExitPairPanel.this.nxPairs.canBeBiDirectional(this.source.get(row), this.panel, this.dest.get(row))) {
                        JOptionPane.showMessageDialog(null, Bundle.getMessage("BothWayTurnoutOnly"));
                        return false;
                    }
                    return true;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int getColumnCount() {
            return 8;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("length") || e.getPropertyName().equals("active")) {
                this.rowCount = AddEntryExitPairPanel.this.nxPairs.getNxPairNumbers(this.panel);
                this.updateNameList();
                this.fireTableDataChanged();
            }
        }
    }

    static class ValidPoints {
        NamedBean bean;
        String description;

        ValidPoints(NamedBean bean, String description) {
            this.bean = bean;
            this.description = description;
        }

        NamedBean getPoint() {
            return this.bean;
        }

        String getDescription() {
            return this.description;
        }
    }
}

