/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.dualdecoder;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import jmri.ProgListener;
import jmri.Programmer;
import jmri.ProgrammerException;
import jmri.jmrit.dualdecoder.Bundle;
import jmri.jmrit.progsupport.ProgModePane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DualDecoderSelectPane
extends JPanel
implements ProgListener {
    boolean scanning = false;
    int next = 0;
    final int NENTRIES = 8;
    JLabel[] labels = new JLabel[8];
    JRadioButton[] buttons = new JRadioButton[8];
    JLabel status = new JLabel(Bundle.getMessage("ButtonIdle"));
    JToggleButton searchButton = new JToggleButton(Bundle.getMessage("ButtonSearch"));
    ProgModePane modePane = new ProgModePane(1);
    final int SEARCH = 10;
    final int INIT = 20;
    int mode = 10;
    final int IDLE = 0;
    final int WROTECV15 = 1;
    final int READCV16 = 2;
    final int FIRSTCV16 = 11;
    final int FIRSTCV15 = 12;
    final int SECONDCV16 = 13;
    int state = 0;
    private static final Logger log = LoggerFactory.getLogger(DualDecoderSelectPane.class);

    public DualDecoderSelectPane() {
        this.setLayout(new BoxLayout(this, 1));
        ButtonGroup g = new ButtonGroup();
        JPanel pane1 = new JPanel();
        pane1.setLayout(new GridLayout(8, 1));
        int i = 0;
        while (i < 8) {
            JRadioButton b;
            JPanel p = new JPanel();
            String name = Bundle.getMessage("IDnumber", i);
            if (i == 7) {
                name = Bundle.getMessage("Legacy");
            }
            this.labels[i] = new JLabel(name);
            p.add(this.labels[i]);
            this.buttons[i] = b = new JRadioButton();
            b.setActionCommand("" + i);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DualDecoderSelectPane.this.select(e.getActionCommand());
                }
            });
            p.add(b);
            g.add(b);
            pane1.add(p);
            ++i;
        }
        this.add(pane1);
        this.add(new JSeparator(0));
        JPanel pane2 = new JPanel();
        pane2.add(this.searchButton);
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DualDecoderSelectPane.this.search();
            }
        });
        JButton t = new JButton(Bundle.getMessage("ButtonReset"));
        pane2.add(t);
        t.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DualDecoderSelectPane.this.reset();
            }
        });
        this.add(pane2);
        JPanel pane3 = new JPanel();
        t = new JButton(Bundle.getMessage("InitDH163"));
        pane3.add(t);
        t.setToolTipText(Bundle.getMessage("InitDH163Tooltip"));
        t.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DualDecoderSelectPane.this.doInit();
            }
        });
        this.add(pane3);
        this.add(new JSeparator(0));
        JPanel pane4 = new JPanel();
        pane4.add(this.status);
        this.add(pane4);
        this.add(new JSeparator(0));
        this.add(this.modePane);
    }

    public void dispose() {
        this.modePane.dispose();
        this.buttons = null;
        this.labels = null;
        this.status = null;
        this.searchButton = null;
    }

    void reset() {
        int i = 0;
        while (i < 8) {
            this.labels[i].setEnabled(true);
            this.buttons[i].setSelected(false);
            this.buttons[i].setEnabled(true);
            ++i;
        }
    }

    void search() {
        this.mode = 10;
        this.reset();
        this.searchButton.setSelected(true);
        this.scanning = true;
        this.next = 0;
        this.select("0");
    }

    void select(String number) {
        this.mode = 10;
        this.next = Integer.parseInt(number);
        this.state = 1;
        this.writeCV15(this.next);
    }

    void writeCV15(int value) {
        this.writeCV("15", value);
    }

    void writeCV16(int value) {
        this.writeCV("16", value);
    }

    void writeCV(String cv, int value) {
        Programmer p = this.modePane.getProgrammer();
        if (p == null) {
            this.state = 0;
            this.status.setText(Bundle.getMessage("NoProgrammerConnected"));
        } else {
            try {
                this.status.setText(Bundle.getMessage("StateWriting"));
                p.writeCV(cv, value, this);
            }
            catch (ProgrammerException ex) {
                this.state = 0;
                this.status.setText("" + ex);
            }
        }
    }

    void readCV16() {
        Programmer p = this.modePane.getProgrammer();
        if (p == null) {
            this.state = 0;
            this.status.setText(Bundle.getMessage("NoProgrammerConnected"));
        } else {
            try {
                this.status.setText(Bundle.getMessage("StateReading"));
                this.state = 2;
                p.readCV("16", this);
            }
            catch (ProgrammerException ex) {
                this.state = 0;
                this.status.setText("" + ex);
            }
        }
    }

    @Override
    public void programmingOpReply(int value, int retcode) {
        switch (this.mode) {
            case 10: {
                this.searchReply(value, retcode);
                break;
            }
            case 20: {
                this.initReply(value, retcode);
                break;
            }
            default: {
                log.warn("unexpected mode: {}", (Object)this.mode);
            }
        }
    }

    void searchReply(int value, int retcode) {
        switch (this.state) {
            default: {
                log.warn("Unexpected search programming reply: {} {}", (Object)value, (Object)retcode);
                this.state = 0;
                break;
            }
            case 1: {
                this.readCV16();
                break;
            }
            case 2: {
                String result = Bundle.getMessage("ButtonOK");
                if (retcode != 0) {
                    log.debug("Readback error: {} {}", (Object)retcode, (Object)value);
                    this.labels[this.next].setEnabled(false);
                    this.buttons[this.next].setEnabled(false);
                    result = "Could not confirm: " + this.modePane.getProgrammer().decodeErrorCode(retcode);
                } else if (value != this.next) {
                    log.debug("Readback error: {} {}", (Object)retcode, (Object)value);
                    if (this.scanning) {
                        this.labels[this.next].setEnabled(false);
                        this.buttons[this.next].setEnabled(false);
                    }
                    result = Bundle.getMessage("UnexpectedID_Read", value);
                }
                if (this.scanning) {
                    ++this.next;
                    if (this.next >= 8) {
                        this.state = 0;
                        this.next = 0;
                        this.scanning = false;
                        this.status.setText(Bundle.getMessage("StateIdle"));
                        this.searchButton.setSelected(false);
                        break;
                    }
                    this.select("" + this.next);
                    break;
                }
                this.status.setText(result);
            }
        }
    }

    void doInit() {
        this.mode = 20;
        this.state = 11;
        this.writeCV16(1);
    }

    void initReply(int value, int retcode) {
        switch (this.state) {
            default: {
                log.warn("Unexpected init programming reply: {} {}", (Object)value, (Object)retcode);
                this.state = 0;
                break;
            }
            case 11: {
                this.state = 12;
                if (retcode != 0) {
                    log.debug("Readback error: {} {}", (Object)retcode, (Object)value);
                    this.status.setText(Bundle.getMessage("WriteCVFailed", 15, 7));
                    this.state = 0;
                    break;
                }
                this.writeCV15(7);
                break;
            }
            case 12: {
                this.state = 13;
                if (retcode != 0) {
                    log.debug("Readback error: {} {}", (Object)retcode, (Object)value);
                    this.status.setText(Bundle.getMessage("WriteCVFailed", 16, 7));
                    this.state = 0;
                    break;
                }
                this.writeCV16(7);
                break;
            }
            case 13: {
                if (retcode != 0) {
                    log.debug("Readback error: {} {}", (Object)retcode, (Object)value);
                    this.status.setText(Bundle.getMessage("WriteCVFailed", 16, 1));
                    this.state = 0;
                    break;
                }
                this.state = 0;
                this.status.setText(Bundle.getMessage("StateInitialized"));
            }
        }
    }
}

