/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.switchboardEditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import jmri.ConfigureManager;
import jmri.DigitalIO;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Light;
import jmri.LightManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.ProxyManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.SystemConnectionMemo;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.configurexml.StoreXmlUserAction;
import jmri.jmrit.display.CoordinateEdit;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.NewPanelAction;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableJComponent;
import jmri.jmrit.display.switchboardEditor.BeanSwitch;
import jmri.jmrit.display.switchboardEditor.Bundle;
import jmri.jmrix.SystemConnectionMemoManager;
import jmri.swing.ManagerComboBox;
import jmri.util.ColorUtil;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriColorChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchboardEditor
extends Editor {
    protected JMenuBar _menuBar;
    private JMenu _editorMenu;
    protected JMenu _fileMenu;
    protected JMenu _optionMenu;
    private transient boolean panelChanged = false;
    ImageIcon iconPrev = new ImageIcon("resources/icons/misc/gui3/LafLeftArrow_m.gif");
    private final JLabel prev = new JLabel(this.iconPrev);
    ImageIcon iconNext = new ImageIcon("resources/icons/misc/gui3/LafRightArrow_m.gif");
    private final JLabel next = new JLabel(this.iconNext);
    private final int rangeBottom = 1;
    private final int rangeTop = 100000;
    private static final int unconnectedRangeLimit = 400;
    private static final int rangeSizeWarning = 250;
    private static final int initialMax = 24;
    private final JSpinner minSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 99999, 1));
    private final JSpinner maxSpinner = new JSpinner(new SpinnerNumberModel(24, 2, 100000, 1));
    private final JCheckBox hideUnconnected = new JCheckBox(Bundle.getMessage("CheckBoxHideUnconnected"));
    private final JCheckBox autoItemRange = new JCheckBox(Bundle.getMessage("CheckBoxAutoItemRange"));
    private JButton allOffButton;
    private JButton allOnButton;
    private Editor.TargetPane switchboardLayeredPane;
    static final String TURNOUT = Bundle.getMessage("Turnouts");
    static final String SENSOR = Bundle.getMessage("Sensors");
    static final String LIGHT = Bundle.getMessage("Lights");
    private final String[] beanTypeStrings = new String[]{TURNOUT, SENSOR, LIGHT};
    private JComboBox<String> beanTypeList;
    private String _type = TURNOUT;
    private final String[] switchShapeStrings = new String[]{Bundle.getMessage("Buttons"), Bundle.getMessage("Sliders"), Bundle.getMessage("Keys"), Bundle.getMessage("Symbols")};
    private JComboBox<String> shapeList;
    static final int BUTTON = 0;
    static final int SLIDER = 1;
    static final int KEY = 2;
    static final int SYMBOL = 3;
    private final ManagerComboBox<Turnout> turnoutManComboBox = new ManagerComboBox();
    private final ManagerComboBox<Sensor> sensorManComboBox = new ManagerComboBox();
    private final ManagerComboBox<Light> lightManComboBox = new ManagerComboBox();
    protected TurnoutManager turnoutManager = InstanceManager.getDefault(TurnoutManager.class);
    protected SensorManager sensorManager = InstanceManager.getDefault(SensorManager.class);
    protected LightManager lightManager = InstanceManager.getDefault(LightManager.class);
    private SystemConnectionMemo memo;
    private int shape = 0;
    JTextField addressTextField = new JTextField(10);
    private TitledBorder border;
    private final String interact = Bundle.getMessage("SwitchboardInteractHint");
    private final String noInteract = Bundle.getMessage("SwitchboardNoInteractHint");
    private Color defaultTextColor = Color.BLACK;
    private Color defaultActiveColor = Color.RED;
    protected static final Color darkActiveColor = new Color(180, 50, 50);
    private Color defaultInactiveColor = Color.GREEN;
    protected static final Color darkInactiveColor = new Color(40, 150, 30);
    private boolean _hideUnconnected = false;
    private boolean _autoItemRange = true;
    private int rows = 4;
    private final float cellProportion = 1.0f;
    private int _tileSize = 100;
    private int _iconSquare = 75;
    private final JSpinner rowsSpinner = new JSpinner(new SpinnerNumberModel(this.rows, 1, 25, 1));
    private final JButton updateButton = new JButton(Bundle.getMessage("ButtonUpdate"));
    private final JTextArea help2 = new JTextArea(Bundle.getMessage("Help2"));
    private final JTextArea help3 = new JTextArea(Bundle.getMessage("Help3", Bundle.getMessage("CheckBoxHideUnconnected")));
    private transient boolean savedEditMode = true;
    private transient boolean savedControlLayout = true;
    private final int height = 455;
    private final int width = 544;
    private int verticalMargin = 55;
    private final JCheckBoxMenuItem controllingBox = new JCheckBoxMenuItem(Bundle.getMessage("CheckBoxControlling"));
    private final JCheckBoxMenuItem hideUnconnectedBox = new JCheckBoxMenuItem(Bundle.getMessage("CheckBoxHideUnconnected"));
    private final JCheckBoxMenuItem autoItemRangeBox = new JCheckBoxMenuItem(Bundle.getMessage("CheckBoxAutoItemRange"));
    private final JCheckBoxMenuItem showToolTipBox = new JCheckBoxMenuItem(Bundle.getMessage("CheckBoxShowTooltips"));
    private final JCheckBoxMenuItem autoRowsBox = new JCheckBoxMenuItem(Bundle.getMessage("CheckBoxAutoRows"));
    private final JCheckBoxMenuItem showUserNameBox = new JCheckBoxMenuItem(Bundle.getMessage("CheckBoxUserName"));
    private final JRadioButtonMenuItem scrollBoth = new JRadioButtonMenuItem(Bundle.getMessage("ScrollBoth"));
    private final JRadioButtonMenuItem scrollNone = new JRadioButtonMenuItem(Bundle.getMessage("ScrollNone"));
    private final JRadioButtonMenuItem scrollHorizontal = new JRadioButtonMenuItem(Bundle.getMessage("ScrollHorizontal"));
    private final JRadioButtonMenuItem scrollVertical = new JRadioButtonMenuItem(Bundle.getMessage("ScrollVertical"));
    private final JRadioButtonMenuItem sizeSmall = new JRadioButtonMenuItem(Bundle.getMessage("optionSmaller"));
    private final JRadioButtonMenuItem sizeDefault = new JRadioButtonMenuItem(Bundle.getMessage("optionDefault"));
    private final JRadioButtonMenuItem sizeLarge = new JRadioButtonMenuItem(Bundle.getMessage("optionLarger"));
    static final int SIZE_MIN = 50;
    static final int SIZE_INIT = 100;
    static final int SIZE_MAX = 150;
    private final LinkedHashMap<String, BeanSwitch> switchesOnBoard = new LinkedHashMap();
    private volatile boolean ready = true;
    private static final Logger log = LoggerFactory.getLogger(SwitchboardEditor.class);

    public SwitchboardEditor() {
    }

    public SwitchboardEditor(String name) {
        super(name, false, true);
        this.init(name);
    }

    @Override
    protected final void init(String name) {
        Container contentPane = this.getContentPane();
        this.setVisible(false);
        this.setUseGlobalFlag(true);
        super.setDefaultCloseOperation(0);
        super.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                log.debug("switchboardEditor close box selected");
                SwitchboardEditor.this.setAllEditable(false);
                SwitchboardEditor.this.setVisible(false);
            }
        });
        this._menuBar = new JMenuBar();
        this.makeOptionMenu();
        this.makeFileMenu();
        this.setJMenuBar(this._menuBar);
        this.addHelpMenu("package.jmri.jmrit.display.SwitchboardEditor", true);
        if (UIManager.getLookAndFeel() != null) {
            if (UIManager.getLookAndFeel().getName().equals("Metal")) {
                this.verticalMargin = 47;
            } else if (UIManager.getLookAndFeel().getName().equals("Mac OS X")) {
                this.verticalMargin = 25;
            }
        }
        this.switchboardLayeredPane = new Editor.TargetPane();
        this.switchboardLayeredPane.setPreferredSize(new Dimension(544, 455));
        this.border = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.defaultTextColor), "temp", 4, 4, this.getFont(), this.defaultTextColor);
        this.switchboardLayeredPane.setBorder(this.border);
        this.switchboardLayeredPane.addMouseMotionListener(this);
        JPanel beanSetupPane = new JPanel();
        beanSetupPane.setLayout(new FlowLayout(4));
        JLabel beanTypeTitle = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("BeanTypeLabel")));
        beanSetupPane.add(beanTypeTitle);
        this.beanTypeList = new JComboBox<String>(this.beanTypeStrings);
        this.beanTypeList.setSelectedIndex(0);
        this.beanTypeList.addActionListener(event -> {
            String typeChoice = (String)this.beanTypeList.getSelectedItem();
            if (typeChoice != null) {
                this.displayManagerComboBoxes(typeChoice);
            }
            this.updatePressed();
            this.setDirty();
        });
        beanSetupPane.add(this.beanTypeList);
        char beanTypeChar = this.getSwitchType().charAt(0);
        log.debug("beanTypeChar set to [{}]", (Object)Character.valueOf(beanTypeChar));
        JLabel beanManuTitle = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("ConnectionLabel")));
        beanSetupPane.add(beanManuTitle);
        beanSetupPane.add(this.turnoutManComboBox);
        beanSetupPane.add(this.sensorManComboBox);
        beanSetupPane.add(this.lightManComboBox);
        this.turnoutManComboBox.setToolTipText(Bundle.getMessage("ManComboBoxTip", Bundle.getMessage("BeanNameTurnout")));
        this.sensorManComboBox.setToolTipText(Bundle.getMessage("ManComboBoxTip", Bundle.getMessage("BeanNameSensor")));
        this.lightManComboBox.setToolTipText(Bundle.getMessage("ManComboBoxTip", Bundle.getMessage("BeanNameLight")));
        this.configureManagerComboBoxes();
        this.displayManagerComboBoxes(TURNOUT);
        this.add(beanSetupPane);
        JPanel switchShapePane = new JPanel();
        switchShapePane.setLayout(new FlowLayout(4));
        JLabel switchShapeTitle = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("SwitchShape")));
        switchShapePane.add(switchShapeTitle);
        this.shapeList = new JComboBox<String>(this.switchShapeStrings);
        this.shapeList.setSelectedIndex(0);
        this.shapeList.addActionListener(event -> {
            this.shape = Math.max(this.shapeList.getSelectedIndex(), 0);
            this.updatePressed();
            this.setDirty();
        });
        switchShapePane.add(this.shapeList);
        JLabel rowsLabel = new JLabel(Bundle.getMessage("NumberOfRows"));
        switchShapePane.add(rowsLabel);
        this.rowsSpinner.setToolTipText(Bundle.getMessage("RowsSpinnerOnTooltip"));
        this.rowsSpinner.addChangeListener(e -> {
            if (!this.autoRowsBox.isSelected()) {
                this.rows = (Integer)this.rowsSpinner.getValue();
                this.updatePressed();
                this.setDirty();
            }
        });
        switchShapePane.add(this.rowsSpinner);
        this.rowsSpinner.setEnabled(false);
        this.add(switchShapePane);
        JPanel checkboxPane = new JPanel();
        checkboxPane.setLayout(new FlowLayout(4));
        this.autoItemRange.setSelected(this.autoItemRange());
        log.debug("autoItemRangeBox set to {}", (Object)this.autoItemRange.isSelected());
        this.autoItemRange.addActionListener(event -> {
            this.setAutoItemRange(this.autoItemRange.isSelected());
            this.autoItemRangeBox.setSelected(this.autoItemRange());
        });
        checkboxPane.add(this.autoItemRange);
        this.autoItemRange.setToolTipText(Bundle.getMessage("AutoItemRangeTooltip"));
        this.hideUnconnected.setSelected(this._hideUnconnected);
        log.debug("hideUnconnectedBox set to {}", (Object)this.hideUnconnected.isSelected());
        this.hideUnconnected.addActionListener(event -> {
            this.setHideUnconnected(this.hideUnconnected.isSelected());
            this.hideUnconnectedBox.setSelected(this._hideUnconnected);
            this.help2.setVisible(!this._hideUnconnected && !this.switchesOnBoard.isEmpty());
            this.updatePressed();
            this.setDirty();
        });
        checkboxPane.add(this.hideUnconnected);
        this.add(checkboxPane);
        this.switchboardLayeredPane.setLayout(new GridLayout(3, 8));
        super.setTargetPanel(this.switchboardLayeredPane, this.makeFrame(name));
        super.getTargetFrame().setSize(550, 330);
        this.setScroll(0);
        this.scrollNone.setSelected(true);
        this._iconSquare = 100;
        this.sizeDefault.setSelected(true);
        ConfigureManager cm = InstanceManager.getNullableDefault(ConfigureManager.class);
        if (cm != null) {
            cm.registerUser(this);
        }
        this.add(this.createControlPanel());
        this.updateButton.addActionListener(event -> {
            this.updatePressed();
            this.setDirty();
        });
        this.allOnButton = new JButton(Bundle.getMessage("AllOn"));
        this.allOnButton.addActionListener(event -> this.switchAllLights(2));
        this.allOffButton = new JButton(Bundle.getMessage("AllOff"));
        this.allOffButton.addActionListener(event -> this.switchAllLights(4));
        JPanel allPane = new JPanel();
        allPane.setLayout(new BoxLayout(allPane, 3));
        allPane.add(this.allOnButton);
        allPane.add(this.allOffButton);
        JPanel updatePanel = new JPanel();
        updatePanel.add(this.updateButton);
        updatePanel.add(allPane);
        contentPane.setLayout(new BoxLayout(contentPane, 3));
        contentPane.add(updatePanel);
        this.setupEditorPane();
        this.lightManComboBox.addActionListener(event -> {
            Object manager = this.lightManComboBox.getSelectedItem();
            if (manager != null) {
                this.memo = manager.getMemo();
                this.addressTextField.setText("");
                log.debug("Lbox set to {}. Updating", (Object)this.memo.getUserName());
                this.updatePressed();
                this.setDirty();
            }
        });
        this.sensorManComboBox.addActionListener(event -> {
            Object manager = this.sensorManComboBox.getSelectedItem();
            if (manager != null) {
                this.memo = manager.getMemo();
                this.addressTextField.setText("");
                log.debug("Sbox set to {}. Updating", (Object)this.memo.getUserName());
                this.updatePressed();
                this.setDirty();
            }
        });
        this.turnoutManComboBox.addActionListener(event -> {
            Object manager = this.turnoutManComboBox.getSelectedItem();
            if (manager != null) {
                this.memo = manager.getMemo();
                this.addressTextField.setText("");
                log.debug("Tbox set to {}. Updating", (Object)this.memo.getUserName());
                this.updatePressed();
                this.setDirty();
            }
        });
        this.turnoutManComboBox.setSelectedItem("Internal");
        this.lightManComboBox.setSelectedItem("Internal");
        this.sensorManComboBox.setSelectedItem("Internal");
        log.debug("boxes are set to Internal, attaching listeners");
        this.updatePressed();
        super.getTargetFrame().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SwitchboardEditor.this.resizeInFrame();
            }
        });
    }

    private void resizeInFrame() {
        Dimension frSize = super.getTargetFrame().getSize();
        this.switchboardLayeredPane.setSize(new Dimension((int)frSize.getWidth() - 6, (int)frSize.getHeight() - this.verticalMargin));
        this.switchboardLayeredPane.repaint();
        if (this.autoRowsBox.isSelected()) {
            int oldRows = this.rows;
            this.rows = this.autoRows(1.0f);
            if (this.rows != oldRows) {
                this.rowsSpinner.setValue(this.rows);
                this.updatePressed();
            }
        }
    }

    public void updatePressed() {
        log.debug("updatePressed START _tileSize = {}", (Object)this._tileSize);
        if (this._autoItemRange && !this.autoItemRange.isSelected()) {
            this.autoItemRange.setSelected(true);
        }
        this.setVisible(this._editable);
        int range = (Integer)this.maxSpinner.getValue() - (Integer)this.minSpinner.getValue() + 1;
        if (range > 400 && !this._hideUnconnected) {
            range = 400;
            this.maxSpinner.setValue((Integer)this.minSpinner.getValue() + range - 1);
        }
        log.debug("address range = {}", (Object)range);
        if (range > 250) {
            log.debug("Warning for big range");
            int retval = JOptionPane.showOptionDialog(null, Bundle.getMessage("LargeRangeWarning", range, Bundle.getMessage("CheckBoxHideUnconnected")), Bundle.getMessage("WarningTitle"), 0, 1, null, new Object[]{Bundle.getMessage("ButtonYes"), Bundle.getMessage("ButtonCancel")}, null);
            log.debug("Retval: {}", (Object)retval);
            if (retval != 0) {
                return;
            }
        }
        this.ready = false;
        int i = this.switchesOnBoard.size() - 1;
        while (i >= 0) {
            ((BeanSwitch)this.switchboardLayeredPane.getComponent(i)).cleanup();
            this.switchboardLayeredPane.remove(i);
            --i;
        }
        this.switchesOnBoard.clear();
        log.debug("switchesOnBoard cleared, size is now: 0");
        this.switchboardLayeredPane.setSize(544, 455);
        String memoName = this.memo != null ? this.memo.getUserName() : "UNKNOWN";
        log.debug("creating range for manu index {}", (Object)memoName);
        String startAddress = "";
        this.createSwitchRange((Integer)this.minSpinner.getValue(), (Integer)this.maxSpinner.getValue(), this.beanTypeList.getSelectedIndex(), this.shapeList.getSelectedIndex(), startAddress);
        if (this.autoRowsBox.isSelected()) {
            this.rows = this.autoRows(1.0f);
            log.debug("autoRows() called in updatePressed(). Rows = {}", (Object)this.rows);
            this.rowsSpinner.setValue(this.rows);
        }
        this.switchboardLayeredPane.setLayout(new GridLayout(Math.max(this.rows, 1), 1));
        for (BeanSwitch bs : this.switchesOnBoard.values()) {
            this.switchboardLayeredPane.add(bs);
        }
        this.ready = true;
        this.help3.setVisible(this.switchesOnBoard.isEmpty());
        this.help2.setVisible(!this.switchesOnBoard.isEmpty());
        if (this.beanTypeList.getSelectedIndex() >= 0) {
            this.border.setTitle(String.valueOf(memoName) + " " + this.beanTypeList.getSelectedItem() + " - " + (this.allControlling() ? this.interact : this.noInteract));
        }
        this.allOnButton.setVisible(this.beanTypeList.getSelectedIndex() == 2 && this.allControlling());
        this.allOffButton.setVisible(this.beanTypeList.getSelectedIndex() == 2 && this.allControlling());
        this.pack();
        Dimension frSize = super.getTargetFrame().getSize();
        this.switchboardLayeredPane.setSize(new Dimension((int)frSize.getWidth() - 6, (int)frSize.getHeight() - this.verticalMargin));
        this.switchboardLayeredPane.repaint();
        log.debug("updatePressed END _tileSize = {}", (Object)this._tileSize);
    }

    private void createSwitchRange(int min, int max, int beanType, int shapeChoice, @Nonnull String startAddress) {
        log.debug("createSwitchRange - _hideUnconnected = {}", (Object)this._hideUnconnected);
        if (this.memo == null) {
            log.error("createSwitchRange - null memo, can't create range");
            return;
        }
        String prefix = this.memo.getSystemPrefix();
        log.debug("createSwitchRange - _manuprefix={} beanType={}", (Object)prefix, (Object)beanType);
        int i = min;
        while (i <= max) {
            DigitalIO nb;
            String name;
            switch (beanType) {
                case 0: {
                    try {
                        name = ((TurnoutManager)this.memo.get(TurnoutManager.class)).createSystemName(String.valueOf(i), prefix);
                    }
                    catch (JmriException jmriException) {
                        log.error("Error creating range at turnout {}", (Object)i);
                        return;
                    }
                    nb = InstanceManager.getDefault(TurnoutManager.class).getTurnout(name);
                    break;
                }
                case 1: {
                    try {
                        name = ((SensorManager)this.memo.get(SensorManager.class)).createSystemName(String.valueOf(i), prefix);
                    }
                    catch (NullPointerException | JmriException ex) {
                        log.trace("Error creating range at sensor {}. Connection {}", new Object[]{i, this.memo.getUserName(), ex});
                        return;
                    }
                    nb = InstanceManager.getDefault(SensorManager.class).getSensor(name);
                    break;
                }
                case 2: {
                    try {
                        name = ((LightManager)this.memo.get(LightManager.class)).createSystemName(String.valueOf(i), prefix);
                    }
                    catch (JmriException jmriException) {
                        log.error("Error creating range at light {}", (Object)i);
                        return;
                    }
                    nb = InstanceManager.lightManagerInstance().getLight(name);
                    break;
                }
                default: {
                    log.error("addSwitchRange: cannot parse bean name. Prefix = {}; i = {}; type={}", new Object[]{prefix, i, beanType});
                    return;
                }
            }
            if (nb != null || !this._hideUnconnected) {
                log.debug("Creating Switch for {}", (Object)name);
                BeanSwitch _switch = new BeanSwitch(i, nb, name, shapeChoice, this);
                if (nb == null) {
                    _switch.setEnabled(false);
                } else {
                    _switch.displayState(nb.getState());
                }
                this.switchesOnBoard.put(name, _switch);
                log.debug("Added switch {}", (Object)name);
                if (this.switchesOnBoard.size() >= 400) {
                    log.warn("switchboards are limited to {} items", (Object)400);
                    break;
                }
            }
            ++i;
        }
    }

    private JPanel createControlPanel() {
        JPanel controls = new JPanel();
        JPanel navBarPanel = new JPanel();
        navBarPanel.setLayout(new BoxLayout(navBarPanel, 0));
        navBarPanel.add(this.prev);
        this.prev.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int oldMin = SwitchboardEditor.this.getMinSpinner();
                int oldMax = SwitchboardEditor.this.getMaxSpinner();
                int range = Math.max(oldMax - oldMin + 1, 1);
                log.debug("prev range was {}, oldMin ={}, oldMax ={}", new Object[]{range, oldMin, oldMax});
                SwitchboardEditor.this.setMinSpinner(Math.max(oldMin - range, 1));
                if (SwitchboardEditor.this._autoItemRange) {
                    SwitchboardEditor.this.setMaxSpinner(Math.max(oldMax - range, range));
                }
                SwitchboardEditor.this.updatePressed();
                SwitchboardEditor.this.setDirty();
                log.debug("new prev range = {}, newMin ={}, newMax ={}", new Object[]{range, SwitchboardEditor.this.getMinSpinner(), SwitchboardEditor.this.getMaxSpinner()});
            }
        });
        this.prev.setToolTipText(Bundle.getMessage("PreviousToolTip", Bundle.getMessage("CheckBoxAutoItemRange")));
        navBarPanel.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("From"))));
        JComponent minEditor = this.minSpinner.getEditor();
        JFormattedTextField minTf = ((JSpinner.DefaultEditor)minEditor).getTextField();
        minTf.setColumns(5);
        this.minSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            int value = (Integer)spinner.getValue();
            if (value >= (Integer)this.maxSpinner.getValue() - 1) {
                this.maxSpinner.setValue(value + 1);
            }
            this.updatePressed();
            this.setDirty();
        });
        navBarPanel.add(this.minSpinner);
        navBarPanel.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("UpTo"))));
        JComponent maxEditor = this.maxSpinner.getEditor();
        JFormattedTextField maxTf = ((JSpinner.DefaultEditor)maxEditor).getTextField();
        maxTf.setColumns(5);
        this.maxSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            int value = (Integer)spinner.getValue();
            if (value <= (Integer)this.minSpinner.getValue() + 1) {
                this.minSpinner.setValue(value - 1);
            }
            this.updatePressed();
            this.setDirty();
        });
        navBarPanel.add(this.maxSpinner);
        navBarPanel.add(this.next);
        this.next.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int oldMin = SwitchboardEditor.this.getMinSpinner();
                int oldMax = SwitchboardEditor.this.getMaxSpinner();
                int range = Math.max(oldMax - oldMin + 1, 1);
                log.debug("next range was {}, oldMin ={}, oldMax ={}", new Object[]{range, oldMin, oldMax});
                SwitchboardEditor.this.setMaxSpinner(Math.min(oldMax + range, 100000));
                if (SwitchboardEditor.this._autoItemRange) {
                    SwitchboardEditor.this.setMinSpinner(Math.min(oldMin + range, 100000 - range + 1));
                }
                SwitchboardEditor.this.updatePressed();
                SwitchboardEditor.this.setDirty();
                log.debug("new next range = {}, newMin ={}, newMax ={}", new Object[]{range, SwitchboardEditor.this.getMinSpinner(), SwitchboardEditor.this.getMaxSpinner()});
            }
        });
        this.next.setToolTipText(Bundle.getMessage("NextToolTip", Bundle.getMessage("CheckBoxAutoItemRange")));
        navBarPanel.add(Box.createHorizontalGlue());
        controls.add(navBarPanel);
        controls.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SelectRangeTitle")));
        return controls;
    }

    private int getMinSpinner() {
        return (Integer)this.minSpinner.getValue();
    }

    private int getMaxSpinner() {
        return (Integer)this.maxSpinner.getValue();
    }

    protected void setMinSpinner(int value) {
        if (value >= 1 && value < 100000) {
            this.minSpinner.setValue(value);
        }
    }

    protected void setMaxSpinner(int value) {
        if (value > 1 && value <= 100000) {
            this.maxSpinner.setValue(value);
        }
    }

    private void setupEditorPane() {
        Container contentPane = this.getContentPane();
        JPanel innerBorderPanel = new JPanel();
        innerBorderPanel.setLayout(new BoxLayout(innerBorderPanel, 3));
        TitledBorder TitleBorder = BorderFactory.createTitledBorder(Bundle.getMessage("SwitchboardHelpTitle"));
        innerBorderPanel.setBorder(TitleBorder);
        innerBorderPanel.add(new JTextArea(Bundle.getMessage("Help1")));
        innerBorderPanel.add(this.help2);
        if (!this._hideUnconnected) {
            this.help2.setVisible(false);
        }
        this.help3.setForeground(Color.red);
        innerBorderPanel.add(this.help3);
        this.help3.setVisible(false);
        contentPane.add(innerBorderPanel);
    }

    protected void makeOptionMenu() {
        this._optionMenu = new JMenu(Bundle.getMessage("MenuOptions"));
        this._menuBar.add((Component)this._optionMenu, 0);
        this._optionMenu.add(this.controllingBox);
        this.controllingBox.addActionListener(event -> {
            this.setAllControlling(this.controllingBox.isSelected());
            if (this.beanTypeList.getSelectedItem() != null) {
                this.border.setTitle(String.valueOf(this.memo.getUserName()) + " " + this.beanTypeList.getSelectedItem().toString() + " - " + (this.allControlling() ? this.interact : this.noInteract));
            }
            this.allOnButton.setVisible(this.beanTypeList.getSelectedIndex() == 2 && this.allControlling());
            this.allOffButton.setVisible(this.beanTypeList.getSelectedIndex() == 2 && this.allControlling());
            this.switchboardLayeredPane.repaint();
            log.debug("border title updated");
        });
        this.controllingBox.setSelected(this.allControlling());
        this._optionMenu.add(this.autoItemRangeBox);
        this.autoItemRangeBox.addActionListener(event -> {
            this.setAutoItemRange(this.autoItemRangeBox.isSelected());
            this.autoItemRange.setSelected(this.autoItemRange());
        });
        this.autoItemRangeBox.setSelected(this.autoItemRange());
        this._optionMenu.addSeparator();
        this._optionMenu.add(this.autoRowsBox);
        this.autoRowsBox.setSelected(true);
        this.autoRowsBox.addActionListener(event -> {
            if (this.autoRowsBox.isSelected()) {
                log.debug("autoRows was turned ON");
                int oldRows = this.rows;
                this.rows = this.autoRows(1.0f);
                this.rowsSpinner.setEnabled(false);
                this.rowsSpinner.setToolTipText(Bundle.getMessage("RowsSpinnerOffTooltip"));
                if (this.rows != oldRows) {
                    this.updatePressed();
                }
            } else {
                log.debug("autoRows was turned OFF");
                this.rowsSpinner.setValue(this.rows);
                this.rowsSpinner.setEnabled(true);
                this.rowsSpinner.setToolTipText(Bundle.getMessage("RowsSpinnerOnTooltip"));
                int colNum = ((this.getTotal() > 0 ? this.getTotal() : 1) + this.rows - 1) / Math.max(this.rows, 1);
                int maxW = (super.getTargetFrame().getWidth() - 10) / colNum;
                int maxH = (super.getTargetFrame().getHeight() - this.verticalMargin) / Math.max(this.rows, 1);
                this._tileSize = Math.min(maxW, maxH);
            }
        });
        this._optionMenu.add(this.showToolTipBox);
        this.showToolTipBox.addActionListener(e -> this.setAllShowToolTip(this.showToolTipBox.isSelected()));
        this.showToolTipBox.setSelected(this.showToolTip());
        this._optionMenu.add(this.showUserNameBox);
        this.showUserNameBox.addActionListener(e -> this.updatePressed());
        this.showUserNameBox.setSelected(true);
        this._optionMenu.add(this.hideUnconnectedBox);
        this.hideUnconnectedBox.setSelected(this._hideUnconnected);
        this.hideUnconnectedBox.addActionListener(event -> {
            this.setHideUnconnected(this.hideUnconnectedBox.isSelected());
            this.hideUnconnected.setSelected(this._hideUnconnected);
            this.help2.setVisible(!this._hideUnconnected && !this.switchesOnBoard.isEmpty());
            this.updatePressed();
            this.setDirty();
        });
        JMenu scrollMenu = new JMenu(Bundle.getMessage("ComboBoxScrollable"));
        this._optionMenu.add(scrollMenu);
        ButtonGroup scrollGroup = new ButtonGroup();
        scrollGroup.add(this.scrollBoth);
        scrollMenu.add(this.scrollBoth);
        this.scrollBoth.addActionListener(event -> this.setScroll(1));
        scrollGroup.add(this.scrollNone);
        scrollMenu.add(this.scrollNone);
        this.scrollNone.addActionListener(event -> this.setScroll(0));
        scrollGroup.add(this.scrollHorizontal);
        scrollMenu.add(this.scrollHorizontal);
        this.scrollHorizontal.addActionListener(event -> this.setScroll(2));
        scrollGroup.add(this.scrollVertical);
        scrollMenu.add(this.scrollVertical);
        this.scrollVertical.addActionListener(event -> this.setScroll(3));
        JMenu iconSizeMenu = new JMenu(Bundle.getMessage("MenuIconSize"));
        this._optionMenu.add(iconSizeMenu);
        ButtonGroup sizeGroup = new ButtonGroup();
        sizeGroup.add(this.sizeSmall);
        iconSizeMenu.add(this.sizeSmall);
        this.sizeSmall.addActionListener(event -> this.setIconScale(50));
        sizeGroup.add(this.sizeDefault);
        iconSizeMenu.add(this.sizeDefault);
        this.sizeDefault.addActionListener(event -> this.setIconScale(100));
        sizeGroup.add(this.sizeLarge);
        iconSizeMenu.add(this.sizeLarge);
        this.sizeLarge.addActionListener(event -> this.setIconScale(150));
        JMenu colorMenu = new JMenu(Bundle.getMessage("Colors"));
        this._optionMenu.add(colorMenu);
        JMenuItem textColorMenuItem = new JMenuItem(Bundle.getMessage("DefaultTextColor", "..."));
        colorMenu.add(textColorMenuItem);
        textColorMenuItem.addActionListener(event -> {
            Color desiredColor = JmriColorChooser.showDialog(this, Bundle.getMessage("DefaultTextColor", ""), this.defaultTextColor);
            if (desiredColor != null && !this.defaultTextColor.equals(desiredColor)) {
                if (desiredColor.equals(this.defaultBackgroundColor)) {
                    int retval = JOptionPane.showOptionDialog(null, Bundle.getMessage("ColorIdenticalWarningF"), Bundle.getMessage("WarningTitle"), 0, 1, null, new Object[]{Bundle.getMessage("ButtonOK"), Bundle.getMessage("ButtonInvert"), Bundle.getMessage("ButtonCancel")}, null);
                    if (retval == 1) {
                        this.setDefaultBackgroundColor(ColorUtil.contrast(this.defaultBackgroundColor));
                    } else if (retval != 0) {
                        return;
                    }
                }
                this.defaultTextColor = desiredColor;
                this.border.setTitleColor(desiredColor);
                this.setDirty(true);
                JmriColorChooser.addRecentColor(desiredColor);
                this.updatePressed();
            }
        });
        JMenuItem backgroundColorMenuItem = new JMenuItem(Bundle.getMessage("SetBackgroundColor", "..."));
        colorMenu.add(backgroundColorMenuItem);
        backgroundColorMenuItem.addActionListener(event -> {
            Color desiredColor = JmriColorChooser.showDialog(this, Bundle.getMessage("SetBackgroundColor", ""), this.defaultBackgroundColor);
            if (desiredColor != null && !this.defaultBackgroundColor.equals(desiredColor)) {
                if (desiredColor.equals(this.defaultTextColor)) {
                    int retval = JOptionPane.showOptionDialog(null, Bundle.getMessage("ColorIdenticalWarningR"), Bundle.getMessage("WarningTitle"), 0, 1, null, new Object[]{Bundle.getMessage("ButtonOK"), Bundle.getMessage("ButtonInvert"), Bundle.getMessage("ButtonCancel")}, null);
                    if (retval == 1) {
                        this.defaultTextColor = ColorUtil.contrast(this.defaultTextColor);
                        this.border.setTitleColor(this.defaultTextColor);
                    } else if (retval != 0) {
                        return;
                    }
                }
                this.defaultBackgroundColor = desiredColor;
                this.setBackgroundColor(desiredColor);
                this.setDirty(true);
                JmriColorChooser.addRecentColor(desiredColor);
                this.updatePressed();
            }
        });
        JMenuItem activeColorMenuItem = new JMenuItem(Bundle.getMessage("SetActiveColor", "..."));
        colorMenu.add(activeColorMenuItem);
        activeColorMenuItem.addActionListener(event -> {
            Color desiredColor = JmriColorChooser.showDialog(this, Bundle.getMessage("SetActiveColor", ""), this.defaultActiveColor);
            if (desiredColor != null && !this.defaultActiveColor.equals(desiredColor)) {
                if (desiredColor.equals(this.defaultInactiveColor)) {
                    int retval = JOptionPane.showOptionDialog(null, Bundle.getMessage("ColorIdenticalWarningF"), Bundle.getMessage("WarningTitle"), 0, 1, null, new Object[]{Bundle.getMessage("ButtonOK"), Bundle.getMessage("ButtonInvert"), Bundle.getMessage("ButtonCancel")}, null);
                    if (retval == 1) {
                        this.setDefaultInactiveColor(ColorUtil.contrast(this.defaultInactiveColor));
                    } else if (retval != 0) {
                        return;
                    }
                }
                this.defaultActiveColor = desiredColor;
                this.setDirty(true);
                JmriColorChooser.addRecentColor(desiredColor);
                this.updatePressed();
            }
        });
        JMenuItem inactiveColorMenuItem = new JMenuItem(Bundle.getMessage("SetInactiveColor", "..."));
        colorMenu.add(inactiveColorMenuItem);
        inactiveColorMenuItem.addActionListener(event -> {
            Color desiredColor = JmriColorChooser.showDialog(this, Bundle.getMessage("SetInactiveColor", ""), this.defaultInactiveColor);
            if (desiredColor != null && !this.defaultInactiveColor.equals(desiredColor)) {
                if (desiredColor.equals(this.defaultInactiveColor)) {
                    int retval = JOptionPane.showOptionDialog(null, Bundle.getMessage("ColorIdenticalWarningF"), Bundle.getMessage("WarningTitle"), 0, 1, null, new Object[]{Bundle.getMessage("ButtonOK"), Bundle.getMessage("ButtonInvert"), Bundle.getMessage("ButtonCancel")}, null);
                    if (retval == 1) {
                        this.setDefaultActiveColor(ColorUtil.contrast(this.defaultActiveColor));
                    } else if (retval != 0) {
                        return;
                    }
                }
                this.defaultInactiveColor = desiredColor;
                this.setDirty(true);
                JmriColorChooser.addRecentColor(desiredColor);
                this.updatePressed();
            }
        });
    }

    private void makeFileMenu() {
        this._fileMenu = new JMenu(Bundle.getMessage("MenuFile"));
        this._menuBar.add((Component)this._fileMenu, 0);
        this._fileMenu.add(new NewPanelAction(Bundle.getMessage("MenuItemNew")));
        this._fileMenu.add(new StoreXmlUserAction(Bundle.getMessage("FileMenuItemStore")));
        JMenuItem editItem = new JMenuItem(Bundle.getMessage("renamePanelMenu", "..."));
        PositionableJComponent z = new PositionableJComponent(this);
        z.setScale(this.getPaintScale());
        editItem.addActionListener(CoordinateEdit.getNameEditAction(z));
        this._fileMenu.add(editItem);
        this._fileMenu.addSeparator();
        JMenuItem deleteItem = new JMenuItem(Bundle.getMessage("DeletePanel"));
        this._fileMenu.add(deleteItem);
        deleteItem.addActionListener(event -> {
            if (this.deletePanel()) {
                this.getTargetFrame().dispose();
                this.dispose();
            }
        });
        this._fileMenu.addSeparator();
        editItem = new JMenuItem(Bundle.getMessage("CloseEditor"));
        this._fileMenu.add(editItem);
        editItem.addActionListener(event -> {
            log.debug("switchboardeditor edit menu CloseEditor selected");
            this.setAllEditable(false);
            this.setVisible(false);
        });
    }

    public void setDefaultTextColor(Color color) {
        this.defaultTextColor = color;
        this.border.setTitleColor(color);
    }

    @Deprecated
    public void setDefaultTextColor(String color) {
        this.setDefaultTextColor(ColorUtil.stringToColor(color));
    }

    public String getDefaultTextColor() {
        return ColorUtil.colorToColorName(this.defaultTextColor);
    }

    public Color getDefaultTextColorAsColor() {
        return this.defaultTextColor;
    }

    public String getActiveSwitchColor() {
        return ColorUtil.colorToColorName(this.defaultActiveColor);
    }

    public Color getActiveColorAsColor() {
        return this.defaultActiveColor;
    }

    public void setDefaultActiveColor(Color color) {
        this.defaultActiveColor = color;
    }

    public String getInactiveSwitchColor() {
        return ColorUtil.colorToColorName(this.defaultInactiveColor);
    }

    public Color getInactiveColorAsColor() {
        return this.defaultInactiveColor;
    }

    public void setDefaultInactiveColor(Color color) {
        this.defaultInactiveColor = color;
    }

    public void setDefaultBackgroundColor(Color color) {
        this.setBackgroundColor(color);
        this.defaultBackgroundColor = color;
    }

    public Color getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    @Override
    public void setAllEditable(boolean edit) {
        log.debug("_editable set to {} in super", (Object)edit);
        if (edit) {
            if (this._editorMenu != null) {
                this._menuBar.remove(this._editorMenu);
            }
            if (this._optionMenu == null) {
                this.makeOptionMenu();
            } else {
                this._menuBar.add((Component)this._optionMenu, 0);
            }
            if (this._fileMenu == null) {
                this.makeFileMenu();
            } else {
                this._menuBar.add((Component)this._fileMenu, 0);
            }
            log.debug("added File and Options menubar");
        } else {
            if (this._fileMenu != null) {
                this._menuBar.remove(this._fileMenu);
            }
            if (this._optionMenu != null) {
                this._menuBar.remove(this._optionMenu);
            }
            if (this._editorMenu == null) {
                this._editorMenu = new JMenu(Bundle.getMessage("MenuEdit"));
                this._editorMenu.add(new AbstractAction(Bundle.getMessage("OpenEditor")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwitchboardEditor.this.setAllEditable(true);
                        log.debug("Switchboard Editor Open Editor menu called");
                    }
                });
                this._menuBar.add((Component)this._editorMenu, 0);
            }
        }
        super.setAllEditable(edit);
        super.setTitle();
        this._menuBar.revalidate();
    }

    @Override
    public void setUseGlobalFlag(boolean set) {
        this.controllingBox.setEnabled(set);
        super.setUseGlobalFlag(set);
    }

    @Override
    public void setTitle() {
        String name = this.getName();
        log.debug("JFrame name = {}", (Object)name);
        if (name == null || name.length() == 0) {
            name = Bundle.getMessage("SwitchboardDefaultName", "");
        }
        super.setTitle(String.valueOf(name) + " " + Bundle.getMessage("LabelEditor"));
        super.getTargetFrame().setTitle(name);
    }

    public void setHideUnconnected(boolean state) {
        this._hideUnconnected = state;
    }

    public boolean hideUnconnected() {
        return this._hideUnconnected;
    }

    public void setAutoItemRange(boolean state) {
        this._autoItemRange = state;
    }

    public boolean autoItemRange() {
        return this._autoItemRange;
    }

    private int autoRows(float cellProp) {
        int totalDisplayed;
        double paneEffectiveWidth = Math.ceil((float)(super.getTargetFrame().getWidth() - 6) / Math.max(cellProp, 0.1f));
        double paneHeight = super.getTargetFrame().getHeight() - this.verticalMargin;
        int columnsNum = 1;
        int rowsNum = 1;
        float tileSize = 0.1f;
        float tileSizeOld = 0.0f;
        int n = totalDisplayed = this.getTotal() > 0 ? this.getTotal() : 1;
        if (totalDisplayed >= 400) {
            log.warn("switchboards are limited to {} items", (Object)400);
        }
        while (tileSize > tileSizeOld) {
            rowsNum = (totalDisplayed + columnsNum - 1) / Math.max(columnsNum, 1);
            tileSizeOld = tileSize;
            tileSize = (float)Math.min(paneEffectiveWidth / (double)Math.max(columnsNum, 1), paneHeight / (double)Math.max(rowsNum, 1));
            if (tileSize < tileSizeOld) {
                rowsNum = (totalDisplayed + columnsNum - 2) / Math.max(columnsNum - 1, 1);
                break;
            }
            ++columnsNum;
        }
        int rowsNumC = 1;
        float tileSizeC = 0.1f;
        float tileSizeCOld = 0.0f;
        while (tileSizeC > tileSizeCOld) {
            int columnsNumC = (totalDisplayed + rowsNumC - 1) / Math.max(rowsNumC, 1);
            tileSizeCOld = tileSizeC;
            tileSizeC = (float)Math.min(paneEffectiveWidth / (double)Math.max(columnsNumC, 1), paneHeight / (double)Math.max(rowsNumC, 1));
            if (tileSizeC < tileSizeCOld) {
                --rowsNumC;
                break;
            }
            ++rowsNumC;
        }
        if (tileSizeC > tileSize) {
            rowsNum = rowsNumC;
        }
        this._tileSize = Math.round((float)paneHeight / (float)Math.max(rowsNum, 1));
        return rowsNum;
    }

    public void resetDirty() {
        this.setDirty(false);
        this.savedEditMode = this.isEditable();
        this.savedControlLayout = this.allControlling();
    }

    public void setDirty(boolean val) {
        this.panelChanged = val;
    }

    public void setDirty() {
        this.setDirty(true);
    }

    public boolean isDirty() {
        return this.panelChanged;
    }

    public void setPanelMenuRangeMin(int rangemin) {
        this.minSpinner.setValue(rangemin);
    }

    public void setPanelMenuRangeMax(int rangemax) {
        this.maxSpinner.setValue(rangemax);
    }

    public int getPanelMenuRangeMin() {
        return (Integer)this.minSpinner.getValue();
    }

    public int getPanelMenuRangeMax() {
        return (Integer)this.maxSpinner.getValue();
    }

    public String getSwitchType() {
        String switchType = "";
        if (this.beanTypeList.getSelectedItem() != null) {
            switchType = this.beanTypeList.getSelectedItem().toString();
        }
        String typePref = switchType.equals(LIGHT) ? "L" : (switchType.equals(SENSOR) ? "S" : "T");
        return typePref;
    }

    public String getSwitchTypeName() {
        return this._type;
    }

    /*
     * Exception decompiling
     */
    public void setSwitchType(String prefix) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[6] lbl29 : CaseStatement: default:\u000a, @NONE, blocks:[6] lbl29 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getSwitchManu() {
        return this.memo.getSystemPrefix();
    }

    public void setSwitchManu(String manuPrefix) {
        try {
            this.memo = SystemConnectionMemoManager.getDefault().getSystemConnectionMemoForSystemPrefix(manuPrefix);
            if (this.memo.get(TurnoutManager.class) != null) {
                this.turnoutManComboBox.setSelectedItem(this.memo.get(TurnoutManager.class));
                log.debug("turnoutManComboBox set to {} for {}", (Object)this.memo.getUserName(), (Object)manuPrefix);
            }
            if (this.memo.get(SensorManager.class) != null) {
                this.sensorManComboBox.setSelectedItem(this.memo.get(SensorManager.class));
                log.debug("sensorManComboBox set to {} for {}", (Object)this.memo.getUserName(), (Object)manuPrefix);
            }
            if (this.memo.get(LightManager.class) != null) {
                this.lightManComboBox.setSelectedItem(this.memo.get(LightManager.class));
                log.debug("lightManComboBox set to {} for {}", (Object)this.memo.getUserName(), (Object)manuPrefix);
            }
        }
        catch (IllegalArgumentException e) {
            log.error("invalid connection [{}] in Switchboard, {}", (Object)manuPrefix, (Object)e.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            log.error("NPE setting prefix to [{}] in Switchboard", (Object)manuPrefix);
        }
    }

    public String getSwitchShape() {
        String shapeAsString;
        switch (this.shape) {
            case 1: {
                shapeAsString = "icon";
                break;
            }
            case 2: {
                shapeAsString = "drawing";
                break;
            }
            case 3: {
                shapeAsString = "symbol";
                break;
            }
            default: {
                shapeAsString = "button";
            }
        }
        return shapeAsString;
    }

    public void setSwitchShape(String switchShape) {
        switch (switchShape) {
            case "icon": {
                this.shape = 1;
                break;
            }
            case "drawing": {
                this.shape = 2;
                break;
            }
            case "symbol": {
                this.shape = 3;
                break;
            }
            default: {
                this.shape = 0;
            }
        }
        try {
            this.shapeList.setSelectedIndex(this.shape);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error("invalid switch shape [{}] in Switchboard", (Object)this.shape);
        }
    }

    public int getRows() {
        if (this.autoRowsBox.isSelected()) {
            return 0;
        }
        return this.rows;
    }

    public void setRows(int rws) {
        this.autoRowsBox.setSelected(rws == 0);
        if (rws > 0) {
            this.rowsSpinner.setValue(rws);
            this.rowsSpinner.setEnabled(true);
        } else {
            this.rowsSpinner.setEnabled(false);
            this.rowsSpinner.setToolTipText(Bundle.getMessage("RowsSpinnerOffTooltip"));
            this.rows = this.autoRows(1.0f);
            this.rowsSpinner.setValue(this.rows);
        }
    }

    @Deprecated
    public int getColumns() {
        return this.getRows();
    }

    @Deprecated
    public void setColumns(int rws) {
        this.setRows(rws);
    }

    public int getTotal() {
        return this.switchesOnBoard.size();
    }

    public void loadComplete() {
        log.debug("loadComplete");
    }

    public String showUserName() {
        return this.showUserNameBox.isSelected() ? "yes" : "no";
    }

    public void setShowUserName(Boolean on) {
        this.showUserNameBox.setSelected(on);
    }

    @Override
    public void initView() {
        this.controllingBox.setSelected(this.allControlling());
        this.showToolTipBox.setSelected(this.showToolTip());
        switch (this._scrollState) {
            case 0: {
                this.scrollNone.setSelected(true);
                break;
            }
            case 1: {
                this.scrollBoth.setSelected(true);
                break;
            }
            case 2: {
                this.scrollHorizontal.setSelected(true);
                break;
            }
            default: {
                this.scrollVertical.setSelected(true);
            }
        }
        log.debug("InitView done");
    }

    protected Manager<?> getManager(char typeChar) {
        switch (typeChar) {
            case 'T': {
                return InstanceManager.getNullableDefault(TurnoutManager.class);
            }
            case 'S': {
                return InstanceManager.getNullableDefault(SensorManager.class);
            }
            case 'L': {
                return InstanceManager.getNullableDefault(LightManager.class);
            }
        }
        log.error("Unsupported bean type character \"{}\" found.", (Object)Character.valueOf(typeChar));
        return null;
    }

    protected Manager<?> getManager() {
        if (this._type.equals(TURNOUT)) {
            return this.turnoutManComboBox.getSelectedItem();
        }
        if (this._type.equals(SENSOR)) {
            return this.sensorManComboBox.getSelectedItem();
        }
        if (this._type.equals(LIGHT)) {
            return this.lightManComboBox.getSelectedItem();
        }
        log.error("Unsupported bean type character \"{}\" found.", (Object)this._type);
        return null;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseDragged(MouseEvent event) {
    }

    @Override
    public void mouseMoved(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this._targetPanel.repaint();
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.setToolTip(null);
        this._targetPanel.repaint();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
        this.setAllEditable(false);
        log.debug("windowClosing");
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this._menuBar.revalidate();
    }

    @Override
    protected void targetWindowClosingEvent(WindowEvent e) {
        boolean save = this.isDirty() || this.savedEditMode != this.isEditable() || this.savedControlLayout != this.allControlling();
        log.trace("Temp fix to disable CI errors: save = {}", (Object)save);
        this.targetWindowClosing();
    }

    @Override
    protected Editor changeView(String className) {
        return null;
    }

    public JmriJFrame makeFrame(String name) {
        JmriJFrame targetFrame = new JmriJFrame(name);
        targetFrame.setVisible(true);
        JMenuBar menuBar = new JMenuBar();
        JMenu editMenu = new JMenu(Bundle.getMessage("MenuEdit"));
        menuBar.add(editMenu);
        editMenu.add(new AbstractAction(Bundle.getMessage("OpenEditor")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwitchboardEditor.this.setVisible(true);
                SwitchboardEditor.this.setAllEditable(true);
                log.debug("Switchboard Open Editor menu called");
            }
        });
        targetFrame.setJMenuBar(menuBar);
        targetFrame.addHelpMenu("package.jmri.jmrit.display.SwitchboardEditor", true);
        return targetFrame;
    }

    @Override
    protected void paintTargetPanel(Graphics g) {
    }

    protected BeanSwitch getSwitch(String sName) {
        if (this.ready && this.switchesOnBoard.containsKey(sName)) {
            return this.switchesOnBoard.get(sName);
        }
        log.warn("Switch {} not found on panel. Number of switches displayed: {}", (Object)sName, (Object)this.switchesOnBoard.size());
        return null;
    }

    public List<BeanSwitch> getSwitches() {
        ArrayList<BeanSwitch> _switches = new ArrayList<BeanSwitch>();
        log.debug("N = {}", (Object)this.switchesOnBoard.size());
        if (this.ready) {
            for (Map.Entry<String, BeanSwitch> bs : this.switchesOnBoard.entrySet()) {
                _switches.add(bs.getValue());
            }
        }
        return _switches;
    }

    @Override
    protected void copyItem(Positionable p) {
    }

    @Override
    public void setNextLocation(Positionable obj) {
    }

    @Override
    protected void showPopUp(Positionable p, MouseEvent event) {
    }

    protected ArrayList<Positionable> getSelectionGroup() {
        return null;
    }

    @Override
    public List<NamedBeanUsageReport> getUsageReport(NamedBean bean) {
        ArrayList<NamedBeanUsageReport> report = new ArrayList<NamedBeanUsageReport>();
        if (bean != null) {
            this.getSwitches().forEach(beanSwitch -> {
                if (bean.equals(beanSwitch.getNamedBean())) {
                    report.add(new NamedBeanUsageReport("SwitchBoard", this.getName()));
                }
            });
        }
        return report;
    }

    public int getTileSize() {
        return this._tileSize;
    }

    public void switchAllLights(int on) {
        if (this.ready) {
            for (BeanSwitch bs : this.switchesOnBoard.values()) {
                bs.switchLight(on);
            }
        }
    }

    protected void configureManagerComboBoxes() {
        LightManager defaultManagerL = InstanceManager.getDefault(LightManager.class);
        if (defaultManagerL instanceof ProxyManager) {
            this.lightManComboBox.setManagers(defaultManagerL);
        } else {
            this.lightManComboBox.setManagers(this.lightManager);
        }
        SensorManager defaultManagerS = InstanceManager.getDefault(SensorManager.class);
        if (defaultManagerS instanceof ProxyManager) {
            this.sensorManComboBox.setManagers(defaultManagerS);
            log.debug("using PROXYmanager for Sensors");
        } else {
            this.sensorManComboBox.setManagers(this.sensorManager);
        }
        TurnoutManager defaultManagerT = InstanceManager.getDefault(TurnoutManager.class);
        if (defaultManagerT instanceof ProxyManager) {
            this.turnoutManComboBox.setManagers(defaultManagerT);
            log.debug("using PROXYmanager for Turnouts");
        } else {
            this.turnoutManComboBox.setManagers(this.turnoutManager);
        }
    }

    protected void displayManagerComboBoxes(String type) {
        this._type = type;
        if (type.equals(LIGHT)) {
            Object manager = this.lightManComboBox.getSelectedItem();
            if (manager != null) {
                this.memo = manager.getMemo();
            }
            this.turnoutManComboBox.setVisible(false);
            this.sensorManComboBox.setVisible(false);
            this.lightManComboBox.setVisible(true);
            log.debug("BOX for LightManager set. LightManComboVisible={}", (Object)this.lightManComboBox.isVisible());
        } else if (type.equals(SENSOR)) {
            Object manager = this.sensorManComboBox.getSelectedItem();
            if (manager != null) {
                this.memo = manager.getMemo();
            }
            this.turnoutManComboBox.setVisible(false);
            this.sensorManComboBox.setVisible(true);
            this.lightManComboBox.setVisible(false);
            log.debug("BOX for SensorManager set. SensorManComboVisible={}", (Object)this.sensorManComboBox.isVisible());
        } else {
            Object manager = this.turnoutManComboBox.getSelectedItem();
            if (manager != null) {
                this.memo = manager.getMemo();
            }
            this.turnoutManComboBox.setVisible(true);
            this.sensorManComboBox.setVisible(false);
            this.lightManComboBox.setVisible(false);
            log.debug("BOX for TurnoutManager set. TurnoutManComboVisible={}", (Object)this.turnoutManComboBox.isVisible());
        }
    }

    public void setIconScale(int size) {
        this._iconSquare = size;
        if (size < 100) {
            this.sizeSmall.setSelected(true);
        } else if (size > 100) {
            this.sizeLarge.setSelected(true);
        } else {
            this.sizeDefault.setSelected(true);
        }
        this.updatePressed();
    }

    public int getIconScale() {
        return this._iconSquare;
    }
}

