/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.switchboardEditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jmri.DigitalIO;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Light;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Sensor;
import jmri.Turnout;
import jmri.jmrit.beantable.AddNewDevicePanel;
import jmri.jmrit.display.switchboardEditor.Bundle;
import jmri.jmrit.display.switchboardEditor.SwitchboardEditor;
import jmri.util.JmriJFrame;
import jmri.util.SystemType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanSwitch
extends JPanel
implements PropertyChangeListener,
ActionListener {
    private final JButton beanButton = new JButton();
    private IconSwitch iconSwitch;
    private final int _shape;
    private int square = 75;
    private int radius = 50;
    private double popScale = 1.0;
    private Boolean showUserName = true;
    private Color activeColor = Color.RED;
    private Color inactiveColor = Color.GREEN;
    Color textColor = Color.BLACK;
    protected String switchLabel;
    protected String switchTooltip;
    protected boolean _text;
    protected boolean _icon = false;
    protected boolean _control = false;
    protected int _showingState = 0;
    protected String _stateSign;
    protected String _color;
    protected String stateClosed = Bundle.getMessage("StateClosedShort");
    protected String stateThrown = Bundle.getMessage("StateThrownShort");
    private final SwitchboardEditor _editor;
    private char beanTypeChar = (char)84;
    private String switchTypeName = "Turnout";
    private String manuPrefix = "I";
    private final String _switchSysName;
    boolean showToolTip = true;
    boolean allControlling = true;
    boolean panelEditable = false;
    private final NamedBean _bname;
    private NamedBeanHandle<?> namedBean = null;
    protected NamedBeanHandleManager nbhm = InstanceManager.getDefault(NamedBeanHandleManager.class);
    private String _uName = "unconnected";
    private String _uLabel = "";
    JPopupMenu switchPopup;
    JMenuItem connectNewMenu = new JMenuItem(Bundle.getMessage("ConnectNewMenu", "..."));
    JMenuItem editItem = null;
    JCheckBoxMenuItem invertItem = null;
    private boolean inverted = false;
    JmriJFrame addFrame = null;
    JTextField sysNameTextBox = new JTextField(12);
    JTextField userName = new JTextField(15);
    String rootPath = "resources/icons/misc/switchboard/";
    private static final Logger log = LoggerFactory.getLogger(BeanSwitch.class);

    public BeanSwitch(int index, @CheckForNull NamedBean bean, final @Nonnull String switchName, int shapeChoice, @CheckForNull SwitchboardEditor editor) {
        log.debug("Name = [{}]", (Object)switchName);
        this._switchSysName = switchName;
        this._editor = editor;
        this._bname = bean;
        this._shape = shapeChoice;
        this.sysNameTextBox.setText(switchName);
        boolean hideUnconnected = false;
        Color backgroundColor = Color.LIGHT_GRAY;
        if (editor != null) {
            this.manuPrefix = editor.getSwitchManu();
            this.switchTypeName = this._editor.getSwitchTypeName();
            hideUnconnected = editor.hideUnconnected();
            this.allControlling = editor.allControlling();
            this.panelEditable = editor.isEditable();
            this.showToolTip = editor.showToolTip();
            this.showUserName = editor.showUserName().equals("yes");
            this.radius = editor.getTileSize() / 2;
            this.square = editor.getIconScale();
            this.textColor = editor.getDefaultTextColorAsColor();
            backgroundColor = editor.getDefaultBackgroundColor();
            this.activeColor = editor.getActiveColorAsColor();
            this.inactiveColor = editor.getInactiveColorAsColor();
            this.popScale = this._editor.getPaintScale();
        }
        if (bean != null) {
            this._uName = bean.getUserName();
            log.debug("Switch userName from bean: {}", (Object)this._uName);
            if (this._uName == null) {
                this._uName = Bundle.getMessage("NoUserName");
            } else if (this.showUserName.booleanValue()) {
                this._uLabel = this._uName;
            }
        }
        this.switchTooltip = String.valueOf(switchName) + " (" + this._uName + ")";
        this.setLayout(new BorderLayout());
        this.beanTypeChar = this._switchSysName.charAt(this.manuPrefix.length());
        if (this.beanTypeChar != 'T' && this.beanTypeChar != 'S' && this.beanTypeChar != 'L') {
            log.error("invalid char in Switchboard Button \"{}\". Check connection name.", (Object)this._switchSysName);
            JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorSwitchAddFailed"), Bundle.getMessage("WarningTitle"), 0);
            return;
        }
        log.debug("BeanSwitch graphic tilesize/2  r={} scale={}", (Object)this.radius, (Object)this.square);
        log.debug("beanconnect = {}, beantype = {}", (Object)this.manuPrefix, (Object)Character.valueOf(this.beanTypeChar));
        try {
            if (bean != null) {
                this.namedBean = this.nbhm.getNamedBeanHandle(switchName, bean);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error("invalid bean name= \"{}\" in Switchboard Button", (Object)switchName);
        }
        this._text = true;
        this._icon = true;
        switch (this._shape) {
            case 1: {
                this.iconSwitch = new IconSwitch(this._shape, this.beanTypeChar);
                this.iconSwitch.setPreferredSize(new Dimension(2 * this.radius, 2 * this.radius));
                this.iconSwitch.positionLabel(0, 5 * this.radius / -8, 0.5f, Math.max(12, this.radius / 4));
                this.iconSwitch.positionSubLabel(0, this.radius / -5, 0.5f, Math.max(9, this.radius / 5));
                this.add(this.iconSwitch);
                break;
            }
            case 2: {
                this.iconSwitch = new IconSwitch(this._shape, this.beanTypeChar);
                this.iconSwitch.setPreferredSize(new Dimension(2 * this.radius, 2 * this.radius));
                this.iconSwitch.positionLabel(0, 0, 0.5f, Math.max(12, this.radius / 4));
                this.iconSwitch.positionSubLabel(0, 3 * this.radius / 10, 0.5f, Math.max(9, this.radius / 5));
                this.add(this.iconSwitch);
                break;
            }
            case 3: {
                this.iconSwitch = new IconSwitch(String.valueOf(this.rootPath) + this.beanTypeChar + "-on-s.png", String.valueOf(this.rootPath) + this.beanTypeChar + "-off-s.png", backgroundColor);
                this.iconSwitch.setPreferredSize(new Dimension(2 * this.radius, 2 * this.radius));
                switch (this.beanTypeChar) {
                    case 'T': {
                        this.iconSwitch.positionLabel(0, 5 * this.radius / -8, 0.5f, Math.max(12, this.radius / 4));
                        this.iconSwitch.positionSubLabel(0, this.radius / -4, 0.5f, Math.max(9, this.radius / 5));
                        break;
                    }
                    default: {
                        this.iconSwitch.positionLabel(0, 5 * this.radius / -8, 0.5f, Math.max(12, this.radius / 4));
                        this.iconSwitch.positionSubLabel(0, this.radius / -3, 0.5f, Math.max(9, this.radius / 5));
                    }
                }
                this.setBorder(BorderFactory.createLineBorder(backgroundColor, 3));
                this.add(this.iconSwitch);
                break;
            }
            default: {
                this._icon = false;
                this.beanButton.setText(this.getSwitchButtonLabel(String.valueOf(this._switchSysName) + ": ?"));
                this.beanButton.setForeground(this.textColor);
                this.beanButton.setOpaque(true);
                this.setBorder(BorderFactory.createLineBorder(backgroundColor, 2));
                this.beanButton.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        if (BeanSwitch.this.showUserName.booleanValue() && BeanSwitch.this.beanButton.getHeight() < 50) {
                            BeanSwitch.this.beanButton.setVerticalAlignment(1);
                        } else {
                            BeanSwitch.this.beanButton.setVerticalAlignment(0);
                        }
                    }
                });
                this.beanButton.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        BeanSwitch.this.redispatchToParent(e);
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        BeanSwitch.this.redispatchToParent(e);
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                        BeanSwitch.this.redispatchToParent(e);
                    }
                });
                this.beanButton.setMargin(new Insets(4, 1, 2, 1));
                this.add(this.beanButton);
            }
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                BeanSwitch.this.operate(me, switchName);
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (me.isPopupTrigger()) {
                    BeanSwitch.this.showPopUp(me);
                }
            }

            @Override
            public void mousePressed(MouseEvent me) {
                if (me.isPopupTrigger()) {
                    log.debug("what's clicking?");
                    BeanSwitch.this.showPopUp(me);
                }
            }
        });
        if (this.showToolTip) {
            this.setToolTipText(this.switchTooltip);
        }
        if (this.iconSwitch != null) {
            this.iconSwitch.setBackground(backgroundColor);
            this.iconSwitch.setLabels(this.switchLabel, this._uLabel);
        }
        if (bean == null) {
            if (!hideUnconnected) {
                switch (this._shape) {
                    case 0: {
                        this.beanButton.setEnabled(false);
                    }
                }
                this.displayState(0);
            }
        } else {
            this._control = true;
            switch (this.beanTypeChar) {
                case 'T': {
                    this.getTurnout().addPropertyChangeListener(this, this._switchSysName, "Switchboard Editor Turnout Switch");
                    if (!this.getTurnout().canInvert()) break;
                    this.setInverted(this.getTurnout().getInverted());
                    break;
                }
                case 'S': {
                    this.getSensor().addPropertyChangeListener(this, this._switchSysName, "Switchboard Editor Sensor Switch");
                    if (!this.getSensor().canInvert()) break;
                    this.setInverted(this.getSensor().getInverted());
                    break;
                }
                default: {
                    this.getLight().addPropertyChangeListener(this, this._switchSysName, "Switchboard Editor Light Switch");
                }
            }
            this.displayState(bean.getState());
        }
        log.debug("Created switch {}", (Object)index);
    }

    public NamedBean getNamedBean() {
        return this._bname;
    }

    public void setNamedBean(@Nonnull NamedBean bean) {
        try {
            this.namedBean = this.nbhm.getNamedBeanHandle(this._switchSysName, bean);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error("invalid bean name= \"{}\" in Switchboard Button", (Object)this._switchSysName);
        }
        this._uName = bean.getUserName();
        if (this._uName == null) {
            this._uName = Bundle.getMessage("NoUserName");
        } else if (this.showUserName.booleanValue()) {
            this._uLabel = this._uName;
        }
        this._control = true;
    }

    public Turnout getTurnout() {
        if (this.namedBean == null) {
            return null;
        }
        return (Turnout)this.namedBean.getBean();
    }

    public Sensor getSensor() {
        if (this.namedBean == null) {
            return null;
        }
        return (Sensor)this.namedBean.getBean();
    }

    public Light getLight() {
        if (this.namedBean == null) {
            return null;
        }
        return (Light)this.namedBean.getBean();
    }

    public int getShape() {
        return this._shape;
    }

    public String getActiveText() {
        this._stateSign = this.beanTypeChar == 'T' ? this.stateClosed : "+";
        return String.valueOf(this._switchSysName) + ": " + this._stateSign;
    }

    public String getInactiveText() {
        this._stateSign = this.beanTypeChar == 'T' ? this.stateThrown : "-";
        return String.valueOf(this._switchSysName) + ": " + this._stateSign;
    }

    public String getUnknownText() {
        return String.valueOf(this._switchSysName) + ": ?";
    }

    public String getInconsistentText() {
        return String.valueOf(this._switchSysName) + ": X";
    }

    public String getToolTip() {
        return this.switchTooltip;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public String getNameString() {
        return this._switchSysName;
    }

    public String getUserNameString() {
        return this._uLabel;
    }

    private String getSwitchButtonLabel(String label) {
        if (!this.showUserName.booleanValue() || this._uLabel.equals("")) {
            return label;
        }
        String subLabel = this._uLabel.substring(0, Math.min(this._uLabel.length(), 35));
        return "<html><center>" + label + "</center><br><center><i>" + subLabel + "</i></center></html>";
    }

    public void displayState(int newState) {
        Color switchColor;
        String switchLabel;
        if (this.getNamedBean() == null) {
            switchLabel = this._switchSysName;
            switchColor = Color.GRAY;
            log.debug("Switch label {} state {}, disconnected", (Object)switchLabel, (Object)newState);
        } else {
            if (newState == this._showingState) {
                return;
            }
            switch (newState) {
                case 1: {
                    switchLabel = this.getUnknownText();
                    switchColor = Color.GRAY;
                    break;
                }
                case 2: {
                    switchLabel = this.getActiveText();
                    switchColor = this.activeColor;
                    break;
                }
                case 4: {
                    switchLabel = this.getInactiveText();
                    switchColor = this.inactiveColor;
                    break;
                }
                default: {
                    switchLabel = this.getInconsistentText();
                    switchColor = Color.WHITE;
                    log.debug("Switch label {} state: {}, connected", (Object)switchLabel, (Object)newState);
                }
            }
        }
        if (this.isText() && !this.isIcon()) {
            log.debug("Label = {}", (Object)this.getSwitchButtonLabel(switchLabel));
            this.beanButton.setText(this.getSwitchButtonLabel(switchLabel));
            this.beanButton.setBackground(switchColor);
            this.beanButton.setOpaque(true);
        } else if (this.isIcon() && this.iconSwitch != null) {
            this.iconSwitch.showSwitchIcon(newState);
            this.iconSwitch.setLabels(switchLabel, this._uLabel);
        }
        this._showingState = newState;
    }

    public final boolean isIcon() {
        return this._icon;
    }

    public final boolean isText() {
        return this._text;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("property change: {} {} is now: {}", new Object[]{this._switchSysName, e.getPropertyName(), e.getNewValue()});
        }
        if (e.getPropertyName().equals("KnownState")) {
            int now = (Integer)e.getNewValue();
            this.displayState(now);
            log.debug("Item state changed");
        }
        if (e.getPropertyName().equals("UserName") && this.showToolTip) {
            String newUserName = (String)e.getNewValue();
            String string = this._uLabel = newUserName == null ? "" : newUserName;
            if (newUserName == null || newUserName.equals("")) {
                newUserName = Bundle.getMessage("NoUserName");
            }
            this.setToolTipText(String.valueOf(this._switchSysName) + " (" + newUserName + ")");
            log.debug("User Name changed to {}", (Object)newUserName);
        }
    }

    void cleanup() {
        if (this.namedBean != null) {
            switch (this.beanTypeChar) {
                case 'T': {
                    this.getTurnout().removePropertyChangeListener(this);
                    break;
                }
                case 'S': {
                    this.getSensor().removePropertyChangeListener(this);
                    break;
                }
                default: {
                    this.getLight().removePropertyChangeListener(this);
                }
            }
        }
        this.namedBean = null;
    }

    public boolean showPopUp(MouseEvent e) {
        block10: {
            block11: {
                if (this.switchPopup != null) {
                    this.switchPopup.removeAll();
                } else {
                    this.switchPopup = new JPopupMenu();
                }
                this.switchPopup.add(this.getNameString());
                if (!this.panelEditable || !this.allControlling) break block10;
                if (this.namedBean == null) break block11;
                this.addEditUserName(this.switchPopup);
                switch (this.beanTypeChar) {
                    case 'T': {
                        if (this.getTurnout().canInvert()) {
                            this.addInvert(this.switchPopup);
                            break;
                        }
                        break block10;
                    }
                    case 'S': {
                        if (!this.getSensor().canInvert()) break block10;
                        this.addInvert(this.switchPopup);
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block10;
            }
            this.switchPopup.add(this.connectNewMenu);
            this.connectNewMenu.addActionListener(e1 -> this.connectNew());
        }
        this.switchPopup.show(this, this.getWidth() / 3 + (int)((this.popScale - 1.0) * (double)this.getX()), this.getHeight() / 3 + (int)((this.popScale - 1.0) * (double)this.getY()));
        return true;
    }

    void addEditUserName(JPopupMenu popup) {
        this.editItem = new JMenuItem(Bundle.getMessage("EditNameTitle", "..."));
        popup.add(this.editItem);
        this.editItem.addActionListener(e -> this.renameBeanDialog());
    }

    void addInvert(JPopupMenu popup) {
        this.invertItem = new JCheckBoxMenuItem(Bundle.getMessage("MenuInvertItem", this._switchSysName));
        this.invertItem.setSelected(this.getInverted());
        popup.add(this.invertItem);
        this.invertItem.addActionListener(e -> this.setBeanInverted(this.invertItem.isSelected()));
    }

    public void renameBeanDialog() {
        String oldName = this._uName;
        JTextField name = new JTextField(oldName);
        JOptionPane pane = new JOptionPane(new Object[]{Bundle.getMessage("EnterNewName", this._switchSysName), name}, 1, 0, null, new Object[]{Bundle.getMessage("ButtonOK"), Bundle.getMessage("ButtonCancel")}, 0);
        JDialog dialog = pane.createDialog(null, Bundle.getMessage("EditNameTitle", ""));
        dialog.setVisible(true);
        if (pane.getValue().equals(Bundle.getMessage("ButtonCancel"))) {
            return;
        }
        String newUserName = name.getText();
        if (newUserName == null || newUserName.equals(Bundle.getMessage("NoUserName")) || newUserName.isEmpty()) {
            log.debug("new user name was empty");
            JOptionPane.showMessageDialog(null, Bundle.getMessage("WarningEmptyUserName"), Bundle.getMessage("WarningTitle"), 0);
            return;
        }
        this.renameBean(newUserName, oldName);
    }

    protected void renameBean(String newUserName, String oldName) {
        DigitalIO nb;
        if (newUserName.equals(oldName)) {
            return;
        }
        switch (this.beanTypeChar) {
            case 'T': {
                nb = InstanceManager.turnoutManagerInstance().getTurnout(newUserName);
                break;
            }
            case 'S': {
                nb = InstanceManager.sensorManagerInstance().getSensor(newUserName);
                break;
            }
            case 'L': {
                nb = InstanceManager.lightManagerInstance().getLight(newUserName);
                break;
            }
            default: {
                log.error("Check userName: cannot parse bean name. userName = {}", (Object)newUserName);
                return;
            }
        }
        if (nb != null) {
            log.error("User name is not unique {}", (Object)newUserName);
            String msg = Bundle.getMessage("WarningUserName", newUserName);
            JOptionPane.showMessageDialog(null, msg, Bundle.getMessage("WarningTitle"), 0);
            return;
        }
        this._bname.setUserName(newUserName);
        if (oldName == null || oldName.equals("")) {
            if (!this.nbhm.inUse(this._switchSysName, this._bname)) {
                return;
            }
            String msg = Bundle.getMessage("UpdateToUserName", this.switchTypeName, newUserName, this._switchSysName);
            int optionPane = JOptionPane.showConfirmDialog(null, msg, Bundle.getMessage("UpdateToUserNameTitle"), 0);
            if (optionPane == 0) {
                try {
                    this.nbhm.updateBeanFromSystemToUser(this._bname);
                }
                catch (JmriException jmriException) {}
            }
        } else {
            this.nbhm.renameBean(oldName, newUserName, this._bname);
        }
        if (this._editor != null) {
            this._editor.updatePressed();
        }
    }

    public void setInverted(boolean set) {
        this.inverted = set;
    }

    public boolean getInverted() {
        return this.inverted;
    }

    public void setBeanInverted(boolean set) {
        switch (this.beanTypeChar) {
            case 'T': {
                if (this.getTurnout() == null || !this.getTurnout().canInvert()) break;
                this.setInverted(set);
                this.getTurnout().setInverted(set);
                break;
            }
            case 'S': {
                if (this.getSensor() == null || !this.getSensor().canInvert()) break;
                this.setInverted(set);
                this.getSensor().setInverted(set);
                break;
            }
            case 'L': {
                return;
            }
            default: {
                log.error("Invert item: cannot parse bean name. userName = {}", (Object)this._switchSysName);
            }
        }
    }

    public void operate(MouseEvent e, String name) {
        log.debug("Button {} clicked", (Object)name);
        if (this.namedBean == null || e == null || e.isMetaDown()) {
            return;
        }
        this.alternateOnClick();
    }

    public void doMouseClicked(MouseEvent e) {
        log.debug("Switch clicked");
        if (this.namedBean == null || e == null || e.isMetaDown()) {
            return;
        }
        this.alternateOnClick();
    }

    void alternateOnClick() {
        if (this.allControlling) {
            switch (this.beanTypeChar) {
                case 'T': {
                    log.debug("T clicked");
                    if (this.getTurnout().getKnownState() == 2) {
                        this.getTurnout().setCommandedState(4);
                        break;
                    }
                    if (this.getTurnout().getKnownState() == 4) {
                        this.getTurnout().setCommandedState(2);
                        break;
                    }
                    if (this.getTurnout().getCommandedState() == 2) {
                        this.getTurnout().setCommandedState(4);
                        break;
                    }
                    this.getTurnout().setCommandedState(2);
                    break;
                }
                case 'L': {
                    log.debug("L clicked");
                    if (this.getLight().getState() == 4) {
                        this.getLight().setState(2);
                        break;
                    }
                    this.getLight().setState(4);
                    break;
                }
                case 'S': {
                    log.debug("S clicked");
                    try {
                        if (this.getSensor().getKnownState() == 4) {
                            this.getSensor().setKnownState(2);
                            break;
                        }
                        this.getSensor().setKnownState(4);
                    }
                    catch (JmriException reason) {
                        log.warn("Exception flipping sensor: {}", (Object)reason);
                    }
                    break;
                }
                default: {
                    log.error("invalid char in Switchboard Button \"{}\". State not set.", (Object)this._switchSysName);
                }
            }
        }
    }

    public void switchLight(int state) {
        if (this.namedBean != null) {
            this.getLight().setState(state);
        }
    }

    public void setBackgroundColor(Color bgcolor) {
        this.setBackground(bgcolor);
    }

    protected void connectNew() {
        log.debug("Request new bean");
        this.userName.setText("");
        if (this.addFrame == null) {
            this.addFrame = new JmriJFrame(Bundle.getMessage("ConnectNewMenu", ""), false, true);
            this.addFrame.addHelpMenu("package.jmri.jmrit.display.switchboardEditor.SwitchboardEditor", true);
            this.addFrame.getContentPane().setLayout(new BoxLayout(this.addFrame.getContentPane(), 1));
            ActionListener okListener = this::okAddPressed;
            ActionListener cancelListener = this::cancelAddPressed;
            AddNewDevicePanel switchConnect = new AddNewDevicePanel(this.sysNameTextBox, this.userName, "ButtonOK", okListener, cancelListener);
            switchConnect.setSystemNameFieldIneditable();
            switchConnect.setOK();
            this.addFrame.add(switchConnect);
        }
        this.addFrame.pack();
        this.addFrame.setLocationRelativeTo(this);
        this.addFrame.setVisible(true);
    }

    protected void cancelAddPressed(ActionEvent e) {
        if (this.addFrame != null) {
            this.addFrame.setVisible(false);
            this.addFrame.dispose();
            this.addFrame = null;
        }
    }

    protected void okAddPressed(ActionEvent e) {
        DigitalIO nb;
        String user = this.userName.getText();
        if (user.trim().equals("")) {
            user = null;
        }
        if (this.addFrame != null) {
            this.addFrame.setVisible(false);
            this.addFrame.dispose();
            this.addFrame = null;
        }
        switch (this._switchSysName.charAt(this.manuPrefix.length())) {
            case 'T': {
                try {
                    Turnout t = InstanceManager.turnoutManagerInstance().provideTurnout(this._switchSysName);
                    t.setUserName(user);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.handleCreateException(this._switchSysName);
                    return;
                }
                nb = InstanceManager.turnoutManagerInstance().getTurnout(this._switchSysName);
                break;
            }
            case 'S': {
                try {
                    Sensor s = InstanceManager.sensorManagerInstance().provideSensor(this._switchSysName);
                    s.setUserName(user);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.handleCreateException(this._switchSysName);
                    return;
                }
                nb = InstanceManager.sensorManagerInstance().getSensor(this._switchSysName);
                break;
            }
            case 'L': {
                try {
                    Light l = InstanceManager.lightManagerInstance().provideLight(this._switchSysName);
                    l.setUserName(user);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.handleCreateException(this._switchSysName);
                    return;
                }
                nb = InstanceManager.lightManagerInstance().getLight(this._switchSysName);
                break;
            }
            default: {
                log.error("connectNew - okAddPressed: cannot parse bean name. sName = {}", (Object)this._switchSysName);
                return;
            }
        }
        if (nb == null) {
            log.warn("failed to connect switch to item {}", (Object)this._switchSysName);
        } else {
            log.debug("sName state: {}", (Object)nb.getState());
            try {
                if (this._editor.getSwitch(this._switchSysName) == null) {
                    log.warn("failed to update switch to state of {}", (Object)this._switchSysName);
                } else {
                    this._editor.updatePressed();
                }
            }
            catch (NullPointerException nullPointerException) {
                this.handleCreateException(this._switchSysName);
            }
        }
    }

    protected String getIconLabel() {
        switch (this._shape) {
            case 0: {
                String lbl = this.beanButton.getText();
                if (!lbl.startsWith("<")) {
                    return lbl;
                }
                return lbl.substring(14, lbl.indexOf("</center>"));
            }
            case 1: 
            case 2: 
            case 3: {
                return this.iconSwitch.getIconLabel();
            }
        }
        return "";
    }

    void handleCreateException(String sysName) {
        JOptionPane.showMessageDialog(this.addFrame, MessageFormat.format(Bundle.getMessage("ErrorSwitchAddFailed"), sysName), Bundle.getMessage("ErrorTitle"), 0);
    }

    private void redispatchToParent(MouseEvent e) {
        Component source = (Component)e.getSource();
        MouseEvent parentEvent = SwingUtilities.convertMouseEvent(source, e, source.getParent());
        source.getParent().dispatchEvent(parentEvent);
    }

    public static BufferedImage resizeImage(Image image, int scale, Color background) {
        int newWidth = scale * image.getWidth(null) / 100;
        int newHeight = scale * image.getHeight(null) / 100;
        BufferedImage bimg = new BufferedImage(newWidth, newHeight, 1);
        Graphics2D g2d = bimg.createGraphics();
        g2d.setColor(background);
        log.debug("BGCOLOR={}", (Object)background);
        g2d.fillRect(0, 0, newWidth, newHeight);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.drawImage(image, 0, 0, newWidth, newHeight, null);
        g2d.dispose();
        return bimg;
    }

    public class IconSwitch
    extends JPanel {
        private BufferedImage image;
        private BufferedImage image1;
        private BufferedImage image2;
        private String tag = "tag";
        private String subTag = "";
        private int labelX = 16;
        private int labelY = 53;
        private int subLabelX = 16;
        private int subLabelY = 53;
        private int textSize = 12;
        private int subTextSize = 10;
        private float textAlign = 0.0f;
        private float subTextAlign = 0.0f;
        private float ropOffset = 0.0f;
        private int r = 10;
        private int _shape = 0;
        private int _state = 0;
        private RescaleOp rop;

        public IconSwitch(String filepath1, String filepath2, Color back) {
            try {
                this.image1 = ImageIO.read(new File(filepath1));
                this.image2 = ImageIO.read(new File(filepath2));
                if (BeanSwitch.this.square != 100 && BeanSwitch.this.square >= 25 && BeanSwitch.this.square <= 150) {
                    this.image1 = BeanSwitch.resizeImage(this.image1, BeanSwitch.this.square, back);
                    this.image2 = BeanSwitch.resizeImage(this.image2, BeanSwitch.this.square, back);
                }
                this.image = this.image2;
            }
            catch (IOException ex) {
                log.error("error reading image from {}-{}", new Object[]{filepath1, filepath2, ex});
            }
            this._shape = 3;
            if (BeanSwitch.this.radius > 10) {
                this.r = BeanSwitch.this.radius;
            }
            log.debug("radius={} size={}", (Object)this.r, (Object)this.getWidth());
        }

        @Deprecated
        public IconSwitch(String filepath1, String filepath2) {
            this(filepath1, filepath2, Color.GRAY);
        }

        public IconSwitch(int shape, int type) {
            if (shape == 0 || shape == 3) {
                return;
            }
            this._shape = shape;
            if (BeanSwitch.this.radius > 10) {
                this.r = BeanSwitch.this.radius;
            }
            log.debug("DrawnIcon type={}", (Object)type);
        }

        public void setOpacity(float offset) {
            this.ropOffset = offset;
            float ropScale = 1.0f;
            this.rop = new RescaleOp(ropScale, this.ropOffset, null);
        }

        protected void showSwitchIcon(int stateIndex) {
            log.debug("showSwitchIcon {}", (Object)stateIndex);
            if (this._shape == 1 || this._shape == 2) {
                this._state = stateIndex;
            } else if (this.image1 != null && this.image2 != null) {
                switch (stateIndex) {
                    case 2: {
                        this.image = this.image1;
                        break;
                    }
                    default: {
                        this.image = this.image2;
                    }
                }
                this.repaint();
            }
        }

        protected void setLabels(String sName, String uName) {
            this.tag = sName;
            this.subTag = uName;
            this.repaint();
        }

        private String getIconLabel() {
            return this.tag;
        }

        protected void positionLabel(int x, int y, float align, int fontsize) {
            this.labelX = x;
            this.labelY = y;
            this.textAlign = align;
            this.textSize = fontsize;
        }

        protected void positionSubLabel(int x, int y, float align, int fontsize) {
            this.subLabelX = x;
            this.subLabelY = y;
            this.subTextAlign = align;
            this.subTextSize = fontsize;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            if (SystemType.isMacOSX() || SystemType.isWindows()) {
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            g.translate(this.r, this.r);
            if (this._shape == 1) {
                if (this._state == 4) {
                    g.setColor(BeanSwitch.this.inactiveColor);
                } else if (this._state == 2) {
                    g.setColor(BeanSwitch.this.activeColor);
                } else {
                    g.setColor(Color.GRAY);
                }
                g2d.fillRoundRect(-this.r / 2, 0, this.r, this.r / 2, this.r / 2, this.r / 2);
                g.setColor(this._state == 2 || this._state == 4 ? Color.BLACK : Color.GRAY);
                g2d.drawRoundRect(-this.r / 2, 0, this.r, this.r / 2, this.r / 2, this.r / 2);
                int knobX = this._state == 2 ? 0 : -this.r / 2;
                g.setColor(Color.WHITE);
                g2d.fillOval(knobX, 0, this.r / 2, this.r / 2);
                g.setColor(Color.BLACK);
                g2d.drawOval(knobX, 0, this.r / 2, this.r / 2);
            } else if (this._shape == 2) {
                g.setColor(this._state == 2 ? BeanSwitch.this.activeColor : SwitchboardEditor.darkActiveColor);
                g2d.fillRoundRect(-3 * this.r / 8, -2 * this.r / 3, 3 * this.r / 4, this.r / 3, this.r / 6, this.r / 6);
                g.setColor(this._state == 4 ? BeanSwitch.this.inactiveColor : SwitchboardEditor.darkInactiveColor);
                g2d.fillRoundRect(-3 * this.r / 8, this.r / 3, 3 * this.r / 4, this.r / 3, this.r / 6, this.r / 6);
                Point2D.Float center = new Point2D.Float(0.05f * (float)this.r, -7.0f * (float)this.r / 8.0f);
                float radius = (float)this.r / 6.0f;
                float[] dist = new float[]{0.0f, 0.8f};
                Color[] colors = new Color[]{Color.WHITE, this._state == 2 ? BeanSwitch.this.activeColor : Color.GRAY};
                RadialGradientPaint pnt = new RadialGradientPaint(center, radius, dist, colors);
                g2d.setPaint(pnt);
                g2d.fillOval(-this.r / 8, -this.r, this.r / 4, this.r / 4);
                g.setColor(Color.BLACK);
                g2d.drawOval(-this.r / 8, -this.r, this.r / 4, this.r / 4);
            } else {
                g2d.drawImage(this.image, this.rop, this.image.getWidth() / -2, this.image.getHeight() / -2);
            }
            g.setFont(this.getFont());
            if (this.ropOffset > 0.0f) {
                g.setColor(Color.GRAY);
            } else {
                g.setColor(BeanSwitch.this.textColor);
            }
            g.setFont(new Font("SansSerif", 1, this.textSize));
            if ((double)Math.abs(this.textAlign - 0.5f) < 1.0E-4) {
                FontMetrics metrics = g.getFontMetrics();
                this.labelX = metrics.stringWidth(this.tag) / -2;
            }
            g.drawString(this.tag, this.labelX, this.labelY);
            if (BeanSwitch.this.showUserName.booleanValue()) {
                g.setFont(new Font("SansSerif", 2, Math.max(this.subTextSize, 6)));
                if ((double)Math.abs(this.subTextAlign - 0.5f) < 1.0E-4) {
                    FontMetrics metrics2 = g.getFontMetrics();
                    this.subLabelX = metrics2.stringWidth(this.subTag) / -2;
                }
                g.drawString(this.subTag, this.subLabelX, this.subLabelY);
            }
        }
    }
}

