/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.panelEditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jmri.CatalogTreeManager;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.configurexml.ConfigXmlManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.configurexml.StoreXmlUserAction;
import jmri.configurexml.XmlAdapter;
import jmri.jmrit.catalog.ImageIndexEditor;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.NewPanelAction;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.jmrit.display.ToolTip;
import jmri.jmrit.display.panelEditor.Bundle;
import jmri.jmrit.logix.WarrantTableAction;
import jmri.util.JmriJFrame;
import jmri.util.SystemType;
import jmri.util.gui.GuiLafPreferencesManager;
import jmri.util.swing.JmriColorChooser;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanelEditor
extends Editor
implements ItemListener {
    private static final String SENSOR = "Sensor";
    private static final String SIGNAL_HEAD = "SignalHead";
    private static final String SIGNAL_MAST = "SignalMast";
    private static final String MEMORY = "Memory";
    private static final String RIGHT_TURNOUT = "RightTurnout";
    private static final String LEFT_TURNOUT = "LeftTurnout";
    private static final String SLIP_TO_EDITOR = "SlipTOEditor";
    private static final String BLOCK_LABEL = "BlockLabel";
    private static final String REPORTER = "Reporter";
    private static final String LIGHT = "Light";
    private static final String BACKGROUND = "Background";
    private static final String MULTI_SENSOR = "MultiSensor";
    private static final String RPSREPORTER = "RPSreporter";
    private static final String FAST_CLOCK = "FastClock";
    private static final String ICON = "Icon";
    private final JTextField nextX = new JTextField("0", 4);
    private final JTextField nextY = new JTextField("0", 4);
    private final JCheckBox editableBox = new JCheckBox(Bundle.getMessage("CheckBoxEditable"));
    private final JCheckBox positionableBox = new JCheckBox(Bundle.getMessage("CheckBoxPositionable"));
    private final JCheckBox controllingBox = new JCheckBox(Bundle.getMessage("CheckBoxControlling"));
    private final JCheckBox showTooltipBox = new JCheckBox(Bundle.getMessage("CheckBoxShowTooltips"));
    private final JCheckBox hiddenBox = new JCheckBox(Bundle.getMessage("CheckBoxHidden"));
    private final JCheckBox menuBox = new JCheckBox(Bundle.getMessage("CheckBoxMenuBar"));
    private final JLabel scrollableLabel = new JLabel(Bundle.getMessage("ComboBoxScrollable"));
    private final JComboBox<String> scrollableComboBox = new JComboBox();
    private final JButton labelAdd = new JButton(Bundle.getMessage("ButtonAddText"));
    private final JTextField nextLabel = new JTextField(10);
    private JComboBox<ComboBoxItem> _addIconBox;
    private boolean delayedPopupTrigger;
    protected ArrayList<Positionable> _multiItemCopyGroup = null;
    protected boolean addItemViaMouseClick = false;
    protected boolean pasteItemFlag = false;
    private static final Logger log = LoggerFactory.getLogger(PanelEditor.class);

    public PanelEditor() {
    }

    public PanelEditor(String name) {
        super(name, false, true);
        this.init(name);
    }

    @Override
    protected void init(String name) {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel common = new JPanel();
        common.setLayout(new FlowLayout());
        common.add(new JLabel(" x:"));
        common.add(this.nextX);
        common.add(new JLabel(" y:"));
        common.add(this.nextY);
        contentPane.add(common);
        this.setAllEditable(true);
        this.setShowHidden(true);
        super.setTargetPanel(null, this.makeFrame(name));
        super.setTargetPanelSize(400, 300);
        super.setDefaultToolTip(new ToolTip(null, 0, 0, new Font("SansSerif", 0, 12), Color.black, new Color(215, 225, 255), Color.black));
        this.setScroll(1);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu(Bundle.getMessage("MenuFile"));
        menuBar.add(fileMenu);
        fileMenu.add(new NewPanelAction(Bundle.getMessage("MenuItemNew")));
        fileMenu.add(new StoreXmlUserAction(Bundle.getMessage("FileMenuItemStore")));
        JMenuItem storeIndexItem = new JMenuItem(Bundle.getMessage("MIStoreImageIndex"));
        fileMenu.add(storeIndexItem);
        storeIndexItem.addActionListener(event -> InstanceManager.getDefault(CatalogTreeManager.class).storeImageIndex());
        JMenuItem editItem = new JMenuItem(Bundle.getMessage("editIndexMenu"));
        editItem.addActionListener(e -> {
            ImageIndexEditor ii = InstanceManager.getDefault(ImageIndexEditor.class);
            ii.pack();
            ii.setVisible(true);
        });
        fileMenu.add(editItem);
        editItem = new JMenuItem(Bundle.getMessage("CPEView"));
        fileMenu.add(editItem);
        editItem.addActionListener(event -> {
            Editor editor = this.changeView("jmri.jmrit.display.controlPanelEditor.ControlPanelEditor");
        });
        fileMenu.addSeparator();
        JMenuItem deleteItem = new JMenuItem(Bundle.getMessage("DeletePanel"));
        fileMenu.add(deleteItem);
        deleteItem.addActionListener(event -> {
            if (this.deletePanel()) {
                this.getTargetFrame().dispose();
                this.dispose();
            }
        });
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.display.PanelEditor", true);
        JPanel namep = new JPanel();
        namep.setLayout(new FlowLayout());
        JButton b = new JButton(Bundle.getMessage("renamePanelMenu", "..."));
        b.addActionListener(new ActionListener(){
            PanelEditor editor;

            @Override
            public void actionPerformed(ActionEvent e) {
                String newName = JOptionPane.showInputDialog(null, (Object)Bundle.getMessage("PromptNewName"));
                if (newName == null) {
                    return;
                }
                if (InstanceManager.getDefault(EditorManager.class).contains(newName)) {
                    JOptionPane.showMessageDialog(null, Bundle.getMessage("CanNotRename"), Bundle.getMessage("PanelExist"), 0);
                    return;
                }
                Container ancestor = PanelEditor.this.getTargetPanel().getTopLevelAncestor();
                if (ancestor instanceof JFrame) {
                    ((JFrame)ancestor).setTitle(newName);
                }
                this.editor.setTitle();
            }

            ActionListener init(PanelEditor e) {
                this.editor = e;
                return this;
            }
        }.init(this));
        namep.add(b);
        this.getContentPane().add(namep);
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        panel.add(this.labelAdd);
        this.labelAdd.setEnabled(false);
        this.labelAdd.setToolTipText(Bundle.getMessage("ToolTipWillActivate"));
        panel.add(this.nextLabel);
        this.labelAdd.addActionListener(new ActionListener(){
            PanelEditor editor;

            @Override
            public void actionPerformed(ActionEvent a) {
                this.editor.addLabel(PanelEditor.this.nextLabel.getText());
            }

            ActionListener init(PanelEditor e) {
                this.editor = e;
                return this;
            }
        }.init(this));
        this.nextLabel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent a) {
                if (PanelEditor.this.nextLabel.getText().equals("")) {
                    PanelEditor.this.labelAdd.setEnabled(false);
                    PanelEditor.this.labelAdd.setToolTipText(Bundle.getMessage("ToolTipWillActivate"));
                } else {
                    PanelEditor.this.labelAdd.setEnabled(true);
                    PanelEditor.this.labelAdd.setToolTipText(null);
                }
            }
        });
        this.getContentPane().add(panel);
        this._addIconBox = new JComboBox();
        this._addIconBox.setMinimumSize(new Dimension(75, 75));
        this._addIconBox.setMaximumSize(new Dimension(200, 200));
        this._addIconBox.addItem(new ComboBoxItem(RIGHT_TURNOUT));
        this._addIconBox.addItem(new ComboBoxItem(LEFT_TURNOUT));
        this._addIconBox.addItem(new ComboBoxItem(SLIP_TO_EDITOR));
        this._addIconBox.addItem(new ComboBoxItem(SENSOR));
        this._addIconBox.addItem(new ComboBoxItem(SIGNAL_HEAD));
        this._addIconBox.addItem(new ComboBoxItem(SIGNAL_MAST));
        this._addIconBox.addItem(new ComboBoxItem(MEMORY));
        this._addIconBox.addItem(new ComboBoxItem(BLOCK_LABEL));
        this._addIconBox.addItem(new ComboBoxItem(REPORTER));
        this._addIconBox.addItem(new ComboBoxItem(LIGHT));
        this._addIconBox.addItem(new ComboBoxItem(BACKGROUND));
        this._addIconBox.addItem(new ComboBoxItem(MULTI_SENSOR));
        this._addIconBox.addItem(new ComboBoxItem(RPSREPORTER));
        this._addIconBox.addItem(new ComboBoxItem(FAST_CLOCK));
        this._addIconBox.addItem(new ComboBoxItem(ICON));
        this._addIconBox.setSelectedIndex(-1);
        this._addIconBox.addItemListener(this);
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 1));
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout());
        p2.add(new JLabel(Bundle.getMessage("selectTypeIcon")));
        p1.add(p2);
        p1.add(this._addIconBox);
        contentPane.add(p1);
        contentPane.add(this.editableBox);
        this.editableBox.addActionListener(event -> {
            this.setAllEditable(this.editableBox.isSelected());
            this.hiddenCheckBoxListener();
        });
        this.editableBox.setSelected(this.isEditable());
        contentPane.add(this.positionableBox);
        this.positionableBox.addActionListener(event -> this.setAllPositionable(this.positionableBox.isSelected()));
        this.positionableBox.setSelected(this.allPositionable());
        contentPane.add(this.controllingBox);
        this.controllingBox.addActionListener(event -> this.setAllControlling(this.controllingBox.isSelected()));
        this.controllingBox.setSelected(this.allControlling());
        contentPane.add(this.hiddenBox);
        this.hiddenCheckBoxListener();
        this.hiddenBox.setSelected(this.showHidden());
        contentPane.add(this.showTooltipBox);
        this.showTooltipBox.addActionListener(e -> this.setAllShowToolTip(this.showTooltipBox.isSelected()));
        this.showTooltipBox.setSelected(this.showToolTip());
        contentPane.add(this.menuBox);
        this.menuBox.addActionListener(e -> this.setPanelMenuVisible(this.menuBox.isSelected()));
        this.menuBox.setSelected(true);
        JPanel scrollPanel = new JPanel();
        scrollPanel.setLayout(new FlowLayout());
        this.scrollableLabel.setLabelFor(this.scrollableComboBox);
        scrollPanel.add(this.scrollableLabel);
        scrollPanel.add(this.scrollableComboBox);
        contentPane.add(scrollPanel);
        this.scrollableComboBox.addItem(Bundle.getMessage("ScrollNone"));
        this.scrollableComboBox.addItem(Bundle.getMessage("ScrollBoth"));
        this.scrollableComboBox.addItem(Bundle.getMessage("ScrollHorizontal"));
        this.scrollableComboBox.addItem(Bundle.getMessage("ScrollVertical"));
        this.scrollableComboBox.setSelectedIndex(1);
        this.scrollableComboBox.addActionListener(e -> this.setScroll(this.scrollableComboBox.getSelectedIndex()));
        ConfigureManager cm = InstanceManager.getNullableDefault(ConfigureManager.class);
        if (cm != null) {
            cm.registerUser(this);
        }
        this.addWindowListener(new WindowAdapter(){
            HashMap<String, Editor.JFrameItem> iconAdderFrames;

            @Override
            public void windowClosing(WindowEvent e) {
                for (Editor.JFrameItem frame : this.iconAdderFrames.values()) {
                    frame.dispose();
                }
            }

            WindowAdapter init(HashMap<String, Editor.JFrameItem> f) {
                this.iconAdderFrames = f;
                return this;
            }
        }.init(this._iconEditorFrame));
        this.setDefaultCloseOperation(1);
        this.getTargetFrame().setLocationRelativeTo(this);
        this.getTargetFrame().pack();
        this.getTargetFrame().setVisible(true);
        log.debug("PanelEditor ctor done.");
    }

    private void hiddenCheckBoxListener() {
        this.setShowHidden(this.hiddenBox.isSelected());
        if (this.editableBox.isSelected()) {
            this.hiddenBox.setEnabled(false);
            this.hiddenBox.setSelected(true);
        } else {
            this.hiddenBox.setEnabled(true);
            this.hiddenBox.addActionListener(event -> this.setShowHidden(this.hiddenBox.isSelected()));
        }
    }

    @Override
    public void initView() {
        this.editableBox.setSelected(this.isEditable());
        this.positionableBox.setSelected(this.allPositionable());
        this.controllingBox.setSelected(this.allControlling());
        this.showTooltipBox.setSelected(this.showToolTip());
        this.hiddenBox.setSelected(this.showHidden());
        this.menuBox.setSelected(this.getTargetFrame().getJMenuBar().isVisible());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            ComboBoxItem item = (ComboBoxItem)e.getItem();
            String name = item.getName();
            Editor.JFrameItem frame = super.getIconFrame(name);
            if (frame != null) {
                frame.getEditor().reset();
                frame.setVisible(true);
            } else if (name.equals(FAST_CLOCK)) {
                this.addClock();
            } else if (name.equals(RPSREPORTER)) {
                this.addRpsReporter();
            } else {
                log.error("Unable to open Icon Editor \"{}\"", (Object)item.getName());
            }
            this._addIconBox.setSelectedIndex(-1);
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
    }

    public JmriJFrame makeFrame(String name) {
        JmriJFrame targetFrame = new JmriJFrame(name);
        targetFrame.setVisible(false);
        JMenuBar menuBar = new JMenuBar();
        JMenu editMenu = new JMenu(Bundle.getMessage("MenuEdit"));
        menuBar.add(editMenu);
        editMenu.add(new AbstractAction(Bundle.getMessage("OpenEditor")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelEditor.this.setVisible(true);
            }
        });
        editMenu.addSeparator();
        editMenu.add(new AbstractAction(Bundle.getMessage("DeletePanel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PanelEditor.this.deletePanel()) {
                    PanelEditor.this.dispose();
                }
            }
        });
        targetFrame.setJMenuBar(menuBar);
        JMenu markerMenu = new JMenu(Bundle.getMessage("MenuMarker"));
        menuBar.add(markerMenu);
        markerMenu.add(new AbstractAction(Bundle.getMessage("AddLoco")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelEditor.this.locoMarkerFromInput();
            }
        });
        markerMenu.add(new AbstractAction(Bundle.getMessage("AddLocoRoster")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelEditor.this.locoMarkerFromRoster();
            }
        });
        markerMenu.add(new AbstractAction(Bundle.getMessage("RemoveMarkers")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelEditor.this.removeMarkers();
            }
        });
        JMenu warrantMenu = WarrantTableAction.getDefault().makeWarrantMenu(this.isEditable());
        if (warrantMenu != null) {
            menuBar.add(warrantMenu);
        }
        targetFrame.addHelpMenu("package.jmri.jmrit.display.PanelTarget", true);
        return targetFrame;
    }

    @Override
    protected void targetWindowClosingEvent(WindowEvent e) {
        this.targetWindowClosing();
    }

    @Override
    protected void paintTargetPanel(Graphics g) {
    }

    @Override
    protected void setNextLocation(Positionable obj) {
        int x = Integer.parseInt(this.nextX.getText());
        int y = Integer.parseInt(this.nextY.getText());
        obj.setLocation(x, y);
    }

    @Override
    protected void showPopUp(Positionable p, MouseEvent event) {
        if (!((JComponent)((Object)p)).isVisible()) {
            return;
        }
        JPopupMenu popup = new JPopupMenu();
        PositionablePopupUtil util = p.getPopupUtility();
        if (p.isEditable()) {
            if (p.doViemMenu()) {
                popup.add(p.getNameString());
                this.setPositionableMenu(p, popup);
                if (p.isPositionable()) {
                    this.setShowCoordinatesMenu(p, popup);
                    this.setShowAlignmentMenu(p, popup);
                }
                this.setDisplayLevelMenu(p, popup);
                this.setHiddenMenu(p, popup);
                this.setEditIdMenu(p, popup);
                popup.addSeparator();
            }
            boolean popupSet = false;
            popupSet = p.setRotateOrthogonalMenu(popup);
            popupSet |= p.setRotateMenu(popup);
            if (popupSet |= p.setScaleMenu(popup)) {
                popup.addSeparator();
            }
            if (popupSet = p.setEditIconMenu(popup)) {
                popup.addSeparator();
            }
            popupSet = p.setTextEditMenu(popup);
            if (util != null) {
                util.setFixedTextMenu(popup);
                util.setTextMarginMenu(popup);
                util.setTextBorderMenu(popup);
                util.setTextFontMenu(popup);
                util.setBackgroundMenu(popup);
                util.setTextJustificationMenu(popup);
                util.setTextOrientationMenu(popup);
                util.copyItem(popup);
                popup.addSeparator();
                util.propertyUtil(popup);
                util.setAdditionalEditPopUpMenu(popup);
                popupSet = true;
            }
            if (popupSet) {
                popup.addSeparator();
            }
            p.setDisableControlMenu(popup);
            p.showPopUp(popup);
            this.setRemoveMenu(p, popup);
        } else {
            p.showPopUp(popup);
            if (util != null) {
                util.setAdditionalViewPopUpMenu(popup);
            }
        }
        popup.show((Component)((Object)p), p.getWidth() / 2, p.getHeight() / 2);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.setToolTip(null);
        if (log.isDebugEnabled()) {
            log.debug("mousePressed at ({},{}) _dragging= {}", new Object[]{event.getX(), event.getY(), this._dragging});
        }
        this._anchorX = event.getX();
        this._anchorY = event.getY();
        this._lastX = this._anchorX;
        this._lastY = this._anchorY;
        List<Positionable> selections = this.getSelectedItems(event);
        if (this._dragging) {
            return;
        }
        if (selections.size() > 0) {
            this._currentSelection = event.isShiftDown() && selections.size() > 1 ? selections.get(1) : selections.get(0);
            if (event.isPopupTrigger()) {
                log.debug("mousePressed calls showPopUp");
                if (this.isMetaDown(event) || event.isAltDown()) {
                    this.delayedPopupTrigger = true;
                } else if (this._selectionGroup != null) {
                    this.showMultiSelectPopUp(event, this._currentSelection);
                } else {
                    this.showPopUp(this._currentSelection, event);
                }
            } else if (!event.isControlDown()) {
                this._currentSelection.doMousePressed(event);
                if (this._multiItemCopyGroup != null && !this._multiItemCopyGroup.contains(this._currentSelection)) {
                    this._multiItemCopyGroup = null;
                }
            }
        } else if (event.isPopupTrigger()) {
            if (this.isMetaDown(event) || event.isAltDown()) {
                this.delayedPopupTrigger = true;
            } else if (this._multiItemCopyGroup != null) {
                this.pasteItemPopUp(event);
            } else if (this._selectionGroup != null) {
                this.showMultiSelectPopUp(event, this._currentSelection);
            } else {
                this.backgroundPopUp(event);
                this._currentSelection = null;
            }
        } else {
            this._currentSelection = null;
        }
        if (!(event.isControlDown() || this.isMetaDown(event) || event.isAltDown())) {
            if (this._currentSelection == null && this._multiItemCopyGroup == null || this._selectRect != null && !this._selectRect.contains(this._anchorX, this._anchorY)) {
                this._selectRect = new Rectangle(this._anchorX, this._anchorY, 0, 0);
                this._selectionGroup = null;
            } else {
                this._selectRect = null;
                this._selectionGroup = null;
            }
        }
        this._targetPanel.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.setToolTip(null);
        if (log.isDebugEnabled()) {
            log.debug("mouseReleased at ({},{}) dragging= {} selectRect is {}", new Object[]{event.getX(), event.getY(), this._dragging, this._selectRect == null ? "null" : "not null"});
        }
        List<Positionable> selections = this.getSelectedItems(event);
        if (this._dragging) {
            this.mouseDragged(event);
        }
        if (selections.size() > 0) {
            this._currentSelection = event.isShiftDown() && selections.size() > 1 ? selections.get(1) : selections.get(0);
            if (this._multiItemCopyGroup != null && !this._multiItemCopyGroup.contains(this._currentSelection)) {
                this._multiItemCopyGroup = null;
            }
        } else if ((event.isPopupTrigger() || this.delayedPopupTrigger) && !this._dragging) {
            if (this._multiItemCopyGroup != null) {
                this.pasteItemPopUp(event);
            } else {
                this.backgroundPopUp(event);
                this._currentSelection = null;
            }
        } else {
            this._currentSelection = null;
        }
        if ((event.isPopupTrigger() || this.delayedPopupTrigger) && this._currentSelection != null && !this._dragging) {
            if (this._selectionGroup != null) {
                this.showMultiSelectPopUp(event, this._currentSelection);
            } else {
                this.showPopUp(this._currentSelection, event);
            }
        } else {
            if (this._currentSelection != null && !this._dragging && !event.isControlDown()) {
                this._currentSelection.doMouseReleased(event);
            }
            if (this.allPositionable() && this._selectRect != null && this._selectionGroup == null && this._dragging) {
                this.makeSelectionGroup(event);
            }
        }
        this.delayedPopupTrigger = false;
        this._dragging = false;
        this._selectRect = null;
        if (InstanceManager.getDefault(GuiLafPreferencesManager.class).isNonStandardMouseEvent()) {
            this.mouseClicked(event);
        }
        this._targetPanel.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.setToolTip(null);
        if (event.isPopupTrigger() || !this.isMetaDown(event) && !event.isAltDown()) {
            if (this._currentSelection != null) {
                List<Positionable> selections = this.getSelectedItems(event);
                if (selections.size() > 0) {
                    if (selections.get(0) != this._currentSelection) {
                        this._currentSelection.doMouseReleased(event);
                    } else {
                        this._currentSelection.doMouseDragged(event);
                    }
                } else {
                    this._currentSelection.doMouseReleased(event);
                }
            }
            return;
        }
        if (this._currentSelection != null && this.getFlag(1, this._currentSelection.isPositionable())) {
            int deltaX = event.getX() - this._lastX;
            int deltaY = event.getY() - this._lastY;
            int minX = this.getItemX(this._currentSelection, deltaX);
            int minY = this.getItemY(this._currentSelection, deltaY);
            if (this._selectionGroup != null && this._selectionGroup.contains(this._currentSelection)) {
                for (Positionable comp : this._selectionGroup) {
                    minX = Math.min(this.getItemX(comp, deltaX), minX);
                    minY = Math.min(this.getItemY(comp, deltaY), minY);
                }
            }
            if (minX >= 0 && minY >= 0) {
                if (this._selectionGroup != null && this._selectionGroup.contains(this._currentSelection)) {
                    for (Positionable comp : this._selectionGroup) {
                        this.moveItem(comp, deltaX, deltaY);
                    }
                    this._highlightcomponent = null;
                } else {
                    this.moveItem(this._currentSelection, deltaX, deltaY);
                    this._highlightcomponent = new Rectangle(this._currentSelection.getX(), this._currentSelection.getY(), this._currentSelection.maxWidth(), this._currentSelection.maxHeight());
                }
            }
        } else if (this.allPositionable() && this._selectionGroup == null) {
            this.drawSelectRect(event.getX(), event.getY());
        }
        this._dragging = true;
        this._lastX = event.getX();
        this._lastY = event.getY();
        this._targetPanel.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (this._dragging || event.isPopupTrigger()) {
            return;
        }
        List<Positionable> selections = this.getSelectedItems(event);
        Positionable selection = null;
        if (selections.size() > 0) {
            selection = event.isShiftDown() && selections.size() > 1 ? selections.get(1) : selections.get(0);
        }
        if (this.isEditable() && selection != null && selection.getDisplayLevel() > 1) {
            this._highlightcomponent = new Rectangle(selection.getX(), selection.getY(), selection.maxWidth(), selection.maxHeight());
            this._targetPanel.repaint();
        } else {
            this._highlightcomponent = null;
            this._targetPanel.repaint();
        }
        if (selection != null && selection.getDisplayLevel() > 1 && selection.showToolTip()) {
            this.showToolTip(selection, event);
            this._targetPanel.repaint();
        } else {
            this.setToolTip(null);
            this._highlightcomponent = null;
            this._targetPanel.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        List<Positionable> selections;
        this.setToolTip(null);
        if (log.isDebugEnabled()) {
            log.debug("mouseClicked at ({},{}) dragging= {} selectRect is {}", new Object[]{event.getX(), event.getY(), this._dragging, this._selectRect == null ? "null" : "not null"});
        }
        if ((selections = this.getSelectedItems(event)).size() > 0) {
            this._currentSelection = event.isShiftDown() && selections.size() > 1 ? selections.get(1) : selections.get(0);
        } else {
            this._currentSelection = null;
            if (event.isPopupTrigger()) {
                if (this._multiItemCopyGroup == null) {
                    this.pasteItemPopUp(event);
                } else {
                    this.backgroundPopUp(event);
                }
            }
        }
        if (event.isPopupTrigger() && this._currentSelection != null && !this._dragging) {
            if (this._selectionGroup != null) {
                this.showMultiSelectPopUp(event, this._currentSelection);
            } else {
                this.showPopUp(this._currentSelection, event);
            }
        } else if (this._currentSelection != null && !this._dragging && !event.isControlDown()) {
            this._currentSelection.doMouseClicked(event);
        }
        this._targetPanel.repaint();
        if (event.isControlDown() && this._currentSelection != null && !event.isPopupTrigger()) {
            this.amendSelectionGroup(this._currentSelection);
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.setToolTip(null);
        this._targetPanel.repaint();
    }

    @Override
    protected void copyItem(Positionable p) {
        this._multiItemCopyGroup = new ArrayList();
        this._multiItemCopyGroup.add(p);
    }

    protected void pasteItemPopUp(MouseEvent event) {
        if (!this.isEditable()) {
            return;
        }
        if (this._multiItemCopyGroup == null) {
            return;
        }
        JPopupMenu popup = new JPopupMenu();
        JMenuItem edit = new JMenuItem(Bundle.getMessage("MenuItemPaste"));
        edit.addActionListener(e -> this.pasteItem(event));
        this.setBackgroundMenu(popup);
        this.showAddItemPopUp(event, popup);
        popup.add(edit);
        popup.show(event.getComponent(), event.getX(), event.getY());
    }

    protected void backgroundPopUp(MouseEvent event) {
        if (!this.isEditable()) {
            return;
        }
        JPopupMenu popup = new JPopupMenu();
        this.setBackgroundMenu(popup);
        this.showAddItemPopUp(event, popup);
        popup.show(event.getComponent(), event.getX(), event.getY());
    }

    protected void showMultiSelectPopUp(MouseEvent event, Positionable p) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem copy = new JMenuItem(Bundle.getMessage("MenuItemCopy"));
        if (p.isPositionable()) {
            this.setShowAlignmentMenu(p, popup);
        }
        copy.addActionListener(e -> {
            this._multiItemCopyGroup = new ArrayList();
            if (this._selectionGroup != null) {
                this._multiItemCopyGroup.addAll(this._selectionGroup);
            }
        });
        this.setMultiItemsPositionableMenu(popup);
        this.setRemoveMenu(p, popup);
        popup.add(copy);
        popup.show(event.getComponent(), event.getX(), event.getY());
    }

    protected void showAddItemPopUp(MouseEvent event, JPopupMenu popup) {
        if (!this.isEditable()) {
            return;
        }
        JMenu _add = new JMenu(Bundle.getMessage("MenuItemAddItem"));
        this.addItemPopUp(new ComboBoxItem(RIGHT_TURNOUT), _add);
        this.addItemPopUp(new ComboBoxItem(LEFT_TURNOUT), _add);
        this.addItemPopUp(new ComboBoxItem(SLIP_TO_EDITOR), _add);
        this.addItemPopUp(new ComboBoxItem(SENSOR), _add);
        this.addItemPopUp(new ComboBoxItem(SIGNAL_HEAD), _add);
        this.addItemPopUp(new ComboBoxItem(SIGNAL_MAST), _add);
        this.addItemPopUp(new ComboBoxItem(MEMORY), _add);
        this.addItemPopUp(new ComboBoxItem(BLOCK_LABEL), _add);
        this.addItemPopUp(new ComboBoxItem(REPORTER), _add);
        this.addItemPopUp(new ComboBoxItem(LIGHT), _add);
        this.addItemPopUp(new ComboBoxItem(BACKGROUND), _add);
        this.addItemPopUp(new ComboBoxItem(MULTI_SENSOR), _add);
        this.addItemPopUp(new ComboBoxItem(RPSREPORTER), _add);
        this.addItemPopUp(new ComboBoxItem(FAST_CLOCK), _add);
        this.addItemPopUp(new ComboBoxItem(ICON), _add);
        this.addItemPopUp(new ComboBoxItem("Text"), _add);
        popup.add(_add);
    }

    protected void addItemPopUp(final ComboBoxItem item, JMenu menu) {
        ActionListener a = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelEditor.this.addItemViaMouseClick = true;
                PanelEditor.this.getIconFrame(item.getName());
            }

            ActionListener init(ComboBoxItem i) {
                return this;
            }
        }.init(item);
        JMenuItem addto = new JMenuItem(item.toString());
        addto.addActionListener(a);
        menu.add(addto);
    }

    @Override
    public void putItem(Positionable l) throws Positionable.DuplicateIdException {
        super.putItem(l);
        if (this.pasteItemFlag) {
            this.amendSelectionGroup(l);
            return;
        }
        if (this.addItemViaMouseClick) {
            this.addItemViaMouseClick = false;
            l.setLocation(this._lastX, this._lastY);
        }
    }

    private void amendSelectionGroup(Positionable p) {
        if (p == null) {
            return;
        }
        if (this._selectionGroup == null) {
            this._selectionGroup = new ArrayList();
        }
        boolean removed = false;
        int i = 0;
        while (i < this._selectionGroup.size()) {
            if (this._selectionGroup.get(i) == p) {
                this._selectionGroup.remove(i);
                removed = true;
                break;
            }
            ++i;
        }
        if (!removed) {
            this._selectionGroup.add(p);
        } else if (this._selectionGroup.isEmpty()) {
            this._selectionGroup = null;
        }
        this._targetPanel.repaint();
    }

    protected void pasteItem(MouseEvent e) {
        this.pasteItemFlag = true;
        if (this._multiItemCopyGroup != null) {
            int x = this._multiItemCopyGroup.get(0).getX();
            int y = this._multiItemCopyGroup.get(0).getY();
            int xoffset = e.getX() - x;
            int yoffset = e.getY() - y;
            ArrayList<Positionable> _copyOfMultiItemCopyGroup = new ArrayList<Positionable>(this._multiItemCopyGroup);
            Collections.copy(_copyOfMultiItemCopyGroup, this._multiItemCopyGroup);
            for (Positionable comp : _copyOfMultiItemCopyGroup) {
                JComponent copied = (JComponent)((Object)comp);
                int xOrig = copied.getX();
                int yOrig = copied.getY();
                x = xOrig + xoffset;
                y = yOrig + yoffset;
                if (x < 0) {
                    x = 1;
                }
                if (y < 0) {
                    y = 1;
                }
                String className = ConfigXmlManager.adapterName(copied);
                copied.setLocation(x, y);
                try {
                    XmlAdapter adapter = (XmlAdapter)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Element el = adapter.store(copied);
                    adapter.load(el, this);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | RuntimeException | InvocationTargetException | JmriConfigureXmlException ex) {
                    log.debug(ex.getLocalizedMessage(), (Throwable)ex);
                }
                this.amendSelectionGroup(comp);
                copied.setLocation(xOrig, yOrig);
            }
            this._selectionGroup = null;
        }
        this.pasteItemFlag = false;
        this._targetPanel.repaint();
    }

    @Override
    public void setRemoveMenu(Positionable p, JPopupMenu popup) {
        popup.add(new AbstractAction(Bundle.getMessage("Remove")){
            Positionable comp;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PanelEditor.this._selectionGroup == null) {
                    this.comp.remove();
                } else {
                    PanelEditor.this.removeMultiItems();
                }
            }

            AbstractAction init(Positionable pos) {
                this.comp = pos;
                return this;
            }
        }.init(p));
    }

    private void removeMultiItems() {
        boolean itemsInCopy = false;
        if (this._selectionGroup == this._multiItemCopyGroup) {
            itemsInCopy = true;
        }
        for (Positionable comp : this._selectionGroup) {
            comp.remove();
        }
        this._selectionGroup = null;
        if (itemsInCopy) {
            this._multiItemCopyGroup = null;
        }
    }

    private void setMultiItemsPositionableMenu(JPopupMenu popup) {
        JCheckBoxMenuItem lockItem = new JCheckBoxMenuItem(Bundle.getMessage("LockPosition"));
        boolean allSetToMove = false;
        int trues = 0;
        int size = this._selectionGroup.size();
        for (Positionable comp : this._selectionGroup) {
            if (!comp.isPositionable()) {
                allSetToMove = true;
                ++trues;
            }
            lockItem.setSelected(allSetToMove);
            lockItem.addActionListener(new ActionListener(){
                Positionable comp;
                JCheckBoxMenuItem checkBox;

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.comp.setPositionable(!this.checkBox.isSelected());
                    PanelEditor.this.setSelectionsPositionable(!this.checkBox.isSelected(), this.comp);
                }

                ActionListener init(Positionable pos, JCheckBoxMenuItem cb) {
                    this.comp = pos;
                    this.checkBox = cb;
                    return this;
                }
            }.init(comp, lockItem));
        }
        if (trues != size && trues != 0) {
            lockItem.setText("~ " + lockItem.getText());
            lockItem.setSelected(false);
        }
        popup.add(lockItem);
    }

    public void setBackgroundMenu(JPopupMenu popup) {
        JMenuItem edit = new JMenuItem(Bundle.getMessage("FontBackgroundColor"));
        edit.addActionListener(event -> {
            Color desiredColor = JmriColorChooser.showDialog(this, Bundle.getMessage("FontBackgroundColor"), this.getBackgroundColor());
            if (desiredColor != null) {
                this.setBackgroundColor(desiredColor);
            }
        });
        popup.add(edit);
    }

    protected boolean isMetaDown(MouseEvent event) {
        if (SystemType.isWindows() || SystemType.isLinux()) {
            return SwingUtilities.isRightMouseButton(event);
        }
        return event.isMetaDown();
    }

    static class ComboBoxItem {
        private final String name;

        protected ComboBoxItem(String n) {
            this.name = n;
        }

        protected String getName() {
            return this.name;
        }

        public String toString() {
            String bundleName = PanelEditor.SENSOR.equals(this.name) ? "BeanNameSensor" : (PanelEditor.SIGNAL_HEAD.equals(this.name) ? "BeanNameSignalHead" : (PanelEditor.SIGNAL_MAST.equals(this.name) ? "BeanNameSignalMast" : (PanelEditor.MEMORY.equals(this.name) ? "BeanNameMemory" : (PanelEditor.REPORTER.equals(this.name) ? "BeanNameReporter" : (PanelEditor.LIGHT.equals(this.name) ? "BeanNameLight" : this.name)))));
            return Bundle.getMessage(bundleName);
        }
    }
}

