/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.palette;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.DisplayFrame;
import jmri.jmrit.display.LinkingLabel;
import jmri.jmrit.display.MemoryComboIcon;
import jmri.jmrit.display.MemoryIcon;
import jmri.jmrit.display.MemoryInputIcon;
import jmri.jmrit.display.MemorySpinnerIcon;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableLabel;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.jmrit.display.PreviewPanel;
import jmri.jmrit.display.SensorIcon;
import jmri.jmrit.display.palette.Bundle;
import jmri.jmrit.display.palette.DragJComponent;
import jmri.jmrit.display.palette.FontPanel;
import jmri.jmrit.display.palette.ItemPalette;
import jmri.jmrit.display.palette.ItemPanel;
import jmri.util.swing.ImagePanel;
import jmri.util.swing.JmriColorChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextItemPanel
extends ItemPanel {
    private final ImagePanel _samplePanel;
    private PositionablePopupUtil _util;
    private final HashMap<String, PositionableLabel> _samples;
    private String _selectedState;
    private boolean _isPositionableLabel;
    private JComponent _textEditComponent;
    private JTabbedPane _tabPane;
    private final ButtonGroup _buttonGroup = new ButtonGroup();
    private AJRadioButton _fontButton;
    private AJRadioButton _borderButton;
    private AJRadioButton _backgroundButton;
    protected int _selectedButton;
    protected JColorChooser _chooser;
    protected AJSpinner _borderSpin;
    protected AJSpinner _marginSpin;
    private AJSpinner _widthSpin;
    private AJSpinner _heightSpin;
    public static final int BORDER = 1;
    public static final int MARGIN = 2;
    public static final int FWIDTH = 3;
    public static final int FHEIGHT = 4;
    static final int FOREGROUND_BUTTON = 1;
    static final int BACKGROUND_BUTTON = 2;
    static final int TRANSPARENT_BUTTON = 3;
    static final int BORDERCOLOR_BUTTON = 4;
    JPanel dragger;
    private static final Logger log = LoggerFactory.getLogger(TextItemPanel.class);

    public TextItemPanel(DisplayFrame parentFrame, String type) {
        super(parentFrame, type);
        this.setToolTipText(Bundle.getMessage("ToolTipDragText"));
        this._samples = new HashMap();
        this._samplePanel = new ImagePanel();
        this._samplePanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this._samplePanel.setName("SamplePanel");
        this._samplePanel.setImage(this._frame.getPreviewBackground());
    }

    @Override
    public void init() {
        if (!this._initialized) {
            JPanel dragger;
            this.add(this.instructions());
            PositionableLabel label = new PositionableLabel(Bundle.getMessage("sample"), this._frame.getEditor());
            label.setLevel(4);
            try {
                dragger = new LabelDragJComponent(new DataFlavor("application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable"), label);
            }
            catch (ClassNotFoundException cnfe) {
                log.error("Unable to find class supporting {}", (Object)"application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable", (Object)cnfe);
                dragger = new JPanel();
            }
            this._util = label.getPopupUtility();
            this._samples.put("Text", label);
            this._selectedState = "Text";
            this._isPositionableLabel = true;
            this._textEditComponent = this.makeTextPanel("Text", label, true);
            this._samplePanel.add(dragger);
            this._previewPanel = new PreviewPanel(this._frame, this._samplePanel, null, true);
            this.sampleBgColorChange();
            log.debug("LabelDragJComponent size {} | panel size {}", (Object)label.getPreferredSize(), (Object)this._samplePanel.getPreferredSize());
            this.finishInit(false);
            dragger.setOpaque(false);
            dragger.setToolTipText(Bundle.getMessage("ToolTipDragIcon"));
            if (log.isDebugEnabled()) {
                log.debug("end init: TextItemPanel size {}", (Object)this.getPreferredSize());
            }
            super.init();
        }
    }

    public void init(ActionListener doneAction, Positionable pos) {
        boolean hasTextStates;
        this._update = true;
        this._doneAction = doneAction;
        Positionable item = pos.deepClone();
        this._util = item.getPopupUtility();
        item.remove();
        this._isPositionableLabel = pos instanceof PositionableLabel;
        this._previewPanel = new PreviewPanel(this._frame, this._samplePanel, null, false);
        this.sampleBgColorChange();
        if (pos instanceof SensorIcon && !((SensorIcon)pos).isIcon()) {
            SensorIcon si = (SensorIcon)pos;
            hasTextStates = true;
            if (!si.isIcon() && si.isText()) {
                this._tabPane = new JTabbedPane();
                this._tabPane.addChangeListener(c -> {
                    TextPanel panel = (TextPanel)this._tabPane.getSelectedComponent();
                    this._selectedState = panel.getState();
                    log.debug("StateChange");
                    this.setChooserColor();
                });
                PositionableLabel sample = new PositionableLabel(si.getActiveText(), this._frame.getEditor());
                sample.setForeground(si.getTextActive());
                sample.setBackground(si.getBackgroundActive());
                JPanel panel = this.doPopupUtility("SensorStateActive", sample, true);
                this._tabPane.add((Component)panel, Bundle.getMessage("SensorStateActive"));
                sample = new PositionableLabel(si.getInactiveText(), this._frame.getEditor());
                sample.setForeground(si.getTextInActive());
                sample.setBackground(si.getBackgroundInActive());
                panel = this.doPopupUtility("SensorStateInactive", sample, true);
                this._tabPane.add((Component)panel, Bundle.getMessage("SensorStateInactive"));
                sample = new PositionableLabel(si.getUnknownText(), this._frame.getEditor());
                sample.setForeground(si.getTextUnknown());
                sample.setBackground(si.getBackgroundUnknown());
                panel = this.doPopupUtility("BeanStateUnknown", sample, true);
                this._tabPane.add((Component)panel, Bundle.getMessage("BeanStateUnknown"));
                sample = new PositionableLabel(si.getInconsistentText(), this._frame.getEditor());
                sample.setForeground(si.getTextInconsistent());
                sample.setBackground(si.getBackgroundInconsistent());
                panel = this.doPopupUtility("BeanStateInconsistent", sample, true);
                this._tabPane.add((Component)panel, Bundle.getMessage("BeanStateInconsistent"));
                this._textEditComponent = this._tabPane;
            }
        } else {
            boolean addtextField;
            hasTextStates = false;
            PositionableLabel sample = new PositionableLabel("", this._frame.getEditor());
            sample.setForeground(this._util.getForeground());
            sample.setBackground(this._util.getBackground());
            PositionablePopupUtil util = sample.getPopupUtility();
            util.setHasBackground(this._util.hasBackground());
            if (pos instanceof PositionableLabel) {
                sample.setText(((PositionableLabel)pos).getUnRotatedText());
                addtextField = !(pos instanceof MemoryIcon);
            } else {
                util.setFixedWidth(pos.getWidth() - 2 * this._util.getBorderSize());
                util.setFixedHeight(pos.getHeight() - 2 * this._util.getBorderSize());
                if (pos instanceof MemoryInputIcon) {
                    JTextField field = (JTextField)pos.getTextComponent();
                    sample.setText(field.getText());
                    addtextField = false;
                } else if (pos instanceof MemoryComboIcon) {
                    JComponent box = ((MemoryComboIcon)pos).getTextComponent();
                    sample.setText(((JComboBox)box).getSelectedItem() != null ? ((JComboBox)box).getSelectedItem().toString() : "");
                    addtextField = false;
                } else if (pos instanceof MemorySpinnerIcon) {
                    JTextField field = (JTextField)pos.getTextComponent();
                    sample.setText(field.getText());
                    addtextField = false;
                } else {
                    addtextField = true;
                    log.error("Unknown Postionable Type {}", (Object)pos.getClass().getName());
                }
            }
            this._textEditComponent = this.doPopupUtility("Text", sample, addtextField);
            if (log.isDebugEnabled()) {
                log.debug("util width= {} height= {} POS width= {} height= {}", new Object[]{util.getFixedWidth(), util.getFixedHeight(), pos.getWidth(), pos.getHeight()});
            }
        }
        this.finishInit(hasTextStates);
        this._bottomPanel = new JPanel();
        JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
        cancelButton.addActionListener(a -> this.cancel());
        this._bottomPanel.add(cancelButton);
        this._bottomPanel.add(this.makeUpdateButton(this._doneAction));
        this.add(this._bottomPanel);
    }

    protected void cancel() {
        this._frame.dispose();
    }

    @Override
    protected JPanel instructions() {
        JPanel blurb = new JPanel();
        blurb.setLayout(new BoxLayout(blurb, 1));
        blurb.add(new JLabel(Bundle.getMessage("addTextAndAttrs")));
        blurb.add(new JLabel(Bundle.getMessage("ToolTipDragText")));
        blurb.add(Box.createVerticalStrut(5));
        JPanel panel = new JPanel();
        panel.add(blurb);
        return panel;
    }

    @Override
    protected void previewColorChange() {
        this._previewPanel.setBackgroundSelection(this._frame.getPreviewBg());
    }

    protected JPanel makeDoneButtonPanel(ActionListener doneAction) {
        JPanel panel = new JPanel();
        JButton updateButton = new JButton(Bundle.getMessage("updateButton"));
        updateButton.addActionListener(doneAction);
        updateButton.setToolTipText(Bundle.getMessage("ToolTipPickFromTable"));
        panel.add(updateButton);
        JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
        cancelButton.addActionListener(a -> this.closeDialogs());
        panel.add(cancelButton);
        return panel;
    }

    public void updateAttributes(PositionableLabel l) {
        this.setAttributes(l);
        PositionablePopupUtil util = this.getPositionablePopupUtil();
        l.setPopupUtility(util.clone(l, l.getTextComponent()));
        l.setFont(util.getFont().deriveFont(util.getFontStyle()));
        if (util.hasBackground()) {
            l.setOpaque(true);
        }
    }

    @Override
    protected JPanel makeSpecialBottomPanel(boolean update) {
        return null;
    }

    @Override
    protected JPanel makeItemButtonPanel() {
        return null;
    }

    @Override
    protected JPanel makeIconDisplayPanel(String k, HashMap<String, NamedIcon> m, boolean d) {
        return null;
    }

    @Override
    protected void initIconFamiliesPanel() {
    }

    @Override
    protected void hideIcons() {
    }

    @Override
    protected void makeFamiliesPanel() {
    }

    private void finishInit(boolean addCaption) {
        JPanel p;
        this._selectedButton = 1;
        this._selectedState = addCaption ? "SensorStateActive" : "Text";
        JPanel colorButtons = this.makeColorPanel(addCaption);
        this.makeColorChooser();
        JPanel panel = this.makeFontPanel();
        if (addCaption) {
            p = new JPanel();
            p.add(new JLabel(Bundle.getMessage("StateTextBlurb1")));
            panel.add(p);
        }
        this.add(panel);
        if (addCaption) {
            p = new JPanel();
            p.add(new JLabel(Bundle.getMessage("StateTextBlurb3")));
            this.add(p);
        }
        JPanel textEditPanel = new JPanel();
        textEditPanel.setLayout(new BoxLayout(textEditPanel, 1));
        textEditPanel.add(this._textEditComponent);
        this.add(textEditPanel);
        this.add(this._previewPanel);
        this.add(Box.createVerticalGlue());
        this.add(colorButtons);
        this.add(this._chooser);
    }

    private JPanel doPopupUtility(String type, PositionableLabel sample, boolean editText) {
        PositionablePopupUtil util = sample.getPopupUtility();
        util.setJustification(this._util.getJustification());
        util.setHorizontalAlignment(this._util.getJustification());
        if (this._isPositionableLabel) {
            int size = this._util.getFixedWidth();
            util.setFixedWidth(size);
            size = this._util.getFixedHeight();
            util.setFixedHeight(size);
        }
        util.setMargin(this._util.getMargin());
        util.setBorderSize(this._util.getBorderSize());
        util.setBorderColor(this._util.getBorderColor());
        util.setFont(util.getFont().deriveFont(this._util.getFontStyle()));
        util.setFontSize(this._util.getFontSize());
        util.setFontStyle(this._util.getFontStyle());
        util.setOrientation(this._util.getOrientation());
        boolean back = sample.getBackground() != null;
        util.setHasBackground(back);
        sample.setOpaque(back);
        sample.updateSize();
        this._samples.put(type, sample);
        this._selectedState = type;
        JPanel panel = this.makeTextPanel(type, sample, editText);
        this._samplePanel.add(sample);
        return panel;
    }

    private void makeColorChooser() {
        Color panelBackground = this._frame.getEditor().getTargetPanel().getBackground();
        this._chooser = JmriColorChooser.extendColorChooser(new JColorChooser(panelBackground));
        this._chooser.getSelectionModel().addChangeListener(c -> this.chooserColorChange());
        this._chooser.setPreviewPanel(new JPanel());
        JmriColorChooser.suppressAddRecentColor(true);
    }

    private void fontChange() {
        log.debug("fontChange");
        if (this._selectedButton != 1) {
            this._selectedButton = 1;
            this._fontButton.setSelected(true);
        }
        this.updateSamples();
    }

    private JPanel makeFontPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black, 1), Bundle.getMessage("FontDisplaySettings")));
        ActionListener fontAction = event -> this.fontChange();
        FontPanel fontPanel = new FontPanel(this._util, fontAction);
        panel.add(fontPanel);
        fontPanel.setFontSelections();
        SpinnerChangeListener listener = new SpinnerChangeListener();
        JPanel sizePanel = new JPanel();
        SpinnerNumberModel model = new SpinnerNumberModel(this._util.getBorderSize(), 0, 100, 1);
        this._borderSpin = new AJSpinner(model, 1);
        sizePanel.add(TextItemPanel.makeSpinPanel("borderSize", this._borderSpin, listener));
        model = new SpinnerNumberModel(this._util.getMargin(), 0, 100, 1);
        this._marginSpin = new AJSpinner(model, 2);
        sizePanel.add(TextItemPanel.makeSpinPanel("marginSize", this._marginSpin, listener));
        if (this._isPositionableLabel) {
            model = new SpinnerNumberModel(this._util.getFixedWidth(), 0, 1000, 1);
            this._widthSpin = new AJSpinner(model, 3);
            sizePanel.add(TextItemPanel.makeSpinPanel("fixedWidth", this._widthSpin, listener));
            model = new SpinnerNumberModel(this._util.getFixedHeight(), 0, 1000, 1);
            this._heightSpin = new AJSpinner(model, 4);
            sizePanel.add(TextItemPanel.makeSpinPanel("fixedHeight", this._heightSpin, listener));
        }
        panel.add(sizePanel);
        return panel;
    }

    public static JPanel makeSpinPanel(String caption, JSpinner spin, ChangeListener listener) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JLabel(Bundle.getMessage(caption)));
        spin.addChangeListener(listener);
        panel.add(spin);
        return panel;
    }

    private JPanel makeTextPanel(String beanState, JLabel sample, boolean addTextField) {
        TextPanel panel = new TextPanel(beanState);
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black, 1), Bundle.getMessage(beanState)));
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel p = new JPanel();
        if (addTextField) {
            JTextField textField = new JTextField(sample.getText(), 25);
            textField.addKeyListener(new KeyListener(){
                JLabel sample;

                KeyListener init(JLabel s) {
                    this.sample = s;
                    return this;
                }

                @Override
                public void keyTyped(KeyEvent evt) {
                }

                @Override
                public void keyPressed(KeyEvent evt) {
                }

                @Override
                public void keyReleased(KeyEvent evt) {
                    JTextField tmp = (JTextField)evt.getSource();
                    this.sample.setText(tmp.getText());
                    TextItemPanel.this.updateSamples();
                }
            }.init(sample));
            p.add(textField);
            panel.add(p);
        }
        return panel;
    }

    private JPanel makeColorPanel(boolean addCaption) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black, 1), Bundle.getMessage("ColorDisplaySettings")));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this._fontButton = this.makeColorRadioButton("FontColor", 1);
        buttonPanel.add(this._fontButton);
        this._backgroundButton = this.makeColorRadioButton("FontBackgroundColor", 2);
        buttonPanel.add(this._backgroundButton);
        AJRadioButton button = this.makeColorRadioButton("transparentBack", 3);
        buttonPanel.add(button);
        this._borderButton = this.makeColorRadioButton("borderColor", 4);
        buttonPanel.add(this._borderButton);
        panel.add(buttonPanel);
        if (addCaption) {
            JPanel p = new JPanel();
            p.add(new JLabel(Bundle.getMessage("StateTextBlurb2")));
            panel.add(p);
        }
        this._fontButton.setSelected(true);
        this._selectedButton = 1;
        return panel;
    }

    private AJRadioButton makeColorRadioButton(String caption, int which) {
        AJRadioButton button = new AJRadioButton(Bundle.getMessage(caption), which);
        button.addActionListener(a -> {
            if (button.isSelected()) {
                this._selectedButton = aJRadioButton._which;
                log.debug("Button #{} selected.", (Object)which);
                this.setChooserColor();
            }
        });
        this._buttonGroup.add(button);
        return button;
    }

    private void chooserColorChange() {
        PositionableLabel pos = this._samples.get(this._selectedState);
        PositionablePopupUtil util = pos.getPopupUtility();
        switch (this._selectedButton) {
            case 1: {
                util.setForeground(this._chooser.getColor());
                break;
            }
            case 2: {
                pos.setOpaque(true);
                util.setBackgroundColor(this._chooser.getColor());
                break;
            }
            case 3: {
                pos.setOpaque(false);
                break;
            }
            case 4: {
                this._util.setBorderColor(this._chooser.getColor());
                util.setBorderColor(this._chooser.getColor());
                break;
            }
            default: {
                log.warn("Unexpected color change for state {}, button# {}", (Object)this._selectedState, (Object)this._selectedButton);
            }
        }
        log.debug("chooserColorChange opaque= {} _selectedState= {} _selectedButton= {} color= {}", new Object[]{pos.isOpaque(), this._selectedState, this._selectedButton, this._chooser.getColor().toString()});
        this.updateSamples();
    }

    private void setChooserColor() {
        PositionableLabel pos = this._samples.get(this._selectedState);
        PositionablePopupUtil util = pos.getPopupUtility();
        Color c = null;
        switch (this._selectedButton) {
            case 1: {
                c = util.getForeground();
                break;
            }
            case 2: {
                c = util.getBackground();
                break;
            }
            case 4: {
                c = util.getBorderColor();
                break;
            }
            case 3: {
                util.setBackgroundColor(null);
                this.updateSamples();
                break;
            }
            default: {
                return;
            }
        }
        this._chooser.setColor(c);
    }

    protected void updateSamples() {
        boolean isPalette = this._frame instanceof ItemPalette;
        Dimension totalDim = this._frame.getSize();
        Dimension oldDim = this.getSize();
        int mar = this._util.getMargin();
        int bor = this._util.getBorderSize();
        Font font = this._util.getFont();
        int just = this._util.getJustification();
        for (PositionableLabel sam : this._samples.values()) {
            PositionablePopupUtil util = sam.getPopupUtility();
            sam.setFont(font);
            if (this._isPositionableLabel) {
                util.setFixedWidth(this._util.getFixedWidth());
                util.setFixedHeight(this._util.getFixedHeight());
            } else {
                util.setFixedWidth(util.getFixedWidth() + 2 * (mar - util.getMargin()));
                util.setFixedHeight(util.getFixedHeight() + 2 * (mar - util.getMargin()));
            }
            util.setMargin(mar);
            util.setBorderSize(bor);
            Border borderMargin = sam.isOpaque() ? new LineBorder(sam.getBackground(), mar) : BorderFactory.createEmptyBorder(mar, mar, mar, mar);
            Border outlineBorder = bor == 0 ? BorderFactory.createEmptyBorder(0, 0, 0, 0) : new LineBorder(this._util.getBorderColor(), bor);
            sam.setBorder(new CompoundBorder(outlineBorder, borderMargin));
            switch (just) {
                case 0: {
                    sam.setHorizontalAlignment(2);
                    break;
                }
                case 2: {
                    sam.setHorizontalAlignment(4);
                    break;
                }
                default: {
                    sam.setHorizontalAlignment(0);
                }
            }
            sam.updateSize();
            sam.setPreferredSize(sam.getSize());
            sam.invalidate();
            if (!log.isTraceEnabled()) continue;
            log.debug("util width= {} height= {} SAM width= {} height= {}", new Object[]{util.getFixedWidth(), util.getFixedHeight(), sam.getWidth(), sam.getHeight()});
            log.debug("margin = {}, border = {}, opaque= {}", new Object[]{util.getMargin(), util.getBorderSize(), sam.isOpaque()});
        }
        this._previewPanel.invalidate();
        this._textEditComponent.invalidate();
        if (this.dragger != null) {
            this.dragger.invalidate();
        }
        this._samplePanel.invalidate();
        this.reSizeDisplay(isPalette, oldDim, totalDim);
    }

    protected void sampleBgColorChange() {
        this._previewPanel.setBackgroundSelection(this._frame.getPreviewBg());
    }

    public PositionablePopupUtil getPositionablePopupUtil() {
        PositionableLabel pos = this._samples.get(this._selectedState);
        PositionablePopupUtil util = pos.getPopupUtility();
        this._util.setForeground(util.getForeground());
        this._util.setBackgroundColor(util.getBackground());
        this._util.setBorderColor(util.getBorderColor());
        return this._util;
    }

    public void setAttributes(Positionable pos) {
        if (pos instanceof SensorIcon && !((SensorIcon)pos).isIcon()) {
            SensorIcon icon = (SensorIcon)pos;
            PositionableLabel sample = this._samples.get("SensorStateActive");
            if (sample.isOpaque()) {
                icon.setBackgroundActive(sample.getBackground());
            } else {
                icon.setBackgroundActive(null);
            }
            icon.setTextActive(sample.getForeground());
            icon.setActiveText(sample.getText());
            sample = this._samples.get("SensorStateInactive");
            icon.setInactiveText(sample.getText());
            if (sample.isOpaque()) {
                icon.setBackgroundInActive(sample.getBackground());
            } else {
                icon.setBackgroundInActive(null);
            }
            icon.setTextInActive(sample.getForeground());
            sample = this._samples.get("BeanStateUnknown");
            icon.setUnknownText(sample.getText());
            if (sample.isOpaque()) {
                icon.setBackgroundUnknown(sample.getBackground());
            } else {
                icon.setBackgroundUnknown(null);
            }
            icon.setTextUnknown(sample.getForeground());
            sample = this._samples.get("BeanStateInconsistent");
            icon.setInconsistentText(sample.getText());
            if (sample.isOpaque()) {
                icon.setBackgroundInconsistent(sample.getBackground());
            } else {
                icon.setBackgroundInconsistent(null);
            }
            icon.setTextInconsistent(sample.getForeground());
        } else {
            PositionableLabel sample = this._samples.get("Text");
            if (pos instanceof PositionableLabel && !(pos instanceof MemoryIcon)) {
                ((PositionableLabel)pos).setText(sample.getText());
            }
            PositionablePopupUtil posUtil = pos.getPopupUtility();
            PositionablePopupUtil samUtil = sample.getPopupUtility();
            if (sample.isOpaque()) {
                posUtil.setBackgroundColor(samUtil.getBackground());
            } else {
                posUtil.setBackgroundColor(null);
            }
            posUtil.setHasBackground(samUtil.hasBackground());
            posUtil.setForeground(samUtil.getForeground());
            posUtil.setBorderColor(samUtil.getBorderColor());
            posUtil.setFont(samUtil.getFont());
            posUtil.setFixedWidth(samUtil.getFixedWidth());
            posUtil.setFixedHeight(samUtil.getFixedHeight());
            posUtil.setMargin(samUtil.getMargin());
            posUtil.setBorderSize(samUtil.getBorderSize());
        }
        pos.invalidate();
    }

    public void close() {
        JmriColorChooser.suppressAddRecentColor(false);
    }

    static class AJRadioButton
    extends JRadioButton {
        int _which;

        AJRadioButton(String text, int which) {
            super(text);
            this._which = which;
        }
    }

    static class AJSpinner
    extends JSpinner {
        int _which;

        AJSpinner(SpinnerModel model, int which) {
            super(model);
            this._which = which;
        }
    }

    protected class LabelDragJComponent
    extends DragJComponent {
        public LabelDragJComponent(DataFlavor flavor, JComponent comp) {
            super(flavor, comp);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                return null;
            }
            if (flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable")) {
                String link = TextItemPanel.this._linkName.getText().trim();
                PositionableLabel sample = (PositionableLabel)this.getThing();
                PositionableLabel label = link.length() == 0 ? new PositionableLabel(sample.getText(), sample.getEditor()) : new LinkingLabel(sample.getText(), sample.getEditor(), link);
                TextItemPanel.this.updateAttributes(label);
                label.setLevel(sample.getDisplayLevel());
                return label;
            }
            return null;
        }
    }

    private class SpinnerChangeListener
    implements ChangeListener {
        private SpinnerChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object obj = e.getSource();
            int num = ((Number)((AJSpinner)obj).getValue()).intValue();
            int which = ((AJSpinner)obj)._which;
            switch (which) {
                case 1: {
                    TextItemPanel.this._util.setBorderSize(num);
                    TextItemPanel.this._borderButton.setSelected(true);
                    TextItemPanel.this._selectedButton = 4;
                    break;
                }
                case 2: {
                    TextItemPanel.this._util.setMargin(num);
                    TextItemPanel.this._selectedButton = 2;
                    TextItemPanel.this._backgroundButton.setSelected(true);
                    break;
                }
                case 3: {
                    TextItemPanel.this._util.setFixedWidth(num);
                    TextItemPanel.this._selectedButton = 2;
                    TextItemPanel.this._backgroundButton.setSelected(true);
                    break;
                }
                case 4: {
                    TextItemPanel.this._util.setFixedHeight(num);
                    TextItemPanel.this._selectedButton = 2;
                    TextItemPanel.this._backgroundButton.setSelected(true);
                    break;
                }
                default: {
                    log.warn("Unexpected _which {}  in stateChanged", (Object)((AJSpinner)obj)._which);
                }
            }
            TextItemPanel.this.updateSamples();
            log.debug("SpinnerChange which= {}, num= {}", (Object)which, (Object)num);
        }
    }

    static class TextPanel
    extends JPanel {
        String _state;

        TextPanel(String state) {
            this._state = state;
        }

        String getState() {
            return this._state;
        }
    }
}

