/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.palette;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jmri.Light;
import jmri.NamedBean;
import jmri.jmrit.beantable.AbstractTableAction;
import jmri.jmrit.beantable.AddNewDevicePanel;
import jmri.jmrit.beantable.BeanTableFrame;
import jmri.jmrit.beantable.LightTableAction;
import jmri.jmrit.beantable.MemoryTableAction;
import jmri.jmrit.beantable.ReporterTableAction;
import jmri.jmrit.beantable.SensorTableAction;
import jmri.jmrit.beantable.SignalHeadTableAction;
import jmri.jmrit.beantable.SignalMastTableAction;
import jmri.jmrit.beantable.TurnoutTableAction;
import jmri.jmrit.catalog.DragJLabel;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.DisplayFrame;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.LightIcon;
import jmri.jmrit.display.SensorIcon;
import jmri.jmrit.display.SignalMastIcon;
import jmri.jmrit.display.TurnoutIcon;
import jmri.jmrit.display.palette.Bundle;
import jmri.jmrit.display.palette.FamilyItemPanel;
import jmri.jmrit.picker.PickListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableItemPanel<E extends NamedBean>
extends FamilyItemPanel
implements ListSelectionListener {
    int ROW_HEIGHT;
    protected JTable _table;
    protected PickListModel<E> _model;
    AbstractTableAction<E> _tableAction;
    JScrollPane _scrollPane;
    JDialog _addTableDialog;
    JTextField _sysNametext = new JTextField();
    JTextField _userNametext = new JTextField();
    JButton _addTableButton;
    private static final Logger log = LoggerFactory.getLogger(TableItemPanel.class);

    public TableItemPanel(DisplayFrame parentFrame, String type, String family, PickListModel<E> model) {
        super(parentFrame, type, family);
        this._model = model;
        this._tableAction = this.getTableAction(type);
    }

    @Override
    public void init() {
        if (!this._initialized) {
            super.init();
            this.add((Component)this.initTablePanel(this._model), 0);
        }
        this.hideIcons();
    }

    @Override
    public void init(ActionListener doneAction, HashMap<String, NamedIcon> iconMap) {
        super.init(doneAction, iconMap);
        this.add((Component)this.initTablePanel(this._model), 0);
    }

    private AbstractTableAction<?> getTableAction(String type) {
        switch (type) {
            case "IndicatorTO": 
            case "Turnout": {
                return new TurnoutTableAction(Bundle.getMessage("CreateNewItem"));
            }
            case "Sensor": 
            case "MultiSensor": {
                return new SensorTableAction(Bundle.getMessage("CreateNewItem"));
            }
            case "SignalHead": {
                return new SignalHeadTableAction(Bundle.getMessage("CreateNewItem"));
            }
            case "SignalMast": {
                return new SignalMastTableAction(Bundle.getMessage("CreateNewItem"));
            }
            case "Memory": {
                return new MemoryTableAction(Bundle.getMessage("CreateNewItem"));
            }
            case "Light": {
                return new LightTableAction(Bundle.getMessage("CreateNewItem"));
            }
            case "Reporter": {
                return new ReporterTableAction(Bundle.getMessage("CreateNewItem"));
            }
        }
        return null;
    }

    protected JPanel initTablePanel(PickListModel<E> model) {
        this._table = model.makePickTable();
        this.ROW_HEIGHT = this._table.getRowHeight();
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)new JLabel(model.getName(), 0), "North");
        this._scrollPane = new JScrollPane(this._table);
        int cnt = Math.max(Math.min(10, this._table.getRowCount()), 4);
        this._scrollPane.setPreferredSize(new Dimension(this._scrollPane.getPreferredSize().width, cnt * this.ROW_HEIGHT));
        topPanel.add((Component)this._scrollPane, "Center");
        topPanel.setToolTipText(Bundle.getMessage("ToolTipDragTableRow"));
        JPanel panel = new JPanel();
        this._addTableButton = new JButton(Bundle.getMessage("CreateNewItem"));
        this._addTableButton.addActionListener(this._tableAction);
        this._addTableButton.setToolTipText(Bundle.getMessage("ToolTipAddToTable"));
        panel.add(this._addTableButton);
        JButton clearSelectionButton = new JButton(Bundle.getMessage("ClearSelection"));
        clearSelectionButton.addActionListener(a -> {
            this._table.clearSelection();
            this.hideIcons();
        });
        clearSelectionButton.setToolTipText(Bundle.getMessage("ToolTipClearSelection"));
        panel.add(clearSelectionButton);
        topPanel.add((Component)panel, "South");
        this._table.getSelectionModel().addListSelectionListener(this);
        this._table.setToolTipText(Bundle.getMessage("ToolTipDragTableRow"));
        this._scrollPane.setToolTipText(Bundle.getMessage("ToolTipDragTableRow"));
        topPanel.setToolTipText(Bundle.getMessage("ToolTipDragTableRow"));
        return topPanel;
    }

    protected void makeAddToTableWindow() {
        this._addTableDialog = new JDialog(this._frame, Bundle.getMessage("AddToTableTitle"), true);
        ActionListener cancelListener = this::cancelPressed;
        ActionListener okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                TableItemPanel.this.addToTable();
            }
        };
        AddNewDevicePanel addPanel = new AddNewDevicePanel(this._sysNametext, this._userNametext, "addToTable", okListener, cancelListener);
        this._addTableDialog.getContentPane().add(addPanel);
        this._addTableDialog.pack();
        this._addTableDialog.setSize(this._frame.getSize().width - 20, this._addTableDialog.getPreferredSize().height);
        this._addTableDialog.setLocation(10, 35);
        this._addTableDialog.setLocationRelativeTo(this._frame);
        this._addTableDialog.toFront();
        this._addTableDialog.setVisible(true);
    }

    void cancelPressed(ActionEvent e) {
        this._addTableDialog.setVisible(false);
        this._addTableDialog.dispose();
        this._addTableDialog = null;
    }

    protected void addToTable() {
        String sysname = this._sysNametext.getText();
        if (sysname != null && sysname.length() > 1) {
            String uname = this._userNametext.getText();
            if (uname != null && uname.trim().length() == 0) {
                uname = null;
            }
            try {
                E bean = this._model.addBean(sysname, uname);
                if (bean != null) {
                    int setRow = this._model.getIndexOf(bean);
                    if (log.isDebugEnabled()) {
                        log.debug("addToTable: row = {}, bean = {}", (Object)setRow, (Object)bean.getDisplayName());
                    }
                    this._table.setRowSelectionInterval(setRow, setRow);
                    this._scrollPane.getVerticalScrollBar().setValue(setRow * this.ROW_HEIGHT);
                }
                this._addTableDialog.dispose();
            }
            catch (IllegalArgumentException ex) {
                JOptionPane.showMessageDialog(this._frame, ex.getMessage(), Bundle.getMessage("WarningTitle"), 2);
            }
        }
        this._sysNametext.setText("");
        this._userNametext.setText("");
    }

    public E getTableSelection() {
        int row = this._table.getSelectedRow();
        if ((row = this._table.convertRowIndexToModel(row)) >= 0) {
            E b = this._model.getBeanAt(row);
            this._table.clearSelection();
            if (log.isDebugEnabled()) {
                log.debug("getTableSelection: row = {}, bean = {}", (Object)row, (Object)(b == null ? "null" : b.getDisplayName()));
            }
            return b;
        }
        if (log.isDebugEnabled()) {
            log.debug("getTableSelection: row = {}", (Object)row);
        }
        return null;
    }

    public void setSelection(E bean) {
        int row = this._model.getIndexOf(bean);
        row = this._table.convertRowIndexToView(row);
        log.debug("setSelection: NamedBean = {}, row = {}", bean, (Object)row);
        if (row >= 0) {
            this._table.addRowSelectionInterval(row, row);
            this._scrollPane.getVerticalScrollBar().setValue(row * this.ROW_HEIGHT);
        } else {
            this.valueChanged(null);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this._table == null) {
            return;
        }
        int row = this._table.getSelectedRow();
        log.debug("Table valueChanged: row = {}", (Object)row);
        if (this._updateButton != null) {
            if (row >= 0) {
                this._updateButton.setEnabled(true);
                this._updateButton.setToolTipText(null);
            } else {
                this._updateButton.setEnabled(false);
                this._updateButton.setToolTipText(Bundle.getMessage("ToolTipPickFromTable"));
            }
        }
        this.hideIcons();
    }

    protected E getDeviceNamedBean() {
        int row = this._table.getSelectedRow();
        log.debug("getDeviceNamedBean: from table \"{}\" at row {}", (Object)this._itemType, (Object)row);
        if (row < 0) {
            return null;
        }
        return this._model.getBySystemName((String)this._table.getValueAt(row, 0));
    }

    @Override
    protected String getDisplayKey() {
        if (this._itemType.equals("Turnout")) {
            return "TurnoutStateClosed";
        }
        if (this._itemType.equals("Sensor")) {
            return "SensorStateActive";
        }
        if (this._itemType.equals("Light")) {
            return "StateOn";
        }
        return null;
    }

    @Override
    public void closeDialogs() {
        if (this._tableAction != null) {
            this._tableAction.dispose();
            BeanTableFrame<E> frame = this._tableAction.getFrame();
            if (frame != null) {
                frame.dispose();
            }
        }
        super.closeDialogs();
    }

    @Override
    protected JLabel getDragger(DataFlavor flavor, HashMap<String, NamedIcon> map, NamedIcon icon) {
        return new IconDragJLabel(flavor, map, icon);
    }

    protected class IconDragJLabel
    extends DragJLabel {
        HashMap<String, NamedIcon> iMap;

        public IconDragJLabel(DataFlavor flavor, HashMap<String, NamedIcon> map, NamedIcon icon) {
            super(flavor, icon);
            this.iMap = map;
        }

        @Override
        protected boolean okToDrag() {
            Object bean = TableItemPanel.this.getDeviceNamedBean();
            if (bean == null) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("noRowSelected"), Bundle.getMessage("WarningTitle"), 2);
                return false;
            }
            return true;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            Object bean;
            block21: {
                if (!this.isDataFlavorSupported(flavor)) {
                    return null;
                }
                bean = TableItemPanel.this.getDeviceNamedBean();
                if (bean == null) {
                    return null;
                }
                Editor editor = TableItemPanel.this._frame.getEditor();
                if (!flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable")) break block21;
                switch (TableItemPanel.this._itemType) {
                    case "Turnout": {
                        TurnoutIcon t = new TurnoutIcon(editor);
                        t.setTurnout(bean.getDisplayName());
                        for (Map.Entry<String, NamedIcon> ent : this.iMap.entrySet()) {
                            t.setIcon(ent.getKey(), new NamedIcon(ent.getValue()));
                        }
                        t.setFamily(TableItemPanel.this._family);
                        t.setLevel(7);
                        return t;
                    }
                    case "Sensor": {
                        SensorIcon s = new SensorIcon(new NamedIcon("resources/icons/smallschematics/tracksegments/circuit-error.gif", "resources/icons/smallschematics/tracksegments/circuit-error.gif"), editor);
                        for (Map.Entry<String, NamedIcon> ent : this.iMap.entrySet()) {
                            s.setIcon(ent.getKey(), new NamedIcon(ent.getValue()));
                        }
                        s.setSensor(bean.getDisplayName());
                        s.setFamily(TableItemPanel.this._family);
                        s.setLevel(10);
                        return s;
                    }
                    case "SignalMast": {
                        SignalMastIcon sm = new SignalMastIcon(TableItemPanel.this._frame.getEditor());
                        sm.setSignalMast(bean.getDisplayName());
                        sm.setLevel(9);
                        return sm;
                    }
                    case "Light": {
                        LightIcon l = new LightIcon(editor);
                        l.setOffIcon(this.iMap.get("StateOff"));
                        l.setOnIcon(this.iMap.get("StateOn"));
                        l.setInconsistentIcon(this.iMap.get("BeanStateInconsistent"));
                        l.setUnknownIcon(this.iMap.get("BeanStateUnknown"));
                        l.setLight((Light)bean);
                        l.setLevel(8);
                        return l;
                    }
                }
                return null;
            }
            if (DataFlavor.stringFlavor.equals(flavor)) {
                return String.valueOf(TableItemPanel.this._itemType) + " icons for \"" + bean.getDisplayName() + "\"";
            }
            return null;
        }
    }
}

