/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.palette;

import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import jmri.SignalAppearanceMap;
import jmri.SignalMast;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.DisplayFrame;
import jmri.jmrit.display.palette.TableItemPanel;
import jmri.jmrit.picker.PickListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalMastItemPanel
extends TableItemPanel<SignalMast> {
    private SignalMast _mast;
    private static final Logger log = LoggerFactory.getLogger(SignalMastItemPanel.class);

    public SignalMastItemPanel(DisplayFrame parentFrame, String type, String family, PickListModel<SignalMast> model) {
        super(parentFrame, type, family, model);
        this._currentIconMap = new HashMap();
    }

    @Override
    public void init() {
        super.init();
        this._showIconsButton.setEnabled(this._mast != null);
    }

    @Override
    public void init(ActionListener doneAction, HashMap<String, NamedIcon> iconMap) {
        super.init(doneAction, iconMap);
    }

    @Override
    protected JPanel makeItemButtonPanel() {
        JPanel panel = new JPanel();
        panel.add(this.makeShowIconsButton());
        return panel;
    }

    @Override
    protected JPanel makeSpecialBottomPanel(boolean update) {
        JPanel panel = new JPanel();
        panel.add(this.makeShowIconsButton());
        return panel;
    }

    private void makeIconMap() {
        if (this._mast == null) {
            this._currentIconMap.clear();
            this._showIconsButton.setEnabled(false);
            return;
        }
        this._showIconsButton.setEnabled(true);
        this._family = this._mast.getSignalSystem().getSystemName();
        SignalAppearanceMap appMap = this._mast.getAppearanceMap();
        Enumeration<String> e = this._mast.getAppearanceMap().getAspects();
        while (e.hasMoreElements()) {
            String aspect = e.nextElement();
            String s = appMap.getImageLink(aspect, this._family);
            if (s == null || s.equals("")) continue;
            if (!s.contains("preference:")) {
                s = s.substring(s.indexOf("resources"));
            }
            NamedIcon n = new NamedIcon(s, s);
            this._currentIconMap.put(aspect, n);
        }
        if (log.isDebugEnabled()) {
            log.debug("makeIconMap for {}  size= {}", (Object)this._family, (Object)this._currentIconMap.size());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this._mast = (SignalMast)this.getDeviceNamedBean();
        this.makeIconMap();
        super.valueChanged(e);
        this.updateFamiliesPanel();
        this.setFamily();
        if (log.isDebugEnabled()) {
            log.debug("table valueChanged for= {}, row = {}", (Object)this._itemType, (Object)this._table.getSelectedRow());
        }
    }
}

