/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.palette;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import jmri.SignalHead;
import jmri.jmrit.catalog.DragJLabel;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.DisplayFrame;
import jmri.jmrit.display.SignalHeadIcon;
import jmri.jmrit.display.palette.Bundle;
import jmri.jmrit.display.palette.ItemPalette;
import jmri.jmrit.display.palette.TableItemPanel;
import jmri.jmrit.picker.PickListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalHeadItemPanel
extends TableItemPanel<SignalHead> {
    private static final Logger log = LoggerFactory.getLogger(SignalHeadItemPanel.class);

    public SignalHeadItemPanel(DisplayFrame parentFrame, String type, String family, PickListModel<SignalHead> model) {
        super(parentFrame, type, family, model);
    }

    @Override
    protected JPanel initTablePanel(PickListModel<SignalHead> model) {
        this._table = model.makePickTable();
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)new JLabel(model.getName(), 0), "North");
        this._scrollPane = new JScrollPane(this._table);
        topPanel.add((Component)this._scrollPane, "Center");
        this._table.getSelectionModel().addListSelectionListener(this);
        this._table.setToolTipText(Bundle.getMessage("ToolTipDragTableRow"));
        this._scrollPane.setToolTipText(Bundle.getMessage("ToolTipDragTableRow"));
        topPanel.setToolTipText(Bundle.getMessage("ToolTipDragTableRow"));
        JPanel panel = new JPanel();
        JButton clearSelectionButton = new JButton(Bundle.getMessage("ClearSelection"));
        clearSelectionButton.addActionListener(a -> this._table.clearSelection());
        clearSelectionButton.setToolTipText(Bundle.getMessage("ToolTipClearSelection"));
        panel.add(clearSelectionButton);
        topPanel.add((Component)panel, "South");
        return topPanel;
    }

    @Override
    protected String getDisplayKey() {
        return "SignalHeadStateGreen";
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this._table == null || this._updateButton == null) {
            return;
        }
        int row = this._table.getSelectedRow();
        if (this._table.getRowCount() < 2) {
            log.debug("Table valueChanged: row= {}, {}({})", new Object[]{row, this._table.getValueAt(row, 0), this._table.getValueAt(row, 1)});
        }
        if (row >= 0) {
            this._updateButton.setEnabled(true);
            this._updateButton.setToolTipText(null);
            if (this._family != null) {
                HashMap<String, NamedIcon> fullmap = this.getFilteredIconMap(this.makeNewIconMap(this._itemType));
                HashMap<String, NamedIcon> currentmap = this.getIconMap();
                log.debug("currentmap keys = {}", (Object)currentmap.keySet().toString());
                HashMap<String, NamedIcon> iconMap = new HashMap<String, NamedIcon>();
                for (Map.Entry<String, NamedIcon> entry : fullmap.entrySet()) {
                    String key = entry.getKey();
                    String newKey = ItemPalette.convertText(key);
                    log.debug("fullmap key = {}, converts to {}", (Object)key, (Object)newKey);
                    NamedIcon icon = currentmap.get(newKey);
                    if (icon != null) {
                        iconMap.put(newKey, icon);
                        continue;
                    }
                    iconMap.put(newKey, entry.getValue());
                }
                log.debug("set Signal Head {} map size= {}", this._table.getValueAt(row, 0), (Object)iconMap.size());
                this.updateFamiliesPanel();
            }
        } else {
            this._updateButton.setEnabled(false);
            this._updateButton.setToolTipText(Bundle.getMessage("ToolTipPickFromTable"));
        }
        if (this._iconPanel.isVisible()) {
            this.showIcons();
        }
    }

    protected HashMap<String, NamedIcon> getFilteredIconMap(HashMap<String, NamedIcon> allIconsMap) {
        if (allIconsMap == null) {
            JOptionPane.showMessageDialog(this._frame, Bundle.getMessage("FamilyNotFound", this._itemType, this._family), Bundle.getMessage("WarningTitle"), 2);
            return null;
        }
        if (this._table == null || this._table.getSelectedRow() < 0) {
            return allIconsMap;
        }
        SignalHead sh = (SignalHead)this.getDeviceNamedBean();
        if (sh != null) {
            String[] states = sh.getValidStateNames();
            if (states.length == 0) {
                return allIconsMap;
            }
            HashMap<String, NamedIcon> iconMap = new HashMap<String, NamedIcon>();
            block0: for (Map.Entry<String, NamedIcon> entry : allIconsMap.entrySet()) {
                String name = entry.getKey();
                String borderName = ItemPalette.convertText(name);
                String[] stringArray = states;
                int n = states.length;
                int n2 = 0;
                while (n2 < n) {
                    String state = stringArray[n2];
                    if (borderName.equals(state) || name.equals("SignalHeadStateDark") || name.equals(ItemPalette.convertText("SignalHeadStateDark")) || name.equals("SignalHeadStateHeld") || name.equals(ItemPalette.convertText("SignalHeadStateHeld"))) {
                        iconMap.put(name, entry.getValue());
                        continue block0;
                    }
                    ++n2;
                }
            }
            log.debug("filteredMap size= {}", (Object)iconMap.size());
            return iconMap;
        }
        log.debug("Map NOT filtered, size= {}", (Object)allIconsMap.size());
        return allIconsMap;
    }

    @Override
    protected JLabel getDragger(DataFlavor flavor, HashMap<String, NamedIcon> map, NamedIcon icon) {
        return new IconDragJLabel(flavor, map, icon);
    }

    protected class IconDragJLabel
    extends DragJLabel {
        HashMap<String, NamedIcon> iMap;

        public IconDragJLabel(DataFlavor flavor, HashMap<String, NamedIcon> map, NamedIcon icon) {
            super(flavor, icon);
            this.iMap = map;
        }

        @Override
        protected boolean okToDrag() {
            SignalHead bean = (SignalHead)SignalHeadItemPanel.this.getDeviceNamedBean();
            if (bean == null) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("noRowSelected"), Bundle.getMessage("WarningTitle"), 2);
                return false;
            }
            return true;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                return null;
            }
            SignalHead bean = (SignalHead)SignalHeadItemPanel.this.getDeviceNamedBean();
            if (bean == null) {
                return null;
            }
            if (flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable")) {
                SignalHeadIcon sh = new SignalHeadIcon(SignalHeadItemPanel.this._frame.getEditor());
                sh.setSignalHead(bean.getDisplayName());
                HashMap<String, NamedIcon> map = SignalHeadItemPanel.this.getFilteredIconMap(this.iMap);
                for (Map.Entry<String, NamedIcon> ent : map.entrySet()) {
                    sh.setIcon(ent.getKey(), new NamedIcon(ent.getValue()));
                }
                sh.setFamily(SignalHeadItemPanel.this._family);
                sh.setLevel(9);
                return sh;
            }
            if (DataFlavor.stringFlavor.equals(flavor)) {
                return String.valueOf(SignalHeadItemPanel.this._itemType) + " icons for \"" + bean.getDisplayName() + "\"";
            }
            return null;
        }
    }
}

