/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.palette;

import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jmri.Reporter;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.DisplayFrame;
import jmri.jmrit.display.ReporterIcon;
import jmri.jmrit.display.palette.Bundle;
import jmri.jmrit.display.palette.DragJComponent;
import jmri.jmrit.display.palette.TableItemPanel;
import jmri.jmrit.picker.PickListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReporterItemPanel
extends TableItemPanel<Reporter> {
    private final JPanel _dragPanel;
    private static final Logger log = LoggerFactory.getLogger(ReporterItemPanel.class);

    public ReporterItemPanel(DisplayFrame parentFrame, String type, String family, PickListModel<Reporter> model) {
        super(parentFrame, type, family, model);
        this._dragPanel = this.makeDraggerPanel(parentFrame);
        this._currentIconMap = new HashMap();
    }

    private JPanel makeDraggerPanel(DisplayFrame frame) {
        JPanel dragger;
        JPanel panel = new JPanel();
        panel.setToolTipText(Bundle.getMessage("ToolTipDragIcon"));
        panel.setOpaque(false);
        ReporterIcon reporter = new ReporterIcon(frame.getEditor());
        try {
            dragger = new IconDragJComponent(new DataFlavor("application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable"), reporter);
        }
        catch (ClassNotFoundException cnfe) {
            log.error("Unable to find class supporting {}", (Object)"application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable", (Object)cnfe);
            dragger = new JPanel();
        }
        dragger.setOpaque(false);
        dragger.setToolTipText(Bundle.getMessage("ToolTipDragIcon"));
        panel.add(dragger);
        int width = Math.max(100, panel.getPreferredSize().width);
        panel.setPreferredSize(new Dimension(width, panel.getPreferredSize().height));
        panel.setToolTipText(Bundle.getMessage("ToolTipDragIcon"));
        return panel;
    }

    @Override
    protected void makeDndIcon(HashMap<String, NamedIcon> iconMap) {
        this._dragIconPanel.add(this._dragPanel);
    }

    @Override
    protected JPanel makeItemButtonPanel() {
        JPanel panel = new JPanel();
        panel.add(this.makeShowIconsButton());
        return panel;
    }

    @Override
    protected JPanel makeSpecialBottomPanel(boolean update) {
        JPanel panel = new JPanel();
        panel.add(this.makeShowIconsButton());
        return panel;
    }

    protected class IconDragJComponent
    extends DragJComponent {
        public IconDragJComponent(DataFlavor flavor, JComponent comp) {
            super(flavor, comp);
        }

        @Override
        protected boolean okToDrag() {
            Reporter bean = (Reporter)ReporterItemPanel.this.getDeviceNamedBean();
            if (bean == null) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("noRowSelected"), Bundle.getMessage("WarningTitle"), 2);
                return false;
            }
            return true;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                return null;
            }
            Reporter bean = (Reporter)ReporterItemPanel.this.getDeviceNamedBean();
            if (bean == null) {
                return null;
            }
            if (flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable")) {
                ReporterIcon r = new ReporterIcon(ReporterItemPanel.this._frame.getEditor());
                r.setReporter(bean.getDisplayName());
                r.setLevel(5);
                return r;
            }
            if (DataFlavor.stringFlavor.equals(flavor)) {
                return String.valueOf(ReporterItemPanel.this._itemType) + " icon for \"" + bean.getDisplayName() + "\"";
            }
            return null;
        }
    }
}

