/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.palette;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.jmrit.catalog.DragJLabel;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.DisplayFrame;
import jmri.jmrit.display.RpsPositionIcon;
import jmri.jmrit.display.palette.Bundle;
import jmri.jmrit.display.palette.FamilyItemPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RPSItemPanel
extends FamilyItemPanel {
    private static final Logger log = LoggerFactory.getLogger(RPSItemPanel.class);

    public RPSItemPanel(DisplayFrame parentFrame, String type, String family) {
        super(parentFrame, type, family);
    }

    @Override
    protected JPanel instructions() {
        JPanel blurb = new JPanel();
        blurb.setLayout(new BoxLayout(blurb, 1));
        blurb.add(new JLabel(Bundle.getMessage("DragIconPanel")));
        JPanel panel = new JPanel();
        panel.add(blurb);
        return panel;
    }

    @Override
    protected String getDisplayKey() {
        return "active";
    }

    @Override
    protected JLabel getDragger(DataFlavor flavor, HashMap<String, NamedIcon> map, NamedIcon icon) {
        return new IconDragJLabel(flavor, map, icon);
    }

    protected class IconDragJLabel
    extends DragJLabel {
        HashMap<String, NamedIcon> iconMap;

        public IconDragJLabel(DataFlavor flavor, HashMap<String, NamedIcon> map, NamedIcon icon) {
            super(flavor, icon);
            this.iconMap = new HashMap<String, NamedIcon>(map);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return super.isDataFlavorSupported(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug("IconDragJLabel.getTransferData");
            }
            if (flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable")) {
                RpsPositionIcon r = new RpsPositionIcon(RPSItemPanel.this._frame.getEditor());
                r.setActiveIcon(new NamedIcon(this.iconMap.get("active")));
                r.setErrorIcon(new NamedIcon(this.iconMap.get("error")));
                r.setSize(r.getPreferredSize().width, r.getPreferredSize().height);
                r.setLevel(10);
                return r;
            }
            if (DataFlavor.stringFlavor.equals(flavor)) {
                return String.valueOf(RPSItemPanel.this._itemType) + " icons";
            }
            return null;
        }
    }
}

