/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.palette;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;
import jmri.Sensor;
import jmri.jmrit.catalog.DragJLabel;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.DisplayFrame;
import jmri.jmrit.display.MultiSensorIcon;
import jmri.jmrit.display.palette.Bundle;
import jmri.jmrit.display.palette.ItemPalette;
import jmri.jmrit.display.palette.TableItemPanel;
import jmri.jmrit.picker.PickListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiSensorItemPanel
extends TableItemPanel<Sensor> {
    JPanel _multiSensorPanel;
    MultiSensorSelectionModel _selectionModel;
    boolean _upDown = false;
    static final String[] POSITION = new String[]{"first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth", "nineth", "tenth", "eleventh", "twelfth"};
    private static final Logger log = LoggerFactory.getLogger(MultiSensorItemPanel.class);

    public MultiSensorItemPanel(DisplayFrame parentFrame, String type, String family, PickListModel<Sensor> model) {
        super(parentFrame, type, family, model);
        this.setToolTipText(Bundle.getMessage("ToolTipDragSelection"));
    }

    @Override
    protected JPanel initTablePanel(PickListModel<Sensor> model) {
        HashMap<String, NamedIcon> map;
        this._table = model.makePickTable();
        TableColumn column = new TableColumn(2);
        column.setHeaderValue("Position");
        this._table.addColumn(column);
        this._selectionModel = new MultiSensorSelectionModel(model);
        this._table.setSelectionModel(this._selectionModel);
        this._table.getSelectionModel().setSelectionMode(0);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)new JLabel(model.getName(), 0), "North");
        this._scrollPane = new JScrollPane(this._table);
        topPanel.add((Component)this._scrollPane, "Center");
        this._scrollPane.getVerticalScrollBar().setMaximum(100);
        topPanel.setToolTipText(Bundle.getMessage("ToolTipDragTableRow"));
        JPanel panel = new JPanel();
        this._addTableButton = new JButton(Bundle.getMessage("CreateNewItem"));
        this._addTableButton.addActionListener(a -> this.makeAddToTableWindow());
        this._addTableButton.setToolTipText(Bundle.getMessage("ToolTipAddToTable"));
        panel.add(this._addTableButton);
        int size = 6;
        if (this._family != null && (map = ItemPalette.getIconMap(this._itemType, this._family)) != null) {
            size = map.size();
        }
        this._selectionModel.setPositionRange(size - 3);
        JButton clearSelectionButton = new JButton(Bundle.getMessage("ClearSelection"));
        clearSelectionButton.addActionListener(a -> this.clearSelections());
        clearSelectionButton.setToolTipText(Bundle.getMessage("ToolTipClearSelection"));
        panel.add(clearSelectionButton);
        topPanel.add((Component)panel, "South");
        this._table.setToolTipText(Bundle.getMessage("ToolTipDragTableRow"));
        this._scrollPane.setToolTipText(Bundle.getMessage("ToolTipDragTableRow"));
        topPanel.setToolTipText(Bundle.getMessage("ToolTipDragTableRow"));
        return topPanel;
    }

    public void clearSelections() {
        this._selectionModel.clearSelection();
        int size = 6;
        HashMap<String, NamedIcon> map = this.getIconMap();
        if (map != null) {
            size = map.size();
        }
        this._selectionModel.setPositionRange(size - 3);
    }

    @Override
    protected String getDisplayKey() {
        return "second";
    }

    @Override
    protected void initIconFamiliesPanel() {
        super.initIconFamiliesPanel();
        if (this._multiSensorPanel == null) {
            this.makeMultiSensorPanel();
            this._iconFamilyPanel.add(this._multiSensorPanel);
        }
    }

    private void makeMultiSensorPanel() {
        this._multiSensorPanel = new JPanel();
        this._multiSensorPanel.setLayout(new BoxLayout(this._multiSensorPanel, 1));
        JPanel panel2 = new JPanel();
        ButtonGroup group2 = new ButtonGroup();
        JRadioButton button = new JRadioButton(Bundle.getMessage("LeftRight"));
        button.addActionListener(e -> {
            boolean bl = this._upDown = false;
        });
        group2.add(button);
        panel2.add(button);
        button.setSelected(true);
        button = new JRadioButton(Bundle.getMessage("UpDown"));
        button.addActionListener(e -> {
            boolean bl = this._upDown = true;
        });
        group2.add(button);
        panel2.add(button);
        this._multiSensorPanel.add(panel2);
        this._multiSensorPanel.repaint();
    }

    @Override
    protected void setFamily(String family) {
        super.setFamily(family);
        if (this._multiSensorPanel == null) {
            this.makeMultiSensorPanel();
            this._iconFamilyPanel.add(this._multiSensorPanel);
        }
        this._iconFamilyPanel.repaint();
        this.updateFamiliesPanel();
        this.setSelections();
    }

    protected void setSelections() {
        int[] positions = this._selectionModel.getPositions();
        this.clearSelections();
        int len = Math.min(positions.length, this._selectionModel.getPositions().length);
        int i = 0;
        while (i < len) {
            if (positions[i] > -1) {
                this._selectionModel.setSelectionInterval(positions[i], positions[i]);
            }
            ++i;
        }
    }

    public ArrayList<Sensor> getTableSelections() {
        return this._selectionModel.getSelections();
    }

    public int[] getPositions() {
        return this._selectionModel.getPositions();
    }

    public boolean getUpDown() {
        return this._upDown;
    }

    @Override
    public void setSelection(Sensor bean) {
        int row = this._model.getIndexOf(bean);
        if (row >= 0) {
            this._selectionModel.setSelectionInterval(row, row);
            JScrollBar bar = this._scrollPane.getVerticalScrollBar();
            int numRows = this._model.getRowCount();
            bar.setValue((int)((float)(row * bar.getMaximum()) / (float)numRows));
        } else {
            this.valueChanged(null);
        }
    }

    public void setUpDown(boolean upDown) {
        this._upDown = upDown;
    }

    public static String getPositionName(int index) {
        return POSITION[index];
    }

    @Override
    protected JLabel getDragger(DataFlavor flavor, HashMap<String, NamedIcon> map, NamedIcon icon) {
        return new IconDragJLabel(flavor, map, icon);
    }

    public boolean oktoUpdate() {
        ArrayList<Sensor> selections = this._selectionModel.getSelections();
        if (selections == null || selections.isEmpty()) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("noRowSelected"), Bundle.getMessage("WarningTitle"), 2);
            return false;
        }
        if (selections.size() < this._selectionModel.getPositions().length) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("NeedPosition", this._selectionModel.getPositions().length), Bundle.getMessage("WarningTitle"), 2);
            return false;
        }
        return this.getIconMap() != null;
    }

    protected class IconDragJLabel
    extends DragJLabel {
        HashMap<String, NamedIcon> iconMap;

        public IconDragJLabel(DataFlavor flavor, HashMap<String, NamedIcon> map, NamedIcon icon) {
            super(flavor, icon);
            this.iconMap = new HashMap<String, NamedIcon>(map);
        }

        @Override
        protected boolean okToDrag() {
            return MultiSensorItemPanel.this.oktoUpdate();
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                return null;
            }
            if (this.iconMap == null) {
                log.error("IconDragJLabel.getTransferData: iconMap is null!");
                return null;
            }
            ArrayList<Sensor> selections = MultiSensorItemPanel.this._selectionModel.getSelections();
            if (selections == null || selections.size() < MultiSensorItemPanel.this._selectionModel.getPositions().length) {
                return null;
            }
            if (flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable")) {
                if (MultiSensorItemPanel.this._itemType.equals("MultiSensor")) {
                    MultiSensorIcon ms = new MultiSensorIcon(MultiSensorItemPanel.this._frame.getEditor());
                    ms.setInactiveIcon(new NamedIcon(this.iconMap.get("SensorStateInactive")));
                    ms.setInconsistentIcon(new NamedIcon(this.iconMap.get("BeanStateInconsistent")));
                    ms.setUnknownIcon(new NamedIcon(this.iconMap.get("BeanStateUnknown")));
                    int i = 0;
                    while (i < selections.size()) {
                        ms.addEntry(selections.get(i).getDisplayName(), new NamedIcon(this.iconMap.get(POSITION[i])));
                        ++i;
                    }
                    MultiSensorItemPanel.this._selectionModel.clearSelection();
                    ms.setFamily(MultiSensorItemPanel.this._family);
                    ms.setUpDown(MultiSensorItemPanel.this._upDown);
                    ms.setLevel(10);
                    return ms;
                }
            } else if (DataFlavor.stringFlavor.equals(flavor)) {
                StringBuilder sb = new StringBuilder(MultiSensorItemPanel.this._itemType);
                sb.append(" icons for ");
                int i = 0;
                while (i < selections.size()) {
                    sb.append(selections.get(i).getDisplayName());
                    if (i < selections.size() - 1) {
                        sb.append(", ");
                    }
                    ++i;
                }
                return sb.toString();
            }
            return null;
        }
    }

    protected class MultiSensorSelectionModel
    extends DefaultListSelectionModel {
        ArrayList<Sensor> _selections;
        int[] _positions;
        int _nextPosition;
        PickListModel<Sensor> _tableModel;

        MultiSensorSelectionModel(PickListModel<Sensor> tableModel) {
            this._tableModel = tableModel;
            this.setPositionRange(0);
        }

        protected ArrayList<Sensor> getSelections() {
            if (log.isDebugEnabled()) {
                log.debug("getSelections: size = {}, _nextPosition = {}", (Object)this._selections.size(), (Object)this._nextPosition);
            }
            return this._selections;
        }

        protected int[] getPositions() {
            int[] positions = new int[this._positions.length];
            System.arraycopy(this._positions, 0, positions, 0, this._positions.length);
            return positions;
        }

        protected int getNextPosition() {
            return this._nextPosition;
        }

        protected void setPositionRange(int size) {
            if (log.isDebugEnabled()) {
                log.debug("setPositionRange: size= {}", (Object)size);
            }
            if (size > POSITION.length) {
                size = POSITION.length;
            }
            if (size < 0) {
                size = 0;
            }
            this._positions = new int[size];
            int i = 0;
            while (i < size) {
                this._positions[i] = -1;
                ++i;
            }
            this._selections = new ArrayList(size);
            this._nextPosition = 0;
        }

        @Override
        public boolean isSelectedIndex(int index) {
            int[] nArray = this._positions;
            int n = this._positions.length;
            int n2 = 0;
            while (n2 < n) {
                int position = nArray[n2];
                if (position == index) {
                    log.debug("isSelectedIndex({}) returned true", (Object)index);
                    return true;
                }
                ++n2;
            }
            log.debug("isSelectedIndex({}) returned false", (Object)index);
            return false;
        }

        @Override
        public void clearSelection() {
            log.debug("clearSelection()");
            int i = 0;
            while (i < this._positions.length) {
                if (this._positions[i] >= 0) {
                    MultiSensorItemPanel.this._table.setValueAt(null, this._positions[i], 2);
                    super.setSelectionInterval(this._positions[i], this._positions[i]);
                    super.clearSelection();
                    this._positions[i] = -1;
                }
                ++i;
            }
            this._selections = new ArrayList(this._positions.length);
            this._nextPosition = 0;
        }

        @Override
        public void addSelectionInterval(int index0, int index1) {
            log.debug("addSelectionInterval({}), {}) - stubbed", (Object)index0, (Object)index1);
        }

        @Override
        public void setSelectionInterval(int row, int index1) {
            Sensor bean;
            if (this._nextPosition >= this._positions.length) {
                JOptionPane.showMessageDialog(MultiSensorItemPanel.this._frame, Bundle.getMessage("NeedIcon", MultiSensorItemPanel.this._selectionModel.getPositions().length), Bundle.getMessage("WarningTitle"), 2);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("setSelectionInterval({}, {})", (Object)row, (Object)index1);
            }
            if ((bean = this._tableModel.getBySystemName((String)MultiSensorItemPanel.this._table.getValueAt(row, 0))) == null) {
                return;
            }
            String position = (String)this._tableModel.getValueAt(row, 2);
            if (position != null && position.length() > 0) {
                JOptionPane.showMessageDialog(MultiSensorItemPanel.this._frame, Bundle.getMessage("DuplicatePosition", bean.getDisplayName(), position), Bundle.getMessage("WarningTitle"), 2);
            } else {
                MultiSensorItemPanel.this._table.setValueAt(Bundle.getMessage(POSITION[this._nextPosition]), row, 2);
                this._selections.add(this._nextPosition, bean);
                this._positions[this._nextPosition] = row;
                ++this._nextPosition;
                super.setSelectionInterval(row, row);
            }
        }
    }
}

