/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.palette;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import jmri.Memory;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.DisplayFrame;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.MemoryComboIcon;
import jmri.jmrit.display.MemoryIcon;
import jmri.jmrit.display.MemoryInputIcon;
import jmri.jmrit.display.MemorySpinnerIcon;
import jmri.jmrit.display.PreviewPanel;
import jmri.jmrit.display.palette.Bundle;
import jmri.jmrit.display.palette.DragJComponent;
import jmri.jmrit.display.palette.TableItemPanel;
import jmri.jmrit.picker.PickListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryItemPanel
extends TableItemPanel<Memory>
implements ChangeListener {
    JSpinner _spinner;
    String[] list = new String[]{"Item1", "Item2", "Item3"};
    MemoryIcon _readMem;
    MemoryInputIcon _writeMem;
    MemorySpinnerIcon _spinMem;
    MemoryComboIcon _comboMem;
    private static final Logger log = LoggerFactory.getLogger(MemoryItemPanel.class);

    public MemoryItemPanel(DisplayFrame parentFrame, String type, String family, PickListModel<Memory> model) {
        super(parentFrame, type, family, model);
    }

    @Override
    public void init() {
        if (!this._initialized) {
            this.add(this.initTablePanel(this._model));
            this.initIconFamiliesPanel();
            this.add(this._iconFamilyPanel);
            this._previewPanel = new PreviewPanel(this._frame, this._dragIconPanel, this._iconPanel, true);
            this.add(this._previewPanel);
            this._initialized = true;
        }
    }

    @Override
    protected JPanel instructions() {
        JPanel blurb = new JPanel();
        blurb.setLayout(new BoxLayout(blurb, 1));
        blurb.add(Box.createVerticalStrut(5));
        blurb.add(new JLabel(Bundle.getMessage("AddMemoryToPanel")));
        blurb.add(new JLabel(Bundle.getMessage("MemoryDragStart")));
        blurb.add(new JLabel(Bundle.getMessage("MemoryDragFix")));
        blurb.add(Box.createVerticalStrut(5));
        blurb.add(new JLabel(Bundle.getMessage("DecorateMemory")));
        blurb.add(Box.createVerticalStrut(5));
        JPanel panel = new JPanel();
        panel.add(blurb);
        return panel;
    }

    @Override
    protected void hideIcons() {
    }

    @Override
    protected void initIconFamiliesPanel() {
        this._iconFamilyPanel = new JPanel();
        this._iconFamilyPanel.setLayout(new BoxLayout(this._iconFamilyPanel, 1));
        this._iconFamilyPanel.setOpaque(true);
        if (!this._update) {
            this._iconFamilyPanel.add(this.instructions());
        }
        this.makeDragIconPanel();
        this.makeDndIcon(null);
        log.debug("initIconFamiliesPanel done");
    }

    @Override
    protected void makeDndIcon(HashMap<String, NamedIcon> iconMap) {
        if (this._update) {
            return;
        }
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new GridBagLayout());
        Editor editor = this._frame.getEditor();
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 10;
        c.weightx = 1.0;
        JLabel label = new JLabel(Bundle.getMessage("ReadWriteMemory"));
        label.setOpaque(false);
        panel.add((Component)label, c);
        c.gridy = 1;
        this._writeMem = new MemoryInputIcon(5, editor);
        panel.add((Component)this.makeDragIcon(this._writeMem, Type.READWRITE), c);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 10;
        label = new JLabel(Bundle.getMessage("ReadMemory"));
        label.setOpaque(false);
        panel.add((Component)label, c);
        c.gridy = 1;
        this._readMem = new MemoryIcon("_____", editor);
        panel.add((Component)this.makeDragIcon(this._readMem, Type.READONLY), c);
        c.gridx = 2;
        c.gridy = 0;
        label = new JLabel(Bundle.getMessage("SpinnerMemory"));
        label.setOpaque(false);
        panel.add((Component)label, c);
        c.gridy = 1;
        this._spinMem = new MemorySpinnerIcon(editor);
        panel.add((Component)this.makeDragIcon(this._spinMem, Type.SPINNER), c);
        c.gridx = 3;
        c.gridy = 0;
        label = new JLabel(Bundle.getMessage("ComboMemory"));
        label.setOpaque(false);
        panel.add((Component)label, c);
        c.gridy = 1;
        String[] list = new String[]{"item1", "Item2", "Item3"};
        this._comboMem = new MemoryComboIcon(editor, list);
        panel.add((Component)this.makeDragIcon(this._comboMem, Type.COMBO), c);
        this._spinner = new JSpinner(new SpinnerNumberModel(0, 0, 100, 1));
        JFormattedTextField field = ((JSpinner.DefaultEditor)this._spinner.getEditor()).getTextField();
        field.setColumns(2);
        field.setText("5");
        this._spinner.setMaximumSize(this._spinner.getPreferredSize());
        this._spinner.addChangeListener(this);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 2;
        c.anchor = 10;
        panel.add((Component)this._spinner, c);
        c.gridy = 3;
        c.anchor = 11;
        label = new JLabel(Bundle.getMessage("MemoryWidth"));
        label.setOpaque(false);
        panel.add((Component)label, c);
        this._dragIconPanel.add(panel);
        this._dragIconPanel.invalidate();
    }

    private JPanel makeDragIcon(JComponent mem, Type type) {
        JPanel comp;
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        try {
            comp = this.getDragger(new DataFlavor("application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable"), type, mem);
            comp.setOpaque(false);
            comp.setToolTipText(Bundle.getMessage("ToolTipDragIcon"));
        }
        catch (ClassNotFoundException cnfe) {
            log.error("Unable to find class supporting {}", (Object)"application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable", (Object)cnfe);
            comp = new JPanel();
        }
        panel.add(comp);
        return panel;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("stateChanged: class= {}, value= {}", (Object)this._spinner.getValue().getClass().getName(), this._spinner.getValue());
        }
        Integer nCols = (Integer)this._spinner.getValue();
        this._writeMem.setNumColumns(nCols);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this._table == null) {
            return;
        }
        int row = this._table.getSelectedRow();
        log.debug("Table valueChanged: row= {}", (Object)row);
        if (row >= 0) {
            if (this._updateButton != null) {
                this._updateButton.setEnabled(true);
                this._updateButton.setToolTipText(null);
            }
        } else {
            if (this._updateButton != null) {
                this._updateButton.setEnabled(false);
                this._updateButton.setToolTipText(Bundle.getMessage("ToolTipPickFromTable"));
            }
            this._dragIconPanel.removeAll();
            this.makeDragIconPanel();
            this.makeDndIcon(null);
        }
        this.validate();
    }

    protected IconDragJComponent getDragger(DataFlavor flavor, Type type, JComponent comp) {
        return new IconDragJComponent(flavor, type, comp);
    }

    protected class IconDragJComponent
    extends DragJComponent {
        Type _memType;

        public IconDragJComponent(DataFlavor flavor, Type type, JComponent comp) {
            super(flavor, comp);
            this._memType = type;
        }

        @Override
        protected boolean okToDrag() {
            Memory bean = (Memory)MemoryItemPanel.this.getDeviceNamedBean();
            if (bean == null) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("noRowSelected"), Bundle.getMessage("WarningTitle"), 2);
                return false;
            }
            return true;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                return null;
            }
            Memory bean = (Memory)MemoryItemPanel.this.getDeviceNamedBean();
            if (bean == null) {
                log.error("IconDragJComponent.getTransferData: Memory is null!");
                return null;
            }
            Editor editor = MemoryItemPanel.this._frame.getEditor();
            if (flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable")) {
                int numCols = 5;
                try {
                    ((JSpinner.DefaultEditor)MemoryItemPanel.this._spinner.getEditor()).commitEdit();
                    SpinnerNumberModel spinModel = (SpinnerNumberModel)MemoryItemPanel.this._spinner.getModel();
                    if (log.isDebugEnabled()) {
                        log.debug("MemoryDnD.createTransferable: spinCols= {}", (Object)spinModel.getNumber().intValue());
                    }
                    numCols = spinModel.getNumber().intValue();
                }
                catch (ParseException pe) {
                    log.error("MemoryDnD.createTransferable: ", (Throwable)pe);
                }
                switch (this._memType) {
                    case READONLY: {
                        MemoryIcon m = new MemoryIcon("", editor);
                        m.setMemory(bean.getDisplayName());
                        m.getPopupUtility().setFixedWidth(numCols * 10);
                        m.setLevel(5);
                        return m;
                    }
                    case READWRITE: {
                        MemoryInputIcon mi = new MemoryInputIcon(numCols, editor);
                        mi.setMemory(bean.getDisplayName());
                        mi.setSize(mi.getPreferredSize().width, mi.getPreferredSize().height);
                        mi.setLevel(5);
                        return mi;
                    }
                    case SPINNER: {
                        MemorySpinnerIcon ms = new MemorySpinnerIcon(editor);
                        ms.setMemory(bean.getDisplayName());
                        ms.setSize(ms.getPreferredSize().width, ms.getPreferredSize().height);
                        ms.setLevel(5);
                        return ms;
                    }
                    case COMBO: {
                        MemoryComboIcon mc = new MemoryComboIcon(editor, MemoryItemPanel.this.list);
                        mc.setMemory(bean.getDisplayName());
                        mc.setSize(mc.getPreferredSize().width, mc.getPreferredSize().height);
                        mc.setLevel(5);
                        return mc;
                    }
                }
            } else if (DataFlavor.stringFlavor.equals(flavor)) {
                return String.valueOf(MemoryItemPanel.this._itemType) + " icons for \"" + bean.getDisplayName() + "\"";
            }
            return null;
        }
    }

    static enum Type {
        READONLY,
        READWRITE,
        SPINNER,
        COMBO;

    }
}

