/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.palette;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.jmrit.catalog.CatalogPanel;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.DisplayFrame;
import jmri.jmrit.display.PreviewPanel;
import jmri.jmrit.display.palette.Bundle;
import jmri.jmrit.display.palette.FamilyItemPanel;
import jmri.jmrit.display.palette.IconItemPanel;
import jmri.jmrit.display.palette.IndicatorTOItemPanel;
import jmri.jmrit.display.palette.ItemPalette;
import jmri.util.swing.ImagePanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ItemPanel
extends JPanel {
    protected DisplayFrame _frame;
    protected String _itemType;
    protected boolean _initialized = false;
    protected boolean _update = false;
    protected boolean _suppressDragging;
    protected boolean _askOnce = false;
    protected JTextField _linkName = new JTextField(30);
    protected PreviewPanel _previewPanel;
    protected HashMap<String, NamedIcon> _currentIconMap;
    protected ImagePanel _iconPanel;
    protected JPanel _iconFamilyPanel;
    protected JPanel _bottomPanel;
    protected ActionListener _doneAction;
    protected boolean _wasEmpty;
    protected JPanel _instructions;
    static final String[] TURNOUT = new String[]{"TurnoutStateClosed", "TurnoutStateThrown", "BeanStateInconsistent", "BeanStateUnknown"};
    static final String[] SENSOR = new String[]{"SensorStateActive", "SensorStateInactive", "BeanStateInconsistent", "BeanStateUnknown"};
    static final String[] SIGNALHEAD = new String[]{"SignalHeadStateRed", "SignalHeadStateYellow", "SignalHeadStateGreen", "SignalHeadStateDark", "SignalHeadStateHeld", "SignalHeadStateLunar", "SignalHeadStateFlashingRed", "SignalHeadStateFlashingYellow", "SignalHeadStateFlashingGreen", "SignalHeadStateFlashingLunar"};
    static final String[] LIGHT = new String[]{"StateOff", "StateOn", "BeanStateInconsistent", "BeanStateUnknown"};
    static final String[] MULTISENSOR = new String[]{"SensorStateInactive", "BeanStateInconsistent", "BeanStateUnknown", "first", "second", "third"};
    static final String[] RPSREPORTER = new String[]{"active", "error"};
    static final String[] INDICATOR_TRACK = new String[]{"ClearTrack", "OccupiedTrack", "PositionTrack", "AllocatedTrack", "DontUseTrack", "ErrorTrack"};
    static final String[] PORTAL = new String[]{"hidden", "block", "path", "toArrow", "fromArrow"};
    protected static HashMap<String, String[]> STATE_MAP = new HashMap();
    protected static HashMap<String, String> NAME_MAP;
    private static final Logger log;

    static {
        STATE_MAP.put("Turnout", TURNOUT);
        STATE_MAP.put("Sensor", SENSOR);
        STATE_MAP.put("SignalHead", SIGNALHEAD);
        STATE_MAP.put("Light", LIGHT);
        STATE_MAP.put("MultiSensor", MULTISENSOR);
        STATE_MAP.put("RPSReporter", RPSREPORTER);
        STATE_MAP.put("IndicatorTrack", INDICATOR_TRACK);
        STATE_MAP.put("IndicatorTO", INDICATOR_TRACK);
        STATE_MAP.put("Portal", PORTAL);
        NAME_MAP = new HashMap();
        NAME_MAP.put("Turnout", "BeanNameTurnout");
        NAME_MAP.put("Sensor", "BeanNameSensor");
        NAME_MAP.put("SignalHead", "BeanNameSignalHead");
        NAME_MAP.put("Light", "BeanNameLight");
        NAME_MAP.put("SignalMast", "BeanNameSignalMast");
        NAME_MAP.put("MultiSensor", "MultiSensor");
        NAME_MAP.put("Memory", "BeanNameMemory");
        NAME_MAP.put("Reporter", "BeanNameReporter");
        NAME_MAP.put("RPSReporter", "RPSreporter");
        NAME_MAP.put("IndicatorTrack", "IndicatorTrack");
        NAME_MAP.put("IndicatorTO", "IndicatorTO");
        NAME_MAP.put("Portal", "BeanNamePortal");
        NAME_MAP.put("Icon", "Icon");
        NAME_MAP.put("Background", "Background");
        NAME_MAP.put("Text", "Text");
        NAME_MAP.put("FastClock", "FastClock");
        log = LoggerFactory.getLogger(ItemPanel.class);
    }

    public ItemPanel(DisplayFrame parentFrame, @Nonnull String type) {
        this._frame = parentFrame;
        this._itemType = type;
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalGlue());
    }

    public void init() {
        if (!this._initialized) {
            this._update = false;
            this._suppressDragging = false;
            this.initIconFamiliesPanel();
            this._initialized = true;
        }
    }

    @Nonnull
    protected HashMap<String, NamedIcon> makeNewIconMap(String type) {
        HashMap<String, NamedIcon> newMap = new HashMap<String, NamedIcon>();
        String[] stringArray = STATE_MAP.get(type);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            NamedIcon icon = new NamedIcon("resources/icons/misc/X-red.gif", "resources/icons/misc/X-red.gif");
            newMap.put(name, icon);
            ++n2;
        }
        return newMap;
    }

    protected static void checkIconMap(String type, HashMap<String, NamedIcon> map) {
        String[] stringArray = STATE_MAP.get(type);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (map.get(name) == null) {
                NamedIcon icon = new NamedIcon("resources/icons/misc/X-red.gif", "resources/icons/misc/X-red.gif");
                map.put(name, icon);
            }
            ++n2;
        }
    }

    protected void previewColorChange() {
        if (this._previewPanel != null) {
            this._previewPanel.setBackgroundSelection(this._frame.getPreviewBg());
            this._previewPanel.invalidate();
        }
    }

    public void closeDialogs() {
    }

    protected abstract JPanel makeSpecialBottomPanel(boolean var1);

    protected abstract JPanel makeItemButtonPanel();

    protected JButton makeUpdateButton(ActionListener doneAction) {
        JButton updateButton = new JButton(Bundle.getMessage("updateButton"));
        updateButton.addActionListener(doneAction);
        updateButton.setToolTipText(Bundle.getMessage("ToolTipPickFromTable"));
        return updateButton;
    }

    protected void makeBottomPanel(boolean isEmpty) {
        this._bottomPanel = isEmpty ? this.makeSpecialBottomPanel(this._update) : this.makeItemButtonPanel();
        if (this._doneAction != null) {
            this._bottomPanel.add(this.makeUpdateButton(this._doneAction));
        }
        this._bottomPanel.invalidate();
        this.add(this._bottomPanel);
    }

    protected void initIconFamiliesPanel() {
        if (this._iconPanel == null) {
            this._iconPanel = new ImagePanel();
            this._iconPanel.setBorder(BorderFactory.createLineBorder(Color.black));
            this._iconPanel.setImage(this._frame.getPreviewBackground());
            this._iconPanel.setOpaque(false);
        }
        if (this._iconFamilyPanel == null) {
            this._iconFamilyPanel = new JPanel();
            this._iconFamilyPanel.setLayout(new BoxLayout(this._iconFamilyPanel, 1));
            this.add(this._iconFamilyPanel);
        }
        this.makeFamiliesPanel();
        if (log.isDebugEnabled()) {
            log.debug("initIconFamiliesPanel done for {}, update= {}", (Object)this._itemType, (Object)this._update);
        }
    }

    protected void makePreviewPanel(boolean hasMaps, ImagePanel dragIconPanel) {
        if (this._previewPanel == null) {
            if (!this._update && !this._suppressDragging) {
                this._previewPanel = new PreviewPanel(this._frame, this._iconPanel, dragIconPanel, true);
                this._instructions = this.instructions();
                this._previewPanel.add((Component)this._instructions, 0);
            } else {
                this._previewPanel = new PreviewPanel(this._frame, this._iconPanel, null, false);
                this._previewPanel.setVisible(false);
            }
            this._iconFamilyPanel.add(this._previewPanel);
        }
        this._previewPanel.setVisible(true);
        this._previewPanel.invalidate();
    }

    protected void addIconsToPanel(HashMap<String, NamedIcon> iconMap, ImagePanel iconPanel, boolean dropIcon) {
        if (iconMap == null) {
            log.debug("_currentIconMap is null for type {}", (Object)this._itemType);
            return;
        }
        iconPanel.removeAll();
        GridBagLayout gridbag = new GridBagLayout();
        iconPanel.setLayout(gridbag);
        int numCol = 4;
        GridBagConstraints c = ItemPanel.itemGridBagConstraint();
        if (iconMap.isEmpty()) {
            iconPanel.add(Box.createRigidArea(new Dimension(70, 70)));
        }
        int cnt = 0;
        for (String key : iconMap.keySet()) {
            JPanel panel = this.makeIconDisplayPanel(key, iconMap, dropIcon);
            iconPanel.add((Component)panel, c);
            if (c.gridx > numCol) {
                ++c.gridy;
                c.gridx = 0;
            }
            ++c.gridx;
            ++cnt;
            gridbag.setConstraints(panel, c);
        }
        if (log.isDebugEnabled()) {
            log.debug("addIconsToPanel adds {} icons (map size {}) to iconPanel for {}", new Object[]{cnt, iconMap.size(), this._itemType});
        }
        iconPanel.invalidate();
    }

    protected abstract JPanel makeIconDisplayPanel(String var1, HashMap<String, NamedIcon> var2, boolean var3);

    protected void wrapIconImage(NamedIcon icon, JLabel image, JPanel panel, String key) {
        double scale;
        String borderName = ItemPalette.convertText(key);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), borderName));
        image.setOpaque(false);
        image.setToolTipText(icon.getName());
        image.setName(key);
        JPanel iPanel = new JPanel();
        iPanel.setOpaque(false);
        iPanel.add(image);
        panel.add(iPanel);
        if (icon.getIconWidth() < 1 || icon.getIconHeight() < 1) {
            image.setText(Bundle.getMessage("invisibleIcon"));
            scale = 0.0;
        } else {
            scale = icon.reduceTo(100, 100, 0.02);
        }
        String scaleText = MessageFormat.format(Bundle.getMessage("scale"), CatalogPanel.printDbl(scale, 2));
        JLabel label = new JLabel(scaleText);
        JPanel sPanel = new JPanel();
        sPanel.setOpaque(false);
        sPanel.add(label);
        panel.add(sPanel);
        FontMetrics fm = this.getFontMetrics(panel.getFont());
        int width = fm.stringWidth(borderName) + 5;
        width = Math.max(Math.max(width, 100), icon.getIconWidth() + 5);
        int height = panel.getPreferredSize().height;
        panel.setPreferredSize(new Dimension(width, height));
    }

    protected abstract JPanel instructions();

    protected abstract void makeFamiliesPanel();

    protected abstract void hideIcons();

    protected boolean mapsAreEqual(HashMap<String, NamedIcon> mapOne, HashMap<String, NamedIcon> mapTwo) {
        if (!this._itemType.equals("SignalHead") && mapOne.size() != mapTwo.size()) {
            return false;
        }
        for (Map.Entry<String, NamedIcon> mapTwoEntry : mapTwo.entrySet()) {
            NamedIcon mapOneIcon = mapOne.get(mapTwoEntry.getKey());
            if (mapOneIcon == null) {
                return false;
            }
            String url = mapOneIcon.getURL();
            if (url != null && url.equals(mapTwoEntry.getValue().getURL())) continue;
            return false;
        }
        return true;
    }

    protected void loadDefaultType() {
        ItemPalette.loadMissingItemType(this._itemType);
        ArrayList<String> deletes = new ArrayList<String>();
        if (!this._itemType.equals("IndicatorTO")) {
            HashMap<String, HashMap<String, NamedIcon>> families = ItemPalette.getFamilyMaps(this._itemType);
            Set<String> keys = families.keySet();
            String[] key = new String[keys.size()];
            key = keys.toArray(key);
            int i = 0;
            while (i < key.length) {
                int j = i + 1;
                while (j < key.length) {
                    HashMap<String, NamedIcon> mapK = families.get(key[i]);
                    if (this.mapsAreEqual(mapK, families.get(key[j]))) {
                        deletes.add(this.queryWhichToDelete(key[i], key[j]));
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            for (String k : deletes) {
                ItemPalette.removeIconMap(this._itemType, k);
            }
            if (this instanceof FamilyItemPanel) {
                ((FamilyItemPanel)this)._family = null;
            }
        } else {
            IndicatorTOItemPanel p = (IndicatorTOItemPanel)this;
            HashMap<String, HashMap<String, HashMap<String, NamedIcon>>> families = ItemPalette.getLevel4FamilyMaps(this._itemType);
            Set<String> keys = families.keySet();
            String[] key = new String[keys.size()];
            key = keys.toArray(key);
            int i = 0;
            while (i < key.length) {
                int j = i + 1;
                while (j < key.length) {
                    HashMap<String, HashMap<String, NamedIcon>> mapK = families.get(key[i]);
                    if (p.familiesAreEqual(mapK, families.get(key[j]))) {
                        deletes.add(this.queryWhichToDelete(key[i], key[j]));
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            for (String k : deletes) {
                ItemPalette.removeLevel4IconMap(this._itemType, k, null);
            }
            p._family = null;
        }
        if (!this._initialized) {
            this.makeFamiliesPanel();
        } else {
            this.initIconFamiliesPanel();
            this.hideIcons();
        }
    }

    private String queryWhichToDelete(String key1, String key2) {
        int result = JOptionPane.showOptionDialog(this, Bundle.getMessage("DuplicateMap", key1, key2), Bundle.getMessage("QuestionTitle"), 0, 3, null, new Object[]{key1, key2}, key1);
        if (result == 0) {
            return key2;
        }
        if (result == 1) {
            return key1;
        }
        return key2;
    }

    protected void reSizeDisplay(boolean isPalette, Dimension oldDim, Dimension frameDim) {
        Dimension newDim = this.getPreferredSize();
        Dimension deltaDim = this.shellDimension(this);
        if (log.isDebugEnabled()) {
            Dimension frameDiffDim = new Dimension(frameDim.width - oldDim.width, frameDim.height - oldDim.height);
            log.debug("resize {} {}. frameDiffDim= ({}, {}) deltaDim= ({}, {}) prefDim= ({}, {}))", new Object[]{isPalette ? "tabPane" : "update", this._itemType, frameDiffDim.width, frameDiffDim.height, deltaDim.width, deltaDim.height, newDim.width, newDim.height});
        }
        if (isPalette && this._initialized) {
            this._frame.reSize(ItemPalette._tabPane, deltaDim, newDim);
        } else if (this._update || this._initialized) {
            this._frame.reSize(this._frame, deltaDim, newDim);
        }
    }

    public Dimension shellDimension(ItemPanel panel) {
        if (panel instanceof FamilyItemPanel) {
            return new Dimension(23, 122);
        }
        if (panel instanceof IconItemPanel) {
            return new Dimension(23, 65);
        }
        return new Dimension(23, 48);
    }

    public static GridBagConstraints itemGridBagConstraint() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        return c;
    }
}

