/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.palette;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.jmrit.catalog.DragJLabel;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.DisplayFrame;
import jmri.jmrit.display.IndicatorTrackIcon;
import jmri.jmrit.display.palette.DetectionPanel;
import jmri.jmrit.display.palette.FamilyItemPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndicatorItemPanel
extends FamilyItemPanel {
    private DetectionPanel _detectPanel;
    private static final Logger log = LoggerFactory.getLogger(IndicatorItemPanel.class);

    public IndicatorItemPanel(DisplayFrame parentFrame, String type, String family) {
        super(parentFrame, type, family);
    }

    @Override
    public void init() {
        if (!this._initialized) {
            super.init();
            this._detectPanel = new DetectionPanel(this);
            this.add((Component)this._detectPanel, 1);
        }
        this.hideIcons();
    }

    @Override
    protected void hideIcons() {
        if (this._detectPanel != null) {
            this._detectPanel.setVisible(true);
            this._detectPanel.invalidate();
        }
        super.hideIcons();
    }

    @Override
    protected void showIcons() {
        if (this._detectPanel != null) {
            this._detectPanel.setVisible(false);
            this._detectPanel.invalidate();
        }
        super.showIcons();
    }

    @Override
    public void init(ActionListener doneAction, HashMap<String, NamedIcon> iconMap) {
        super.init(doneAction, iconMap);
        this._detectPanel = new DetectionPanel(this);
        this.add((Component)this._detectPanel, 0);
    }

    @Override
    public void init(JPanel bottomPanel) {
        super.init(bottomPanel);
        this.add((Component)this._iconFamilyPanel, 0);
    }

    @Override
    public void dispose() {
        if (this._detectPanel != null) {
            this._detectPanel.dispose();
        }
    }

    @Override
    protected String getDisplayKey() {
        return "ClearTrack";
    }

    public boolean getShowTrainName() {
        return this._detectPanel.getShowTrainName();
    }

    public void setShowTrainName(boolean show) {
        this._detectPanel.setShowTrainName(show);
    }

    public String getOccSensor() {
        return this._detectPanel.getOccSensor();
    }

    public String getOccBlock() {
        return this._detectPanel.getOccBlock();
    }

    public void setOccDetector(String name) {
        this._detectPanel.setOccDetector(name);
    }

    public ArrayList<String> getPaths() {
        return this._detectPanel.getPaths();
    }

    public void setPaths(ArrayList<String> paths) {
        this._detectPanel.setPaths(paths);
    }

    @Override
    protected JLabel getDragger(DataFlavor flavor, HashMap<String, NamedIcon> map, NamedIcon icon) {
        return new IndicatorDragJLabel(flavor, map, icon);
    }

    protected class IndicatorDragJLabel
    extends DragJLabel {
        HashMap<String, NamedIcon> iconMap;

        public IndicatorDragJLabel(DataFlavor flavor, HashMap<String, NamedIcon> map, NamedIcon icon) {
            super(flavor, icon);
            this.iconMap = new HashMap<String, NamedIcon>(map);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return super.isDataFlavorSupported(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                return null;
            }
            if (this.iconMap == null) {
                log.error("IconDragJLabel.getTransferData: iconMap is null!");
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug("IndicatorDragJLabel.getTransferData");
            }
            if (flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable")) {
                IndicatorTrackIcon t = new IndicatorTrackIcon(IndicatorItemPanel.this._frame.getEditor());
                t.setOccBlock(IndicatorItemPanel.this._detectPanel.getOccBlock());
                t.setOccSensor(IndicatorItemPanel.this._detectPanel.getOccSensor());
                t.setShowTrain(IndicatorItemPanel.this._detectPanel.getShowTrainName());
                t.setFamily(IndicatorItemPanel.this._family);
                for (Map.Entry<String, NamedIcon> entry : this.iconMap.entrySet()) {
                    t.setIcon(entry.getKey(), new NamedIcon(entry.getValue()));
                }
                t.setLevel(7);
                return t;
            }
            if (DataFlavor.stringFlavor.equals(flavor)) {
                return String.valueOf(IndicatorItemPanel.this._itemType) + " icons";
            }
            return null;
        }
    }
}

