/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.palette;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jmri.jmrit.catalog.CatalogPanel;
import jmri.jmrit.catalog.DragJLabel;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.DisplayFrame;
import jmri.jmrit.display.LinkingLabel;
import jmri.jmrit.display.PositionableLabel;
import jmri.jmrit.display.palette.Bundle;
import jmri.jmrit.display.palette.DropJLabel;
import jmri.jmrit.display.palette.ItemPalette;
import jmri.jmrit.display.palette.ItemPanel;
import jmri.util.swing.ImagePanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IconItemPanel
extends ItemPanel {
    protected JButton _catalogButton;
    protected JButton _deleteIconButton;
    protected CatalogPanel _catalog;
    protected IconDisplayPanel _selectedIcon;
    protected DataFlavor _positionableDataFlavor;
    protected DataFlavor _namedIconDataFlavor;
    protected int _level = 3;
    private NamedIcon _updateIcon;
    private static final Logger log = LoggerFactory.getLogger(IconItemPanel.class);

    public IconItemPanel(DisplayFrame parentFrame, String type) {
        super(parentFrame, type);
        this.setToolTipText(Bundle.getMessage("ToolTipDragIcon"));
    }

    @Override
    public void init() {
        if (!this._initialized) {
            super.init();
            this.initLinkPanel();
            this._catalog = this.makeCatalog();
            this.add(this._catalog);
        }
    }

    public void init(ActionListener doneAction) {
        this._update = true;
        this._doneAction = doneAction;
        this._suppressDragging = true;
        this.initIconFamiliesPanel();
        this.add(this._iconPanel);
        this._catalog = this.makeCatalog();
        this.add(this._catalog);
    }

    @Override
    protected JPanel instructions() {
        JPanel blurb = new JPanel();
        blurb.setLayout(new BoxLayout(blurb, 1));
        blurb.add(new JLabel(Bundle.getMessage("DragIconPanel")));
        blurb.add(new JLabel(Bundle.getMessage("DragIconCatalog")));
        JPanel panel = new JPanel();
        panel.add(blurb);
        return panel;
    }

    protected CatalogPanel makeCatalog() {
        CatalogPanel catalog = CatalogPanel.makeDefaultCatalog(false, false, true);
        ImagePanel panel = catalog.getPreviewPanel();
        if (!this._update) {
            panel.setImage(this._frame.getPreviewBackground());
        } else {
            panel.setImage(this._frame.getBackground(0));
            catalog.setParent(this);
        }
        catalog.setToolTipText(Bundle.getMessage("ToolTipDragCatalog"));
        catalog.setVisible(false);
        return catalog;
    }

    @Override
    protected void previewColorChange() {
        ImagePanel iconPanel;
        if (this._initialized && (iconPanel = this._catalog.getPreviewPanel()) != null) {
            iconPanel.setImage(this._frame.getPreviewBackground());
        }
        super.previewColorChange();
    }

    @Override
    protected void initIconFamiliesPanel() {
        super.initIconFamiliesPanel();
        if (!this._update) {
            this._iconPanel.addMouseListener(new IconListener());
        }
    }

    @Override
    protected void makeFamiliesPanel() {
        if (!this._update) {
            HashMap<String, HashMap<String, NamedIcon>> families = ItemPalette.getFamilyMaps(this._itemType);
            log.debug("makeFamiliesPanel Num families= {}", (Object)families.size());
            this._currentIconMap = families.get("set");
            if (this._currentIconMap == null) {
                this._currentIconMap = new HashMap();
                if (families.size() != 0) {
                    log.error("{} Unknown families found for {}", (Object)families.size(), (Object)this._itemType);
                }
            }
            this.makeDataFlavors();
        } else {
            this._currentIconMap = new HashMap();
        }
        this.addIconsToPanel();
        this.makePreviewPanel(true, null);
    }

    private void addIconsToPanel() {
        boolean isEmpty = this._currentIconMap.isEmpty();
        if (this._bottomPanel == null) {
            this.makeBottomPanel(isEmpty);
        } else if (isEmpty ^ this._wasEmpty) {
            this.remove(this._bottomPanel);
            this.makeBottomPanel(isEmpty);
        }
        this._wasEmpty = isEmpty;
        this.addIconsToPanel(this._currentIconMap, this._iconPanel, this._update);
    }

    private void makeDataFlavors() {
        try {
            this._positionableDataFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable");
            this._namedIconDataFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=jmri.jmrit.catalog.NamedIcon");
        }
        catch (ClassNotFoundException cnfe) {
            log.error("Unable to find class supporting {}", (Object)"application/x-java-jvm-local-objectref;class=jmri.jmrit.catalog.NamedIcon", (Object)cnfe);
        }
        if (!this._update) {
            new DropTarget(this._iconPanel, 3, new ADropTargetListener());
        }
    }

    @Override
    protected JPanel makeIconDisplayPanel(String key, HashMap<String, NamedIcon> iconMap, boolean dropIcon) {
        NamedIcon icon = iconMap.get(key);
        return new IconDisplayPanel(key, icon, dropIcon);
    }

    @Override
    protected JPanel makeItemButtonPanel() {
        JPanel panel = new JPanel();
        panel.add(this.makeCatalogButton());
        if (this._update) {
            return panel;
        }
        JButton renameButton = new JButton(Bundle.getMessage("RenameIcon"));
        renameButton.addActionListener(a -> this.renameIcon());
        panel.add(renameButton);
        this._deleteIconButton = new JButton(Bundle.getMessage("deleteIcon"));
        this._deleteIconButton.addActionListener(a -> this.deleteIcon());
        this._deleteIconButton.setToolTipText(Bundle.getMessage("ToolTipDeleteIcon"));
        panel.add(this._deleteIconButton);
        return panel;
    }

    private JButton makeCatalogButton() {
        if (this._catalogButton == null) {
            this._catalogButton = new JButton(Bundle.getMessage("ButtonShowCatalog"));
            this._catalogButton.addActionListener(a -> {
                if (this._catalog.isVisible()) {
                    this.hideCatalog();
                } else {
                    this.showCatalog();
                }
            });
            this._catalogButton.setToolTipText(Bundle.getMessage("ToolTipCatalog"));
        }
        return this._catalogButton;
    }

    @Override
    protected JPanel makeSpecialBottomPanel(boolean update) {
        JPanel _bottom2Panel = new JPanel();
        _bottom2Panel.add(this.makeCatalogButton());
        if (!update) {
            JButton button = new JButton(Bundle.getMessage("RestoreDefault"));
            button.addActionListener(a -> this.loadDefaultType());
            _bottom2Panel.add(button);
        }
        return _bottom2Panel;
    }

    protected void hideCatalog() {
        Dimension oldDim = this.getSize();
        boolean isPalette = this._frame instanceof ItemPalette;
        Dimension totalDim = this._frame.getSize();
        this._catalog.setVisible(false);
        this._catalog.invalidate();
        this.reSizeDisplay(isPalette, oldDim, totalDim);
        this._catalogButton.setText(Bundle.getMessage("ButtonShowCatalog"));
    }

    protected void showCatalog() {
        Dimension oldDim = this.getSize();
        boolean isPalette = this._frame instanceof ItemPalette;
        Dimension totalDim = this._frame.getSize();
        this._catalog.setVisible(true);
        this._catalog.invalidate();
        this.reSizeDisplay(isPalette, oldDim, totalDim);
        this._catalogButton.setText(Bundle.getMessage("HideCatalog"));
    }

    protected void putIcon(String name, NamedIcon icon) {
        this._currentIconMap.put(name, icon);
        log.debug("putIcon {}", (Object)name);
        this.updateIcons();
    }

    protected void deleteIcon() {
        if (this._selectedIcon == null) {
            JOptionPane.showMessageDialog(this._frame, Bundle.getMessage("ToSelectIcon"), Bundle.getMessage("ReminderTitle"), 1);
            return;
        }
        log.debug("deleteIcon {}", (Object)this._selectedIcon._key);
        this._currentIconMap.remove(this._selectedIcon._key);
        this.updateIcons();
    }

    @Override
    protected void hideIcons() {
    }

    private void updateIcons() {
        this._previewPanel.setVisible(false);
        this.addIconsToPanel();
        Dimension oldDim = this.getSize();
        boolean isPalette = this._frame instanceof ItemPalette;
        Dimension totalDim = this._frame.getSize();
        this._previewPanel.setVisible(true);
        if (!this._update) {
            ItemPalette.removeIconMap(this._itemType, "set");
            ItemPalette.addFamily(this._itemType, "set", this._currentIconMap);
        }
        this._iconPanel.invalidate();
        this.reSizeDisplay(isPalette, oldDim, totalDim);
    }

    private void renameIcon() {
        if (this._selectedIcon != null) {
            String name = JOptionPane.showInputDialog(this._frame, Bundle.getMessage("NoIconName"), Bundle.getMessage("QuestionTitle"), 3);
            if (name != null) {
                this._currentIconMap.remove(this._selectedIcon._key);
                this.putIcon(name, this._selectedIcon._icon);
                this._selectedIcon._key = name;
                this.deselectIcon();
            }
        } else {
            JOptionPane.showMessageDialog(this._frame, Bundle.getMessage("ToSelectIcon"), Bundle.getMessage("ReminderTitle"), 1);
        }
    }

    protected void setSelection(@Nonnull IconDisplayPanel panel) {
        if (this._selectedIcon != null && !panel.equals(this._selectedIcon)) {
            this.deselectIcon();
        }
        String borderName = ItemPalette.convertText(panel._key);
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.red, 2), borderName));
        this._selectedIcon = panel;
        this._catalog.deselectIcon();
    }

    public void deselectIcon() {
        if (this._selectedIcon != null) {
            String borderName = ItemPalette.convertText(this._selectedIcon._key);
            this._selectedIcon.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black, 1), borderName));
            this._selectedIcon = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected String setIconName(String name) {
        name = JOptionPane.showInputDialog(this, Bundle.getMessage("NoIconName"), name);
        if (name != null && name.trim().length() != 0) ** GOTO lbl8
        return null;
lbl-1000:
        // 1 sources

        {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("DuplicateIconName", new Object[]{name}), Bundle.getMessage("WarningTitle"), 2);
            name = JOptionPane.showInputDialog(this, Bundle.getMessage("NoIconName"), name);
            if (name != null && name.trim().length() != 0) continue;
            return null;
lbl8:
            // 2 sources

            ** while (this._currentIconMap.get((Object)name) != null)
        }
lbl9:
        // 1 sources

        return name;
    }

    protected void initLinkPanel() {
        JPanel blurb = new JPanel();
        blurb.setLayout(new BoxLayout(blurb, 1));
        blurb.add(Box.createVerticalStrut(5));
        blurb.add(new JLabel(Bundle.getMessage("ToLinkToURL", "Text")));
        blurb.add(new JLabel(Bundle.getMessage("enterPanel")));
        blurb.add(new JLabel(Bundle.getMessage("enterURL")));
        blurb.add(Box.createVerticalStrut(5));
        blurb.add(new JLabel(Bundle.getMessage("LinkName")));
        blurb.add(this._linkName);
        this._linkName.setToolTipText(Bundle.getMessage("ToolTipLink"));
        blurb.setToolTipText(Bundle.getMessage("ToolTipLink"));
        JPanel panel = new JPanel();
        panel.add(blurb);
        JPanel linkPanel = new JPanel();
        linkPanel.add(panel);
        this.add(linkPanel);
    }

    public void setUpdateIcon(NamedIcon icon) {
        if (!this._update || icon == null) {
            return;
        }
        this._updateIcon = icon;
        String name = icon.getName();
        if (name == null) {
            name = Bundle.getMessage("unNamed");
        } else {
            File f = new File(name);
            int index = (name = f.getName()).indexOf(46);
            if (index > 0) {
                name = name.substring(0, index);
            }
        }
        this._currentIconMap.put(name, icon);
        this.updateIcons();
    }

    public NamedIcon getUpdateIcon() {
        return this._updateIcon;
    }

    class ADropJLabel
    extends DropJLabel {
        ADropJLabel(Icon icon) {
            super(icon);
        }

        ADropJLabel(Icon icon, HashMap<String, NamedIcon> iconMap) {
            super(icon, iconMap);
        }

        @Override
        protected void accept(DropTargetDropEvent e, NamedIcon newIcon) {
            super.accept(e, newIcon);
            IconItemPanel.this._updateIcon = newIcon;
        }
    }

    class ADropTargetListener
    extends DropTargetAdapter {
        ADropTargetListener() {
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            boolean accepted = false;
            try {
                Transferable tr = e.getTransferable();
                if (e.isDataFlavorSupported(IconItemPanel.this._positionableDataFlavor)) {
                    PositionableLabel label = (PositionableLabel)tr.getTransferData(IconItemPanel.this._positionableDataFlavor);
                    NamedIcon newIcon = new NamedIcon((NamedIcon)label.getIcon());
                    accepted = this.accept(label.getName(), newIcon);
                } else if (e.isDataFlavorSupported(IconItemPanel.this._namedIconDataFlavor)) {
                    NamedIcon icon = (NamedIcon)tr.getTransferData(IconItemPanel.this._namedIconDataFlavor);
                    NamedIcon newIcon = new NamedIcon(icon);
                    accepted = this.accept(icon.getName(), newIcon);
                } else if (e.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String text = (String)tr.getTransferData(DataFlavor.stringFlavor);
                    log.debug("drop for stringFlavor {}", (Object)text);
                    NamedIcon newIcon = new NamedIcon(text, text);
                    accepted = this.accept(Bundle.getMessage("unNamed"), newIcon);
                } else {
                    log.debug("IconDragJLabel.drop REJECTED!");
                    e.rejectDrop();
                }
            }
            catch (UnsupportedFlavorException | IOException exception) {}
            if (!accepted) {
                e.rejectDrop();
                log.debug("IconDragJLabel.drop REJECTED!");
            } else {
                e.acceptDrop(3);
            }
        }

        private boolean accept(String name, NamedIcon newIcon) {
            if (name == null || newIcon == null) {
                return false;
            }
            IconItemPanel.this.putIcon(name, newIcon);
            if (log.isDebugEnabled()) {
                log.debug("IconDragJLabel.drop COMPLETED for {}, {}", (Object)name, (Object)newIcon.getURL());
            }
            return true;
        }
    }

    public class IconDisplayPanel
    extends JPanel
    implements MouseListener {
        String _key;
        NamedIcon _icon;

        public IconDisplayPanel(String key, NamedIcon icon, boolean dropIcon) {
            JLabel image;
            this._key = key;
            this._icon = icon;
            if (dropIcon) {
                image = new ADropJLabel(icon);
            } else {
                image = new IconDragJLabel(IconItemPanel.this._positionableDataFlavor, icon, IconItemPanel.this._level);
                image.addMouseListener(this);
                this.addMouseListener(new IconListener());
            }
            IconItemPanel.this.wrapIconImage(icon, image, this, key);
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getSource() instanceof JLabel) {
                IconItemPanel.this.setSelection(this);
            } else if (event.getSource() instanceof IconDisplayPanel) {
                IconDisplayPanel panel = (IconDisplayPanel)event.getSource();
                IconItemPanel.this.setSelection(panel);
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
        }

        @Override
        public void mouseExited(MouseEvent event) {
        }
    }

    public class IconDragJLabel
    extends DragJLabel {
        int level;

        public IconDragJLabel(DataFlavor flavor, NamedIcon icon, int zLevel) {
            super(flavor, icon);
            this.level = zLevel;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return this._dataFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                return null;
            }
            String url = ((NamedIcon)this.getIcon()).getURL();
            log.debug("DragJLabel.getTransferData url= {}", (Object)url);
            if (flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable")) {
                String link = IconItemPanel.this._linkName.getText().trim();
                PositionableLabel l = link.length() == 0 ? new PositionableLabel(NamedIcon.getIconByName(url), IconItemPanel.this._frame.getEditor()) : new LinkingLabel(NamedIcon.getIconByName(url), IconItemPanel.this._frame.getEditor(), link);
                l.setLevel(this.level);
                return l;
            }
            if (DataFlavor.stringFlavor.equals(flavor)) {
                return String.valueOf(IconItemPanel.this._itemType) + " for \"" + url + "\"";
            }
            return null;
        }
    }

    class IconListener
    extends MouseAdapter {
        IconListener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getSource() instanceof IconDisplayPanel) {
                IconDisplayPanel panel = (IconDisplayPanel)event.getSource();
                IconItemPanel.this.setSelection(panel);
            } else {
                IconItemPanel.this.deselectIcon();
            }
        }
    }
}

