/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.palette;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import jmri.jmrit.catalog.CatalogPanel;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.DisplayFrame;
import jmri.jmrit.display.palette.Bundle;
import jmri.jmrit.display.palette.DropJLabel;
import jmri.jmrit.display.palette.IconDialog;
import jmri.jmrit.display.palette.ItemPalette;
import jmri.jmrit.display.palette.ItemPanel;
import jmri.util.swing.ImagePanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FamilyItemPanel
extends ItemPanel {
    protected String _family;
    protected ImagePanel _dragIconPanel;
    protected JPanel _familyButtonPanel;
    protected JButton _showIconsButton;
    protected JButton _updateButton;
    protected HashMap<String, NamedIcon> _unstoredMap;
    protected IconDialog _dialog;
    protected ButtonGroup _familyButtonGroup;
    protected boolean _isUnstoredMap;
    protected boolean _cntlDown;
    Action pressed = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FamilyItemPanel.this.setControlDown(true);
        }
    };
    Action released = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FamilyItemPanel.this.setControlDown(false);
        }
    };
    private static final Logger log = LoggerFactory.getLogger(FamilyItemPanel.class);

    public FamilyItemPanel(DisplayFrame parentFrame, String type, String family) {
        super(parentFrame, type);
        this._family = family;
    }

    @Override
    public void init() {
        if (!this._initialized) {
            this.makeShowIconsButton();
            super.init();
        }
        this.hideIcons();
    }

    public void init(ActionListener doneAction, HashMap<String, NamedIcon> iconMap) {
        this._update = true;
        this._doneAction = doneAction;
        this._suppressDragging = true;
        if (iconMap != null) {
            this.checkCurrentMap(iconMap);
        }
        if (this._family == null || this._family.isEmpty()) {
            this._family = Bundle.getMessage("unNamed");
        }
        this.initIconFamiliesPanel();
        this._initialized = true;
    }

    public void init(JPanel bottomPanel) {
        this._update = false;
        this._suppressDragging = true;
        this.initIconFamiliesPanel();
        this.remove(this._bottomPanel);
        bottomPanel.add((Component)this.makeShowIconsButton(), 0);
        this.add(bottomPanel);
        this._initialized = true;
        this.hideIcons();
    }

    public JPanel getBottomPanel() {
        return this._bottomPanel;
    }

    public JButton getUpdateButton() {
        return this._updateButton;
    }

    @Override
    protected JButton makeUpdateButton(ActionListener doneAction) {
        this._updateButton = new JButton(Bundle.getMessage("updateButton"));
        this._updateButton.addActionListener(doneAction);
        this._updateButton.setToolTipText(Bundle.getMessage("ToolTipPickFromTable"));
        return this._updateButton;
    }

    @Override
    protected JPanel makeItemButtonPanel() {
        JPanel panel = new JPanel();
        panel.add(this.makeShowIconsButton());
        panel.add(this.makeEditButton());
        if (!this._update) {
            this.addCreateDeleteFamilyButtons(panel);
        }
        return panel;
    }

    protected JButton makeShowIconsButton() {
        if (this._showIconsButton == null) {
            this._showIconsButton = new JButton(Bundle.getMessage("ShowIcons"));
            this._showIconsButton.addActionListener(a -> {
                if (this._iconPanel.isVisible()) {
                    this.hideIcons();
                } else {
                    this.showIcons();
                }
            });
            this._showIconsButton.setToolTipText(Bundle.getMessage("ToolTipShowIcons"));
        }
        return this._showIconsButton;
    }

    private JButton makeEditButton() {
        JButton editButton = new JButton(Bundle.getMessage("ButtonEditIcons"));
        editButton.addActionListener(a -> this.openDialog(this._itemType, this._family));
        editButton.setToolTipText(Bundle.getMessage("ToolTipEditIcons"));
        this.makeControlKeyBinder(editButton);
        return editButton;
    }

    private JButton makeNewFamilyButton() {
        JButton button = new JButton(Bundle.getMessage("createNewFamily"));
        button.addActionListener(a -> {
            boolean bl = this.newFamilyDialog();
        });
        button.setToolTipText(Bundle.getMessage("ToolTipAddFamily"));
        this.makeControlKeyBinder(button);
        return button;
    }

    @Override
    protected JPanel makeSpecialBottomPanel(boolean update) {
        JPanel _bottom2Panel = new JPanel();
        if (update) {
            _bottom2Panel.add(this.makeEditButton());
        } else {
            _bottom2Panel.add(this.makeNewFamilyButton());
        }
        JButton button = new JButton(Bundle.getMessage("RestoreDefault"));
        button.addActionListener(a -> this.loadDefaultType());
        _bottom2Panel.add(button);
        return _bottom2Panel;
    }

    protected void addCreateDeleteFamilyButtons(JPanel panel) {
        panel.add(this.makeNewFamilyButton());
        JButton deleteButton = new JButton(Bundle.getMessage("deleteFamily"));
        deleteButton.addActionListener(a -> this.deleteFamilySet());
        deleteButton.setToolTipText(Bundle.getMessage("ToolTipDeleteFamily"));
        panel.add(deleteButton);
    }

    private void checkCurrentMap(HashMap<String, NamedIcon> iconMap) {
        if (this._itemType.equals("SignalMast")) {
            return;
        }
        String family = this.getValidFamilyName(this._family, iconMap);
        if (this._isUnstoredMap) {
            this._unstoredMap = iconMap;
            int result = JOptionPane.showConfirmDialog(this._frame.getEditor(), Bundle.getMessage("UnkownFamilyName", family), Bundle.getMessage("QuestionTitle"), 0, 3);
            if (result == 0) {
                ItemPalette.addFamily(this._itemType, family, iconMap);
            }
            this._family = family;
        } else if (family != null && !family.equals(this._family)) {
            log.info("{} icon's family \"{}\" found but is called \"{}\" in the Catalog.  Name changed to Catalog name.", new Object[]{this._itemType, this._family, family});
            this._family = family;
        }
    }

    protected String getValidFamilyName(String family, HashMap<String, NamedIcon> iconMap) {
        String mapFamily;
        HashMap<String, HashMap<String, NamedIcon>> families = ItemPalette.getFamilyMaps(this._itemType);
        if (iconMap != null) {
            mapFamily = this.findFamilyOfMap(null, iconMap, families);
            if (mapFamily == null) {
                this._isUnstoredMap = true;
            } else {
                log.debug("getValidFamilyName: findFamilyOfMap {} found stored family \"{}\" for family \"{}\".", new Object[]{this._itemType, mapFamily, family});
                this._isUnstoredMap = false;
                if (family != null) {
                    return mapFamily;
                }
            }
        }
        mapFamily = family;
        boolean nameOK = false;
        while (!nameOK) {
            Container fr;
            if ((mapFamily == null || mapFamily.isEmpty()) && (mapFamily = JOptionPane.showInputDialog(fr = this._dialog != null ? this._dialog : this, Bundle.getMessage("EnterFamilyName"), Bundle.getMessage("createNewFamily"), 3)) == null) {
                return null;
            }
            if (families.isEmpty()) break;
            for (String fam : families.keySet()) {
                if (mapFamily.equals(fam)) {
                    if (this._update) {
                        String thisType = (String)NAME_MAP.get(this._itemType);
                        JOptionPane.showMessageDialog(this._frame, Bundle.getMessage("DuplicateFamilyName", mapFamily, Bundle.getMessage(thisType), Bundle.getMessage("UseAnotherName")), Bundle.getMessage("WarningTitle"), 2);
                        mapFamily = null;
                        nameOK = false;
                        break;
                    }
                    return mapFamily;
                }
                nameOK = true;
            }
            if (!nameOK && this._update) break;
        }
        return mapFamily;
    }

    protected String findFamilyOfMap(String exemptFamily, HashMap<String, NamedIcon> newMap, HashMap<String, HashMap<String, NamedIcon>> families) {
        for (Map.Entry<String, HashMap<String, NamedIcon>> entry : families.entrySet()) {
            String family = entry.getKey();
            if (family.equals(exemptFamily) || !this.mapsAreEqual(entry.getValue(), newMap)) continue;
            return entry.getKey();
        }
        return null;
    }

    protected boolean namesStoredMap(String family) {
        HashMap<String, HashMap<String, NamedIcon>> families = ItemPalette.getFamilyMaps(this._itemType);
        return families.containsKey(family);
    }

    @Override
    protected void makeFamiliesPanel() {
        HashMap<String, HashMap<String, NamedIcon>> families = ItemPalette.getFamilyMaps(this._itemType);
        boolean isEmpty = families.values().isEmpty();
        if (this._bottomPanel == null) {
            this.makeBottomPanel(isEmpty);
        } else if (isEmpty ^ this._wasEmpty) {
            this.remove(this._bottomPanel);
            this.makeBottomPanel(isEmpty);
            log.debug("REMAKE BOTTOM PANEL {}", (Object)this._itemType);
        }
        if (!isEmpty) {
            this.makeFamilyButtons(families.keySet());
            if (this._currentIconMap == null || this._currentIconMap.isEmpty()) {
                this._currentIconMap = families.get(this._family);
            }
        }
        if (this._currentIconMap == null) {
            this._currentIconMap = this._isUnstoredMap ? this._unstoredMap : new HashMap();
        }
        this._wasEmpty = isEmpty;
        if (!this._suppressDragging) {
            this.makeDragIconPanel();
            this.makeDndIcon(this._currentIconMap);
        }
        this.addIconsToPanel(this._currentIconMap, this._iconPanel, false);
        this.addFamilyPanels(!isEmpty);
    }

    @Override
    protected JPanel instructions() {
        JPanel blurb = new JPanel();
        blurb.setLayout(new BoxLayout(blurb, 1));
        String thisType = (String)NAME_MAP.get(this._itemType);
        blurb.add(new JLabel(Bundle.getMessage("PickRowBean", Bundle.getMessage(thisType))));
        blurb.add(new JLabel(Bundle.getMessage("DragBean")));
        JPanel panel = new JPanel();
        panel.add(blurb);
        return panel;
    }

    protected void addFamilyPanels(boolean hasMaps) {
        this.makePreviewPanel(hasMaps, this._dragIconPanel);
        if (this._familyButtonPanel != null) {
            this._iconFamilyPanel.add(this._familyButtonPanel);
        }
        this._iconPanel.setVisible(false);
    }

    protected void updateFamiliesPanel() {
        log.debug("updateFamiliesPanel for {}", (Object)this._itemType);
        if (this._iconPanel != null) {
            this._iconPanel.removeAll();
        }
        if (this._dragIconPanel != null) {
            this._dragIconPanel.removeAll();
        }
        if (this._previewPanel != null) {
            this._previewPanel.setVisible(false);
        }
        if (this._familyButtonPanel != null) {
            this._familyButtonPanel.removeAll();
        }
        this.makeFamiliesPanel();
        this._iconFamilyPanel.invalidate();
    }

    protected void makeFamilyButtons(Set<String> keySet) {
        if (this._familyButtonPanel == null) {
            this._familyButtonPanel = new JPanel();
            this._familyButtonPanel.setLayout(new BoxLayout(this._familyButtonPanel, 1));
        } else {
            this._familyButtonPanel.removeAll();
        }
        log.debug("makeFamilyButtons for {} family= {}", (Object)this._itemType, (Object)this._family);
        String thisType = (String)NAME_MAP.get(this._itemType);
        String txt = Bundle.getMessage("IconFamiliesLabel", Bundle.getMessage(thisType));
        JPanel p = new JPanel(new FlowLayout());
        p.add(new JLabel(txt));
        p.setOpaque(false);
        this._familyButtonPanel.add(p);
        this._familyButtonGroup = new ButtonGroup();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = ItemPanel.itemGridBagConstraint();
        int numCol = 4;
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(gridbag);
        String family = "";
        int length = 0;
        AbstractButton button = null;
        Iterator<String> iterator = keySet.iterator();
        while (iterator.hasNext()) {
            String s;
            family = s = iterator.next();
            length += family.length();
            button = new JRadioButton(family);
            this.addFamilyButtonListener((JRadioButton)button, family);
            if (family.equals(this._family)) {
                button.setSelected(true);
            }
            log.debug("{} ActionListener and button for family \"{}\" at gridx= {} gridy= {}", new Object[]{this._itemType, family, c.gridx, c.gridy});
            gridbag.setConstraints(button, c);
            buttonPanel.add((Component)button, c);
            if (c.gridx >= numCol || length > 50) {
                ++c.gridy;
                c.gridx = 0;
                length = 0;
            }
            ++c.gridx;
        }
        if (button != null && this._family == null) {
            button.setSelected(true);
            this._family = family;
        } else if (this._family != null && !keySet.contains(this._family)) {
            button = new JRadioButton(this._family);
            this.addFamilyButtonListener((JRadioButton)button, this._family);
            log.debug("\"{}\" ActionListener and button for family \"{}\" at gridx= {} gridy= {}", new Object[]{this._itemType, this._family, c.gridx, c.gridy});
            gridbag.setConstraints(button, c);
            buttonPanel.add((Component)button, c);
            button.setSelected(true);
        }
        this._familyButtonPanel.add(buttonPanel);
    }

    private void addFamilyButtonListener(JRadioButton button, String family) {
        button.addActionListener(new ActionListener(){
            String fam;

            @Override
            public void actionPerformed(ActionEvent e) {
                FamilyItemPanel.this.setFamily(this.fam);
            }

            ActionListener init(String f) {
                this.fam = f;
                return this;
            }
        }.init(family));
        this._familyButtonGroup.add(button);
    }

    protected void makeDragIconPanel() {
        if (this._dragIconPanel == null) {
            this._dragIconPanel = new ImagePanel();
            this._dragIconPanel.setOpaque(true);
            this._dragIconPanel.setLayout(new FlowLayout());
            this._dragIconPanel.setBorder(BorderFactory.createLineBorder(Color.black));
            this._dragIconPanel.setToolTipText(Bundle.getMessage("ToolTipDragIcon"));
        } else {
            this._dragIconPanel.removeAll();
        }
        this._dragIconPanel.setImage(this._frame.getPreviewBackground());
        if (this._iconPanel != null) {
            this._iconPanel.setImage(this._frame.getPreviewBackground());
        }
        this._dragIconPanel.setVisible(true);
    }

    @Override
    protected JPanel makeIconDisplayPanel(String key, HashMap<String, NamedIcon> iconMap, boolean dropIcon) {
        NamedIcon icon = iconMap.get(key);
        JPanel panel = new JPanel();
        JLabel image = dropIcon ? new DropJLabel((Icon)icon, iconMap) : new JLabel(icon);
        this.wrapIconImage(icon, image, panel, key);
        return panel;
    }

    protected JLabel getDragger(DataFlavor flavor, HashMap<String, NamedIcon> map, NamedIcon icon) {
        return null;
    }

    protected void makeDndIcon(HashMap<String, NamedIcon> iconMap) {
        JLabel label;
        String scaleText;
        if (iconMap == null) {
            return;
        }
        if (!iconMap.isEmpty()) {
            String displayKey = this.getDisplayKey();
            if (iconMap.get(displayKey) == null) {
                displayKey = (String)iconMap.keySet().toArray()[0];
            }
            NamedIcon icon = iconMap.get(displayKey);
            if (log.isDebugEnabled()) {
                log.debug("makeDndIcon for {}, {}. displayKey \"{}\" has icon {}", new Object[]{this._itemType, this._family, displayKey, icon != null});
            }
            if (icon != null) {
                icon = new NamedIcon(icon);
                double scale = icon.reduceTo(100, 100, 0.02);
                scaleText = MessageFormat.format(Bundle.getMessage("scale"), CatalogPanel.printDbl(scale, 2));
            } else {
                scaleText = Bundle.getMessage("noIcon");
            }
            try {
                label = this.getDragger(new DataFlavor("application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable"), iconMap, icon);
            }
            catch (ClassNotFoundException cnfe) {
                log.warn("no DndIconPanel for {}, {} created. {}", new Object[]{this._itemType, displayKey, cnfe});
                label = new JLabel(scaleText);
            }
        } else {
            label = new JLabel("- - - - - -");
            scaleText = Bundle.getMessage("noIcon");
        }
        JPanel panel = this.makeDragIconPanel(label, scaleText);
        this._dragIconPanel.add(panel);
    }

    protected abstract String getDisplayKey();

    private JPanel makeDragIconPanel(JLabel label, String scaleText) {
        JPanel p;
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        String borderName = Bundle.getMessage("dragToPanel");
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), borderName));
        panel.setToolTipText(Bundle.getMessage("ToolTipDragIcon"));
        panel.setOpaque(false);
        panel.add(Box.createVerticalGlue());
        if (label != null) {
            label.setToolTipText(Bundle.getMessage("ToolTipDragIcon"));
            label.setName(borderName);
            label.setOpaque(false);
            p = new JPanel();
            p.add(label);
            p.setOpaque(false);
            panel.add(p);
        }
        p = new JPanel();
        p.setOpaque(false);
        p.add(new JLabel(scaleText));
        panel.add(p);
        Dimension dim = panel.getPreferredSize();
        dim.width = Math.max(100, dim.width) + 10;
        panel.setPreferredSize(dim);
        return panel;
    }

    @Override
    protected void hideIcons() {
        boolean isPalette = this._frame instanceof ItemPalette;
        Dimension totalDim = this._frame.getSize();
        Dimension oldDim = this.getSize();
        if (this._iconPanel != null) {
            this._iconPanel.setVisible(false);
            this._iconPanel.invalidate();
            if (this._update) {
                this._previewPanel.setVisible(false);
            }
            if (!this._suppressDragging) {
                this._dragIconPanel.setVisible(true);
                this._dragIconPanel.invalidate();
                this._previewPanel.setVisible(true);
                this._instructions.setVisible(true);
            } else {
                this._previewPanel.setVisible(false);
            }
            this._previewPanel.invalidate();
        }
        this.reSizeDisplay(isPalette, oldDim, totalDim);
        this._showIconsButton.setText(Bundle.getMessage("ShowIcons"));
        this.closeDialogs();
    }

    protected void showIcons() {
        boolean isPalette = this._frame instanceof ItemPalette;
        Dimension totalDim = this._frame.getSize();
        Dimension oldDim = this.getSize();
        if (this._iconPanel != null) {
            this._iconPanel.setVisible(true);
            this._iconPanel.invalidate();
            if (this._update) {
                this._previewPanel.setVisible(true);
            }
            if (!this._suppressDragging) {
                this._dragIconPanel.setVisible(false);
                this._dragIconPanel.invalidate();
                this._instructions.setVisible(false);
            } else {
                this._previewPanel.setVisible(true);
            }
            this._previewPanel.invalidate();
        }
        this.reSizeDisplay(isPalette, oldDim, totalDim);
        this._showIconsButton.setText(Bundle.getMessage("HideIcons"));
        this.closeDialogs();
    }

    protected void deleteFamilySet() {
        if (JOptionPane.showConfirmDialog(this._frame, Bundle.getMessage("confirmDelete", this._family), Bundle.getMessage("QuestionTitle"), 0, 3) == 0) {
            ItemPalette.removeIconMap(this._itemType, this._family);
            this._family = null;
            this._currentIconMap = null;
            this.updateFamiliesPanel();
        }
    }

    protected void setControlDown(boolean b) {
        this._cntlDown = b;
    }

    private void makeControlKeyBinder(JComponent comp) {
        comp.getInputMap().put(KeyStroke.getKeyStroke("control A"), "pressed");
        comp.getActionMap().put("pressed", this.pressed);
        comp.getInputMap().put(KeyStroke.getKeyStroke("control released A"), "released");
        comp.getActionMap().put("released", this.released);
    }

    private boolean newFamilyDialog() {
        if (this._cntlDown) {
            this.loadDefaultType();
            this._cntlDown = false;
            return true;
        }
        String family = JOptionPane.showInputDialog(this._frame, Bundle.getMessage("EnterFamilyName"), Bundle.getMessage("createNewFamily"), 3);
        if (family == null) {
            return false;
        }
        this._family = null;
        this.openDialog(this._itemType, family);
        return true;
    }

    protected void openDialog(String type, String family) {
        this.closeDialogs();
        this.hideIcons();
        this._dialog = new IconDialog(type, family, this);
        if (this._family == null) {
            this._dialog.setMap(null);
        } else {
            this._dialog.setMap(this._currentIconMap);
        }
    }

    protected void dialogDoneAction(String family, HashMap<String, NamedIcon> iconMap) {
        if (!(this._update || family.equals(this._family) && this.mapsAreEqual(iconMap, this._currentIconMap))) {
            ItemPalette.removeIconMap(this._itemType, this._family);
            ItemPalette.addFamily(this._itemType, family, iconMap);
        } else {
            this._currentIconMap = iconMap;
            if (!this.namesStoredMap(family)) {
                this._isUnstoredMap = true;
            }
            if (this._isUnstoredMap) {
                this._unstoredMap = iconMap;
            }
        }
        this._family = family;
        this.makeFamiliesPanel();
        this.setFamily(family);
        this._cntlDown = false;
        this.hideIcons();
        if (log.isDebugEnabled()) {
            log.debug("dialogDoneAction done for {} {} update={}. unStored={}", new Object[]{this._itemType, this._family, this._update, this._isUnstoredMap});
        }
    }

    protected boolean isUpdate() {
        return this._update;
    }

    @Override
    public void closeDialogs() {
        if (this._dialog != null) {
            this._dialog.closeDialogs();
            this._dialog.dispose();
            this._dialog = null;
        }
    }

    public void dispose() {
        this.closeDialogs();
    }

    protected void setFamily() {
        if (this._familyButtonGroup == null) {
            return;
        }
        Enumeration<AbstractButton> en = this._familyButtonGroup.getElements();
        while (en.hasMoreElements()) {
            AbstractButton button = en.nextElement();
            if (!button.isSelected()) continue;
            this._family = button.getText();
            break;
        }
    }

    protected void setFamily(String family) {
        this._family = family;
        this.setFamilyMaps();
        this._iconFamilyPanel.invalidate();
        this.hideIcons();
        this.setFamilyButton();
    }

    protected void setFamilyMaps() {
        this._currentIconMap = ItemPalette.getIconMap(this._itemType, this._family);
        if (this._currentIconMap == null) {
            this._isUnstoredMap = true;
            this._currentIconMap = this._unstoredMap;
        }
        if (!this._suppressDragging) {
            this.makeDragIconPanel();
            this.makeDndIcon(this._currentIconMap);
        }
        this.addIconsToPanel(this._currentIconMap, this._iconPanel, false);
    }

    protected void setFamilyButton() {
        if (this._familyButtonGroup == null) {
            return;
        }
        Enumeration<AbstractButton> en = this._familyButtonGroup.getElements();
        while (en.hasMoreElements()) {
            AbstractButton button = en.nextElement();
            if (this._family == null || !this._family.equals(button.getText())) continue;
            button.setSelected(true);
            break;
        }
    }

    @Override
    protected void previewColorChange() {
        if (this._dialog != null) {
            ImagePanel iconPanel = this._dialog.getIconEditPanel();
            if (iconPanel != null) {
                iconPanel.setImage(this._frame.getPreviewBackground());
            }
            if ((iconPanel = this._dialog.getCatalogPreviewPanel()) != null) {
                iconPanel.setImage(this._frame.getPreviewBackground());
            }
        }
        log.debug("FamilyItemPanel.super stores previewColorChange");
        super.previewColorChange();
    }

    public HashMap<String, NamedIcon> getIconMap() {
        if (this._currentIconMap != null) {
            return this._currentIconMap;
        }
        HashMap<String, NamedIcon> map = ItemPalette.getIconMap(this._itemType, this._family);
        if (map == null) {
            map = this._unstoredMap;
        }
        if (map == null) {
            log.warn("Family \"{}\" for type \"{}\" not found.", (Object)this._family, (Object)this._itemType);
            map = this.makeNewIconMap(this._itemType);
        }
        return map;
    }

    public String getFamilyName() {
        return this._family;
    }
}

