/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.palette;

import java.awt.Color;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JLabel;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.palette.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropJLabel
extends JLabel
implements DropTargetListener {
    private DataFlavor _dataFlavor;
    private HashMap<String, NamedIcon> _iconMap;
    private static final Logger log = LoggerFactory.getLogger(DropJLabel.class);

    DropJLabel(Icon icon) {
        super(icon);
        try {
            this._dataFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=jmri.jmrit.catalog.NamedIcon");
        }
        catch (ClassNotFoundException cnfe) {
            log.error("Unable to find class supporting {}", (Object)"application/x-java-jvm-local-objectref;class=jmri.jmrit.catalog.NamedIcon", (Object)cnfe);
        }
        new DropTarget(this, 3, this);
    }

    DropJLabel(Icon icon, HashMap<String, NamedIcon> iconMap) {
        this(icon);
        this._iconMap = iconMap;
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        try {
            Transferable tr = e.getTransferable();
            if (e.isDataFlavorSupported(this._dataFlavor)) {
                NamedIcon newIcon = new NamedIcon((NamedIcon)tr.getTransferData(this._dataFlavor));
                this.accept(e, newIcon);
            } else if (e.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String text = (String)tr.getTransferData(DataFlavor.stringFlavor);
                if (log.isDebugEnabled()) {
                    log.debug("drop for stringFlavor {}", (Object)text);
                }
                NamedIcon newIcon = new NamedIcon(text, text);
                this.accept(e, newIcon);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("DropJLabel.drop REJECTED!");
                }
                e.rejectDrop();
            }
        }
        catch (IOException iOException) {
            if (log.isDebugEnabled()) {
                log.debug("DropPanel.drop REJECTED!");
            }
            e.rejectDrop();
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            if (log.isDebugEnabled()) {
                log.debug("DropJLabel.drop REJECTED!");
            }
            e.rejectDrop();
        }
    }

    protected void accept(DropTargetDropEvent e, NamedIcon newIcon) {
        e.acceptDrop(3);
        DropTarget target = (DropTarget)e.getSource();
        DropJLabel label = (DropJLabel)target.getComponent();
        if (log.isDebugEnabled()) {
            log.debug("accept drop of {} for {} name, {}", new Object[]{label.getClass().getName(), label.getName(), newIcon.getURL()});
        }
        if (newIcon.getIconWidth() < 1 || newIcon.getIconHeight() < 1) {
            label.setText(Bundle.getMessage("invisibleIcon"));
            label.setForeground(Color.lightGray);
        } else {
            label.setText(null);
        }
        label.setIcon(newIcon);
        if (this._iconMap != null) {
            String name = label.getName();
            if (name != null) {
                this._iconMap.put(name, newIcon);
            } else {
                log.error("Map key= {}, icon= {} ", (Object)label.getName(), (Object)newIcon.getName());
                e.dropComplete(false);
                return;
            }
        }
        e.dropComplete(true);
        if (log.isDebugEnabled()) {
            log.debug("DropJLabel.drop COMPLETED for {}, {}", (Object)label.getName(), (Object)newIcon.getURL());
        }
    }
}

