/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.palette;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import jmri.jmrit.display.palette.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DragJComponent
extends JPanel
implements DragGestureListener,
DragSourceListener,
Transferable {
    DataFlavor _dataFlavor;
    JComponent _component;
    private static final Logger log = LoggerFactory.getLogger(DragJComponent.class);

    public DragJComponent(DataFlavor flavor, JComponent comp) {
        this._component = comp;
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), Bundle.getMessage("dragToPanel")));
        this.add(comp);
        this.setPreferredSize();
        this.setToolTipText(Bundle.getMessage("ToolTipDragIcon"));
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 1, this);
        this._dataFlavor = flavor;
    }

    @Override
    public void invalidate() {
        this.setPreferredSize();
        super.invalidate();
    }

    protected void setPreferredSize() {
        Dimension dim = this._component.getSize();
        int width = Math.max(100, dim.width + 30);
        int height = Math.max(65, dim.height + 35);
        this.setPreferredSize(new Dimension(width, height));
    }

    protected JComponent getThing() {
        return this._component;
    }

    protected boolean okToDrag() {
        return true;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("DragJLabel.dragGestureRecognized ");
        }
        if (this.okToDrag()) {
            e.startDrag(DragSource.DefaultCopyDrop, this, this);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("DragJLabel.dragDropEnd ");
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
    }

    @Override
    public void dragExit(DragSourceEvent e) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{this._dataFlavor, DataFlavor.stringFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this._dataFlavor.equals(flavor);
    }
}

