/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.palette;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.Sensor;
import jmri.jmrit.display.palette.Bundle;
import jmri.jmrit.display.palette.ItemPanel;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.OPath;
import jmri.jmrit.picker.PickListModel;
import jmri.jmrit.picker.PickPanel;
import jmri.util.DnDStringImportHandler;

public class DetectionPanel
extends JPanel {
    private final JTextField _occDetectorName = new JTextField();
    private JFrame _pickFrame;
    private final JButton _openPicklistButton;
    private final JPanel _trainIdPanel;
    private JCheckBox _showTrainName;
    private OBlock _block;
    private final JPanel _blockPathPanel;
    private final JPanel _sensorBlurbPanel;
    private final ItemPanel _parent;
    private ArrayList<JCheckBox> _pathBoxes;
    private JPanel _checkBoxPanel;

    public DetectionPanel(ItemPanel parent) {
        this._parent = parent;
        this._occDetectorName.addActionListener(e -> this.checkDetection());
        this._occDetectorName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DetectionPanel.this.checkDetection();
            }
        });
        this.setLayout(new BoxLayout(this, 1));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.makeSensorPanel(this._occDetectorName, "OccupancySensor", "ToolTipOccupancySensor"));
        this._openPicklistButton = new JButton(Bundle.getMessage("OpenPicklist"));
        this._openPicklistButton.addActionListener(a -> {
            if (this._pickFrame == null) {
                this.openPickList();
            } else {
                this.closePickList();
            }
        });
        JPanel p = new JPanel();
        p.add(this._openPicklistButton);
        panel.add(p);
        this.add(panel);
        this._trainIdPanel = this.makeTrainIdPanel();
        this.add(this._trainIdPanel);
        this._blockPathPanel = new JPanel();
        this._blockPathPanel.setLayout(new BoxLayout(this._blockPathPanel, 1));
        p = new JPanel();
        p.add(new JLabel(Bundle.getMessage("SelectPathIcons")));
        this._blockPathPanel.add(p);
        this._checkBoxPanel = new JPanel();
        this._blockPathPanel.add(this._checkBoxPanel);
        this._blockPathPanel.add(Box.createVerticalStrut(5));
        this._blockPathPanel.setToolTipText(Bundle.getMessage("ToolTipSelectPathIcons"));
        this.add(this._blockPathPanel);
        this._sensorBlurbPanel = new JPanel();
        JPanel blurb = new JPanel();
        blurb.setLayout(new BoxLayout(blurb, 1));
        blurb.add(Box.createVerticalStrut(5));
        blurb.add(new JLabel(Bundle.getMessage("DetectorNote")));
        blurb.add(Box.createVerticalStrut(5));
        this._sensorBlurbPanel.add(blurb);
        this.add(this._sensorBlurbPanel);
    }

    JPanel makeSensorPanel(JTextField field, String text, String toolTip) {
        JPanel panel = new JPanel();
        JLabel label = new JLabel(Bundle.getMessage(text));
        panel.add(label);
        Dimension dim = field.getPreferredSize();
        dim.width = 500;
        field.setMaximumSize(dim);
        dim.width = 200;
        field.setMinimumSize(dim);
        field.setColumns(20);
        field.setDragEnabled(true);
        field.setTransferHandler(new DnDStringImportHandler());
        label.setToolTipText(Bundle.getMessage(toolTip));
        field.setToolTipText(Bundle.getMessage(toolTip));
        panel.setToolTipText(Bundle.getMessage(toolTip));
        panel.add(field);
        return panel;
    }

    void openPickList() {
        this._pickFrame = new JFrame();
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        JPanel blurb = new JPanel();
        blurb.setLayout(new BoxLayout(blurb, 1));
        blurb.add(Box.createVerticalStrut(5));
        blurb.add(new JLabel(Bundle.getMessage("DragOccupancyName", Bundle.getMessage("OccupancySensor"))));
        blurb.add(new JLabel(Bundle.getMessage("DetectorNote")));
        blurb.add(Box.createVerticalStrut(5));
        JPanel panel = new JPanel();
        panel.add(blurb);
        content.add(panel);
        PickListModel[] models = new PickListModel[]{PickListModel.oBlockPickModelInstance(), PickListModel.sensorPickModelInstance()};
        content.add(new PickPanel(models));
        this._pickFrame.setContentPane(content);
        this._pickFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DetectionPanel.this.closePickList();
            }
        });
        this._pickFrame.setLocationRelativeTo(this);
        this._pickFrame.toFront();
        this._pickFrame.setVisible(true);
        this._pickFrame.pack();
        this._openPicklistButton.setText(Bundle.getMessage("ClosePicklist"));
    }

    void closePickList() {
        this._pickFrame.dispose();
        this._pickFrame = null;
        this._openPicklistButton.setText(Bundle.getMessage("OpenPicklist"));
    }

    private JPanel makeTrainIdPanel() {
        JPanel panel = new JPanel();
        this._showTrainName = new JCheckBox(Bundle.getMessage("ShowTrainName"));
        this._showTrainName.setToolTipText(Bundle.getMessage("ToolTipShowTrainName"));
        JPanel p = new JPanel();
        p.add(this._showTrainName);
        p.setToolTipText(Bundle.getMessage("ToolTipShowTrainName"));
        panel.add(p);
        return panel;
    }

    public void dispose() {
        if (this._pickFrame != null) {
            this._pickFrame.dispose();
            this._pickFrame = null;
        }
    }

    public boolean getShowTrainName() {
        return this._showTrainName.isSelected();
    }

    public void setShowTrainName(boolean show) {
        this._showTrainName.setSelected(show);
    }

    public String getOccSensor() {
        String name = this._occDetectorName.getText();
        if (name != null && name.trim().length() > 0 && InstanceManager.sensorManagerInstance().getSensor(name) != null) {
            return name;
        }
        return null;
    }

    public String getOccBlock() {
        String name = this._occDetectorName.getText();
        if (name != null && name.trim().length() > 0 && InstanceManager.getDefault(OBlockManager.class).getOBlock(name) != null) {
            return name;
        }
        return null;
    }

    public void setOccDetector(String name) {
        this._occDetectorName.setText(name);
        this.checkDetection();
    }

    public ArrayList<String> getPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        if (this._pathBoxes != null) {
            for (JCheckBox pathBox : this._pathBoxes) {
                if (!pathBox.isSelected()) continue;
                paths.add(pathBox.getName().trim());
            }
        }
        return paths;
    }

    public void setPaths(ArrayList<String> iconPath) {
        if (iconPath == null || this._block == null) {
            this._pathBoxes = null;
            return;
        }
        for (String s : iconPath) {
            for (JCheckBox pathBox : this._pathBoxes) {
                String name = pathBox.getName().trim();
                if (!s.equals(name)) continue;
                pathBox.setSelected(true);
            }
        }
    }

    private void checkDetection() {
        String name = this._occDetectorName.getText();
        if (name != null && name.trim().length() > 0) {
            OBlock block = InstanceManager.getDefault(OBlockManager.class).getOBlock(name);
            if (block != null) {
                if (block.equals(this._block)) {
                    return;
                }
                this.makePathList(block);
                this.showPanels(true);
            } else {
                Sensor sensor = InstanceManager.sensorManagerInstance().getSensor(name);
                if (sensor == null) {
                    JOptionPane.showMessageDialog(this._parent._frame, Bundle.getMessage("InvalidOccDetector", name), Bundle.getMessage("WarningTitle"), 2);
                    this._occDetectorName.setText(null);
                }
                this.showPanels(false);
            }
        } else {
            this.showPanels(false);
        }
    }

    private void showPanels(boolean hasOBlock) {
        this._trainIdPanel.setVisible(hasOBlock);
        this._blockPathPanel.setVisible(hasOBlock);
        this._sensorBlurbPanel.setVisible(!hasOBlock);
        if (!hasOBlock) {
            this._block = null;
        }
        this.invalidate();
        this._parent.hideIcons();
    }

    private void makePathList(OBlock block) {
        this._blockPathPanel.remove(this._checkBoxPanel);
        this._checkBoxPanel = new JPanel();
        this._checkBoxPanel.setLayout(new BoxLayout(this._checkBoxPanel, 1));
        this._checkBoxPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), Bundle.getMessage("circuitPaths")));
        this._checkBoxPanel.add(Box.createHorizontalStrut(100));
        this._block = block;
        this._pathBoxes = new ArrayList();
        this._block.getPaths().stream().filter(o -> o instanceof OPath).map(o -> ((OPath)o).getName()).forEach(name -> {
            if (name.length() < 25) {
                char[] ca = new char[25];
                int j = 0;
                while (j < name.length()) {
                    ca[j] = name.charAt(j);
                    ++j;
                }
                j = name.length();
                while (j < 25) {
                    ca[j] = 32;
                    ++j;
                }
                name = new String(ca);
            }
            JCheckBox box = new JCheckBox((String)name);
            box.setName((String)name);
            this._pathBoxes.add(box);
            this._checkBoxPanel.add(box);
        });
        this._blockPathPanel.add((Component)this._checkBoxPanel, 1);
    }
}

