/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.palette;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jmri.InstanceManager;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableLabel;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.jmrit.display.palette.Bundle;
import jmri.jmrit.display.palette.FontPanel;
import jmri.jmrit.display.palette.TextItemPanel;
import jmri.util.PlaceWindow;
import jmri.util.swing.JmriColorChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorDialog
extends JDialog
implements ChangeListener {
    public static final int STRUT = 6;
    public static final int ONLY = 0;
    public static final int BORDER = 1;
    public static final int MARGIN = 2;
    public static final int FWIDTH = 3;
    public static final int FHEIGHT = 4;
    public static final int FONT = 5;
    public static final int TEXT = 6;
    JColorChooser _chooser;
    JComponent _target;
    int _type;
    Color _saveColor;
    boolean _saveOpaque;
    String _saveText;
    PositionablePopupUtil _util;
    PositionablePopupUtil _saveUtil;
    ActionListener _colorAction;
    JPanel _preview;
    private static final Logger log = LoggerFactory.getLogger(ColorDialog.class);

    public ColorDialog(Frame client, JComponent t, int type, ActionListener ca) {
        super(client, true);
        String title;
        this._target = t;
        this._type = type;
        if (t instanceof Positionable) {
            Positionable pos = (Positionable)((Object)t);
            this._util = pos.getPopupUtility();
            if (this._util != null) {
                this._util.setSuppressRecentColor(true);
                Positionable p = pos.deepClone();
                this._saveUtil = p.getPopupUtility();
                p.remove();
            }
        } else {
            this._util = null;
        }
        this._saveOpaque = t.isOpaque();
        this._colorAction = ca;
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(Box.createVerticalGlue());
        switch (type) {
            case 0: {
                title = "PanelColor";
                this._saveColor = t.getBackground();
                break;
            }
            case 1: {
                title = "SetBorderSizeColor";
                this._saveColor = this._util.getBorderColor();
                SpinnerNumberModel model = new SpinnerNumberModel(this._util.getBorderSize(), 0, 100, 1);
                JPanel p = this.makePanel(TextItemPanel.makeSpinPanel("borderSize", new TextItemPanel.AJSpinner(model, 1), this));
                panel.add(p);
                break;
            }
            case 2: {
                title = "SetMarginSizeColor";
                this._saveColor = this._util.getBackground();
                SpinnerNumberModel model = new SpinnerNumberModel(this._util.getMargin(), 0, 100, 1);
                JPanel p = this.makePanel(TextItemPanel.makeSpinPanel("marginSize", new TextItemPanel.AJSpinner(model, 2), this));
                panel.add(p);
                break;
            }
            case 5: {
                title = "SetFontSizeColor";
                this._saveColor = this._util.getForeground();
                ActionListener fontAction = event -> this.update();
                FontPanel fontPanel = new FontPanel(this._util, fontAction);
                panel.add(fontPanel);
                fontPanel.setFontSelections();
                break;
            }
            case 6: {
                title = "SetTextSizeColor";
                this._saveColor = this._util.getBackground();
                this._saveText = ((PositionableLabel)t).getUnRotatedText();
                panel.add(this.makePanel(this.makeTextSpinnerPanel()));
                panel.add(Box.createVerticalGlue());
                panel.add(this.makePanel(this.makeTextPanel()));
                break;
            }
            default: {
                title = "ColorChooser";
                this._saveColor = t.getBackground();
            }
        }
        panel.add(Box.createVerticalStrut(6));
        this.setTitle(Bundle.getMessage(title));
        this._chooser = JmriColorChooser.extendColorChooser(new JColorChooser(this._saveColor));
        this._chooser.getSelectionModel().addChangeListener(this);
        this._chooser.setPreviewPanel(new JPanel());
        JmriColorChooser.suppressAddRecentColor(true);
        panel.add(this._chooser);
        panel.add(Box.createVerticalStrut(6));
        panel.add(this.makeDoneButtonPanel());
        panel.add(Box.createVerticalGlue());
        super.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ColorDialog.this.cancel();
            }
        });
        this.setContentPane(panel);
        this.pack();
        InstanceManager.getDefault(PlaceWindow.class).nextTo(client, t, this);
        this.setVisible(true);
    }

    JPanel makePanel(JPanel p) {
        JPanel panel = new JPanel();
        panel.add(p);
        return panel;
    }

    JPanel makeTextSpinnerPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        SpinnerNumberModel model = new SpinnerNumberModel(this._util.getFixedWidth(), 0, 1000, 1);
        panel.add(TextItemPanel.makeSpinPanel("fixedWidth", new TextItemPanel.AJSpinner(model, 3), this));
        panel.add(Box.createHorizontalStrut(6));
        model = new SpinnerNumberModel(this._util.getFixedHeight(), 0, 1000, 1);
        panel.add(TextItemPanel.makeSpinPanel("fixedHeight", new TextItemPanel.AJSpinner(model, 4), this));
        return panel;
    }

    JPanel makeTextPanel() {
        JPanel panel = new JPanel();
        JTextField textField = new JTextField(this._saveText, 25);
        textField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent evt) {
            }

            @Override
            public void keyPressed(KeyEvent evt) {
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                JTextField tmp = (JTextField)evt.getSource();
                ((PositionableLabel)ColorDialog.this._target).setText(tmp.getText());
                ColorDialog.this.update();
            }
        });
        panel.add(textField);
        return panel;
    }

    protected JPanel makeDoneButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        JButton doneButton = new JButton(Bundle.getMessage("ButtonDone"));
        doneButton.addActionListener(event -> this.done());
        panel.add(doneButton);
        JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
        cancelButton.addActionListener(event -> this.cancel());
        panel.add(cancelButton);
        return panel;
    }

    void done() {
        log.debug("Done button: color= {}", (Object)this._chooser.getColor());
        if (this._colorAction != null) {
            this._colorAction.actionPerformed(null);
        }
        if (this._util != null) {
            this._util.setSuppressRecentColor(false);
        }
        JmriColorChooser.suppressAddRecentColor(false);
        JmriColorChooser.addRecentColor(this._chooser.getColor());
        this.dispose();
    }

    void cancel() {
        if (this._util != null) {
            Positionable pl = (Positionable)((Object)this._target);
            pl.getEditor().setAttributes(this._saveUtil, pl);
            this._util.setSuppressRecentColor(false);
            pl.updateSize();
            if (this._type == 6) {
                ((PositionableLabel)this._target).setText(this._saveText);
            }
        } else {
            this._target.setBackground(this._saveColor);
        }
        this._target.setOpaque(this._saveOpaque);
        log.debug("Cancel: color= {}", (Object)this._saveColor);
        JmriColorChooser.suppressAddRecentColor(false);
        this.dispose();
    }

    private void update() {
        if (this._util != null) {
            Positionable pl = (Positionable)((Object)this._target);
            pl.getEditor().setAttributes(this._util, pl);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object obj = e.getSource();
        if (obj instanceof TextItemPanel.AJSpinner) {
            int num = ((Number)((TextItemPanel.AJSpinner)obj).getValue()).intValue();
            switch (((TextItemPanel.AJSpinner)obj)._which) {
                case 1: {
                    this._util.setBorderSize(num);
                    break;
                }
                case 2: {
                    this._util.setMargin(num);
                    break;
                }
                case 3: {
                    this._util.setFixedWidth(num);
                    break;
                }
                case 4: {
                    this._util.setFixedHeight(num);
                    break;
                }
                default: {
                    log.warn("Unexpected _which {}  in stateChanged", (Object)((TextItemPanel.AJSpinner)obj)._which);
                    break;
                }
            }
        } else {
            log.debug("stateChanged: color= {}", (Object)this._chooser.getColor());
            if (this._util != null) {
                switch (this._type) {
                    case 1: {
                        this._util.setBorderColor(this._chooser.getColor());
                        break;
                    }
                    case 2: {
                        this._util.setBackgroundColor(this._chooser.getColor());
                        break;
                    }
                    case 5: 
                    case 6: {
                        this._util.setForeground(this._chooser.getColor());
                    }
                }
            } else {
                this._target.setOpaque(true);
                this._target.setBackground(this._chooser.getColor());
            }
        }
        this.update();
    }
}

