/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.palette;

import java.awt.Color;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.jmrit.catalog.DragJLabel;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.AnalogClock2Display;
import jmri.jmrit.display.DisplayFrame;
import jmri.jmrit.display.palette.Bundle;
import jmri.jmrit.display.palette.IconItemPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClockItemPanel
extends IconItemPanel {
    private static final Logger log = LoggerFactory.getLogger(ClockItemPanel.class);

    public ClockItemPanel(DisplayFrame parentFrame, String type) {
        super(parentFrame, type);
        this.setToolTipText(Bundle.getMessage("ToolTipDragIcon"));
    }

    @Override
    protected JPanel instructions() {
        JPanel blurb = new JPanel();
        blurb.setLayout(new BoxLayout(blurb, 1));
        blurb.add(Box.createVerticalStrut(5));
        blurb.add(new JLabel(Bundle.getMessage("AddClockToPanel", Bundle.getMessage("FastClock"))));
        blurb.add(Box.createVerticalStrut(5));
        JPanel panel = new JPanel();
        panel.add(blurb);
        return panel;
    }

    @Override
    public void init() {
        if (!this._initialized) {
            this.initIconFamiliesPanel();
            this.initLinkPanel();
            this.add(Box.createVerticalGlue());
        }
        this._previewPanel.invalidate();
        this.hideIcons();
    }

    @Override
    protected JPanel makeIconDisplayPanel(String key, HashMap<String, NamedIcon> iconMap, boolean dropIcon) {
        JLabel label;
        NamedIcon icon = iconMap.get(key);
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        if (dropIcon) {
            try {
                label = new ClockDragJLabel(new DataFlavor("application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable"), icon);
            }
            catch (ClassNotFoundException cnfe) {
                label = new JLabel(cnfe.toString());
                log.error("Unable to find class supporting {}", (Object)"application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable", (Object)cnfe);
            }
        } else {
            label = new JLabel(icon);
        }
        if (icon.getIconWidth() < 1 || icon.getIconHeight() < 1) {
            label.setText(Bundle.getMessage("invisibleIcon"));
            label.setForeground(Color.lightGray);
        }
        this.wrapIconImage(icon, label, panel, key);
        return panel;
    }

    public class ClockDragJLabel
    extends DragJLabel {
        public ClockDragJLabel(DataFlavor flavor, NamedIcon icon) {
            super(flavor, icon);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                return null;
            }
            String url = ((NamedIcon)this.getIcon()).getURL();
            log.debug("DragJLabel.getTransferData url= {}", (Object)url);
            if (flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable")) {
                String link = ClockItemPanel.this._linkName.getText().trim();
                AnalogClock2Display c = link.length() == 0 ? new AnalogClock2Display(ClockItemPanel.this._frame.getEditor()) : new AnalogClock2Display(ClockItemPanel.this._frame.getEditor(), link);
                c.setOpaque(false);
                c.update();
                c.setLevel(10);
                return c;
            }
            if (DataFlavor.stringFlavor.equals(flavor)) {
                return String.valueOf(ClockItemPanel.this._itemType) + " icon \"" + url + "\"";
            }
            return null;
        }
    }
}

