/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.palette;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jmri.jmrit.display.DisplayFrame;
import jmri.jmrit.display.palette.Bundle;
import jmri.jmrit.display.palette.IconItemPanel;
import jmri.jmrit.display.palette.ItemPalette;
import jmri.util.swing.DrawSquares;
import jmri.util.swing.ImagePanel;
import jmri.util.swing.JmriColorChooser;

public class BackgroundItemPanel
extends IconItemPanel {
    JColorChooser _chooser;
    JButton _colorButton;
    JPanel _colorPanel;
    Color _color;

    public BackgroundItemPanel(DisplayFrame parentFrame, String type) {
        super(parentFrame, type);
        this._level = 1;
    }

    @Override
    public void init() {
        if (!this._initialized) {
            super.init();
            this._colorPanel = this.makeColorPanel();
            this.add(this._colorPanel);
        }
    }

    @Override
    protected JPanel instructions() {
        JPanel blurb = new JPanel();
        blurb.setLayout(new BoxLayout(blurb, 1));
        blurb.add(new JLabel(Bundle.getMessage("DragIconPanel")));
        blurb.add(new JLabel(Bundle.getMessage("DragIconCatalog")));
        blurb.add(Box.createVerticalStrut(5));
        JLabel label = new JLabel(Bundle.getMessage("BackgroundIcons"));
        label.setForeground(Color.RED);
        blurb.add(label);
        JPanel panel = new JPanel();
        panel.add(blurb);
        return panel;
    }

    @Override
    protected JPanel makeItemButtonPanel() {
        JPanel panel = super.makeItemButtonPanel();
        panel.add(this.makeColorButton());
        return panel;
    }

    @Override
    protected JPanel makeSpecialBottomPanel(boolean update) {
        JPanel _bottom2Panel = super.makeSpecialBottomPanel(update);
        _bottom2Panel.add((Component)this.makeColorButton(), 1);
        return _bottom2Panel;
    }

    @Override
    protected void initLinkPanel() {
    }

    @Override
    protected void showCatalog() {
        this._colorPanel.setVisible(false);
        this._colorPanel.invalidate();
        super.showCatalog();
    }

    private void showColorPanel() {
        this.deselectIcon();
        this._chooser.setColor(this._frame.getCurrentColor());
        Dimension totalDim = this._frame.getSize();
        Dimension oldDim = this.getSize();
        boolean isPalette = this._frame instanceof ItemPalette;
        this._catalog.setVisible(false);
        this._catalog.invalidate();
        this._colorPanel.setVisible(true);
        this._colorPanel.invalidate();
        this._bottomPanel.setVisible(false);
        this._bottomPanel.invalidate();
        this.reSizeDisplay(isPalette, oldDim, totalDim);
        this._colorButton.setText(Bundle.getMessage("HideColorPanel"));
    }

    private void hideColorPanel() {
        this._chooser.setColor(this._frame.getCurrentColor());
        Dimension totalDim = this._frame.getSize();
        Dimension oldDim = this.getSize();
        boolean isPalette = this._frame instanceof ItemPalette;
        this._colorPanel.setVisible(false);
        this._colorPanel.invalidate();
        this._bottomPanel.setVisible(true);
        this._bottomPanel.invalidate();
        this.reSizeDisplay(isPalette, oldDim, totalDim);
        this._colorButton.setText(Bundle.getMessage("ShowColorPanel"));
    }

    private JButton makeColorButton() {
        this._colorButton = new JButton(Bundle.getMessage("ButtonShowColorPanel"));
        this._colorButton.addActionListener(a -> {
            if (this._colorPanel.isVisible()) {
                this.hideColorPanel();
            } else {
                this.showColorPanel();
            }
        });
        this._colorButton.setToolTipText(Bundle.getMessage("ToolTipColor"));
        return this._colorButton;
    }

    protected JPanel makeColorButtonPanel() {
        JPanel panel = new JPanel();
        JButton button = new JButton(Bundle.getMessage("ButtonBackgroundColor"));
        button.addActionListener(a -> this.setColor());
        button.setToolTipText(Bundle.getMessage("ToColorBackground", Bundle.getMessage("ButtonBackgroundColor")));
        panel.add(button);
        button = new JButton(Bundle.getMessage("ButtonCancel"));
        button.addActionListener(a -> this.hideColorPanel());
        button.setToolTipText(Bundle.getMessage("ToColorBackground", Bundle.getMessage("ButtonBackgroundColor")));
        panel.add(button);
        panel.setToolTipText(Bundle.getMessage("ToColorBackground", Bundle.getMessage("ButtonBackgroundColor")));
        return panel;
    }

    private JPanel makeColorPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this._chooser = new JColorChooser(this._frame.getCurrentColor());
        this._chooser.setPreviewPanel(new JPanel());
        this._chooser.getSelectionModel().addChangeListener(e -> this.colorChange());
        this._chooser.setColor(this._frame.getCurrentColor());
        JmriColorChooser.extendColorChooser(this._chooser);
        panel.add(this._chooser);
        panel.add(this.makeColorButtonPanel());
        panel.setToolTipText(Bundle.getMessage("ToColorBackground", Bundle.getMessage("ButtonBackgroundColor")));
        panel.setVisible(false);
        return panel;
    }

    private void colorChange() {
        this._color = this._chooser.getColor();
        this._iconPanel.setImage(DrawSquares.getImage(500, 400, 10, this._color, this._color));
        this._iconPanel.invalidate();
    }

    private void setColor() {
        if (this._color == null) {
            JOptionPane.showMessageDialog(this._frame, Bundle.getMessage("ToColorBackground", Bundle.getMessage("ButtonBackgroundColor")), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this._frame.getEditor().setBackgroundColor(this._color);
        this._frame.updateBackground(this._frame.getEditor());
        this.hideColorPanel();
    }

    @Override
    protected void previewColorChange() {
        if (this._initialized) {
            ImagePanel iconPanel = this._catalog.getPreviewPanel();
            if (iconPanel != null) {
                iconPanel.setImage(this._frame.getPreviewBackground());
            }
            this._iconPanel.setImage(this._frame.getPreviewBackground());
            this._iconPanel.setImage(this._frame.getBackground(0));
        }
    }
}

