/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor.configurexml;

import java.awt.geom.Point2D;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.PositionablePoint;
import jmri.jmrit.display.layoutEditor.PositionablePointView;
import org.jdom2.Attribute;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionablePointViewXml
extends AbstractXmlAdapter {
    static final AbstractXmlAdapter.EnumIO<PositionablePoint.PointType> pTypeEnumMap = new AbstractXmlAdapter.EnumIoNamesNumbers<PositionablePoint.PointType>(PositionablePoint.PointType.class);
    private static final Logger log = LoggerFactory.getLogger(PositionablePointViewXml.class);

    @Override
    public Element store(Object o) {
        PositionablePointView pv = (PositionablePointView)o;
        PositionablePoint p = pv.getPoint();
        Element element = new Element("positionablepoint");
        element.setAttribute("ident", p.getId());
        element.setAttribute("type", pTypeEnumMap.outputFromEnum(p.getType()));
        Point2D coords = pv.getCoordsCenter();
        element.setAttribute("x", "" + coords.getX());
        element.setAttribute("y", "" + coords.getY());
        if (p.getConnect1() != null) {
            element.setAttribute("connect1name", p.getConnect1().getId());
        }
        if (p.getConnect2() != null) {
            element.setAttribute("connect2name", p.getConnect2().getId());
        }
        if (!p.getEastBoundSignal().isEmpty()) {
            element.setAttribute("eastboundsignal", p.getEastBoundSignal());
        }
        if (!p.getWestBoundSignal().isEmpty()) {
            element.setAttribute("westboundsignal", p.getWestBoundSignal());
        }
        if (!p.getEastBoundSignalMastName().isEmpty()) {
            element.setAttribute("eastboundsignalmast", p.getEastBoundSignalMastName());
        }
        if (!p.getWestBoundSignalMastName().isEmpty()) {
            element.setAttribute("westboundsignalmast", p.getWestBoundSignalMastName());
        }
        if (!p.getEastBoundSensorName().isEmpty()) {
            element.setAttribute("eastboundsensor", p.getEastBoundSensorName());
        }
        if (!p.getWestBoundSensorName().isEmpty()) {
            element.setAttribute("westboundsensor", p.getWestBoundSensorName());
        }
        if (p.getType() == PositionablePoint.PointType.EDGE_CONNECTOR) {
            element.setAttribute("linkedpanel", p.getLinkedEditorName());
            element.setAttribute("linkpointid", p.getLinkedPointId());
        }
        element.setAttribute("class", "jmri.jmrit.display.layoutEditor.configurexml.PositionablePointXml");
        return element;
    }

    @Override
    public boolean load(@Nonnull Element shared, Element perNode) {
        log.error("Invalid method called");
        return false;
    }

    @Override
    public void load(Element element, Object o) {
        LayoutEditor p = (LayoutEditor)o;
        String name = element.getAttribute("ident").getValue();
        PositionablePoint.PointType type = PositionablePoint.PointType.ANCHOR;
        double x = 0.0;
        double y = 0.0;
        try {
            x = element.getAttribute("x").getFloatValue();
            y = element.getAttribute("y").getFloatValue();
            type = pTypeEnumMap.inputFromAttribute(element.getAttribute("type"));
        }
        catch (DataConversionException dataConversionException) {
            log.error("failed to convert positionablepoint attribute");
        }
        PositionablePoint l = new PositionablePoint(name, type, p);
        PositionablePointView pv = new PositionablePointView(l, (Point2D)new Point2D.Double(x, y), p);
        p.addLayoutTrack(l, pv);
        Attribute a = element.getAttribute("connect1name");
        if (a != null) {
            l.trackSegment1Name = a.getValue();
        }
        if ((a = element.getAttribute("connect2name")) != null) {
            l.trackSegment2Name = a.getValue();
        }
        if ((a = element.getAttribute("eastboundsignal")) != null) {
            l.setEastBoundSignal(a.getValue());
        }
        if ((a = element.getAttribute("westboundsignal")) != null) {
            l.setWestBoundSignal(a.getValue());
        }
        if ((a = element.getAttribute("eastboundsignalmast")) != null) {
            l.setEastBoundSignalMast(a.getValue());
        }
        if ((a = element.getAttribute("westboundsignalmast")) != null) {
            l.setWestBoundSignalMast(a.getValue());
        }
        if ((a = element.getAttribute("eastboundsensor")) != null) {
            l.setEastBoundSensor(a.getValue());
        }
        if ((a = element.getAttribute("westboundsensor")) != null) {
            l.setWestBoundSensor(a.getValue());
        }
        if (type == PositionablePoint.PointType.EDGE_CONNECTOR && element.getAttribute("linkedpanel") != null && element.getAttribute("linkpointid") != null) {
            String linkedEditorName = element.getAttribute("linkedpanel").getValue();
            LayoutEditor linkedEditor = InstanceManager.getDefault(EditorManager.class).get(LayoutEditor.class, linkedEditorName);
            if (linkedEditor != null) {
                String linkedPoint = element.getAttribute("linkpointid").getValue();
                for (PositionablePoint point : linkedEditor.getPositionablePoints()) {
                    if (point.getType() != PositionablePoint.PointType.EDGE_CONNECTOR || !point.getId().equals(linkedPoint)) continue;
                    point.setLinkedPoint(l);
                    l.setLinkedPoint(point);
                    break;
                }
            }
        }
    }
}

