/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor.configurexml;

import java.awt.geom.Point2D;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.jmrit.display.layoutEditor.LayoutDoubleSlip;
import jmri.jmrit.display.layoutEditor.LayoutDoubleSlipView;
import jmri.jmrit.display.layoutEditor.LayoutDoubleXOver;
import jmri.jmrit.display.layoutEditor.LayoutDoubleXOverView;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutLHTurnout;
import jmri.jmrit.display.layoutEditor.LayoutLHTurnoutView;
import jmri.jmrit.display.layoutEditor.LayoutLHXOver;
import jmri.jmrit.display.layoutEditor.LayoutLHXOverView;
import jmri.jmrit.display.layoutEditor.LayoutRHTurnout;
import jmri.jmrit.display.layoutEditor.LayoutRHTurnoutView;
import jmri.jmrit.display.layoutEditor.LayoutRHXOver;
import jmri.jmrit.display.layoutEditor.LayoutRHXOverView;
import jmri.jmrit.display.layoutEditor.LayoutSingleSlip;
import jmri.jmrit.display.layoutEditor.LayoutSingleSlipView;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.LayoutTurnoutView;
import jmri.jmrit.display.layoutEditor.LayoutWye;
import jmri.jmrit.display.layoutEditor.LayoutWyeView;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutTurnoutViewXml
extends AbstractXmlAdapter {
    static final AbstractXmlAdapter.EnumIO<LayoutTurnout.LinkType> linkEnumMap = new AbstractXmlAdapter.EnumIoNamesNumbers<LayoutTurnout.LinkType>(LayoutTurnout.LinkType.class);
    static final AbstractXmlAdapter.EnumIO<LayoutTurnout.TurnoutType> tTypeEnumMap = new AbstractXmlAdapter.EnumIoNamesNumbers<LayoutTurnout.TurnoutType>(LayoutTurnout.TurnoutType.class);
    private static final Logger log = LoggerFactory.getLogger(LayoutTurnoutViewXml.class);

    protected void addClass(Element element) {
        element.setAttribute("class", "jmri.jmrit.display.layoutEditor.configurexml.LayoutTurnoutXml");
    }

    @Override
    public Element store(Object o) {
        LayoutTurnoutView pv = (LayoutTurnoutView)o;
        LayoutTurnout p = pv.getLayoutTurnout();
        Element element = new Element("layoutturnout");
        element.setAttribute("ident", p.getName());
        element.setAttribute("type", tTypeEnumMap.outputFromEnum(p.getTurnoutType()));
        element.setAttribute("hidden", pv.isHidden() ? "yes" : "no");
        element.setAttribute("disabled", p.isDisabled() ? "yes" : "no");
        element.setAttribute("disableWhenOccupied", p.isDisabledWhenOccupied() ? "yes" : "no");
        element.setAttribute("continuing", "" + p.getContinuingSense());
        Point2D coords = pv.getCoordsCenter();
        element.setAttribute("xcen", "" + coords.getX());
        element.setAttribute("ycen", "" + coords.getY());
        coords = pv.getCoordsA();
        element.setAttribute("xa", "" + coords.getX());
        element.setAttribute("ya", "" + coords.getY());
        coords = pv.getCoordsB();
        element.setAttribute("xb", "" + coords.getX());
        element.setAttribute("yb", "" + coords.getY());
        coords = pv.getCoordsC();
        element.setAttribute("xc", "" + coords.getX());
        element.setAttribute("yc", "" + coords.getY());
        coords = pv.getCoordsD();
        element.setAttribute("xd", "" + coords.getX());
        element.setAttribute("yd", "" + coords.getY());
        element.setAttribute("ver", "" + p.getVersion());
        this.addClass(element);
        if (!p.getTurnoutName().isEmpty()) {
            element.setAttribute("turnoutname", p.getTurnoutName());
        }
        if (!p.getSecondTurnoutName().isEmpty()) {
            element.setAttribute("secondturnoutname", p.getSecondTurnoutName());
            if (p.isSecondTurnoutInverted()) {
                element.setAttribute("secondturnoutinverted", "true");
            }
        }
        if (!p.getLinkedTurnoutName().isEmpty()) {
            element.setAttribute("linkedturnoutname", p.getLinkedTurnoutName());
            element.setAttribute("linktype", linkEnumMap.outputFromEnum(p.getLinkType()));
        }
        if (!p.getBlockName().isEmpty()) {
            element.setAttribute("blockname", p.getBlockName());
        }
        if (!p.getBlockBName().isEmpty() && !p.getBlockBName().equals(p.getBlockName())) {
            element.setAttribute("blockbname", p.getBlockBName());
        }
        if (!p.getBlockCName().isEmpty() && !p.getBlockCName().equals(p.getBlockName())) {
            element.setAttribute("blockcname", p.getBlockCName());
        }
        if (!p.getBlockDName().isEmpty() && !p.getBlockDName().equals(p.getBlockName())) {
            element.setAttribute("blockdname", p.getBlockDName());
        }
        if (p.getConnectA() != null) {
            element.setAttribute("connectaname", ((TrackSegment)p.getConnectA()).getId());
        }
        if (p.getConnectB() != null) {
            element.setAttribute("connectbname", ((TrackSegment)p.getConnectB()).getId());
        }
        if (p.getConnectC() != null) {
            element.setAttribute("connectcname", ((TrackSegment)p.getConnectC()).getId());
        }
        if (p.getConnectD() != null) {
            element.setAttribute("connectdname", ((TrackSegment)p.getConnectD()).getId());
        }
        if (!p.getSignalA1Name().isEmpty()) {
            element.setAttribute("signala1name", p.getSignalA1Name());
        }
        if (!p.getSignalA2Name().isEmpty()) {
            element.setAttribute("signala2name", p.getSignalA2Name());
        }
        if (!p.getSignalA3Name().isEmpty()) {
            element.setAttribute("signala3name", p.getSignalA3Name());
        }
        if (!p.getSignalB1Name().isEmpty()) {
            element.setAttribute("signalb1name", p.getSignalB1Name());
        }
        if (!p.getSignalB2Name().isEmpty()) {
            element.setAttribute("signalb2name", p.getSignalB2Name());
        }
        if (!p.getSignalC1Name().isEmpty()) {
            element.setAttribute("signalc1name", p.getSignalC1Name());
        }
        if (!p.getSignalC2Name().isEmpty()) {
            element.setAttribute("signalc2name", p.getSignalC2Name());
        }
        if (!p.getSignalD1Name().isEmpty()) {
            element.setAttribute("signald1name", p.getSignalD1Name());
        }
        if (!p.getSignalD2Name().isEmpty()) {
            element.setAttribute("signald2name", p.getSignalD2Name());
        }
        if (!p.getSignalAMastName().isEmpty()) {
            element.addContent((Content)new Element("signalAMast").addContent(p.getSignalAMastName()));
        }
        if (!p.getSignalBMastName().isEmpty()) {
            element.addContent((Content)new Element("signalBMast").addContent(p.getSignalBMastName()));
        }
        if (!p.getSignalCMastName().isEmpty()) {
            element.addContent((Content)new Element("signalCMast").addContent(p.getSignalCMastName()));
        }
        if (!p.getSignalDMastName().isEmpty()) {
            element.addContent((Content)new Element("signalDMast").addContent(p.getSignalDMastName()));
        }
        if (!p.getSensorAName().isEmpty()) {
            element.addContent((Content)new Element("sensorA").addContent(p.getSensorAName()));
        }
        if (!p.getSensorBName().isEmpty()) {
            element.addContent((Content)new Element("sensorB").addContent(p.getSensorBName()));
        }
        if (!p.getSensorCName().isEmpty()) {
            element.addContent((Content)new Element("sensorC").addContent(p.getSensorCName()));
        }
        if (!p.getSensorDName().isEmpty()) {
            element.addContent((Content)new Element("sensorD").addContent(p.getSensorDName()));
        }
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        log.error("Invalid method called");
        return false;
    }

    @Override
    public void load(Element element, Object o) {
        LayoutTurnoutView lv;
        LayoutTurnout l;
        LayoutEditor p = (LayoutEditor)o;
        String name = element.getAttribute("ident").getValue();
        double x = 0.0;
        double y = 0.0;
        LayoutTurnout.TurnoutType type = LayoutTurnout.TurnoutType.NONE;
        try {
            x = element.getAttribute("xcen").getFloatValue();
            y = element.getAttribute("ycen").getFloatValue();
            type = tTypeEnumMap.inputFromAttribute(element.getAttribute("type"));
        }
        catch (DataConversionException dataConversionException) {
            log.error("failed to convert layoutturnout attribute");
        }
        int version = 1;
        try {
            if (element.getAttribute("ver") != null) {
                version = element.getAttribute("ver").getIntValue();
            }
        }
        catch (DataConversionException dataConversionException) {
            log.error("failed to convert layoutturnout version attribute");
        }
        switch (type) {
            case RH_TURNOUT: {
                LayoutRHTurnout lrht = new LayoutRHTurnout(name, p, version);
                l = lrht;
                lv = new LayoutRHTurnoutView(lrht, (Point2D)new Point2D.Double(x, y), 0.0, 1.0, 1.0, p);
                break;
            }
            case LH_TURNOUT: {
                LayoutLHTurnout llht = new LayoutLHTurnout(name, p, version);
                l = llht;
                lv = new LayoutLHTurnoutView(llht, (Point2D)new Point2D.Double(x, y), 0.0, 1.0, 1.0, p);
                break;
            }
            case WYE_TURNOUT: {
                LayoutWye lwt = new LayoutWye(name, p, version);
                l = lwt;
                lv = new LayoutWyeView(lwt, (Point2D)new Point2D.Double(x, y), 0.0, 1.0, 1.0, p);
                break;
            }
            case DOUBLE_XOVER: {
                LayoutDoubleXOver ldx = new LayoutDoubleXOver(name, p, version);
                l = ldx;
                lv = new LayoutDoubleXOverView(ldx, (Point2D)new Point2D.Double(x, y), 0.0, 1.0, 1.0, p);
                break;
            }
            case RH_XOVER: {
                LayoutRHXOver lrx = new LayoutRHXOver(name, p, version);
                l = lrx;
                lv = new LayoutRHXOverView(lrx, (Point2D)new Point2D.Double(x, y), 0.0, 1.0, 1.0, p);
                break;
            }
            case LH_XOVER: {
                LayoutLHXOver llx = new LayoutLHXOver(name, p, version);
                l = llx;
                lv = new LayoutLHXOverView(llx, (Point2D)new Point2D.Double(x, y), 0.0, 1.0, 1.0, p);
                break;
            }
            case DOUBLE_SLIP: {
                LayoutDoubleSlip lds = new LayoutDoubleSlip(name, p);
                l = lds;
                lv = new LayoutDoubleSlipView(lds, (Point2D)new Point2D.Double(x, y), 0.0, p);
                log.error("Found DOUBLE_SLIP in LayoutTrack ctor for element {}", (Object)name);
                break;
            }
            case SINGLE_SLIP: {
                LayoutSingleSlip lss = new LayoutSingleSlip(name, p);
                l = lss;
                lv = new LayoutSingleSlipView(lss, (Point2D)new Point2D.Double(x, y), 0.0, p);
                log.error("Found SINGLE_SLIP in LayoutTrack ctor for element {}", (Object)name);
                break;
            }
            default: {
                log.error("can't create LayoutTrack {} with type {}", (Object)name, (Object)type);
                return;
            }
        }
        p.addLayoutTrack(l, lv);
        Attribute a = element.getAttribute("turnoutname");
        if (a != null) {
            l.setTurnout(a.getValue());
        }
        if ((a = element.getAttribute("secondturnoutname")) != null) {
            l.setSecondTurnout(a.getValue());
            try {
                l.setSecondTurnoutInverted(element.getAttribute("secondturnoutinverted").getBooleanValue());
            }
            catch (DataConversionException dataConversionException) {
                log.warn("unable to convert layout turnout secondturnoutinverted attribute");
            }
            catch (NullPointerException nullPointerException) {}
        }
        if ((a = element.getAttribute("blockname")) != null) {
            l.tBlockAName = a.getValue();
        }
        if ((a = element.getAttribute("blockbname")) != null) {
            l.tBlockBName = a.getValue();
        }
        if ((a = element.getAttribute("blockcname")) != null) {
            l.tBlockCName = a.getValue();
        }
        if ((a = element.getAttribute("blockdname")) != null) {
            l.tBlockDName = a.getValue();
        }
        if ((a = element.getAttribute("connectaname")) != null) {
            l.connectAName = a.getValue();
        }
        if ((a = element.getAttribute("connectbname")) != null) {
            l.connectBName = a.getValue();
        }
        if ((a = element.getAttribute("connectcname")) != null) {
            l.connectCName = a.getValue();
        }
        if ((a = element.getAttribute("connectdname")) != null) {
            l.connectDName = a.getValue();
        }
        if ((a = element.getAttribute("signala1name")) != null) {
            l.setSignalA1Name(a.getValue());
        }
        if ((a = element.getAttribute("signala2name")) != null) {
            l.setSignalA2Name(a.getValue());
        }
        if ((a = element.getAttribute("signala3name")) != null) {
            l.setSignalA3Name(a.getValue());
        }
        if ((a = element.getAttribute("signalb1name")) != null) {
            l.setSignalB1Name(a.getValue());
        }
        if ((a = element.getAttribute("signalb2name")) != null) {
            l.setSignalB2Name(a.getValue());
        }
        if ((a = element.getAttribute("signalc1name")) != null) {
            l.setSignalC1Name(a.getValue());
        }
        if ((a = element.getAttribute("signalc2name")) != null) {
            l.setSignalC2Name(a.getValue());
        }
        if ((a = element.getAttribute("signald1name")) != null) {
            l.setSignalD1Name(a.getValue());
        }
        if ((a = element.getAttribute("signald2name")) != null) {
            l.setSignalD2Name(a.getValue());
        }
        if ((a = element.getAttribute("linkedturnoutname")) != null) {
            l.linkedTurnoutName = a.getValue();
            l.linkType = linkEnumMap.inputFromAttribute(element.getAttribute("linktype"));
        }
        if ((a = element.getAttribute("continuing")) != null) {
            int continuing = 2;
            try {
                continuing = element.getAttribute("continuing").getIntValue();
            }
            catch (DataConversionException dataConversionException) {
                log.error("failed to convert continuingsense attribute");
            }
            l.setContinuingSense(continuing);
        }
        try {
            l.setDisabled(element.getAttribute("disabled").getBooleanValue());
        }
        catch (DataConversionException dataConversionException) {
            log.warn("unable to convert layout turnout disabled attribute");
        }
        catch (NullPointerException nullPointerException) {}
        try {
            l.setDisableWhenOccupied(element.getAttribute("disableWhenOccupied").getBooleanValue());
        }
        catch (DataConversionException dataConversionException) {
            log.warn("unable to convert layout turnout disableWhenOccupied attribute");
        }
        catch (NullPointerException nullPointerException) {}
        try {
            lv.setHidden(element.getAttribute("hidden").getBooleanValue());
        }
        catch (DataConversionException dataConversionException) {
            log.warn("unable to convert layout turnout hidden attribute");
        }
        catch (NullPointerException nullPointerException) {}
        if (version == 2) {
            try {
                x = element.getAttribute("xa").getFloatValue();
                y = element.getAttribute("ya").getFloatValue();
                lv.setCoordsA(new Point2D.Double(x, y));
            }
            catch (DataConversionException dataConversionException) {
                log.error("failed to convert layoutturnout b coords attribute");
            }
            catch (NullPointerException nullPointerException) {}
        }
        try {
            x = element.getAttribute("xb").getFloatValue();
            y = element.getAttribute("yb").getFloatValue();
            lv.setCoordsB(new Point2D.Double(x, y));
        }
        catch (DataConversionException dataConversionException) {
            log.error("failed to convert layoutturnout b coords attribute");
        }
        try {
            x = element.getAttribute("xc").getFloatValue();
            y = element.getAttribute("yc").getFloatValue();
            lv.setCoordsC(new Point2D.Double(x, y));
        }
        catch (DataConversionException dataConversionException) {
            log.error("failed to convert layoutturnout c coords attribute");
        }
        if (version == 2) {
            try {
                x = element.getAttribute("xd").getFloatValue();
                y = element.getAttribute("yd").getFloatValue();
                lv.setCoordsD(new Point2D.Double(x, y));
            }
            catch (DataConversionException dataConversionException) {
                log.error("failed to convert layoutturnout c coords attribute");
            }
            catch (NullPointerException nullPointerException) {}
        }
        l.setSignalAMast(this.getElement(element, "signalAMast"));
        l.setSignalBMast(this.getElement(element, "signalBMast"));
        l.setSignalCMast(this.getElement(element, "signalCMast"));
        l.setSignalDMast(this.getElement(element, "signalDMast"));
        l.setSensorA(this.getElement(element, "sensorA"));
        l.setSensorB(this.getElement(element, "sensorB"));
        l.setSensorC(this.getElement(element, "sensorC"));
        l.setSensorD(this.getElement(element, "sensorD"));
    }

    String getElement(Element el, String child) {
        if (el.getChild(child) != null) {
            return el.getChild(child).getText();
        }
        return "";
    }
}

