/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor.configurexml;

import java.awt.geom.Point2D;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.jmrit.display.layoutEditor.LayoutDoubleSlip;
import jmri.jmrit.display.layoutEditor.LayoutDoubleSlipView;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutSingleSlip;
import jmri.jmrit.display.layoutEditor.LayoutSingleSlipView;
import jmri.jmrit.display.layoutEditor.LayoutSlip;
import jmri.jmrit.display.layoutEditor.LayoutSlipView;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutSlipViewXml
extends AbstractXmlAdapter {
    static final AbstractXmlAdapter.EnumIO<LayoutTurnout.TurnoutType> tTypeEnumMap = new AbstractXmlAdapter.EnumIoNamesNumbers<LayoutTurnout.TurnoutType>(LayoutTurnout.TurnoutType.class);
    private static final Logger log = LoggerFactory.getLogger(LayoutSlipViewXml.class);

    protected void addClass(Element element) {
        element.setAttribute("class", "jmri.jmrit.display.layoutEditor.configurexml.LayoutSlipXml");
    }

    @Override
    public Element store(Object o) {
        LayoutSlipView pv = (LayoutSlipView)o;
        LayoutSlip p = pv.getSlip();
        Element element = new Element("layoutSlip");
        element.setAttribute("ident", p.getName());
        element.setAttribute("slipType", tTypeEnumMap.outputFromEnum(p.getTurnoutType()));
        element.setAttribute("hidden", pv.isHidden() ? "yes" : "no");
        element.setAttribute("disabled", p.isDisabled() ? "yes" : "no");
        element.setAttribute("disableWhenOccupied", p.isDisabledWhenOccupied() ? "yes" : "no");
        Point2D coords = pv.getCoordsCenter();
        element.setAttribute("xcen", "" + coords.getX());
        element.setAttribute("ycen", "" + coords.getY());
        coords = pv.getCoordsA();
        element.setAttribute("xa", "" + coords.getX());
        element.setAttribute("ya", "" + coords.getY());
        coords = pv.getCoordsB();
        element.setAttribute("xb", "" + coords.getX());
        element.setAttribute("yb", "" + coords.getY());
        if (!p.getTurnoutName().isEmpty()) {
            element.addContent((Content)new Element("turnout").addContent(p.getTurnoutName()));
        }
        if (!p.getTurnoutBName().isEmpty()) {
            element.addContent((Content)new Element("turnoutB").addContent(p.getTurnoutBName()));
        }
        if (!p.getBlockName().isEmpty()) {
            element.setAttribute("blockname", p.getBlockName());
        }
        if (!p.getBlockBName().isEmpty() && !p.getBlockBName().equals(p.getBlockName())) {
            element.setAttribute("blockbname", p.getBlockBName());
        }
        if (!p.getBlockCName().isEmpty() && !p.getBlockCName().equals(p.getBlockName())) {
            element.setAttribute("blockcname", p.getBlockCName());
        }
        if (!p.getBlockDName().isEmpty() && !p.getBlockDName().equals(p.getBlockName())) {
            element.setAttribute("blockdname", p.getBlockDName());
        }
        if (p.getConnectA() != null) {
            element.setAttribute("connectaname", ((TrackSegment)p.getConnectA()).getId());
        }
        if (p.getConnectB() != null) {
            element.setAttribute("connectbname", ((TrackSegment)p.getConnectB()).getId());
        }
        if (p.getConnectC() != null) {
            element.setAttribute("connectcname", ((TrackSegment)p.getConnectC()).getId());
        }
        if (p.getConnectD() != null) {
            element.setAttribute("connectdname", ((TrackSegment)p.getConnectD()).getId());
        }
        if (!p.getSignalA1Name().isEmpty()) {
            element.addContent((Content)new Element("signala1name").addContent(p.getSignalA1Name()));
        }
        if (!p.getSignalB1Name().isEmpty()) {
            element.addContent((Content)new Element("signalb1name").addContent(p.getSignalB1Name()));
        }
        if (!p.getSignalC1Name().isEmpty()) {
            element.addContent((Content)new Element("signalc1name").addContent(p.getSignalC1Name()));
        }
        if (!p.getSignalD1Name().isEmpty()) {
            element.addContent((Content)new Element("signald1name").addContent(p.getSignalD1Name()));
        }
        if (!p.getSignalA2Name().isEmpty()) {
            element.addContent((Content)new Element("signala2name").addContent(p.getSignalA2Name()));
        }
        if (!p.getSignalB2Name().isEmpty()) {
            element.addContent((Content)new Element("signalb2name").addContent(p.getSignalB2Name()));
        }
        if (!p.getSignalC2Name().isEmpty()) {
            element.addContent((Content)new Element("signalc2name").addContent(p.getSignalC2Name()));
        }
        if (!p.getSignalD2Name().isEmpty()) {
            element.addContent((Content)new Element("signald2name").addContent(p.getSignalD2Name()));
        }
        if (!p.getSignalAMastName().isEmpty()) {
            element.addContent((Content)new Element("signalAMast").addContent(p.getSignalAMastName()));
        }
        if (!p.getSignalBMastName().isEmpty()) {
            element.addContent((Content)new Element("signalBMast").addContent(p.getSignalBMastName()));
        }
        if (!p.getSignalCMastName().isEmpty()) {
            element.addContent((Content)new Element("signalCMast").addContent(p.getSignalCMastName()));
        }
        if (!p.getSignalDMastName().isEmpty()) {
            element.addContent((Content)new Element("signalDMast").addContent(p.getSignalDMastName()));
        }
        if (!p.getSensorAName().isEmpty()) {
            element.addContent((Content)new Element("sensorA").addContent(p.getSensorAName()));
        }
        if (!p.getSensorBName().isEmpty()) {
            element.addContent((Content)new Element("sensorB").addContent(p.getSensorBName()));
        }
        if (!p.getSensorCName().isEmpty()) {
            element.addContent((Content)new Element("sensorC").addContent(p.getSensorCName()));
        }
        if (!p.getSensorDName().isEmpty()) {
            element.addContent((Content)new Element("sensorD").addContent(p.getSensorDName()));
        }
        Element states = new Element("states");
        Element state = new Element("A-C");
        state.addContent((Content)new Element("turnout").addContent("" + p.getTurnoutState(2)));
        state.addContent((Content)new Element("turnoutB").addContent("" + p.getTurnoutBState(2)));
        states.addContent((Content)state);
        state = new Element("A-D");
        state.addContent((Content)new Element("turnout").addContent("" + p.getTurnoutState(6)));
        state.addContent((Content)new Element("turnoutB").addContent("" + p.getTurnoutBState(6)));
        states.addContent((Content)state);
        state = new Element("B-D");
        state.addContent((Content)new Element("turnout").addContent("" + p.getTurnoutState(4)));
        state.addContent((Content)new Element("turnoutB").addContent("" + p.getTurnoutBState(4)));
        states.addContent((Content)state);
        if (p.getSlipType() == LayoutTurnout.TurnoutType.DOUBLE_SLIP) {
            state = new Element("B-C");
            state.addContent((Content)new Element("turnout").addContent("" + p.getTurnoutState(8)));
            state.addContent((Content)new Element("turnoutB").addContent("" + p.getTurnoutBState(8)));
            states.addContent((Content)state);
        }
        element.addContent((Content)states);
        this.addClass(element);
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        log.error("Invalid method called");
        return false;
    }

    @Override
    public void load(Element element, Object o) {
        LayoutSlipView lv;
        LayoutSlip l;
        LayoutEditor p = (LayoutEditor)o;
        String name = element.getAttribute("ident").getValue();
        double x = 0.0;
        double y = 0.0;
        try {
            x = element.getAttribute("xcen").getFloatValue();
            y = element.getAttribute("ycen").getFloatValue();
        }
        catch (DataConversionException dataConversionException) {
            log.error("failed to convert layoutslip center  attribute");
        }
        LayoutTurnout.TurnoutType type = tTypeEnumMap.inputFromAttribute(element.getAttribute("slipType"));
        switch (type) {
            case DOUBLE_SLIP: {
                LayoutDoubleSlip lds = new LayoutDoubleSlip(name, p);
                l = lds;
                lv = new LayoutDoubleSlipView(lds, (Point2D)new Point2D.Double(x, y), 0.0, p);
                break;
            }
            case SINGLE_SLIP: {
                LayoutSingleSlip lss = new LayoutSingleSlip(name, p);
                l = lss;
                lv = new LayoutSingleSlipView(lss, (Point2D)new Point2D.Double(x, y), 0.0, p);
                break;
            }
            default: {
                log.error("can't create slip {} with type {}", (Object)name, (Object)type);
                return;
            }
        }
        p.addLayoutTrack(l, lv);
        l.setTurnout(this.getElement(element, "turnout"));
        l.setTurnoutB(this.getElement(element, "turnoutB"));
        Attribute a = element.getAttribute("blockname");
        if (a != null) {
            l.tBlockAName = a.getValue();
        }
        if ((a = element.getAttribute("blockbname")) != null) {
            l.tBlockBName = a.getValue();
        }
        if ((a = element.getAttribute("blockcname")) != null) {
            l.tBlockCName = a.getValue();
        }
        if ((a = element.getAttribute("blockdname")) != null) {
            l.tBlockDName = a.getValue();
        }
        if ((a = element.getAttribute("connectaname")) != null) {
            l.connectAName = a.getValue();
        }
        if ((a = element.getAttribute("connectbname")) != null) {
            l.connectBName = a.getValue();
        }
        if ((a = element.getAttribute("connectcname")) != null) {
            l.connectCName = a.getValue();
        }
        if ((a = element.getAttribute("connectdname")) != null) {
            l.connectDName = a.getValue();
        }
        l.setSignalA1Name(this.getElement(element, "signala1name"));
        l.setSignalB1Name(this.getElement(element, "signalb1name"));
        l.setSignalC1Name(this.getElement(element, "signalc1name"));
        l.setSignalD1Name(this.getElement(element, "signald1name"));
        l.setSignalA2Name(this.getElement(element, "signala2name"));
        l.setSignalB2Name(this.getElement(element, "signalb2name"));
        l.setSignalC2Name(this.getElement(element, "signalc2name"));
        l.setSignalD2Name(this.getElement(element, "signald2name"));
        try {
            l.setDisabled(element.getAttribute("disabled").getBooleanValue());
        }
        catch (DataConversionException dataConversionException) {
            log.warn("unable to convert layout turnout disabled attribute");
        }
        catch (NullPointerException nullPointerException) {}
        try {
            l.setDisableWhenOccupied(element.getAttribute("disableWhenOccupied").getBooleanValue());
        }
        catch (DataConversionException dataConversionException) {
            log.warn("unable to convert layout turnout disableWhenOccupied attribute");
        }
        catch (NullPointerException nullPointerException) {}
        try {
            lv.setHidden(element.getAttribute("hidden").getBooleanValue());
        }
        catch (DataConversionException dataConversionException) {
            log.warn("unable to convert layout turnout hidden attribute");
        }
        catch (NullPointerException nullPointerException) {}
        try {
            x = element.getAttribute("xa").getFloatValue();
            y = element.getAttribute("ya").getFloatValue();
            lv.setCoordsA(new Point2D.Double(x, y));
        }
        catch (DataConversionException dataConversionException) {
            log.error("failed to convert LayoutSlip a coords attribute");
        }
        try {
            x = element.getAttribute("xb").getFloatValue();
            y = element.getAttribute("yb").getFloatValue();
            lv.setCoordsB(new Point2D.Double(x, y));
        }
        catch (DataConversionException dataConversionException) {
            log.error("failed to convert LayoutSlip b coords attribute");
        }
        l.setSignalAMast(this.getElement(element, "signalAMast"));
        l.setSignalBMast(this.getElement(element, "signalBMast"));
        l.setSignalCMast(this.getElement(element, "signalCMast"));
        l.setSignalDMast(this.getElement(element, "signalDMast"));
        l.setSensorA(this.getElement(element, "sensorA"));
        l.setSensorB(this.getElement(element, "sensorB"));
        l.setSensorC(this.getElement(element, "sensorC"));
        l.setSensorD(this.getElement(element, "sensorD"));
        if (element.getChild("states") != null) {
            Element state = element.getChild("states");
            if (state.getChild("A-C") != null) {
                Element ac = state.getChild("A-C");
                l.setTurnoutStates(2, ac.getChild("turnout").getText(), ac.getChild("turnoutB").getText());
            }
            if (state.getChild("A-D") != null) {
                Element ad = state.getChild("A-D");
                l.setTurnoutStates(6, ad.getChild("turnout").getText(), ad.getChild("turnoutB").getText());
            }
            if (state.getChild("B-D") != null) {
                Element bd = state.getChild("B-D");
                l.setTurnoutStates(4, bd.getChild("turnout").getText(), bd.getChild("turnoutB").getText());
            }
            if (state.getChild("B-C") != null) {
                Element bc = state.getChild("B-C");
                l.setTurnoutStates(8, bc.getChild("turnout").getText(), bc.getChild("turnoutB").getText());
            }
        }
    }

    String getElement(Element el, String child) {
        if (el.getChild(child) != null) {
            return el.getChild(child).getText();
        }
        return "";
    }
}

