/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor.configurexml;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutShape;
import jmri.util.ColorUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutShapeXml
extends AbstractXmlAdapter {
    static final AbstractXmlAdapter.EnumIoNames<LayoutShape.LayoutShapeType> sTypeEnumMap = new AbstractXmlAdapter.EnumIoNames<LayoutShape.LayoutShapeType>(LayoutShape.LayoutShapeType.class);
    static final AbstractXmlAdapter.EnumIoNames<LayoutShape.LayoutShapePointType> pTypeEnumMap = new AbstractXmlAdapter.EnumIoNames<LayoutShape.LayoutShapePointType>(LayoutShape.LayoutShapePointType.class);
    private static final Logger log = LoggerFactory.getLogger(LayoutShapeXml.class);

    @Override
    public Element store(Object o) {
        LayoutShape s = (LayoutShape)o;
        Element element = null;
        if (s.getNumberPoints() > 0) {
            element = new Element("layoutShape");
            element.setAttribute("ident", s.getName());
            element.setAttribute("type", sTypeEnumMap.outputFromEnum(s.getType()));
            element.setAttribute("level", "" + s.getLevel());
            element.setAttribute("linewidth", "" + s.getLineWidth());
            element.setAttribute("lineColor", ColorUtil.colorToHexString(s.getLineColor()));
            element.setAttribute("fillColor", ColorUtil.colorToHexString(s.getFillColor()));
            Element elementPoints = new Element("points");
            ArrayList<LayoutShape.LayoutShapePoint> shapePoints = s.getPoints();
            for (LayoutShape.LayoutShapePoint p : shapePoints) {
                Element elementPoint = new Element("point");
                elementPoint.setAttribute("type", pTypeEnumMap.outputFromEnum(p.getType()));
                Point2D pt = p.getPoint();
                elementPoint.setAttribute("x", "" + pt.getX());
                elementPoint.setAttribute("y", "" + pt.getY());
                elementPoints.addContent((Content)elementPoint);
            }
            element.addContent((Content)elementPoints);
            element.setAttribute("class", this.getClass().getName());
        }
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        log.error("Invalid method called");
        return false;
    }

    @Override
    public void load(Element element, Object o) {
        Element pointsElement;
        LayoutEditor p = (LayoutEditor)o;
        String name = element.getAttribute("ident").getValue();
        LayoutShape.LayoutShapeType type = (LayoutShape.LayoutShapeType)((Object)sTypeEnumMap.inputFromAttribute(element.getAttribute("type")));
        LayoutShape s = new LayoutShape(name, type, p);
        Attribute a = element.getAttribute("level");
        if (a != null) {
            try {
                s.setLevel(a.getIntValue());
            }
            catch (DataConversionException dataConversionException) {
                log.error("Layout Shape level attribute Conversion error.");
            }
        } else {
            log.error("Layout Shape level attribute not found.");
        }
        a = element.getAttribute("linewidth");
        if (a != null) {
            try {
                s.setLineWidth(a.getIntValue());
            }
            catch (DataConversionException dataConversionException) {
                log.error("Layout Shape line width attribute Conversion error.");
            }
        } else {
            log.error("Layout Shape line width attribute not found.");
        }
        a = element.getAttribute("lineColor");
        if (a != null) {
            try {
                s.setLineColor(ColorUtil.stringToColor(a.getValue()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                s.setLineColor(Color.BLACK);
                log.error("Invalid lineColor {}; using black", (Object)a.getValue());
            }
        }
        if ((a = element.getAttribute("fillColor")) != null) {
            try {
                s.setFillColor(ColorUtil.stringToColor(a.getValue()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                s.setFillColor(Color.BLACK);
                log.error("Invalid fillColor {}; using black", (Object)a.getValue());
            }
        }
        if ((pointsElement = element.getChild("points")) != null) {
            List elementList = pointsElement.getChildren("point");
            if (elementList != null) {
                if (elementList.size() > 0) {
                    int i = 0;
                    while (i < elementList.size()) {
                        Element relem = (Element)elementList.get(i);
                        LayoutShape.LayoutShapePointType pointType = (LayoutShape.LayoutShapePointType)((Object)pTypeEnumMap.inputFromAttribute(relem.getAttribute("type")));
                        double x = 0.0;
                        double y = 0.0;
                        try {
                            x = relem.getAttribute("x").getFloatValue();
                            y = relem.getAttribute("y").getFloatValue();
                        }
                        catch (DataConversionException dataConversionException) {
                            log.error("failed to convert Layout Shape point #{}coordinates attributes", (Object)i);
                        }
                        s.addPoint(pointType, new Point2D.Double(x, y));
                        ++i;
                    }
                } else {
                    log.error("No Layout Shape point elements");
                }
            } else {
                log.error("Layout Shape point elements not found.");
            }
        } else {
            log.error("Layout Shape points element not found.");
        }
        p.getLayoutShapes().add(s);
    }
}

