/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor.blockRoutingTable;

import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.blockRoutingTable.Bundle;
import jmri.jmrit.display.layoutEditor.blockRoutingTable.LayoutBlockNeighbourTableModel;
import jmri.jmrit.display.layoutEditor.blockRoutingTable.LayoutBlockRouteTableModel;
import jmri.jmrit.display.layoutEditor.blockRoutingTable.LayoutBlockThroughPathsTableModel;
import jmri.swing.RowSorterUtil;
import jmri.util.swing.JmriPanel;

public class LayoutBlockRouteTable
extends JmriPanel {
    private LayoutBlockRouteTableModel dataModel;
    private LayoutBlockNeighbourTableModel neighbourDataModel;
    private TableRowSorter<LayoutBlockNeighbourTableModel> neighbourSorter;
    private JTable neighbourDataTable;
    private JScrollPane neighbourDataScroll;
    private final TableRowSorter<LayoutBlockRouteTableModel> sorter;
    private JTable dataTable;
    private JScrollPane dataScroll;
    private final LayoutBlockThroughPathsTableModel throughPathsDataModel;
    private final TableRowSorter<LayoutBlockThroughPathsTableModel> throughPathsSorter;
    private final JTable throughPathsDataTable;
    private final JScrollPane throughPathsDataScroll;

    public LayoutBlockRouteTable(boolean editable, LayoutBlock block) {
        this.dataModel = new LayoutBlockRouteTableModel(editable, block);
        this.sorter = new TableRowSorter<LayoutBlockRouteTableModel>(this.dataModel);
        this.dataTable = new JTable(this.dataModel);
        this.dataTable.setRowSorter(this.sorter);
        this.dataScroll = new JScrollPane(this.dataTable, 20, 30);
        this.neighbourDataModel = new LayoutBlockNeighbourTableModel(editable, block);
        this.neighbourSorter = new TableRowSorter<LayoutBlockNeighbourTableModel>(this.neighbourDataModel);
        this.neighbourDataTable = new JTable(this.neighbourDataModel);
        this.neighbourDataTable.setRowSorter(this.neighbourSorter);
        this.neighbourDataScroll = new JScrollPane(this.neighbourDataTable, 20, 30);
        this.throughPathsDataModel = new LayoutBlockThroughPathsTableModel(editable, block);
        this.throughPathsSorter = new TableRowSorter<LayoutBlockThroughPathsTableModel>(this.throughPathsDataModel);
        this.throughPathsDataTable = new JTable(this.throughPathsDataModel);
        this.throughPathsDataTable.setRowSorter(this.throughPathsSorter);
        this.throughPathsDataScroll = new JScrollPane(this.throughPathsDataTable, 20, 30);
        RowSorterUtil.setSortOrder(this.sorter, 2, SortOrder.ASCENDING);
        RowSorterUtil.setSortOrder(this.neighbourSorter, 0, SortOrder.ASCENDING);
        RowSorterUtil.setSortOrder(this.throughPathsSorter, 0, SortOrder.ASCENDING);
        this.dataTable.getTableHeader().setReorderingAllowed(true);
        this.neighbourDataTable.getTableHeader().setReorderingAllowed(true);
        this.throughPathsDataTable.getTableHeader().setReorderingAllowed(true);
        this.dataTable.setAutoResizeMode(0);
        this.neighbourDataTable.setAutoResizeMode(0);
        this.throughPathsDataTable.setAutoResizeMode(0);
        this.setLayout(new BoxLayout(this, 1));
        int i = 0;
        while (i < this.dataTable.getColumnCount()) {
            int width = this.dataModel.getPreferredWidth(i);
            this.dataTable.getColumnModel().getColumn(i).setPreferredWidth(width);
            ++i;
        }
        this.dataTable.sizeColumnsToFit(-1);
        Dimension dataTableSize = this.dataTable.getPreferredSize();
        dataTableSize.height = Math.max(dataTableSize.height, 400);
        dataTableSize.width = Math.max(dataTableSize.width, 400);
        this.dataScroll.getViewport().setPreferredSize(dataTableSize);
        this.dataTable.setSelectionMode(0);
        int i2 = 0;
        while (i2 < this.neighbourDataTable.getColumnCount()) {
            int width = this.neighbourDataModel.getPreferredWidth(i2);
            this.neighbourDataTable.getColumnModel().getColumn(i2).setPreferredWidth(width);
            ++i2;
        }
        this.neighbourDataTable.sizeColumnsToFit(-1);
        Dimension neighbourDataTableSize = this.neighbourDataTable.getPreferredSize();
        neighbourDataTableSize.height = Math.max(neighbourDataTableSize.height, 400);
        neighbourDataTableSize.width = Math.max(neighbourDataTableSize.width, 400);
        this.neighbourDataScroll.getViewport().setPreferredSize(neighbourDataTableSize);
        this.neighbourDataScroll.setHorizontalScrollBarPolicy(30);
        this.neighbourDataScroll.setVerticalScrollBarPolicy(20);
        this.neighbourDataTable.setSelectionMode(0);
        int i3 = 0;
        while (i3 < this.throughPathsDataTable.getColumnCount()) {
            int width = this.throughPathsDataModel.getPreferredWidth(i3);
            this.throughPathsDataTable.getColumnModel().getColumn(i3).setPreferredWidth(width);
            ++i3;
        }
        this.throughPathsDataTable.sizeColumnsToFit(-1);
        Dimension throughPathsDataTableSize = this.throughPathsDataTable.getPreferredSize();
        throughPathsDataTableSize.height = Math.max(throughPathsDataTableSize.height, 400);
        throughPathsDataTableSize.width = Math.max(throughPathsDataTableSize.width, 400);
        this.throughPathsDataScroll.getViewport().setPreferredSize(throughPathsDataTableSize);
        this.throughPathsDataScroll.setHorizontalScrollBarPolicy(30);
        this.throughPathsDataScroll.setVerticalScrollBarPolicy(20);
        this.throughPathsDataTable.setSelectionMode(0);
        JPanel neigh = new JPanel();
        neigh.setLayout(new BoxLayout(neigh, 1));
        neigh.add(new JLabel(Bundle.getMessage("Neighbouring")));
        neigh.add(this.neighbourDataScroll);
        JPanel through = new JPanel();
        through.setLayout(new BoxLayout(through, 1));
        through.add(new JLabel(Bundle.getMessage("ValidPaths")));
        through.add(this.throughPathsDataScroll);
        JPanel routePane = new JPanel();
        routePane.setLayout(new BoxLayout(routePane, 1));
        routePane.add(new JLabel(Bundle.getMessage("Accessible")));
        routePane.add(this.dataScroll);
        JSplitPane splitTopPane = new JSplitPane(0, neigh, through);
        splitTopPane.setOneTouchExpandable(true);
        splitTopPane.setDividerLocation(150);
        JSplitPane splitBotPane = new JSplitPane(0, splitTopPane, routePane);
        splitBotPane.setOneTouchExpandable(true);
        splitBotPane.setDividerLocation(300);
        this.add(splitBotPane);
    }

    public JTable getTable() {
        return this.dataTable;
    }

    public TableModel getModel() {
        return this.dataModel;
    }

    public JTable getNeighbourTable() {
        return this.neighbourDataTable;
    }

    public TableModel getNeighbourModel() {
        return this.neighbourDataModel;
    }

    @Override
    public void dispose() {
        if (this.dataModel != null) {
            this.dataModel.dispose();
        }
        this.dataModel = null;
        this.dataTable = null;
        this.dataScroll = null;
        this.neighbourDataModel = null;
        this.neighbourSorter = null;
        this.neighbourDataTable = null;
        this.neighbourDataScroll = null;
        super.dispose();
    }
}

