/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.util.ArrayList;
import java.util.List;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.Section;
import jmri.SectionManager;
import jmri.SignalMast;
import jmri.SignalMastLogic;
import jmri.SignalMastLogicManager;
import jmri.Transit;
import jmri.TransitManager;
import jmri.TransitSection;
import jmri.jmrit.display.layoutEditor.Bundle;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransitCreationTool {
    ArrayList<NamedBean> list = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(TransitCreationTool.class);

    public void addNamedBean(NamedBean nb) throws JmriException {
        if (!this.list.isEmpty()) {
            if (this.list.get(this.list.size() - 1) == nb) {
                log.debug("Bean is the same as the last one so will not add or error");
                return;
            }
            if (nb instanceof SignalMast && this.list.get(this.list.size() - 1) instanceof SignalMast) {
                SignalMastLogicManager smlm = InstanceManager.getDefault(SignalMastLogicManager.class);
                SignalMastLogic sml = smlm.getSignalMastLogic((SignalMast)this.list.get(this.list.size() - 1));
                if (sml == null || !sml.isDestinationValid((SignalMast)nb)) {
                    String error = Bundle.getMessage("TCTErrorMastPairsNotValid", nb.getDisplayName(), this.list.get(this.list.size() - 1).getDisplayName());
                    log.error("will throw {}", (Object)error);
                    throw new JmriException(error);
                }
                if (sml.getAssociatedSection((SignalMast)nb) == null) {
                    String error = Bundle.getMessage("TCTErrorMastPairsNoSection", this.list.get(this.list.size() - 1).getDisplayName(), nb.getDisplayName());
                    log.error("will throw {}", (Object)error);
                    throw new JmriException(error);
                }
            }
        }
        this.list.add(nb);
    }

    public Transit createTransit() throws JmriException {
        Transit t;
        TransitManager tm = InstanceManager.getDefault(TransitManager.class);
        String transitName = "From " + this.list.get(0).getDisplayName() + " to " + this.list.get(this.list.size() - 1).getDisplayName();
        try {
            t = tm.createNewTransit(transitName);
        }
        catch (NamedBean.BadNameException ex) {
            log.error("Unable to create transit {} {}", (Object)transitName, (Object)ex.getMessage());
            throw new JmriException(String.valueOf(Bundle.getMessage("TCTErrorUnableToCreate", transitName)) + " " + ex.getLocalizedMessage());
        }
        if (this.list.get(0) instanceof SignalMast) {
            LayoutBlock layoutBlock;
            SignalMastLogicManager smlm = InstanceManager.getDefault(SignalMastLogicManager.class);
            int seqNo = 1;
            SignalMastLogic smlForFirstMast = smlm.getSignalMastLogic((SignalMast)this.list.get(0));
            if (smlForFirstMast != null && (layoutBlock = smlForFirstMast.getFacingBlock()) != null && layoutBlock.getNumberOfNeighbours() == 1) {
                SectionManager sectionManager = InstanceManager.getDefault(SectionManager.class);
                for (Section section : sectionManager.getNamedBeanSet()) {
                    if (section.getSectionType() != 1 || section.getNumBlocks() != 1 || !layoutBlock.getBlock().equals(section.getEntryBlock())) continue;
                    t.addTransitSection(new TransitSection(section, seqNo, 4));
                    ++seqNo;
                    break;
                }
                if (seqNo == 1) {
                    log.warn("Unable to find a stub block section for {}", (Object)layoutBlock.getDisplayName());
                }
            }
            int i = 1;
            while (i <= this.list.size() - 1) {
                SignalMastLogic sml = smlm.getSignalMastLogic((SignalMast)this.list.get(i - 1));
                if (sml == null) {
                    String error = "Cannot locate SML for SM " + this.list.get(i - 1).getDisplayName();
                    log.error("will throw {}", (Object)error);
                    tm.deregister(t);
                    t.dispose();
                    this.cancelTransitCreate();
                    throw new JmriException(error);
                }
                Section sec = sml.getAssociatedSection((SignalMast)this.list.get(i));
                if (sec == null) {
                    String error = Bundle.getMessage("TCTErrorMastPairsNoSection", this.list.get(i - 1).getDisplayName(), this.list.get(i).getDisplayName());
                    log.error("will throw {}", (Object)error);
                    tm.deregister(t);
                    t.dispose();
                    this.cancelTransitCreate();
                    throw new JmriException(error);
                }
                t.addTransitSection(new TransitSection(sec, seqNo, 4));
                ++seqNo;
                ++i;
            }
        }
        this.list = new ArrayList();
        return t;
    }

    public void cancelTransitCreate() {
        this.list = new ArrayList();
    }

    public List<NamedBean> getBeans() {
        return this.list;
    }

    public boolean isToolInUse() {
        return !this.list.isEmpty();
    }
}

