/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.display.layoutEditor.Bundle;
import jmri.jmrit.display.layoutEditor.HitPointType;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutConnectivity;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutSlip;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.LevelXing;
import jmri.jmrit.display.layoutEditor.PositionablePoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackSegment
extends LayoutTrack {
    private NamedBeanHandle<LayoutBlock> namedLayoutBlock = null;
    protected LayoutTrack connect1 = null;
    protected HitPointType type1 = HitPointType.NONE;
    protected LayoutTrack connect2 = null;
    protected HitPointType type2 = HitPointType.NONE;
    private boolean mainline = false;
    public String tConnect1Name = "";
    public String tConnect2Name = "";
    public String tLayoutBlockName = "";
    private boolean active = true;
    private static final Logger log = LoggerFactory.getLogger(TrackSegment.class);

    public TrackSegment(@Nonnull String id, @CheckForNull LayoutTrack c1, HitPointType t1, @CheckForNull LayoutTrack c2, HitPointType t2, boolean main, @Nonnull LayoutEditor models) {
        super(id, models);
        if (c1 == null || c2 == null) {
            log.error("Invalid object in TrackSegment constructor call - {}", (Object)id);
        }
        if (HitPointType.isConnectionHitType(t1)) {
            this.connect1 = c1;
            this.type1 = t1;
        } else {
            log.error("Invalid connect type 1 ('{}') in TrackSegment constructor - {}", (Object)t1, (Object)id);
        }
        if (HitPointType.isConnectionHitType(t2)) {
            this.connect2 = c2;
            this.type2 = t2;
        } else {
            log.error("Invalid connect type 2 ('{}') in TrackSegment constructor - {}", (Object)t2, (Object)id);
        }
        this.mainline = main;
    }

    public TrackSegment(@Nonnull String id, @CheckForNull String c1Name, HitPointType t1, @CheckForNull String c2Name, HitPointType t2, boolean main, @Nonnull LayoutEditor models) {
        super(id, models);
        this.tConnect1Name = c1Name;
        this.type1 = t1;
        this.tConnect2Name = c2Name;
        this.type2 = t2;
        this.mainline = main;
    }

    public String toString() {
        return "TrackSegment " + this.getName() + " c1:{" + this.getConnect1Name() + " (" + (Object)((Object)this.type1) + ")}," + " c2:{" + this.getConnect2Name() + " (" + (Object)((Object)this.type2) + ")}";
    }

    @Nonnull
    public String getBlockName() {
        String result = null;
        if (this.namedLayoutBlock != null) {
            result = this.namedLayoutBlock.getName();
        }
        return result == null ? "" : result;
    }

    public HitPointType getType1() {
        return this.type1;
    }

    public HitPointType getType2() {
        return this.type2;
    }

    public LayoutTrack getConnect1() {
        return this.connect1;
    }

    public LayoutTrack getConnect2() {
        return this.connect2;
    }

    protected void setNewConnect1(@CheckForNull LayoutTrack connectTrack, HitPointType connectionType) {
        this.connect1 = connectTrack;
        this.type1 = connectionType;
    }

    protected void setNewConnect2(@CheckForNull LayoutTrack connectTrack, HitPointType connectionType) {
        this.connect2 = connectTrack;
        this.type2 = connectionType;
    }

    public boolean replaceTrackConnection(@CheckForNull LayoutTrack oldTrack, @CheckForNull LayoutTrack newTrack, HitPointType newType) {
        boolean result = false;
        if (newTrack == null) {
            result = true;
            if (oldTrack != null) {
                if (this.connect1 == oldTrack) {
                    this.connect1 = null;
                    this.type1 = HitPointType.NONE;
                } else if (this.connect2 == oldTrack) {
                    this.connect2 = null;
                    this.type2 = HitPointType.NONE;
                } else {
                    log.error("{}.replaceTrackConnection({}, null, {}); Attempt to remove invalid track connection", new Object[]{this.getName(), oldTrack.getName(), newType});
                    result = false;
                }
            } else {
                log.warn("{}.replaceTrackConnection(null, null, {}); Can't replace null track connection with null", (Object)this.getName(), (Object)newType);
                result = false;
            }
        } else if (this.connect1 != newTrack && this.connect2 != newTrack) {
            result = true;
            if (this.connect1 == oldTrack) {
                this.connect1 = newTrack;
                this.type1 = newType;
            } else if (this.connect2 == oldTrack) {
                this.connect2 = newTrack;
                this.type2 = newType;
            } else {
                log.error("{}.replaceTrackConnection({}, {}, {}); Attempt to replace invalid track connection", new Object[]{this.getName(), oldTrack == null ? "null" : oldTrack.getName(), newTrack.getName(), newType});
                result = false;
            }
        }
        return result;
    }

    @Override
    public boolean isMainline() {
        return this.mainline;
    }

    public void setMainline(boolean main) {
        if (this.mainline != main) {
            this.mainline = main;
            this.models.redrawPanel();
            this.models.setDirty();
        }
    }

    public LayoutBlock getLayoutBlock() {
        return this.namedLayoutBlock != null ? this.namedLayoutBlock.getBean() : null;
    }

    public String getConnect1Name() {
        return this.getConnectName(this.connect1, this.type1);
    }

    public String getConnect2Name() {
        return this.getConnectName(this.connect2, this.type2);
    }

    private String getConnectName(@CheckForNull LayoutTrack layoutTrack, HitPointType type) {
        return layoutTrack == null ? null : layoutTrack.getName();
    }

    @Override
    public LayoutTrack getConnection(HitPointType connectionType) throws JmriException {
        throw new JmriException("Use getConnect1() or getConnect2() instead.");
    }

    @Override
    public void setConnection(HitPointType connectionType, @CheckForNull LayoutTrack o, HitPointType type) throws JmriException {
        throw new JmriException("Use setConnect1() or setConnect2() instead.");
    }

    public void setConnect1(@CheckForNull LayoutTrack o, HitPointType type) {
        this.type1 = type;
        this.connect1 = o;
    }

    public void setConnect2(@CheckForNull LayoutTrack o, HitPointType type) {
        this.type2 = type;
        this.connect2 = o;
    }

    public void setLayoutBlock(@CheckForNull LayoutBlock newLayoutBlock) {
        LayoutBlock layoutBlock = this.getLayoutBlock();
        if (layoutBlock != newLayoutBlock) {
            String newName;
            if (layoutBlock != null) {
                layoutBlock.decrementUse();
            }
            this.namedLayoutBlock = null;
            if (newLayoutBlock != null && (newName = newLayoutBlock.getUserName()) != null && !newName.isEmpty()) {
                this.namedLayoutBlock = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(newName, newLayoutBlock);
            }
        }
    }

    public void setLayoutBlockByName(@CheckForNull String name) {
        LayoutBlock b;
        this.namedLayoutBlock = name != null && !name.isEmpty() ? ((b = this.models.provideLayoutBlock(name)) != null ? InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(name, b) : null) : null;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Null check performed before using return value")
    public void setObjects(LayoutEditor p) {
        if (!this.tLayoutBlockName.isEmpty()) {
            LayoutBlock lb = p.provideLayoutBlock(this.tLayoutBlockName);
            if (lb != null) {
                this.namedLayoutBlock = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(lb.getUserName(), lb);
                lb.incrementUse();
            } else {
                log.error("{}.setObjects(...); bad blockname '{}' in tracksegment {}", new Object[]{this.getName(), this.tLayoutBlockName, this.getName()});
                this.namedLayoutBlock = null;
            }
            this.tLayoutBlockName = null;
        }
        this.connect1 = p.getFinder().findObjectByName(this.tConnect1Name);
        this.connect2 = p.getFinder().findObjectByName(this.tConnect2Name);
    }

    public void updateBlockInfo() {
        LayoutBlock b2;
        LayoutBlock b1;
        LayoutBlock layoutBlock = this.getLayoutBlock();
        if (layoutBlock != null) {
            layoutBlock.updatePaths();
        }
        if ((b1 = this.getBlock(this.connect1, this.type1)) != null && b1 != layoutBlock) {
            b1.updatePaths();
        }
        if ((b2 = this.getBlock(this.connect2, this.type2)) != null && b2 != layoutBlock && b2 != b1) {
            b2.updatePaths();
        }
        this.getConnect1().reCheckBlockBoundary();
        this.getConnect2().reCheckBlockBoundary();
    }

    private LayoutBlock getBlock(LayoutTrack connect, HitPointType type) {
        LayoutBlock result = null;
        if (connect != null) {
            if (type == HitPointType.POS_POINT) {
                PositionablePoint p = (PositionablePoint)connect;
                if (p.getConnect1() != this) {
                    if (p.getConnect1() != null) {
                        result = p.getConnect1().getLayoutBlock();
                    }
                } else if (p.getConnect2() != null) {
                    result = p.getConnect2().getLayoutBlock();
                }
            } else {
                result = this.models.getAffectedBlock(connect, type);
            }
        }
        return result;
    }

    @Override
    public boolean canRemove() {
        ArrayList<String> itemList = new ArrayList<String>();
        HitPointType type1 = this.getType1();
        LayoutTrack conn1 = this.getConnect1();
        itemList.addAll(this.getPointReferences(type1, conn1));
        HitPointType type2 = this.getType2();
        LayoutTrack conn2 = this.getConnect2();
        itemList.addAll(this.getPointReferences(type2, conn2));
        if (!itemList.isEmpty()) {
            this.models.displayRemoveWarning(this, itemList, "TrackSegment");
        }
        return itemList.isEmpty();
    }

    public ArrayList<String> getPointReferences(HitPointType type, LayoutTrack conn) {
        ArrayList<String> result = new ArrayList<String>();
        if (type == HitPointType.POS_POINT && conn instanceof PositionablePoint) {
            PositionablePoint pt = (PositionablePoint)conn;
            if (!pt.getEastBoundSignal().isEmpty()) {
                result.add(pt.getEastBoundSignal());
            }
            if (!pt.getWestBoundSignal().isEmpty()) {
                result.add(pt.getWestBoundSignal());
            }
            if (!pt.getEastBoundSignalMastName().isEmpty()) {
                result.add(pt.getEastBoundSignalMastName());
            }
            if (!pt.getWestBoundSignalMastName().isEmpty()) {
                result.add(pt.getWestBoundSignalMastName());
            }
            if (!pt.getEastBoundSensorName().isEmpty()) {
                result.add(pt.getEastBoundSensorName());
            }
            if (!pt.getWestBoundSensorName().isEmpty()) {
                result.add(pt.getWestBoundSensorName());
            }
            if (pt.getType() == PositionablePoint.PointType.EDGE_CONNECTOR && pt.getLinkedPoint() != null) {
                result.add(Bundle.getMessage("DeleteECisActive"));
            }
        }
        if (HitPointType.isTurnoutHitType(type) && conn instanceof LayoutTurnout) {
            LayoutTurnout lt = (LayoutTurnout)conn;
            switch (type) {
                case TURNOUT_A: {
                    result = lt.getBeanReferences("A");
                    break;
                }
                case TURNOUT_B: {
                    result = lt.getBeanReferences("B");
                    break;
                }
                case TURNOUT_C: {
                    result = lt.getBeanReferences("C");
                    break;
                }
                case TURNOUT_D: {
                    result = lt.getBeanReferences("D");
                    break;
                }
                default: {
                    log.error("Unexpected HitPointType: {}", (Object)type);
                }
            }
        }
        if (HitPointType.isLevelXingHitType(type) && conn instanceof LevelXing) {
            LevelXing lx = (LevelXing)conn;
            switch (type) {
                case LEVEL_XING_A: {
                    result = lx.getBeanReferences("A");
                    break;
                }
                case LEVEL_XING_B: {
                    result = lx.getBeanReferences("B");
                    break;
                }
                case LEVEL_XING_C: {
                    result = lx.getBeanReferences("C");
                    break;
                }
                case LEVEL_XING_D: {
                    result = lx.getBeanReferences("D");
                    break;
                }
                default: {
                    log.error("Unexpected HitPointType: {}", (Object)type);
                }
            }
        }
        if (HitPointType.isSlipHitType(type) && conn instanceof LayoutSlip) {
            LayoutSlip ls = (LayoutSlip)conn;
            switch (type) {
                case SLIP_A: {
                    result = ls.getBeanReferences("A");
                    break;
                }
                case SLIP_B: {
                    result = ls.getBeanReferences("B");
                    break;
                }
                case SLIP_C: {
                    result = ls.getBeanReferences("C");
                    break;
                }
                case SLIP_D: {
                    result = ls.getBeanReferences("D");
                    break;
                }
                default: {
                    log.error("Unexpected HitPointType: {}", (Object)type);
                }
            }
        }
        return result;
    }

    public void remove() {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void reCheckBlockBoundary() {
        log.info("reCheckBlockBoundary is temporary, but was invoked", (Throwable)new Exception("traceback"));
    }

    @Override
    protected List<LayoutConnectivity> getLayoutConnectivity() {
        ArrayList<LayoutConnectivity> results = new ArrayList<LayoutConnectivity>();
        LayoutConnectivity lc = null;
        LayoutBlock lb1 = this.getLayoutBlock();
        LayoutBlock lb2 = null;
        if (lb1 != null) {
            LayoutSlip ls;
            LevelXing lx;
            LayoutTurnout lt;
            if (HitPointType.isTurnoutHitType(this.type1)) {
                lt = (LayoutTurnout)this.getConnect1();
                lb2 = lt.getLayoutBlock();
                if (lt.hasEnteringDoubleTrack()) {
                    if (this.type1 == HitPointType.TURNOUT_B && lt.getLayoutBlockB() != null) {
                        lb2 = lt.getLayoutBlockB();
                    }
                    if (this.type1 == HitPointType.TURNOUT_C && lt.getLayoutBlockC() != null) {
                        lb2 = lt.getLayoutBlockC();
                    }
                    if (this.type1 == HitPointType.TURNOUT_D && lt.getLayoutBlockD() != null) {
                        lb2 = lt.getLayoutBlockD();
                    }
                }
                if (lb2 != null && lb1 != lb2) {
                    log.debug("Block boundary  (''{}''<->''{}'') found at {}", new Object[]{lb1, lb2, this});
                    lc = new LayoutConnectivity(lb1, lb2);
                    lc.setConnections(this, lt, this.type1, null);
                    lc.setDirection(this.models.computeDirection(this.getConnect2(), this.type2, this.getConnect1(), this.type1));
                    results.add(lc);
                }
            } else if (HitPointType.isLevelXingHitType(this.type1)) {
                lx = (LevelXing)this.getConnect1();
                lb2 = this.type1 == HitPointType.LEVEL_XING_A || this.type1 == HitPointType.LEVEL_XING_C ? lx.getLayoutBlockAC() : lx.getLayoutBlockBD();
                if (lb2 != null && lb1 != lb2) {
                    log.debug("Block boundary  (''{}''<->''{}'') found at {}", new Object[]{lb1, lb2, this});
                    lc = new LayoutConnectivity(lb1, lb2);
                    lc.setConnections(this, lx, this.type1, null);
                    lc.setDirection(this.models.computeDirection(this.getConnect2(), this.type2, this.getConnect1(), this.type1));
                    results.add(lc);
                }
            } else if (HitPointType.isSlipHitType(this.type1) && (lb2 = (ls = (LayoutSlip)this.getConnect1()).getLayoutBlock()) != null && lb1 != lb2) {
                log.debug("Block boundary  (''{}''<->''{}'') found at {}", new Object[]{lb1, lb2, this});
                lc = new LayoutConnectivity(lb1, lb2);
                lc.setConnections(this, ls, this.type1, null);
                lc.setDirection(this.models.computeDirection(this.getConnect2(), this.type2, this.getConnect1(), this.type1));
                results.add(lc);
            }
            if (HitPointType.isTurnoutHitType(this.type2)) {
                lt = (LayoutTurnout)this.getConnect2();
                lb2 = lt.getLayoutBlock();
                if (lt.hasEnteringDoubleTrack()) {
                    if (this.type2 == HitPointType.TURNOUT_B && lt.getLayoutBlockB() != null) {
                        lb2 = lt.getLayoutBlockB();
                    }
                    if (this.type2 == HitPointType.TURNOUT_C && lt.getLayoutBlockC() != null) {
                        lb2 = lt.getLayoutBlockC();
                    }
                    if (this.type2 == HitPointType.TURNOUT_D && lt.getLayoutBlockD() != null) {
                        lb2 = lt.getLayoutBlockD();
                    }
                }
                if (lb2 != null && lb1 != lb2) {
                    log.debug("Block boundary  (''{}''<->''{}'') found at {}", new Object[]{lb1, lb2, this});
                    lc = new LayoutConnectivity(lb1, lb2);
                    lc.setConnections(this, lt, this.type2, null);
                    lc.setDirection(this.models.computeDirection(this.getConnect1(), this.type1, this.getConnect2(), this.type2));
                    results.add(lc);
                }
            } else if (HitPointType.isLevelXingHitType(this.type2)) {
                lx = (LevelXing)this.getConnect2();
                lb2 = this.type2 == HitPointType.LEVEL_XING_A || this.type2 == HitPointType.LEVEL_XING_C ? lx.getLayoutBlockAC() : lx.getLayoutBlockBD();
                if (lb2 != null && lb1 != lb2) {
                    log.debug("Block boundary  (''{}''<->''{}'') found at {}", new Object[]{lb1, lb2, this});
                    lc = new LayoutConnectivity(lb1, lb2);
                    lc.setConnections(this, lx, this.type2, null);
                    lc.setDirection(this.models.computeDirection(this.getConnect1(), this.type1, this.getConnect2(), this.type2));
                    results.add(lc);
                }
            } else if (HitPointType.isSlipHitType(this.type2) && (lb2 = (ls = (LayoutSlip)this.getConnect2()).getLayoutBlock()) != null && lb1 != lb2) {
                log.debug("Block boundary  (''{}''<->''{}'') found at {}", new Object[]{lb1, lb2, this});
                lc = new LayoutConnectivity(lb1, lb2);
                lc.setConnections(this, ls, this.type2, null);
                lc.setDirection(this.models.computeDirection(this.getConnect1(), this.type1, this.getConnect2(), this.type2));
                results.add(lc);
            }
        }
        return results;
    }

    @Override
    public List<HitPointType> checkForFreeConnections() {
        return new ArrayList<HitPointType>();
    }

    @Override
    public boolean checkForUnAssignedBlocks() {
        return this.getLayoutBlock() != null;
    }

    @Override
    public void checkForNonContiguousBlocks(@Nonnull HashMap<String, List<Set<String>>> blockNamesToTrackNameSetsMap) {
        List<Set<String>> TrackNameSets = null;
        LinkedHashSet<String> TrackNameSet = null;
        String blockName = this.getBlockName();
        if (!blockName.isEmpty()) {
            TrackNameSets = blockNamesToTrackNameSetsMap.get(blockName);
            if (TrackNameSets != null) {
                for (Set<String> checkTrackNameSet : TrackNameSets) {
                    if (!checkTrackNameSet.contains(this.getName())) continue;
                    TrackNameSet = checkTrackNameSet;
                    break;
                }
            } else {
                log.debug("*New block (''{}'') trackNameSets", (Object)blockName);
                TrackNameSets = new ArrayList<Set<String>>();
                blockNamesToTrackNameSetsMap.put(blockName, TrackNameSets);
            }
            if (TrackNameSet == null) {
                TrackNameSet = new LinkedHashSet<String>();
                TrackNameSets.add(TrackNameSet);
            }
            if (TrackNameSet.add(this.getName())) {
                log.debug("*    Add track ''{}'' to TrackNameSets for block ''{}''", (Object)this.getName(), (Object)blockName);
            }
            if (this.connect1 != null) {
                this.connect1.collectContiguousTracksNamesInBlockNamed(blockName, TrackNameSet);
            }
            if (this.connect2 != null) {
                this.connect2.collectContiguousTracksNamesInBlockNamed(blockName, TrackNameSet);
            }
        }
    }

    @Override
    public void collectContiguousTracksNamesInBlockNamed(@Nonnull String blockName, @Nonnull Set<String> TrackNameSet) {
        if (!TrackNameSet.contains(this.getName()) && this.getBlockName().equals(blockName)) {
            if (TrackNameSet.add(this.getName())) {
                log.debug("*    Add track ''{}''for block ''{}''", (Object)this.getName(), (Object)blockName);
            }
            if (this.connect1 != null) {
                this.connect1.collectContiguousTracksNamesInBlockNamed(blockName, TrackNameSet);
            }
            if (this.connect2 != null) {
                this.connect2.collectContiguousTracksNamesInBlockNamed(blockName, TrackNameSet);
            }
        }
    }

    @Override
    public void setAllLayoutBlocks(LayoutBlock layoutBlock) {
        this.setLayoutBlock(layoutBlock);
    }
}

